/*******************************************************************************
* Copyright 2023-2025 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include <cstdint>
#include <vector>

namespace dnnl {
namespace impl {
namespace gpu {
namespace intel {
namespace conv {
namespace jit {

// clang-format off
static const uint64_t _data[] = {
        0x000000133e4ccccd, 0x0000000100000000, 0x4000000000000000, 0x0000000000000051, 0x3ce000003ca80000, 0x3d1a00003d050000, 0x3d5000003d280000, 0x3d7c00003d600000,
        0x3d8c00003d800000, 0x3da000003d900000, 0x3dc000003da80000, 0x3dd800003dd00000, 0x3df000003de00000, 0x3e0000003dfc0000, 0x3e1000003e0c0000, 0x3e2000003e180000,
        0x3e3400003e280000, 0x3e4600003e400000, 0x3e5800003e500000, 0x3e6a00003e600000, 0x3e7c00003e700000, 0x3e8500003e800000, 0x3e8c00003e8a0000, 0x3e9600003e900000,
        0x3ea000003e9c0000, 0x3eaf00003ea80000, 0x3ebb80003eb40000, 0x3ec600003ec00000, 0x3ed200003ecf0000, 0x3ee000003ed80000, 0x3eee00003ee10000, 0x3efc00003ef00000,
        0x3f0400003f000000, 0x3f0c00003f070000, 0x3f1300003f100000, 0x3f1c00003f184000, 0x3f2500003f200000, 0x3f2d40003f280000, 0x3f39a0003f340000, 0x3f4000003f3d0000,
        0x3f4f00003f480000, 0x3f5800003f534000, 0x3f6400003f600000, 0x3f7c00003f700000, 0x000000023f800000, 0x0000000000000000, 0x000000273f800000, 0x3da0000000000000,
        0x3e0000003de00000, 0x3e2800003e200000, 0x3e6000003e400000, 0x3e8000003e700000, 0x3e9000003e8c0000, 0x3ea000003e9c0000, 0x3eb600003ea80000, 0x3ed000003ec00000,
        0x3ee000003ed80000, 0x3efc00003ef00000, 0x3f0700003f000000, 0x3f1000003f0c0000, 0x3f1c00003f160000, 0x3f2800003f200000, 0x3f4000003f340000, 0x3f5000003f480000,
        0x3f6000003f580000, 0x3f7000003f640000, 0x3f8000003f7c0000, 0x00000000000000b8, 0x49870000497c0000, 0x49900000498dc000, 0x49a2000049992000, 0x49af000049a80000,
        0x49bd000049b64000, 0x49d2000049c58800, 0x49e5b00049dc8000, 0x49fc000049f30000, 0x4a0700004a034000, 0x4a1000004a0dc000, 0x4a1c30004a190000, 0x4a2560004a220000,
        0x4a2f00004a2b8000, 0x4a3d00004a340000, 0x4a5200004a421000, 0x4a5c80004a580000, 0x4a7000004a65b000, 0x4a7c00004a781000, 0x4a89d0004a834000, 0x4a9000004a8dc000,
        0x4a9920004a95a000, 0x4aa050004a9c4000, 0x4aa560004aa20000, 0x4aac44004aa8c000, 0x4ab400004aaf8000, 0x4abd00004aba0c00, 0x4aca80004ac06000, 0x4ad800004ad2f000,
        0x4ae3d0004adc8000, 0x4af300004aea0000, 0x4afc00004af81000, 0x4b0340004aff3c00, 0x4b0c00004b070000, 0x4b1000004b0dc000, 0x4b15a0004b13a800, 0x4b1c00004b18ee00,
        0x4b2200004b1e3400, 0x4b28c0004b256000, 0x4b37c0004b2f8000, 0x4b4000004b3d0000, 0x4b4eb8004b48d000, 0x4b5800004b52f000, 0x4b6580004b5ec000, 0x4b7810004b700000,
        0x4b8040004b7c0000, 0x4b87f0004b84e400, 0x4b9000004b8dc000, 0x4b97e0004b948000, 0x4ba200004b9b6400, 0x4baa04004ba56000, 0x4bb6d0004baf8000, 0x4bc210004bbd0000,
        0x4bd7a0004bca8000, 0x4bdc80004bd80000, 0x4bf300004be48400, 0x4bfe4c004bf81000, 0x4c0b38004c059800, 0x4c1000004c0dc000, 0x4c1b40004c148000, 0x4c28c0004c220000,
        0x4c3400004c2f8000, 0x4c4600004c3d0000, 0x4c5800004c4c3000, 0x4c65b0004c5c8000, 0x4c83a0004c74e600, 0x4c9000004c8f7000, 0x4ca710004c97e000, 0x4cb94d804caf0000,
        0x4ccdaa004cc00000, 0x4ce580004cdc8000, 0x4cfc00004ced4e00, 0x4d07f0004d059800, 0x4d1000004d0dc000, 0x4d1d80004d148000, 0x4d2ea8004d28c000, 0x4d3b80004d340000,
        0x4d4a26004d43c000, 0x4d5f20004d52f000, 0x4d7300004d666580, 0x4d8700004d7c0000, 0x4d9c00004d8dc000, 0x4db640004da48800, 0x4dca80004dbf6800, 0x4df300004ddf2000,
        0x4e0c00004e028000, 0x4e28c0004e192400, 0x4e3e20004e2ea800, 0x4e6100004e52f000, 0x4e9000004e730000, 0x4ed5c0004eb7c000, 0x4f1a3f804ef30000, 0x4f8ca0004f45c100,
        0x0000000000000096, 0x4210000041900000, 0x4260000042500000, 0x4290000042800000, 0x42a8000042a00000, 0x42d8000042c00000, 0x42f0000042e00000, 0x430c000043000000,
        0x431c000043100000, 0x4328000043200000, 0x4340000043360000, 0x43520000434f0000, 0x4360000043580000, 0x437c000043700000, 0x4387000043800000, 0x43900000438c0000,
        0x439c000043960000, 0x43a8000043a00000, 0x43c0000043b40000, 0x43cf000043c80000, 0x43d8000043d20000, 0x43e4000043e00000, 0x43fc000043f00000, 0x4405000044000000,
        0x440c00004409c000, 0x4416000044100000, 0x44200000441c0000, 0x442f000044280000, 0x443b800044340000, 0x4444000044400000, 0x44500000444a8000, 0x4460000044580000,
        0x4470000044638000, 0x44800000447c0000, 0x4489800044840000, 0x44900000448c0000, 0x4499000044948000, 0x44a6400044a00000, 0x44af000044a80000, 0x44bb800044b40000,
        0x44c6000044c00000, 0x44d8000044d00000, 0x44e4000044e00000, 0x44fc000044f00000, 0x4506100045000000, 0x450c000045088000, 0x4513000045100000, 0x45200000451c0000,
        0x4532800045280000, 0x453b800045360000, 0x454a800045400000, 0x456000004555c000, 0x457c000045700000, 0x4587000045800000, 0x45900000458c0000, 0x45a0000045960000,
        0x45b5200045a8c000, 0x45c0000045bb8000, 0x45dc800045cf0000, 0x45f3c00045e00000, 0x4600000045ff0000, 0x46100000460c0000, 0x46248800461d8000, 0x4640000046340000,
        0x466000004655c000, 0x46844000467c0000, 0x46a0000046900000, 0x46c4000046b58000, 0x46f2800046dc8000, 0x4710000047028200, 0x47400000472eae00, 0x4780000047580000,
        0x47b9a00047930000, 0x4805980047d80000, 0x486d800048322000, 0x496a600048b58000, 0x000000000000000f, 0x414000003f800000, 0x4210000041c00000, 0x4290000042400000,
        0x4310000042c00000, 0x4390000043400000, 0x4410000043c00000, 0x44d8000044800000, 0x0000000445900000, 0x3f80000000000000, 0x4080000040000000, 0x0000000141000000,
        0x3f80000000000000, 0x0000000000000001, 0x000000033f800000, 0x4180000000000000, 0x4280000042000000, 0x000000000000000c, 0x40c000003f800000, 0x4100000040e00000,
        0x4120000041100000, 0x4140000041300000, 0x4160000041500000, 0x4180000041700000, 0x0000000000000001, 0x000000083f800000, 0x3f80000000000000, 0x40a0000040400000,
        0x4100000040c00000, 0x4140000041100000, 0x0000001f41800000, 0x3f80000000000000, 0x4080000040400000, 0x40c0000040a00000, 0x4100000040e00000, 0x4130000041100000,
        0x4170000041400000, 0x4188000041800000, 0x41c0000041a80000, 0x41f8000041c80000, 0x421c000042040000, 0x424c000042400000, 0x4290000042800000, 0x42c0000042ae0000,
        0x42f6000042e60000, 0x43c0000043400000, 0x45c0000044580000, 0x0000000000000001, 0x0000000100000000, 0x0000000000000000, 0x0000000000000003, 0x400000003f800000,
        0x0000000340400000, 0x3f80000000000000, 0x4040000040000000, 0x000000323cc39240, 0x0000001300000000, 0x000003e800000005, 0x0000023c00000001, 0x0120011200000000,
        0x0050330400946604, 0x0022010e00301c04, 0xbdd5ceff001d1204, 0x0a01bcba8ce9ffbc, 0xffbcc097d0ff002b, 0x0042010ebcbe513e, 0xb7dc74ff003d0011, 0x0011bcb2b173ffbc,
        0xffbcbd15aeff004b, 0x00744d04bcb8743e, 0x006100110066010e, 0xeb1dffbcb29141ff, 0xd1ff006f0011bca6, 0xbcb11917ffbcb8b6, 0x0081000d00860011, 0x0851ffbcb2985cff,
        0x7aff008f030ebcaa, 0xbca683d1ffbc976a, 0x00bc001100dc8304, 0x00a97b0400ae000d, 0xfa08ffbcaceb0bff, 0x47ff00b7020dbca4, 0xbc980012ffbca093, 0x00c9760400ce030e,
        0x1bafffbc85f8fcff, 0xd1ff00d73501bc67, 0xbc90b735ffbca30b, 0x00f2130e01000011, 0x99b20cff00ed010d, 0x010abc8b8547ffbc, 0xffbcaf637fff00fb, 0x0112020dbcb3cc91,
        0x5d568fff010d100e, 0x4c01bc88910bffbc, 0xffbc79523aff011b, 0x01b03c05bc1e0995, 0x014c1601016c0207, 0x01391a04013e030e, 0x8d3fffbb116934ff, 0x8bff014710043c8b,
        0xbbfc36a0ffbc7cce, 0x01592505015e0107, 0x75c3ff3c07d14fff, 0x40ff01674f043cb3, 0x3da6b153ff3cddb6, 0x01822d0401904e04, 0x5db35eff017d030e, 0x000dbbaa1430ff3c,
        0xff3c965374ff018b, 0x01a2000d3d619167, 0x894070ff019d0e03, 0x77043d640173ff3c, 0xff3df14131ff01ab, 0x01f8010d3e6c7d80, 0x01ca440401d86204, 0xb54fc8ff01c52e04,
        0x010e3ccf47a5ff3b, 0xff3d8203deff01d3, 0x01ea000d3d0714ed, 0x70f2aeff01e5000a, 0xa6043db5f305ff3d, 0xff3df72cf7ff01f3, 0x021c70043d770dde, 0x02094804020e5504,
        0x35a1ff3d327c8bff, 0xf8ff021700073d97, 0x3e087452ff3dc782, 0x02298104022eb304, 0xce9dff3e402eaeff, 0x6cff0237b5043e7c, 0x3dff568aff3e36cb, 0x0000000500000013,
        0x00000001000003e8, 0x000000000000023c, 0x00946f0401200112, 0x0030240400503a04, 0x001d0c0100221304, 0xcb66ffbc99c6f3ff, 0x03ff002b010ebc97, 0xbc976a00ffbc9415,
        0x003d00110042010e, 0x7dd3ffbc91cc27ff, 0x74ff004b070ebc8c, 0xbc98d1e0ffbc924f, 0x0066010e00745604, 0x8d1361ff00610011, 0x070ebc821bffffbc, 0xffbc8c1c28ff006f,
        0x00860011bc95a19a, 0x8d3fe3ff0081000d, 0x030ebc858b87ffbc, 0xffbc67039cff008f, 0x00dc0011bc80c12d, 0x00ae930400bc010d, 0x825a6fff00a9130e, 0x000abc8e7251ffbc,
        0xffbc7f5ac5ff00b7, 0x00ce8f04bc602ca6, 0x68c286ff00c9010e, 0x040bbc7832e9ffbc, 0xffbc560b2dff00d7, 0x0100010dbc45df23, 0x00ed2b0100f24201, 0xef52ffbc89167fff,
        0x48ff00fb8e04bc6a, 0xbc34ace4ffbc5665, 0x010d420101124c01, 0xdbffffbc62b144ff, 0xfbff011b8504bc3e, 0xbbfc6d1fffbc2a79, 0x016c280501b05105, 0x013e1301014c0207,
        0x7fda66ff0139030e, 0x0107bc200a5eff39, 0xff3be1d52fff0147, 0x015e4c043ca9b5bb, 0x059f9eff01592604, 0x000d3ccca4d0ffba, 0xff3cf80f0dff0167, 0x019049043de90528,
        0x017d26040182000d, 0x6ee7ffbc0b8d6eff, 0x51ff018b28043c20, 0x3d1a0303ff3c0499, 0x019d080601a20007, 0xb4eeff3ccb6059ff, 0x46ff01ab010dbc40, 0x3e0553c5ff3d5ed4,
        0x01d86d0401f8010d, 0x01c5000d01ca5204, 0x9c94ff3c1c44d3ff, 0x63ff01d3000d3cf7, 0x3d6b4d6fff3d0505, 0x01e5000d01eaaf04, 0xd1b0ff3d8c5abeff, 0xd9ff01f3070e3dc3,
        0x3dfd846aff3ceea3, 0x020e6504021c7804, 0x2ee2dcff02095704, 0x020d3d9c9c13ff3d, 0xff3da9ee5eff0217, 0x022eb1043e035c64, 0x24ffb3ff02290007, 0x8b053e584306ff3e,
        0xff3e28f1ccff0237, 0x000000133de14e25, 0x000003e800000005, 0x0000023c00000001, 0x0120011200000000, 0x00503f0400946604, 0x0022140100301e04, 0x78115fff001d0301,
        0x0012bc73f8d7ffbc, 0xffbc730219ff002b, 0x00421f01bc6c5b4d, 0x69f7c4ff003d030e, 0x0011bc7181e4ffbc, 0xffbc6b9759ff004b, 0x0074000dbc5e58d0, 0x0061560400660011,
        0x6f5cffbc6b6c1fff, 0xd9ff006f2a01bc63, 0xbc4f530bffbc6842, 0x0081570400860011, 0x2587ffbc5fe1f1ff, 0x31ff008f2a01bc57, 0xbc40c947ffbc5980, 0x00bc001100dc8204,
        0x00a9070e00ae000d, 0x18b8ffbc585e11ff, 0xbfff00b77104bc66, 0xbc456ba1ffbc51c4, 0x00c9790400ce050e, 0x3cd2ffbc28e5f0ff, 0x9fff00d70c0ebc11, 0xbc54a035ffbc38b4,
        0x00f200110100010d, 0x4f1359ff00ed000a, 0x3601bc3d19f8ffbc, 0xffbc560c7cff00fb, 0x01120011bc14fb2b, 0x2c9468ff010d030e, 0x8f05bc467daaffbc, 0xffbbcd8613ff011b,
        0x01b05105bc09ac4e, 0x014c1f04016c2805, 0x01391904013e000d, 0xc1a9ffbc317131ff, 0x94ff01471004bbb6, 0x3ba13b8dffbbb314, 0x0159020e015e0007, 0xef49ffbc3018bbff,
        0x44ff0167000d3bd3, 0x3d326a58ff3bcc42, 0x0182000d01904904, 0x9bca7dff017d2e04, 0x36043c1fe2e2ffbb, 0xff3c48c545ff018b, 0x01a201073d16f9a9, 0x816db0ff019d0007,
        0x010d3d35ad0eff3c, 0xff3d464a65ff01ab, 0x01f8010d3dfebf4e, 0x01ca500401d86f04, 0xd0a942ff01c5000d, 0x000d3cb47108ff3b, 0xff3cd14c4aff01d3, 0x01eaa6043d3fc1a9,
        0x78af32ff01e59e04, 0x070e3dde462aff3d, 0xff3d067fb0ff01f3, 0x021c7c043de0282e, 0x02094a04020e6204, 0xc446ff3caedfc7ff, 0x58ff021700073d53, 0x3de46b56ff3da21c,
        0x0229020d022eb104, 0xc613ff3dfdc8b3ff, 0xa5ff0237010e3e31, 0x3e1348e3ff3db6e5, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094660401200112,
        0x0030200400503704, 0x001d010e00220e04, 0x05e6ffbc42e06cff, 0x7bff002b010ebc46, 0xbc42d744ffbc3e7d, 0x003d070e00421501, 0x615bffbc3ed427ff, 0x47ff004b0011bc46,
        0xbc34bca9ffbc3e05, 0x0066070e00742101, 0x3ea3b6ff00611501, 0x1101bc34b21cffbc, 0xffbc47eba7ff006f, 0x00860011bc4059cd, 0x39247fff0081000d, 0x020dbc30efbbffbc,
        0xffbc271d2cff008f, 0x00dc8704bc15127c, 0x00ae000d00bc0011, 0x35af33ff00a9000a, 0x7904bc2a057fffbc, 0xffbc24b5b7ff00b7, 0x00ce020dbc1ac427, 0x289b5eff00c93b01,
        0x4601bc0f4d63ffbc, 0xffbc0e70f7ff00d7, 0x0100010dbbdbcf15, 0x00ed0f0e00f20011, 0xff8dffbc1ade58ff, 0x26ff00fb8c05bc34, 0xbc10b67cffbbe6c1, 0x010d030e01120011,
        0x98c0ffbc07781bff, 0x2fff011b9304bc1b, 0xbb95a2c3ffbbca93, 0x016c020701b04c05, 0x013e2b05014c0107, 0x0982a1ff01394901, 0x000d3bbc8c08ffbb, 0xff3b368d8bff0147,
        0x015e42043ca97206, 0x0cb27eff01592d04, 0x000d3c8e6fdaffbb, 0xff3c77c098ff0167, 0x019064043d8931de, 0x017d030e01823704, 0x108bff3c13515fff, 0x78ff018b020dbb66,
        0x3d85d79fff3cb4a4, 0x019d000d01a2010d, 0x3a80ff3d106851ff, 0xe5ff01ab030e3d9f, 0x3e43693dff3deeea, 0x01d8710401f8020d, 0x01c5370401ca4e04, 0x2de8ff3b0346b2ff,
        0x26ff01d3000d3c78, 0x3d1be855ff3ca217, 0x01e58b0501ea010d, 0x966fff3d651a17ff, 0x8eff01f3030b3cc7, 0x3df9df43ff3dac23, 0x020e5c04021c7004, 0xfea8e9ff02094e04,
        0x00073d30f04dff3c, 0xff3d69fbe3ff0217, 0x022e8f053d9fc896, 0xcc5934ff02298404, 0xb4043e1373e6ff3d, 0xff3da4cf27ff0237, 0x000000133d640d5e, 0x000003e800000005,
        0x0000023c00000001, 0x0120011200000000, 0x0050490400946604, 0x00220c0100302904, 0x1cc745ff001d070e, 0x0011bc20d465ffbc, 0xffbc1c0ba0ff002b, 0x0042010ebc169cf1,
        0x114307ff003d0107, 0x0011bc0853ddffbc, 0xffbc1a5a0fff004b, 0x0074070ebc12cf23, 0x0061020d00660011, 0x57c4ffbc0f7ff4ff, 0x50ff006f3001bc07, 0xbbf331cbffbc093e,
        0x00810c0100861901, 0x4bc2ffbc2463daff, 0x7bff008f0011bc1d, 0xbc120cf1ffbc1a15, 0x00bc000d00dc9004, 0x00a9140e00ae0a0b, 0x148dffbc0714b0ff, 0xf1ff00b73c01bc1a,
        0xbbe91109ffbc0b3b, 0x00c9020d00ce0011, 0x3ec6ffbc033f6fff, 0x03ff00d74601bbf1, 0xbbbab9aeffbbeb51, 0x00f2000a0100020d, 0xca312fff00ed8905, 0x4701bc06add8ffbb,
        0xffbbf60eb0ff00fb, 0x0112050bbb9d1f09, 0x769cf6ff010d030b, 0x8a05bbc54150ffbb, 0xffbaf47652ff011b, 0x01b03c05bb94862e, 0x014c1801016c0207, 0x01390a04013e030e,
        0x40baffbbfceb5fff, 0xf9ff0147000a3b9d, 0xbba8a9c7ffbc2029, 0x0159020e015e0007, 0xcc70ffbc159eabff, 0xe6ff0167010d3ba4, 0x3d4682e0ff3c210b, 0x0182060301905704,
        0x59eb44ff017d070e, 0x000dbc7eb734ff3a, 0xff3bf3ec7dff018b, 0x01a2010d3cc4fcca, 0xd4276eff019d8d04, 0x87043d8c59eeff3c, 0xff3dab825fff01ab, 0x01f86f043e2b8874,
        0x01ca220401d83c04, 0x1147c1ff01c51704, 0x030ebad51842ffbc, 0xff3c2e6ef9ff01d3, 0x01ea000d3a0b4aec, 0x7e97e2ff01e5070e, 0x6004bbafa72aff3c, 0xff3cdd77c1ff01f3,
        0x021c010d3d2a7ec7, 0x0209000d020e010a, 0xcffbff3cd4239cff, 0xd3ff0217aa043d42, 0x3cf6d05eff3d8518, 0x0229040b022e0007, 0x72faff3d831b24ff, 0x5cff0237b1043db2,
        0x3d7ca18dff3de0e4, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x00947c0401200112, 0x0030180100505204, 0x001d010d00220011, 0x3465ffbc00007aff,
        0x9cff002b0b01bbfb, 0xbbf41b0dffbbfb84, 0x003d020d00420011, 0xaf41ffbbf5ffb4ff, 0x87ff004b3701bbe8, 0xbbd62fd2ffbbe5ce, 0x006600110074020d, 0xe0bf90ff0061070e,
        0x3701bbf6a592ffbb, 0xffbbe4d883ff006f, 0x00860107bbc4aa28, 0xd01e90ff00816004, 0x3201bbb49100ffbb, 0xffbbc8f82fff008f, 0x00dc010dbb9a0672, 0x00ae000a00bc0012,
        0xe867b0ff00a9000d, 0x130ebbca939bffbb, 0xffbbbf857eff00b7, 0x00ce100ebbf4ce1b, 0x868269ff00c98f05, 0x170ebbc8257effbb, 0xffbbbcf52cff00d7, 0x01004c01bc0583b3,
        0x00ed001200f2000a, 0xb76fffbbcd3306ff, 0xc2ff00fb030bbb93, 0xbc0d0e73ffbbafea, 0x010d030b01120011, 0xaf6bffbbbbe138ff, 0xd5ff011b8d05bba0, 0xbb988a7fffbb3ff7,
        0x016c020701b03c05, 0x013e000d014c2604, 0xa9ac47ff01391601, 0x1604bc30d55dffbb, 0xffbb5aee96ff0147, 0x015e00073b83af9b, 0x04f42bff0159010e, 0x000d3b600b3bffbc,
        0xff3b1ad7bfff0167, 0x019066043cf7b49e, 0x017d000d01821205, 0x82e1ffbb821523ff, 0x74ff018b020d3c02, 0x3d4d3567ff3c7010, 0x019d0f0e01a2000d, 0xdf44ff3d244f2fff,
        0x6cff01ab7d04bb21, 0x3def7712ff3d75f5, 0x01d8580401f87e04, 0x01c5000a01ca000d, 0xcb21ff3a016235ff, 0xcfff01d33a043bff, 0x3c9dceebff3bb0b0, 0x01e5000d01ea020d,
        0xc745ff3c4e1268ff, 0x2cff01f301073cf7, 0x3d8d6cfaff3d3f33, 0x020e8405021c010d, 0x18a8b6ff0209000d, 0x8f053d820374ff3d, 0xff3cdaac7dff0217, 0x022e8b053b347cac,
        0x8846d1ff0229020d, 0xb5043dcc66fcff3d, 0xff3d6f04afff0237, 0x000000133cf6a8da, 0x000003e800000005, 0x0000023c00000001, 0x0120011200000000, 0x00505a0400947c04,
        0x0022000d00302b04, 0xcbf8feff001d0011, 0x0107bbc7425dffbb, 0xffbbc5391dff002b, 0x00421b01bbbe6975, 0xc0f234ff003d070e, 0x0011bbcd1a48ffbb, 0xffbbbe8b95ff004b,
        0x0074020dbbae52ff, 0x006100110066080e, 0xc118ffbbb1d661ff, 0xadff006f2501bb9b, 0xbbb5d3feffbbcee9, 0x00814a0100860011, 0x0b3fffbbb7b6c7ff, 0x41ff008f4101bba6,
        0xbb6b1d9fffbb9369, 0x00bc9a0400dc010d, 0x00a9000d00ae0a0b, 0x92a4ffbbb25c8bff, 0x9aff00b70011bb8f, 0xbb74bba5ffbba4c0, 0x00c9040b00ce000a, 0x9760ffbbc879e7ff,
        0x06ff00d70011bb87, 0xbb252621ffbb91c3, 0x00f2070e01009a04, 0x92ca6eff00ed0011, 0x3401bb41b005ffbb, 0xffbbd978b6ff00fb, 0x01128a05bb90c22b, 0x0e9d91ff010d050b,
        0x000aba2e5abaffbb, 0xffbb89a8fcff011b, 0x01b03c05bad3ff61, 0x014c1e01016c0207, 0x01392a04013e030e, 0x75f2ff380ad82fff, 0x2bff0147070e3c61, 0xbbee5a33ffbb4dd8,
        0x0159040e015e020b, 0x0156ffbb4dc0ccff, 0x9bff016787043b86, 0x3dac6acfff3c3bdf, 0x0182360401905704, 0x95e4d5ff017d0303, 0x000d3b3c4319ffbb, 0xff3b823b08ff018b,
        0x01a2010d3c9d6da6, 0x46e9adff019d000d, 0x78043d127c70ff3c, 0xff3d56c133ff01ab, 0x01f87f043dccac6e, 0x01ca360401d84d04, 0xe15c7eff01c51b04, 0x010e3b11a28effbb,
        0xff3c59a555ff01d3, 0x01ea000d3b9a1e41, 0x46ab76ff01e5070e, 0x020dbbe0e419ff3c, 0xff3cb83dfcff01f3, 0x021c020d3d232a76, 0x0209130e020e7e05, 0x3b11ff3d3acb77ff,
        0x99ff0217a604bc8a, 0x3c111da3ff3d0119, 0x0229040b022e8905, 0x154eff3d92fdfeff, 0xc5ff0237b5043dfb, 0x3cc15f08ff3d510d, 0x0000000500000013, 0x00000001000003e8,
        0x000000000000023c, 0x0094720401200112, 0x00302d0400504304, 0x001d001100220604, 0x5466ffbba5a840ff, 0x65ff002b1101bba3, 0xbb9b2155ffbba06e, 0x003d000700420107,
        0xdabdffbb9e3f04ff, 0x12ff004b2b01bb96, 0xbb87703effbb9828, 0x0066070e0074020d, 0x93fdb1ff00610007, 0x000abb85bef5ffbb, 0xffbb9a2d13ff006f, 0x00863201bba46765,
        0xa30feaff00811701, 0x0007bb867f65ffbb, 0xffbb899bd5ff008f, 0x00dc0011bb516545, 0x00ae000d00bc000a, 0xa8f04bff00a9050b, 0x020dbb95e150ffbb, 0xffbb85e20aff00b7,
        0x00ce4601bb72a9a7, 0xa7d0cdff00c92b01, 0x050bbb940bfbffbb, 0xffbb853ab4ff00d7, 0x01008705bb62866c, 0x00ed060e00f2a004, 0xbe37ffbb253c3cff, 0x41ff00fb0f0ebb68,
        0xbb295c5bffba5b48, 0x010d010e0112000a, 0xed73ffbb4287a4ff, 0xfcff011b010dbb9e, 0xbaae2fbdffbb3fcd, 0x016c020701b03c05, 0x013e0e04014c2a04, 0x95469aff01391501,
        0x000dbc37cc89ffbb, 0xffbb6d2ad3ff0147, 0x015e26053b12269d, 0x4e2d97ff01591b0e, 0x000dbb730ab8ff3b, 0xff3ac823abff0167, 0x019070043c8194d4, 0x017d070e0182020d,
        0x9b8bff3be215ceff, 0xd8ff018b5c04bc3d, 0x3d4c5383ff3c9314, 0x019d870401a2130e, 0x6dd4ff3d24f512ff, 0x15ff01ab8e043da0, 0x3c651eabffbc301d, 0x01d8320401f86204,
        0x01c5120401ca1f04, 0x54baffbbf82e57ff, 0xd1ff01d35205bb40, 0xbb6b0a31ff3b75ac, 0x01e5570501ea030e, 0x6938ff3c7a34f5ff, 0x8aff01f3070e3bd9, 0xbbf8fe79ff3bbf42,
        0x020e000a021c000d, 0xdc5d81ff0209070b, 0x3d013c9e0c26ffbb, 0xffbbb82179ff0217, 0x022e020d3cc3dc78, 0xd4d4a0ff0229030e, 0x00073dabeeb1ff3c, 0xff3d0174a5ff0237,
        0x000000133d67a221, 0x000003e800000005, 0x0000023c00000001, 0x0120011100000000, 0x0050560400948f04, 0x0022001100302301, 0x843e05ff001d1601, 0x020dbb810af3ffbb,
        0xffbb7d296dff002b, 0x00420011bb6c7d26, 0x7d8a13ff003d010d, 0x000ebb6790e5ffbb, 0xffbb160b9dff004b, 0x00740011bb613d2a, 0x00610f0e00668205, 0x52a1ffbb5f717eff,
        0x97ff006f8805bb81, 0xbb9bd4ecffbb8656, 0x0081010700860b0e, 0x5d9cffbb420e7cff, 0x33ff008f2801bb1e, 0xbb59e1e9ffbb8e7b, 0x00bc010a00dc000d, 0x00a9000a00ae050b,
        0x7ae7ffbb993a31ff, 0x59ff00b7000abb77, 0xbb0c28f2ffbb5021, 0x00c9000700ce0f0e, 0x69f1ffbb138951ff, 0xccff00d73001b9ed, 0xbb0bf3a2ffbb9174, 0x00f2b50401000012,
        0x44de25ff00ed0011, 0x010dbacf925cffbb, 0xffbb6a692fff00fb, 0x01128b05bba2c6e9, 0x6d1280ff010d4c01, 0x0002ba8ec1cbffbb, 0xffbb3b22f6ff011b, 0x01b02705bac3c7bf,
        0x014c4901016c1805, 0x01393604013e070e, 0x5f66ffbafde1e5ff, 0xefff01478a043c15, 0xbb8e3285ffbbef3c, 0x01590c06015e010e, 0x6ed3ffb9c2c2ebff, 0x8eff0167000abc52,
        0x3b94a023ffb9ecb8, 0x0182000d01903604, 0xbf6249ff017d1a01, 0x1904bbf26d5cffba, 0xff398c1946ff018b, 0x01a200073bc1198e, 0x67c412ff019d000a, 0x010d3c174678ffbb,
        0xff3c2b3e27ff01ab, 0x01f801073d2209a6, 0x01ca390401d86704, 0x98182fff01c51c04, 0x020d3b045881ffbb, 0xff3bca7bdcff01d3, 0x01ea010b3c8d587c, 0xc45d94ff01e50906,
        0x8f05bcb0d4beff3a, 0xff3cb461bcff01f3, 0x021c020d3b01ebcf, 0x0209010e020e7104, 0x9b62ff3c5cc0a0ff, 0xc1ff021780053b47, 0x3b253aecff3cdde6, 0x0229020b022e040b,
        0x4707ff3cdf1020ff, 0x55ff023780043d46, 0x3dddce2fff3d5638, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094900401200111, 0x0030170100503001,
        0x001d00110022070e, 0xef40ffbb522502ff, 0xa1ff002b7404bb49, 0xbb95f3b7ffbb58ec, 0x003d00110042070e, 0xef08ffbb4c14afff, 0x93ff004b8504bb3a, 0xbb6bf152ffbb4b17,
        0x0066050b0074020d, 0x463ef9ff0061000a, 0x0011bb288bc6ffbb, 0xffbb39a5fcff006f, 0x00860011bb0a1c57, 0x362d53ff00817604, 0x0007bb1117f8ffbb, 0xffbb1ac74eff008f,
        0x00dc010dbad2c1ff, 0x00aea40400bc8505, 0xf4ebd6ff00a9150e, 0x8005bb4fd1fdffba, 0xffb9ac9ddbff00b7, 0x00ce000abaecc2c9, 0x80c7e4ff00c9040b, 0x070ebb23b552ffbb,
        0xffbb0a0d41ff00d7, 0x0100050bba0beaad, 0x00ed030b00f2050d, 0x68d5ffbaca5605ff, 0x76ff00fb030bbb3b, 0xbb1fdde1ff3a2727, 0x010d000201120007, 0x0b52ffbb11dd8dff,
        0xf7ff011b0002398a, 0x3a7d27baffb9ac57, 0x016c1a0501b02705, 0x013e0601014c2201, 0x949e7cff01390006, 0x030ebc4451e7ffbb, 0xff3ac3bb8fff0147, 0x015e020bbb5cbd46,
        0xb44bc6ff0159020e, 0x000d3ad7bdf9ffbb, 0xff3b2c596dff0167, 0x019002073c8ad939, 0x017d000d01820a06, 0x0babffbad1300fff, 0x5aff018b0b063bdf, 0xbc76f4f8ffbc0285,
        0x019d010d01a28804, 0xfc71ff3bcb3b53ff, 0x92ff01ab000d3ccd, 0x3dac64d8ff3c3562, 0x01d8840401f80107, 0x01c51e0401ca3d04, 0x3a38ffbb6cb9a8ff, 0x3cff01d3070e3b0c,
        0xbc01e60aff3c1194, 0x01e5070601ea010b, 0x8d3eff3af605efff, 0x2dff01f38905bc4e, 0x3c357657ff3ced2a, 0x020e010a021c010d, 0x50fa22ff0209040b, 0x070e3c8d4180ff3b,
        0xff3cc99a2dff0217, 0x022e030e3d7be526, 0x9d68f1ff02297604, 0x4c013d2eec2fff3c, 0xff3e1e06baff0237, 0x000000133d0a9fa7, 0x000003e800000005, 0x0000023c00000001,
        0x0120011200000000, 0x0050270100944601, 0x0022000d00306104, 0x2575ceff001d070e, 0x1804bb2d2d60ffbb, 0xffbb241fd6ff002b, 0x00428404bb18fa76, 0x36d9aeff003d2401,
        0x2001bb0ba016ffbb, 0xffbb7fc243ff004b, 0x00740107bb3a0ddc, 0x00615d0400660007, 0xc1c8ffbb286cc4ff, 0xaaff006f0011bb1a, 0xbb089cccffbb1f02, 0x0081000d00860011,
        0x9801ffbb1b38d0ff, 0xfdff008f010dbb0f, 0xbacef1eeffbb0526, 0x00bc001100dcb704, 0x00a9000a00ae000d, 0x83ddffbb2bb0d7ff, 0xe4ff00b7000abb0c, 0xbade2c27ffbb0b53,
        0x00c9030b00ce020d, 0x2350ffbb06ef51ff, 0xbaff00d7a504ba9a, 0xb9890022ffba9512, 0x00f292050100010a, 0x9414dfff00ed010e, 0x000abac92d1bffb9, 0xffbb268ee5ff00fb,
        0x0112010ebabc6fb5, 0x2ae9ffff010d030b, 0x7f053a6c8528ff3b, 0xff3b1af61cff011b, 0x01b061053a1c3603, 0x014c1905016c4605, 0x01390e0e013e4f01, 0x8e71ffb9889bf6ff,
        0x28ff0147010abb77, 0x3ba415e2ffb94051, 0x0159020d015e3604, 0xabc6ffba6b1e6aff, 0x6dff016700073bf1, 0x3c443dadff3a2073, 0x0182020d01908704, 0x9558a3ff017d0f0e,
        0x6604bcac0249ff3b, 0xff3c2a06efff018b, 0x01a2130e3ccd1049, 0x980fedff019d4c01, 0x190e3cee3c34ff3d, 0xffbcee9ee6ff01ab, 0x01f8000dbc67da5a, 0x01ca040b01d8000a,
        0x5734bfff01c56e04, 0x070ebc5f2376ffbb, 0xff3baf85a5ff01d3, 0x01ea070e3cf3071e, 0x3fbb3bff01e5a604, 0x9904bb90ab24ff3c, 0xff3c96d5f5ff01f3, 0x021caf043d86273e,
        0x02097e04020e9e04, 0x1a1eff3bead9abff, 0x6fff0217a6043c98, 0x3c9c4ee4ff3d50cc, 0x0229010a022e010d, 0x8971ffbc553a48ff, 0x0fff0237b1043bb9, 0x3ba9babeff3d9679,
        0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094900401200111, 0x0030020d00503201, 0x001d650400221a01, 0x7495ffbb054697ff, 0xafff002b8404bb2a,
        0xbb137b48ffbafdda, 0x003d100100427b04, 0x49d0ffbb029d17ff, 0xc4ff004b8904bae3, 0xbbab78c0ffbb25ce, 0x006600070074010d, 0x0e0c9bff00615f04, 0x0011baf22f04ffbb,
        0xffbaeed518ff006f, 0x0086040dbabea4ab, 0xc9ddaaff00810107, 0x030bba8ed188ffba, 0xff38e58dceff008f, 0x00dc070bbb07918a, 0x00ae000d00bc9305, 0x1e8f2eff00a9010a,
        0x4c01ba3774feffbb, 0xffbb225d99ff00b7, 0x00ce000aba6233fe, 0x535e1dff00c9030b, 0x030eba9db413ffbb, 0xffba5dc190ff00d7, 0x0100020dbb24900a, 0x00edb20400f20011,
        0x1694ffbad23a41ff, 0xebff00fb8005bb05, 0xbaaab58fffb98627, 0x010d000201120107, 0xb641ffba82cd4bff, 0x9aff011bb3043a2a, 0xb98d2a14ff3a71d0, 0x016c000a01b0000d,
        0x013e0f0e014c0a0b, 0xdbf4e3ff0139050b, 0x2805ba82a189ffbb, 0xffbb9f4998ff0147, 0x015e8e04bcb9ad21, 0x2f6a44ff01593b01, 0x070e3b898734ffbb, 0xff3c2a2fc9ff0167,
        0x0190a1043d15bae0, 0x017d370101829e04, 0x0916ffba9c7a10ff, 0x82ff018b9f043bd5, 0x3c9d773eff3d553e, 0x019da60401a2070e, 0x7842ff3d2c1c72ff, 0xc2ff01ab030bbb67,
        0x3db08a98ff3d1a54, 0x01d8250501f83405, 0x01c50b0601ca060e, 0xe5c5ff3b00ef03ff, 0xa5ff01d3000bbc02, 0x3d93373bff3ab45f, 0x01e5080601ea0107, 0xebf8ff3b822f13ff,
        0xc7ff01f3030ebc39, 0x3db89c8bff3c20cf, 0x020e0007021c6b04, 0xf8d494ff0209010d, 0x020d3bc6fc81ff39, 0xff3bc17539ff0217, 0x022e00073c8d5f0e, 0x84d176ff02293401,
        0x030e3c0889beff3d, 0xff3c99b645ff0237, 0x000000133d983d66, 0x000003e800000005, 0x0000023c00000001, 0x01207c0500000000, 0x0050a10400940111, 0x0022820400304601,
        0xd5b4cfff001d0007, 0x3801bac0f266ffba, 0xffbb03e018ff002b, 0x0042000dbaabe042, 0xc37d86ff003d010a, 0x7104ba55d9b3ffba, 0xffbaa30d2cff004b, 0x0074af04ba380609,
        0x0061050b00660f0e, 0xc490ffb96a8af2ff, 0x98ff006fa5043a49, 0xb9df470dffbab588, 0x00816d050086b404, 0x64bcff3ba1cb37ff, 0x70ff008fb6043acc, 0x3c432e88ff3c0761,
        0x00bc720500dc0107, 0x00a9360400ae160e, 0x8e23ffba2694ddff, 0x06ff00b705063b5e, 0x3abdb6abffbba477, 0x00c9020d00ce8d04, 0x780effb9d0602bff, 0xcfff00d700073c9f,
        0x3cb90b9bff3d520f, 0x00f28d0401009904, 0xc90edaff00ed020d, 0x000d3c89808eff3a, 0xff3c03fd66ff00fb, 0x0112000d3d0fde76, 0x47dfc5ff010d070e, 0x010d3d2b0bcdff3c,
        0xff3d147dc3ff011b, 0x01b085053d6dc1d5, 0x014ca804016c0111, 0x0139040d013ea104, 0x9bbbffbac3d007ff, 0xbaff0147000d39b1, 0xb954ebd2ffbaa039, 0x01598205015e0207,
        0x295aff3a2dfcc9ff, 0x9eff0167b004b9b5, 0xb964421dffbaf6e3, 0x0182010d01909e04, 0x39c3f8ff017d0207, 0x030bbcedaa73ffb9, 0xff3c80282fff018b, 0x01a202073d3bd01f,
        0xfa2b51ff019d040b, 0x010d3d5d9b38ff3c, 0xffbb23ebf4ff01ab, 0x01f8a6043d20d1a5, 0x01ca000701d89d04, 0x1b0058ff01c59c04, 0x01123c00c80affbb, 0xffbb1af63dff01d3,
        0x01ea0111bc59bdf5, 0x9ef0edff01e5a504, 0x070bbb12dd52ffba, 0xff3c8c56edff01f3, 0x021c91053d44db5c, 0x0209020d020e0207, 0x7f28ffba8d729aff, 0x78ff021701113ba0,
        0xbc79d182ffbacffd, 0x0229010e022ea704, 0xd1e5ffbc992761ff, 0xf7ff0237020dbc35, 0x3a317400ffbb319e, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c,
        0x0094020b01207b05, 0x0030440100504c01, 0x001d000d00220112, 0x8211ffbac00f84ff, 0x43ff002b010eba9f, 0xbb3e6ba2ff39ecec, 0x003dad0400420007, 0xf62dffbb158ef9ff,
        0x10ff004b01113b14, 0x3bf182dbffba8181, 0x00660a060074000a, 0x39ffb7ff0061030d, 0x090e391051c1ffbb, 0xffbc4895caff006f, 0x008698043aedf4b1, 0x280d2eff00814f01,
        0x060eba0eea1eff3b, 0xffb9f0db13ff008f, 0x00dc01113b84c0bb, 0x00ae600400bca104, 0xa6ffa8ff00a90107, 0x0007ba8c584bffba, 0xffba987283ff00b7, 0x00cea804ba3d5e26,
        0x9814fcff00c90d0e, 0xaf04ba1cb96cff39, 0xff3a223f36ff00d7, 0x010094043b240c91, 0x00ed550400f2020d, 0x4b78ffb9328126ff, 0x26ff00fb86043bc9, 0x3d3fc423ff3c2fd7,
        0x010d000d01127605, 0xa889ff3ca48153ff, 0x75ff011b99043d20, 0x3c9e48c5ffbc6862, 0x016c000a01b00112, 0x013e040d014c030b, 0xd76d7fff0139af04, 0x020bbb22d75effba,
        0xffb9915843ff0147, 0x015e000d3b0362ed, 0xccac3dff01590002, 0x0002ba863d58ffba, 0xffba84ce1eff0167, 0x0190000d3927ba80, 0x017db0040182070e, 0x4512ffba47b558ff,
        0x46ff018b0002baad, 0xbaca038fff3a992b, 0x019d080e01a20007, 0x1022ffba238193ff, 0xd2ff01ab010e3aa3, 0x3aafc91bffb7daa1, 0x01d88b0501f8010d, 0x01c5010a01ca9e04,
        0x750fffbb0b488cff, 0xaeff01d3a6043c4e, 0xba35ba0cff3cfea6, 0x01e58f0501ea0007, 0x914eff3bce72c7ff, 0x34ff01f3010ebba6, 0xbb882475ffbc2cff, 0x020e040b021cb104,
        0x803455ff0209af04, 0xa7043d48b522ff3c, 0xff3cfb3c79ff0217, 0x022e010e3dc67d90, 0x4d9f10ff02299105, 0x020d3b4c59e6ffbc, 0xff3caf13dcff0237, 0x000000133d60ee15,
        0x000003e800000005, 0x0000023c00000001, 0x0120870500000000, 0x0050000d00948505, 0x0022a60400308405, 0x85ae37ff001d8305, 0x01123af15299ffba, 0xffb95b5425ff002b,
        0x0042000a3c2534cf, 0xf03c3aff003d0111, 0xae04bc04de5dffba, 0xff3b77f21fff004b, 0x00740112bb0f551a, 0x0061060d00669904, 0xfc9affba5618f4ff, 0x0cff006f050b38ba,
        0x3a03ad5affb9cefa, 0x0081000a0086010b, 0xd44affbb0397c7ff, 0xdbff008fb1043ad4, 0x3b85e073ff3bcdec, 0x00bc030b00dc000a, 0x00a9970400ae0107, 0x127affbb87062dff,
        0x9fff00b701123c4a, 0xbcca61fcffbb4205, 0x00c9011200ce0007, 0x40e0ffba798011ff, 0xe9ff00d701073c8f, 0x3aba4bffffbbf17a, 0x00f2000201009c04, 0x98eef2ff00ed0111,
        0x000dbcc00aafffba, 0xffbc2ed3c0ff00fb, 0x011201123d111e8b, 0x0958b9ff010da704, 0x01073a7e8f7cffba, 0xff3cdd7bd5ff011b, 0x01b0020dbb044120, 0x014c040b016c9d04,
        0x01390112013e000a, 0x733fffbaea8c08ff, 0x0aff01479b04bc0c, 0x3bdf2466ffbb8a23, 0x01590002015e090b, 0x9174ffb9357323ff, 0x0dff01679a043c84, 0xbc03c3caff39199e,
        0x018201110190a404, 0xad2a0eff017d040b, 0x040bb9d98ee1ffba, 0xff3baf7dfcff018b, 0x01a2010b3d148018, 0x5cc21eff019dac04, 0x0112ba7bb6e5ffbc, 0xffba611bb2ff01ab,
        0x01f80112bb5d48d5, 0x01ca010e01d80002, 0xd3c5bbff01c50007, 0x000aba22d54dffba, 0xffbb5956cdff01d3, 0x01eab50438d556b8, 0x065e73ff01e5b104, 0x010e3a367313ffba,
        0xffba6cea15ff01f3, 0x021cb104bb619540, 0x0209ad04020e040b, 0xdff9ff3c3ead49ff, 0x73ff0217050b3d37, 0x3d3e85b5ff3df50e, 0x02290207022e010e, 0xd680ffb9af3f2aff,
        0x38ff02370007bc77, 0x3d5f6263ff3caf7b, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094850501208705, 0x0030720500507b05, 0x001d0b0e0022000a,
        0x24ccffb99df824ff, 0xd4ff002b7005ba5b, 0x3b10103dff38e8f0, 0x003d011200420002, 0x56e5ffb9b6c91eff, 0x9dff004b010a3bbd, 0x3be70e2dffbab3bc, 0x0066b40400740112,
        0x6b331aff0061000d, 0x070eb9956165ffba, 0xff39313e33ff006f, 0x0086020d3b762703, 0x9e2831ff00819e04, 0xab043c6ae0adffb9, 0xff3c89f778ff008f, 0x00dc000a3d77bf4c,
        0x00ae010700bc030b, 0x19ac42ff00a9020b, 0xab043ba26173ffbc, 0xffbc9f2bb0ff00b7, 0x00ce000739df694d, 0x4799a8ff00c90112, 0x01073c65349effba, 0xffbbc12f23ff00d7,
        0x01009c043a95099a, 0x00ed970400f29b04, 0x7d0bffbb6b80eaff, 0x33ff00fb01123cb3, 0xbd8fee32ffbaa18a, 0x010d070e01120111, 0x5ab9ff38060b6bff, 0xddff011b01073afb,
        0xbad39b77ff3cb12f, 0x016c9d0401b0020d, 0x013e9404014c9904, 0x1eabadff01399304, 0x01113c0edad3ffbb, 0xffba8781dfff0147, 0x015e9a04bc993f7b, 0xc58f08ff01590111,
        0x9c043d2faf37ffba, 0xffbc3e5d8dff0167, 0x0190a5043ac6e121, 0x017d050b01820112, 0x16f9ffba93a629ff, 0x72ff018b040bb956, 0x3cecd666ff3ba115, 0x019d011201a2070e,
        0x8281ffba4198f1ff, 0x2bff01ab0112bb96, 0x3cd74403ffb9b3ac, 0x01d8000201f80112, 0x01c5020e01ca000a, 0x44c1ffba7aa1b3ff, 0xb9ff01d3030bbb37, 0xbbafe3bcff39f4a1,
        0x01e5001201eab504, 0x0decffba408364ff, 0x7cff01f3b70439d1, 0x3a244078ffbb14c7, 0x020e040b021cb104, 0x0ebe1fff0209ae04, 0x00023d345070ff3c, 0xffbc78ebe0ff0217,
        0x022e010e3d8e016e, 0x402b4aff0229b204, 0xb3043a1c2aa7ffbc, 0xff3ccbeb7fff0237, 0x000000133d5faffd, 0x000003e800000005, 0x0000023c00000001, 0x0120870500000000,
        0x00507b0500948505, 0x0022000a00307205, 0x73fc95ff001d030d, 0x70053a541ed3ffba, 0xff38ba5a14ff002b, 0x004200023ae6805b, 0x923a8aff003d0112, 0x99043b9778b8ffb9,
        0xffbb23e440ff004b, 0x007401123b18f1bb, 0x0061000a0066b504, 0x3475ffba23c91cff, 0x4fff006f070eb8e8, 0x3b8c2f00ff38da03, 0x00818d0400869904, 0x6879ffbb9c1c10ff,
        0xafff008f02073b9f, 0xba71571bff3c9979, 0x00bc000700dc9d04, 0x00a99c0400ae010a, 0xeeb1ffba9b77f6ff, 0x7bff00b7010ebc82, 0x38bae6abff3ca8fd, 0x00c9930400ce0112,
        0x9f6affbad66110ff, 0xb5ff00d795043ab3, 0xbcc5f0bdffbc18ec, 0x00f2011201000107, 0xe8018cff00eda704, 0x00073a4e19c4ffb9, 0xff3d0ced9aff00fb, 0x0112010b3c73053b,
        0xcbbea0ff010d0002, 0xa804bc09024cffbc, 0xff3b6b5d74ff011b, 0x01b08f05bb263d74, 0x014c010a016c010b, 0x0139010e013e0007, 0xa27effba6e8e73ff, 0x84ff01470207bbc8,
        0xbb95000affbc40be, 0x01598905015e000d, 0x6c1eff3984fd55ff, 0xeeff0167ad043b93, 0x3b0d43d3ffbbd473, 0x0182000201900107, 0x0a3e78ff017d0112, 0x01113b91168fffba,
        0xff37b03d23ff018b, 0x01a202073c179fd5, 0xd98e41ff019d020d, 0x01113bc6d3a6ffba, 0xffba4cd17fff01ab, 0x01f8a704bc47484d, 0x01caa60401d80112, 0xb91a05ff01c5000a,
        0x0007bb95d95affba, 0xff3750f5a0ff01d3, 0x01ea0002bb0159c0, 0x0831d7ff01e5000d, 0x010bbcd79ef3ffbc, 0xffbc31f9aaff01f3, 0x021cab04bae9931a, 0x02090002020e0112,
        0x52e6ffbaadb30eff, 0x6bff0217aa0439e7, 0x3d0a49d7ff3b990f, 0x02290111022e010a, 0xc3bdffba4a85d4ff, 0x1aff02370112bb6e, 0x3c2e51bbff39a58a, 0x0000000500000013,
        0x00000001000003e8, 0x000000000000023c, 0x00948d0401208705, 0x0030870400507605, 0x001d4e0100228604, 0xcba8ffba157a61ff, 0xeaff002b0e0e3a13, 0xbc007152ff3bb5fb,
        0x003d01120042010d, 0xd996ffb9c21205ff, 0x95ff004b0112bc0f, 0x3cf9d8b2ffb98f79, 0x0066770500740111, 0x1c9d50ff00610107, 0x7c04ba4dfd6aff3a, 0xffba725f7bff006f,
        0x0086010eb9e1f52c, 0x04a13bff0081010a, 0x000d3cf30740ffb9, 0xffbbf33f88ff008f, 0x00dc8f04bcd0000c, 0x00ae030b00bc0112, 0x19ded9ff00a9060e, 0x3d01baa81282ffb9,
        0xffba3e94efff00b7, 0x00ce4c01b868e2fb, 0x50d98cff00c9000d, 0x010d3d92b63effbb, 0xffbb707d1dff00d7, 0x01000112bcd73fec, 0x00ed000a00f2ad04, 0xfef9ffb7553963ff,
        0x30ff00fb000aba18, 0x3a11b832ffba3c81, 0x010d000e01120007, 0xebbbffbc55204eff, 0x39ff011b010d39ed, 0x3cc45d62ff3c0407, 0x016ca60401b0010d, 0x013e9404014c9904,
        0x13e11cff01399304, 0x01113bce74a9ffbb, 0xffba0e25ceff0147, 0x015e0112bc826b34, 0x6543e6ff0159050b, 0x040b380326cbffba, 0xff3ac5aed2ff0167, 0x0190a7043c926870,
        0x017d030b01820112, 0x4ac4ffba698550ff, 0x3fff018b000a3966, 0xbc52b33affbb91c3, 0x019d000a01a20111, 0xc4ebffba16be37ff, 0xf2ff01ab070eb857, 0x3cad407affbb5a10,
        0x01d8011201f8b104, 0x01c5040d01ca0002, 0x148cffbac25d4eff, 0xa5ff01d3020d3b48, 0xb9eff398ff3ad772, 0x01e5010b01ea040b, 0x761cffbc671738ff, 0x60ff01f300023c49,
        0x3d43503fffbc55a5, 0x020e0111021c0002, 0xc2a618ff0209000a, 0xb20439cfd764ffba, 0xffbd45eb0bff0217, 0x022eb5043a38ce30, 0x2b7c01ff02290111, 0x010b3c5c33aeff3a,
        0xff3c709a8bff0237, 0x00000013bb55c0ac, 0x000003e800000005, 0x0000022a00000001, 0x010e870500000000, 0x00507b0500948505, 0x0022000a00307205, 0x3261b0ff001d0d0e,
        0x7005ba39098cffb9, 0xff38f82894ff002b, 0x004202073a9eddaf, 0x9ed031ff003d7705, 0x010bb945d4cdff3a, 0xffbca9cea9ff004b, 0x0074020bba934fa7, 0x0061930400660107,
        0x575affbb176507ff, 0xe9ff006f7d053aed, 0xbc60caa7ff3c5c09, 0x0081001100860112, 0x5971ffba2d91f7ff, 0x23ff008f020db856, 0x3c984947ff3b4be5, 0x00b3001200ca010b,
        0x00a9000d00ae7804, 0x81acff3ad36974ff, 0x0d3b11c16cff3ac7, 0xff00c0000a00c501, 0x1abac4ffbc89d345, 0x000abd143c34ffbc, 0xa10400e0011100ee, 0xff39a0c515ff00db,
        0x00e9b304ba772f59, 0xb378ffbbc1cce8ff, 0x010a01009d043d7f, 0xffbbde6bcaff00fb, 0x01099f043c585bfc, 0xf0aeff3c699dd8ff, 0x9d04019e020d3abb, 0x030b013a040b015a,
        0x16ff0127000a012c, 0x3b414eceffbb5b74, 0xbaf311ff01350002, 0x050b3ba42bd6ffbc, 0xd3ff01470011014c, 0x3cca1f0fffbb51dc, 0x85fb17ff01558b05, 0xa604bb896c54ff3a,
        0xa50401700112017e, 0xffb996b766ff016b, 0x01798f05ba818604, 0x40d9ff3c4f0202ff, 0x01120190030ebc2a, 0xffb944af54ff018b, 0x0199a704bbb7df6c, 0x22deffbb3ffdbdff,
        0x010e01e601113809, 0x000a01b8050b01c6, 0xffba6801f0ff01b3, 0x01c10207b88bf5d9, 0x08a0ffb8ddad08ff, 0x880501d8ad043afd, 0xffbae1c5e1ff01d3, 0x01e100023a8006c0,
        0xd5a4ffbaeae259ff, 0x0207020a8905b9a6, 0x7aff01f7010701fc, 0x3d3d3f42ff3ca74f, 0xa59680ff0205b304, 0x0002bccbf48eff39, 0x63ff0217a604021c, 0xbc2e2ba7ff3ca201,
        0x84963bff02250107, 0x0013bc1d2223ff3c, 0x03e8000000050000, 0x023c000000010000, 0x8405000000000000, 0x00020094150e0120, 0x3004003065040050, 0x10ff001d01120022,
        0xbad1301effba30f2, 0xdf892dff002b080e, 0x0112bb23a6b4ff38, 0x13ff003d060b0042, 0xb9292fc0ffba25f8, 0xd0c4f2ff004b020b, 0x010a3c320bcdff3a, 0xae04006609060074,
        0xffb9000469ff0061, 0x006f070e3b900ef6, 0x258effbc1e9f9cff, 0x9f04008601123ab7, 0xffb9707fcfff0081, 0x008fa204bacb73e2, 0xb0b8ff3c86bf35ff, 0x011200dc8c0439cf,
        0x000a00ae001200bc, 0xff39af480eff00a9, 0x00b78704b9fd5cba, 0x22eaffba1a4b5fff, 0x790400ce2003bacc, 0xffbc94a235ff00c9, 0x00d72805bc1f142f, 0xba10ffbc633e18ff,
        0x01120100ae04bccc, 0xfeff00ed020b00f2, 0xba4e57ecffbafea6, 0x1f19b8ff00fb2805, 0x4101bc069503ffbb, 0x30ff010d1e0e0112, 0xbc13efa7ffbada24, 0x8daee1ff011b1b0e,
        0x02073aea8ab3ff3b, 0x010e016c011201b0, 0x030b013e000a014c, 0xffba2f484bff0139, 0x0147a604384f851d, 0x3701ffb9dffb17ff, 0x040e015e000a39b5, 0xffbac75e7bff0159,
        0x0167b504b9f764b1, 0xa700ffb9971f72ff, 0x8b050190010d3a08, 0x33ff017d9d040182, 0x3bdbcf11ffbab63e, 0x2ad564ff018b010a, 0x040b3c0844afffbb, 0xb9ff019d900501a2,
        0xbb290ed0ff3bdf6b, 0x484cc0ff01ab8505, 0x01123c7de422ff3e, 0x000201d8b60401f8, 0x8dff01c5ab0401ca, 0xbaadff96ffbb8620, 0x283137ff01d3020d, 0x010b39eb700cffba,
        0x85ff01e5010a01ea, 0x3a959adcffbb21c0, 0x74efc8ff01f3b704, 0x030b3a234921ffb9, 0xa204020e8505021c, 0xffbc386704ff0209, 0x0217010e3d7d0f60, 0x18e2ffbbd8a8e8ff,
        0x010d022e85053949, 0xffbcaf7ee1ff0229, 0x0237b004bd95729c, 0xf206ffbb919b50ff, 0x000500000013bc61, 0x0001000003e80000, 0x00000000022a0000, 0x8505010e87050000,
        0x720500507b050094, 0x010e0022000a0030, 0xff393ba82eff001d, 0x002b0002b9f659ca, 0xa84bff38a7a15dff, 0x9f04004200023a9d, 0xffb9b570eeff003d, 0x004b9d043b28144c,
        0xb9faffbb180617ff, 0x01070074020b3ac8, 0xa0ff006197040066, 0x3af2b58affbad7bf, 0x3c8f8dff006f8205, 0x9e043c409103ffbc, 0x77ff008182050086, 0xbabbe175ffb9b346,
        0x6ac568ff008f0207, 0x010bba8144a3ff3b, 0x780400b3001100ca, 0xccff00a9000d00ae, 0x3ab1222bff3ab57f, 0xc5010d3afabcb4ff, 0xf6e2ff00c0000a00, 0xffbc006f04ffbc57,
        0x00ee000abcf858e8, 0x00db010e00e00112, 0x83b7ff3959cdc5ff, 0x09ff00e9010eba2d, 0x3b1e454fffbc2635, 0x00fb9d040100000d, 0x6e3dffbb98f9dcff, 0x21ff0109020b396b,
        0x3b7cff60ff3d3625, 0x015a9d04019e020d, 0x012c0002013a010e, 0xd4e1d2ff01279404, 0x9104bba16789ff3a, 0xff39766f97ff0135, 0x014c01113bdca1c1, 0x35e61cff01479a04,
        0x00073b167f56ffba, 0xffbb321d41ff0155, 0x017e0107bc15854c, 0x016b8d0501700111, 0x6d1fff3913a058ff, 0x17ff01798d05b9bc, 0xbab74313ff3c0398, 0x018b030b01900111,
        0xfbfeffba3d6507ff, 0x59ff01990002b89a, 0xbbc3fdf8ff3b1ac1, 0x01c6890501e60112, 0x01b3030e01b8040d, 0xc539ffb7ce5821ff, 0x84ff01c1070d3b35, 0xb94946e0ff3b6b4a,
        0x01d3000201d8b604, 0xa03effba75995bff, 0x07ff01e10007b936, 0x393fd842ffba31a3, 0x01fc010b020a8905, 0x9d5b4eff01f70207, 0x02073a3aef55ffbc, 0xff3ce8e068ff0205,
        0x021c0002bc5346f3, 0x3041f2ff0217b204, 0x01073b2799f8ffbc, 0xff3c46e4b1ff0225, 0x00000013bc00422a, 0x000003e800000005, 0x0000023c00000001, 0x0120840500000000,
        0x00508c0400947805, 0x00224d0100308604, 0x0e0066ff001d0112, 0x011239402018ffba, 0xffba10db1eff002b, 0x004201123b28bff0, 0x8812ccff003d020b, 0x010db90c413affba,
        0xffbc129c0aff004b, 0x007492043cdde0d6, 0x0061360100660112, 0x6769ffba9ab951ff, 0x97ff006f000db907, 0x3ce8de94ff3a6af6, 0x0081040e00863805, 0xc363ffbb8902b8ff,
        0xd2ff008f01123a1a, 0x3c028073ffb87043, 0x00bc9b0400dc9e04, 0x00a9010d00ae8005, 0x449dffba334ec3ff, 0x76ff00b799043abd, 0x3bf78934ffbb1158, 0x00c9011200ce0107,
        0xcd96ffb93b826cff, 0xb5ff00d701113bd3, 0xbcab9987ffba3227, 0x00f2b10401000111, 0x803af8ff00ed000d, 0x8105b9891f4fffba, 0xff3a94680aff00fb, 0x01120002b99af9dc,
        0xffe60dff010da904, 0x020dbc3e67cdff3c, 0xffbadca698ff011b, 0x01b0000a3ccdf5f1, 0x014c0207016c040b, 0x01390007013e8605, 0xd593ff3b0def21ff, 0x37ff0147020dbbec,
        0x3a9ffb58ffbae911, 0x0159a204015e030b, 0xfccbffbc3a0904ff, 0x4aff01678905b9f2, 0xbb8dbc47ffbcd503, 0x0182850501900111, 0x3b0de8ff017d0107, 0x010ebb10e6e2ffba,
        0xff3928362fff018b, 0x01a2af04b9fdf2c9, 0xab7586ff019d010d, 0x070e3cfad836ff3b, 0xffbb86bdf2ff01ab, 0x01f800073cdf1643, 0x01ca001201d80112, 0xb8e8f4ff01c59f04,
        0x9c04b9bfe483ffba, 0xff3a457bfdff01d3, 0x01ea8d05b918039d, 0x47ca7cff01e59d04, 0x010d3c74e6d9ff3b, 0xff3ab359b7ff01f3, 0x021c0002bcbfb84b, 0x02099b04020e9d04,
        0xbaceffba299139ff, 0xa1ff0217a904bca1, 0x38a94833ff3bf7df, 0x02299f04022e0112, 0x1d87ffbb3dc76eff, 0x15ff02379f04b91d, 0xbc08e4ceff3c1fe4, 0x0000000500000013,
        0x00000001000003e8, 0x000000000000023c, 0x0094850501208705, 0x0030720500507b05, 0x001d040b0022000a, 0x9583ffba26fcbcff, 0x67ff002b00023a10, 0x3a6c9a7eff38c729,
        0x003d740500420207, 0xd53dffbb09d2a1ff, 0xa6ff004b9e043a4e, 0x37a8ca15ffbc03da, 0x00667f0500748005, 0x12c984ff0061a104, 0x010d3b765143ffba, 0xffba859e3aff006f,
        0x008602073bc819cc, 0x09ae32ff00818d04, 0x01123ac2bb79ffbb, 0xffba0ed046ff008f, 0x00dc020bbc230354, 0x00ae000200bc0111, 0x2d5bdfff00a97804, 0x7e043a8fd0ecff3a,
        0xff3aedb2ecff00b7, 0x00ce000a3a7aaf4e, 0x61661aff00c9010d, 0x8605bcc25e35ffbc, 0xffbbca0097ff00d7, 0x010001073c140195, 0x00ed011200f2030b, 0x702cffba581c5bff,
        0xbbff00fb86053c35, 0x3ae55ccdffbb34ae, 0x010d011101129f04, 0x7ab9ff3b30e039ff, 0xaaff011ba804bc84, 0xbb26e1aaff3ba973, 0x016c010b01b0010e, 0x013e010d014cb304,
        0xa02d5eff0139ad04, 0x02073b03de81ffbb, 0xffbc89b3d5ff0147, 0x015e010d3a2dd855, 0x17dd9cff0159010a, 0x01113b5a33caffbb, 0xffba946deeff0167, 0x0190a9043c74a63b,
        0x017da6040182a804, 0x94f2ff3b00f013ff, 0xa7ff018b0112bb31, 0x3d2817e6ffb9a992, 0x019d010d01a28905, 0xe835ffbb3f22b0ff, 0x6dff01ab01113c17, 0xbb46f2beffb891ff,
        0x01d8040b01f8a304, 0x01c59c0401ca0112, 0x6db1ff3a2773dbff, 0xefff01d39b04ba3a, 0xbaf09e36ffbbeb50, 0x01e59a0401ea0112, 0x6b09ffba9c5615ff, 0x72ff01f39d04393f,
        0x3c36ea04ff368f3c, 0x020ea404021c080e, 0x30e04fff02090111, 0x01113c3100caffb9, 0xffb9c5d3ceff0217, 0x022e01113a8a1cb9, 0x9e1301ff0229010a, 0x030b3ac59cc6ffb8,
        0xff3a82c42dff0237, 0x000000133d253683, 0x000003e800000005, 0x0000023c00000001, 0x0120870500000000, 0x00507a0500948505, 0x0022470100307505, 0x16075dff001d140e,
        0x2103bb310631ffb9, 0xff3b86a60bff002b, 0x0042020739cf3f08, 0x1d9cc0ff003d0111, 0x040b3b87b01affb9, 0xffbc12f68cff004b, 0x0074030e3afc2a1d, 0x0061910400660112,
        0x0447ff39688ad1ff, 0x98ff006f9904ba12, 0x3c278ff7ffbb1d5c, 0x0081040b00860207, 0x0fe3ffbaf60186ff, 0x7aff008f01113a28, 0xbc2bf08fffba6069, 0x00bc011100dc020b,
        0x00a9780400ae8605, 0x1b10ff3a0aafe6ff, 0xbaff00b77e043a66, 0x3a488c3eff3abe28, 0x00c9010d00ce000a, 0x7e8effbc3451b2ff, 0x4aff00d7000dbc9b, 0x3b93afe0ffbbfd93,
        0x00f2011201000007, 0xb3205fff00ed9d04, 0x010dba803090ff39, 0xff3b73a3e8ff00fb, 0x01129c043d4ba602, 0xa02127ff010d0111, 0x010abc8a7f29ff3a, 0xffba0ba9d8ff011b,
        0x01b0010e3b6254dc, 0x014cb204016c010b, 0x0139010d013e000a, 0x6c1cffbbb6dc2dff, 0x54ff01478c05bc45, 0x3b21d2fdffbb001c, 0x0159010a015e010d, 0x8fd0ffbac03b9fff,
        0xf9ff0167b6043b2e, 0x39885d4cff3c6a10, 0x0182a8040190a904, 0xce4d0cff017da604, 0x0112bb0e10bbff3a, 0xffb987a886ff018b, 0x01a289053d067984, 0x18e88cff019d010d,
        0x01123bf30d27ffbb, 0xffb86998e7ff01ab, 0x01f8a304bb1f289c, 0x01ca010701d8010b, 0xa4571fff01c5010a, 0x9d043b557dc0ffbb, 0xffbc7a6246ff01d3, 0x01ea9c04bca9e764,
        0x485bf9ff01e50112, 0x010abb8ce06eff39, 0xff3a9e148bff01f3, 0x021ca604bbf5c8d0, 0x0209000a020e0112, 0xeedbffb63baa5fff, 0xd0ff0217010aba4a, 0x3d3714bfff3bf690,
        0x0229070e022e8d05, 0x6433ffba1ab57fff, 0x31ff023701123afb, 0x3b0c1910ffb9acd2, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x00948d0401208705,
        0x0030020d00506405, 0x001d2e0400228c04, 0x8b10ffba28a27fff, 0x50ff002b00023887, 0xbd318149ff388e7d, 0x003d8a0400420112, 0x8165ffb9e044b0ff, 0xc7ff004b5d04b916,
        0x3c669dc2ff3b2606, 0x00668a0400748b04, 0x4f4579ff00618704, 0x010e39ed6ef7ffba, 0xff3bacd73cff006f, 0x00860112ba9168fc, 0x26ef37ff00818c04, 0x010d39972d10ffba,
        0xffbb4eebcbff008f, 0x00dc8f04bd2b4ed1, 0x00ae011200bc4c01, 0x47785cff00a9060e, 0x000d388dcdbeffbb, 0xffba65c3beff00b7, 0x00ce01113d4b6f54, 0xecde05ff00c9000a,
        0x010d3a21473affb9, 0xffbba7644dff00d7, 0x01000112bce377fc, 0x00ed030e00f2af04, 0xf438ffb81ea8b0ff, 0x69ff00fb7505b9e1, 0x36792247ff3b23fc, 0x010d910401120207,
        0x0c27ff3ca4c720ff, 0x4dff011b7d053a67, 0xbc31b643ff3c0c2b, 0x016ca10401b00002, 0x013e8a05014c8b05, 0x0fac77ff0139020b, 0x0112baf1f1b9ff3c, 0xff38969125ff0147,
        0x015e01123cfbd697, 0xa25c23ff01599c04, 0x9e04ba744481ff3a, 0xffbbbd5d64ff0167, 0x0190a604bcbb7fc6, 0x017d010a01820112, 0xc001ffba0c8713ff, 0x33ff018ba3043b0e,
        0x3ca96a52ffbb0442, 0x019d010d01a20111, 0x16d0ffb8d042c0ff, 0x58ff01aba704ba28, 0x3a9cb68cffbca8f3, 0x01d8020d01f8af04, 0x01c5000a01ca010b, 0x49beffbbdbe2cdff,
        0xe3ff01d3a504ba2f, 0xb8734726ff3b2136, 0x01e5011201eaa504, 0x3f42ffb9c0e560ff, 0xf2ff01f30112bc9d, 0x3cb41ca7ffb9cee9, 0x020e0112021c8b05, 0x02afb1ff02098905,
        0x070e3a64c8cfffba, 0xffbbdd09c5ff0217, 0x022e010a3c637848, 0xc623fdff0229010d, 0xb0043a7489f2ffba, 0xff3c1b88a3ff0237, 0x000000133a57455a, 0x000003e800000005,
        0x0000023c00000001, 0x0120870500000000, 0x0050800500948505, 0x00227c0500307d05, 0xaf2dfbff001d0112, 0x01123a4fed1effb9, 0xffb854b1d7ff002b, 0x004201113c21caf5,
        0x0afeb1ff003d010d, 0x7e05ba509644ff39, 0xffbc821dfbff004b, 0x0074020d3994ea52, 0x0061040b00669d04, 0xed6cffbb11587eff, 0x06ff006fa6043a58, 0xbb113c29ff3b9867,
        0x00818d0400860111, 0x46d7ff3a83a148ff, 0xc7ff008f8305b96b, 0x3c979d20ffbb2545, 0x00bc9b0400dc9d04, 0x00a9020b00ae9a04, 0xe8b0ffbb80f352ff, 0x05ff00b7010e3a75,
        0xbc68f368ff3d24e4, 0x00c9000d00ce0112, 0xe973ff3b374628ff, 0xdbff00d79c043acb, 0xbb93a25cffbd4628, 0x00f2011201000107, 0x747a93ff00eda804, 0xa80439f2f9b6ffba,
        0xff3bd2ccbaff00fb, 0x01129f043d180d6e, 0xadd7feff010d0112, 0xa804bc83b94cff3a, 0xff3b5df2a9ff011b, 0x01b0ae04bae667a0, 0x014c9904016ca604, 0x0139010d013e9804,
        0xc37cffba9d70feff, 0x5eff014701113c17, 0xbcfb8470ffba2603, 0x01590112015e9a04, 0xb47fffba54e97fff, 0x41ff01679c043ce4, 0x3ab80289ffbc0f49, 0x0182070b0190a704,
        0x825e11ff017d030b, 0x0007bc4866fbffbb, 0xffba75d219ff018b, 0x01a200023bacd5a9, 0x53e89eff019d020d, 0x010dbbdfc15aff3a, 0xff3a82ff57ff01ab, 0x01f801073bff7ec8,
        0x01ca011101d88f05, 0x98c70dff01c5b404, 0x000a3aacfe08ffb7, 0xff3cc28620ff01d3, 0x01eab004ba494583, 0x2aa0aeff01e5010a, 0xb2043bebde3fff3a, 0xffbb0273ccff01f3,
        0x021c020d38a9a93d, 0x02090002020e0112, 0xfc92ffb9711a48ff, 0xfeff0217b004399f, 0xbba52c99ff3a9a0e, 0x02298905022eb004, 0xf5f0ff3d8d1496ff, 0x0eff0237b504bd16,
        0xbae86457ff3ad703, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094830501208705, 0x0030470400504201, 0x001d011200223304, 0x6347ffb95d0a4dff,
        0xb2ff002b0112baa1, 0x3a966324ffb9e1d8, 0x003d000a00420112, 0xa49dffb8bb6becff, 0x59ff004b000db9fa, 0x3b763e31ffbaf00a, 0x006681050074ad04, 0x2af469ff0061030e,
        0x010ab94c0328ff3a, 0xffba39208cff006f, 0x00860112bc1bdfc8, 0x21bd24ff0081af04, 0xaf043a1102a4ffba, 0xff3d01cb06ff008f, 0x00dc85053b1231c8, 0x00ae910400bc0112,
        0xf15ed7ff00a9040b, 0xaa04b893bb7dff39, 0xffbabf56adff00b7, 0x00ce040bb87e0b98, 0xaeddafff00c9030b, 0x0007bc70ba6eff3b, 0xff3bd48521ff00d7, 0x0100000d3d0ed648,
        0x00ed010a00f20002, 0x41ddff3a5d7c8fff, 0xd9ff00fb0112bb0b, 0xbc0d7804ffb9fe31, 0x010d010a01128605, 0x8d8affbb0e8cdbff, 0xf8ff011b01123bcb, 0x3c08bb5eff38d824,
        0x016c010b01b0010e, 0x013e010d014cb204, 0xd416aaff01390002, 0x0207b9da03f2ffbb, 0xffbc54c8bbff0147, 0x015e010d3b81cf6b, 0x8f3096ff01590112, 0xb604baf72933ff3a,
        0xff3c38d14cff0167, 0x0190a90439c705c8, 0x017da6040182a704, 0x40edff3a8ac6b7ff, 0x99ff018b0112bb95, 0x3ca6c30bff3a3b1b, 0x019d040b01a28905, 0xf9a7ff3bb804fdff,
        0x29ff01ab0112bb15, 0xbb0fc6c6ff388bf8, 0x01d8000201f8a304, 0x01c5880501ca010a, 0x9776ff3b922df8ff, 0xe8ff01d30112b877, 0xbc9d0c67ff3b50b2, 0x01e5020b01ea0007,
        0xb9e1ffbbcbf730ff, 0x92ff01f3011239c9, 0xbbf4ade2ffba2434, 0x020ea604021ca704, 0xc5cebdff0209010a, 0x000a3c829647ff39, 0xff396a92adff0217, 0x022eac04bbbbc53a,
        0xb093b9ff02290111, 0x070e3c0d0290ffb7, 0xffb9573e58ff0237, 0x000000133a8c8f2f, 0x000003e800000005, 0x0000023c00000001, 0x0120870500000000, 0x0050800500948505,
        0x0022480100306305, 0x31c9a9ff001d6304, 0x250339183522ffb9, 0xff3b5877b6ff002b, 0x0042030b399f14af, 0x593a48ff003d9304, 0x040b3ac0c570ffba, 0xffbbabc059ff004b,
        0x0074020d39ee7cd3, 0x0061000a00669d04, 0x5a84ffbadd63eaff, 0xb9ff006fa6043ac7, 0xbae914c8ff3b6519, 0x0081820500860107, 0x8055ff3a78dd60ff, 0x18ff008f0111bacb,
        0x3c1a9123ff398aa8, 0x00bc011200dc020b, 0x00a9010b00ae7e04, 0x8268ff3ac4cc4eff, 0x80ff00b7010b3b0c, 0x3ab5ab58ff3a63e6, 0x00c9010d00ce000a, 0x5dd2ffbc029eb2ff,
        0x23ff00d78605bc86, 0x3bc33885ffbb896b, 0x00f2940401009d04, 0x691138ff00ed8e04, 0x01123bef4b31ffb9, 0xff3ad34f78ff00fb, 0x01120112bc075129, 0x9df742ff010da804,
        0xa9043a47ceffffba, 0xff3bfdd10cff011b, 0x01b0010ebba3432e, 0x014cb404016c010b, 0x0139000a013e010d, 0x8501ffbb5137bcff, 0x1dff0147b2043a28, 0x3b2c1040ffbc1403,
        0x0159000a015e0111, 0x17b7ffbacc6e1eff, 0x58ff016700073a97, 0x3bdcc487ff3c99a7, 0x0182a7040190a904, 0x34b28eff017d9005, 0x0112bbffdd07ff3a, 0xff3a15afaaff018b,
        0x01a289053c8568d9, 0x910b34ff019d0207, 0x0111bb45f08bff3b, 0xff385ff37aff01ab, 0x01f8a304bae60ae1, 0x01ca000d01d80002, 0x456ae1ff01c5010a, 0x0112bbfb65bbff39,
        0xffbba8489dff01d3, 0x01ea00073d00a318, 0x4993e2ff01e59b04, 0x070b3ad8efe3ffbb, 0xffbbbb9159ff01f3, 0x021ca7043c209f58, 0x02090002020e070b, 0x14a1ff3a84e6f4ff,
        0x33ff02170111bb3e, 0x3c155dd8ffb640b7, 0x02290112022e010b, 0x6b0cffba88a56bff, 0x24ff0237070e3b96, 0x3a46d10fffb653b0, 0x0000000500000013, 0x00000001000003e8,
        0x000000000000023c, 0x0094830501208705, 0x00306d0400507b05, 0x001d150400224804, 0xd363ffba48d058ff, 0x19ff002b0112b838, 0x3abc6ccdffb9c81c, 0x003d780500420b06,
        0x250bff39e25a36ff, 0x01ff004b070eb8d6, 0x3b2e2c24ffbbca93, 0x0066aa0400740207, 0xabf2e2ff00617d05, 0x070eb8cedf26ff3a, 0xffbb84745bff006f, 0x00867d053b2d619c,
        0xad7397ff0081020d, 0x01113ced8a9fff3a, 0xffb91f0a7dff008f, 0x00dc8505bc4e9645, 0x00ae930400bc0111, 0xa8b3bdff00a9010b, 0xa60439b2ef62ff3a, 0xffbaccb322ff00b7,
        0x00ce050b38948486, 0x867c69ff00c9030b, 0x010dbc1e6561ff3b, 0xff3c852db3ff00d7, 0x0100000d3dccf4e7, 0x00ed010a00f20002, 0xd17dff3a41217bff, 0x79ff00fb0112bad7,
        0xbbea289fffb9c2d5, 0x010da9040112020e, 0x8a8cff3a8bfcaaff, 0xf7ff011b0111bb86, 0x3d08efdcff3a10fb, 0x016ca40401b0ae04, 0x013e000a014ca304, 0xcbfe08ff01398b05,
        0x0002bb2ba232ff39, 0xffb9e9b6deff0147, 0x015e01113b9b7a32, 0x9bf8e2ff01590007, 0x010dbaa56690ffb9, 0xff3c4b9913ff0167, 0x0190010a3dc442c6, 0x017d020d01820002,
        0x5c68ffb848c34eff, 0x94ff018b010dbbbb, 0x3b8e0f96ffb9eb32, 0x019d011101a2a604, 0xde73ffbb2868a1ff, 0xffff01abac043ce9, 0xbb597616ff3b5512, 0x01d8920501f8030b,
        0x01c5000a01ca0112, 0xbc88ffba356c48ff, 0x14ff01d3b50437bc, 0xbc051632ff3b8c98, 0x01e5b20401eab404, 0x14c0ffba6cbda0ff, 0x20ff01f301113b23, 0xbc08fc10ffba14e0,
        0x020e070e021c8a05, 0x6f39baff0209040b, 0x0111ba42c94aff3c, 0xffb9b17acdff0217, 0x022e040b3d27ec3e, 0x22dbddff02298b05, 0x01123bb94452ffbc, 0xff373abd8cff0237,
        0x00000013bb59799f, 0x000003e800000005, 0x0000023c00000001, 0x0120870500000000, 0x00507b0500948305, 0x0022480400306d04, 0x067680ff001d070e, 0x0112ba7f4fb3ffb9,
        0xffb9a01682ff002b, 0x00420b063a96bd7d, 0xb51505ff003d7805, 0x0105b8ab509bff39, 0xff3b1c55c6ff004b, 0x00740207bbb26a26, 0x00617d050066aa04, 0x7f67ff3a898f20ff,
        0x4bff006f080eb8a5, 0x3b25f6c7ffbb41eb, 0x0081020d00867d05, 0x0880ff3a8ac2eeff, 0x09ff008f01123cbe, 0xbc254507ffb8fe77, 0x00bc011200dc8505, 0x00a9820400ae9204,
        0x6b52ff3a13d71fff, 0xb0ff00b7a804384d, 0x38d32443ffba9d04, 0x00c9030b00ce040b, 0xd381ff3b572d7cff, 0x0fff00d70207bc23, 0xbce7fe1bff3c9d41, 0x00f201120100000a,
        0xa4d7afff00edaa04, 0x010e3a845accffb9, 0xffbbe363d8ff00fb, 0x0112030b3b181723, 0x73433aff010d0111, 0x040b3b92c1f3ff39, 0xffbd0e48adff011b, 0x01b0ae04b9b0fb20,
        0x014ca304016ca404, 0x01399904013e9005, 0xf6f0ffbaa1ff12ff, 0xd1ff014700023a1a, 0x393e42e4ffbc120e, 0x01590112015e020d, 0xcd08ffba0def3fff, 0x40ff016701123c19,
        0x3e261e58ffb969d8, 0x018200020190010a, 0x209c72ff017d020d, 0x020dbb95e384ffb8, 0xffb9e489aaff018b, 0x01a2a6043b8b6215, 0x06ba19ff019d0111, 0xa7043cbb185bffbb,
        0xffbb9c5b3fff01ab, 0x01f8030b3b11161c, 0x01ca011201d89205, 0x1b6922ff01c50107, 0x020db9fdfa80ff39, 0xff359743dbff01d3, 0x01eab4043bffcfc3, 0x3d648dff01e5b204,
        0x01113b027701ffba, 0xffb9ee335eff01f3, 0x021c8a05bbdb2cdf, 0x0209040b020e070e, 0xd439ff3c3f615bff, 0xceff02170111ba1b, 0x3d065696ffb98dfb, 0x0229af04022e040b,
        0x1718ff3d00cc6aff, 0x8aff023701123988, 0xbb2dfadeff371564, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094830501208705, 0x0030160e00506305,
        0x001d7b0400229704, 0xe20bffb6ff10fcff, 0x4fff002b09063a89, 0xbac3421bff3b0ec9, 0x003d011100420906, 0xb6cdffb9abbe81ff, 0xb8ff004b0005bb4b, 0x3b45eb7aff39e62d,
        0x0066020700740002, 0x15b280ff00619004, 0xa0043aa4c17cffba, 0xffbb2c6f54ff006f, 0x00869d043b173cc5, 0x16b380ff00819904, 0x01123a883b09ffbb, 0xffba1b878aff008f,
        0x00dc9c043ba053a9, 0x00ae000d00bc9b04, 0x9dbe64ff00a99a04, 0x9904bc37639bffba, 0xffb9cdae2bff00b7, 0x00ce01123c059c0d, 0xf8b100ff00c98405, 0x000d3ab491c8ffb9,
        0xffbcec44b0ff00d7, 0x01000112bd61064e, 0x00ed010700f2a804, 0x1fa4ffb9fef290ff, 0x00ff00fb8405bb24, 0x3a1ef9d6ffb9f256, 0x010d040b01128505, 0x8676ff3b7eb0cfff,
        0xfaff011baa043cca, 0xbba4200fff3b825e, 0x016c010701b0ad04, 0x013e8b05014c8c05, 0x943536ff0139a604, 0x0111bb07c9ecff3a, 0xff3aaf0cdeff0147, 0x015e0002bc0877ac,
        0xf9a261ff0159ac04, 0x020dbcce8a0effb8, 0xff3a782777ff0167, 0x0190010b3c283cf2, 0x017d010d01820207, 0xc8bcffbbe99a13ff, 0xb2ff018b0002bc56, 0x3a9ec2abffbc05ef,
        0x019d890501a2aa04, 0x6db9ff3b03901bff, 0x89ff01ab030bbaf0, 0xbbcd20faffba52a6, 0x01d8010a01f8010b, 0x01c5010701ca9005, 0x0709ffbcdae430ff, 0x95ff01d3b504bb5a,
        0x3b2d9e85ffb9db65, 0x01e5b00401ea0107, 0x07bbff3c28f594ff, 0x74ff01f302073b79, 0xba00d58cff3a9e26, 0x020e0112021c8c05, 0x834fe0ff0209b204, 0x0002ba2f577dff36,
        0xff3c8be137ff0217, 0x022eae04394ad1a9, 0x220690ff02290111, 0x020dbbe01d79ff37, 0xffb994d5ebff0237, 0x0000001339be6705, 0x000003e800000005, 0x0000023c00000001,
        0x0120870500000000, 0x00507b0500948305, 0x0022480400306d04, 0x15cebcff001d1504, 0x0112372781f4ffba, 0xffb968a1f4ff002b, 0x004277053a76c5a8, 0x5da9eeff003d6f05,
        0x010e39d9cda6ff39, 0xff39bae5f0ff004b, 0x00740207bad7b7d9, 0x0061030e0066a904, 0x70e0ff3a782e33ff, 0x65ff006f010eba1f, 0x39d5454affbbafc7, 0x0081010e00867d05,
        0x16a2ff3c4d8d95ff, 0x7cff008f0112bb84, 0xbc105388ffb9abcd, 0x00bc9b0400dc9c04, 0x00a9950400ae9904, 0xaf8cffb8fb7bbcff, 0xa4ff00b70111bc20, 0x3c0aa73affba09e0,
        0x00c9840500ce0112, 0x749effb9c6f400ff, 0xacff00d7030b3a90, 0xbd2d158bffbca710, 0x00f2aa0401000112, 0x9ba4e1ff00ed9e04, 0xae04ba819efbff3a, 0xff3ae69c84ff00fb,
        0x0112840539484a62, 0x6e40e8ff010d030b, 0xb0043b881ba5ff3c, 0xff3b5940baff011b, 0x01b0ad04bbddf76c, 0x014c020d016c0107, 0x0139030b013e040b, 0x1907ff39713afeff,
        0x90ff0147050bbb79, 0x39a9b224ff3bf57d, 0x01598f05015e9005, 0xe873ffba40d87fff, 0x74ff016791053c52, 0x3a6358c0ffbd0407, 0x018202070190010b, 0xacdb34ff017d000d,
        0x0002bbeef8ffffbb, 0xffbbd64c50ff018b, 0x01a200023a7e0455, 0x2bc3f5ff019da004, 0xa404ba982a11ffbc, 0xffbb890fb1ff01ab, 0x01f8010b3ae130eb, 0x01ca930501d8010a,
        0x1cab54ff01c5010d, 0x0112bbad9878ffb9, 0xffba688cd5ff01d3, 0x01eab0043b79b6a8, 0xc62d80ff01e58905, 0x91053c072adcff3a, 0xff37551480ff01f3, 0x021c8a053b47395f,
        0x02090112020e8805, 0x4c63ffb9663c7fff, 0x6eff02170112bc27, 0x3bcf9760ffb9c6f3, 0x0229b004022e020d, 0x03dbff3a00d762ff, 0xa1ff0237b104b9ca, 0xb9ad4baeff3bdf19,
        0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x0094830501208705, 0x0030000d00506305, 0x001d140e00224f01, 0xdfbdffb8fe1a7cff, 0xe0ff002b090bbb09,
        0x38a2f957ffbab82f, 0x003d920400424301, 0x3f22ff39b7c6ceff, 0x43ff004b0112bb37, 0x3aac59d9ffb9fe88, 0x0066020700740002, 0xffe6e4ff00619004, 0x97043a861ea6ffb9,
        0xffbb723e6eff006f, 0x00869d043ab42f79, 0x652019ff00810111, 0x0112bbbd8eddff39, 0xffb9e9ce25ff008f, 0x00dc85053b89f028, 0x00ae040b00bc020d, 0xdfaf49ff00a9030b,
        0x0112bbc161f6ffb9, 0xffb9aac2bfff00b7, 0x00ce01113bf776f2, 0x037a7bff00c9040d, 0x050b3b29c80affb7, 0xff3b8e6e06ff00d7, 0x0100020b3dd73ea4, 0x00ed000d00f20112,
        0x156bff3b069c72ff, 0xf3ff00fb010d3aa1, 0xbc516a6affbb3ce0, 0x010d00020112000d, 0xa40aff3978aa49ff, 0x76ff011b010abb0a, 0x3bfe0685ff39d679, 0x016c010701b0ad04,
        0x013e040b014c020d, 0xab8ec1ff0139000a, 0x01123aa76367ffba, 0xffb98a9a5bff0147, 0x015e90053b245ea0, 0x1a46a8ff01598f05, 0x00023c28b9f5ffba, 0xffbda58ed7ff0167,
        0x0190010b3c27676f, 0x017d010d01820207, 0xedfcffbb91b2d5ff, 0xf8ff018b000dbc13, 0x3b0a3b30ffbb6976, 0x019d8b0501a2a704, 0xeb24ff38f0d030ff, 0xcaff01ab01113c34,
        0xbb968ab9ffb845f4, 0x01d8010a01f8010b, 0x01c5010d01cab404, 0x66d2ff397bafafff, 0x90ff01d30111bc0b, 0x3c176c55ffb9f517, 0x01e5890501eab004, 0x4498ff3a9e8ac0ff,
        0xfbff01f38f053bd8, 0x3b112f88ffb9e4a8, 0x020e000a021c8a05, 0x0ab0daff02090112, 0x01123bfa91dfffba, 0xffb7418c29ff0217, 0x022e020dbbcd024f, 0xce2579ff0229b004,
        0xb104b9a19cb4ff39, 0xff3bb27ae7ff0237, 0x00000013b98aa319, 0x000003e800000005, 0x0000023c00000001, 0x0120870500000000, 0x00507b0500948305, 0x0022480400306d04,
        0x54a059ff001d060b, 0x0002b71672ecffb9, 0xffb85363ddff002b, 0x00420b063b4a6b7a, 0x85640cff003d7805, 0x070eb764cae1ff39, 0xffbb917334ff004b, 0x007402073b066b9e,
        0x00617d050066aa04, 0xd495ff3a726b3dff, 0x78ff006fae04b900, 0x3b046a4dffbb2af4, 0x0081011200867d05, 0xc8f8ffbb90ba2aff, 0x71ff008f01123c38, 0xbbfb0fdbffb9d5e7,
        0x00bc990400dc8505, 0x00a9000a00ae9404, 0xdc5cffba9c3684ff, 0x3dff00b701123bb3, 0xbcc6aeceff3b2308, 0x00c9a60400ce0112, 0x054effba54c813ff, 0x9bff00d7050b3824,
        0x3c96cd46ff3a7178, 0x00f2011201000007, 0xf8c5a1ff00ed050b, 0x9d04b9de2b8cff39, 0xff390c432eff00fb, 0x0112a4043c4ccf3e, 0x223b8fff010d0111, 0x020dbba7448dff3a,
        0xff3aab7e06ff011b, 0x01b0ae04bb36f8e1, 0x014ca104016c020d, 0x01399d04013e9f04, 0x844dffb9ce3152ff, 0xcfff0147030b3bd7, 0xb97fef6bffbbd467, 0x0159050b015e070b,
        0xb97bff3911c43fff, 0xbdff01670111bbcb, 0x3b8c849aff38d093, 0x01828f0501909005, 0x9ad47fff017d8b05, 0x030bbb233576ff3a, 0xff3b4d3540ff018b, 0x01a200023cb68c96,
        0x847245ff019dad04, 0x9105bcdbf616ffbd, 0xff3cdeff91ff01ab, 0x01f8030bbab0e840, 0x01ca011201d89205, 0x8c776fff01c5b604, 0x00023a2778daffb9, 0xff3c025fc2ff01d3,
        0x01eab00439b2b4ef, 0x122e96ff01e5010d, 0x0112bd21e544ff3b, 0xffb9806722ff01f3, 0x021c8a05bb18d656, 0x02090112020eaf04, 0x3c13ff391d33d3ff, 0x4dff021789053ccc,
        0x3b1b3902ffbaaf73, 0x02298b05022e040b, 0x5335ffbc049defff, 0x67ff0237070e3b79, 0x3ae90dc4ffb97778, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c,
        0x0094830501208705, 0x00306d0400507b05, 0x001d080b00224804, 0x1eafffb91cc663ff, 0xb5ff002b0112b7d4, 0x3a3dce07ffb9284e, 0x003d700500427705, 0x74d6ff3927c48aff,
        0x01ff004b010e39b2, 0xbab96bf7ff39952c, 0x0066aa0400740207, 0x41ef5fff00617d05, 0x070eb8ce20d1ff3a, 0xffbb2cacdeff006f, 0x00867d053abf8db7, 0x131243ff0081010e,
        0x0111bb7e4c94ff3c, 0xffb9ab1f8bff008f, 0x00dc8505bbc8d97c, 0x00ae010a00bc000d, 0x242004ff00a90111, 0x0112bbb9dc6fffb8, 0xff3904212dff00b7, 0x00ceb1043bc009b0,
        0xc6d7e3ff00c90112, 0xb2043b9e3502ff37, 0xffbd2ca15eff00d7, 0x0100000d39e1771e, 0x00ed9e0400f2a604, 0x5e4dffb9a77e26ff, 0x23ff00fb0112bbc2, 0x3b458a9effb91d27,
        0x010d020d01128605, 0xdc8bff3a03de0eff, 0x0cff011b0112bb83, 0x3bc49186ff3810ad, 0x016c020d01b0ae04, 0x013e0002014ca104, 0x60a5a3ff01399005, 0x000dbc55c35cffba,
        0xffbabe7f51ff0147, 0x015e010d3b81b690, 0x222a2bff0159010b, 0x011139ee8c02ffbb, 0xffba57f478ff0167, 0x01909005bc1ae105, 0x017d8b0501828c05, 0x551dff3a77ba76ff,
        0x00ff018b0002bc6d, 0x3bfa078cffbb223b, 0x019d011201a20002, 0xc74eff3b9d641cff, 0xa0ff01abab04bd4b, 0x3cb26610ffba8d86, 0x01d8920501f8030b, 0x01c5020d01cab504,
        0x7064ffb9135431ff, 0x9aff01d301123b3c, 0xbc13e68cff38fa55, 0x01e5930501eab404, 0x7ebbffbacc61a5ff, 0x73ff01f301113a8d, 0xbbb2958cffb97cf2, 0x020eaf04021c040b,
        0x1dec52ff02090111, 0xb4043d5aa6b8ffbc, 0xffba984b8fff0217, 0x022e01123c108121, 0xc96295ff02290002, 0x070e3a164083ff36, 0xffbb4f7562ff0237, 0x000000133ca90b89,
        0x000003e800000005, 0x0000023c00000001, 0x0120870500000000, 0x00507b0500948305, 0x0022480400306d04, 0x19eb7cff001d070e, 0x2103ba31372dffb8, 0xff3a68d09dff002b,
        0x0042180eb8f4dd74, 0xd09df2ff003d7705, 0x2405ba281cdaff39, 0xffba929900ff004b, 0x00740207bb93266a, 0x00617d050066aa04, 0xe75cff3a1b25f1ff, 0xb2ff006fae04b8a4,
        0x3ae0258affbb005b, 0x008182050086a304, 0xb6b8ffbb92b4c7ff, 0x0aff008f000abd79, 0xbb124772ff3b05dc, 0x00bc020d00dc8505, 0x00a9011200ae9904, 0xb85aff3a4a7086ff,
        0x92ff00b7a604bbcc, 0xbabd5057ff3ace0f, 0x00c9040d00ce0111, 0xc275ff384bc039ff, 0xaaff00d7050b3b10, 0x3da2ad94ff3b7154, 0x00f2011201000007, 0xc21e10ff00ed030e,
        0x010d3a290d68ffb9, 0xff3a853e69ff00fb, 0x0112a5043c913688, 0x3c15dcff010d0111, 0x0107bb907eeaff3a, 0xff3af8499dff011b, 0x01b0ae04b9813830, 0x014ca104016c020d,
        0x01399a04013e0002, 0xbf12ff39d0c529ff, 0xebff01479e04bb29, 0x3c01248cffb8347a, 0x0159a204015e030e, 0xaadfff3c1b8571ff, 0x7aff01670112ba04, 0x3b104d81ffb94c71,
        0x0182aa0401909005, 0x8db234ff017da904, 0x8e05bc6cc188ff3a, 0xff393f5923ff018b, 0x01a200023c913d9b, 0x7bd360ff019d0111, 0x010bbd2305d6ff3b, 0xffba627140ff01ab,
        0x01f8030b3c8eb80e, 0x01ca011201d89205, 0x7abd8bff01c5020d, 0x020dba3a6c8dff38, 0xffb9b646a0ff01d3, 0x01eab0043bb29fa7, 0xeecbe1ff01e5010d, 0xb204bd003d34ff3a,
        0xffbade630bff01f3, 0x021c040bb9565f58, 0x02090007020eaf04, 0x30f9ffbc436b6bff, 0xa1ff0217000a3d40, 0xbb6e57e3ff3b231b, 0x02290112022e010d, 0x7705ff3959a3b8ff,
        0xebff02370111bb40, 0x3b7073b8ffb8f423, 0x0000000500000013, 0x00000001000003e8, 0x000000000000023c, 0x00944f0501208705, 0x00308c0400503105, 0x001d0f0400223a01,
        0x870affb9f47045ff, 0xb4ff002b4a0438b7, 0xb81eeba8ff3a5443, 0x003d011200429204, 0xfeb3ffb99acf75ff, 0x54ff004b040e3c9b, 0xb92b937affbb3003, 0x0066000200746804,
        0xe9e4dbff00616104, 0x0112ba41f6e5ff38, 0xffb944fd9eff006f, 0x008601113c870be5, 0x2898ddff0081170e, 0x00073a9d1870ffba, 0xffbb5f0362ff008f, 0x00dca5043c32a0a6,
        0x00ae920400bc9404, 0xe576feff00a99004, 0x01123a85b459ffb9, 0xffba37a778ff00b7, 0x00ce7d053b4d486c, 0x887742ff00c9070b, 0x7e053acb5467ff39, 0xffbbf287f2ff00d7,
        0x01000111b96aec89, 0x00ed7b0500f27f05, 0xf972ffb930f9abff, 0x10ff00fba804bad7, 0x3a0a65b0ffba7c77, 0x010d7d0501120002, 0x0f00ff3d501694ff, 0x68ff011b020d3bbc,
        0x3cb325f7ffbbe4cd, 0x016c020d01b0ae04, 0x013e9904014ca104, 0x90ad2cff01399604, 0x9a04bc15fd51ffb9, 0xff3bcbde6fff0147, 0x015e070bb9f428ff, 0x9a59a4ff0159030b,
        0x0111bb3a971aff39, 0xff383386a6ff0167, 0x019090053b509349, 0x017d00020182a504, 0x2d90ff3b65341dff, 0xa4ff018ba604bc01, 0xb9ca64ffff3c7eba, 0x019d910501a20002,
        0xcba2ffbcca841aff, 0xc4ff01ab01113b1c, 0x3c052110ffbc7e3b, 0x01d8920501f8030b, 0x01c5000a01ca0111, 0xa1d9ffba14fc78ff, 0xc4ff01d3b50438ee, 0xbc082ecbff3b0fde,
        0x01e5b20401eab404, 0x6b77ffb9f32bb3ff, 0xb5ff01f301113aea, 0xbb8d870affb91f7b, 0x020e0112021c040b, 0xcbe8daff02098905, 0x8905bc36ed2dffbc, 0xff3cc7cdbbff0217,
        0x022e000d3a6fdd9b, 0xb0c37dff02290112, 0x8f05bb130a93ff38, 0xffb9e90429ff0237, 0x0000001339a2a04f, 0x000003e800000005, 0x0000023300000001, 0x0117870500000000,
        0x0050780500948305, 0x0022070b00300806, 0x054691ff001d000d, 0x170e39c489cdffba, 0xff385f466eff002b, 0x0042ac04bb20a863, 0x010fceff003d1d05, 0x070ebbe16d8fffbb,
        0xffbaab68bbff004b, 0x007401113b3586ff, 0x00617e0500669204, 0xddf3ff38293be0ff, 0xe8ff006f7d053a85, 0xb986cc51ffba824c, 0x0081020d00869f04, 0x8db3ffbb1fc231ff,
        0x3fff008f00023bd8, 0x39917ab1ff3c85c8, 0x00b3020b00d38505, 0x00a9000d00aea604, 0xd164ffbb79c166ff, 0x043d057158ff3bb5, 0xff00c09b0400c59c, 0xaf0d29ffba6d47af,
        0xd8deff00ce9f04bc, 0x04b88db90dff3c19, 0x0400e9aa0400f7b2, 0xb988e166ff00e4a7, 0xf201113b3f7a32ff, 0x44ff3a5356f1ff00, 0x0d01090111bc0c7a, 0xb9dbf0c0ff010402,
        0x12010e3b17d46cff, 0x13ffbc079214ff01, 0x0b01a7010e3c498a, 0x0d0143b404016301, 0xff01309d04013501, 0x06cdbaff3a767870, 0xa62cff013e8c05bb, 0x12bc131149ffbb21,
        0xff0150000a015501, 0x80b83effba66331e, 0x8b78ff015e01073a, 0x043b9a9d20ff3c73, 0x040179a7040187a9, 0x39ffed8aff0174a6, 0x820111bb53a571ff, 0x09ff3a302ac0ff01,
        0x04019989053c5438, 0x3b1b57f9ff0194b2, 0xa20112bb8e1b31ff, 0x5cff393eb64eff01, 0x0201efa404bac3d9, 0x0e01c1020b01cf00, 0x3cc941f8ff01bc03, 0xca010a3b227367ff,
        0x51ff3a30f543ff01, 0x0501e10007bbe633, 0xbb20d205ff01dc88, 0xea0111b8310598ff, 0xd2ffb8fa1220ff01, 0x0b0213a804bbb210, 0xff02008b05020507, 0x003e45ffbb47a342,
        0x964bff020e8905ba, 0x11b8a0eadbff3bce, 0xff0220b604022501, 0x810686ffb90d9a52, 0x3d13ff022eb40439, 0x133ce07173ff3a91, 0xe800000005000000, 0x3c00000001000003,
        0x0500000000000002, 0x0400945a05012087, 0x040030010e00506a, 0xff001d3904002259, 0x01d389ffb8e8d893, 0xa3a8ff002b4f013a, 0x01b9ae472aff39a3, 0xff003d660400424f,
        0x095bc7ffb6d76d5e, 0x36d6ff004b01113b, 0x04bbbad6bcffb898, 0x120066080e007479, 0xba0bcc8cff006101, 0x6f01123be49f6cff, 0x15ffb9e10fe2ff00, 0x0e00865605bc63be,
        0xb9a7a21fff008104, 0x8f01123a16fb23ff, 0x9cffba401ad8ff00, 0x0500dc0112bc5ca1, 0x0400aeae0400bc72, 0xb910174bff00a96d, 0xb7af04ba2687b0ff, 0x9dffbb386668ff00,
        0x0500ce9e043aa079, 0xb706620cff00c97d, 0xd7a70439ee4c56ff, 0x24ffba8ffa17ff00, 0x070100020d37e635, 0xff00eda10400f202, 0x2b5fd9ffbaa3788b, 0xefcdff00fb96043c,
        0x013abd4fa8ffbc4b, 0xff010d070e01124f, 0xe7efdfffbbb90d01, 0xb768ff011b040bbc, 0x0e3c9367f4ff3b72, 0x04016c010b01b001, 0x04013e010d014cb4, 0x3a452d18ff01399d,
        0x47b204bad7af7bff, 0x40ffbbcd28c1ff01, 0x04015e01123b3a5e, 0x3a633e54ff0159b7, 0x670107ba789b54ff, 0xc0ff3c42d5f8ff01, 0x040190a9043b7761, 0xff017d010a0182a8,
        0xcc9e5cffb6a85eaf, 0x4863ff018b01123b, 0x053c7bf3edff3991, 0xff019d030b01a289, 0xe9a8cfff3b82a3cf, 0x7c52ff01ab8a05ba, 0x04380d3bbeffbbb1, 0x0401d8000201f8a4,
        0xff01c59a0401ca9c, 0xc33d99ff3a57f4d2, 0x972eff01d30111bb, 0x073ba957cfffb950, 0xff01e5020d01ea00, 0xb12ee6ffb969594b, 0x7f2cff01f3030bbb, 0x0aba954840ffbb99,
        0x02020e0112021c00, 0xb9f5262eff020900, 0x17b40439aefea8ff, 0xf4ff3b24c3f4ff02, 0x11022e00023cb38d, 0x39378fe4ff022901, 0x3701123ba75d4dff, 0xe6ffb8da143fff02,
        0x0500000013bb3e6b, 0x01000003e8000000, 0x0000000233000000, 0x0501178705000000, 0x0e00506305009483, 0x0400228004003014, 0xb70bb8a9ff001d71, 0x2b011238eaeddeff,
        0xceffba3532bbff00, 0x01004201123b32f4, 0x3a258552ff003d4e, 0x4b8e04ba447cbeff, 0x74ffbc39fdf5ff00, 0x0700740002bad781, 0xff00618205006602, 0xf89867ffb80f4fe0,
        0x6aabff006f660539, 0x04ba3fd6d3ff3bb9, 0xff0081990400869d, 0xe92f8cffbadc8a70, 0x0184ff008f01123a, 0x053b4ae3beffb91d, 0x0400b3020b00d385, 0xff00a9000a00aea6,
        0x2c98a4ffba5898ef, 0x050b3ccf70c0ff3c, 0x3cff00c0030b00c5, 0xbbd5537cff39b346, 0x1eb8d8ff00ce0111, 0x00073baa5d0affb9, 0x011200e9000200f7, 0xff39b43334ff00e4,
        0x00f2010a3b695aa9, 0x6ca8ffbad23411ff, 0x00020109020d3bd7, 0xff3a14fcdbff0104, 0x01120112babd02e0, 0xde80ff3ab9f579ff, 0x020d01a7ae04bc5b, 0x00020143a1040163,
        0xedff013001120135, 0xbb20d8a3ff39a0e9, 0x6950ecff013e9e04, 0x010d3bd5c667ff39, 0xb2ff0150010b0155, 0x398c3f12ffbae658, 0x67b632ff015e8805, 0x0107bb1fd4fcff3b,
        0x001101799a040187, 0xff3989028eff0174, 0x0182a2043c3f4808, 0xf3c6ffbbe8b0e5ff, 0x01110199ad04b993, 0xffbb3b4f18ff0194, 0x01a20112bbca5cd0, 0xdda8ffbb802b64ff,
        0x920501ef030b3ddb, 0xb60401c1011201cf, 0xffb98a4fd5ff01bc, 0x01ca020d3a01577f, 0x7680ffba15a32fff, 0x930501e1b4043b98, 0xffba8775fcff01dc, 0x01ea01123a7c7f4e,
        0xb912ffb91d7b2bff, 0xb20402138a05bb92, 0x9cff0200010d0205, 0x3be35719ffb7e6b8, 0x8dd9eaff020e0111, 0x040bbc57cc10ff39, 0xdcff02208b050225, 0x3b1d3049ffbbcee3,
        0x130042ff022e070e, 0x00133a8e6978ffb9, 0x03e8000000050000, 0x023c000000010000, 0x8705000000000000, 0x7b05009483050120, 0x011200306a050050, 0x3fff001d23040022,
        0xb9806e8eff391467, 0x572cd8ff002b0007, 0x00023ad1c516ffba, 0xb1ff003d050e0042, 0xba66a57aff3a5827, 0xfc7d06ff004b9904, 0x02073ab186a8ffba, 0x0111006681050074,
        0xffb926f629ff0061, 0x006f010a3ad64b58, 0x91eeffb7e53f35ff, 0x7c050086040bbbc5, 0xff3b8ec472ff0081, 0x008f0112bb6f53fa, 0x6446ffba4f652bff, 0xb10400dc85053b8d,
        0xa90400aeaa0400bc, 0xffb8ae092bff00a9, 0x00b7020dbbfd8f13, 0xafedffb96df128ff, 0xb40400ce01123c29, 0xffba173722ff00c9, 0x00d7010e3a89b1d4, 0xaa70ffbd50c9efff,
        0x000a0100030b3b7a, 0x20ff00ed010700f2, 0xbb819c2dff3ab33b, 0x87e889ff00fb000d, 0x090b3b531594ffb8, 0x72ff010d010a0112, 0xbceabfb2ffbb1d54, 0x83937eff011b0002,
        0x010ebaeda2ceff3a, 0xb404016c010b01b0, 0x000a013e010d014c, 0xffbac8620dff0139, 0x01478c0539334187, 0xe368ffba5bc514ff, 0xb704015e0112bbd2, 0xff3a38b4fbff0159,
        0x01670107ba4a4240, 0xdda0ff3c2a8a78ff, 0x01120190a9043b1c, 0x80ff017da6040182, 0x3a841927ffba8d00, 0x663e5bff018b040b, 0x89053bb11e61ffb8, 0x47ff019d880501a2,
        0x3b6d5c00ffbafb6c, 0x4de20cff01ab0112, 0xa404ba9fd006ff39, 0x020b01d8000201f8, 0x30ff01c5000d01ca, 0x3ca3ecf4ff3b0d71, 0x0cc90fff01d3010a, 0x0007bbc74f20ff3a,
        0xbdff01e58c0501ea, 0xbaeb0d8cff3a45f1, 0x06224dff01f30111, 0xa804bb76ff57ff3a, 0x0112020e070b021c, 0xff38140a18ff0209, 0x02170111bb1761b6, 0x9ce5ffb98829cfff,
        0x0112022eb0043b59, 0xffb971f7e4ff0229, 0x023701113b5dcaf4, 0x3f24ff3832d737ff, 0x000500000013baf9, 0x0001000003e80000, 0x00000000023c0000, 0x5a05012087050000,
        0x6604005069040094, 0x080e002201120030, 0xffb890233eff001d, 0x002b65043a00efd4, 0x0424ff38140052ff, 0x010d0042020dbc1c, 0xffba16d504ff003d, 0x004b0112bbe4c685,
        0x91ecffb9dcf25fff, 0x011200746a043cbf, 0xd8ff00613c010066, 0xb9f5e2daff389c61, 0x5d3c5dff006f010e, 0x580538ba2fa6ffbc, 0x33ff0081050b0086, 0x3ab9e26effb8c150,
        0x03c1b1ff008f0112, 0x0112bbc0cd0bffba, 0x000a00bca90400dc, 0x18ff00a9070d00ae, 0xbac0fd80ffb7e58b, 0x67505eff00b79004, 0xad04ba5ac36effb9, 0x76ff00c97f0500ce,
        0x3aaff51dff39960c, 0x35a10eff00d7000a, 0x020d398e2379ffba, 0x8c0400f202070100, 0xffbb0e830bff00ed, 0x00fb95043b656896, 0x67a4ffbc22e011ff, 0x050b0112030e3a17,
        0xff3b2ad1ecff010d, 0x011b41013c7bf78e, 0x5779ffbd7606b4ff, 0x020d01b0ae04bc9b, 0x0002014ca104016c, 0x0cff01399005013e, 0xbc203a9bffba0e28, 0x3fd45cff0147000d,
        0x010a3b2a2151ffba, 0x85ff0159a404015e, 0xb9a48fc7ff3a955c, 0x520c86ff0167ac04, 0xaa04bb394864ff3b, 0x8d050182a9040190, 0xffb9deddd7ff017d, 0x018b01123bbe2f4d,
        0xc165ff3b91b303ff, 0x000201a2ab04bd91, 0xff3cf00a76ff019d, 0x01ab0002bac5134d, 0x5b43ffbbb55b78ff, 0x930501f8030b3bde, 0x020d01cab10401d8, 0xff38c5ad5fff01c5,
        0x01d3b2043bd75c09, 0x30d7ffbb34fde0ff, 0x020d01eab4043993, 0xffba1ddbe8ff01e5, 0x01f301113c5c517c, 0xc0d6ffb92a536eff, 0x0002021c040bbbf4, 0x65ff02090112020e,
        0x3d48ea19ffbc4466, 0xdb8abeff0217b404, 0x000d3bdc4263ffba, 0x6fff02290111022e, 0xbb0bfb3bff38ac7a, 0x94bd93ff02378f05, 0x0013398de789ffb9, 0x03e8000000050000,
        0x023c000000010000, 0x8705000000000000, 0x7204009470050120, 0x4c010030010a0050, 0x40ff001d6a040022, 0xbac52a67ffb90265, 0x188af4ff002b0002, 0x01123b063392ffb9,
        0x4aff003d14040042, 0xb97807c6ff39211d, 0xa1c376ff004b2701, 0x75043bc075feff3a, 0x1e01006601120074, 0xffbab78b7dff0061, 0x006f010eba04852c, 0x791eff3b6e905bff,
        0x130e00863001bc18, 0xff3bb13eb0ff0081, 0x008f3101bada8b5a, 0xb468ff3c16356aff, 0x940400dc010b391d, 0x011200ae500400bc, 0xffba154602ff00a9, 0x00b70112bc6e9c64,
        0xdd68ff3885dd07ff, 0x010e00ce71053b82, 0xff3d902b18ff00c9, 0x00d773053b02c983, 0x620bffbd06eb7cff, 0xae0401007e05bb8e, 0xc5ff00ed010a00f2, 0x3b5af5e6ffb9a2ab,
        0x5ddfd9ff00fb0111, 0x80053c455e4fffba, 0xccff010d01070112, 0xbb03862dff3ab372, 0x2c40bdff011ba404, 0x010eb969452cffb9, 0xb404016c010b01b0, 0x9d04013e010d014c,
        0xff39ec9dd8ff0139, 0x01470012ba8b4e30, 0x1128ff3bd934e9ff, 0x000a015e0111bb8c, 0xffba33cd32ff0159, 0x016701073a33baf7, 0xbe40ff3c20e878ff, 0x99040190a9043b0a,
        0x77ff017d94040182, 0xbc181970ff3a2b29, 0x0fddc4ff018b9a04, 0x890539010c74ff3c, 0x52ff019d010d01a2, 0x3b47e01dffbaf841, 0x904f88ff01ab8a05, 0xa40438080573ffbb,
        0x010a01d8000201f8, 0x62ff01c5900401ca, 0x3a788b17ffbb0bff, 0x0b7ac7ff01d38805, 0x020b3bf2f860ffbd, 0x49ff01e5010b01ea, 0xbc498b7bffbaa8da, 0xa58906ff01f30007,
        0x070ebb2ee032ff39, 0xa604020ea704021c, 0xff39e7b99cff0209, 0x0217000abac991cb, 0x8b03ff39df3b50ff, 0x000d022e0111b979, 0xffb9869954ff0229, 0x0237030b3ad8fc7b,
        0xbd40ffba91f6f1ff, 0x0005000000133c93, 0x0001000003e80000, 0x00000000023c0000, 0x7005012087050000, 0x6f04005072040094, 0x6605002266040030, 0xffb813cbdfff001d,
        0x002b020dba127ffe, 0xa4b6ffb9c58a25ff, 0x090b004201123ae3, 0xffba2668f3ff003d, 0x004b020e377e5dc5, 0x71d1ff3c3e3807ff, 0x000d0074050bbb83, 0x83ff0061010a0066,
        0x3a5e45caffbb1fdb, 0x29eb95ff006f020b, 0x01123ab743c8ffba, 0xc9ff0081170e0086, 0x3a6052fbffba0170, 0x9ce29bff008f010d, 0x010b3ccf355dff3b, 0x011200bc710500dc,
        0x8bff00a9000a00ae, 0xbb1acad1ff39cdaf, 0x23ab68ff00b7010e, 0x01073c66e783ff3d, 0xd5ff00c9570400ce, 0xb85baa10ffbb71d7, 0xdab0dbff00d7ad04, 0x7e053c3cde53ffbb,
        0x010a00f2ae040100, 0xffb982230cff00ed, 0x00fb01123b2f2b23, 0xe511ffba317fdaff, 0x0107011280053c1d, 0xff3a8f8f00ff010d, 0x011ba404bad27048, 0x9dadffb909cd27ff,
        0x010b01b0010eb93a, 0x8a05014cb404016c, 0x54ff0139000a013e, 0xba3f29c4ff3b1734, 0x495632ff0147000a, 0x01113a058030ffbb, 0x84ff0159b504015e, 0xb9494ae7ff3aeb59,
        0xdd2167ff01670207, 0xa904ba95f755ff3b, 0xa604018201110190, 0xffba853348ff017d, 0x018b8b053a4368c7, 0x3453ff3b708a51ff, 0xac0401a28905ba47, 0xffbb71ea50ff019d,
        0x01ab01123ace0f90, 0xf778ff39049935ff, 0x000201f8a404ba5f, 0x9a0401ca9c0401d8, 0xff3a42880cff01c5, 0x01d30111bb9ed0b0, 0x04cdffb9dd09abff, 0x020b01ea01073b85,
        0xffbb25f3a2ff01e5, 0x01f39d04b922e83b, 0x9f27ffbae49b48ff, 0xa704021c070ebbdf, 0x4dff0209a604020e, 0xbaa1417bff39b961, 0x3e9b84ff0217ae04, 0x0111b8b77c9cff3a,
        0x08ff0229b404022e, 0x39e566b7ffb9ccbb, 0x3483b7ff02370007, 0x0013bbd56529ff3c, 0x03e8000000050000, 0x023c000000010000, 0x8705000000000000, 0x7204009470050120,
        0x4b0100304f010050, 0x24ff001d01120022, 0xb95429d8ff378fbb, 0x4ef1a3ff002b7104, 0x00023c2dc699ff3a, 0x49ff003d49050042, 0x38b2ced0ffbadba1, 0x1533feff004b0111,
        0x75043c40b037ffba, 0x3805006674040074, 0xff3a593ac3ff0061, 0x006f010ebaa71f68, 0x1f26ff3bac3dc2ff, 0x130e00863001bba4, 0xff3b8b185fff0081, 0x008f3101bab28f89,
        0x96adff3bebba54ff, 0xa20400dc010b38e6, 0x020700ae9f0400bc, 0xffb9860717ff00a9, 0x00b7010ebc302275, 0x93f3ff3cff4b21ff, 0x000a00ce010abbba, 0xffbc702a2cff00c9,
        0x00d702073c404e81, 0x29a5ffbca2d095ff, 0xae0401007e05baeb, 0xa1ff00ed770500f2, 0xb9d6bb96ff39ca4f, 0x0dffdcff00fb0111, 0x80053bfca1b5ffba, 0x5dff010d030e0112,
        0xba92cb3fff3a9d06, 0x259067ff011b9004, 0x010e371c643affba, 0xb204016c010b01b0, 0x9d04013eb004014c, 0xff3a4b85c9ff0139, 0x01478905baa0ea4b, 0xf7cbff3bbc0e4bff,
        0x010d015e0207bc45, 0xffb9694e81ff0159, 0x0167b4043b42c527, 0xf137ffbb676dfcff, 0xa8040190a904b996, 0xddff017d020b0182, 0xb941ee7fff3ba397, 0x2029b6ff018b0002,
        0x89053c78f557ff3a, 0x00ff019d020701a2, 0xbb1734adff3b1aa6, 0xd42878ff01ab0112, 0xa404ba332c69ff38, 0x9b0401d8a30401f8, 0xf8ff01c59a0401ca, 0xbbd229f3ffb818b6,
        0x052d5aff01d38805, 0x030b3a9d5b8fffbb, 0x97ff01e5011201ea, 0xbc0c29bbffb96a7a, 0x5ba8cfff01f30111, 0x070e3b6d14aeffba, 0x8b05020ea704021c, 0xffbac7af72ff0209,
        0x0217000a38dbebbc, 0xf1e6ff39a72c83ff, 0x000d022e0111b956, 0xffb94007faff0229, 0x023700073ab7d35a, 0xb751ff3c106965ff, 0x000500000013bbaa, 0x0001000003e80000,
        0x00000000023c0000, 0x4f05012087050000, 0x0d06005032050094, 0x060d00221c050030, 0xffb9a5d3c8ff001d, 0x002b140e3a134bec, 0xa735ff39df2ba3ff, 0x050d00420005bb31,
        0xff3b5dc032ff003d, 0x004b0d0e3c2dafb5, 0x434bffbb82655bff, 0x010a0074000d3b40, 0x7eff006101110066, 0xbafb9de0ff387a6d, 0x5f60e1ff006f0111, 0x01113b87856fffb9,
        0x6aff008175040086, 0xba5f63a8ffb8e0ad, 0xe361e5ff008f7504, 0xa5043c4392f1ff3a, 0x920400bc940400dc, 0x33ff00a9900400ae, 0x3a78c56effb9857c, 0x944a0bff00b70112,
        0x7d053b301e16ffb9, 0x98ff00c9070b00ce, 0x3aac81aeff393ce5, 0xbd1ae1ff00d77e05, 0x0112b9bc89cdffbb, 0x020e00f27f050100, 0xffba8bf865ff00ed, 0x00fb8305b810ab9b,
        0x87b0ff3a684e30ff, 0xa90401120002b875, 0xff3cd01a30ff010d, 0x011b000abc29e1b9, 0xd495ff3bfb853aff, 0x010b01b0010ebc23, 0x010d014cb204016c, 0x30ff01390002013e,
        0x3999f819ffbb00a6, 0x73669fff01470207, 0xb6043b9671cbffbb, 0x8cff0159010d015e, 0x3b9e0ed3ffb8f77f, 0xe23db7ff0167000a, 0x010d39ad2d9effba, 0x01120182010a0190,
        0xff387e48daff017d, 0x018b0112ba6f2730, 0x611fff39324a76ff, 0x011201a2b4043bca, 0xffba6d4049ff019d, 0x01ab01113b9fe41d, 0xf9f5ffb78bd955ff, 0x000201f8a404bbab,
        0x020b01ca010a01d8, 0xff3b71615aff01c5, 0x01d38805399f41d0, 0xa6c2ffbcded166ff, 0x011101ea000a3bab, 0xff3a8ce807ff01e5, 0x01f38905bb21578a, 0x6d14ff3b2d34b1ff,
        0xa704021c070eba52, 0xbdff0209000a020e, 0xbaaa5dbdff393afd, 0x1ba522ff02178f05, 0x011139853caeffb9, 0x06ff0229b404022e, 0x39cab953ffb99d4d, 0x02553fff0237030b,
        0x00133c4a6aa5ffbb, 0x03e8000000050000, 0x023c000000010000, 0x8805000000000000, 0x7b05009486050120, 0x97040030010e0050, 0xf5ff001d8a040022, 0xbaa8bf1dff3910f0,
        0xc17412ff002b010d, 0x6605baec8226ff3b, 0x8cff003d010a0042, 0x39d6d780ffb9280c, 0xb9ceecff004b6705, 0x000dba343934ff3b, 0x01120066a7040074, 0xff393bd82aff0061,
        0x006fa804bb276f02, 0xf0f1ff3ba3ce11ff, 0x7d0500860112394a, 0xffba81e41dff0081, 0x008fa904397e27a4, 0xb653ff3b067d1fff, 0x000200dc0107bc05, 0x010a00ae011200bc,
        0xffb97cbc71ff00a9, 0x00b7010a3b152b75, 0x9d6fff3c2d403bff, 0x050b00ceb104bc47, 0xff392e13a7ff00c9, 0x00d70111bb142161, 0xe4acffba9236c3ff, 0x0002010001123cd3,
        0xaaff00eda00400f2, 0xba50b588ff3b6602, 0xb19966ff00fb8705, 0x030bb83c0d8cff3a, 0x54ff010d9f040112, 0xbab99b7dffbc422b, 0x936f21ff011baa04, 0x020bbbdb7062ffbc,
        0x9304016c9b0401b0, 0x000d013e0012014c, 0xff3a1b5693ff0139, 0x014700023b89c31b, 0xbbaeffbc0db0dcff, 0x0002015e000dbc43, 0xff3b8dbda0ff0159, 0x01679504bbdb5de8,
        0xdbc8ff3bf78c30ff, 0x00020190040d3d3f, 0x5bff017da7040182, 0xb9df912dffbbf98d, 0x4c2c83ff018b0107, 0x070dba050e52ff3a, 0xb5ff019da90401a2, 0xbb80df02ffbb5b55,
        0xa1ee94ff01aba604, 0x020dbc292850ffbb, 0x000701d89d0401f8, 0x4dff01c59c0401ca, 0x3b82c2c1ffb9f3a6, 0xcdc4f8ff01d38b05, 0x9f04bc3c0435ffba, 0xe6ff01e5011201ea,
        0x3c5b7ad2ffbb72d3, 0xd201a0ff01f3000d, 0x0002b937b659ff38, 0x0111020ea604021c, 0xffbabd2924ff0209, 0x0217a7043c56426c, 0x9c8effbc9e917fff, 0x0111022ea104b9f6,
        0xff3b156680ff0229, 0x02370112bd6b24ea, 0x4563ffba472ef9ff, 0x0005000000133ba6, 0x0001000003e80000, 0x00000000023c0000, 0x8b04012087050000, 0x880400507d050094,
        0x6b05002272050030, 0xffb8317edeff001d, 0x002b740539ca54fe, 0xefb5ffbb029b52ff, 0x01120042010b3a1a, 0xffb91b56efff003d, 0x004b0112bcff16b3, 0x098affb9626ab2ff,
        0x8005007401123bf4, 0xb5ff0061010e0066, 0x3a4e0b00ffb99f0e, 0x754374ff006f0002, 0x7e053af0a92aff3a, 0xbdff0081010d0086, 0xbcf4eb0dffbbf09a, 0x484289ff008f020d,
        0x86053bd18db5ffbb, 0x490100bc8c0400dc, 0x0eff00a9000d00ae, 0x3c53c719ffbb1574, 0x97c685ff00b70112, 0x8005bc8d6025ffb9, 0xb1ff00c95d0500ce, 0x39d50cfdffb64a92,
        0x4e2634ff00d7030b, 0x000db9d76732ff39, 0xb50400f201120100, 0xff39703746ff00ed, 0x00fbb1043b9a52a9, 0x6528ffbbbc8e9bff, 0xae04011201123b9f, 0xffb9c6bcd7ff010d,
        0x011b01073aef5e02, 0xedf8ff3c3c55fcff, 0x010b01b0010ebb06, 0xb004014cb204016c, 0x3bff01399205013e, 0xbb2c5b4cffb90532, 0x135a00ff01470207, 0x01073b775d15ffbc,
        0x0bff01590112015e, 0x3b4ad48eff38a115, 0xd97ae6ff0167b404, 0x010d39897044ffba, 0x00070182030b0190, 0xff3ad22b20ff017d, 0x018b040bb9f72053, 0x8d2cffbbaee47aff,
        0x011101a2b4043822, 0xffba1bb835ff019d, 0x01ab01113b693538, 0x3caeff38c8bf18ff, 0xa30401f8a404bba0, 0x9a0401ca9b0401d8, 0xffb8344f82ff01c5, 0x01d38805bba2cb6d,
        0xa6b3ffbacc23f8ff, 0x011201ea030b3a5c, 0xffb99be193ff01e5, 0x01f30111bbd92fc0, 0xba5bffba469ab3ff, 0x8905021c040d3b42, 0x69ff02090111020e, 0xbafae250ff391365,
        0x6991d4ff0217a704, 0x000238e399d9ffb9, 0x38ff0229a904022e, 0x3bb011fdff3bd927, 0x07e736ff0237ab04, 0x0013bb9657d3ffbb, 0x03e8000000050000, 0x023c000000010000,
        0x8705000000000000, 0x7d0500948b040120, 0x7905003088040050, 0x05ff001d86040022, 0x3af38562ffb83c1f, 0x163864ff002b7a05, 0x010db9f544beff3b, 0xc0ff003d070e0042,
        0x3a7faf22ffbb60df, 0xd19bd6ff004b0111, 0x01113c97da81ffb9, 0x010e006680050074, 0xffb97e7de8ff0061, 0x006f83053a24d595, 0xee82ff3aa25f9cff, 0x7e050086000a39fb,
        0xffbc512ba2ff0081, 0x008f000dbb1b7eeb, 0x539cffbb798b3bff, 0x7d0500dc86053c43, 0x010a00ae010e00bc, 0xffba556d88ff00a9, 0x00b7030b3bac8544, 0xbc7bffb8cc3715ff,
        0x7f0500ce010b3a1a, 0xffbc78e717ff00c9, 0x00d78505b9b6159f, 0xe384ffb93058c5ff, 0x011201008f04ba13, 0x3cff00ed8e0400f2, 0xbb338a80ff3a0865, 0xedc854ff00fb000a,
        0x000dbb7760d0ff3c, 0x44ff010d01120112, 0xbb9ed9adff397372, 0xc82b04ff011b010e, 0x010e3b7be11dff38, 0x9005016c010b01b0, 0x010a013ea304014c, 0xff3ab7065eff0139,
        0x01470207bb9f5f36, 0xbc43ffbb2d6a33ff, 0xa704015e010a3a0a, 0xffbae77ca0ff0159, 0x0167000239e73770, 0x3510ffb9a72c60ff, 0xa3040190010d3ba8, 0xaeff017d00020182,
        0x3b09f376ffbaca6e, 0xde7632ff018ba404, 0xaa04b9242520ff3b, 0x19ff019da90401a2, 0xbc5b6d9dffb868b2, 0x8296dbff01abb104, 0xa404b9cb5cefff3b, 0x900401d8000201f8,
        0xbeff01c5011201ca, 0xbbc20f6aff3a3e97, 0x0a2c8eff01d39504, 0x9d0438bfce21ff3b, 0x2fff01e5020b01ea, 0x39f40438ffbaf135, 0x2a4c72ff01f3030b, 0xa60438dac0c8ffbb,
        0x030e020e010a021c, 0xff3c1a0d10ff0209, 0x02170112ba6a1855, 0xe4bdffbb4722c5ff, 0x030b022eac043c9c, 0xff3ab32e46ff0229, 0x02370112b997bf0a, 0xde42ffb8b1e47aff,
        0x000500000013b923, 0x0001000003e80000, 0x00000000023c0000, 0x4f05012087050000, 0x0a0b005032050094, 0x0305002200020030, 0xffb9ed4bcaff001d, 0x002b070637914249,
        0xae79ff3b11a911ff, 0x8d0400423801bb05, 0xffb81ef43dff003d, 0x004b01123b9f4e45, 0x65ffffb941d49aff, 0x010b0074000d3b6b, 0xc4ff006101120066, 0xbb9ba168ffb8b2b3,
        0x7b5ff3ff006f0207, 0x0111ba1af10aff36, 0x1bff008175040086, 0xba3d4832ffb8b935, 0xe36fc4ff008f0a0e, 0xa5043c80f8cfff3a, 0x920400bc940400dc, 0x3fff00a9900400ae,
        0x3a505940ffb95651, 0x3314ddff00b7020d, 0x7d053b35b0fcffb9, 0xc6ff00c9080b00ce, 0x3a687256ff389d1d, 0x863b45ff00d79904, 0x011138da2863ffbb, 0x000200f2a8040100,
        0xffba547cbbff00ed, 0x00fbb4043966a666, 0x54c0ff38d9424bff, 0x0002011275053a96, 0xff3d7c0c27ff010d, 0x011b070e3ba1deea, 0xdff2ffbb06db23ff, 0x020d01b0ae043c77,
        0x9f04014ca104016c, 0x9bff01399c04013e, 0x3ad3d41dffb9f15b, 0x001837ff0147a004, 0x9305370f0322ffbc, 0x92ff01599005015e, 0x39f0422cff3825c8, 0x058738ff0167ac04,
        0x0107bc8aa93eff3a, 0xaa040182ab040190, 0xffba7a389fff017d, 0x018b00023b557fa3, 0xb5b3ffbc04a80aff, 0xab0401a2ad043b98, 0xffbb0afb70ff019d, 0x01ab0111bbc34ad5,
        0xebacffbb94f768ff, 0x930501f8030b3da8, 0x000a01ca011201d8, 0xffb9e03d8cff01c5, 0x01d30002397ffe28, 0xf4d9ff3b862492ff, 0x020d01eab404390d, 0xffba0a902eff01e5,
        0x01f301123c394cb7, 0x4967ffb92cdefcff, 0x0112021c040bbbcd, 0x3eff02098905020e, 0xbbeeb1eaffbcb07e, 0x918733ff0217b004, 0x000dbacd1b21ff3b, 0x9eff02290112022e,
        0xbb20b18cff37d1dd, 0x1bfcf9ff02378f05, 0x0000399f9854ffb9
};

const std::vector<uint64_t> &get_model_xehpc_dw_data() {
    static std::vector<uint64_t> data(
            _data, _data + sizeof(_data) / sizeof(_data[0]));
    return data;
}
// clang-format on

} // namespace jit
} // namespace conv
} // namespace intel
} // namespace gpu
} // namespace impl
} // namespace dnnl
