"use strict";
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateProperty = void 0;
/**
 * Validate a property as being on an object, and optionally
 * of a given type and among a given set of values.
 */
function validateProperty(object, name, typeName, values = []) {
    if (!object.hasOwnProperty(name)) {
        throw Error(`Missing property '${name}'`);
    }
    const value = object[name];
    if (typeName !== void 0) {
        let valid = true;
        switch (typeName) {
            case 'array':
                valid = Array.isArray(value);
                break;
            case 'object':
                valid = typeof value !== 'undefined';
                break;
            default:
                valid = typeof value === typeName;
        }
        if (!valid) {
            throw new Error(`Property '${name}' is not of type '${typeName}'`);
        }
        if (values.length > 0) {
            let valid = true;
            switch (typeName) {
                case 'string':
                case 'number':
                case 'boolean':
                    valid = values.includes(value);
                    break;
                default:
                    valid = values.findIndex(v => v === value) >= 0;
                    break;
            }
            if (!valid) {
                throw new Error(`Property '${name}' is not one of the valid values ${JSON.stringify(values)}`);
            }
        }
    }
}
exports.validateProperty = validateProperty;
//# sourceMappingURL=validate.js.map