#ifndef OT_LAYOUT_GPOS_PAIRPOS_HH
#define OT_LAYOUT_GPOS_PAIRPOS_HH

#include "PairPosFormat1.hh"
#include "PairPosFormat2.hh"

namespace OT {
namespace Layout {
namespace GPOS_impl {

struct PairPos
{
  protected:
  union {
  struct { HBUINT16 v; }        format;         /* Format identifier */
  PairPosFormat1_3<SmallTypes>  format1;
  PairPosFormat2_4<SmallTypes>  format2;
#ifndef HB_NO_BEYOND_64K
  PairPosFormat1_3<MediumTypes> format3;
  PairPosFormat2_4<MediumTypes> format4;
#endif
  } u;

  public:
  template <typename context_t, typename ...Ts>
  typename context_t::return_t dispatch (context_t *c, Ts&&... ds) const
  {
    if (unlikely (!c->may_dispatch (this, &u.format.v))) return c->no_dispatch_return_value ();
    TRACE_DISPATCH (this, u.format.v);
    switch (u.format.v) {
    case 1: return_trace (c->dispatch (u.format1, std::forward<Ts> (ds)...));
    case 2: return_trace (c->dispatch (u.format2, std::forward<Ts> (ds)...));
#ifndef HB_NO_BEYOND_64K
    case 3: return_trace (c->dispatch (u.format3, std::forward<Ts> (ds)...));
    case 4: return_trace (c->dispatch (u.format4, std::forward<Ts> (ds)...));
#endif
    default:return_trace (c->default_return_value ());
    }
  }
};

}
}
}

#endif  // OT_LAYOUT_GPOS_PAIRPOS_HH
