// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TraceEntry Trace event
//
// # Configure a trace event
//
// swagger:model trace_entry
type TraceEntry struct {

	// Trace parameters
	// Required: true
	// Min Length: 1
	Trace string `json:"trace"`
}

// Validate validates this trace entry
func (m *TraceEntry) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTrace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TraceEntry) validateTrace(formats strfmt.Registry) error {

	if err := validate.RequiredString("trace", "body", m.Trace); err != nil {
		return err
	}

	if err := validate.MinLength("trace", "body", m.Trace, 1); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this trace entry based on context it is used
func (m *TraceEntry) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TraceEntry) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TraceEntry) UnmarshalBinary(b []byte) error {
	var res TraceEntry
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
