// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Consul Consul server
//
// Consul server configuration
// Example: {"address":"127.0.0.1","enabled":true,"id":"0","port":90,"retry_timeout":10}
//
// swagger:model consul
type Consul struct {
	// address
	// Required: true
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Address *string `json:"address"`

	// Name of the defaults section to be used in backends created by this service
	Defaults string `json:"defaults,omitempty"`

	// description
	Description string `json:"description,omitempty"`

	// enabled
	// Required: true
	Enabled *bool `json:"enabled"`

	// Defines the health check conditions required for each node to be considered valid for the service.
	//   none: all nodes are considered valid
	//   any: a node is considered valid if any one health check is 'passing'
	//   all: a node is considered valid if all health checks are 'passing'
	//   min: a node is considered valid if the number of 'passing' checks is greater or equal to the 'health_check_policy_min' value.
	//     If the node has less health checks configured then 'health_check_policy_min' it is considered invalid.
	// Enum: ["none","any","all","min"]
	// +kubebuilder:validation:Enum=none;any;all;min;
	HealthCheckPolicy *string `json:"health_check_policy,omitempty"`

	// health check policy min
	HealthCheckPolicyMin int64 `json:"health_check_policy_min,omitempty"`

	// Auto generated ID.
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	ID *string `json:"id,omitempty"`

	// mode
	// Enum: ["http","https"]
	// +kubebuilder:validation:Enum=http;https;
	Mode *string `json:"mode,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// namespace
	Namespace string `json:"namespace,omitempty"`

	// port
	// Required: true
	// Maximum: 65535
	// Minimum: 1
	// +kubebuilder:validation:Maximum=65535
	// +kubebuilder:validation:Minimum=1
	Port *int64 `json:"port"`

	// Duration in seconds in-between data pulling requests to the consul server
	// Required: true
	// Minimum: 1
	// +kubebuilder:validation:Minimum=1
	RetryTimeout *int64 `json:"retry_timeout"`

	// server slots base
	ServerSlotsBase *int64 `json:"server_slots_base,omitempty"`

	// server slots growth increment
	ServerSlotsGrowthIncrement int64 `json:"server_slots_growth_increment,omitempty"`

	// server slots growth type
	// Enum: ["linear","exponential"]
	// +kubebuilder:validation:Enum=linear;exponential;
	ServerSlotsGrowthType *string `json:"server_slots_growth_type,omitempty"`

	// service allowlist
	ServiceAllowlist []string `json:"service_allowlist,omitempty"`

	// service denylist
	ServiceDenylist []string `json:"service_denylist,omitempty"`

	// Regular expression used to filter services by name.
	ServiceNameRegexp string `json:"service_name_regexp,omitempty"`

	// token
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Token string `json:"token,omitempty"`
}

// Validate validates this consul
func (m *Consul) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEnabled(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHealthCheckPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRetryTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerSlotsGrowthType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServiceAllowlist(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServiceDenylist(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateToken(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Consul) validateAddress(formats strfmt.Registry) error {

	if err := validate.Required("address", "body", m.Address); err != nil {
		return err
	}

	if err := validate.Pattern("address", "body", *m.Address, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *Consul) validateEnabled(formats strfmt.Registry) error {

	if err := validate.Required("enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

var consulTypeHealthCheckPolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","any","all","min"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consulTypeHealthCheckPolicyPropEnum = append(consulTypeHealthCheckPolicyPropEnum, v)
	}
}

const (

	// ConsulHealthCheckPolicyNone captures enum value "none"
	ConsulHealthCheckPolicyNone string = "none"

	// ConsulHealthCheckPolicyAny captures enum value "any"
	ConsulHealthCheckPolicyAny string = "any"

	// ConsulHealthCheckPolicyAll captures enum value "all"
	ConsulHealthCheckPolicyAll string = "all"

	// ConsulHealthCheckPolicyMin captures enum value "min"
	ConsulHealthCheckPolicyMin string = "min"
)

// prop value enum
func (m *Consul) validateHealthCheckPolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consulTypeHealthCheckPolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Consul) validateHealthCheckPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.HealthCheckPolicy) { // not required
		return nil
	}

	// value enum
	if err := m.validateHealthCheckPolicyEnum("health_check_policy", "body", *m.HealthCheckPolicy); err != nil {
		return err
	}

	return nil
}

func (m *Consul) validateID(formats strfmt.Registry) error {
	if swag.IsZero(m.ID) { // not required
		return nil
	}

	if err := validate.Pattern("id", "body", *m.ID, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var consulTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consulTypeModePropEnum = append(consulTypeModePropEnum, v)
	}
}

const (

	// ConsulModeHTTP captures enum value "http"
	ConsulModeHTTP string = "http"

	// ConsulModeHTTPS captures enum value "https"
	ConsulModeHTTPS string = "https"
)

// prop value enum
func (m *Consul) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consulTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Consul) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

func (m *Consul) validatePort(formats strfmt.Registry) error {

	if err := validate.Required("port", "body", m.Port); err != nil {
		return err
	}

	if err := validate.MinimumInt("port", "body", *m.Port, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("port", "body", *m.Port, 65535, false); err != nil {
		return err
	}

	return nil
}

func (m *Consul) validateRetryTimeout(formats strfmt.Registry) error {

	if err := validate.Required("retry_timeout", "body", m.RetryTimeout); err != nil {
		return err
	}

	if err := validate.MinimumInt("retry_timeout", "body", *m.RetryTimeout, 1, false); err != nil {
		return err
	}

	return nil
}

var consulTypeServerSlotsGrowthTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["linear","exponential"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consulTypeServerSlotsGrowthTypePropEnum = append(consulTypeServerSlotsGrowthTypePropEnum, v)
	}
}

const (

	// ConsulServerSlotsGrowthTypeLinear captures enum value "linear"
	ConsulServerSlotsGrowthTypeLinear string = "linear"

	// ConsulServerSlotsGrowthTypeExponential captures enum value "exponential"
	ConsulServerSlotsGrowthTypeExponential string = "exponential"
)

// prop value enum
func (m *Consul) validateServerSlotsGrowthTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consulTypeServerSlotsGrowthTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Consul) validateServerSlotsGrowthType(formats strfmt.Registry) error {
	if swag.IsZero(m.ServerSlotsGrowthType) { // not required
		return nil
	}

	// value enum
	if err := m.validateServerSlotsGrowthTypeEnum("server_slots_growth_type", "body", *m.ServerSlotsGrowthType); err != nil {
		return err
	}

	return nil
}

func (m *Consul) validateServiceAllowlist(formats strfmt.Registry) error {
	if swag.IsZero(m.ServiceAllowlist) { // not required
		return nil
	}

	for i := 0; i < len(m.ServiceAllowlist); i++ {

		if err := validate.Pattern("service_allowlist"+"."+strconv.Itoa(i), "body", m.ServiceAllowlist[i], `^[^\s]+$`); err != nil {
			return err
		}

	}

	return nil
}

func (m *Consul) validateServiceDenylist(formats strfmt.Registry) error {
	if swag.IsZero(m.ServiceDenylist) { // not required
		return nil
	}

	for i := 0; i < len(m.ServiceDenylist); i++ {

		if err := validate.Pattern("service_denylist"+"."+strconv.Itoa(i), "body", m.ServiceDenylist[i], `^[^\s]+$`); err != nil {
			return err
		}

	}

	return nil
}

func (m *Consul) validateToken(formats strfmt.Registry) error {
	if swag.IsZero(m.Token) { // not required
		return nil
	}

	if err := validate.Pattern("token", "body", m.Token, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consul based on context it is used
func (m *Consul) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Consul) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Consul) UnmarshalBinary(b []byte) error {
	var res Consul
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
