﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudfront/model/ResponseHeadersPolicyAccessControlExposeHeaders.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/core/utils/xml/XmlSerializer.h>

#include <utility>

using namespace Aws::Utils::Xml;
using namespace Aws::Utils;

namespace Aws {
namespace CloudFront {
namespace Model {

ResponseHeadersPolicyAccessControlExposeHeaders::ResponseHeadersPolicyAccessControlExposeHeaders(const XmlNode& xmlNode) {
  *this = xmlNode;
}

ResponseHeadersPolicyAccessControlExposeHeaders& ResponseHeadersPolicyAccessControlExposeHeaders::operator=(const XmlNode& xmlNode) {
  XmlNode resultNode = xmlNode;

  if (!resultNode.IsNull()) {
    XmlNode quantityNode = resultNode.FirstChild("Quantity");
    if (!quantityNode.IsNull()) {
      m_quantity =
          StringUtils::ConvertToInt32(StringUtils::Trim(Aws::Utils::Xml::DecodeEscapedXmlText(quantityNode.GetText()).c_str()).c_str());
      m_quantityHasBeenSet = true;
    }
    XmlNode itemsNode = resultNode.FirstChild("Items");
    if (!itemsNode.IsNull()) {
      XmlNode itemsMember = itemsNode.FirstChild("Header");
      m_itemsHasBeenSet = !itemsMember.IsNull();
      while (!itemsMember.IsNull()) {
        m_items.push_back(itemsMember.GetText());
        itemsMember = itemsMember.NextNode("Header");
      }

      m_itemsHasBeenSet = true;
    }
  }

  return *this;
}

void ResponseHeadersPolicyAccessControlExposeHeaders::AddToNode(XmlNode& parentNode) const {
  Aws::StringStream ss;
  if (m_quantityHasBeenSet) {
    XmlNode quantityNode = parentNode.CreateChildElement("Quantity");
    ss << m_quantity;
    quantityNode.SetText(ss.str());
    ss.str("");
  }

  if (m_itemsHasBeenSet) {
    XmlNode itemsParentNode = parentNode.CreateChildElement("Items");
    for (const auto& item : m_items) {
      XmlNode itemsNode = itemsParentNode.CreateChildElement("Header");
      itemsNode.SetText(item);
    }
  }
}

}  // namespace Model
}  // namespace CloudFront
}  // namespace Aws
