﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock/model/ByteContentDoc.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Bedrock {
namespace Model {

ByteContentDoc::ByteContentDoc(JsonView jsonValue) { *this = jsonValue; }

ByteContentDoc& ByteContentDoc::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("identifier")) {
    m_identifier = jsonValue.GetString("identifier");
    m_identifierHasBeenSet = true;
  }
  if (jsonValue.ValueExists("contentType")) {
    m_contentType = jsonValue.GetString("contentType");
    m_contentTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("data")) {
    m_data = HashingUtils::Base64Decode(jsonValue.GetString("data"));
    m_dataHasBeenSet = true;
  }
  return *this;
}

JsonValue ByteContentDoc::Jsonize() const {
  JsonValue payload;

  if (m_identifierHasBeenSet) {
    payload.WithString("identifier", m_identifier);
  }

  if (m_contentTypeHasBeenSet) {
    payload.WithString("contentType", m_contentType);
  }

  if (m_dataHasBeenSet) {
    payload.WithString("data", HashingUtils::Base64Encode(m_data));
  }

  return payload;
}

}  // namespace Model
}  // namespace Bedrock
}  // namespace Aws
