// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcceptAccountLinkInvitation = "AcceptAccountLinkInvitation"

// AcceptAccountLinkInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptAccountLinkInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptAccountLinkInvitation for more information on using the AcceptAccountLinkInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptAccountLinkInvitationRequest method.
//	req, resp := client.AcceptAccountLinkInvitationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AcceptAccountLinkInvitation
func (c *WorkSpaces) AcceptAccountLinkInvitationRequest(input *AcceptAccountLinkInvitationInput) (req *request.Request, output *AcceptAccountLinkInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptAccountLinkInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptAccountLinkInvitationInput{}
	}

	output = &AcceptAccountLinkInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptAccountLinkInvitation API operation for Amazon WorkSpaces.
//
// Accepts the account link invitation.
//
// There's currently no unlinking capability after you accept the account linking
// invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation AcceptAccountLinkInvitation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     You either haven't provided a TargetAccountId or are using the same value
//     for TargetAccountId and SourceAccountId.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - ConflictException
//     The TargetAccountId is already linked or invited.
//
//   - InternalServerException
//     Unexpected server error occured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AcceptAccountLinkInvitation
func (c *WorkSpaces) AcceptAccountLinkInvitation(input *AcceptAccountLinkInvitationInput) (*AcceptAccountLinkInvitationOutput, error) {
	req, out := c.AcceptAccountLinkInvitationRequest(input)
	return out, req.Send()
}

// AcceptAccountLinkInvitationWithContext is the same as AcceptAccountLinkInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptAccountLinkInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) AcceptAccountLinkInvitationWithContext(ctx aws.Context, input *AcceptAccountLinkInvitationInput, opts ...request.Option) (*AcceptAccountLinkInvitationOutput, error) {
	req, out := c.AcceptAccountLinkInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateConnectionAlias = "AssociateConnectionAlias"

// AssociateConnectionAliasRequest generates a "aws/request.Request" representing the
// client's request for the AssociateConnectionAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateConnectionAlias for more information on using the AssociateConnectionAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateConnectionAliasRequest method.
//	req, resp := client.AssociateConnectionAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateConnectionAlias
func (c *WorkSpaces) AssociateConnectionAliasRequest(input *AssociateConnectionAliasInput) (req *request.Request, output *AssociateConnectionAliasOutput) {
	op := &request.Operation{
		Name:       opAssociateConnectionAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateConnectionAliasInput{}
	}

	output = &AssociateConnectionAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateConnectionAlias API operation for Amazon WorkSpaces.
//
// Associates the specified connection alias with the specified directory to
// enable cross-Region redirection. For more information, see Cross-Region Redirection
// for Amazon WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
// Before performing this operation, call DescribeConnectionAliases (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html)
// to make sure that the current state of the connection alias is CREATED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation AssociateConnectionAlias for usage and error information.
//
// Returned Error Types:
//
//   - ResourceAssociatedException
//     The resource is associated with a directory.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateConnectionAlias
func (c *WorkSpaces) AssociateConnectionAlias(input *AssociateConnectionAliasInput) (*AssociateConnectionAliasOutput, error) {
	req, out := c.AssociateConnectionAliasRequest(input)
	return out, req.Send()
}

// AssociateConnectionAliasWithContext is the same as AssociateConnectionAlias with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateConnectionAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) AssociateConnectionAliasWithContext(ctx aws.Context, input *AssociateConnectionAliasInput, opts ...request.Option) (*AssociateConnectionAliasOutput, error) {
	req, out := c.AssociateConnectionAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateIpGroups = "AssociateIpGroups"

// AssociateIpGroupsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateIpGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateIpGroups for more information on using the AssociateIpGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateIpGroupsRequest method.
//	req, resp := client.AssociateIpGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups
func (c *WorkSpaces) AssociateIpGroupsRequest(input *AssociateIpGroupsInput) (req *request.Request, output *AssociateIpGroupsOutput) {
	op := &request.Operation{
		Name:       opAssociateIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateIpGroupsInput{}
	}

	output = &AssociateIpGroupsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateIpGroups API operation for Amazon WorkSpaces.
//
// Associates the specified IP access control group with the specified directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation AssociateIpGroups for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups
func (c *WorkSpaces) AssociateIpGroups(input *AssociateIpGroupsInput) (*AssociateIpGroupsOutput, error) {
	req, out := c.AssociateIpGroupsRequest(input)
	return out, req.Send()
}

// AssociateIpGroupsWithContext is the same as AssociateIpGroups with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateIpGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) AssociateIpGroupsWithContext(ctx aws.Context, input *AssociateIpGroupsInput, opts ...request.Option) (*AssociateIpGroupsOutput, error) {
	req, out := c.AssociateIpGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateWorkspaceApplication = "AssociateWorkspaceApplication"

// AssociateWorkspaceApplicationRequest generates a "aws/request.Request" representing the
// client's request for the AssociateWorkspaceApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateWorkspaceApplication for more information on using the AssociateWorkspaceApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateWorkspaceApplicationRequest method.
//	req, resp := client.AssociateWorkspaceApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateWorkspaceApplication
func (c *WorkSpaces) AssociateWorkspaceApplicationRequest(input *AssociateWorkspaceApplicationInput) (req *request.Request, output *AssociateWorkspaceApplicationOutput) {
	op := &request.Operation{
		Name:       opAssociateWorkspaceApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateWorkspaceApplicationInput{}
	}

	output = &AssociateWorkspaceApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateWorkspaceApplication API operation for Amazon WorkSpaces.
//
// Associates the specified application to the specified WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation AssociateWorkspaceApplication for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - ResourceInUseException
//     The specified resource is currently in use.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ComputeNotCompatibleException
//     The compute type of the WorkSpace is not compatible with the application.
//
//   - OperatingSystemNotCompatibleException
//     The operating system of the WorkSpace is not compatible with the application.
//
//   - ApplicationNotSupportedException
//     The specified application is not supported.
//
//   - IncompatibleApplicationsException
//     The specified application is not compatible with the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateWorkspaceApplication
func (c *WorkSpaces) AssociateWorkspaceApplication(input *AssociateWorkspaceApplicationInput) (*AssociateWorkspaceApplicationOutput, error) {
	req, out := c.AssociateWorkspaceApplicationRequest(input)
	return out, req.Send()
}

// AssociateWorkspaceApplicationWithContext is the same as AssociateWorkspaceApplication with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateWorkspaceApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) AssociateWorkspaceApplicationWithContext(ctx aws.Context, input *AssociateWorkspaceApplicationInput, opts ...request.Option) (*AssociateWorkspaceApplicationOutput, error) {
	req, out := c.AssociateWorkspaceApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeIpRules = "AuthorizeIpRules"

// AuthorizeIpRulesRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeIpRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeIpRules for more information on using the AuthorizeIpRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AuthorizeIpRulesRequest method.
//	req, resp := client.AuthorizeIpRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules
func (c *WorkSpaces) AuthorizeIpRulesRequest(input *AuthorizeIpRulesInput) (req *request.Request, output *AuthorizeIpRulesOutput) {
	op := &request.Operation{
		Name:       opAuthorizeIpRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeIpRulesInput{}
	}

	output = &AuthorizeIpRulesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AuthorizeIpRules API operation for Amazon WorkSpaces.
//
// Adds one or more rules to the specified IP access control group.
//
// This action gives users permission to access their WorkSpaces from the CIDR
// address ranges specified in the rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation AuthorizeIpRules for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules
func (c *WorkSpaces) AuthorizeIpRules(input *AuthorizeIpRulesInput) (*AuthorizeIpRulesOutput, error) {
	req, out := c.AuthorizeIpRulesRequest(input)
	return out, req.Send()
}

// AuthorizeIpRulesWithContext is the same as AuthorizeIpRules with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeIpRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) AuthorizeIpRulesWithContext(ctx aws.Context, input *AuthorizeIpRulesInput, opts ...request.Option) (*AuthorizeIpRulesOutput, error) {
	req, out := c.AuthorizeIpRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyWorkspaceImage = "CopyWorkspaceImage"

// CopyWorkspaceImageRequest generates a "aws/request.Request" representing the
// client's request for the CopyWorkspaceImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyWorkspaceImage for more information on using the CopyWorkspaceImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CopyWorkspaceImageRequest method.
//	req, resp := client.CopyWorkspaceImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage
func (c *WorkSpaces) CopyWorkspaceImageRequest(input *CopyWorkspaceImageInput) (req *request.Request, output *CopyWorkspaceImageOutput) {
	op := &request.Operation{
		Name:       opCopyWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyWorkspaceImageInput{}
	}

	output = &CopyWorkspaceImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyWorkspaceImage API operation for Amazon WorkSpaces.
//
// Copies the specified image from the specified Region to the current Region.
// For more information about copying images, see Copy a Custom WorkSpaces Image
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html).
//
// In the China (Ningxia) Region, you can copy images only within the same Region.
//
// In Amazon Web Services GovCloud (US), to copy images to and from other Regions,
// contact Amazon Web Services Support.
//
// Before copying a shared image, be sure to verify that it has been shared
// from the correct Amazon Web Services account. To determine if an image has
// been shared and to see the ID of the Amazon Web Services account that owns
// an image, use the DescribeWorkSpaceImages (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html)
// and DescribeWorkspaceImagePermissions (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html)
// API operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CopyWorkspaceImage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceUnavailableException
//     The specified resource is not available.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage
func (c *WorkSpaces) CopyWorkspaceImage(input *CopyWorkspaceImageInput) (*CopyWorkspaceImageOutput, error) {
	req, out := c.CopyWorkspaceImageRequest(input)
	return out, req.Send()
}

// CopyWorkspaceImageWithContext is the same as CopyWorkspaceImage with the addition of
// the ability to pass a context and additional request options.
//
// See CopyWorkspaceImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CopyWorkspaceImageWithContext(ctx aws.Context, input *CopyWorkspaceImageInput, opts ...request.Option) (*CopyWorkspaceImageOutput, error) {
	req, out := c.CopyWorkspaceImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccountLinkInvitation = "CreateAccountLinkInvitation"

// CreateAccountLinkInvitationRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccountLinkInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccountLinkInvitation for more information on using the CreateAccountLinkInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccountLinkInvitationRequest method.
//	req, resp := client.CreateAccountLinkInvitationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateAccountLinkInvitation
func (c *WorkSpaces) CreateAccountLinkInvitationRequest(input *CreateAccountLinkInvitationInput) (req *request.Request, output *CreateAccountLinkInvitationOutput) {
	op := &request.Operation{
		Name:       opCreateAccountLinkInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAccountLinkInvitationInput{}
	}

	output = &CreateAccountLinkInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccountLinkInvitation API operation for Amazon WorkSpaces.
//
// Creates the account link invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateAccountLinkInvitation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     You either haven't provided a TargetAccountId or are using the same value
//     for TargetAccountId and SourceAccountId.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - ConflictException
//     The TargetAccountId is already linked or invited.
//
//   - InternalServerException
//     Unexpected server error occured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateAccountLinkInvitation
func (c *WorkSpaces) CreateAccountLinkInvitation(input *CreateAccountLinkInvitationInput) (*CreateAccountLinkInvitationOutput, error) {
	req, out := c.CreateAccountLinkInvitationRequest(input)
	return out, req.Send()
}

// CreateAccountLinkInvitationWithContext is the same as CreateAccountLinkInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccountLinkInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateAccountLinkInvitationWithContext(ctx aws.Context, input *CreateAccountLinkInvitationInput, opts ...request.Option) (*CreateAccountLinkInvitationOutput, error) {
	req, out := c.CreateAccountLinkInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnectClientAddIn = "CreateConnectClientAddIn"

// CreateConnectClientAddInRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnectClientAddIn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnectClientAddIn for more information on using the CreateConnectClientAddIn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConnectClientAddInRequest method.
//	req, resp := client.CreateConnectClientAddInRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectClientAddIn
func (c *WorkSpaces) CreateConnectClientAddInRequest(input *CreateConnectClientAddInInput) (req *request.Request, output *CreateConnectClientAddInOutput) {
	op := &request.Operation{
		Name:       opCreateConnectClientAddIn,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectClientAddInInput{}
	}

	output = &CreateConnectClientAddInOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnectClientAddIn API operation for Amazon WorkSpaces.
//
// Creates a client-add-in for Amazon Connect within a directory. You can create
// only one Amazon Connect client add-in within a directory.
//
// This client add-in allows WorkSpaces users to seamlessly connect to Amazon
// Connect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateConnectClientAddIn for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceCreationFailedException
//     The resource could not be created.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectClientAddIn
func (c *WorkSpaces) CreateConnectClientAddIn(input *CreateConnectClientAddInInput) (*CreateConnectClientAddInOutput, error) {
	req, out := c.CreateConnectClientAddInRequest(input)
	return out, req.Send()
}

// CreateConnectClientAddInWithContext is the same as CreateConnectClientAddIn with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnectClientAddIn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateConnectClientAddInWithContext(ctx aws.Context, input *CreateConnectClientAddInInput, opts ...request.Option) (*CreateConnectClientAddInOutput, error) {
	req, out := c.CreateConnectClientAddInRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnectionAlias = "CreateConnectionAlias"

// CreateConnectionAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnectionAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnectionAlias for more information on using the CreateConnectionAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConnectionAliasRequest method.
//	req, resp := client.CreateConnectionAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectionAlias
func (c *WorkSpaces) CreateConnectionAliasRequest(input *CreateConnectionAliasInput) (req *request.Request, output *CreateConnectionAliasOutput) {
	op := &request.Operation{
		Name:       opCreateConnectionAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionAliasInput{}
	}

	output = &CreateConnectionAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnectionAlias API operation for Amazon WorkSpaces.
//
// Creates the specified connection alias for use with cross-Region redirection.
// For more information, see Cross-Region Redirection for Amazon WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateConnectionAlias for usage and error information.
//
// Returned Error Types:
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectionAlias
func (c *WorkSpaces) CreateConnectionAlias(input *CreateConnectionAliasInput) (*CreateConnectionAliasOutput, error) {
	req, out := c.CreateConnectionAliasRequest(input)
	return out, req.Send()
}

// CreateConnectionAliasWithContext is the same as CreateConnectionAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnectionAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateConnectionAliasWithContext(ctx aws.Context, input *CreateConnectionAliasInput, opts ...request.Option) (*CreateConnectionAliasOutput, error) {
	req, out := c.CreateConnectionAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIpGroup = "CreateIpGroup"

// CreateIpGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateIpGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIpGroup for more information on using the CreateIpGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIpGroupRequest method.
//	req, resp := client.CreateIpGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup
func (c *WorkSpaces) CreateIpGroupRequest(input *CreateIpGroupInput) (req *request.Request, output *CreateIpGroupOutput) {
	op := &request.Operation{
		Name:       opCreateIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIpGroupInput{}
	}

	output = &CreateIpGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIpGroup API operation for Amazon WorkSpaces.
//
// Creates an IP access control group.
//
// An IP access control group provides you with the ability to control the IP
// addresses from which users are allowed to access their WorkSpaces. To specify
// the CIDR address ranges, add rules to your IP access control group and then
// associate the group with your directory. You can add rules when you create
// the group or at any time using AuthorizeIpRules.
//
// There is a default IP access control group associated with your directory.
// If you don't associate an IP access control group with your directory, the
// default group is used. The default group includes a default rule that allows
// users to access their WorkSpaces from anywhere. You cannot modify the default
// IP access control group for your directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateIpGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - ResourceCreationFailedException
//     The resource could not be created.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup
func (c *WorkSpaces) CreateIpGroup(input *CreateIpGroupInput) (*CreateIpGroupOutput, error) {
	req, out := c.CreateIpGroupRequest(input)
	return out, req.Send()
}

// CreateIpGroupWithContext is the same as CreateIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateIpGroupWithContext(ctx aws.Context, input *CreateIpGroupInput, opts ...request.Option) (*CreateIpGroupOutput, error) {
	req, out := c.CreateIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStandbyWorkspaces = "CreateStandbyWorkspaces"

// CreateStandbyWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the CreateStandbyWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStandbyWorkspaces for more information on using the CreateStandbyWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStandbyWorkspacesRequest method.
//	req, resp := client.CreateStandbyWorkspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateStandbyWorkspaces
func (c *WorkSpaces) CreateStandbyWorkspacesRequest(input *CreateStandbyWorkspacesInput) (req *request.Request, output *CreateStandbyWorkspacesOutput) {
	op := &request.Operation{
		Name:       opCreateStandbyWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStandbyWorkspacesInput{}
	}

	output = &CreateStandbyWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStandbyWorkspaces API operation for Amazon WorkSpaces.
//
// Creates a standby WorkSpace in a secondary Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateStandbyWorkspaces for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateStandbyWorkspaces
func (c *WorkSpaces) CreateStandbyWorkspaces(input *CreateStandbyWorkspacesInput) (*CreateStandbyWorkspacesOutput, error) {
	req, out := c.CreateStandbyWorkspacesRequest(input)
	return out, req.Send()
}

// CreateStandbyWorkspacesWithContext is the same as CreateStandbyWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStandbyWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateStandbyWorkspacesWithContext(ctx aws.Context, input *CreateStandbyWorkspacesInput, opts ...request.Option) (*CreateStandbyWorkspacesOutput, error) {
	req, out := c.CreateStandbyWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTagsRequest method.
//	req, resp := client.CreateTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags
func (c *WorkSpaces) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for Amazon WorkSpaces.
//
// Creates the specified tags for the specified WorkSpaces resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateTags for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags
func (c *WorkSpaces) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUpdatedWorkspaceImage = "CreateUpdatedWorkspaceImage"

// CreateUpdatedWorkspaceImageRequest generates a "aws/request.Request" representing the
// client's request for the CreateUpdatedWorkspaceImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUpdatedWorkspaceImage for more information on using the CreateUpdatedWorkspaceImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUpdatedWorkspaceImageRequest method.
//	req, resp := client.CreateUpdatedWorkspaceImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateUpdatedWorkspaceImage
func (c *WorkSpaces) CreateUpdatedWorkspaceImageRequest(input *CreateUpdatedWorkspaceImageInput) (req *request.Request, output *CreateUpdatedWorkspaceImageOutput) {
	op := &request.Operation{
		Name:       opCreateUpdatedWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUpdatedWorkspaceImageInput{}
	}

	output = &CreateUpdatedWorkspaceImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUpdatedWorkspaceImage API operation for Amazon WorkSpaces.
//
// Creates a new updated WorkSpace image based on the specified source image.
// The new updated WorkSpace image has the latest drivers and other updates
// required by the Amazon WorkSpaces components.
//
// To determine which WorkSpace images need to be updated with the latest Amazon
// WorkSpaces requirements, use DescribeWorkspaceImages (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html).
//
//   - Only Windows 10, Windows Server 2016, and Windows Server 2019 WorkSpace
//     images can be programmatically updated at this time.
//
//   - Microsoft Windows updates and other application updates are not included
//     in the update process.
//
//   - The source WorkSpace image is not deleted. You can delete the source
//     image after you've verified your new updated image and created a new bundle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateUpdatedWorkspaceImage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateUpdatedWorkspaceImage
func (c *WorkSpaces) CreateUpdatedWorkspaceImage(input *CreateUpdatedWorkspaceImageInput) (*CreateUpdatedWorkspaceImageOutput, error) {
	req, out := c.CreateUpdatedWorkspaceImageRequest(input)
	return out, req.Send()
}

// CreateUpdatedWorkspaceImageWithContext is the same as CreateUpdatedWorkspaceImage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUpdatedWorkspaceImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateUpdatedWorkspaceImageWithContext(ctx aws.Context, input *CreateUpdatedWorkspaceImageInput, opts ...request.Option) (*CreateUpdatedWorkspaceImageOutput, error) {
	req, out := c.CreateUpdatedWorkspaceImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkspaceBundle = "CreateWorkspaceBundle"

// CreateWorkspaceBundleRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspaceBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspaceBundle for more information on using the CreateWorkspaceBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkspaceBundleRequest method.
//	req, resp := client.CreateWorkspaceBundleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceBundle
func (c *WorkSpaces) CreateWorkspaceBundleRequest(input *CreateWorkspaceBundleInput) (req *request.Request, output *CreateWorkspaceBundleOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspaceBundle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkspaceBundleInput{}
	}

	output = &CreateWorkspaceBundleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspaceBundle API operation for Amazon WorkSpaces.
//
// Creates the specified WorkSpace bundle. For more information about creating
// WorkSpace bundles, see Create a Custom WorkSpaces Image and Bundle (https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateWorkspaceBundle for usage and error information.
//
// Returned Error Types:
//
//   - ResourceUnavailableException
//     The specified resource is not available.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceBundle
func (c *WorkSpaces) CreateWorkspaceBundle(input *CreateWorkspaceBundleInput) (*CreateWorkspaceBundleOutput, error) {
	req, out := c.CreateWorkspaceBundleRequest(input)
	return out, req.Send()
}

// CreateWorkspaceBundleWithContext is the same as CreateWorkspaceBundle with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspaceBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateWorkspaceBundleWithContext(ctx aws.Context, input *CreateWorkspaceBundleInput, opts ...request.Option) (*CreateWorkspaceBundleOutput, error) {
	req, out := c.CreateWorkspaceBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkspaceImage = "CreateWorkspaceImage"

// CreateWorkspaceImageRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspaceImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspaceImage for more information on using the CreateWorkspaceImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkspaceImageRequest method.
//	req, resp := client.CreateWorkspaceImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceImage
func (c *WorkSpaces) CreateWorkspaceImageRequest(input *CreateWorkspaceImageInput) (req *request.Request, output *CreateWorkspaceImageOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkspaceImageInput{}
	}

	output = &CreateWorkspaceImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspaceImage API operation for Amazon WorkSpaces.
//
// Creates a new WorkSpace image from an existing WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateWorkspaceImage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceImage
func (c *WorkSpaces) CreateWorkspaceImage(input *CreateWorkspaceImageInput) (*CreateWorkspaceImageOutput, error) {
	req, out := c.CreateWorkspaceImageRequest(input)
	return out, req.Send()
}

// CreateWorkspaceImageWithContext is the same as CreateWorkspaceImage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspaceImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateWorkspaceImageWithContext(ctx aws.Context, input *CreateWorkspaceImageInput, opts ...request.Option) (*CreateWorkspaceImageOutput, error) {
	req, out := c.CreateWorkspaceImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkspaces = "CreateWorkspaces"

// CreateWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspaces for more information on using the CreateWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkspacesRequest method.
//	req, resp := client.CreateWorkspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces
func (c *WorkSpaces) CreateWorkspacesRequest(input *CreateWorkspacesInput) (req *request.Request, output *CreateWorkspacesOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkspacesInput{}
	}

	output = &CreateWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspaces API operation for Amazon WorkSpaces.
//
// Creates one or more WorkSpaces.
//
// This operation is asynchronous and returns before the WorkSpaces are created.
//
//   - The MANUAL running mode value is only supported by Amazon WorkSpaces
//     Core. Contact your account team to be allow-listed to use this value.
//     For more information, see Amazon WorkSpaces Core (http://aws.amazon.com/workspaces/core/).
//
//   - You don't need to specify the PCOIP protocol for Linux bundles because
//     WSP is the default protocol for those bundles.
//
//   - User-decoupled WorkSpaces are only supported by Amazon WorkSpaces Core.
//
//   - Review your running mode to ensure you are using one that is optimal
//     for your needs and budget. For more information on switching running modes,
//     see Can I switch between hourly and monthly billing? (http://aws.amazon.com/workspaces-family/workspaces/faqs/#:~:text=Can%20I%20switch%20between%20hourly%20and%20monthly%20billing%20on%20WorkSpaces%20Personal%3F)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateWorkspaces for usage and error information.
//
// Returned Error Types:
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces
func (c *WorkSpaces) CreateWorkspaces(input *CreateWorkspacesInput) (*CreateWorkspacesOutput, error) {
	req, out := c.CreateWorkspacesRequest(input)
	return out, req.Send()
}

// CreateWorkspacesWithContext is the same as CreateWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateWorkspacesWithContext(ctx aws.Context, input *CreateWorkspacesInput, opts ...request.Option) (*CreateWorkspacesOutput, error) {
	req, out := c.CreateWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkspacesPool = "CreateWorkspacesPool"

// CreateWorkspacesPoolRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspacesPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspacesPool for more information on using the CreateWorkspacesPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkspacesPoolRequest method.
//	req, resp := client.CreateWorkspacesPoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspacesPool
func (c *WorkSpaces) CreateWorkspacesPoolRequest(input *CreateWorkspacesPoolInput) (req *request.Request, output *CreateWorkspacesPoolOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspacesPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkspacesPoolInput{}
	}

	output = &CreateWorkspacesPoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspacesPool API operation for Amazon WorkSpaces.
//
// Creates a pool of WorkSpaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateWorkspacesPool for usage and error information.
//
// Returned Error Types:
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspacesPool
func (c *WorkSpaces) CreateWorkspacesPool(input *CreateWorkspacesPoolInput) (*CreateWorkspacesPoolOutput, error) {
	req, out := c.CreateWorkspacesPoolRequest(input)
	return out, req.Send()
}

// CreateWorkspacesPoolWithContext is the same as CreateWorkspacesPool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspacesPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateWorkspacesPoolWithContext(ctx aws.Context, input *CreateWorkspacesPoolInput, opts ...request.Option) (*CreateWorkspacesPoolOutput, error) {
	req, out := c.CreateWorkspacesPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccountLinkInvitation = "DeleteAccountLinkInvitation"

// DeleteAccountLinkInvitationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountLinkInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccountLinkInvitation for more information on using the DeleteAccountLinkInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccountLinkInvitationRequest method.
//	req, resp := client.DeleteAccountLinkInvitationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteAccountLinkInvitation
func (c *WorkSpaces) DeleteAccountLinkInvitationRequest(input *DeleteAccountLinkInvitationInput) (req *request.Request, output *DeleteAccountLinkInvitationOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountLinkInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccountLinkInvitationInput{}
	}

	output = &DeleteAccountLinkInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAccountLinkInvitation API operation for Amazon WorkSpaces.
//
// Deletes the account link invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteAccountLinkInvitation for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     You either haven't provided a TargetAccountId or are using the same value
//     for TargetAccountId and SourceAccountId.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The TargetAccountId is already linked or invited.
//
//   - InternalServerException
//     Unexpected server error occured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteAccountLinkInvitation
func (c *WorkSpaces) DeleteAccountLinkInvitation(input *DeleteAccountLinkInvitationInput) (*DeleteAccountLinkInvitationOutput, error) {
	req, out := c.DeleteAccountLinkInvitationRequest(input)
	return out, req.Send()
}

// DeleteAccountLinkInvitationWithContext is the same as DeleteAccountLinkInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccountLinkInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteAccountLinkInvitationWithContext(ctx aws.Context, input *DeleteAccountLinkInvitationInput, opts ...request.Option) (*DeleteAccountLinkInvitationOutput, error) {
	req, out := c.DeleteAccountLinkInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClientBranding = "DeleteClientBranding"

// DeleteClientBrandingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClientBranding operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClientBranding for more information on using the DeleteClientBranding
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteClientBrandingRequest method.
//	req, resp := client.DeleteClientBrandingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteClientBranding
func (c *WorkSpaces) DeleteClientBrandingRequest(input *DeleteClientBrandingInput) (req *request.Request, output *DeleteClientBrandingOutput) {
	op := &request.Operation{
		Name:       opDeleteClientBranding,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClientBrandingInput{}
	}

	output = &DeleteClientBrandingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteClientBranding API operation for Amazon WorkSpaces.
//
// Deletes customized client branding. Client branding allows you to customize
// your WorkSpace's client login portal. You can tailor your login portal company
// logo, the support email address, support link, link to reset password, and
// a custom message for users trying to sign in.
//
// After you delete your customized client branding, your login portal reverts
// to the default client branding.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteClientBranding for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteClientBranding
func (c *WorkSpaces) DeleteClientBranding(input *DeleteClientBrandingInput) (*DeleteClientBrandingOutput, error) {
	req, out := c.DeleteClientBrandingRequest(input)
	return out, req.Send()
}

// DeleteClientBrandingWithContext is the same as DeleteClientBranding with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClientBranding for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteClientBrandingWithContext(ctx aws.Context, input *DeleteClientBrandingInput, opts ...request.Option) (*DeleteClientBrandingOutput, error) {
	req, out := c.DeleteClientBrandingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnectClientAddIn = "DeleteConnectClientAddIn"

// DeleteConnectClientAddInRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnectClientAddIn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnectClientAddIn for more information on using the DeleteConnectClientAddIn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConnectClientAddInRequest method.
//	req, resp := client.DeleteConnectClientAddInRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectClientAddIn
func (c *WorkSpaces) DeleteConnectClientAddInRequest(input *DeleteConnectClientAddInInput) (req *request.Request, output *DeleteConnectClientAddInOutput) {
	op := &request.Operation{
		Name:       opDeleteConnectClientAddIn,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectClientAddInInput{}
	}

	output = &DeleteConnectClientAddInOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConnectClientAddIn API operation for Amazon WorkSpaces.
//
// Deletes a client-add-in for Amazon Connect that is configured within a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteConnectClientAddIn for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectClientAddIn
func (c *WorkSpaces) DeleteConnectClientAddIn(input *DeleteConnectClientAddInInput) (*DeleteConnectClientAddInOutput, error) {
	req, out := c.DeleteConnectClientAddInRequest(input)
	return out, req.Send()
}

// DeleteConnectClientAddInWithContext is the same as DeleteConnectClientAddIn with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnectClientAddIn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteConnectClientAddInWithContext(ctx aws.Context, input *DeleteConnectClientAddInInput, opts ...request.Option) (*DeleteConnectClientAddInOutput, error) {
	req, out := c.DeleteConnectClientAddInRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnectionAlias = "DeleteConnectionAlias"

// DeleteConnectionAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnectionAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnectionAlias for more information on using the DeleteConnectionAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConnectionAliasRequest method.
//	req, resp := client.DeleteConnectionAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectionAlias
func (c *WorkSpaces) DeleteConnectionAliasRequest(input *DeleteConnectionAliasInput) (req *request.Request, output *DeleteConnectionAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteConnectionAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionAliasInput{}
	}

	output = &DeleteConnectionAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConnectionAlias API operation for Amazon WorkSpaces.
//
// Deletes the specified connection alias. For more information, see Cross-Region
// Redirection for Amazon WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
// If you will no longer be using a fully qualified domain name (FQDN) as the
// registration code for your WorkSpaces users, you must take certain precautions
// to prevent potential security issues. For more information, see Security
// Considerations if You Stop Using Cross-Region Redirection (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations).
//
// To delete a connection alias that has been shared, the shared account must
// first disassociate the connection alias from any directories it has been
// associated with. Then you must unshare the connection alias from the account
// it has been shared with. You can delete a connection alias only after it
// is no longer shared with any accounts or associated with any directories.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteConnectionAlias for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceAssociatedException
//     The resource is associated with a directory.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectionAlias
func (c *WorkSpaces) DeleteConnectionAlias(input *DeleteConnectionAliasInput) (*DeleteConnectionAliasOutput, error) {
	req, out := c.DeleteConnectionAliasRequest(input)
	return out, req.Send()
}

// DeleteConnectionAliasWithContext is the same as DeleteConnectionAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnectionAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteConnectionAliasWithContext(ctx aws.Context, input *DeleteConnectionAliasInput, opts ...request.Option) (*DeleteConnectionAliasOutput, error) {
	req, out := c.DeleteConnectionAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIpGroup = "DeleteIpGroup"

// DeleteIpGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIpGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIpGroup for more information on using the DeleteIpGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIpGroupRequest method.
//	req, resp := client.DeleteIpGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup
func (c *WorkSpaces) DeleteIpGroupRequest(input *DeleteIpGroupInput) (req *request.Request, output *DeleteIpGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIpGroupInput{}
	}

	output = &DeleteIpGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIpGroup API operation for Amazon WorkSpaces.
//
// Deletes the specified IP access control group.
//
// You cannot delete an IP access control group that is associated with a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteIpGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceAssociatedException
//     The resource is associated with a directory.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup
func (c *WorkSpaces) DeleteIpGroup(input *DeleteIpGroupInput) (*DeleteIpGroupOutput, error) {
	req, out := c.DeleteIpGroupRequest(input)
	return out, req.Send()
}

// DeleteIpGroupWithContext is the same as DeleteIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteIpGroupWithContext(ctx aws.Context, input *DeleteIpGroupInput, opts ...request.Option) (*DeleteIpGroupOutput, error) {
	req, out := c.DeleteIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTagsRequest method.
//	req, resp := client.DeleteTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags
func (c *WorkSpaces) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for Amazon WorkSpaces.
//
// Deletes the specified tags from the specified WorkSpaces resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteTags for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags
func (c *WorkSpaces) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkspaceBundle = "DeleteWorkspaceBundle"

// DeleteWorkspaceBundleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkspaceBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkspaceBundle for more information on using the DeleteWorkspaceBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkspaceBundleRequest method.
//	req, resp := client.DeleteWorkspaceBundleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceBundle
func (c *WorkSpaces) DeleteWorkspaceBundleRequest(input *DeleteWorkspaceBundleInput) (req *request.Request, output *DeleteWorkspaceBundleOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkspaceBundle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkspaceBundleInput{}
	}

	output = &DeleteWorkspaceBundleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkspaceBundle API operation for Amazon WorkSpaces.
//
// Deletes the specified WorkSpace bundle. For more information about deleting
// WorkSpace bundles, see Delete a Custom WorkSpaces Bundle or Image (https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteWorkspaceBundle for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceAssociatedException
//     The resource is associated with a directory.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceBundle
func (c *WorkSpaces) DeleteWorkspaceBundle(input *DeleteWorkspaceBundleInput) (*DeleteWorkspaceBundleOutput, error) {
	req, out := c.DeleteWorkspaceBundleRequest(input)
	return out, req.Send()
}

// DeleteWorkspaceBundleWithContext is the same as DeleteWorkspaceBundle with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkspaceBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteWorkspaceBundleWithContext(ctx aws.Context, input *DeleteWorkspaceBundleInput, opts ...request.Option) (*DeleteWorkspaceBundleOutput, error) {
	req, out := c.DeleteWorkspaceBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkspaceImage = "DeleteWorkspaceImage"

// DeleteWorkspaceImageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkspaceImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkspaceImage for more information on using the DeleteWorkspaceImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkspaceImageRequest method.
//	req, resp := client.DeleteWorkspaceImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage
func (c *WorkSpaces) DeleteWorkspaceImageRequest(input *DeleteWorkspaceImageInput) (req *request.Request, output *DeleteWorkspaceImageOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkspaceImageInput{}
	}

	output = &DeleteWorkspaceImageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkspaceImage API operation for Amazon WorkSpaces.
//
// Deletes the specified image from your account. To delete an image, you must
// first delete any bundles that are associated with the image and unshare the
// image if it is shared with other accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteWorkspaceImage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceAssociatedException
//     The resource is associated with a directory.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage
func (c *WorkSpaces) DeleteWorkspaceImage(input *DeleteWorkspaceImageInput) (*DeleteWorkspaceImageOutput, error) {
	req, out := c.DeleteWorkspaceImageRequest(input)
	return out, req.Send()
}

// DeleteWorkspaceImageWithContext is the same as DeleteWorkspaceImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkspaceImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteWorkspaceImageWithContext(ctx aws.Context, input *DeleteWorkspaceImageInput, opts ...request.Option) (*DeleteWorkspaceImageOutput, error) {
	req, out := c.DeleteWorkspaceImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeployWorkspaceApplications = "DeployWorkspaceApplications"

// DeployWorkspaceApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the DeployWorkspaceApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeployWorkspaceApplications for more information on using the DeployWorkspaceApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeployWorkspaceApplicationsRequest method.
//	req, resp := client.DeployWorkspaceApplicationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeployWorkspaceApplications
func (c *WorkSpaces) DeployWorkspaceApplicationsRequest(input *DeployWorkspaceApplicationsInput) (req *request.Request, output *DeployWorkspaceApplicationsOutput) {
	op := &request.Operation{
		Name:       opDeployWorkspaceApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeployWorkspaceApplicationsInput{}
	}

	output = &DeployWorkspaceApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeployWorkspaceApplications API operation for Amazon WorkSpaces.
//
// # Deploys associated applications to the specified WorkSpace
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeployWorkspaceApplications for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceInUseException
//     The specified resource is currently in use.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - IncompatibleApplicationsException
//     The specified application is not compatible with the resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeployWorkspaceApplications
func (c *WorkSpaces) DeployWorkspaceApplications(input *DeployWorkspaceApplicationsInput) (*DeployWorkspaceApplicationsOutput, error) {
	req, out := c.DeployWorkspaceApplicationsRequest(input)
	return out, req.Send()
}

// DeployWorkspaceApplicationsWithContext is the same as DeployWorkspaceApplications with the addition of
// the ability to pass a context and additional request options.
//
// See DeployWorkspaceApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeployWorkspaceApplicationsWithContext(ctx aws.Context, input *DeployWorkspaceApplicationsInput, opts ...request.Option) (*DeployWorkspaceApplicationsOutput, error) {
	req, out := c.DeployWorkspaceApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterWorkspaceDirectory = "DeregisterWorkspaceDirectory"

// DeregisterWorkspaceDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterWorkspaceDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterWorkspaceDirectory for more information on using the DeregisterWorkspaceDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterWorkspaceDirectoryRequest method.
//	req, resp := client.DeregisterWorkspaceDirectoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory
func (c *WorkSpaces) DeregisterWorkspaceDirectoryRequest(input *DeregisterWorkspaceDirectoryInput) (req *request.Request, output *DeregisterWorkspaceDirectoryOutput) {
	op := &request.Operation{
		Name:       opDeregisterWorkspaceDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterWorkspaceDirectoryInput{}
	}

	output = &DeregisterWorkspaceDirectoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterWorkspaceDirectory API operation for Amazon WorkSpaces.
//
// Deregisters the specified directory. This operation is asynchronous and returns
// before the WorkSpace directory is deregistered. If any WorkSpaces are registered
// to this directory, you must remove them before you can deregister the directory.
//
// Simple AD and AD Connector are made available to you free of charge to use
// with WorkSpaces. If there are no WorkSpaces being used with your Simple AD
// or AD Connector directory for 30 consecutive days, this directory will be
// automatically deregistered for use with Amazon WorkSpaces, and you will be
// charged for this directory as per the Directory Service pricing terms (http://aws.amazon.com/directoryservice/pricing/).
//
// To delete empty directories, see Delete the Directory for Your WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html).
// If you delete your Simple AD or AD Connector directory, you can always create
// a new one when you want to start using WorkSpaces again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeregisterWorkspaceDirectory for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory
func (c *WorkSpaces) DeregisterWorkspaceDirectory(input *DeregisterWorkspaceDirectoryInput) (*DeregisterWorkspaceDirectoryOutput, error) {
	req, out := c.DeregisterWorkspaceDirectoryRequest(input)
	return out, req.Send()
}

// DeregisterWorkspaceDirectoryWithContext is the same as DeregisterWorkspaceDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterWorkspaceDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeregisterWorkspaceDirectoryWithContext(ctx aws.Context, input *DeregisterWorkspaceDirectoryInput, opts ...request.Option) (*DeregisterWorkspaceDirectoryOutput, error) {
	req, out := c.DeregisterWorkspaceDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccount = "DescribeAccount"

// DescribeAccountRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccount for more information on using the DescribeAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountRequest method.
//	req, resp := client.DescribeAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount
func (c *WorkSpaces) DescribeAccountRequest(input *DescribeAccountInput) (req *request.Request, output *DescribeAccountOutput) {
	op := &request.Operation{
		Name:       opDescribeAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountInput{}
	}

	output = &DescribeAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccount API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes the configuration of Bring Your Own License
// (BYOL) for the specified account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeAccount for usage and error information.
//
// Returned Error Types:
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount
func (c *WorkSpaces) DescribeAccount(input *DescribeAccountInput) (*DescribeAccountOutput, error) {
	req, out := c.DescribeAccountRequest(input)
	return out, req.Send()
}

// DescribeAccountWithContext is the same as DescribeAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeAccountWithContext(ctx aws.Context, input *DescribeAccountInput, opts ...request.Option) (*DescribeAccountOutput, error) {
	req, out := c.DescribeAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountModifications = "DescribeAccountModifications"

// DescribeAccountModificationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountModifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountModifications for more information on using the DescribeAccountModifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountModificationsRequest method.
//	req, resp := client.DescribeAccountModificationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications
func (c *WorkSpaces) DescribeAccountModificationsRequest(input *DescribeAccountModificationsInput) (req *request.Request, output *DescribeAccountModificationsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountModifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountModificationsInput{}
	}

	output = &DescribeAccountModificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountModifications API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes modifications to the configuration of Bring
// Your Own License (BYOL) for the specified account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeAccountModifications for usage and error information.
//
// Returned Error Types:
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications
func (c *WorkSpaces) DescribeAccountModifications(input *DescribeAccountModificationsInput) (*DescribeAccountModificationsOutput, error) {
	req, out := c.DescribeAccountModificationsRequest(input)
	return out, req.Send()
}

// DescribeAccountModificationsWithContext is the same as DescribeAccountModifications with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountModifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeAccountModificationsWithContext(ctx aws.Context, input *DescribeAccountModificationsInput, opts ...request.Option) (*DescribeAccountModificationsOutput, error) {
	req, out := c.DescribeAccountModificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplicationAssociations = "DescribeApplicationAssociations"

// DescribeApplicationAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplicationAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplicationAssociations for more information on using the DescribeApplicationAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeApplicationAssociationsRequest method.
//	req, resp := client.DescribeApplicationAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplicationAssociations
func (c *WorkSpaces) DescribeApplicationAssociationsRequest(input *DescribeApplicationAssociationsInput) (req *request.Request, output *DescribeApplicationAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeApplicationAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeApplicationAssociationsInput{}
	}

	output = &DescribeApplicationAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplicationAssociations API operation for Amazon WorkSpaces.
//
// Describes the associations between the application and the specified associated
// resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeApplicationAssociations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplicationAssociations
func (c *WorkSpaces) DescribeApplicationAssociations(input *DescribeApplicationAssociationsInput) (*DescribeApplicationAssociationsOutput, error) {
	req, out := c.DescribeApplicationAssociationsRequest(input)
	return out, req.Send()
}

// DescribeApplicationAssociationsWithContext is the same as DescribeApplicationAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplicationAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeApplicationAssociationsWithContext(ctx aws.Context, input *DescribeApplicationAssociationsInput, opts ...request.Option) (*DescribeApplicationAssociationsOutput, error) {
	req, out := c.DescribeApplicationAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeApplicationAssociationsPages iterates over the pages of a DescribeApplicationAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeApplicationAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeApplicationAssociations operation.
//	pageNum := 0
//	err := client.DescribeApplicationAssociationsPages(params,
//	    func(page *workspaces.DescribeApplicationAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpaces) DescribeApplicationAssociationsPages(input *DescribeApplicationAssociationsInput, fn func(*DescribeApplicationAssociationsOutput, bool) bool) error {
	return c.DescribeApplicationAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeApplicationAssociationsPagesWithContext same as DescribeApplicationAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeApplicationAssociationsPagesWithContext(ctx aws.Context, input *DescribeApplicationAssociationsInput, fn func(*DescribeApplicationAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeApplicationAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeApplicationAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeApplicationAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeApplications = "DescribeApplications"

// DescribeApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplications for more information on using the DescribeApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeApplicationsRequest method.
//	req, resp := client.DescribeApplicationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplications
func (c *WorkSpaces) DescribeApplicationsRequest(input *DescribeApplicationsInput) (req *request.Request, output *DescribeApplicationsOutput) {
	op := &request.Operation{
		Name:       opDescribeApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeApplicationsInput{}
	}

	output = &DescribeApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplications API operation for Amazon WorkSpaces.
//
// Describes the specified applications by filtering based on their compute
// types, license availability, operating systems, and owners.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeApplications for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplications
func (c *WorkSpaces) DescribeApplications(input *DescribeApplicationsInput) (*DescribeApplicationsOutput, error) {
	req, out := c.DescribeApplicationsRequest(input)
	return out, req.Send()
}

// DescribeApplicationsWithContext is the same as DescribeApplications with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeApplicationsWithContext(ctx aws.Context, input *DescribeApplicationsInput, opts ...request.Option) (*DescribeApplicationsOutput, error) {
	req, out := c.DescribeApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeApplicationsPages iterates over the pages of a DescribeApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeApplications operation.
//	pageNum := 0
//	err := client.DescribeApplicationsPages(params,
//	    func(page *workspaces.DescribeApplicationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpaces) DescribeApplicationsPages(input *DescribeApplicationsInput, fn func(*DescribeApplicationsOutput, bool) bool) error {
	return c.DescribeApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeApplicationsPagesWithContext same as DescribeApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeApplicationsPagesWithContext(ctx aws.Context, input *DescribeApplicationsInput, fn func(*DescribeApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeBundleAssociations = "DescribeBundleAssociations"

// DescribeBundleAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBundleAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBundleAssociations for more information on using the DescribeBundleAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBundleAssociationsRequest method.
//	req, resp := client.DescribeBundleAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeBundleAssociations
func (c *WorkSpaces) DescribeBundleAssociationsRequest(input *DescribeBundleAssociationsInput) (req *request.Request, output *DescribeBundleAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeBundleAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBundleAssociationsInput{}
	}

	output = &DescribeBundleAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBundleAssociations API operation for Amazon WorkSpaces.
//
// Describes the associations between the applications and the specified bundle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeBundleAssociations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeBundleAssociations
func (c *WorkSpaces) DescribeBundleAssociations(input *DescribeBundleAssociationsInput) (*DescribeBundleAssociationsOutput, error) {
	req, out := c.DescribeBundleAssociationsRequest(input)
	return out, req.Send()
}

// DescribeBundleAssociationsWithContext is the same as DescribeBundleAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBundleAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeBundleAssociationsWithContext(ctx aws.Context, input *DescribeBundleAssociationsInput, opts ...request.Option) (*DescribeBundleAssociationsOutput, error) {
	req, out := c.DescribeBundleAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClientBranding = "DescribeClientBranding"

// DescribeClientBrandingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientBranding operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientBranding for more information on using the DescribeClientBranding
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClientBrandingRequest method.
//	req, resp := client.DescribeClientBrandingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientBranding
func (c *WorkSpaces) DescribeClientBrandingRequest(input *DescribeClientBrandingInput) (req *request.Request, output *DescribeClientBrandingOutput) {
	op := &request.Operation{
		Name:       opDescribeClientBranding,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClientBrandingInput{}
	}

	output = &DescribeClientBrandingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientBranding API operation for Amazon WorkSpaces.
//
// Describes the specified client branding. Client branding allows you to customize
// the log in page of various device types for your users. You can add your
// company logo, the support email address, support link, link to reset password,
// and a custom message for users trying to sign in.
//
// Only device types that have branding information configured will be shown
// in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeClientBranding for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientBranding
func (c *WorkSpaces) DescribeClientBranding(input *DescribeClientBrandingInput) (*DescribeClientBrandingOutput, error) {
	req, out := c.DescribeClientBrandingRequest(input)
	return out, req.Send()
}

// DescribeClientBrandingWithContext is the same as DescribeClientBranding with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientBranding for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeClientBrandingWithContext(ctx aws.Context, input *DescribeClientBrandingInput, opts ...request.Option) (*DescribeClientBrandingOutput, error) {
	req, out := c.DescribeClientBrandingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClientProperties = "DescribeClientProperties"

// DescribeClientPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientProperties for more information on using the DescribeClientProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClientPropertiesRequest method.
//	req, resp := client.DescribeClientPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties
func (c *WorkSpaces) DescribeClientPropertiesRequest(input *DescribeClientPropertiesInput) (req *request.Request, output *DescribeClientPropertiesOutput) {
	op := &request.Operation{
		Name:       opDescribeClientProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClientPropertiesInput{}
	}

	output = &DescribeClientPropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientProperties API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeClientProperties for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties
func (c *WorkSpaces) DescribeClientProperties(input *DescribeClientPropertiesInput) (*DescribeClientPropertiesOutput, error) {
	req, out := c.DescribeClientPropertiesRequest(input)
	return out, req.Send()
}

// DescribeClientPropertiesWithContext is the same as DescribeClientProperties with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeClientPropertiesWithContext(ctx aws.Context, input *DescribeClientPropertiesInput, opts ...request.Option) (*DescribeClientPropertiesOutput, error) {
	req, out := c.DescribeClientPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnectClientAddIns = "DescribeConnectClientAddIns"

// DescribeConnectClientAddInsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectClientAddIns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectClientAddIns for more information on using the DescribeConnectClientAddIns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeConnectClientAddInsRequest method.
//	req, resp := client.DescribeConnectClientAddInsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectClientAddIns
func (c *WorkSpaces) DescribeConnectClientAddInsRequest(input *DescribeConnectClientAddInsInput) (req *request.Request, output *DescribeConnectClientAddInsOutput) {
	op := &request.Operation{
		Name:       opDescribeConnectClientAddIns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectClientAddInsInput{}
	}

	output = &DescribeConnectClientAddInsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectClientAddIns API operation for Amazon WorkSpaces.
//
// Retrieves a list of Amazon Connect client add-ins that have been created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeConnectClientAddIns for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectClientAddIns
func (c *WorkSpaces) DescribeConnectClientAddIns(input *DescribeConnectClientAddInsInput) (*DescribeConnectClientAddInsOutput, error) {
	req, out := c.DescribeConnectClientAddInsRequest(input)
	return out, req.Send()
}

// DescribeConnectClientAddInsWithContext is the same as DescribeConnectClientAddIns with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectClientAddIns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeConnectClientAddInsWithContext(ctx aws.Context, input *DescribeConnectClientAddInsInput, opts ...request.Option) (*DescribeConnectClientAddInsOutput, error) {
	req, out := c.DescribeConnectClientAddInsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnectionAliasPermissions = "DescribeConnectionAliasPermissions"

// DescribeConnectionAliasPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectionAliasPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectionAliasPermissions for more information on using the DescribeConnectionAliasPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeConnectionAliasPermissionsRequest method.
//	req, resp := client.DescribeConnectionAliasPermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliasPermissions
func (c *WorkSpaces) DescribeConnectionAliasPermissionsRequest(input *DescribeConnectionAliasPermissionsInput) (req *request.Request, output *DescribeConnectionAliasPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeConnectionAliasPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionAliasPermissionsInput{}
	}

	output = &DescribeConnectionAliasPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectionAliasPermissions API operation for Amazon WorkSpaces.
//
// Describes the permissions that the owner of a connection alias has granted
// to another Amazon Web Services account for the specified connection alias.
// For more information, see Cross-Region Redirection for Amazon WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeConnectionAliasPermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliasPermissions
func (c *WorkSpaces) DescribeConnectionAliasPermissions(input *DescribeConnectionAliasPermissionsInput) (*DescribeConnectionAliasPermissionsOutput, error) {
	req, out := c.DescribeConnectionAliasPermissionsRequest(input)
	return out, req.Send()
}

// DescribeConnectionAliasPermissionsWithContext is the same as DescribeConnectionAliasPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectionAliasPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeConnectionAliasPermissionsWithContext(ctx aws.Context, input *DescribeConnectionAliasPermissionsInput, opts ...request.Option) (*DescribeConnectionAliasPermissionsOutput, error) {
	req, out := c.DescribeConnectionAliasPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnectionAliases = "DescribeConnectionAliases"

// DescribeConnectionAliasesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectionAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectionAliases for more information on using the DescribeConnectionAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeConnectionAliasesRequest method.
//	req, resp := client.DescribeConnectionAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliases
func (c *WorkSpaces) DescribeConnectionAliasesRequest(input *DescribeConnectionAliasesInput) (req *request.Request, output *DescribeConnectionAliasesOutput) {
	op := &request.Operation{
		Name:       opDescribeConnectionAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionAliasesInput{}
	}

	output = &DescribeConnectionAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectionAliases API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes the connection aliases used for cross-Region
// redirection. For more information, see Cross-Region Redirection for Amazon
// WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeConnectionAliases for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliases
func (c *WorkSpaces) DescribeConnectionAliases(input *DescribeConnectionAliasesInput) (*DescribeConnectionAliasesOutput, error) {
	req, out := c.DescribeConnectionAliasesRequest(input)
	return out, req.Send()
}

// DescribeConnectionAliasesWithContext is the same as DescribeConnectionAliases with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectionAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeConnectionAliasesWithContext(ctx aws.Context, input *DescribeConnectionAliasesInput, opts ...request.Option) (*DescribeConnectionAliasesOutput, error) {
	req, out := c.DescribeConnectionAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImageAssociations = "DescribeImageAssociations"

// DescribeImageAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImageAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImageAssociations for more information on using the DescribeImageAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeImageAssociationsRequest method.
//	req, resp := client.DescribeImageAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeImageAssociations
func (c *WorkSpaces) DescribeImageAssociationsRequest(input *DescribeImageAssociationsInput) (req *request.Request, output *DescribeImageAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeImageAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImageAssociationsInput{}
	}

	output = &DescribeImageAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImageAssociations API operation for Amazon WorkSpaces.
//
// Describes the associations between the applications and the specified image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeImageAssociations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeImageAssociations
func (c *WorkSpaces) DescribeImageAssociations(input *DescribeImageAssociationsInput) (*DescribeImageAssociationsOutput, error) {
	req, out := c.DescribeImageAssociationsRequest(input)
	return out, req.Send()
}

// DescribeImageAssociationsWithContext is the same as DescribeImageAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImageAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeImageAssociationsWithContext(ctx aws.Context, input *DescribeImageAssociationsInput, opts ...request.Option) (*DescribeImageAssociationsOutput, error) {
	req, out := c.DescribeImageAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIpGroups = "DescribeIpGroups"

// DescribeIpGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIpGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIpGroups for more information on using the DescribeIpGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIpGroupsRequest method.
//	req, resp := client.DescribeIpGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups
func (c *WorkSpaces) DescribeIpGroupsRequest(input *DescribeIpGroupsInput) (req *request.Request, output *DescribeIpGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIpGroupsInput{}
	}

	output = &DescribeIpGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIpGroups API operation for Amazon WorkSpaces.
//
// Describes one or more of your IP access control groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeIpGroups for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups
func (c *WorkSpaces) DescribeIpGroups(input *DescribeIpGroupsInput) (*DescribeIpGroupsOutput, error) {
	req, out := c.DescribeIpGroupsRequest(input)
	return out, req.Send()
}

// DescribeIpGroupsWithContext is the same as DescribeIpGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIpGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeIpGroupsWithContext(ctx aws.Context, input *DescribeIpGroupsInput, opts ...request.Option) (*DescribeIpGroupsOutput, error) {
	req, out := c.DescribeIpGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTags for more information on using the DescribeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTagsRequest method.
//	req, resp := client.DescribeTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags
func (c *WorkSpaces) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for Amazon WorkSpaces.
//
// Describes the specified tags for the specified WorkSpaces resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeTags for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags
func (c *WorkSpaces) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	return out, req.Send()
}

// DescribeTagsWithContext is the same as DescribeTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeTagsWithContext(ctx aws.Context, input *DescribeTagsInput, opts ...request.Option) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaceAssociations = "DescribeWorkspaceAssociations"

// DescribeWorkspaceAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceAssociations for more information on using the DescribeWorkspaceAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspaceAssociationsRequest method.
//	req, resp := client.DescribeWorkspaceAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceAssociations
func (c *WorkSpaces) DescribeWorkspaceAssociationsRequest(input *DescribeWorkspaceAssociationsInput) (req *request.Request, output *DescribeWorkspaceAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspaceAssociationsInput{}
	}

	output = &DescribeWorkspaceAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceAssociations API operation for Amazon WorkSpaces.
//
// Describes the associations betweens applications and the specified WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceAssociations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceAssociations
func (c *WorkSpaces) DescribeWorkspaceAssociations(input *DescribeWorkspaceAssociationsInput) (*DescribeWorkspaceAssociationsOutput, error) {
	req, out := c.DescribeWorkspaceAssociationsRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceAssociationsWithContext is the same as DescribeWorkspaceAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceAssociationsWithContext(ctx aws.Context, input *DescribeWorkspaceAssociationsInput, opts ...request.Option) (*DescribeWorkspaceAssociationsOutput, error) {
	req, out := c.DescribeWorkspaceAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaceBundles = "DescribeWorkspaceBundles"

// DescribeWorkspaceBundlesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceBundles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceBundles for more information on using the DescribeWorkspaceBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspaceBundlesRequest method.
//	req, resp := client.DescribeWorkspaceBundlesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles
func (c *WorkSpaces) DescribeWorkspaceBundlesRequest(input *DescribeWorkspaceBundlesInput) (req *request.Request, output *DescribeWorkspaceBundlesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspaceBundlesInput{}
	}

	output = &DescribeWorkspaceBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceBundles API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes the available WorkSpace bundles.
//
// You can filter the results using either bundle ID or owner, but not both.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceBundles for usage and error information.
//
// Returned Error Types:
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles
func (c *WorkSpaces) DescribeWorkspaceBundles(input *DescribeWorkspaceBundlesInput) (*DescribeWorkspaceBundlesOutput, error) {
	req, out := c.DescribeWorkspaceBundlesRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceBundlesWithContext is the same as DescribeWorkspaceBundles with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceBundlesWithContext(ctx aws.Context, input *DescribeWorkspaceBundlesInput, opts ...request.Option) (*DescribeWorkspaceBundlesOutput, error) {
	req, out := c.DescribeWorkspaceBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeWorkspaceBundlesPages iterates over the pages of a DescribeWorkspaceBundles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaceBundles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeWorkspaceBundles operation.
//	pageNum := 0
//	err := client.DescribeWorkspaceBundlesPages(params,
//	    func(page *workspaces.DescribeWorkspaceBundlesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpaces) DescribeWorkspaceBundlesPages(input *DescribeWorkspaceBundlesInput, fn func(*DescribeWorkspaceBundlesOutput, bool) bool) error {
	return c.DescribeWorkspaceBundlesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeWorkspaceBundlesPagesWithContext same as DescribeWorkspaceBundlesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceBundlesPagesWithContext(ctx aws.Context, input *DescribeWorkspaceBundlesInput, fn func(*DescribeWorkspaceBundlesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeWorkspaceBundlesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeWorkspaceBundlesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeWorkspaceBundlesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeWorkspaceDirectories = "DescribeWorkspaceDirectories"

// DescribeWorkspaceDirectoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceDirectories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceDirectories for more information on using the DescribeWorkspaceDirectories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspaceDirectoriesRequest method.
//	req, resp := client.DescribeWorkspaceDirectoriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories
func (c *WorkSpaces) DescribeWorkspaceDirectoriesRequest(input *DescribeWorkspaceDirectoriesInput) (req *request.Request, output *DescribeWorkspaceDirectoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceDirectories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspaceDirectoriesInput{}
	}

	output = &DescribeWorkspaceDirectoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceDirectories API operation for Amazon WorkSpaces.
//
// Describes the available directories that are registered with Amazon WorkSpaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceDirectories for usage and error information.
//
// Returned Error Types:
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories
func (c *WorkSpaces) DescribeWorkspaceDirectories(input *DescribeWorkspaceDirectoriesInput) (*DescribeWorkspaceDirectoriesOutput, error) {
	req, out := c.DescribeWorkspaceDirectoriesRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceDirectoriesWithContext is the same as DescribeWorkspaceDirectories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceDirectories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceDirectoriesWithContext(ctx aws.Context, input *DescribeWorkspaceDirectoriesInput, opts ...request.Option) (*DescribeWorkspaceDirectoriesOutput, error) {
	req, out := c.DescribeWorkspaceDirectoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeWorkspaceDirectoriesPages iterates over the pages of a DescribeWorkspaceDirectories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaceDirectories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeWorkspaceDirectories operation.
//	pageNum := 0
//	err := client.DescribeWorkspaceDirectoriesPages(params,
//	    func(page *workspaces.DescribeWorkspaceDirectoriesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpaces) DescribeWorkspaceDirectoriesPages(input *DescribeWorkspaceDirectoriesInput, fn func(*DescribeWorkspaceDirectoriesOutput, bool) bool) error {
	return c.DescribeWorkspaceDirectoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeWorkspaceDirectoriesPagesWithContext same as DescribeWorkspaceDirectoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceDirectoriesPagesWithContext(ctx aws.Context, input *DescribeWorkspaceDirectoriesInput, fn func(*DescribeWorkspaceDirectoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeWorkspaceDirectoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeWorkspaceDirectoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeWorkspaceDirectoriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeWorkspaceImagePermissions = "DescribeWorkspaceImagePermissions"

// DescribeWorkspaceImagePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceImagePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceImagePermissions for more information on using the DescribeWorkspaceImagePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspaceImagePermissionsRequest method.
//	req, resp := client.DescribeWorkspaceImagePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImagePermissions
func (c *WorkSpaces) DescribeWorkspaceImagePermissionsRequest(input *DescribeWorkspaceImagePermissionsInput) (req *request.Request, output *DescribeWorkspaceImagePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceImagePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspaceImagePermissionsInput{}
	}

	output = &DescribeWorkspaceImagePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceImagePermissions API operation for Amazon WorkSpaces.
//
// Describes the permissions that the owner of an image has granted to other
// Amazon Web Services accounts for an image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceImagePermissions for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImagePermissions
func (c *WorkSpaces) DescribeWorkspaceImagePermissions(input *DescribeWorkspaceImagePermissionsInput) (*DescribeWorkspaceImagePermissionsOutput, error) {
	req, out := c.DescribeWorkspaceImagePermissionsRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceImagePermissionsWithContext is the same as DescribeWorkspaceImagePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceImagePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceImagePermissionsWithContext(ctx aws.Context, input *DescribeWorkspaceImagePermissionsInput, opts ...request.Option) (*DescribeWorkspaceImagePermissionsOutput, error) {
	req, out := c.DescribeWorkspaceImagePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaceImages = "DescribeWorkspaceImages"

// DescribeWorkspaceImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceImages for more information on using the DescribeWorkspaceImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspaceImagesRequest method.
//	req, resp := client.DescribeWorkspaceImagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages
func (c *WorkSpaces) DescribeWorkspaceImagesRequest(input *DescribeWorkspaceImagesInput) (req *request.Request, output *DescribeWorkspaceImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspaceImagesInput{}
	}

	output = &DescribeWorkspaceImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceImages API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes one or more specified images, if the image
// identifiers are provided. Otherwise, all images in the account are described.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceImages for usage and error information.
//
// Returned Error Types:
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages
func (c *WorkSpaces) DescribeWorkspaceImages(input *DescribeWorkspaceImagesInput) (*DescribeWorkspaceImagesOutput, error) {
	req, out := c.DescribeWorkspaceImagesRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceImagesWithContext is the same as DescribeWorkspaceImages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceImagesWithContext(ctx aws.Context, input *DescribeWorkspaceImagesInput, opts ...request.Option) (*DescribeWorkspaceImagesOutput, error) {
	req, out := c.DescribeWorkspaceImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaceSnapshots = "DescribeWorkspaceSnapshots"

// DescribeWorkspaceSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceSnapshots for more information on using the DescribeWorkspaceSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspaceSnapshotsRequest method.
//	req, resp := client.DescribeWorkspaceSnapshotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceSnapshots
func (c *WorkSpaces) DescribeWorkspaceSnapshotsRequest(input *DescribeWorkspaceSnapshotsInput) (req *request.Request, output *DescribeWorkspaceSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspaceSnapshotsInput{}
	}

	output = &DescribeWorkspaceSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceSnapshots API operation for Amazon WorkSpaces.
//
// Describes the snapshots for the specified WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceSnapshots for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceSnapshots
func (c *WorkSpaces) DescribeWorkspaceSnapshots(input *DescribeWorkspaceSnapshotsInput) (*DescribeWorkspaceSnapshotsOutput, error) {
	req, out := c.DescribeWorkspaceSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceSnapshotsWithContext is the same as DescribeWorkspaceSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceSnapshotsWithContext(ctx aws.Context, input *DescribeWorkspaceSnapshotsInput, opts ...request.Option) (*DescribeWorkspaceSnapshotsOutput, error) {
	req, out := c.DescribeWorkspaceSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaces = "DescribeWorkspaces"

// DescribeWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaces for more information on using the DescribeWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspacesRequest method.
//	req, resp := client.DescribeWorkspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces
func (c *WorkSpaces) DescribeWorkspacesRequest(input *DescribeWorkspacesInput) (req *request.Request, output *DescribeWorkspacesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspacesInput{}
	}

	output = &DescribeWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaces API operation for Amazon WorkSpaces.
//
// Describes the specified WorkSpaces.
//
// You can filter the results by using the bundle identifier, directory identifier,
// or owner, but you can specify only one filter at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaces for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceUnavailableException
//     The specified resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces
func (c *WorkSpaces) DescribeWorkspaces(input *DescribeWorkspacesInput) (*DescribeWorkspacesOutput, error) {
	req, out := c.DescribeWorkspacesRequest(input)
	return out, req.Send()
}

// DescribeWorkspacesWithContext is the same as DescribeWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesWithContext(ctx aws.Context, input *DescribeWorkspacesInput, opts ...request.Option) (*DescribeWorkspacesOutput, error) {
	req, out := c.DescribeWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeWorkspacesPages iterates over the pages of a DescribeWorkspaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeWorkspaces operation.
//	pageNum := 0
//	err := client.DescribeWorkspacesPages(params,
//	    func(page *workspaces.DescribeWorkspacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpaces) DescribeWorkspacesPages(input *DescribeWorkspacesInput, fn func(*DescribeWorkspacesOutput, bool) bool) error {
	return c.DescribeWorkspacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeWorkspacesPagesWithContext same as DescribeWorkspacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesPagesWithContext(ctx aws.Context, input *DescribeWorkspacesInput, fn func(*DescribeWorkspacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeWorkspacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeWorkspacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeWorkspacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeWorkspacesConnectionStatus = "DescribeWorkspacesConnectionStatus"

// DescribeWorkspacesConnectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspacesConnectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspacesConnectionStatus for more information on using the DescribeWorkspacesConnectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspacesConnectionStatusRequest method.
//	req, resp := client.DescribeWorkspacesConnectionStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus
func (c *WorkSpaces) DescribeWorkspacesConnectionStatusRequest(input *DescribeWorkspacesConnectionStatusInput) (req *request.Request, output *DescribeWorkspacesConnectionStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspacesConnectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspacesConnectionStatusInput{}
	}

	output = &DescribeWorkspacesConnectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspacesConnectionStatus API operation for Amazon WorkSpaces.
//
// Describes the connection status of the specified WorkSpaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspacesConnectionStatus for usage and error information.
//
// Returned Error Types:
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus
func (c *WorkSpaces) DescribeWorkspacesConnectionStatus(input *DescribeWorkspacesConnectionStatusInput) (*DescribeWorkspacesConnectionStatusOutput, error) {
	req, out := c.DescribeWorkspacesConnectionStatusRequest(input)
	return out, req.Send()
}

// DescribeWorkspacesConnectionStatusWithContext is the same as DescribeWorkspacesConnectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspacesConnectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesConnectionStatusWithContext(ctx aws.Context, input *DescribeWorkspacesConnectionStatusInput, opts ...request.Option) (*DescribeWorkspacesConnectionStatusOutput, error) {
	req, out := c.DescribeWorkspacesConnectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspacesPoolSessions = "DescribeWorkspacesPoolSessions"

// DescribeWorkspacesPoolSessionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspacesPoolSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspacesPoolSessions for more information on using the DescribeWorkspacesPoolSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspacesPoolSessionsRequest method.
//	req, resp := client.DescribeWorkspacesPoolSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesPoolSessions
func (c *WorkSpaces) DescribeWorkspacesPoolSessionsRequest(input *DescribeWorkspacesPoolSessionsInput) (req *request.Request, output *DescribeWorkspacesPoolSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspacesPoolSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspacesPoolSessionsInput{}
	}

	output = &DescribeWorkspacesPoolSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspacesPoolSessions API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes the streaming sessions for a specified pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspacesPoolSessions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesPoolSessions
func (c *WorkSpaces) DescribeWorkspacesPoolSessions(input *DescribeWorkspacesPoolSessionsInput) (*DescribeWorkspacesPoolSessionsOutput, error) {
	req, out := c.DescribeWorkspacesPoolSessionsRequest(input)
	return out, req.Send()
}

// DescribeWorkspacesPoolSessionsWithContext is the same as DescribeWorkspacesPoolSessions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspacesPoolSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesPoolSessionsWithContext(ctx aws.Context, input *DescribeWorkspacesPoolSessionsInput, opts ...request.Option) (*DescribeWorkspacesPoolSessionsOutput, error) {
	req, out := c.DescribeWorkspacesPoolSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspacesPools = "DescribeWorkspacesPools"

// DescribeWorkspacesPoolsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspacesPools operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspacesPools for more information on using the DescribeWorkspacesPools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeWorkspacesPoolsRequest method.
//	req, resp := client.DescribeWorkspacesPoolsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesPools
func (c *WorkSpaces) DescribeWorkspacesPoolsRequest(input *DescribeWorkspacesPoolsInput) (req *request.Request, output *DescribeWorkspacesPoolsOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspacesPools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspacesPoolsInput{}
	}

	output = &DescribeWorkspacesPoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspacesPools API operation for Amazon WorkSpaces.
//
// Describes the specified WorkSpaces Pools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspacesPools for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesPools
func (c *WorkSpaces) DescribeWorkspacesPools(input *DescribeWorkspacesPoolsInput) (*DescribeWorkspacesPoolsOutput, error) {
	req, out := c.DescribeWorkspacesPoolsRequest(input)
	return out, req.Send()
}

// DescribeWorkspacesPoolsWithContext is the same as DescribeWorkspacesPools with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspacesPools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesPoolsWithContext(ctx aws.Context, input *DescribeWorkspacesPoolsInput, opts ...request.Option) (*DescribeWorkspacesPoolsOutput, error) {
	req, out := c.DescribeWorkspacesPoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateConnectionAlias = "DisassociateConnectionAlias"

// DisassociateConnectionAliasRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateConnectionAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateConnectionAlias for more information on using the DisassociateConnectionAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateConnectionAliasRequest method.
//	req, resp := client.DisassociateConnectionAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateConnectionAlias
func (c *WorkSpaces) DisassociateConnectionAliasRequest(input *DisassociateConnectionAliasInput) (req *request.Request, output *DisassociateConnectionAliasOutput) {
	op := &request.Operation{
		Name:       opDisassociateConnectionAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateConnectionAliasInput{}
	}

	output = &DisassociateConnectionAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateConnectionAlias API operation for Amazon WorkSpaces.
//
// Disassociates a connection alias from a directory. Disassociating a connection
// alias disables cross-Region redirection between two directories in different
// Regions. For more information, see Cross-Region Redirection for Amazon WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
// Before performing this operation, call DescribeConnectionAliases (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html)
// to make sure that the current state of the connection alias is CREATED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DisassociateConnectionAlias for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateConnectionAlias
func (c *WorkSpaces) DisassociateConnectionAlias(input *DisassociateConnectionAliasInput) (*DisassociateConnectionAliasOutput, error) {
	req, out := c.DisassociateConnectionAliasRequest(input)
	return out, req.Send()
}

// DisassociateConnectionAliasWithContext is the same as DisassociateConnectionAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateConnectionAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DisassociateConnectionAliasWithContext(ctx aws.Context, input *DisassociateConnectionAliasInput, opts ...request.Option) (*DisassociateConnectionAliasOutput, error) {
	req, out := c.DisassociateConnectionAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateIpGroups = "DisassociateIpGroups"

// DisassociateIpGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateIpGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateIpGroups for more information on using the DisassociateIpGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateIpGroupsRequest method.
//	req, resp := client.DisassociateIpGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups
func (c *WorkSpaces) DisassociateIpGroupsRequest(input *DisassociateIpGroupsInput) (req *request.Request, output *DisassociateIpGroupsOutput) {
	op := &request.Operation{
		Name:       opDisassociateIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateIpGroupsInput{}
	}

	output = &DisassociateIpGroupsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateIpGroups API operation for Amazon WorkSpaces.
//
// Disassociates the specified IP access control group from the specified directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DisassociateIpGroups for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups
func (c *WorkSpaces) DisassociateIpGroups(input *DisassociateIpGroupsInput) (*DisassociateIpGroupsOutput, error) {
	req, out := c.DisassociateIpGroupsRequest(input)
	return out, req.Send()
}

// DisassociateIpGroupsWithContext is the same as DisassociateIpGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateIpGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DisassociateIpGroupsWithContext(ctx aws.Context, input *DisassociateIpGroupsInput, opts ...request.Option) (*DisassociateIpGroupsOutput, error) {
	req, out := c.DisassociateIpGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateWorkspaceApplication = "DisassociateWorkspaceApplication"

// DisassociateWorkspaceApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateWorkspaceApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateWorkspaceApplication for more information on using the DisassociateWorkspaceApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateWorkspaceApplicationRequest method.
//	req, resp := client.DisassociateWorkspaceApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateWorkspaceApplication
func (c *WorkSpaces) DisassociateWorkspaceApplicationRequest(input *DisassociateWorkspaceApplicationInput) (req *request.Request, output *DisassociateWorkspaceApplicationOutput) {
	op := &request.Operation{
		Name:       opDisassociateWorkspaceApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateWorkspaceApplicationInput{}
	}

	output = &DisassociateWorkspaceApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateWorkspaceApplication API operation for Amazon WorkSpaces.
//
// Disassociates the specified application from a WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DisassociateWorkspaceApplication for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceInUseException
//     The specified resource is currently in use.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateWorkspaceApplication
func (c *WorkSpaces) DisassociateWorkspaceApplication(input *DisassociateWorkspaceApplicationInput) (*DisassociateWorkspaceApplicationOutput, error) {
	req, out := c.DisassociateWorkspaceApplicationRequest(input)
	return out, req.Send()
}

// DisassociateWorkspaceApplicationWithContext is the same as DisassociateWorkspaceApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateWorkspaceApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DisassociateWorkspaceApplicationWithContext(ctx aws.Context, input *DisassociateWorkspaceApplicationInput, opts ...request.Option) (*DisassociateWorkspaceApplicationOutput, error) {
	req, out := c.DisassociateWorkspaceApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountLink = "GetAccountLink"

// GetAccountLinkRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountLink for more information on using the GetAccountLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccountLinkRequest method.
//	req, resp := client.GetAccountLinkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/GetAccountLink
func (c *WorkSpaces) GetAccountLinkRequest(input *GetAccountLinkInput) (req *request.Request, output *GetAccountLinkOutput) {
	op := &request.Operation{
		Name:       opGetAccountLink,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountLinkInput{}
	}

	output = &GetAccountLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountLink API operation for Amazon WorkSpaces.
//
// Retrieves account link information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation GetAccountLink for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - ValidationException
//     You either haven't provided a TargetAccountId or are using the same value
//     for TargetAccountId and SourceAccountId.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InternalServerException
//     Unexpected server error occured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/GetAccountLink
func (c *WorkSpaces) GetAccountLink(input *GetAccountLinkInput) (*GetAccountLinkOutput, error) {
	req, out := c.GetAccountLinkRequest(input)
	return out, req.Send()
}

// GetAccountLinkWithContext is the same as GetAccountLink with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) GetAccountLinkWithContext(ctx aws.Context, input *GetAccountLinkInput, opts ...request.Option) (*GetAccountLinkOutput, error) {
	req, out := c.GetAccountLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportClientBranding = "ImportClientBranding"

// ImportClientBrandingRequest generates a "aws/request.Request" representing the
// client's request for the ImportClientBranding operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportClientBranding for more information on using the ImportClientBranding
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportClientBrandingRequest method.
//	req, resp := client.ImportClientBrandingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportClientBranding
func (c *WorkSpaces) ImportClientBrandingRequest(input *ImportClientBrandingInput) (req *request.Request, output *ImportClientBrandingOutput) {
	op := &request.Operation{
		Name:       opImportClientBranding,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportClientBrandingInput{}
	}

	output = &ImportClientBrandingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportClientBranding API operation for Amazon WorkSpaces.
//
// Imports client branding. Client branding allows you to customize your WorkSpace's
// client login portal. You can tailor your login portal company logo, the support
// email address, support link, link to reset password, and a custom message
// for users trying to sign in.
//
// After you import client branding, the default branding experience for the
// specified platform type is replaced with the imported experience
//
//   - You must specify at least one platform type when importing client branding.
//
//   - You can import up to 6 MB of data with each request. If your request
//     exceeds this limit, you can import client branding for different platform
//     types using separate requests.
//
//   - In each platform type, the SupportEmail and SupportLink parameters are
//     mutually exclusive. You can specify only one parameter for each platform
//     type, but not both.
//
//   - Imported data can take up to a minute to appear in the WorkSpaces client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ImportClientBranding for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportClientBranding
func (c *WorkSpaces) ImportClientBranding(input *ImportClientBrandingInput) (*ImportClientBrandingOutput, error) {
	req, out := c.ImportClientBrandingRequest(input)
	return out, req.Send()
}

// ImportClientBrandingWithContext is the same as ImportClientBranding with the addition of
// the ability to pass a context and additional request options.
//
// See ImportClientBranding for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ImportClientBrandingWithContext(ctx aws.Context, input *ImportClientBrandingInput, opts ...request.Option) (*ImportClientBrandingOutput, error) {
	req, out := c.ImportClientBrandingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportWorkspaceImage = "ImportWorkspaceImage"

// ImportWorkspaceImageRequest generates a "aws/request.Request" representing the
// client's request for the ImportWorkspaceImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportWorkspaceImage for more information on using the ImportWorkspaceImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportWorkspaceImageRequest method.
//	req, resp := client.ImportWorkspaceImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage
func (c *WorkSpaces) ImportWorkspaceImageRequest(input *ImportWorkspaceImageInput) (req *request.Request, output *ImportWorkspaceImageOutput) {
	op := &request.Operation{
		Name:       opImportWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportWorkspaceImageInput{}
	}

	output = &ImportWorkspaceImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportWorkspaceImage API operation for Amazon WorkSpaces.
//
// Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image
// into Amazon WorkSpaces. The image must be an already licensed Amazon EC2
// image that is in your Amazon Web Services account, and you must own the image.
// For more information about creating BYOL images, see Bring Your Own Windows
// Desktop Licenses (https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ImportWorkspaceImage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage
func (c *WorkSpaces) ImportWorkspaceImage(input *ImportWorkspaceImageInput) (*ImportWorkspaceImageOutput, error) {
	req, out := c.ImportWorkspaceImageRequest(input)
	return out, req.Send()
}

// ImportWorkspaceImageWithContext is the same as ImportWorkspaceImage with the addition of
// the ability to pass a context and additional request options.
//
// See ImportWorkspaceImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ImportWorkspaceImageWithContext(ctx aws.Context, input *ImportWorkspaceImageInput, opts ...request.Option) (*ImportWorkspaceImageOutput, error) {
	req, out := c.ImportWorkspaceImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccountLinks = "ListAccountLinks"

// ListAccountLinksRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountLinks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountLinks for more information on using the ListAccountLinks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccountLinksRequest method.
//	req, resp := client.ListAccountLinksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAccountLinks
func (c *WorkSpaces) ListAccountLinksRequest(input *ListAccountLinksInput) (req *request.Request, output *ListAccountLinksOutput) {
	op := &request.Operation{
		Name:       opListAccountLinks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountLinksInput{}
	}

	output = &ListAccountLinksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountLinks API operation for Amazon WorkSpaces.
//
// Lists all account links.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ListAccountLinks for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - ValidationException
//     You either haven't provided a TargetAccountId or are using the same value
//     for TargetAccountId and SourceAccountId.
//
//   - InternalServerException
//     Unexpected server error occured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAccountLinks
func (c *WorkSpaces) ListAccountLinks(input *ListAccountLinksInput) (*ListAccountLinksOutput, error) {
	req, out := c.ListAccountLinksRequest(input)
	return out, req.Send()
}

// ListAccountLinksWithContext is the same as ListAccountLinks with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountLinks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ListAccountLinksWithContext(ctx aws.Context, input *ListAccountLinksInput, opts ...request.Option) (*ListAccountLinksOutput, error) {
	req, out := c.ListAccountLinksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountLinksPages iterates over the pages of a ListAccountLinks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountLinks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccountLinks operation.
//	pageNum := 0
//	err := client.ListAccountLinksPages(params,
//	    func(page *workspaces.ListAccountLinksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *WorkSpaces) ListAccountLinksPages(input *ListAccountLinksInput, fn func(*ListAccountLinksOutput, bool) bool) error {
	return c.ListAccountLinksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountLinksPagesWithContext same as ListAccountLinksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ListAccountLinksPagesWithContext(ctx aws.Context, input *ListAccountLinksInput, fn func(*ListAccountLinksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountLinksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountLinksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountLinksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAvailableManagementCidrRanges = "ListAvailableManagementCidrRanges"

// ListAvailableManagementCidrRangesRequest generates a "aws/request.Request" representing the
// client's request for the ListAvailableManagementCidrRanges operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAvailableManagementCidrRanges for more information on using the ListAvailableManagementCidrRanges
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAvailableManagementCidrRangesRequest method.
//	req, resp := client.ListAvailableManagementCidrRangesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges
func (c *WorkSpaces) ListAvailableManagementCidrRangesRequest(input *ListAvailableManagementCidrRangesInput) (req *request.Request, output *ListAvailableManagementCidrRangesOutput) {
	op := &request.Operation{
		Name:       opListAvailableManagementCidrRanges,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAvailableManagementCidrRangesInput{}
	}

	output = &ListAvailableManagementCidrRangesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAvailableManagementCidrRanges API operation for Amazon WorkSpaces.
//
// Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that
// you can use for the network management interface when you enable Bring Your
// Own License (BYOL).
//
// This operation can be run only by Amazon Web Services accounts that are enabled
// for BYOL. If your account isn't enabled for BYOL, you'll receive an AccessDeniedException
// error.
//
// The management network interface is connected to a secure Amazon WorkSpaces
// management network. It is used for interactive streaming of the WorkSpace
// desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage
// the WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ListAvailableManagementCidrRanges for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges
func (c *WorkSpaces) ListAvailableManagementCidrRanges(input *ListAvailableManagementCidrRangesInput) (*ListAvailableManagementCidrRangesOutput, error) {
	req, out := c.ListAvailableManagementCidrRangesRequest(input)
	return out, req.Send()
}

// ListAvailableManagementCidrRangesWithContext is the same as ListAvailableManagementCidrRanges with the addition of
// the ability to pass a context and additional request options.
//
// See ListAvailableManagementCidrRanges for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ListAvailableManagementCidrRangesWithContext(ctx aws.Context, input *ListAvailableManagementCidrRangesInput, opts ...request.Option) (*ListAvailableManagementCidrRangesOutput, error) {
	req, out := c.ListAvailableManagementCidrRangesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opMigrateWorkspace = "MigrateWorkspace"

// MigrateWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the MigrateWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See MigrateWorkspace for more information on using the MigrateWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the MigrateWorkspaceRequest method.
//	req, resp := client.MigrateWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/MigrateWorkspace
func (c *WorkSpaces) MigrateWorkspaceRequest(input *MigrateWorkspaceInput) (req *request.Request, output *MigrateWorkspaceOutput) {
	op := &request.Operation{
		Name:       opMigrateWorkspace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MigrateWorkspaceInput{}
	}

	output = &MigrateWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// MigrateWorkspace API operation for Amazon WorkSpaces.
//
// Migrates a WorkSpace from one operating system or bundle type to another,
// while retaining the data on the user volume.
//
// The migration process recreates the WorkSpace by using a new root volume
// from the target bundle image and the user volume from the last available
// snapshot of the original WorkSpace. During migration, the original D:\Users\%USERNAME%
// user profile folder is renamed to D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated.
// A new D:\Users\%USERNAME%\ folder is generated by the new OS. Certain files
// in the old user profile are moved to the new user profile.
//
// For available migration scenarios, details about what happens during migration,
// and best practices, see Migrate a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation MigrateWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - OperationInProgressException
//     The properties of this WorkSpace are currently being modified. Try again
//     in a moment.
//
//   - ResourceUnavailableException
//     The specified resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/MigrateWorkspace
func (c *WorkSpaces) MigrateWorkspace(input *MigrateWorkspaceInput) (*MigrateWorkspaceOutput, error) {
	req, out := c.MigrateWorkspaceRequest(input)
	return out, req.Send()
}

// MigrateWorkspaceWithContext is the same as MigrateWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See MigrateWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) MigrateWorkspaceWithContext(ctx aws.Context, input *MigrateWorkspaceInput, opts ...request.Option) (*MigrateWorkspaceOutput, error) {
	req, out := c.MigrateWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyAccount = "ModifyAccount"

// ModifyAccountRequest generates a "aws/request.Request" representing the
// client's request for the ModifyAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyAccount for more information on using the ModifyAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyAccountRequest method.
//	req, resp := client.ModifyAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount
func (c *WorkSpaces) ModifyAccountRequest(input *ModifyAccountInput) (req *request.Request, output *ModifyAccountOutput) {
	op := &request.Operation{
		Name:       opModifyAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyAccountInput{}
	}

	output = &ModifyAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyAccount API operation for Amazon WorkSpaces.
//
// Modifies the configuration of Bring Your Own License (BYOL) for the specified
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyAccount for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - ResourceUnavailableException
//     The specified resource is not available.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount
func (c *WorkSpaces) ModifyAccount(input *ModifyAccountInput) (*ModifyAccountOutput, error) {
	req, out := c.ModifyAccountRequest(input)
	return out, req.Send()
}

// ModifyAccountWithContext is the same as ModifyAccount with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyAccountWithContext(ctx aws.Context, input *ModifyAccountInput, opts ...request.Option) (*ModifyAccountOutput, error) {
	req, out := c.ModifyAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyCertificateBasedAuthProperties = "ModifyCertificateBasedAuthProperties"

// ModifyCertificateBasedAuthPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyCertificateBasedAuthProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyCertificateBasedAuthProperties for more information on using the ModifyCertificateBasedAuthProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyCertificateBasedAuthPropertiesRequest method.
//	req, resp := client.ModifyCertificateBasedAuthPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyCertificateBasedAuthProperties
func (c *WorkSpaces) ModifyCertificateBasedAuthPropertiesRequest(input *ModifyCertificateBasedAuthPropertiesInput) (req *request.Request, output *ModifyCertificateBasedAuthPropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyCertificateBasedAuthProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCertificateBasedAuthPropertiesInput{}
	}

	output = &ModifyCertificateBasedAuthPropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyCertificateBasedAuthProperties API operation for Amazon WorkSpaces.
//
// Modifies the properties of the certificate-based authentication you want
// to use with your WorkSpaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyCertificateBasedAuthProperties for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyCertificateBasedAuthProperties
func (c *WorkSpaces) ModifyCertificateBasedAuthProperties(input *ModifyCertificateBasedAuthPropertiesInput) (*ModifyCertificateBasedAuthPropertiesOutput, error) {
	req, out := c.ModifyCertificateBasedAuthPropertiesRequest(input)
	return out, req.Send()
}

// ModifyCertificateBasedAuthPropertiesWithContext is the same as ModifyCertificateBasedAuthProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyCertificateBasedAuthProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyCertificateBasedAuthPropertiesWithContext(ctx aws.Context, input *ModifyCertificateBasedAuthPropertiesInput, opts ...request.Option) (*ModifyCertificateBasedAuthPropertiesOutput, error) {
	req, out := c.ModifyCertificateBasedAuthPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyClientProperties = "ModifyClientProperties"

// ModifyClientPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClientProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyClientProperties for more information on using the ModifyClientProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyClientPropertiesRequest method.
//	req, resp := client.ModifyClientPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties
func (c *WorkSpaces) ModifyClientPropertiesRequest(input *ModifyClientPropertiesInput) (req *request.Request, output *ModifyClientPropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyClientProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClientPropertiesInput{}
	}

	output = &ModifyClientPropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyClientProperties API operation for Amazon WorkSpaces.
//
// Modifies the properties of the specified Amazon WorkSpaces clients.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyClientProperties for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties
func (c *WorkSpaces) ModifyClientProperties(input *ModifyClientPropertiesInput) (*ModifyClientPropertiesOutput, error) {
	req, out := c.ModifyClientPropertiesRequest(input)
	return out, req.Send()
}

// ModifyClientPropertiesWithContext is the same as ModifyClientProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyClientProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyClientPropertiesWithContext(ctx aws.Context, input *ModifyClientPropertiesInput, opts ...request.Option) (*ModifyClientPropertiesOutput, error) {
	req, out := c.ModifyClientPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifySamlProperties = "ModifySamlProperties"

// ModifySamlPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifySamlProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifySamlProperties for more information on using the ModifySamlProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifySamlPropertiesRequest method.
//	req, resp := client.ModifySamlPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySamlProperties
func (c *WorkSpaces) ModifySamlPropertiesRequest(input *ModifySamlPropertiesInput) (req *request.Request, output *ModifySamlPropertiesOutput) {
	op := &request.Operation{
		Name:       opModifySamlProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySamlPropertiesInput{}
	}

	output = &ModifySamlPropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifySamlProperties API operation for Amazon WorkSpaces.
//
// Modifies multiple properties related to SAML 2.0 authentication, including
// the enablement status, user access URL, and relay state parameter name that
// are used for configuring federation with an SAML 2.0 identity provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifySamlProperties for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySamlProperties
func (c *WorkSpaces) ModifySamlProperties(input *ModifySamlPropertiesInput) (*ModifySamlPropertiesOutput, error) {
	req, out := c.ModifySamlPropertiesRequest(input)
	return out, req.Send()
}

// ModifySamlPropertiesWithContext is the same as ModifySamlProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifySamlProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifySamlPropertiesWithContext(ctx aws.Context, input *ModifySamlPropertiesInput, opts ...request.Option) (*ModifySamlPropertiesOutput, error) {
	req, out := c.ModifySamlPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifySelfservicePermissions = "ModifySelfservicePermissions"

// ModifySelfservicePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ModifySelfservicePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifySelfservicePermissions for more information on using the ModifySelfservicePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifySelfservicePermissionsRequest method.
//	req, resp := client.ModifySelfservicePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions
func (c *WorkSpaces) ModifySelfservicePermissionsRequest(input *ModifySelfservicePermissionsInput) (req *request.Request, output *ModifySelfservicePermissionsOutput) {
	op := &request.Operation{
		Name:       opModifySelfservicePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySelfservicePermissionsInput{}
	}

	output = &ModifySelfservicePermissionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifySelfservicePermissions API operation for Amazon WorkSpaces.
//
// Modifies the self-service WorkSpace management capabilities for your users.
// For more information, see Enable Self-Service WorkSpace Management Capabilities
// for Your Users (https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifySelfservicePermissions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions
func (c *WorkSpaces) ModifySelfservicePermissions(input *ModifySelfservicePermissionsInput) (*ModifySelfservicePermissionsOutput, error) {
	req, out := c.ModifySelfservicePermissionsRequest(input)
	return out, req.Send()
}

// ModifySelfservicePermissionsWithContext is the same as ModifySelfservicePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ModifySelfservicePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifySelfservicePermissionsWithContext(ctx aws.Context, input *ModifySelfservicePermissionsInput, opts ...request.Option) (*ModifySelfservicePermissionsOutput, error) {
	req, out := c.ModifySelfservicePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyStreamingProperties = "ModifyStreamingProperties"

// ModifyStreamingPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyStreamingProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyStreamingProperties for more information on using the ModifyStreamingProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyStreamingPropertiesRequest method.
//	req, resp := client.ModifyStreamingPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyStreamingProperties
func (c *WorkSpaces) ModifyStreamingPropertiesRequest(input *ModifyStreamingPropertiesInput) (req *request.Request, output *ModifyStreamingPropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyStreamingProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyStreamingPropertiesInput{}
	}

	output = &ModifyStreamingPropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyStreamingProperties API operation for Amazon WorkSpaces.
//
// Modifies the specified streaming properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyStreamingProperties for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyStreamingProperties
func (c *WorkSpaces) ModifyStreamingProperties(input *ModifyStreamingPropertiesInput) (*ModifyStreamingPropertiesOutput, error) {
	req, out := c.ModifyStreamingPropertiesRequest(input)
	return out, req.Send()
}

// ModifyStreamingPropertiesWithContext is the same as ModifyStreamingProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyStreamingProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyStreamingPropertiesWithContext(ctx aws.Context, input *ModifyStreamingPropertiesInput, opts ...request.Option) (*ModifyStreamingPropertiesOutput, error) {
	req, out := c.ModifyStreamingPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyWorkspaceAccessProperties = "ModifyWorkspaceAccessProperties"

// ModifyWorkspaceAccessPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceAccessProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyWorkspaceAccessProperties for more information on using the ModifyWorkspaceAccessProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyWorkspaceAccessPropertiesRequest method.
//	req, resp := client.ModifyWorkspaceAccessPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceAccessProperties
func (c *WorkSpaces) ModifyWorkspaceAccessPropertiesRequest(input *ModifyWorkspaceAccessPropertiesInput) (req *request.Request, output *ModifyWorkspaceAccessPropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceAccessProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspaceAccessPropertiesInput{}
	}

	output = &ModifyWorkspaceAccessPropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyWorkspaceAccessProperties API operation for Amazon WorkSpaces.
//
// Specifies which devices and operating systems users can use to access their
// WorkSpaces. For more information, see Control Device Access (https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceAccessProperties for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceAccessProperties
func (c *WorkSpaces) ModifyWorkspaceAccessProperties(input *ModifyWorkspaceAccessPropertiesInput) (*ModifyWorkspaceAccessPropertiesOutput, error) {
	req, out := c.ModifyWorkspaceAccessPropertiesRequest(input)
	return out, req.Send()
}

// ModifyWorkspaceAccessPropertiesWithContext is the same as ModifyWorkspaceAccessProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyWorkspaceAccessProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyWorkspaceAccessPropertiesWithContext(ctx aws.Context, input *ModifyWorkspaceAccessPropertiesInput, opts ...request.Option) (*ModifyWorkspaceAccessPropertiesOutput, error) {
	req, out := c.ModifyWorkspaceAccessPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyWorkspaceCreationProperties = "ModifyWorkspaceCreationProperties"

// ModifyWorkspaceCreationPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceCreationProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyWorkspaceCreationProperties for more information on using the ModifyWorkspaceCreationProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyWorkspaceCreationPropertiesRequest method.
//	req, resp := client.ModifyWorkspaceCreationPropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties
func (c *WorkSpaces) ModifyWorkspaceCreationPropertiesRequest(input *ModifyWorkspaceCreationPropertiesInput) (req *request.Request, output *ModifyWorkspaceCreationPropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceCreationProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspaceCreationPropertiesInput{}
	}

	output = &ModifyWorkspaceCreationPropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyWorkspaceCreationProperties API operation for Amazon WorkSpaces.
//
// Modify the default properties used to create WorkSpaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceCreationProperties for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties
func (c *WorkSpaces) ModifyWorkspaceCreationProperties(input *ModifyWorkspaceCreationPropertiesInput) (*ModifyWorkspaceCreationPropertiesOutput, error) {
	req, out := c.ModifyWorkspaceCreationPropertiesRequest(input)
	return out, req.Send()
}

// ModifyWorkspaceCreationPropertiesWithContext is the same as ModifyWorkspaceCreationProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyWorkspaceCreationProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyWorkspaceCreationPropertiesWithContext(ctx aws.Context, input *ModifyWorkspaceCreationPropertiesInput, opts ...request.Option) (*ModifyWorkspaceCreationPropertiesOutput, error) {
	req, out := c.ModifyWorkspaceCreationPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyWorkspaceProperties = "ModifyWorkspaceProperties"

// ModifyWorkspacePropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyWorkspaceProperties for more information on using the ModifyWorkspaceProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyWorkspacePropertiesRequest method.
//	req, resp := client.ModifyWorkspacePropertiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties
func (c *WorkSpaces) ModifyWorkspacePropertiesRequest(input *ModifyWorkspacePropertiesInput) (req *request.Request, output *ModifyWorkspacePropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspacePropertiesInput{}
	}

	output = &ModifyWorkspacePropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyWorkspaceProperties API operation for Amazon WorkSpaces.
//
// Modifies the specified WorkSpace properties. For important information about
// how to modify the size of the root and user volumes, see Modify a WorkSpace
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
//
// The MANUAL running mode value is only supported by Amazon WorkSpaces Core.
// Contact your account team to be allow-listed to use this value. For more
// information, see Amazon WorkSpaces Core (http://aws.amazon.com/workspaces/core/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceProperties for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - OperationInProgressException
//     The properties of this WorkSpace are currently being modified. Try again
//     in a moment.
//
//   - UnsupportedWorkspaceConfigurationException
//     The configuration of this WorkSpace is not supported for this operation.
//     For more information, see Required Configuration and Service Components for
//     WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html).
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - ResourceUnavailableException
//     The specified resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties
func (c *WorkSpaces) ModifyWorkspaceProperties(input *ModifyWorkspacePropertiesInput) (*ModifyWorkspacePropertiesOutput, error) {
	req, out := c.ModifyWorkspacePropertiesRequest(input)
	return out, req.Send()
}

// ModifyWorkspacePropertiesWithContext is the same as ModifyWorkspaceProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyWorkspaceProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyWorkspacePropertiesWithContext(ctx aws.Context, input *ModifyWorkspacePropertiesInput, opts ...request.Option) (*ModifyWorkspacePropertiesOutput, error) {
	req, out := c.ModifyWorkspacePropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyWorkspaceState = "ModifyWorkspaceState"

// ModifyWorkspaceStateRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyWorkspaceState for more information on using the ModifyWorkspaceState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyWorkspaceStateRequest method.
//	req, resp := client.ModifyWorkspaceStateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState
func (c *WorkSpaces) ModifyWorkspaceStateRequest(input *ModifyWorkspaceStateInput) (req *request.Request, output *ModifyWorkspaceStateOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspaceStateInput{}
	}

	output = &ModifyWorkspaceStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyWorkspaceState API operation for Amazon WorkSpaces.
//
// Sets the state of the specified WorkSpace.
//
// To maintain a WorkSpace without being interrupted, set the WorkSpace state
// to ADMIN_MAINTENANCE. WorkSpaces in this state do not respond to requests
// to reboot, stop, start, rebuild, or restore. An AutoStop WorkSpace in this
// state is not stopped. Users cannot log into a WorkSpace in the ADMIN_MAINTENANCE
// state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceState for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState
func (c *WorkSpaces) ModifyWorkspaceState(input *ModifyWorkspaceStateInput) (*ModifyWorkspaceStateOutput, error) {
	req, out := c.ModifyWorkspaceStateRequest(input)
	return out, req.Send()
}

// ModifyWorkspaceStateWithContext is the same as ModifyWorkspaceState with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyWorkspaceState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyWorkspaceStateWithContext(ctx aws.Context, input *ModifyWorkspaceStateInput, opts ...request.Option) (*ModifyWorkspaceStateOutput, error) {
	req, out := c.ModifyWorkspaceStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootWorkspaces = "RebootWorkspaces"

// RebootWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the RebootWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootWorkspaces for more information on using the RebootWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RebootWorkspacesRequest method.
//	req, resp := client.RebootWorkspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces
func (c *WorkSpaces) RebootWorkspacesRequest(input *RebootWorkspacesInput) (req *request.Request, output *RebootWorkspacesOutput) {
	op := &request.Operation{
		Name:       opRebootWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootWorkspacesInput{}
	}

	output = &RebootWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootWorkspaces API operation for Amazon WorkSpaces.
//
// Reboots the specified WorkSpaces.
//
// You cannot reboot a WorkSpace unless its state is AVAILABLE, UNHEALTHY, or
// REBOOTING. Reboot a WorkSpace in the REBOOTING state only if your WorkSpace
// has been stuck in the REBOOTING state for over 20 minutes.
//
// This operation is asynchronous and returns before the WorkSpaces have rebooted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RebootWorkspaces for usage and error information.
//
// Returned Error Types:
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces
func (c *WorkSpaces) RebootWorkspaces(input *RebootWorkspacesInput) (*RebootWorkspacesOutput, error) {
	req, out := c.RebootWorkspacesRequest(input)
	return out, req.Send()
}

// RebootWorkspacesWithContext is the same as RebootWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See RebootWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RebootWorkspacesWithContext(ctx aws.Context, input *RebootWorkspacesInput, opts ...request.Option) (*RebootWorkspacesOutput, error) {
	req, out := c.RebootWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebuildWorkspaces = "RebuildWorkspaces"

// RebuildWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the RebuildWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebuildWorkspaces for more information on using the RebuildWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RebuildWorkspacesRequest method.
//	req, resp := client.RebuildWorkspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces
func (c *WorkSpaces) RebuildWorkspacesRequest(input *RebuildWorkspacesInput) (req *request.Request, output *RebuildWorkspacesOutput) {
	op := &request.Operation{
		Name:       opRebuildWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebuildWorkspacesInput{}
	}

	output = &RebuildWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebuildWorkspaces API operation for Amazon WorkSpaces.
//
// Rebuilds the specified WorkSpace.
//
// You cannot rebuild a WorkSpace unless its state is AVAILABLE, ERROR, UNHEALTHY,
// STOPPED, or REBOOTING.
//
// Rebuilding a WorkSpace is a potentially destructive action that can result
// in the loss of data. For more information, see Rebuild a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html).
//
// This operation is asynchronous and returns before the WorkSpaces have been
// completely rebuilt.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RebuildWorkspaces for usage and error information.
//
// Returned Error Types:
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces
func (c *WorkSpaces) RebuildWorkspaces(input *RebuildWorkspacesInput) (*RebuildWorkspacesOutput, error) {
	req, out := c.RebuildWorkspacesRequest(input)
	return out, req.Send()
}

// RebuildWorkspacesWithContext is the same as RebuildWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See RebuildWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RebuildWorkspacesWithContext(ctx aws.Context, input *RebuildWorkspacesInput, opts ...request.Option) (*RebuildWorkspacesOutput, error) {
	req, out := c.RebuildWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterWorkspaceDirectory = "RegisterWorkspaceDirectory"

// RegisterWorkspaceDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the RegisterWorkspaceDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterWorkspaceDirectory for more information on using the RegisterWorkspaceDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterWorkspaceDirectoryRequest method.
//	req, resp := client.RegisterWorkspaceDirectoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RegisterWorkspaceDirectory
func (c *WorkSpaces) RegisterWorkspaceDirectoryRequest(input *RegisterWorkspaceDirectoryInput) (req *request.Request, output *RegisterWorkspaceDirectoryOutput) {
	op := &request.Operation{
		Name:       opRegisterWorkspaceDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterWorkspaceDirectoryInput{}
	}

	output = &RegisterWorkspaceDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterWorkspaceDirectory API operation for Amazon WorkSpaces.
//
// Registers the specified directory. This operation is asynchronous and returns
// before the WorkSpace directory is registered. If this is the first time you
// are registering a directory, you will need to create the workspaces_DefaultRole
// role before you can register a directory. For more information, see Creating
// the workspaces_DefaultRole Role (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RegisterWorkspaceDirectory for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - WorkspacesDefaultRoleNotFoundException
//     The workspaces_DefaultRole role could not be found. If this is the first
//     time you are registering a directory, you will need to create the workspaces_DefaultRole
//     role before you can register a directory. For more information, see Creating
//     the workspaces_DefaultRole Role (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role).
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - UnsupportedNetworkConfigurationException
//     The configuration of this network is not supported for this operation, or
//     your network configuration conflicts with the Amazon WorkSpaces management
//     network IP range. For more information, see Configure a VPC for Amazon WorkSpaces
//     (https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html).
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - ResourceAlreadyExistsException
//     The specified resource already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RegisterWorkspaceDirectory
func (c *WorkSpaces) RegisterWorkspaceDirectory(input *RegisterWorkspaceDirectoryInput) (*RegisterWorkspaceDirectoryOutput, error) {
	req, out := c.RegisterWorkspaceDirectoryRequest(input)
	return out, req.Send()
}

// RegisterWorkspaceDirectoryWithContext is the same as RegisterWorkspaceDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterWorkspaceDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RegisterWorkspaceDirectoryWithContext(ctx aws.Context, input *RegisterWorkspaceDirectoryInput, opts ...request.Option) (*RegisterWorkspaceDirectoryOutput, error) {
	req, out := c.RegisterWorkspaceDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectAccountLinkInvitation = "RejectAccountLinkInvitation"

// RejectAccountLinkInvitationRequest generates a "aws/request.Request" representing the
// client's request for the RejectAccountLinkInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectAccountLinkInvitation for more information on using the RejectAccountLinkInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RejectAccountLinkInvitationRequest method.
//	req, resp := client.RejectAccountLinkInvitationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RejectAccountLinkInvitation
func (c *WorkSpaces) RejectAccountLinkInvitationRequest(input *RejectAccountLinkInvitationInput) (req *request.Request, output *RejectAccountLinkInvitationOutput) {
	op := &request.Operation{
		Name:       opRejectAccountLinkInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectAccountLinkInvitationInput{}
	}

	output = &RejectAccountLinkInvitationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RejectAccountLinkInvitation API operation for Amazon WorkSpaces.
//
// Rejects the account link invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RejectAccountLinkInvitation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - ValidationException
//     You either haven't provided a TargetAccountId or are using the same value
//     for TargetAccountId and SourceAccountId.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The TargetAccountId is already linked or invited.
//
//   - InternalServerException
//     Unexpected server error occured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RejectAccountLinkInvitation
func (c *WorkSpaces) RejectAccountLinkInvitation(input *RejectAccountLinkInvitationInput) (*RejectAccountLinkInvitationOutput, error) {
	req, out := c.RejectAccountLinkInvitationRequest(input)
	return out, req.Send()
}

// RejectAccountLinkInvitationWithContext is the same as RejectAccountLinkInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See RejectAccountLinkInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RejectAccountLinkInvitationWithContext(ctx aws.Context, input *RejectAccountLinkInvitationInput, opts ...request.Option) (*RejectAccountLinkInvitationOutput, error) {
	req, out := c.RejectAccountLinkInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreWorkspace = "RestoreWorkspace"

// RestoreWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the RestoreWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreWorkspace for more information on using the RestoreWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreWorkspaceRequest method.
//	req, resp := client.RestoreWorkspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace
func (c *WorkSpaces) RestoreWorkspaceRequest(input *RestoreWorkspaceInput) (req *request.Request, output *RestoreWorkspaceOutput) {
	op := &request.Operation{
		Name:       opRestoreWorkspace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreWorkspaceInput{}
	}

	output = &RestoreWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RestoreWorkspace API operation for Amazon WorkSpaces.
//
// Restores the specified WorkSpace to its last known healthy state.
//
// You cannot restore a WorkSpace unless its state is AVAILABLE, ERROR, UNHEALTHY,
// or STOPPED.
//
// Restoring a WorkSpace is a potentially destructive action that can result
// in the loss of data. For more information, see Restore a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html).
//
// This operation is asynchronous and returns before the WorkSpace is completely
// restored.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RestoreWorkspace for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace
func (c *WorkSpaces) RestoreWorkspace(input *RestoreWorkspaceInput) (*RestoreWorkspaceOutput, error) {
	req, out := c.RestoreWorkspaceRequest(input)
	return out, req.Send()
}

// RestoreWorkspaceWithContext is the same as RestoreWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RestoreWorkspaceWithContext(ctx aws.Context, input *RestoreWorkspaceInput, opts ...request.Option) (*RestoreWorkspaceOutput, error) {
	req, out := c.RestoreWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeIpRules = "RevokeIpRules"

// RevokeIpRulesRequest generates a "aws/request.Request" representing the
// client's request for the RevokeIpRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeIpRules for more information on using the RevokeIpRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RevokeIpRulesRequest method.
//	req, resp := client.RevokeIpRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules
func (c *WorkSpaces) RevokeIpRulesRequest(input *RevokeIpRulesInput) (req *request.Request, output *RevokeIpRulesOutput) {
	op := &request.Operation{
		Name:       opRevokeIpRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeIpRulesInput{}
	}

	output = &RevokeIpRulesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeIpRules API operation for Amazon WorkSpaces.
//
// Removes one or more rules from the specified IP access control group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RevokeIpRules for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules
func (c *WorkSpaces) RevokeIpRules(input *RevokeIpRulesInput) (*RevokeIpRulesOutput, error) {
	req, out := c.RevokeIpRulesRequest(input)
	return out, req.Send()
}

// RevokeIpRulesWithContext is the same as RevokeIpRules with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeIpRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RevokeIpRulesWithContext(ctx aws.Context, input *RevokeIpRulesInput, opts ...request.Option) (*RevokeIpRulesOutput, error) {
	req, out := c.RevokeIpRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartWorkspaces = "StartWorkspaces"

// StartWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the StartWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartWorkspaces for more information on using the StartWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartWorkspacesRequest method.
//	req, resp := client.StartWorkspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces
func (c *WorkSpaces) StartWorkspacesRequest(input *StartWorkspacesInput) (req *request.Request, output *StartWorkspacesOutput) {
	op := &request.Operation{
		Name:       opStartWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartWorkspacesInput{}
	}

	output = &StartWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartWorkspaces API operation for Amazon WorkSpaces.
//
// Starts the specified WorkSpaces.
//
// You cannot start a WorkSpace unless it has a running mode of AutoStop and
// a state of STOPPED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation StartWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces
func (c *WorkSpaces) StartWorkspaces(input *StartWorkspacesInput) (*StartWorkspacesOutput, error) {
	req, out := c.StartWorkspacesRequest(input)
	return out, req.Send()
}

// StartWorkspacesWithContext is the same as StartWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See StartWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) StartWorkspacesWithContext(ctx aws.Context, input *StartWorkspacesInput, opts ...request.Option) (*StartWorkspacesOutput, error) {
	req, out := c.StartWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartWorkspacesPool = "StartWorkspacesPool"

// StartWorkspacesPoolRequest generates a "aws/request.Request" representing the
// client's request for the StartWorkspacesPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartWorkspacesPool for more information on using the StartWorkspacesPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartWorkspacesPoolRequest method.
//	req, resp := client.StartWorkspacesPoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspacesPool
func (c *WorkSpaces) StartWorkspacesPoolRequest(input *StartWorkspacesPoolInput) (req *request.Request, output *StartWorkspacesPoolOutput) {
	op := &request.Operation{
		Name:       opStartWorkspacesPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartWorkspacesPoolInput{}
	}

	output = &StartWorkspacesPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartWorkspacesPool API operation for Amazon WorkSpaces.
//
// Starts the specified pool.
//
// You cannot start a pool unless it has a running mode of AutoStop and a state
// of STOPPED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation StartWorkspacesPool for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - OperationInProgressException
//     The properties of this WorkSpace are currently being modified. Try again
//     in a moment.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspacesPool
func (c *WorkSpaces) StartWorkspacesPool(input *StartWorkspacesPoolInput) (*StartWorkspacesPoolOutput, error) {
	req, out := c.StartWorkspacesPoolRequest(input)
	return out, req.Send()
}

// StartWorkspacesPoolWithContext is the same as StartWorkspacesPool with the addition of
// the ability to pass a context and additional request options.
//
// See StartWorkspacesPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) StartWorkspacesPoolWithContext(ctx aws.Context, input *StartWorkspacesPoolInput, opts ...request.Option) (*StartWorkspacesPoolOutput, error) {
	req, out := c.StartWorkspacesPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopWorkspaces = "StopWorkspaces"

// StopWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the StopWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopWorkspaces for more information on using the StopWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopWorkspacesRequest method.
//	req, resp := client.StopWorkspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces
func (c *WorkSpaces) StopWorkspacesRequest(input *StopWorkspacesInput) (req *request.Request, output *StopWorkspacesOutput) {
	op := &request.Operation{
		Name:       opStopWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopWorkspacesInput{}
	}

	output = &StopWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopWorkspaces API operation for Amazon WorkSpaces.
//
// Stops the specified WorkSpaces.
//
// You cannot stop a WorkSpace unless it has a running mode of AutoStop and
// a state of AVAILABLE, IMPAIRED, UNHEALTHY, or ERROR.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation StopWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces
func (c *WorkSpaces) StopWorkspaces(input *StopWorkspacesInput) (*StopWorkspacesOutput, error) {
	req, out := c.StopWorkspacesRequest(input)
	return out, req.Send()
}

// StopWorkspacesWithContext is the same as StopWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See StopWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) StopWorkspacesWithContext(ctx aws.Context, input *StopWorkspacesInput, opts ...request.Option) (*StopWorkspacesOutput, error) {
	req, out := c.StopWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopWorkspacesPool = "StopWorkspacesPool"

// StopWorkspacesPoolRequest generates a "aws/request.Request" representing the
// client's request for the StopWorkspacesPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopWorkspacesPool for more information on using the StopWorkspacesPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopWorkspacesPoolRequest method.
//	req, resp := client.StopWorkspacesPoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspacesPool
func (c *WorkSpaces) StopWorkspacesPoolRequest(input *StopWorkspacesPoolInput) (req *request.Request, output *StopWorkspacesPoolOutput) {
	op := &request.Operation{
		Name:       opStopWorkspacesPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopWorkspacesPoolInput{}
	}

	output = &StopWorkspacesPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopWorkspacesPool API operation for Amazon WorkSpaces.
//
// Stops the specified pool.
//
// You cannot stop a WorkSpace pool unless it has a running mode of AutoStop
// and a state of AVAILABLE, IMPAIRED, UNHEALTHY, or ERROR.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation StopWorkspacesPool for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - OperationInProgressException
//     The properties of this WorkSpace are currently being modified. Try again
//     in a moment.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspacesPool
func (c *WorkSpaces) StopWorkspacesPool(input *StopWorkspacesPoolInput) (*StopWorkspacesPoolOutput, error) {
	req, out := c.StopWorkspacesPoolRequest(input)
	return out, req.Send()
}

// StopWorkspacesPoolWithContext is the same as StopWorkspacesPool with the addition of
// the ability to pass a context and additional request options.
//
// See StopWorkspacesPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) StopWorkspacesPoolWithContext(ctx aws.Context, input *StopWorkspacesPoolInput, opts ...request.Option) (*StopWorkspacesPoolOutput, error) {
	req, out := c.StopWorkspacesPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateWorkspaces = "TerminateWorkspaces"

// TerminateWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the TerminateWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateWorkspaces for more information on using the TerminateWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TerminateWorkspacesRequest method.
//	req, resp := client.TerminateWorkspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces
func (c *WorkSpaces) TerminateWorkspacesRequest(input *TerminateWorkspacesInput) (req *request.Request, output *TerminateWorkspacesOutput) {
	op := &request.Operation{
		Name:       opTerminateWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateWorkspacesInput{}
	}

	output = &TerminateWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateWorkspaces API operation for Amazon WorkSpaces.
//
// Terminates the specified WorkSpaces.
//
// Terminating a WorkSpace is a permanent action and cannot be undone. The user's
// data is destroyed. If you need to archive any user data, contact Amazon Web
// Services Support before terminating the WorkSpace.
//
// You can terminate a WorkSpace that is in any state except SUSPENDED.
//
// This operation is asynchronous and returns before the WorkSpaces have been
// completely terminated. After a WorkSpace is terminated, the TERMINATED state
// is returned only briefly before the WorkSpace directory metadata is cleaned
// up, so this state is rarely returned. To confirm that a WorkSpace is terminated,
// check for the WorkSpace ID by using DescribeWorkSpaces (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html).
// If the WorkSpace ID isn't returned, then the WorkSpace has been successfully
// terminated.
//
// Simple AD and AD Connector are made available to you free of charge to use
// with WorkSpaces. If there are no WorkSpaces being used with your Simple AD
// or AD Connector directory for 30 consecutive days, this directory will be
// automatically deregistered for use with Amazon WorkSpaces, and you will be
// charged for this directory as per the Directory Service pricing terms (http://aws.amazon.com/directoryservice/pricing/).
//
// To delete empty directories, see Delete the Directory for Your WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html).
// If you delete your Simple AD or AD Connector directory, you can always create
// a new one when you want to start using WorkSpaces again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation TerminateWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces
func (c *WorkSpaces) TerminateWorkspaces(input *TerminateWorkspacesInput) (*TerminateWorkspacesOutput, error) {
	req, out := c.TerminateWorkspacesRequest(input)
	return out, req.Send()
}

// TerminateWorkspacesWithContext is the same as TerminateWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) TerminateWorkspacesWithContext(ctx aws.Context, input *TerminateWorkspacesInput, opts ...request.Option) (*TerminateWorkspacesOutput, error) {
	req, out := c.TerminateWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateWorkspacesPool = "TerminateWorkspacesPool"

// TerminateWorkspacesPoolRequest generates a "aws/request.Request" representing the
// client's request for the TerminateWorkspacesPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateWorkspacesPool for more information on using the TerminateWorkspacesPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TerminateWorkspacesPoolRequest method.
//	req, resp := client.TerminateWorkspacesPoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesPool
func (c *WorkSpaces) TerminateWorkspacesPoolRequest(input *TerminateWorkspacesPoolInput) (req *request.Request, output *TerminateWorkspacesPoolOutput) {
	op := &request.Operation{
		Name:       opTerminateWorkspacesPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateWorkspacesPoolInput{}
	}

	output = &TerminateWorkspacesPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TerminateWorkspacesPool API operation for Amazon WorkSpaces.
//
// Terminates the specified pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation TerminateWorkspacesPool for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - OperationInProgressException
//     The properties of this WorkSpace are currently being modified. Try again
//     in a moment.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesPool
func (c *WorkSpaces) TerminateWorkspacesPool(input *TerminateWorkspacesPoolInput) (*TerminateWorkspacesPoolOutput, error) {
	req, out := c.TerminateWorkspacesPoolRequest(input)
	return out, req.Send()
}

// TerminateWorkspacesPoolWithContext is the same as TerminateWorkspacesPool with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateWorkspacesPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) TerminateWorkspacesPoolWithContext(ctx aws.Context, input *TerminateWorkspacesPoolInput, opts ...request.Option) (*TerminateWorkspacesPoolOutput, error) {
	req, out := c.TerminateWorkspacesPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateWorkspacesPoolSession = "TerminateWorkspacesPoolSession"

// TerminateWorkspacesPoolSessionRequest generates a "aws/request.Request" representing the
// client's request for the TerminateWorkspacesPoolSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateWorkspacesPoolSession for more information on using the TerminateWorkspacesPoolSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TerminateWorkspacesPoolSessionRequest method.
//	req, resp := client.TerminateWorkspacesPoolSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesPoolSession
func (c *WorkSpaces) TerminateWorkspacesPoolSessionRequest(input *TerminateWorkspacesPoolSessionInput) (req *request.Request, output *TerminateWorkspacesPoolSessionOutput) {
	op := &request.Operation{
		Name:       opTerminateWorkspacesPoolSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateWorkspacesPoolSessionInput{}
	}

	output = &TerminateWorkspacesPoolSessionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TerminateWorkspacesPoolSession API operation for Amazon WorkSpaces.
//
// Terminates the pool session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation TerminateWorkspacesPoolSession for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - OperationInProgressException
//     The properties of this WorkSpace are currently being modified. Try again
//     in a moment.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesPoolSession
func (c *WorkSpaces) TerminateWorkspacesPoolSession(input *TerminateWorkspacesPoolSessionInput) (*TerminateWorkspacesPoolSessionOutput, error) {
	req, out := c.TerminateWorkspacesPoolSessionRequest(input)
	return out, req.Send()
}

// TerminateWorkspacesPoolSessionWithContext is the same as TerminateWorkspacesPoolSession with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateWorkspacesPoolSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) TerminateWorkspacesPoolSessionWithContext(ctx aws.Context, input *TerminateWorkspacesPoolSessionInput, opts ...request.Option) (*TerminateWorkspacesPoolSessionOutput, error) {
	req, out := c.TerminateWorkspacesPoolSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnectClientAddIn = "UpdateConnectClientAddIn"

// UpdateConnectClientAddInRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnectClientAddIn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnectClientAddIn for more information on using the UpdateConnectClientAddIn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConnectClientAddInRequest method.
//	req, resp := client.UpdateConnectClientAddInRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectClientAddIn
func (c *WorkSpaces) UpdateConnectClientAddInRequest(input *UpdateConnectClientAddInInput) (req *request.Request, output *UpdateConnectClientAddInOutput) {
	op := &request.Operation{
		Name:       opUpdateConnectClientAddIn,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConnectClientAddInInput{}
	}

	output = &UpdateConnectClientAddInOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConnectClientAddIn API operation for Amazon WorkSpaces.
//
// Updates a Amazon Connect client add-in. Use this action to update the name
// and endpoint URL of a Amazon Connect client add-in.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateConnectClientAddIn for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectClientAddIn
func (c *WorkSpaces) UpdateConnectClientAddIn(input *UpdateConnectClientAddInInput) (*UpdateConnectClientAddInOutput, error) {
	req, out := c.UpdateConnectClientAddInRequest(input)
	return out, req.Send()
}

// UpdateConnectClientAddInWithContext is the same as UpdateConnectClientAddIn with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnectClientAddIn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateConnectClientAddInWithContext(ctx aws.Context, input *UpdateConnectClientAddInInput, opts ...request.Option) (*UpdateConnectClientAddInOutput, error) {
	req, out := c.UpdateConnectClientAddInRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnectionAliasPermission = "UpdateConnectionAliasPermission"

// UpdateConnectionAliasPermissionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnectionAliasPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnectionAliasPermission for more information on using the UpdateConnectionAliasPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConnectionAliasPermissionRequest method.
//	req, resp := client.UpdateConnectionAliasPermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectionAliasPermission
func (c *WorkSpaces) UpdateConnectionAliasPermissionRequest(input *UpdateConnectionAliasPermissionInput) (req *request.Request, output *UpdateConnectionAliasPermissionOutput) {
	op := &request.Operation{
		Name:       opUpdateConnectionAliasPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConnectionAliasPermissionInput{}
	}

	output = &UpdateConnectionAliasPermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConnectionAliasPermission API operation for Amazon WorkSpaces.
//
// Shares or unshares a connection alias with one account by specifying whether
// that account has permission to associate the connection alias with a directory.
// If the association permission is granted, the connection alias is shared
// with that account. If the association permission is revoked, the connection
// alias is unshared with the account. For more information, see Cross-Region
// Redirection for Amazon WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
//   - Before performing this operation, call DescribeConnectionAliases (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html)
//     to make sure that the current state of the connection alias is CREATED.
//
//   - To delete a connection alias that has been shared, the shared account
//     must first disassociate the connection alias from any directories it has
//     been associated with. Then you must unshare the connection alias from
//     the account it has been shared with. You can delete a connection alias
//     only after it is no longer shared with any accounts or associated with
//     any directories.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateConnectionAliasPermission for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceAssociatedException
//     The resource is associated with a directory.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectionAliasPermission
func (c *WorkSpaces) UpdateConnectionAliasPermission(input *UpdateConnectionAliasPermissionInput) (*UpdateConnectionAliasPermissionOutput, error) {
	req, out := c.UpdateConnectionAliasPermissionRequest(input)
	return out, req.Send()
}

// UpdateConnectionAliasPermissionWithContext is the same as UpdateConnectionAliasPermission with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnectionAliasPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateConnectionAliasPermissionWithContext(ctx aws.Context, input *UpdateConnectionAliasPermissionInput, opts ...request.Option) (*UpdateConnectionAliasPermissionOutput, error) {
	req, out := c.UpdateConnectionAliasPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRulesOfIpGroup = "UpdateRulesOfIpGroup"

// UpdateRulesOfIpGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRulesOfIpGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRulesOfIpGroup for more information on using the UpdateRulesOfIpGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRulesOfIpGroupRequest method.
//	req, resp := client.UpdateRulesOfIpGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup
func (c *WorkSpaces) UpdateRulesOfIpGroupRequest(input *UpdateRulesOfIpGroupInput) (req *request.Request, output *UpdateRulesOfIpGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateRulesOfIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRulesOfIpGroupInput{}
	}

	output = &UpdateRulesOfIpGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRulesOfIpGroup API operation for Amazon WorkSpaces.
//
// Replaces the current rules of the specified IP access control group with
// the specified rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateRulesOfIpGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup
func (c *WorkSpaces) UpdateRulesOfIpGroup(input *UpdateRulesOfIpGroupInput) (*UpdateRulesOfIpGroupOutput, error) {
	req, out := c.UpdateRulesOfIpGroupRequest(input)
	return out, req.Send()
}

// UpdateRulesOfIpGroupWithContext is the same as UpdateRulesOfIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRulesOfIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateRulesOfIpGroupWithContext(ctx aws.Context, input *UpdateRulesOfIpGroupInput, opts ...request.Option) (*UpdateRulesOfIpGroupOutput, error) {
	req, out := c.UpdateRulesOfIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkspaceBundle = "UpdateWorkspaceBundle"

// UpdateWorkspaceBundleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkspaceBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkspaceBundle for more information on using the UpdateWorkspaceBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkspaceBundleRequest method.
//	req, resp := client.UpdateWorkspaceBundleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceBundle
func (c *WorkSpaces) UpdateWorkspaceBundleRequest(input *UpdateWorkspaceBundleInput) (req *request.Request, output *UpdateWorkspaceBundleOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkspaceBundle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkspaceBundleInput{}
	}

	output = &UpdateWorkspaceBundleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateWorkspaceBundle API operation for Amazon WorkSpaces.
//
// Updates a WorkSpace bundle with a new image. For more information about updating
// WorkSpace bundles, see Update a Custom WorkSpaces Bundle (https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html).
//
// Existing WorkSpaces aren't automatically updated when you update the bundle
// that they're based on. To update existing WorkSpaces that are based on a
// bundle that you've updated, you must either rebuild the WorkSpaces or delete
// and recreate them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateWorkspaceBundle for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceUnavailableException
//     The specified resource is not available.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceBundle
func (c *WorkSpaces) UpdateWorkspaceBundle(input *UpdateWorkspaceBundleInput) (*UpdateWorkspaceBundleOutput, error) {
	req, out := c.UpdateWorkspaceBundleRequest(input)
	return out, req.Send()
}

// UpdateWorkspaceBundleWithContext is the same as UpdateWorkspaceBundle with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkspaceBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateWorkspaceBundleWithContext(ctx aws.Context, input *UpdateWorkspaceBundleInput, opts ...request.Option) (*UpdateWorkspaceBundleOutput, error) {
	req, out := c.UpdateWorkspaceBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkspaceImagePermission = "UpdateWorkspaceImagePermission"

// UpdateWorkspaceImagePermissionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkspaceImagePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkspaceImagePermission for more information on using the UpdateWorkspaceImagePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkspaceImagePermissionRequest method.
//	req, resp := client.UpdateWorkspaceImagePermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceImagePermission
func (c *WorkSpaces) UpdateWorkspaceImagePermissionRequest(input *UpdateWorkspaceImagePermissionInput) (req *request.Request, output *UpdateWorkspaceImagePermissionOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkspaceImagePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkspaceImagePermissionInput{}
	}

	output = &UpdateWorkspaceImagePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateWorkspaceImagePermission API operation for Amazon WorkSpaces.
//
// Shares or unshares an image with one account in the same Amazon Web Services
// Region by specifying whether that account has permission to copy the image.
// If the copy image permission is granted, the image is shared with that account.
// If the copy image permission is revoked, the image is unshared with the account.
//
// After an image has been shared, the recipient account can copy the image
// to other Regions as needed.
//
// In the China (Ningxia) Region, you can copy images only within the same Region.
//
// In Amazon Web Services GovCloud (US), to copy images to and from other Regions,
// contact Amazon Web Services Support.
//
// For more information about sharing images, see Share or Unshare a Custom
// WorkSpaces Image (https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html).
//
//   - To delete an image that has been shared, you must unshare the image
//     before you delete it.
//
//   - Sharing Bring Your Own License (BYOL) images across Amazon Web Services
//     accounts isn't supported at this time in Amazon Web Services GovCloud
//     (US). To share BYOL images across accounts in Amazon Web Services GovCloud
//     (US), contact Amazon Web Services Support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateWorkspaceImagePermission for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceUnavailableException
//     The specified resource is not available.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceImagePermission
func (c *WorkSpaces) UpdateWorkspaceImagePermission(input *UpdateWorkspaceImagePermissionInput) (*UpdateWorkspaceImagePermissionOutput, error) {
	req, out := c.UpdateWorkspaceImagePermissionRequest(input)
	return out, req.Send()
}

// UpdateWorkspaceImagePermissionWithContext is the same as UpdateWorkspaceImagePermission with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkspaceImagePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateWorkspaceImagePermissionWithContext(ctx aws.Context, input *UpdateWorkspaceImagePermissionInput, opts ...request.Option) (*UpdateWorkspaceImagePermissionOutput, error) {
	req, out := c.UpdateWorkspaceImagePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkspacesPool = "UpdateWorkspacesPool"

// UpdateWorkspacesPoolRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkspacesPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkspacesPool for more information on using the UpdateWorkspacesPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkspacesPoolRequest method.
//	req, resp := client.UpdateWorkspacesPoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspacesPool
func (c *WorkSpaces) UpdateWorkspacesPoolRequest(input *UpdateWorkspacesPoolInput) (req *request.Request, output *UpdateWorkspacesPoolOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkspacesPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkspacesPoolInput{}
	}

	output = &UpdateWorkspacesPoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkspacesPool API operation for Amazon WorkSpaces.
//
// Updates the specified pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateWorkspacesPool for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValuesException
//     One or more parameter values are not valid.
//
//   - InvalidResourceStateException
//     The state of the resource is not valid for this operation.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ResourceLimitExceededException
//     Your resource limits have been exceeded.
//
//   - OperationNotSupportedException
//     This operation is not supported.
//
//   - OperationInProgressException
//     The properties of this WorkSpace are currently being modified. Try again
//     in a moment.
//
//   - AccessDeniedException
//     The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspacesPool
func (c *WorkSpaces) UpdateWorkspacesPool(input *UpdateWorkspacesPoolInput) (*UpdateWorkspacesPoolOutput, error) {
	req, out := c.UpdateWorkspacesPoolRequest(input)
	return out, req.Send()
}

// UpdateWorkspacesPoolWithContext is the same as UpdateWorkspacesPool with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkspacesPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateWorkspacesPoolWithContext(ctx aws.Context, input *UpdateWorkspacesPoolInput, opts ...request.Option) (*UpdateWorkspacesPoolOutput, error) {
	req, out := c.UpdateWorkspacesPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptAccountLinkInvitationInput struct {
	_ struct{} `type:"structure"`

	// A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent
	// creation.
	ClientToken *string `type:"string"`

	// The identifier of the account link.
	//
	// LinkId is a required field
	LinkId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptAccountLinkInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptAccountLinkInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptAccountLinkInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptAccountLinkInvitationInput"}
	if s.LinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("LinkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *AcceptAccountLinkInvitationInput) SetClientToken(v string) *AcceptAccountLinkInvitationInput {
	s.ClientToken = &v
	return s
}

// SetLinkId sets the LinkId field's value.
func (s *AcceptAccountLinkInvitationInput) SetLinkId(v string) *AcceptAccountLinkInvitationInput {
	s.LinkId = &v
	return s
}

type AcceptAccountLinkInvitationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the account link.
	AccountLink *AccountLink `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptAccountLinkInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptAccountLinkInvitationOutput) GoString() string {
	return s.String()
}

// SetAccountLink sets the AccountLink field's value.
func (s *AcceptAccountLinkInvitationOutput) SetAccountLink(v *AccountLink) *AcceptAccountLinkInvitationOutput {
	s.AccountLink = v
	return s
}

// The user is not authorized to access a resource.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about about the account link.
type AccountLink struct {
	_ struct{} `type:"structure"`

	// The identifier of the account link.
	AccountLinkId *string `type:"string"`

	// The status of the account link.
	AccountLinkStatus *string `type:"string" enum:"AccountLinkStatusEnum"`

	// The identifier of the source account.
	SourceAccountId *string `type:"string"`

	// The identifier of the target account.
	TargetAccountId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountLink) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountLink) GoString() string {
	return s.String()
}

// SetAccountLinkId sets the AccountLinkId field's value.
func (s *AccountLink) SetAccountLinkId(v string) *AccountLink {
	s.AccountLinkId = &v
	return s
}

// SetAccountLinkStatus sets the AccountLinkStatus field's value.
func (s *AccountLink) SetAccountLinkStatus(v string) *AccountLink {
	s.AccountLinkStatus = &v
	return s
}

// SetSourceAccountId sets the SourceAccountId field's value.
func (s *AccountLink) SetSourceAccountId(v string) *AccountLink {
	s.SourceAccountId = &v
	return s
}

// SetTargetAccountId sets the TargetAccountId field's value.
func (s *AccountLink) SetTargetAccountId(v string) *AccountLink {
	s.TargetAccountId = &v
	return s
}

// Describes a modification to the configuration of Bring Your Own License (BYOL)
// for the specified account.
type AccountModification struct {
	_ struct{} `type:"structure"`

	// The IP address range, specified as an IPv4 CIDR block, for the management
	// network interface used for the account.
	DedicatedTenancyManagementCidrRange *string `type:"string"`

	// The status of BYOL (whether BYOL is being enabled or disabled).
	DedicatedTenancySupport *string `type:"string" enum:"DedicatedTenancySupportResultEnum"`

	// The error code that is returned if the configuration of BYOL cannot be modified.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the configuration of BYOL
	// cannot be modified.
	ErrorMessage *string `type:"string"`

	// The state of the modification to the configuration of BYOL.
	ModificationState *string `type:"string" enum:"DedicatedTenancyModificationStateEnum"`

	// The timestamp when the modification of the BYOL configuration was started.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountModification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountModification) GoString() string {
	return s.String()
}

// SetDedicatedTenancyManagementCidrRange sets the DedicatedTenancyManagementCidrRange field's value.
func (s *AccountModification) SetDedicatedTenancyManagementCidrRange(v string) *AccountModification {
	s.DedicatedTenancyManagementCidrRange = &v
	return s
}

// SetDedicatedTenancySupport sets the DedicatedTenancySupport field's value.
func (s *AccountModification) SetDedicatedTenancySupport(v string) *AccountModification {
	s.DedicatedTenancySupport = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *AccountModification) SetErrorCode(v string) *AccountModification {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *AccountModification) SetErrorMessage(v string) *AccountModification {
	s.ErrorMessage = &v
	return s
}

// SetModificationState sets the ModificationState field's value.
func (s *AccountModification) SetModificationState(v string) *AccountModification {
	s.ModificationState = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AccountModification) SetStartTime(v time.Time) *AccountModification {
	s.StartTime = &v
	return s
}

// Information about the Active Directory config.
type ActiveDirectoryConfig struct {
	_ struct{} `type:"structure"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// Indicates the secret ARN on the service account.
	//
	// ServiceAccountSecretArn is a required field
	ServiceAccountSecretArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveDirectoryConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveDirectoryConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActiveDirectoryConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActiveDirectoryConfig"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.ServiceAccountSecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccountSecretArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ActiveDirectoryConfig) SetDomainName(v string) *ActiveDirectoryConfig {
	s.DomainName = &v
	return s
}

// SetServiceAccountSecretArn sets the ServiceAccountSecretArn field's value.
func (s *ActiveDirectoryConfig) SetServiceAccountSecretArn(v string) *ActiveDirectoryConfig {
	s.ServiceAccountSecretArn = &v
	return s
}

// The specified application is not supported.
type ApplicationNotSupportedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationNotSupportedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationNotSupportedException) GoString() string {
	return s.String()
}

func newErrorApplicationNotSupportedException(v protocol.ResponseMetadata) error {
	return &ApplicationNotSupportedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ApplicationNotSupportedException) Code() string {
	return "ApplicationNotSupportedException"
}

// Message returns the exception's message.
func (s *ApplicationNotSupportedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ApplicationNotSupportedException) OrigErr() error {
	return nil
}

func (s *ApplicationNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ApplicationNotSupportedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ApplicationNotSupportedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the association between an application and an application resource.
type ApplicationResourceAssociation struct {
	_ struct{} `type:"structure"`

	// The identifier of the application.
	ApplicationId *string `type:"string"`

	// The identifier of the associated resource.
	AssociatedResourceId *string `min:"1" type:"string"`

	// The resource type of the associated resource.
	AssociatedResourceType *string `type:"string" enum:"ApplicationAssociatedResourceType"`

	// The time the association was created.
	Created *time.Time `type:"timestamp"`

	// The time the association status was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The status of the application resource association.
	State *string `type:"string" enum:"AssociationState"`

	// The reason the association deployment failed.
	StateReason *AssociationStateReason `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationResourceAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationResourceAssociation) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationResourceAssociation) SetApplicationId(v string) *ApplicationResourceAssociation {
	s.ApplicationId = &v
	return s
}

// SetAssociatedResourceId sets the AssociatedResourceId field's value.
func (s *ApplicationResourceAssociation) SetAssociatedResourceId(v string) *ApplicationResourceAssociation {
	s.AssociatedResourceId = &v
	return s
}

// SetAssociatedResourceType sets the AssociatedResourceType field's value.
func (s *ApplicationResourceAssociation) SetAssociatedResourceType(v string) *ApplicationResourceAssociation {
	s.AssociatedResourceType = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *ApplicationResourceAssociation) SetCreated(v time.Time) *ApplicationResourceAssociation {
	s.Created = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ApplicationResourceAssociation) SetLastUpdatedTime(v time.Time) *ApplicationResourceAssociation {
	s.LastUpdatedTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ApplicationResourceAssociation) SetState(v string) *ApplicationResourceAssociation {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *ApplicationResourceAssociation) SetStateReason(v *AssociationStateReason) *ApplicationResourceAssociation {
	s.StateReason = v
	return s
}

// The persistent application settings for WorkSpaces Pools users.
type ApplicationSettingsRequest struct {
	_ struct{} `type:"structure"`

	// The path prefix for the S3 bucket where users’ persistent application settings
	// are stored. You can allow the same persistent application settings to be
	// used across multiple pools by specifying the same settings group for each
	// pool.
	SettingsGroup *string `type:"string"`

	// Enables or disables persistent application settings for users during their
	// pool sessions.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ApplicationSettingsStatusEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSettingsRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSettingsRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationSettingsRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationSettingsRequest"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSettingsGroup sets the SettingsGroup field's value.
func (s *ApplicationSettingsRequest) SetSettingsGroup(v string) *ApplicationSettingsRequest {
	s.SettingsGroup = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ApplicationSettingsRequest) SetStatus(v string) *ApplicationSettingsRequest {
	s.Status = &v
	return s
}

// Describes the persistent application settings for WorkSpaces Pools users.
type ApplicationSettingsResponse struct {
	_ struct{} `type:"structure"`

	// The S3 bucket where users’ persistent application settings are stored.
	// When persistent application settings are enabled for the first time for an
	// account in an Amazon Web Services Region, an S3 bucket is created. The bucket
	// is unique to the Amazon Web Services account and the Region.
	S3BucketName *string `min:"3" type:"string"`

	// The path prefix for the S3 bucket where users’ persistent application settings
	// are stored.
	SettingsGroup *string `type:"string"`

	// Specifies whether persistent application settings are enabled for users during
	// their pool sessions.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ApplicationSettingsStatusEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSettingsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSettingsResponse) GoString() string {
	return s.String()
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *ApplicationSettingsResponse) SetS3BucketName(v string) *ApplicationSettingsResponse {
	s.S3BucketName = &v
	return s
}

// SetSettingsGroup sets the SettingsGroup field's value.
func (s *ApplicationSettingsResponse) SetSettingsGroup(v string) *ApplicationSettingsResponse {
	s.SettingsGroup = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ApplicationSettingsResponse) SetStatus(v string) *ApplicationSettingsResponse {
	s.Status = &v
	return s
}

type AssociateConnectionAliasInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias.
	//
	// AliasId is a required field
	AliasId *string `min:"13" type:"string" required:"true"`

	// The identifier of the directory to associate the connection alias with.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateConnectionAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateConnectionAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateConnectionAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateConnectionAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}
	if s.AliasId != nil && len(*s.AliasId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("AliasId", 13))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *AssociateConnectionAliasInput) SetAliasId(v string) *AssociateConnectionAliasInput {
	s.AliasId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AssociateConnectionAliasInput) SetResourceId(v string) *AssociateConnectionAliasInput {
	s.ResourceId = &v
	return s
}

type AssociateConnectionAliasOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias association. You use the connection
	// identifier in the DNS TXT record when you're configuring your DNS routing
	// policies.
	ConnectionIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateConnectionAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateConnectionAliasOutput) GoString() string {
	return s.String()
}

// SetConnectionIdentifier sets the ConnectionIdentifier field's value.
func (s *AssociateConnectionAliasOutput) SetConnectionIdentifier(v string) *AssociateConnectionAliasOutput {
	s.ConnectionIdentifier = &v
	return s
}

type AssociateIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`

	// The identifiers of one or more IP access control groups.
	//
	// GroupIds is a required field
	GroupIds []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIpGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateIpGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateIpGroupsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.GroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *AssociateIpGroupsInput) SetDirectoryId(v string) *AssociateIpGroupsInput {
	s.DirectoryId = &v
	return s
}

// SetGroupIds sets the GroupIds field's value.
func (s *AssociateIpGroupsInput) SetGroupIds(v []*string) *AssociateIpGroupsInput {
	s.GroupIds = v
	return s
}

type AssociateIpGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIpGroupsOutput) GoString() string {
	return s.String()
}

type AssociateWorkspaceApplicationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateWorkspaceApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateWorkspaceApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateWorkspaceApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateWorkspaceApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *AssociateWorkspaceApplicationInput) SetApplicationId(v string) *AssociateWorkspaceApplicationInput {
	s.ApplicationId = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *AssociateWorkspaceApplicationInput) SetWorkspaceId(v string) *AssociateWorkspaceApplicationInput {
	s.WorkspaceId = &v
	return s
}

type AssociateWorkspaceApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the association between the specified WorkSpace and the
	// specified application.
	Association *WorkspaceResourceAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateWorkspaceApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateWorkspaceApplicationOutput) GoString() string {
	return s.String()
}

// SetAssociation sets the Association field's value.
func (s *AssociateWorkspaceApplicationOutput) SetAssociation(v *WorkspaceResourceAssociation) *AssociateWorkspaceApplicationOutput {
	s.Association = v
	return s
}

// Indicates the reason that the association deployment failed, including the
// error code and error message.
type AssociationStateReason struct {
	_ struct{} `type:"structure"`

	// The error code of the association deployment failure.
	ErrorCode *string `type:"string" enum:"AssociationErrorCode"`

	// The error message of the association deployment failure.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationStateReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociationStateReason) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *AssociationStateReason) SetErrorCode(v string) *AssociationStateReason {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *AssociationStateReason) SetErrorMessage(v string) *AssociationStateReason {
	s.ErrorMessage = &v
	return s
}

type AuthorizeIpRulesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// The rules to add to the group.
	//
	// UserRules is a required field
	UserRules []*IpRuleItem `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizeIpRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizeIpRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeIpRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeIpRulesInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.UserRules == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *AuthorizeIpRulesInput) SetGroupId(v string) *AuthorizeIpRulesInput {
	s.GroupId = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *AuthorizeIpRulesInput) SetUserRules(v []*IpRuleItem) *AuthorizeIpRulesInput {
	s.UserRules = v
	return s
}

type AuthorizeIpRulesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizeIpRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizeIpRulesOutput) GoString() string {
	return s.String()
}

// Describes the association between an application and a bundle resource.
type BundleResourceAssociation struct {
	_ struct{} `type:"structure"`

	// The identifier of the associated resource.
	AssociatedResourceId *string `min:"1" type:"string"`

	// The resource type of the associated resources.
	AssociatedResourceType *string `type:"string" enum:"BundleAssociatedResourceType"`

	// The identifier of the bundle.
	BundleId *string `type:"string"`

	// The time the association is created.
	Created *time.Time `type:"timestamp"`

	// The time the association status was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The status of the bundle resource association.
	State *string `type:"string" enum:"AssociationState"`

	// The reason the association deployment failed.
	StateReason *AssociationStateReason `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BundleResourceAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BundleResourceAssociation) GoString() string {
	return s.String()
}

// SetAssociatedResourceId sets the AssociatedResourceId field's value.
func (s *BundleResourceAssociation) SetAssociatedResourceId(v string) *BundleResourceAssociation {
	s.AssociatedResourceId = &v
	return s
}

// SetAssociatedResourceType sets the AssociatedResourceType field's value.
func (s *BundleResourceAssociation) SetAssociatedResourceType(v string) *BundleResourceAssociation {
	s.AssociatedResourceType = &v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *BundleResourceAssociation) SetBundleId(v string) *BundleResourceAssociation {
	s.BundleId = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *BundleResourceAssociation) SetCreated(v time.Time) *BundleResourceAssociation {
	s.Created = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *BundleResourceAssociation) SetLastUpdatedTime(v time.Time) *BundleResourceAssociation {
	s.LastUpdatedTime = &v
	return s
}

// SetState sets the State field's value.
func (s *BundleResourceAssociation) SetState(v string) *BundleResourceAssociation {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *BundleResourceAssociation) SetStateReason(v *AssociationStateReason) *BundleResourceAssociation {
	s.StateReason = v
	return s
}

// Describes the user capacity for a pool of WorkSpaces.
type Capacity struct {
	_ struct{} `type:"structure"`

	// The desired number of user sessions for the WorkSpaces in the pool.
	//
	// DesiredUserSessions is a required field
	DesiredUserSessions *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Capacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Capacity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Capacity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Capacity"}
	if s.DesiredUserSessions == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredUserSessions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredUserSessions sets the DesiredUserSessions field's value.
func (s *Capacity) SetDesiredUserSessions(v int64) *Capacity {
	s.DesiredUserSessions = &v
	return s
}

// Describes the capacity status for a pool of WorkSpaces.
type CapacityStatus struct {
	_ struct{} `type:"structure"`

	// The number of user sessions currently being used for your pool.
	//
	// ActiveUserSessions is a required field
	ActiveUserSessions *int64 `type:"integer" required:"true"`

	// The total number of user sessions that are available for streaming or are
	// currently streaming in your pool.
	//
	// ActualUserSessions = AvailableUserSessions + ActiveUserSessions
	//
	// ActualUserSessions is a required field
	ActualUserSessions *int64 `type:"integer" required:"true"`

	// The number of user sessions currently available for streaming from your pool.
	//
	// AvailableUserSessions = ActualUserSessions - ActiveUserSessions
	//
	// AvailableUserSessions is a required field
	AvailableUserSessions *int64 `type:"integer" required:"true"`

	// The total number of sessions slots that are either running or pending. This
	// represents the total number of concurrent streaming sessions your pool can
	// support in a steady state.
	//
	// DesiredUserSessions is a required field
	DesiredUserSessions *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityStatus) GoString() string {
	return s.String()
}

// SetActiveUserSessions sets the ActiveUserSessions field's value.
func (s *CapacityStatus) SetActiveUserSessions(v int64) *CapacityStatus {
	s.ActiveUserSessions = &v
	return s
}

// SetActualUserSessions sets the ActualUserSessions field's value.
func (s *CapacityStatus) SetActualUserSessions(v int64) *CapacityStatus {
	s.ActualUserSessions = &v
	return s
}

// SetAvailableUserSessions sets the AvailableUserSessions field's value.
func (s *CapacityStatus) SetAvailableUserSessions(v int64) *CapacityStatus {
	s.AvailableUserSessions = &v
	return s
}

// SetDesiredUserSessions sets the DesiredUserSessions field's value.
func (s *CapacityStatus) SetDesiredUserSessions(v int64) *CapacityStatus {
	s.DesiredUserSessions = &v
	return s
}

// Describes the properties of the certificate-based authentication you want
// to use with your WorkSpaces.
type CertificateBasedAuthProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager
	// Private CA resource.
	CertificateAuthorityArn *string `min:"5" type:"string"`

	// The status of the certificate-based authentication properties.
	Status *string `type:"string" enum:"CertificateBasedAuthStatusEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateBasedAuthProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateBasedAuthProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CertificateBasedAuthProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CertificateBasedAuthProperties"}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *CertificateBasedAuthProperties) SetCertificateAuthorityArn(v string) *CertificateBasedAuthProperties {
	s.CertificateAuthorityArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CertificateBasedAuthProperties) SetStatus(v string) *CertificateBasedAuthProperties {
	s.Status = &v
	return s
}

// Describes an Amazon WorkSpaces client.
type ClientProperties struct {
	_ struct{} `type:"structure"`

	// Specifies whether users can upload diagnostic log files of Amazon WorkSpaces
	// client directly to WorkSpaces to troubleshoot issues when using the WorkSpaces
	// client. When enabled, the log files will be sent to WorkSpaces automatically
	// and will be applied to all users in the specified directory.
	LogUploadEnabled *string `type:"string" enum:"LogUploadEnum"`

	// Specifies whether users can cache their credentials on the Amazon WorkSpaces
	// client. When enabled, users can choose to reconnect to their WorkSpaces without
	// re-entering their credentials.
	ReconnectEnabled *string `type:"string" enum:"ReconnectEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientProperties) GoString() string {
	return s.String()
}

// SetLogUploadEnabled sets the LogUploadEnabled field's value.
func (s *ClientProperties) SetLogUploadEnabled(v string) *ClientProperties {
	s.LogUploadEnabled = &v
	return s
}

// SetReconnectEnabled sets the ReconnectEnabled field's value.
func (s *ClientProperties) SetReconnectEnabled(v string) *ClientProperties {
	s.ReconnectEnabled = &v
	return s
}

// Information about the Amazon WorkSpaces client.
type ClientPropertiesResult struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon WorkSpaces client.
	ClientProperties *ClientProperties `type:"structure"`

	// The resource identifier, in the form of a directory ID.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientPropertiesResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientPropertiesResult) GoString() string {
	return s.String()
}

// SetClientProperties sets the ClientProperties field's value.
func (s *ClientPropertiesResult) SetClientProperties(v *ClientProperties) *ClientPropertiesResult {
	s.ClientProperties = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ClientPropertiesResult) SetResourceId(v string) *ClientPropertiesResult {
	s.ResourceId = &v
	return s
}

// The compute type of the WorkSpace is not compatible with the application.
type ComputeNotCompatibleException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeNotCompatibleException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeNotCompatibleException) GoString() string {
	return s.String()
}

func newErrorComputeNotCompatibleException(v protocol.ResponseMetadata) error {
	return &ComputeNotCompatibleException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ComputeNotCompatibleException) Code() string {
	return "ComputeNotCompatibleException"
}

// Message returns the exception's message.
func (s *ComputeNotCompatibleException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ComputeNotCompatibleException) OrigErr() error {
	return nil
}

func (s *ComputeNotCompatibleException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ComputeNotCompatibleException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ComputeNotCompatibleException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the compute type of the bundle.
type ComputeType struct {
	_ struct{} `type:"structure"`

	// The compute type.
	Name *string `type:"string" enum:"Compute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeType) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ComputeType) SetName(v string) *ComputeType {
	s.Name = &v
	return s
}

// The TargetAccountId is already linked or invited.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes an Amazon Connect client add-in.
type ConnectClientAddIn struct {
	_ struct{} `type:"structure"`

	// The client add-in identifier.
	AddInId *string `min:"36" type:"string"`

	// The name of the client add in.
	Name *string `min:"1" type:"string"`

	// The directory identifier for which the client add-in is configured.
	ResourceId *string `min:"10" type:"string"`

	// The endpoint URL of the client add-in.
	URL *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectClientAddIn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectClientAddIn) GoString() string {
	return s.String()
}

// SetAddInId sets the AddInId field's value.
func (s *ConnectClientAddIn) SetAddInId(v string) *ConnectClientAddIn {
	s.AddInId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConnectClientAddIn) SetName(v string) *ConnectClientAddIn {
	s.Name = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ConnectClientAddIn) SetResourceId(v string) *ConnectClientAddIn {
	s.ResourceId = &v
	return s
}

// SetURL sets the URL field's value.
func (s *ConnectClientAddIn) SetURL(v string) *ConnectClientAddIn {
	s.URL = &v
	return s
}

// Describes a connection alias. Connection aliases are used for cross-Region
// redirection. For more information, see Cross-Region Redirection for Amazon
// WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
type ConnectionAlias struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias.
	AliasId *string `min:"13" type:"string"`

	// The association status of the connection alias.
	Associations []*ConnectionAliasAssociation `min:"1" type:"list"`

	// The connection string specified for the connection alias. The connection
	// string must be in the form of a fully qualified domain name (FQDN), such
	// as www.example.com.
	ConnectionString *string `min:"1" type:"string"`

	// The identifier of the Amazon Web Services account that owns the connection
	// alias.
	OwnerAccountId *string `type:"string"`

	// The current state of the connection alias.
	State *string `type:"string" enum:"ConnectionAliasState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAlias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAlias) GoString() string {
	return s.String()
}

// SetAliasId sets the AliasId field's value.
func (s *ConnectionAlias) SetAliasId(v string) *ConnectionAlias {
	s.AliasId = &v
	return s
}

// SetAssociations sets the Associations field's value.
func (s *ConnectionAlias) SetAssociations(v []*ConnectionAliasAssociation) *ConnectionAlias {
	s.Associations = v
	return s
}

// SetConnectionString sets the ConnectionString field's value.
func (s *ConnectionAlias) SetConnectionString(v string) *ConnectionAlias {
	s.ConnectionString = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *ConnectionAlias) SetOwnerAccountId(v string) *ConnectionAlias {
	s.OwnerAccountId = &v
	return s
}

// SetState sets the State field's value.
func (s *ConnectionAlias) SetState(v string) *ConnectionAlias {
	s.State = &v
	return s
}

// Describes a connection alias association that is used for cross-Region redirection.
// For more information, see Cross-Region Redirection for Amazon WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
type ConnectionAliasAssociation struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account that associated the connection
	// alias with a directory.
	AssociatedAccountId *string `type:"string"`

	// The association status of the connection alias.
	AssociationStatus *string `type:"string" enum:"AssociationStatus"`

	// The identifier of the connection alias association. You use the connection
	// identifier in the DNS TXT record when you're configuring your DNS routing
	// policies.
	ConnectionIdentifier *string `min:"1" type:"string"`

	// The identifier of the directory associated with a connection alias.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAliasAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAliasAssociation) GoString() string {
	return s.String()
}

// SetAssociatedAccountId sets the AssociatedAccountId field's value.
func (s *ConnectionAliasAssociation) SetAssociatedAccountId(v string) *ConnectionAliasAssociation {
	s.AssociatedAccountId = &v
	return s
}

// SetAssociationStatus sets the AssociationStatus field's value.
func (s *ConnectionAliasAssociation) SetAssociationStatus(v string) *ConnectionAliasAssociation {
	s.AssociationStatus = &v
	return s
}

// SetConnectionIdentifier sets the ConnectionIdentifier field's value.
func (s *ConnectionAliasAssociation) SetConnectionIdentifier(v string) *ConnectionAliasAssociation {
	s.ConnectionIdentifier = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ConnectionAliasAssociation) SetResourceId(v string) *ConnectionAliasAssociation {
	s.ResourceId = &v
	return s
}

// Describes the permissions for a connection alias. Connection aliases are
// used for cross-Region redirection. For more information, see Cross-Region
// Redirection for Amazon WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
type ConnectionAliasPermission struct {
	_ struct{} `type:"structure"`

	// Indicates whether the specified Amazon Web Services account is allowed to
	// associate the connection alias with a directory.
	//
	// AllowAssociation is a required field
	AllowAssociation *bool `type:"boolean" required:"true"`

	// The identifier of the Amazon Web Services account that the connection alias
	// is shared with.
	//
	// SharedAccountId is a required field
	SharedAccountId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAliasPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAliasPermission) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionAliasPermission) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectionAliasPermission"}
	if s.AllowAssociation == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowAssociation"))
	}
	if s.SharedAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowAssociation sets the AllowAssociation field's value.
func (s *ConnectionAliasPermission) SetAllowAssociation(v bool) *ConnectionAliasPermission {
	s.AllowAssociation = &v
	return s
}

// SetSharedAccountId sets the SharedAccountId field's value.
func (s *ConnectionAliasPermission) SetSharedAccountId(v string) *ConnectionAliasPermission {
	s.SharedAccountId = &v
	return s
}

type CopyWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// A description of the image.
	Description *string `min:"1" type:"string"`

	// The name of the image.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The identifier of the source image.
	//
	// SourceImageId is a required field
	SourceImageId *string `type:"string" required:"true"`

	// The identifier of the source Region.
	//
	// SourceRegion is a required field
	SourceRegion *string `min:"1" type:"string" required:"true"`

	// The tags for the image.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyWorkspaceImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyWorkspaceImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyWorkspaceImageInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SourceImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceImageId"))
	}
	if s.SourceRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceRegion"))
	}
	if s.SourceRegion != nil && len(*s.SourceRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceRegion", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CopyWorkspaceImageInput) SetDescription(v string) *CopyWorkspaceImageInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CopyWorkspaceImageInput) SetName(v string) *CopyWorkspaceImageInput {
	s.Name = &v
	return s
}

// SetSourceImageId sets the SourceImageId field's value.
func (s *CopyWorkspaceImageInput) SetSourceImageId(v string) *CopyWorkspaceImageInput {
	s.SourceImageId = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CopyWorkspaceImageInput) SetSourceRegion(v string) *CopyWorkspaceImageInput {
	s.SourceRegion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyWorkspaceImageInput) SetTags(v []*Tag) *CopyWorkspaceImageInput {
	s.Tags = v
	return s
}

type CopyWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	ImageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyWorkspaceImageOutput) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *CopyWorkspaceImageOutput) SetImageId(v string) *CopyWorkspaceImageOutput {
	s.ImageId = &v
	return s
}

type CreateAccountLinkInvitationInput struct {
	_ struct{} `type:"structure"`

	// A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent
	// creation.
	ClientToken *string `type:"string"`

	// The identifier of the target account.
	//
	// TargetAccountId is a required field
	TargetAccountId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountLinkInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountLinkInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccountLinkInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccountLinkInvitationInput"}
	if s.TargetAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAccountLinkInvitationInput) SetClientToken(v string) *CreateAccountLinkInvitationInput {
	s.ClientToken = &v
	return s
}

// SetTargetAccountId sets the TargetAccountId field's value.
func (s *CreateAccountLinkInvitationInput) SetTargetAccountId(v string) *CreateAccountLinkInvitationInput {
	s.TargetAccountId = &v
	return s
}

type CreateAccountLinkInvitationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the account link.
	AccountLink *AccountLink `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountLinkInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountLinkInvitationOutput) GoString() string {
	return s.String()
}

// SetAccountLink sets the AccountLink field's value.
func (s *CreateAccountLinkInvitationOutput) SetAccountLink(v *AccountLink) *CreateAccountLinkInvitationOutput {
	s.AccountLink = v
	return s
}

type CreateConnectClientAddInInput struct {
	_ struct{} `type:"structure"`

	// The name of the client add-in.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The directory identifier for which to configure the client add-in.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The endpoint URL of the Amazon Connect client add-in.
	//
	// URL is a required field
	URL *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectClientAddInInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectClientAddInInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectClientAddInInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectClientAddInInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.URL == nil {
		invalidParams.Add(request.NewErrParamRequired("URL"))
	}
	if s.URL != nil && len(*s.URL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("URL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateConnectClientAddInInput) SetName(v string) *CreateConnectClientAddInInput {
	s.Name = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateConnectClientAddInInput) SetResourceId(v string) *CreateConnectClientAddInInput {
	s.ResourceId = &v
	return s
}

// SetURL sets the URL field's value.
func (s *CreateConnectClientAddInInput) SetURL(v string) *CreateConnectClientAddInInput {
	s.URL = &v
	return s
}

type CreateConnectClientAddInOutput struct {
	_ struct{} `type:"structure"`

	// The client add-in identifier.
	AddInId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectClientAddInOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectClientAddInOutput) GoString() string {
	return s.String()
}

// SetAddInId sets the AddInId field's value.
func (s *CreateConnectClientAddInOutput) SetAddInId(v string) *CreateConnectClientAddInOutput {
	s.AddInId = &v
	return s
}

type CreateConnectionAliasInput struct {
	_ struct{} `type:"structure"`

	// A connection string in the form of a fully qualified domain name (FQDN),
	// such as www.example.com.
	//
	// After you create a connection string, it is always associated to your Amazon
	// Web Services account. You cannot recreate the same connection string with
	// a different account, even if you delete all instances of it from the original
	// account. The connection string is globally reserved for your account.
	//
	// ConnectionString is a required field
	ConnectionString *string `min:"1" type:"string" required:"true"`

	// The tags to associate with the connection alias.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionAliasInput"}
	if s.ConnectionString == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionString"))
	}
	if s.ConnectionString != nil && len(*s.ConnectionString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionString", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionString sets the ConnectionString field's value.
func (s *CreateConnectionAliasInput) SetConnectionString(v string) *CreateConnectionAliasInput {
	s.ConnectionString = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConnectionAliasInput) SetTags(v []*Tag) *CreateConnectionAliasInput {
	s.Tags = v
	return s
}

type CreateConnectionAliasOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias.
	AliasId *string `min:"13" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionAliasOutput) GoString() string {
	return s.String()
}

// SetAliasId sets the AliasId field's value.
func (s *CreateConnectionAliasOutput) SetAliasId(v string) *CreateConnectionAliasOutput {
	s.AliasId = &v
	return s
}

type CreateIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The description of the group.
	GroupDesc *string `type:"string"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `type:"string" required:"true"`

	// The tags. Each WorkSpaces resource can have a maximum of 50 tags.
	Tags []*Tag `type:"list"`

	// The rules to add to the group.
	UserRules []*IpRuleItem `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIpGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupDesc sets the GroupDesc field's value.
func (s *CreateIpGroupInput) SetGroupDesc(v string) *CreateIpGroupInput {
	s.GroupDesc = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateIpGroupInput) SetGroupName(v string) *CreateIpGroupInput {
	s.GroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIpGroupInput) SetTags(v []*Tag) *CreateIpGroupInput {
	s.Tags = v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *CreateIpGroupInput) SetUserRules(v []*IpRuleItem) *CreateIpGroupInput {
	s.UserRules = v
	return s
}

type CreateIpGroupOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	GroupId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIpGroupOutput) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *CreateIpGroupOutput) SetGroupId(v string) *CreateIpGroupOutput {
	s.GroupId = &v
	return s
}

type CreateStandbyWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The Region of the primary WorkSpace.
	//
	// PrimaryRegion is a required field
	PrimaryRegion *string `min:"1" type:"string" required:"true"`

	// Information about the standby WorkSpace to be created.
	//
	// StandbyWorkspaces is a required field
	StandbyWorkspaces []*StandbyWorkspace `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStandbyWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStandbyWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStandbyWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStandbyWorkspacesInput"}
	if s.PrimaryRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryRegion"))
	}
	if s.PrimaryRegion != nil && len(*s.PrimaryRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryRegion", 1))
	}
	if s.StandbyWorkspaces == nil {
		invalidParams.Add(request.NewErrParamRequired("StandbyWorkspaces"))
	}
	if s.StandbyWorkspaces != nil {
		for i, v := range s.StandbyWorkspaces {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StandbyWorkspaces", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrimaryRegion sets the PrimaryRegion field's value.
func (s *CreateStandbyWorkspacesInput) SetPrimaryRegion(v string) *CreateStandbyWorkspacesInput {
	s.PrimaryRegion = &v
	return s
}

// SetStandbyWorkspaces sets the StandbyWorkspaces field's value.
func (s *CreateStandbyWorkspacesInput) SetStandbyWorkspaces(v []*StandbyWorkspace) *CreateStandbyWorkspacesInput {
	s.StandbyWorkspaces = v
	return s
}

type CreateStandbyWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the standby WorkSpace that could not be created.
	FailedStandbyRequests []*FailedCreateStandbyWorkspacesRequest `type:"list"`

	// Information about the standby WorkSpace that was created.
	PendingStandbyRequests []*PendingCreateStandbyWorkspacesRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStandbyWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStandbyWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedStandbyRequests sets the FailedStandbyRequests field's value.
func (s *CreateStandbyWorkspacesOutput) SetFailedStandbyRequests(v []*FailedCreateStandbyWorkspacesRequest) *CreateStandbyWorkspacesOutput {
	s.FailedStandbyRequests = v
	return s
}

// SetPendingStandbyRequests sets the PendingStandbyRequests field's value.
func (s *CreateStandbyWorkspacesOutput) SetPendingStandbyRequests(v []*PendingCreateStandbyWorkspacesRequest) *CreateStandbyWorkspacesOutput {
	s.PendingStandbyRequests = v
	return s
}

type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpaces resource. The supported resource types are
	// WorkSpaces, registered directories, images, custom bundles, IP access control
	// groups, and connection aliases.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The tags. Each WorkSpaces resource can have a maximum of 50 tags.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateTagsInput) SetResourceId(v string) *CreateTagsInput {
	s.ResourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v []*Tag) *CreateTagsInput {
	s.Tags = v
	return s
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

type CreateUpdatedWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// A description of whether updates for the WorkSpace image are available.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The name of the new updated WorkSpace image.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The identifier of the source WorkSpace image.
	//
	// SourceImageId is a required field
	SourceImageId *string `type:"string" required:"true"`

	// The tags that you want to add to the new updated WorkSpace image.
	//
	// To add tags at the same time when you're creating the updated image, you
	// must create an IAM policy that grants your IAM user permissions to use workspaces:CreateTags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUpdatedWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUpdatedWorkspaceImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUpdatedWorkspaceImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUpdatedWorkspaceImageInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SourceImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceImageId"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateUpdatedWorkspaceImageInput) SetDescription(v string) *CreateUpdatedWorkspaceImageInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateUpdatedWorkspaceImageInput) SetName(v string) *CreateUpdatedWorkspaceImageInput {
	s.Name = &v
	return s
}

// SetSourceImageId sets the SourceImageId field's value.
func (s *CreateUpdatedWorkspaceImageInput) SetSourceImageId(v string) *CreateUpdatedWorkspaceImageInput {
	s.SourceImageId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUpdatedWorkspaceImageInput) SetTags(v []*Tag) *CreateUpdatedWorkspaceImageInput {
	s.Tags = v
	return s
}

type CreateUpdatedWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the new updated WorkSpace image.
	ImageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUpdatedWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUpdatedWorkspaceImageOutput) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *CreateUpdatedWorkspaceImageOutput) SetImageId(v string) *CreateUpdatedWorkspaceImageOutput {
	s.ImageId = &v
	return s
}

type CreateWorkspaceBundleInput struct {
	_ struct{} `type:"structure"`

	// The description of the bundle.
	//
	// BundleDescription is a required field
	BundleDescription *string `min:"1" type:"string" required:"true"`

	// The name of the bundle.
	//
	// BundleName is a required field
	BundleName *string `min:"1" type:"string" required:"true"`

	// Describes the compute type of the bundle.
	//
	// ComputeType is a required field
	ComputeType *ComputeType `type:"structure" required:"true"`

	// The identifier of the image that is used to create the bundle.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`

	// Describes the root volume for a WorkSpace bundle.
	RootStorage *RootStorage `type:"structure"`

	// The tags associated with the bundle.
	//
	// To add tags at the same time when you're creating the bundle, you must create
	// an IAM policy that grants your IAM user permissions to use workspaces:CreateTags.
	Tags []*Tag `type:"list"`

	// Describes the user volume for a WorkSpace bundle.
	//
	// UserStorage is a required field
	UserStorage *UserStorage `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceBundleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceBundleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspaceBundleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspaceBundleInput"}
	if s.BundleDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleDescription"))
	}
	if s.BundleDescription != nil && len(*s.BundleDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BundleDescription", 1))
	}
	if s.BundleName == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleName"))
	}
	if s.BundleName != nil && len(*s.BundleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BundleName", 1))
	}
	if s.ComputeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeType"))
	}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}
	if s.UserStorage == nil {
		invalidParams.Add(request.NewErrParamRequired("UserStorage"))
	}
	if s.RootStorage != nil {
		if err := s.RootStorage.Validate(); err != nil {
			invalidParams.AddNested("RootStorage", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UserStorage != nil {
		if err := s.UserStorage.Validate(); err != nil {
			invalidParams.AddNested("UserStorage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleDescription sets the BundleDescription field's value.
func (s *CreateWorkspaceBundleInput) SetBundleDescription(v string) *CreateWorkspaceBundleInput {
	s.BundleDescription = &v
	return s
}

// SetBundleName sets the BundleName field's value.
func (s *CreateWorkspaceBundleInput) SetBundleName(v string) *CreateWorkspaceBundleInput {
	s.BundleName = &v
	return s
}

// SetComputeType sets the ComputeType field's value.
func (s *CreateWorkspaceBundleInput) SetComputeType(v *ComputeType) *CreateWorkspaceBundleInput {
	s.ComputeType = v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *CreateWorkspaceBundleInput) SetImageId(v string) *CreateWorkspaceBundleInput {
	s.ImageId = &v
	return s
}

// SetRootStorage sets the RootStorage field's value.
func (s *CreateWorkspaceBundleInput) SetRootStorage(v *RootStorage) *CreateWorkspaceBundleInput {
	s.RootStorage = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkspaceBundleInput) SetTags(v []*Tag) *CreateWorkspaceBundleInput {
	s.Tags = v
	return s
}

// SetUserStorage sets the UserStorage field's value.
func (s *CreateWorkspaceBundleInput) SetUserStorage(v *UserStorage) *CreateWorkspaceBundleInput {
	s.UserStorage = v
	return s
}

type CreateWorkspaceBundleOutput struct {
	_ struct{} `type:"structure"`

	// Describes a WorkSpace bundle.
	WorkspaceBundle *WorkspaceBundle `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceBundleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceBundleOutput) GoString() string {
	return s.String()
}

// SetWorkspaceBundle sets the WorkspaceBundle field's value.
func (s *CreateWorkspaceBundleOutput) SetWorkspaceBundle(v *WorkspaceBundle) *CreateWorkspaceBundleOutput {
	s.WorkspaceBundle = v
	return s
}

type CreateWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// The description of the new WorkSpace image.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The name of the new WorkSpace image.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The tags that you want to add to the new WorkSpace image. To add tags when
	// you're creating the image, you must create an IAM policy that grants your
	// IAM user permission to use workspaces:CreateTags.
	Tags []*Tag `type:"list"`

	// The identifier of the source WorkSpace
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspaceImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspaceImageInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateWorkspaceImageInput) SetDescription(v string) *CreateWorkspaceImageInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkspaceImageInput) SetName(v string) *CreateWorkspaceImageInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkspaceImageInput) SetTags(v []*Tag) *CreateWorkspaceImageInput {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateWorkspaceImageInput) SetWorkspaceId(v string) *CreateWorkspaceImageInput {
	s.WorkspaceId = &v
	return s
}

type CreateWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`

	// The date when the image was created.
	Created *time.Time `type:"timestamp"`

	// The description of the image.
	Description *string `min:"1" type:"string"`

	// The identifier of the new WorkSpace image.
	ImageId *string `type:"string"`

	// The name of the image.
	Name *string `min:"1" type:"string"`

	// The operating system that the image is running.
	OperatingSystem *OperatingSystem `type:"structure"`

	// The identifier of the Amazon Web Services account that owns the image.
	OwnerAccountId *string `type:"string"`

	// Specifies whether the image is running on dedicated hardware. When Bring
	// Your Own License (BYOL) is enabled, this value is set to DEDICATED. For more
	// information, see Bring Your Own Windows Desktop Images. (https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.htm).
	RequiredTenancy *string `type:"string" enum:"WorkspaceImageRequiredTenancy"`

	// The availability status of the image.
	State *string `type:"string" enum:"WorkspaceImageState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceImageOutput) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *CreateWorkspaceImageOutput) SetCreated(v time.Time) *CreateWorkspaceImageOutput {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWorkspaceImageOutput) SetDescription(v string) *CreateWorkspaceImageOutput {
	s.Description = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *CreateWorkspaceImageOutput) SetImageId(v string) *CreateWorkspaceImageOutput {
	s.ImageId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkspaceImageOutput) SetName(v string) *CreateWorkspaceImageOutput {
	s.Name = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *CreateWorkspaceImageOutput) SetOperatingSystem(v *OperatingSystem) *CreateWorkspaceImageOutput {
	s.OperatingSystem = v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *CreateWorkspaceImageOutput) SetOwnerAccountId(v string) *CreateWorkspaceImageOutput {
	s.OwnerAccountId = &v
	return s
}

// SetRequiredTenancy sets the RequiredTenancy field's value.
func (s *CreateWorkspaceImageOutput) SetRequiredTenancy(v string) *CreateWorkspaceImageOutput {
	s.RequiredTenancy = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateWorkspaceImageOutput) SetState(v string) *CreateWorkspaceImageOutput {
	s.State = &v
	return s
}

type CreateWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to create. You can specify up to 25 WorkSpaces.
	//
	// Workspaces is a required field
	Workspaces []*WorkspaceRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspacesInput"}
	if s.Workspaces == nil {
		invalidParams.Add(request.NewErrParamRequired("Workspaces"))
	}
	if s.Workspaces != nil && len(s.Workspaces) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Workspaces", 1))
	}
	if s.Workspaces != nil {
		for i, v := range s.Workspaces {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Workspaces", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaces sets the Workspaces field's value.
func (s *CreateWorkspacesInput) SetWorkspaces(v []*WorkspaceRequest) *CreateWorkspacesInput {
	s.Workspaces = v
	return s
}

type CreateWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be created.
	FailedRequests []*FailedCreateWorkspaceRequest `type:"list"`

	// Information about the WorkSpaces that were created.
	//
	// Because this operation is asynchronous, the identifier returned is not immediately
	// available for use with other operations. For example, if you call DescribeWorkspaces
	// before the WorkSpace is created, the information returned can be incomplete.
	PendingRequests []*Workspace `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *CreateWorkspacesOutput) SetFailedRequests(v []*FailedCreateWorkspaceRequest) *CreateWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// SetPendingRequests sets the PendingRequests field's value.
func (s *CreateWorkspacesOutput) SetPendingRequests(v []*Workspace) *CreateWorkspacesOutput {
	s.PendingRequests = v
	return s
}

type CreateWorkspacesPoolInput struct {
	_ struct{} `type:"structure"`

	// Indicates the application settings of the pool.
	ApplicationSettings *ApplicationSettingsRequest `type:"structure"`

	// The identifier of the bundle for the pool.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`

	// The user capacity of the pool.
	//
	// Capacity is a required field
	Capacity *Capacity `type:"structure" required:"true"`

	// The pool description.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The identifier of the directory for the pool.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`

	// The name of the pool.
	//
	// PoolName is a required field
	PoolName *string `type:"string" required:"true"`

	// The tags for the pool.
	Tags []*Tag `type:"list"`

	// Indicates the timeout settings of the pool.
	TimeoutSettings *TimeoutSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspacesPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspacesPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspacesPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspacesPoolInput"}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.Capacity == nil {
		invalidParams.Add(request.NewErrParamRequired("Capacity"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.PoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolName"))
	}
	if s.ApplicationSettings != nil {
		if err := s.ApplicationSettings.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Capacity != nil {
		if err := s.Capacity.Validate(); err != nil {
			invalidParams.AddNested("Capacity", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TimeoutSettings != nil {
		if err := s.TimeoutSettings.Validate(); err != nil {
			invalidParams.AddNested("TimeoutSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationSettings sets the ApplicationSettings field's value.
func (s *CreateWorkspacesPoolInput) SetApplicationSettings(v *ApplicationSettingsRequest) *CreateWorkspacesPoolInput {
	s.ApplicationSettings = v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *CreateWorkspacesPoolInput) SetBundleId(v string) *CreateWorkspacesPoolInput {
	s.BundleId = &v
	return s
}

// SetCapacity sets the Capacity field's value.
func (s *CreateWorkspacesPoolInput) SetCapacity(v *Capacity) *CreateWorkspacesPoolInput {
	s.Capacity = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWorkspacesPoolInput) SetDescription(v string) *CreateWorkspacesPoolInput {
	s.Description = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateWorkspacesPoolInput) SetDirectoryId(v string) *CreateWorkspacesPoolInput {
	s.DirectoryId = &v
	return s
}

// SetPoolName sets the PoolName field's value.
func (s *CreateWorkspacesPoolInput) SetPoolName(v string) *CreateWorkspacesPoolInput {
	s.PoolName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkspacesPoolInput) SetTags(v []*Tag) *CreateWorkspacesPoolInput {
	s.Tags = v
	return s
}

// SetTimeoutSettings sets the TimeoutSettings field's value.
func (s *CreateWorkspacesPoolInput) SetTimeoutSettings(v *TimeoutSettings) *CreateWorkspacesPoolInput {
	s.TimeoutSettings = v
	return s
}

type CreateWorkspacesPoolOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the pool to create.
	WorkspacesPool *WorkspacesPool `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspacesPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspacesPoolOutput) GoString() string {
	return s.String()
}

// SetWorkspacesPool sets the WorkspacesPool field's value.
func (s *CreateWorkspacesPoolOutput) SetWorkspacesPool(v *WorkspacesPool) *CreateWorkspacesPoolOutput {
	s.WorkspacesPool = v
	return s
}

// Describes the data replication settings.
type DataReplicationSettings struct {
	_ struct{} `type:"structure"`

	// Indicates whether data replication is enabled, and if enabled, the type of
	// data replication.
	DataReplication *string `type:"string" enum:"DataReplication"`

	// The date and time at which the last successful snapshot was taken of the
	// primary WorkSpace used for replicating data.
	RecoverySnapshotTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationSettings) GoString() string {
	return s.String()
}

// SetDataReplication sets the DataReplication field's value.
func (s *DataReplicationSettings) SetDataReplication(v string) *DataReplicationSettings {
	s.DataReplication = &v
	return s
}

// SetRecoverySnapshotTime sets the RecoverySnapshotTime field's value.
func (s *DataReplicationSettings) SetRecoverySnapshotTime(v time.Time) *DataReplicationSettings {
	s.RecoverySnapshotTime = &v
	return s
}

// Returns default client branding attributes that were imported. These attributes
// display on the client login screen.
//
// Client branding attributes are public facing. Ensure that you don't include
// sensitive information.
type DefaultClientBrandingAttributes struct {
	_ struct{} `type:"structure"`

	// The forgotten password link. This is the web address that users can go to
	// if they forget the password for their WorkSpace.
	ForgotPasswordLink *string `min:"1" type:"string"`

	// The login message. Specified as a key value pair, in which the key is a locale
	// and the value is the localized message for that locale. The only key supported
	// is en_US. The HTML tags supported include the following: a, b, blockquote,
	// br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike,
	// strong, sub, sup, u, ul.
	LoginMessage map[string]*string `type:"map"`

	// The logo. The only image format accepted is a binary data object that is
	// converted from a .png file.
	LogoUrl *string `min:"1" type:"string"`

	// The support email. The company's customer support email address.
	//
	//    * In each platform type, the SupportEmail and SupportLink parameters are
	//    mutually exclusive. You can specify one parameter for each platform type,
	//    but not both.
	//
	//    * The default email is workspaces-feedback@amazon.com.
	SupportEmail *string `min:"6" type:"string"`

	// The support link. The link for the company's customer support page for their
	// WorkSpace.
	//
	//    * In each platform type, the SupportEmail and SupportLink parameters are
	//    mutually exclusive.You can specify one parameter for each platform type,
	//    but not both.
	//
	//    * The default support link is workspaces-feedback@amazon.com.
	SupportLink *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultClientBrandingAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultClientBrandingAttributes) GoString() string {
	return s.String()
}

// SetForgotPasswordLink sets the ForgotPasswordLink field's value.
func (s *DefaultClientBrandingAttributes) SetForgotPasswordLink(v string) *DefaultClientBrandingAttributes {
	s.ForgotPasswordLink = &v
	return s
}

// SetLoginMessage sets the LoginMessage field's value.
func (s *DefaultClientBrandingAttributes) SetLoginMessage(v map[string]*string) *DefaultClientBrandingAttributes {
	s.LoginMessage = v
	return s
}

// SetLogoUrl sets the LogoUrl field's value.
func (s *DefaultClientBrandingAttributes) SetLogoUrl(v string) *DefaultClientBrandingAttributes {
	s.LogoUrl = &v
	return s
}

// SetSupportEmail sets the SupportEmail field's value.
func (s *DefaultClientBrandingAttributes) SetSupportEmail(v string) *DefaultClientBrandingAttributes {
	s.SupportEmail = &v
	return s
}

// SetSupportLink sets the SupportLink field's value.
func (s *DefaultClientBrandingAttributes) SetSupportLink(v string) *DefaultClientBrandingAttributes {
	s.SupportLink = &v
	return s
}

// The default client branding attributes to be imported. These attributes display
// on the client login screen.
//
// Client branding attributes are public facing. Ensure that you do not include
// sensitive information.
type DefaultImportClientBrandingAttributes struct {
	_ struct{} `type:"structure"`

	// The forgotten password link. This is the web address that users can go to
	// if they forget the password for their WorkSpace.
	ForgotPasswordLink *string `min:"1" type:"string"`

	// The login message. Specified as a key value pair, in which the key is a locale
	// and the value is the localized message for that locale. The only key supported
	// is en_US. The HTML tags supported include the following: a, b, blockquote,
	// br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike,
	// strong, sub, sup, u, ul.
	LoginMessage map[string]*string `type:"map"`

	// The logo. The only image format accepted is a binary data object that is
	// converted from a .png file.
	// Logo is automatically base64 encoded/decoded by the SDK.
	Logo []byte `min:"1" type:"blob"`

	// The support email. The company's customer support email address.
	//
	//    * In each platform type, the SupportEmail and SupportLink parameters are
	//    mutually exclusive. You can specify one parameter for each platform type,
	//    but not both.
	//
	//    * The default email is workspaces-feedback@amazon.com.
	SupportEmail *string `min:"6" type:"string"`

	// The support link. The link for the company's customer support page for their
	// WorkSpace.
	//
	//    * In each platform type, the SupportEmail and SupportLink parameters are
	//    mutually exclusive. You can specify one parameter for each platform type,
	//    but not both.
	//
	//    * The default support link is workspaces-feedback@amazon.com.
	SupportLink *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultImportClientBrandingAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultImportClientBrandingAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefaultImportClientBrandingAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DefaultImportClientBrandingAttributes"}
	if s.ForgotPasswordLink != nil && len(*s.ForgotPasswordLink) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ForgotPasswordLink", 1))
	}
	if s.Logo != nil && len(s.Logo) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Logo", 1))
	}
	if s.SupportEmail != nil && len(*s.SupportEmail) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SupportEmail", 6))
	}
	if s.SupportLink != nil && len(*s.SupportLink) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SupportLink", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForgotPasswordLink sets the ForgotPasswordLink field's value.
func (s *DefaultImportClientBrandingAttributes) SetForgotPasswordLink(v string) *DefaultImportClientBrandingAttributes {
	s.ForgotPasswordLink = &v
	return s
}

// SetLoginMessage sets the LoginMessage field's value.
func (s *DefaultImportClientBrandingAttributes) SetLoginMessage(v map[string]*string) *DefaultImportClientBrandingAttributes {
	s.LoginMessage = v
	return s
}

// SetLogo sets the Logo field's value.
func (s *DefaultImportClientBrandingAttributes) SetLogo(v []byte) *DefaultImportClientBrandingAttributes {
	s.Logo = v
	return s
}

// SetSupportEmail sets the SupportEmail field's value.
func (s *DefaultImportClientBrandingAttributes) SetSupportEmail(v string) *DefaultImportClientBrandingAttributes {
	s.SupportEmail = &v
	return s
}

// SetSupportLink sets the SupportLink field's value.
func (s *DefaultImportClientBrandingAttributes) SetSupportLink(v string) *DefaultImportClientBrandingAttributes {
	s.SupportLink = &v
	return s
}

// Describes the default values that are used to create WorkSpaces. For more
// information, see Update Directory Details for Your WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html).
type DefaultWorkspaceCreationProperties struct {
	_ struct{} `type:"structure"`

	// The identifier of the default security group to apply to WorkSpaces when
	// they are created. For more information, see Security Groups for Your WorkSpaces
	// (https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html).
	CustomSecurityGroupId *string `min:"11" type:"string"`

	// The organizational unit (OU) in the directory for the WorkSpace machine accounts.
	DefaultOu *string `type:"string"`

	// Specifies whether to automatically assign an Elastic public IP address to
	// WorkSpaces in this directory by default. If enabled, the Elastic public IP
	// address allows outbound internet access from your WorkSpaces when you’re
	// using an internet gateway in the Amazon VPC in which your WorkSpaces are
	// located. If you're using a Network Address Translation (NAT) gateway for
	// outbound internet access from your VPC, or if your WorkSpaces are in public
	// subnets and you manually assign them Elastic IP addresses, you should disable
	// this setting. This setting applies to new WorkSpaces that you launch or to
	// existing WorkSpaces that you rebuild. For more information, see Configure
	// a VPC for Amazon WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html).
	EnableInternetAccess *bool `type:"boolean"`

	// Specifies whether maintenance mode is enabled for WorkSpaces. For more information,
	// see WorkSpace Maintenance (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html).
	EnableMaintenanceMode *bool `type:"boolean"`

	// Specifies whether the directory is enabled for Amazon WorkDocs.
	EnableWorkDocs *bool `type:"boolean"`

	// Indicates the IAM role ARN of the instance.
	InstanceIamRoleArn *string `type:"string"`

	// Specifies whether WorkSpace users are local administrators on their WorkSpaces.
	UserEnabledAsLocalAdministrator *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultWorkspaceCreationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultWorkspaceCreationProperties) GoString() string {
	return s.String()
}

// SetCustomSecurityGroupId sets the CustomSecurityGroupId field's value.
func (s *DefaultWorkspaceCreationProperties) SetCustomSecurityGroupId(v string) *DefaultWorkspaceCreationProperties {
	s.CustomSecurityGroupId = &v
	return s
}

// SetDefaultOu sets the DefaultOu field's value.
func (s *DefaultWorkspaceCreationProperties) SetDefaultOu(v string) *DefaultWorkspaceCreationProperties {
	s.DefaultOu = &v
	return s
}

// SetEnableInternetAccess sets the EnableInternetAccess field's value.
func (s *DefaultWorkspaceCreationProperties) SetEnableInternetAccess(v bool) *DefaultWorkspaceCreationProperties {
	s.EnableInternetAccess = &v
	return s
}

// SetEnableMaintenanceMode sets the EnableMaintenanceMode field's value.
func (s *DefaultWorkspaceCreationProperties) SetEnableMaintenanceMode(v bool) *DefaultWorkspaceCreationProperties {
	s.EnableMaintenanceMode = &v
	return s
}

// SetEnableWorkDocs sets the EnableWorkDocs field's value.
func (s *DefaultWorkspaceCreationProperties) SetEnableWorkDocs(v bool) *DefaultWorkspaceCreationProperties {
	s.EnableWorkDocs = &v
	return s
}

// SetInstanceIamRoleArn sets the InstanceIamRoleArn field's value.
func (s *DefaultWorkspaceCreationProperties) SetInstanceIamRoleArn(v string) *DefaultWorkspaceCreationProperties {
	s.InstanceIamRoleArn = &v
	return s
}

// SetUserEnabledAsLocalAdministrator sets the UserEnabledAsLocalAdministrator field's value.
func (s *DefaultWorkspaceCreationProperties) SetUserEnabledAsLocalAdministrator(v bool) *DefaultWorkspaceCreationProperties {
	s.UserEnabledAsLocalAdministrator = &v
	return s
}

type DeleteAccountLinkInvitationInput struct {
	_ struct{} `type:"structure"`

	// A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent
	// creation.
	ClientToken *string `type:"string"`

	// The identifier of the account link.
	//
	// LinkId is a required field
	LinkId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountLinkInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountLinkInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccountLinkInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccountLinkInvitationInput"}
	if s.LinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("LinkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAccountLinkInvitationInput) SetClientToken(v string) *DeleteAccountLinkInvitationInput {
	s.ClientToken = &v
	return s
}

// SetLinkId sets the LinkId field's value.
func (s *DeleteAccountLinkInvitationInput) SetLinkId(v string) *DeleteAccountLinkInvitationInput {
	s.LinkId = &v
	return s
}

type DeleteAccountLinkInvitationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the account link.
	AccountLink *AccountLink `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountLinkInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountLinkInvitationOutput) GoString() string {
	return s.String()
}

// SetAccountLink sets the AccountLink field's value.
func (s *DeleteAccountLinkInvitationOutput) SetAccountLink(v *AccountLink) *DeleteAccountLinkInvitationOutput {
	s.AccountLink = v
	return s
}

type DeleteClientBrandingInput struct {
	_ struct{} `type:"structure"`

	// The device type for which you want to delete client branding.
	//
	// Platforms is a required field
	Platforms []*string `min:"1" type:"list" required:"true" enum:"ClientDeviceType"`

	// The directory identifier of the WorkSpace for which you want to delete client
	// branding.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClientBrandingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClientBrandingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClientBrandingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClientBrandingInput"}
	if s.Platforms == nil {
		invalidParams.Add(request.NewErrParamRequired("Platforms"))
	}
	if s.Platforms != nil && len(s.Platforms) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Platforms", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlatforms sets the Platforms field's value.
func (s *DeleteClientBrandingInput) SetPlatforms(v []*string) *DeleteClientBrandingInput {
	s.Platforms = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteClientBrandingInput) SetResourceId(v string) *DeleteClientBrandingInput {
	s.ResourceId = &v
	return s
}

type DeleteClientBrandingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClientBrandingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClientBrandingOutput) GoString() string {
	return s.String()
}

type DeleteConnectClientAddInInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the client add-in to delete.
	//
	// AddInId is a required field
	AddInId *string `min:"36" type:"string" required:"true"`

	// The directory identifier for which the client add-in is configured.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectClientAddInInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectClientAddInInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectClientAddInInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectClientAddInInput"}
	if s.AddInId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddInId"))
	}
	if s.AddInId != nil && len(*s.AddInId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AddInId", 36))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddInId sets the AddInId field's value.
func (s *DeleteConnectClientAddInInput) SetAddInId(v string) *DeleteConnectClientAddInInput {
	s.AddInId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteConnectClientAddInInput) SetResourceId(v string) *DeleteConnectClientAddInInput {
	s.ResourceId = &v
	return s
}

type DeleteConnectClientAddInOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectClientAddInOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectClientAddInOutput) GoString() string {
	return s.String()
}

type DeleteConnectionAliasInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias to delete.
	//
	// AliasId is a required field
	AliasId *string `min:"13" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectionAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}
	if s.AliasId != nil && len(*s.AliasId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("AliasId", 13))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DeleteConnectionAliasInput) SetAliasId(v string) *DeleteConnectionAliasInput {
	s.AliasId = &v
	return s
}

type DeleteConnectionAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionAliasOutput) GoString() string {
	return s.String()
}

type DeleteIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the IP access control group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIpGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DeleteIpGroupInput) SetGroupId(v string) *DeleteIpGroupInput {
	s.GroupId = &v
	return s
}

type DeleteIpGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIpGroupOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpaces resource. The supported resource types are
	// WorkSpaces, registered directories, images, custom bundles, IP access control
	// groups, and connection aliases.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteTagsInput) SetResourceId(v string) *DeleteTagsInput {
	s.ResourceId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DeleteWorkspaceBundleInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle.
	BundleId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceBundleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceBundleInput) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *DeleteWorkspaceBundleInput) SetBundleId(v string) *DeleteWorkspaceBundleInput {
	s.BundleId = &v
	return s
}

type DeleteWorkspaceBundleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceBundleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceBundleOutput) GoString() string {
	return s.String()
}

type DeleteWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkspaceImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkspaceImageInput"}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageId sets the ImageId field's value.
func (s *DeleteWorkspaceImageInput) SetImageId(v string) *DeleteWorkspaceImageInput {
	s.ImageId = &v
	return s
}

type DeleteWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceImageOutput) GoString() string {
	return s.String()
}

type DeployWorkspaceApplicationsInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the force flag is applied for the specified WorkSpace.
	// When the force flag is enabled, it allows previously failed deployments to
	// be retried.
	Force *bool `type:"boolean"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeployWorkspaceApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeployWorkspaceApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeployWorkspaceApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeployWorkspaceApplicationsInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *DeployWorkspaceApplicationsInput) SetForce(v bool) *DeployWorkspaceApplicationsInput {
	s.Force = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeployWorkspaceApplicationsInput) SetWorkspaceId(v string) *DeployWorkspaceApplicationsInput {
	s.WorkspaceId = &v
	return s
}

type DeployWorkspaceApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of deployed associations and information about them.
	Deployment *WorkSpaceApplicationDeployment `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeployWorkspaceApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeployWorkspaceApplicationsOutput) GoString() string {
	return s.String()
}

// SetDeployment sets the Deployment field's value.
func (s *DeployWorkspaceApplicationsOutput) SetDeployment(v *WorkSpaceApplicationDeployment) *DeployWorkspaceApplicationsOutput {
	s.Deployment = v
	return s
}

type DeregisterWorkspaceDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory. If any WorkSpaces are registered to this
	// directory, you must remove them before you deregister the directory, or you
	// will receive an OperationNotSupportedException error.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterWorkspaceDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterWorkspaceDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterWorkspaceDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterWorkspaceDirectoryInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DeregisterWorkspaceDirectoryInput) SetDirectoryId(v string) *DeregisterWorkspaceDirectoryInput {
	s.DirectoryId = &v
	return s
}

type DeregisterWorkspaceDirectoryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterWorkspaceDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterWorkspaceDirectoryOutput) GoString() string {
	return s.String()
}

type DescribeAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountInput) GoString() string {
	return s.String()
}

type DescribeAccountModificationsInput struct {
	_ struct{} `type:"structure"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountModificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountModificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountModificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountModificationsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountModificationsInput) SetNextToken(v string) *DescribeAccountModificationsInput {
	s.NextToken = &v
	return s
}

type DescribeAccountModificationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of modifications to the configuration of BYOL.
	AccountModifications []*AccountModification `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountModificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountModificationsOutput) GoString() string {
	return s.String()
}

// SetAccountModifications sets the AccountModifications field's value.
func (s *DescribeAccountModificationsOutput) SetAccountModifications(v []*AccountModification) *DescribeAccountModificationsOutput {
	s.AccountModifications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountModificationsOutput) SetNextToken(v string) *DescribeAccountModificationsOutput {
	s.NextToken = &v
	return s
}

type DescribeAccountOutput struct {
	_ struct{} `type:"structure"`

	// The type of linked account.
	DedicatedTenancyAccountType *string `type:"string" enum:"DedicatedTenancyAccountType"`

	// The IP address range, specified as an IPv4 CIDR block, used for the management
	// network interface.
	//
	// The management network interface is connected to a secure Amazon WorkSpaces
	// management network. It is used for interactive streaming of the WorkSpace
	// desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage
	// the WorkSpace.
	DedicatedTenancyManagementCidrRange *string `type:"string"`

	// The status of BYOL (whether BYOL is enabled or disabled).
	DedicatedTenancySupport *string `type:"string" enum:"DedicatedTenancySupportResultEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountOutput) GoString() string {
	return s.String()
}

// SetDedicatedTenancyAccountType sets the DedicatedTenancyAccountType field's value.
func (s *DescribeAccountOutput) SetDedicatedTenancyAccountType(v string) *DescribeAccountOutput {
	s.DedicatedTenancyAccountType = &v
	return s
}

// SetDedicatedTenancyManagementCidrRange sets the DedicatedTenancyManagementCidrRange field's value.
func (s *DescribeAccountOutput) SetDedicatedTenancyManagementCidrRange(v string) *DescribeAccountOutput {
	s.DedicatedTenancyManagementCidrRange = &v
	return s
}

// SetDedicatedTenancySupport sets the DedicatedTenancySupport field's value.
func (s *DescribeAccountOutput) SetDedicatedTenancySupport(v string) *DescribeAccountOutput {
	s.DedicatedTenancySupport = &v
	return s
}

type DescribeApplicationAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the specified application.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The resource type of the associated resources.
	//
	// AssociatedResourceTypes is a required field
	AssociatedResourceTypes []*string `type:"list" required:"true" enum:"ApplicationAssociatedResourceType"`

	// The maximum number of associations to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationAssociationsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.AssociatedResourceTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociatedResourceTypes"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DescribeApplicationAssociationsInput) SetApplicationId(v string) *DescribeApplicationAssociationsInput {
	s.ApplicationId = &v
	return s
}

// SetAssociatedResourceTypes sets the AssociatedResourceTypes field's value.
func (s *DescribeApplicationAssociationsInput) SetAssociatedResourceTypes(v []*string) *DescribeApplicationAssociationsInput {
	s.AssociatedResourceTypes = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeApplicationAssociationsInput) SetMaxResults(v int64) *DescribeApplicationAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeApplicationAssociationsInput) SetNextToken(v string) *DescribeApplicationAssociationsInput {
	s.NextToken = &v
	return s
}

type DescribeApplicationAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// List of associations and information about them.
	Associations []*ApplicationResourceAssociation `type:"list"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationAssociationsOutput) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *DescribeApplicationAssociationsOutput) SetAssociations(v []*ApplicationResourceAssociation) *DescribeApplicationAssociationsOutput {
	s.Associations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeApplicationAssociationsOutput) SetNextToken(v string) *DescribeApplicationAssociationsOutput {
	s.NextToken = &v
	return s
}

type DescribeApplicationsInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of one or more applications.
	ApplicationIds []*string `min:"1" type:"list"`

	// The compute types supported by the applications.
	ComputeTypeNames []*string `type:"list" enum:"Compute"`

	// The license availability for the applications.
	LicenseType *string `type:"string" enum:"WorkSpaceApplicationLicenseType"`

	// The maximum number of applications to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The operating systems supported by the applications.
	OperatingSystemNames []*string `type:"list" enum:"OperatingSystemName"`

	// The owner of the applications.
	Owner *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationsInput"}
	if s.ApplicationIds != nil && len(s.ApplicationIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationIds", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationIds sets the ApplicationIds field's value.
func (s *DescribeApplicationsInput) SetApplicationIds(v []*string) *DescribeApplicationsInput {
	s.ApplicationIds = v
	return s
}

// SetComputeTypeNames sets the ComputeTypeNames field's value.
func (s *DescribeApplicationsInput) SetComputeTypeNames(v []*string) *DescribeApplicationsInput {
	s.ComputeTypeNames = v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *DescribeApplicationsInput) SetLicenseType(v string) *DescribeApplicationsInput {
	s.LicenseType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeApplicationsInput) SetMaxResults(v int64) *DescribeApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeApplicationsInput) SetNextToken(v string) *DescribeApplicationsInput {
	s.NextToken = &v
	return s
}

// SetOperatingSystemNames sets the OperatingSystemNames field's value.
func (s *DescribeApplicationsInput) SetOperatingSystemNames(v []*string) *DescribeApplicationsInput {
	s.OperatingSystemNames = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DescribeApplicationsInput) SetOwner(v string) *DescribeApplicationsInput {
	s.Owner = &v
	return s
}

type DescribeApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// List of information about the specified applications.
	Applications []*WorkSpaceApplication `type:"list"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *DescribeApplicationsOutput) SetApplications(v []*WorkSpaceApplication) *DescribeApplicationsOutput {
	s.Applications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeApplicationsOutput) SetNextToken(v string) *DescribeApplicationsOutput {
	s.NextToken = &v
	return s
}

type DescribeBundleAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The resource types of the associated resource.
	//
	// AssociatedResourceTypes is a required field
	AssociatedResourceTypes []*string `type:"list" required:"true" enum:"BundleAssociatedResourceType"`

	// The identifier of the bundle.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBundleAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBundleAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBundleAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBundleAssociationsInput"}
	if s.AssociatedResourceTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociatedResourceTypes"))
	}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociatedResourceTypes sets the AssociatedResourceTypes field's value.
func (s *DescribeBundleAssociationsInput) SetAssociatedResourceTypes(v []*string) *DescribeBundleAssociationsInput {
	s.AssociatedResourceTypes = v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *DescribeBundleAssociationsInput) SetBundleId(v string) *DescribeBundleAssociationsInput {
	s.BundleId = &v
	return s
}

type DescribeBundleAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// List of information about the specified associations.
	Associations []*BundleResourceAssociation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBundleAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBundleAssociationsOutput) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *DescribeBundleAssociationsOutput) SetAssociations(v []*BundleResourceAssociation) *DescribeBundleAssociationsOutput {
	s.Associations = v
	return s
}

type DescribeClientBrandingInput struct {
	_ struct{} `type:"structure"`

	// The directory identifier of the WorkSpace for which you want to view client
	// branding information.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClientBrandingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClientBrandingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClientBrandingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClientBrandingInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeClientBrandingInput) SetResourceId(v string) *DescribeClientBrandingInput {
	s.ResourceId = &v
	return s
}

type DescribeClientBrandingOutput struct {
	_ struct{} `type:"structure"`

	// The branding information for Android devices.
	DeviceTypeAndroid *DefaultClientBrandingAttributes `type:"structure"`

	// The branding information for iOS devices.
	DeviceTypeIos *IosClientBrandingAttributes `type:"structure"`

	// The branding information for Linux devices.
	DeviceTypeLinux *DefaultClientBrandingAttributes `type:"structure"`

	// The branding information for macOS devices.
	DeviceTypeOsx *DefaultClientBrandingAttributes `type:"structure"`

	// The branding information for Web access.
	DeviceTypeWeb *DefaultClientBrandingAttributes `type:"structure"`

	// The branding information for Windows devices.
	DeviceTypeWindows *DefaultClientBrandingAttributes `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClientBrandingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClientBrandingOutput) GoString() string {
	return s.String()
}

// SetDeviceTypeAndroid sets the DeviceTypeAndroid field's value.
func (s *DescribeClientBrandingOutput) SetDeviceTypeAndroid(v *DefaultClientBrandingAttributes) *DescribeClientBrandingOutput {
	s.DeviceTypeAndroid = v
	return s
}

// SetDeviceTypeIos sets the DeviceTypeIos field's value.
func (s *DescribeClientBrandingOutput) SetDeviceTypeIos(v *IosClientBrandingAttributes) *DescribeClientBrandingOutput {
	s.DeviceTypeIos = v
	return s
}

// SetDeviceTypeLinux sets the DeviceTypeLinux field's value.
func (s *DescribeClientBrandingOutput) SetDeviceTypeLinux(v *DefaultClientBrandingAttributes) *DescribeClientBrandingOutput {
	s.DeviceTypeLinux = v
	return s
}

// SetDeviceTypeOsx sets the DeviceTypeOsx field's value.
func (s *DescribeClientBrandingOutput) SetDeviceTypeOsx(v *DefaultClientBrandingAttributes) *DescribeClientBrandingOutput {
	s.DeviceTypeOsx = v
	return s
}

// SetDeviceTypeWeb sets the DeviceTypeWeb field's value.
func (s *DescribeClientBrandingOutput) SetDeviceTypeWeb(v *DefaultClientBrandingAttributes) *DescribeClientBrandingOutput {
	s.DeviceTypeWeb = v
	return s
}

// SetDeviceTypeWindows sets the DeviceTypeWindows field's value.
func (s *DescribeClientBrandingOutput) SetDeviceTypeWindows(v *DefaultClientBrandingAttributes) *DescribeClientBrandingOutput {
	s.DeviceTypeWindows = v
	return s
}

type DescribeClientPropertiesInput struct {
	_ struct{} `type:"structure"`

	// The resource identifier, in the form of directory IDs.
	//
	// ResourceIds is a required field
	ResourceIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClientPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClientPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClientPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClientPropertiesInput"}
	if s.ResourceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIds"))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIds sets the ResourceIds field's value.
func (s *DescribeClientPropertiesInput) SetResourceIds(v []*string) *DescribeClientPropertiesInput {
	s.ResourceIds = v
	return s
}

type DescribeClientPropertiesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified Amazon WorkSpaces clients.
	ClientPropertiesList []*ClientPropertiesResult `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClientPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClientPropertiesOutput) GoString() string {
	return s.String()
}

// SetClientPropertiesList sets the ClientPropertiesList field's value.
func (s *DescribeClientPropertiesOutput) SetClientPropertiesList(v []*ClientPropertiesResult) *DescribeClientPropertiesOutput {
	s.ClientPropertiesList = v
	return s
}

type DescribeConnectClientAddInsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The directory identifier for which the client add-in is configured.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectClientAddInsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectClientAddInsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectClientAddInsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectClientAddInsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeConnectClientAddInsInput) SetMaxResults(v int64) *DescribeConnectClientAddInsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectClientAddInsInput) SetNextToken(v string) *DescribeConnectClientAddInsInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeConnectClientAddInsInput) SetResourceId(v string) *DescribeConnectClientAddInsInput {
	s.ResourceId = &v
	return s
}

type DescribeConnectClientAddInsOutput struct {
	_ struct{} `type:"structure"`

	// Information about client add-ins.
	AddIns []*ConnectClientAddIn `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectClientAddInsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectClientAddInsOutput) GoString() string {
	return s.String()
}

// SetAddIns sets the AddIns field's value.
func (s *DescribeConnectClientAddInsOutput) SetAddIns(v []*ConnectClientAddIn) *DescribeConnectClientAddInsOutput {
	s.AddIns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectClientAddInsOutput) SetNextToken(v string) *DescribeConnectClientAddInsOutput {
	s.NextToken = &v
	return s
}

type DescribeConnectionAliasPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias.
	//
	// AliasId is a required field
	AliasId *string `min:"13" type:"string" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionAliasPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionAliasPermissionsInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}
	if s.AliasId != nil && len(*s.AliasId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("AliasId", 13))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeConnectionAliasPermissionsInput) SetAliasId(v string) *DescribeConnectionAliasPermissionsInput {
	s.AliasId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeConnectionAliasPermissionsInput) SetMaxResults(v int64) *DescribeConnectionAliasPermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectionAliasPermissionsInput) SetNextToken(v string) *DescribeConnectionAliasPermissionsInput {
	s.NextToken = &v
	return s
}

type DescribeConnectionAliasPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias.
	AliasId *string `min:"13" type:"string"`

	// The permissions associated with a connection alias.
	ConnectionAliasPermissions []*ConnectionAliasPermission `min:"1" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasPermissionsOutput) GoString() string {
	return s.String()
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeConnectionAliasPermissionsOutput) SetAliasId(v string) *DescribeConnectionAliasPermissionsOutput {
	s.AliasId = &v
	return s
}

// SetConnectionAliasPermissions sets the ConnectionAliasPermissions field's value.
func (s *DescribeConnectionAliasPermissionsOutput) SetConnectionAliasPermissions(v []*ConnectionAliasPermission) *DescribeConnectionAliasPermissionsOutput {
	s.ConnectionAliasPermissions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectionAliasPermissionsOutput) SetNextToken(v string) *DescribeConnectionAliasPermissionsOutput {
	s.NextToken = &v
	return s
}

type DescribeConnectionAliasesInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the connection aliases to describe.
	AliasIds []*string `min:"1" type:"list"`

	// The maximum number of connection aliases to return.
	Limit *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The identifier of the directory associated with the connection alias.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionAliasesInput"}
	if s.AliasIds != nil && len(s.AliasIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasIds sets the AliasIds field's value.
func (s *DescribeConnectionAliasesInput) SetAliasIds(v []*string) *DescribeConnectionAliasesInput {
	s.AliasIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConnectionAliasesInput) SetLimit(v int64) *DescribeConnectionAliasesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectionAliasesInput) SetNextToken(v string) *DescribeConnectionAliasesInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeConnectionAliasesInput) SetResourceId(v string) *DescribeConnectionAliasesInput {
	s.ResourceId = &v
	return s
}

type DescribeConnectionAliasesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified connection aliases.
	ConnectionAliases []*ConnectionAlias `min:"1" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasesOutput) GoString() string {
	return s.String()
}

// SetConnectionAliases sets the ConnectionAliases field's value.
func (s *DescribeConnectionAliasesOutput) SetConnectionAliases(v []*ConnectionAlias) *DescribeConnectionAliasesOutput {
	s.ConnectionAliases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectionAliasesOutput) SetNextToken(v string) *DescribeConnectionAliasesOutput {
	s.NextToken = &v
	return s
}

type DescribeImageAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The resource types of the associated resource.
	//
	// AssociatedResourceTypes is a required field
	AssociatedResourceTypes []*string `type:"list" required:"true" enum:"ImageAssociatedResourceType"`

	// The identifier of the image.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImageAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImageAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImageAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeImageAssociationsInput"}
	if s.AssociatedResourceTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociatedResourceTypes"))
	}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociatedResourceTypes sets the AssociatedResourceTypes field's value.
func (s *DescribeImageAssociationsInput) SetAssociatedResourceTypes(v []*string) *DescribeImageAssociationsInput {
	s.AssociatedResourceTypes = v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *DescribeImageAssociationsInput) SetImageId(v string) *DescribeImageAssociationsInput {
	s.ImageId = &v
	return s
}

type DescribeImageAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// List of information about the specified associations.
	Associations []*ImageResourceAssociation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImageAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImageAssociationsOutput) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *DescribeImageAssociationsOutput) SetAssociations(v []*ImageResourceAssociation) *DescribeImageAssociationsOutput {
	s.Associations = v
	return s
}

type DescribeIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of one or more IP access control groups.
	GroupIds []*string `type:"list"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIpGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIpGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIpGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupIds sets the GroupIds field's value.
func (s *DescribeIpGroupsInput) SetGroupIds(v []*string) *DescribeIpGroupsInput {
	s.GroupIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeIpGroupsInput) SetMaxResults(v int64) *DescribeIpGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeIpGroupsInput) SetNextToken(v string) *DescribeIpGroupsInput {
	s.NextToken = &v
	return s
}

type DescribeIpGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// Information about the IP access control groups.
	Result []*IpGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIpGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeIpGroupsOutput) SetNextToken(v string) *DescribeIpGroupsOutput {
	s.NextToken = &v
	return s
}

// SetResult sets the Result field's value.
func (s *DescribeIpGroupsOutput) SetResult(v []*IpGroup) *DescribeIpGroupsOutput {
	s.Result = v
	return s
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpaces resource. The supported resource types are
	// WorkSpaces, registered directories, images, custom bundles, IP access control
	// groups, and connection aliases.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeTagsInput) SetResourceId(v string) *DescribeTagsInput {
	s.ResourceId = &v
	return s
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// The tags.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *DescribeTagsOutput) SetTagList(v []*Tag) *DescribeTagsOutput {
	s.TagList = v
	return s
}

type DescribeWorkspaceAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The resource types of the associated resources.
	//
	// AssociatedResourceTypes is a required field
	AssociatedResourceTypes []*string `type:"list" required:"true" enum:"WorkSpaceAssociatedResourceType"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceAssociationsInput"}
	if s.AssociatedResourceTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociatedResourceTypes"))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociatedResourceTypes sets the AssociatedResourceTypes field's value.
func (s *DescribeWorkspaceAssociationsInput) SetAssociatedResourceTypes(v []*string) *DescribeWorkspaceAssociationsInput {
	s.AssociatedResourceTypes = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DescribeWorkspaceAssociationsInput) SetWorkspaceId(v string) *DescribeWorkspaceAssociationsInput {
	s.WorkspaceId = &v
	return s
}

type DescribeWorkspaceAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// List of information about the specified associations.
	Associations []*WorkspaceResourceAssociation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceAssociationsOutput) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *DescribeWorkspaceAssociationsOutput) SetAssociations(v []*WorkspaceResourceAssociation) *DescribeWorkspaceAssociationsOutput {
	s.Associations = v
	return s
}

type DescribeWorkspaceBundlesInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the bundles. You cannot combine this parameter with any
	// other filter.
	BundleIds []*string `min:"1" type:"list"`

	// The token for the next set of results. (You received this token from a previous
	// call.)
	NextToken *string `min:"1" type:"string"`

	// The owner of the bundles. You cannot combine this parameter with any other
	// filter.
	//
	// To describe the bundles provided by Amazon Web Services, specify AMAZON.
	// To describe the bundles that belong to your account, don't specify a value.
	Owner *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceBundlesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceBundlesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceBundlesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceBundlesInput"}
	if s.BundleIds != nil && len(s.BundleIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BundleIds", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleIds sets the BundleIds field's value.
func (s *DescribeWorkspaceBundlesInput) SetBundleIds(v []*string) *DescribeWorkspaceBundlesInput {
	s.BundleIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceBundlesInput) SetNextToken(v string) *DescribeWorkspaceBundlesInput {
	s.NextToken = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DescribeWorkspaceBundlesInput) SetOwner(v string) *DescribeWorkspaceBundlesInput {
	s.Owner = &v
	return s
}

type DescribeWorkspaceBundlesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the bundles.
	Bundles []*WorkspaceBundle `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return. This token is valid for one day
	// and must be used within that time frame.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceBundlesOutput) GoString() string {
	return s.String()
}

// SetBundles sets the Bundles field's value.
func (s *DescribeWorkspaceBundlesOutput) SetBundles(v []*WorkspaceBundle) *DescribeWorkspaceBundlesOutput {
	s.Bundles = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceBundlesOutput) SetNextToken(v string) *DescribeWorkspaceBundlesOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceDirectoriesInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the directories. If the value is null, all directories
	// are retrieved.
	DirectoryIds []*string `min:"1" type:"list"`

	// The maximum number of directories to return.
	Limit *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The names of the WorkSpace directories.
	WorkspaceDirectoryNames []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceDirectoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceDirectoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceDirectoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceDirectoriesInput"}
	if s.DirectoryIds != nil && len(s.DirectoryIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkspaceDirectoryNames != nil && len(s.WorkspaceDirectoryNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceDirectoryNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryIds sets the DirectoryIds field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetDirectoryIds(v []*string) *DescribeWorkspaceDirectoriesInput {
	s.DirectoryIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetLimit(v int64) *DescribeWorkspaceDirectoriesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetNextToken(v string) *DescribeWorkspaceDirectoriesInput {
	s.NextToken = &v
	return s
}

// SetWorkspaceDirectoryNames sets the WorkspaceDirectoryNames field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetWorkspaceDirectoryNames(v []*string) *DescribeWorkspaceDirectoriesInput {
	s.WorkspaceDirectoryNames = v
	return s
}

type DescribeWorkspaceDirectoriesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the directories.
	Directories []*WorkspaceDirectory `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceDirectoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceDirectoriesOutput) GoString() string {
	return s.String()
}

// SetDirectories sets the Directories field's value.
func (s *DescribeWorkspaceDirectoriesOutput) SetDirectories(v []*WorkspaceDirectory) *DescribeWorkspaceDirectoriesOutput {
	s.Directories = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceDirectoriesOutput) SetNextToken(v string) *DescribeWorkspaceDirectoriesOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceImagePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceImagePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceImagePermissionsInput"}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageId sets the ImageId field's value.
func (s *DescribeWorkspaceImagePermissionsInput) SetImageId(v string) *DescribeWorkspaceImagePermissionsInput {
	s.ImageId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeWorkspaceImagePermissionsInput) SetMaxResults(v int64) *DescribeWorkspaceImagePermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceImagePermissionsInput) SetNextToken(v string) *DescribeWorkspaceImagePermissionsInput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceImagePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	ImageId *string `type:"string"`

	// The identifiers of the Amazon Web Services accounts that the image has been
	// shared with.
	ImagePermissions []*ImagePermission `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagePermissionsOutput) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *DescribeWorkspaceImagePermissionsOutput) SetImageId(v string) *DescribeWorkspaceImagePermissionsOutput {
	s.ImageId = &v
	return s
}

// SetImagePermissions sets the ImagePermissions field's value.
func (s *DescribeWorkspaceImagePermissionsOutput) SetImagePermissions(v []*ImagePermission) *DescribeWorkspaceImagePermissionsOutput {
	s.ImagePermissions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceImagePermissionsOutput) SetNextToken(v string) *DescribeWorkspaceImagePermissionsOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceImagesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	ImageIds []*string `min:"1" type:"list"`

	// The type (owned or shared) of the image.
	ImageType *string `type:"string" enum:"ImageType"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceImagesInput"}
	if s.ImageIds != nil && len(s.ImageIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageIds", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageIds sets the ImageIds field's value.
func (s *DescribeWorkspaceImagesInput) SetImageIds(v []*string) *DescribeWorkspaceImagesInput {
	s.ImageIds = v
	return s
}

// SetImageType sets the ImageType field's value.
func (s *DescribeWorkspaceImagesInput) SetImageType(v string) *DescribeWorkspaceImagesInput {
	s.ImageType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeWorkspaceImagesInput) SetMaxResults(v int64) *DescribeWorkspaceImagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceImagesInput) SetNextToken(v string) *DescribeWorkspaceImagesInput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceImagesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the images.
	Images []*WorkspaceImage `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagesOutput) GoString() string {
	return s.String()
}

// SetImages sets the Images field's value.
func (s *DescribeWorkspaceImagesOutput) SetImages(v []*WorkspaceImage) *DescribeWorkspaceImagesOutput {
	s.Images = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceImagesOutput) SetNextToken(v string) *DescribeWorkspaceImagesOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceSnapshotsInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DescribeWorkspaceSnapshotsInput) SetWorkspaceId(v string) *DescribeWorkspaceSnapshotsInput {
	s.WorkspaceId = &v
	return s
}

type DescribeWorkspaceSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the snapshots that can be used to rebuild a WorkSpace.
	// These snapshots include the user volume.
	RebuildSnapshots []*Snapshot `type:"list"`

	// Information about the snapshots that can be used to restore a WorkSpace.
	// These snapshots include both the root volume and the user volume.
	RestoreSnapshots []*Snapshot `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceSnapshotsOutput) GoString() string {
	return s.String()
}

// SetRebuildSnapshots sets the RebuildSnapshots field's value.
func (s *DescribeWorkspaceSnapshotsOutput) SetRebuildSnapshots(v []*Snapshot) *DescribeWorkspaceSnapshotsOutput {
	s.RebuildSnapshots = v
	return s
}

// SetRestoreSnapshots sets the RestoreSnapshots field's value.
func (s *DescribeWorkspaceSnapshotsOutput) SetRestoreSnapshots(v []*Snapshot) *DescribeWorkspaceSnapshotsOutput {
	s.RestoreSnapshots = v
	return s
}

type DescribeWorkspacesConnectionStatusInput struct {
	_ struct{} `type:"structure"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
	WorkspaceIds []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesConnectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesConnectionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesConnectionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesConnectionStatusInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkspaceIds != nil && len(s.WorkspaceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesConnectionStatusInput) SetNextToken(v string) *DescribeWorkspacesConnectionStatusInput {
	s.NextToken = &v
	return s
}

// SetWorkspaceIds sets the WorkspaceIds field's value.
func (s *DescribeWorkspacesConnectionStatusInput) SetWorkspaceIds(v []*string) *DescribeWorkspacesConnectionStatusInput {
	s.WorkspaceIds = v
	return s
}

type DescribeWorkspacesConnectionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// Information about the connection status of the WorkSpace.
	WorkspacesConnectionStatus []*WorkspaceConnectionStatus `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesConnectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesConnectionStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesConnectionStatusOutput) SetNextToken(v string) *DescribeWorkspacesConnectionStatusOutput {
	s.NextToken = &v
	return s
}

// SetWorkspacesConnectionStatus sets the WorkspacesConnectionStatus field's value.
func (s *DescribeWorkspacesConnectionStatusOutput) SetWorkspacesConnectionStatus(v []*WorkspaceConnectionStatus) *DescribeWorkspacesConnectionStatusOutput {
	s.WorkspacesConnectionStatus = v
	return s
}

type DescribeWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle. All WorkSpaces that are created from this bundle
	// are retrieved. You cannot combine this parameter with any other filter.
	BundleId *string `type:"string"`

	// The identifier of the directory. In addition, you can optionally specify
	// a specific directory user (see UserName). You cannot combine this parameter
	// with any other filter.
	DirectoryId *string `min:"10" type:"string"`

	// The maximum number of items to return.
	Limit *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The name of the directory user. You must specify this parameter with DirectoryId.
	UserName *string `min:"1" type:"string"`

	// The identifiers of the WorkSpaces. You cannot combine this parameter with
	// any other filter.
	//
	// Because the CreateWorkspaces operation is asynchronous, the identifier it
	// returns is not immediately available. If you immediately call DescribeWorkspaces
	// with this identifier, no information is returned.
	WorkspaceIds []*string `min:"1" type:"list"`

	// The name of the user-decoupled WorkSpace.
	WorkspaceName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesInput"}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.WorkspaceIds != nil && len(s.WorkspaceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *DescribeWorkspacesInput) SetBundleId(v string) *DescribeWorkspacesInput {
	s.BundleId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeWorkspacesInput) SetDirectoryId(v string) *DescribeWorkspacesInput {
	s.DirectoryId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeWorkspacesInput) SetLimit(v int64) *DescribeWorkspacesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesInput) SetNextToken(v string) *DescribeWorkspacesInput {
	s.NextToken = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeWorkspacesInput) SetUserName(v string) *DescribeWorkspacesInput {
	s.UserName = &v
	return s
}

// SetWorkspaceIds sets the WorkspaceIds field's value.
func (s *DescribeWorkspacesInput) SetWorkspaceIds(v []*string) *DescribeWorkspacesInput {
	s.WorkspaceIds = v
	return s
}

// SetWorkspaceName sets the WorkspaceName field's value.
func (s *DescribeWorkspacesInput) SetWorkspaceName(v string) *DescribeWorkspacesInput {
	s.WorkspaceName = &v
	return s
}

type DescribeWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// Information about the WorkSpaces.
	//
	// Because CreateWorkspaces is an asynchronous operation, some of the returned
	// information could be incomplete.
	Workspaces []*Workspace `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesOutput) SetNextToken(v string) *DescribeWorkspacesOutput {
	s.NextToken = &v
	return s
}

// SetWorkspaces sets the Workspaces field's value.
func (s *DescribeWorkspacesOutput) SetWorkspaces(v []*Workspace) *DescribeWorkspacesOutput {
	s.Workspaces = v
	return s
}

type DescribeWorkspacesPoolSessionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return.
	Limit *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The identifier of the pool.
	//
	// PoolId is a required field
	PoolId *string `type:"string" required:"true"`

	// The identifier of the user.
	UserId *string `min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesPoolSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesPoolSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesPoolSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesPoolSessionsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}
	if s.UserId != nil && len(*s.UserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *DescribeWorkspacesPoolSessionsInput) SetLimit(v int64) *DescribeWorkspacesPoolSessionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesPoolSessionsInput) SetNextToken(v string) *DescribeWorkspacesPoolSessionsInput {
	s.NextToken = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *DescribeWorkspacesPoolSessionsInput) SetPoolId(v string) *DescribeWorkspacesPoolSessionsInput {
	s.PoolId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeWorkspacesPoolSessionsInput) SetUserId(v string) *DescribeWorkspacesPoolSessionsInput {
	s.UserId = &v
	return s
}

type DescribeWorkspacesPoolSessionsOutput struct {
	_ struct{} `type:"structure"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// Describes the pool sessions.
	Sessions []*WorkspacesPoolSession `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesPoolSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesPoolSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesPoolSessionsOutput) SetNextToken(v string) *DescribeWorkspacesPoolSessionsOutput {
	s.NextToken = &v
	return s
}

// SetSessions sets the Sessions field's value.
func (s *DescribeWorkspacesPoolSessionsOutput) SetSessions(v []*WorkspacesPoolSession) *DescribeWorkspacesPoolSessionsOutput {
	s.Sessions = v
	return s
}

// Describes the filter conditions for WorkSpaces Pools to return.
type DescribeWorkspacesPoolsFilter struct {
	_ struct{} `type:"structure"`

	// The name of the pool to filter.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"DescribeWorkspacesPoolsFilterName"`

	// The operator values for filtering WorkSpaces Pools.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"DescribeWorkspacesPoolsFilterOperator"`

	// The values for filtering WorkSpaces Pools.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesPoolsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesPoolsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesPoolsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesPoolsFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeWorkspacesPoolsFilter) SetName(v string) *DescribeWorkspacesPoolsFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *DescribeWorkspacesPoolsFilter) SetOperator(v string) *DescribeWorkspacesPoolsFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DescribeWorkspacesPoolsFilter) SetValues(v []*string) *DescribeWorkspacesPoolsFilter {
	s.Values = v
	return s
}

type DescribeWorkspacesPoolsInput struct {
	_ struct{} `type:"structure"`

	// The filter conditions for the WorkSpaces Pool to return.
	Filters []*DescribeWorkspacesPoolsFilter `min:"1" type:"list"`

	// The maximum number of items to return.
	Limit *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The identifier of the WorkSpaces Pools.
	PoolIds []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesPoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesPoolsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesPoolsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesPoolsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PoolIds != nil && len(s.PoolIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolIds", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeWorkspacesPoolsInput) SetFilters(v []*DescribeWorkspacesPoolsFilter) *DescribeWorkspacesPoolsInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeWorkspacesPoolsInput) SetLimit(v int64) *DescribeWorkspacesPoolsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesPoolsInput) SetNextToken(v string) *DescribeWorkspacesPoolsInput {
	s.NextToken = &v
	return s
}

// SetPoolIds sets the PoolIds field's value.
func (s *DescribeWorkspacesPoolsInput) SetPoolIds(v []*string) *DescribeWorkspacesPoolsInput {
	s.PoolIds = v
	return s
}

type DescribeWorkspacesPoolsOutput struct {
	_ struct{} `type:"structure"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// Information about the WorkSpaces Pools.
	WorkspacesPools []*WorkspacesPool `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesPoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesPoolsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesPoolsOutput) SetNextToken(v string) *DescribeWorkspacesPoolsOutput {
	s.NextToken = &v
	return s
}

// SetWorkspacesPools sets the WorkspacesPools field's value.
func (s *DescribeWorkspacesPoolsOutput) SetWorkspacesPools(v []*WorkspacesPool) *DescribeWorkspacesPoolsOutput {
	s.WorkspacesPools = v
	return s
}

type DisassociateConnectionAliasInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias to disassociate.
	//
	// AliasId is a required field
	AliasId *string `min:"13" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateConnectionAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateConnectionAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateConnectionAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateConnectionAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}
	if s.AliasId != nil && len(*s.AliasId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("AliasId", 13))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DisassociateConnectionAliasInput) SetAliasId(v string) *DisassociateConnectionAliasInput {
	s.AliasId = &v
	return s
}

type DisassociateConnectionAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateConnectionAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateConnectionAliasOutput) GoString() string {
	return s.String()
}

type DisassociateIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`

	// The identifiers of one or more IP access control groups.
	//
	// GroupIds is a required field
	GroupIds []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIpGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateIpGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateIpGroupsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.GroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DisassociateIpGroupsInput) SetDirectoryId(v string) *DisassociateIpGroupsInput {
	s.DirectoryId = &v
	return s
}

// SetGroupIds sets the GroupIds field's value.
func (s *DisassociateIpGroupsInput) SetGroupIds(v []*string) *DisassociateIpGroupsInput {
	s.GroupIds = v
	return s
}

type DisassociateIpGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIpGroupsOutput) GoString() string {
	return s.String()
}

type DisassociateWorkspaceApplicationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the application.
	//
	// ApplicationId is a required field
	ApplicationId *string `type:"string" required:"true"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateWorkspaceApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateWorkspaceApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateWorkspaceApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateWorkspaceApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DisassociateWorkspaceApplicationInput) SetApplicationId(v string) *DisassociateWorkspaceApplicationInput {
	s.ApplicationId = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DisassociateWorkspaceApplicationInput) SetWorkspaceId(v string) *DisassociateWorkspaceApplicationInput {
	s.WorkspaceId = &v
	return s
}

type DisassociateWorkspaceApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the targeted association.
	Association *WorkspaceResourceAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateWorkspaceApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateWorkspaceApplicationOutput) GoString() string {
	return s.String()
}

// SetAssociation sets the Association field's value.
func (s *DisassociateWorkspaceApplicationOutput) SetAssociation(v *WorkspaceResourceAssociation) *DisassociateWorkspaceApplicationOutput {
	s.Association = v
	return s
}

// Describes in-depth details about the error. These details include the possible
// causes of the error and troubleshooting information.
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// Indicates the error code returned.
	ErrorCode *string `type:"string" enum:"WorkspaceImageErrorDetailCode"`

	// The text of the error message related the error code.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetails) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorDetails) SetErrorCode(v string) *ErrorDetails {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetails) SetErrorMessage(v string) *ErrorDetails {
	s.ErrorMessage = &v
	return s
}

// Describes the standby WorkSpace that could not be created.
type FailedCreateStandbyWorkspacesRequest struct {
	_ struct{} `type:"structure"`

	// The error code that is returned if the standby WorkSpace could not be created.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the standby WorkSpace could
	// not be created.
	ErrorMessage *string `type:"string"`

	// Information about the standby WorkSpace that could not be created.
	StandbyWorkspaceRequest *StandbyWorkspace `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedCreateStandbyWorkspacesRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedCreateStandbyWorkspacesRequest) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedCreateStandbyWorkspacesRequest) SetErrorCode(v string) *FailedCreateStandbyWorkspacesRequest {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedCreateStandbyWorkspacesRequest) SetErrorMessage(v string) *FailedCreateStandbyWorkspacesRequest {
	s.ErrorMessage = &v
	return s
}

// SetStandbyWorkspaceRequest sets the StandbyWorkspaceRequest field's value.
func (s *FailedCreateStandbyWorkspacesRequest) SetStandbyWorkspaceRequest(v *StandbyWorkspace) *FailedCreateStandbyWorkspacesRequest {
	s.StandbyWorkspaceRequest = v
	return s
}

// Describes a WorkSpace that cannot be created.
type FailedCreateWorkspaceRequest struct {
	_ struct{} `type:"structure"`

	// The error code that is returned if the WorkSpace cannot be created.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the WorkSpace cannot be
	// created.
	ErrorMessage *string `type:"string"`

	// Information about the WorkSpace.
	WorkspaceRequest *WorkspaceRequest `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedCreateWorkspaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedCreateWorkspaceRequest) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedCreateWorkspaceRequest) SetErrorCode(v string) *FailedCreateWorkspaceRequest {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedCreateWorkspaceRequest) SetErrorMessage(v string) *FailedCreateWorkspaceRequest {
	s.ErrorMessage = &v
	return s
}

// SetWorkspaceRequest sets the WorkspaceRequest field's value.
func (s *FailedCreateWorkspaceRequest) SetWorkspaceRequest(v *WorkspaceRequest) *FailedCreateWorkspaceRequest {
	s.WorkspaceRequest = v
	return s
}

// Describes a WorkSpace that could not be rebooted. (RebootWorkspaces), rebuilt
// (RebuildWorkspaces), restored (RestoreWorkspace), terminated (TerminateWorkspaces),
// started (StartWorkspaces), or stopped (StopWorkspaces).
type FailedWorkspaceChangeRequest struct {
	_ struct{} `type:"structure"`

	// The error code that is returned if the WorkSpace cannot be rebooted.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the WorkSpace cannot be
	// rebooted.
	ErrorMessage *string `type:"string"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedWorkspaceChangeRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedWorkspaceChangeRequest) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedWorkspaceChangeRequest) SetErrorCode(v string) *FailedWorkspaceChangeRequest {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedWorkspaceChangeRequest) SetErrorMessage(v string) *FailedWorkspaceChangeRequest {
	s.ErrorMessage = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *FailedWorkspaceChangeRequest) SetWorkspaceId(v string) *FailedWorkspaceChangeRequest {
	s.WorkspaceId = &v
	return s
}

type GetAccountLinkInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the account to link.
	LinkId *string `type:"string"`

	// The identifier of the account link
	LinkedAccountId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountLinkInput) GoString() string {
	return s.String()
}

// SetLinkId sets the LinkId field's value.
func (s *GetAccountLinkInput) SetLinkId(v string) *GetAccountLinkInput {
	s.LinkId = &v
	return s
}

// SetLinkedAccountId sets the LinkedAccountId field's value.
func (s *GetAccountLinkInput) SetLinkedAccountId(v string) *GetAccountLinkInput {
	s.LinkedAccountId = &v
	return s
}

type GetAccountLinkOutput struct {
	_ struct{} `type:"structure"`

	// The account link of the account link to retrieve.
	AccountLink *AccountLink `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountLinkOutput) GoString() string {
	return s.String()
}

// SetAccountLink sets the AccountLink field's value.
func (s *GetAccountLinkOutput) SetAccountLink(v *AccountLink) *GetAccountLinkOutput {
	s.AccountLink = v
	return s
}

// Describes the Amazon Web Services accounts that have been granted permission
// to use a shared image. For more information about sharing images, see Share
// or Unshare a Custom WorkSpaces Image (https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html).
type ImagePermission struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account that an image has been
	// shared with.
	SharedAccountId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImagePermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImagePermission) GoString() string {
	return s.String()
}

// SetSharedAccountId sets the SharedAccountId field's value.
func (s *ImagePermission) SetSharedAccountId(v string) *ImagePermission {
	s.SharedAccountId = &v
	return s
}

// Describes the association between an application and an image resource.
type ImageResourceAssociation struct {
	_ struct{} `type:"structure"`

	// The identifier of the associated resource.
	AssociatedResourceId *string `min:"1" type:"string"`

	// The resource type of the associated resources.
	AssociatedResourceType *string `type:"string" enum:"ImageAssociatedResourceType"`

	// The time the association is created.
	Created *time.Time `type:"timestamp"`

	// The identifier of the image.
	ImageId *string `type:"string"`

	// The time the association status was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The status of the image resource association.
	State *string `type:"string" enum:"AssociationState"`

	// The reason the association deployment failed.
	StateReason *AssociationStateReason `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageResourceAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageResourceAssociation) GoString() string {
	return s.String()
}

// SetAssociatedResourceId sets the AssociatedResourceId field's value.
func (s *ImageResourceAssociation) SetAssociatedResourceId(v string) *ImageResourceAssociation {
	s.AssociatedResourceId = &v
	return s
}

// SetAssociatedResourceType sets the AssociatedResourceType field's value.
func (s *ImageResourceAssociation) SetAssociatedResourceType(v string) *ImageResourceAssociation {
	s.AssociatedResourceType = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *ImageResourceAssociation) SetCreated(v time.Time) *ImageResourceAssociation {
	s.Created = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *ImageResourceAssociation) SetImageId(v string) *ImageResourceAssociation {
	s.ImageId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ImageResourceAssociation) SetLastUpdatedTime(v time.Time) *ImageResourceAssociation {
	s.LastUpdatedTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ImageResourceAssociation) SetState(v string) *ImageResourceAssociation {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *ImageResourceAssociation) SetStateReason(v *AssociationStateReason) *ImageResourceAssociation {
	s.StateReason = v
	return s
}

type ImportClientBrandingInput struct {
	_ struct{} `type:"structure"`

	// The branding information to import for Android devices.
	DeviceTypeAndroid *DefaultImportClientBrandingAttributes `type:"structure"`

	// The branding information to import for iOS devices.
	DeviceTypeIos *IosImportClientBrandingAttributes `type:"structure"`

	// The branding information to import for Linux devices.
	DeviceTypeLinux *DefaultImportClientBrandingAttributes `type:"structure"`

	// The branding information to import for macOS devices.
	DeviceTypeOsx *DefaultImportClientBrandingAttributes `type:"structure"`

	// The branding information to import for web access.
	DeviceTypeWeb *DefaultImportClientBrandingAttributes `type:"structure"`

	// The branding information to import for Windows devices.
	DeviceTypeWindows *DefaultImportClientBrandingAttributes `type:"structure"`

	// The directory identifier of the WorkSpace for which you want to import client
	// branding.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportClientBrandingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportClientBrandingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportClientBrandingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportClientBrandingInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.DeviceTypeAndroid != nil {
		if err := s.DeviceTypeAndroid.Validate(); err != nil {
			invalidParams.AddNested("DeviceTypeAndroid", err.(request.ErrInvalidParams))
		}
	}
	if s.DeviceTypeIos != nil {
		if err := s.DeviceTypeIos.Validate(); err != nil {
			invalidParams.AddNested("DeviceTypeIos", err.(request.ErrInvalidParams))
		}
	}
	if s.DeviceTypeLinux != nil {
		if err := s.DeviceTypeLinux.Validate(); err != nil {
			invalidParams.AddNested("DeviceTypeLinux", err.(request.ErrInvalidParams))
		}
	}
	if s.DeviceTypeOsx != nil {
		if err := s.DeviceTypeOsx.Validate(); err != nil {
			invalidParams.AddNested("DeviceTypeOsx", err.(request.ErrInvalidParams))
		}
	}
	if s.DeviceTypeWeb != nil {
		if err := s.DeviceTypeWeb.Validate(); err != nil {
			invalidParams.AddNested("DeviceTypeWeb", err.(request.ErrInvalidParams))
		}
	}
	if s.DeviceTypeWindows != nil {
		if err := s.DeviceTypeWindows.Validate(); err != nil {
			invalidParams.AddNested("DeviceTypeWindows", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceTypeAndroid sets the DeviceTypeAndroid field's value.
func (s *ImportClientBrandingInput) SetDeviceTypeAndroid(v *DefaultImportClientBrandingAttributes) *ImportClientBrandingInput {
	s.DeviceTypeAndroid = v
	return s
}

// SetDeviceTypeIos sets the DeviceTypeIos field's value.
func (s *ImportClientBrandingInput) SetDeviceTypeIos(v *IosImportClientBrandingAttributes) *ImportClientBrandingInput {
	s.DeviceTypeIos = v
	return s
}

// SetDeviceTypeLinux sets the DeviceTypeLinux field's value.
func (s *ImportClientBrandingInput) SetDeviceTypeLinux(v *DefaultImportClientBrandingAttributes) *ImportClientBrandingInput {
	s.DeviceTypeLinux = v
	return s
}

// SetDeviceTypeOsx sets the DeviceTypeOsx field's value.
func (s *ImportClientBrandingInput) SetDeviceTypeOsx(v *DefaultImportClientBrandingAttributes) *ImportClientBrandingInput {
	s.DeviceTypeOsx = v
	return s
}

// SetDeviceTypeWeb sets the DeviceTypeWeb field's value.
func (s *ImportClientBrandingInput) SetDeviceTypeWeb(v *DefaultImportClientBrandingAttributes) *ImportClientBrandingInput {
	s.DeviceTypeWeb = v
	return s
}

// SetDeviceTypeWindows sets the DeviceTypeWindows field's value.
func (s *ImportClientBrandingInput) SetDeviceTypeWindows(v *DefaultImportClientBrandingAttributes) *ImportClientBrandingInput {
	s.DeviceTypeWindows = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ImportClientBrandingInput) SetResourceId(v string) *ImportClientBrandingInput {
	s.ResourceId = &v
	return s
}

type ImportClientBrandingOutput struct {
	_ struct{} `type:"structure"`

	// The branding information configured for Android devices.
	DeviceTypeAndroid *DefaultClientBrandingAttributes `type:"structure"`

	// The branding information configured for iOS devices.
	DeviceTypeIos *IosClientBrandingAttributes `type:"structure"`

	// The branding information configured for Linux devices.
	DeviceTypeLinux *DefaultClientBrandingAttributes `type:"structure"`

	// The branding information configured for macOS devices.
	DeviceTypeOsx *DefaultClientBrandingAttributes `type:"structure"`

	// The branding information configured for web access.
	DeviceTypeWeb *DefaultClientBrandingAttributes `type:"structure"`

	// The branding information configured for Windows devices.
	DeviceTypeWindows *DefaultClientBrandingAttributes `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportClientBrandingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportClientBrandingOutput) GoString() string {
	return s.String()
}

// SetDeviceTypeAndroid sets the DeviceTypeAndroid field's value.
func (s *ImportClientBrandingOutput) SetDeviceTypeAndroid(v *DefaultClientBrandingAttributes) *ImportClientBrandingOutput {
	s.DeviceTypeAndroid = v
	return s
}

// SetDeviceTypeIos sets the DeviceTypeIos field's value.
func (s *ImportClientBrandingOutput) SetDeviceTypeIos(v *IosClientBrandingAttributes) *ImportClientBrandingOutput {
	s.DeviceTypeIos = v
	return s
}

// SetDeviceTypeLinux sets the DeviceTypeLinux field's value.
func (s *ImportClientBrandingOutput) SetDeviceTypeLinux(v *DefaultClientBrandingAttributes) *ImportClientBrandingOutput {
	s.DeviceTypeLinux = v
	return s
}

// SetDeviceTypeOsx sets the DeviceTypeOsx field's value.
func (s *ImportClientBrandingOutput) SetDeviceTypeOsx(v *DefaultClientBrandingAttributes) *ImportClientBrandingOutput {
	s.DeviceTypeOsx = v
	return s
}

// SetDeviceTypeWeb sets the DeviceTypeWeb field's value.
func (s *ImportClientBrandingOutput) SetDeviceTypeWeb(v *DefaultClientBrandingAttributes) *ImportClientBrandingOutput {
	s.DeviceTypeWeb = v
	return s
}

// SetDeviceTypeWindows sets the DeviceTypeWindows field's value.
func (s *ImportClientBrandingOutput) SetDeviceTypeWindows(v *DefaultClientBrandingAttributes) *ImportClientBrandingOutput {
	s.DeviceTypeWindows = v
	return s
}

type ImportWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// If specified, the version of Microsoft Office to subscribe to. Valid only
	// for Windows 10 and 11 BYOL images. For more information about subscribing
	// to Office for BYOL images, see Bring Your Own Windows Desktop Licenses (https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
	//
	//    * Although this parameter is an array, only one item is allowed at this
	//    time.
	//
	//    * Windows 11 only supports Microsoft_Office_2019.
	Applications []*string `min:"1" type:"list" enum:"Application"`

	// The identifier of the EC2 image.
	//
	// Ec2ImageId is a required field
	Ec2ImageId *string `type:"string" required:"true"`

	// The description of the WorkSpace image.
	//
	// ImageDescription is a required field
	ImageDescription *string `min:"1" type:"string" required:"true"`

	// The name of the WorkSpace image.
	//
	// ImageName is a required field
	ImageName *string `min:"1" type:"string" required:"true"`

	// The ingestion process to be used when importing the image, depending on which
	// protocol you want to use for your BYOL Workspace image, either PCoIP, WorkSpaces
	// Streaming Protocol (WSP), or bring your own protocol (BYOP). To use WSP,
	// specify a value that ends in _WSP. To use PCoIP, specify a value that does
	// not end in _WSP. To use BYOP, specify a value that ends in _BYOP.
	//
	// For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro),
	// specify BYOL_REGULAR, BYOL_REGULAR_WSP, or BYOL_REGULAR_BYOP, depending on
	// the protocol.
	//
	// The BYOL_REGULAR_BYOP and BYOL_GRAPHICS_G4DN_BYOP values are only supported
	// by Amazon WorkSpaces Core. Contact your account team to be allow-listed to
	// use these values. For more information, see Amazon WorkSpaces Core (http://aws.amazon.com/workspaces/core/).
	//
	// IngestionProcess is a required field
	IngestionProcess *string `type:"string" required:"true" enum:"WorkspaceImageIngestionProcess"`

	// The tags. Each WorkSpaces resource can have a maximum of 50 tags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportWorkspaceImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportWorkspaceImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportWorkspaceImageInput"}
	if s.Applications != nil && len(s.Applications) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Applications", 1))
	}
	if s.Ec2ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("Ec2ImageId"))
	}
	if s.ImageDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageDescription"))
	}
	if s.ImageDescription != nil && len(*s.ImageDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageDescription", 1))
	}
	if s.ImageName == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageName"))
	}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageName", 1))
	}
	if s.IngestionProcess == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionProcess"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplications sets the Applications field's value.
func (s *ImportWorkspaceImageInput) SetApplications(v []*string) *ImportWorkspaceImageInput {
	s.Applications = v
	return s
}

// SetEc2ImageId sets the Ec2ImageId field's value.
func (s *ImportWorkspaceImageInput) SetEc2ImageId(v string) *ImportWorkspaceImageInput {
	s.Ec2ImageId = &v
	return s
}

// SetImageDescription sets the ImageDescription field's value.
func (s *ImportWorkspaceImageInput) SetImageDescription(v string) *ImportWorkspaceImageInput {
	s.ImageDescription = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *ImportWorkspaceImageInput) SetImageName(v string) *ImportWorkspaceImageInput {
	s.ImageName = &v
	return s
}

// SetIngestionProcess sets the IngestionProcess field's value.
func (s *ImportWorkspaceImageInput) SetIngestionProcess(v string) *ImportWorkspaceImageInput {
	s.IngestionProcess = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportWorkspaceImageInput) SetTags(v []*Tag) *ImportWorkspaceImageInput {
	s.Tags = v
	return s
}

type ImportWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace image.
	ImageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportWorkspaceImageOutput) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *ImportWorkspaceImageOutput) SetImageId(v string) *ImportWorkspaceImageOutput {
	s.ImageId = &v
	return s
}

// The specified application is not compatible with the resource.
type IncompatibleApplicationsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncompatibleApplicationsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncompatibleApplicationsException) GoString() string {
	return s.String()
}

func newErrorIncompatibleApplicationsException(v protocol.ResponseMetadata) error {
	return &IncompatibleApplicationsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IncompatibleApplicationsException) Code() string {
	return "IncompatibleApplicationsException"
}

// Message returns the exception's message.
func (s *IncompatibleApplicationsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IncompatibleApplicationsException) OrigErr() error {
	return nil
}

func (s *IncompatibleApplicationsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IncompatibleApplicationsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IncompatibleApplicationsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Unexpected server error occured.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more parameter values are not valid.
type InvalidParameterValuesException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception error message.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValuesException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValuesException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterValuesException(v protocol.ResponseMetadata) error {
	return &InvalidParameterValuesException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterValuesException) Code() string {
	return "InvalidParameterValuesException"
}

// Message returns the exception's message.
func (s *InvalidParameterValuesException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterValuesException) OrigErr() error {
	return nil
}

func (s *InvalidParameterValuesException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterValuesException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterValuesException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The state of the resource is not valid for this operation.
type InvalidResourceStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourceStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourceStateException) GoString() string {
	return s.String()
}

func newErrorInvalidResourceStateException(v protocol.ResponseMetadata) error {
	return &InvalidResourceStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourceStateException) Code() string {
	return "InvalidResourceStateException"
}

// Message returns the exception's message.
func (s *InvalidResourceStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourceStateException) OrigErr() error {
	return nil
}

func (s *InvalidResourceStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourceStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourceStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The client branding attributes for iOS device types. These attributes are
// displayed on the iOS client login screen only.
//
// Client branding attributes are public facing. Ensure you do not include sensitive
// information.
type IosClientBrandingAttributes struct {
	_ struct{} `type:"structure"`

	// The forgotten password link. This is the web address that users can go to
	// if they forget the password for their WorkSpace.
	ForgotPasswordLink *string `min:"1" type:"string"`

	// The login message. Specified as a key value pair, in which the key is a locale
	// and the value is the localized message for that locale. The only key supported
	// is en_US. The HTML tags supported include the following: a, b, blockquote,
	// br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike,
	// strong, sub, sup, u, ul.
	LoginMessage map[string]*string `type:"map"`

	// The @2x version of the logo. This is the higher resolution display that offers
	// a scale factor of 2.0 (or @2x). The only image format accepted is a binary
	// data object that is converted from a .png file.
	//
	// For more information about iOS image size and resolution, see Image Size
	// and Resolution (https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/)
	// in the Apple Human Interface Guidelines.
	Logo2xUrl *string `min:"1" type:"string"`

	// The @3x version of the logo. This is the higher resolution display that offers
	// a scale factor of 3.0 (or @3x).The only image format accepted is a binary
	// data object that is converted from a .png file.
	//
	// For more information about iOS image size and resolution, see Image Size
	// and Resolution (https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/)
	// in the Apple Human Interface Guidelines.
	Logo3xUrl *string `min:"1" type:"string"`

	// The logo. This is the standard-resolution display that has a 1:1 pixel density
	// (or @1x), where one pixel is equal to one point. The only image format accepted
	// is a binary data object that is converted from a .png file.
	LogoUrl *string `min:"1" type:"string"`

	// The support email. The company's customer support email address.
	//
	//    * In each platform type, the SupportEmail and SupportLink parameters are
	//    mutually exclusive. You can specify one parameter for each platform type,
	//    but not both.
	//
	//    * The default email is workspaces-feedback@amazon.com.
	SupportEmail *string `min:"6" type:"string"`

	// The support link. The link for the company's customer support page for their
	// WorkSpace.
	//
	//    * In each platform type, the SupportEmail and SupportLink parameters are
	//    mutually exclusive. You can specify one parameter for each platform type,
	//    but not both.
	//
	//    * The default support link is workspaces-feedback@amazon.com.
	SupportLink *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IosClientBrandingAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IosClientBrandingAttributes) GoString() string {
	return s.String()
}

// SetForgotPasswordLink sets the ForgotPasswordLink field's value.
func (s *IosClientBrandingAttributes) SetForgotPasswordLink(v string) *IosClientBrandingAttributes {
	s.ForgotPasswordLink = &v
	return s
}

// SetLoginMessage sets the LoginMessage field's value.
func (s *IosClientBrandingAttributes) SetLoginMessage(v map[string]*string) *IosClientBrandingAttributes {
	s.LoginMessage = v
	return s
}

// SetLogo2xUrl sets the Logo2xUrl field's value.
func (s *IosClientBrandingAttributes) SetLogo2xUrl(v string) *IosClientBrandingAttributes {
	s.Logo2xUrl = &v
	return s
}

// SetLogo3xUrl sets the Logo3xUrl field's value.
func (s *IosClientBrandingAttributes) SetLogo3xUrl(v string) *IosClientBrandingAttributes {
	s.Logo3xUrl = &v
	return s
}

// SetLogoUrl sets the LogoUrl field's value.
func (s *IosClientBrandingAttributes) SetLogoUrl(v string) *IosClientBrandingAttributes {
	s.LogoUrl = &v
	return s
}

// SetSupportEmail sets the SupportEmail field's value.
func (s *IosClientBrandingAttributes) SetSupportEmail(v string) *IosClientBrandingAttributes {
	s.SupportEmail = &v
	return s
}

// SetSupportLink sets the SupportLink field's value.
func (s *IosClientBrandingAttributes) SetSupportLink(v string) *IosClientBrandingAttributes {
	s.SupportLink = &v
	return s
}

// The client branding attributes to import for iOS device types. These attributes
// are displayed on the iOS client login screen.
//
// Client branding attributes are public facing. Ensure you do not include sensitive
// information.
type IosImportClientBrandingAttributes struct {
	_ struct{} `type:"structure"`

	// The forgotten password link. This is the web address that users can go to
	// if they forget the password for their WorkSpace.
	ForgotPasswordLink *string `min:"1" type:"string"`

	// The login message. Specified as a key value pair, in which the key is a locale
	// and the value is the localized message for that locale. The only key supported
	// is en_US. The HTML tags supported include the following: a, b, blockquote,
	// br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike,
	// strong, sub, sup, u, ul.
	LoginMessage map[string]*string `type:"map"`

	// The logo. This is the standard-resolution display that has a 1:1 pixel density
	// (or @1x), where one pixel is equal to one point. The only image format accepted
	// is a binary data object that is converted from a .png file.
	// Logo is automatically base64 encoded/decoded by the SDK.
	Logo []byte `min:"1" type:"blob"`

	// The @2x version of the logo. This is the higher resolution display that offers
	// a scale factor of 2.0 (or @2x). The only image format accepted is a binary
	// data object that is converted from a .png file.
	//
	// For more information about iOS image size and resolution, see Image Size
	// and Resolution (https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/)
	// in the Apple Human Interface Guidelines.
	// Logo2x is automatically base64 encoded/decoded by the SDK.
	Logo2x []byte `min:"1" type:"blob"`

	// The @3x version of the logo. This is the higher resolution display that offers
	// a scale factor of 3.0 (or @3x). The only image format accepted is a binary
	// data object that is converted from a .png file.
	//
	// For more information about iOS image size and resolution, see Image Size
	// and Resolution (https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/)
	// in the Apple Human Interface Guidelines.
	// Logo3x is automatically base64 encoded/decoded by the SDK.
	Logo3x []byte `min:"1" type:"blob"`

	// The support email. The company's customer support email address.
	//
	//    * In each platform type, the SupportEmail and SupportLink parameters are
	//    mutually exclusive. You can specify one parameter for each platform type,
	//    but not both.
	//
	//    * The default email is workspaces-feedback@amazon.com.
	SupportEmail *string `min:"6" type:"string"`

	// The support link. The link for the company's customer support page for their
	// WorkSpace.
	//
	//    * In each platform type, the SupportEmail and SupportLink parameters are
	//    mutually exclusive. You can specify one parameter for each platform type,
	//    but not both.
	//
	//    * The default support link is workspaces-feedback@amazon.com.
	SupportLink *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IosImportClientBrandingAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IosImportClientBrandingAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IosImportClientBrandingAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IosImportClientBrandingAttributes"}
	if s.ForgotPasswordLink != nil && len(*s.ForgotPasswordLink) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ForgotPasswordLink", 1))
	}
	if s.Logo != nil && len(s.Logo) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Logo", 1))
	}
	if s.Logo2x != nil && len(s.Logo2x) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Logo2x", 1))
	}
	if s.Logo3x != nil && len(s.Logo3x) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Logo3x", 1))
	}
	if s.SupportEmail != nil && len(*s.SupportEmail) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SupportEmail", 6))
	}
	if s.SupportLink != nil && len(*s.SupportLink) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SupportLink", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForgotPasswordLink sets the ForgotPasswordLink field's value.
func (s *IosImportClientBrandingAttributes) SetForgotPasswordLink(v string) *IosImportClientBrandingAttributes {
	s.ForgotPasswordLink = &v
	return s
}

// SetLoginMessage sets the LoginMessage field's value.
func (s *IosImportClientBrandingAttributes) SetLoginMessage(v map[string]*string) *IosImportClientBrandingAttributes {
	s.LoginMessage = v
	return s
}

// SetLogo sets the Logo field's value.
func (s *IosImportClientBrandingAttributes) SetLogo(v []byte) *IosImportClientBrandingAttributes {
	s.Logo = v
	return s
}

// SetLogo2x sets the Logo2x field's value.
func (s *IosImportClientBrandingAttributes) SetLogo2x(v []byte) *IosImportClientBrandingAttributes {
	s.Logo2x = v
	return s
}

// SetLogo3x sets the Logo3x field's value.
func (s *IosImportClientBrandingAttributes) SetLogo3x(v []byte) *IosImportClientBrandingAttributes {
	s.Logo3x = v
	return s
}

// SetSupportEmail sets the SupportEmail field's value.
func (s *IosImportClientBrandingAttributes) SetSupportEmail(v string) *IosImportClientBrandingAttributes {
	s.SupportEmail = &v
	return s
}

// SetSupportLink sets the SupportLink field's value.
func (s *IosImportClientBrandingAttributes) SetSupportLink(v string) *IosImportClientBrandingAttributes {
	s.SupportLink = &v
	return s
}

// Describes an IP access control group.
type IpGroup struct {
	_ struct{} `type:"structure"`

	// The description of the group.
	GroupDesc *string `locationName:"groupDesc" type:"string"`

	// The identifier of the group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the group.
	GroupName *string `locationName:"groupName" type:"string"`

	// The rules.
	UserRules []*IpRuleItem `locationName:"userRules" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpGroup) GoString() string {
	return s.String()
}

// SetGroupDesc sets the GroupDesc field's value.
func (s *IpGroup) SetGroupDesc(v string) *IpGroup {
	s.GroupDesc = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *IpGroup) SetGroupId(v string) *IpGroup {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *IpGroup) SetGroupName(v string) *IpGroup {
	s.GroupName = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *IpGroup) SetUserRules(v []*IpRuleItem) *IpGroup {
	s.UserRules = v
	return s
}

// Describes a rule for an IP access control group.
type IpRuleItem struct {
	_ struct{} `type:"structure"`

	// The IP address range, in CIDR notation.
	IpRule *string `locationName:"ipRule" type:"string"`

	// The description.
	RuleDesc *string `locationName:"ruleDesc" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpRuleItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpRuleItem) GoString() string {
	return s.String()
}

// SetIpRule sets the IpRule field's value.
func (s *IpRuleItem) SetIpRule(v string) *IpRuleItem {
	s.IpRule = &v
	return s
}

// SetRuleDesc sets the RuleDesc field's value.
func (s *IpRuleItem) SetRuleDesc(v string) *IpRuleItem {
	s.RuleDesc = &v
	return s
}

type ListAccountLinksInput struct {
	_ struct{} `type:"structure"`

	// Filters the account based on their link status.
	LinkStatusFilter []*string `type:"list" enum:"AccountLinkStatusEnum"`

	// The maximum number of accounts to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountLinksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountLinksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountLinksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountLinksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLinkStatusFilter sets the LinkStatusFilter field's value.
func (s *ListAccountLinksInput) SetLinkStatusFilter(v []*string) *ListAccountLinksInput {
	s.LinkStatusFilter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountLinksInput) SetMaxResults(v int64) *ListAccountLinksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountLinksInput) SetNextToken(v string) *ListAccountLinksInput {
	s.NextToken = &v
	return s
}

type ListAccountLinksOutput struct {
	_ struct{} `type:"structure"`

	// Information about the account links.
	AccountLinks []*AccountLink `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountLinksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountLinksOutput) GoString() string {
	return s.String()
}

// SetAccountLinks sets the AccountLinks field's value.
func (s *ListAccountLinksOutput) SetAccountLinks(v []*AccountLink) *ListAccountLinksOutput {
	s.AccountLinks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountLinksOutput) SetNextToken(v string) *ListAccountLinksOutput {
	s.NextToken = &v
	return s
}

type ListAvailableManagementCidrRangesInput struct {
	_ struct{} `type:"structure"`

	// The IP address range to search. Specify an IP address range that is compatible
	// with your network and in CIDR notation (that is, specify the range as an
	// IPv4 CIDR block).
	//
	// ManagementCidrRangeConstraint is a required field
	ManagementCidrRangeConstraint *string `type:"string" required:"true"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableManagementCidrRangesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableManagementCidrRangesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAvailableManagementCidrRangesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAvailableManagementCidrRangesInput"}
	if s.ManagementCidrRangeConstraint == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagementCidrRangeConstraint"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagementCidrRangeConstraint sets the ManagementCidrRangeConstraint field's value.
func (s *ListAvailableManagementCidrRangesInput) SetManagementCidrRangeConstraint(v string) *ListAvailableManagementCidrRangesInput {
	s.ManagementCidrRangeConstraint = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAvailableManagementCidrRangesInput) SetMaxResults(v int64) *ListAvailableManagementCidrRangesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAvailableManagementCidrRangesInput) SetNextToken(v string) *ListAvailableManagementCidrRangesInput {
	s.NextToken = &v
	return s
}

type ListAvailableManagementCidrRangesOutput struct {
	_ struct{} `type:"structure"`

	// The list of available IP address ranges, specified as IPv4 CIDR blocks.
	ManagementCidrRanges []*string `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableManagementCidrRangesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableManagementCidrRangesOutput) GoString() string {
	return s.String()
}

// SetManagementCidrRanges sets the ManagementCidrRanges field's value.
func (s *ListAvailableManagementCidrRangesOutput) SetManagementCidrRanges(v []*string) *ListAvailableManagementCidrRangesOutput {
	s.ManagementCidrRanges = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAvailableManagementCidrRangesOutput) SetNextToken(v string) *ListAvailableManagementCidrRangesOutput {
	s.NextToken = &v
	return s
}

type MigrateWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the target bundle type to migrate the WorkSpace to.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`

	// The identifier of the WorkSpace to migrate from.
	//
	// SourceWorkspaceId is a required field
	SourceWorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MigrateWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MigrateWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MigrateWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MigrateWorkspaceInput"}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.SourceWorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceWorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *MigrateWorkspaceInput) SetBundleId(v string) *MigrateWorkspaceInput {
	s.BundleId = &v
	return s
}

// SetSourceWorkspaceId sets the SourceWorkspaceId field's value.
func (s *MigrateWorkspaceInput) SetSourceWorkspaceId(v string) *MigrateWorkspaceInput {
	s.SourceWorkspaceId = &v
	return s
}

type MigrateWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// The original identifier of the WorkSpace that is being migrated.
	SourceWorkspaceId *string `type:"string"`

	// The new identifier of the WorkSpace that is being migrated. If the migration
	// does not succeed, the target WorkSpace ID will not be used, and the WorkSpace
	// will still have the original WorkSpace ID.
	TargetWorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MigrateWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MigrateWorkspaceOutput) GoString() string {
	return s.String()
}

// SetSourceWorkspaceId sets the SourceWorkspaceId field's value.
func (s *MigrateWorkspaceOutput) SetSourceWorkspaceId(v string) *MigrateWorkspaceOutput {
	s.SourceWorkspaceId = &v
	return s
}

// SetTargetWorkspaceId sets the TargetWorkspaceId field's value.
func (s *MigrateWorkspaceOutput) SetTargetWorkspaceId(v string) *MigrateWorkspaceOutput {
	s.TargetWorkspaceId = &v
	return s
}

// Describes a WorkSpace modification.
type ModificationState struct {
	_ struct{} `type:"structure"`

	// The resource.
	Resource *string `type:"string" enum:"ModificationResourceEnum"`

	// The modification state.
	State *string `type:"string" enum:"ModificationStateEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModificationState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModificationState) GoString() string {
	return s.String()
}

// SetResource sets the Resource field's value.
func (s *ModificationState) SetResource(v string) *ModificationState {
	s.Resource = &v
	return s
}

// SetState sets the State field's value.
func (s *ModificationState) SetState(v string) *ModificationState {
	s.State = &v
	return s
}

type ModifyAccountInput struct {
	_ struct{} `type:"structure"`

	// The IP address range, specified as an IPv4 CIDR block, for the management
	// network interface. Specify an IP address range that is compatible with your
	// network and in CIDR notation (that is, specify the range as an IPv4 CIDR
	// block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It
	// must also be specified as available by the ListAvailableManagementCidrRanges
	// operation.
	DedicatedTenancyManagementCidrRange *string `type:"string"`

	// The status of BYOL.
	DedicatedTenancySupport *string `type:"string" enum:"DedicatedTenancySupportEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyAccountInput) GoString() string {
	return s.String()
}

// SetDedicatedTenancyManagementCidrRange sets the DedicatedTenancyManagementCidrRange field's value.
func (s *ModifyAccountInput) SetDedicatedTenancyManagementCidrRange(v string) *ModifyAccountInput {
	s.DedicatedTenancyManagementCidrRange = &v
	return s
}

// SetDedicatedTenancySupport sets the DedicatedTenancySupport field's value.
func (s *ModifyAccountInput) SetDedicatedTenancySupport(v string) *ModifyAccountInput {
	s.DedicatedTenancySupport = &v
	return s
}

type ModifyAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyAccountOutput) GoString() string {
	return s.String()
}

type ModifyCertificateBasedAuthPropertiesInput struct {
	_ struct{} `type:"structure"`

	// The properties of the certificate-based authentication.
	CertificateBasedAuthProperties *CertificateBasedAuthProperties `type:"structure"`

	// The properties of the certificate-based authentication you want to delete.
	PropertiesToDelete []*string `type:"list" enum:"DeletableCertificateBasedAuthProperty"`

	// The resource identifiers, in the form of directory IDs.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyCertificateBasedAuthPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyCertificateBasedAuthPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyCertificateBasedAuthPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyCertificateBasedAuthPropertiesInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.CertificateBasedAuthProperties != nil {
		if err := s.CertificateBasedAuthProperties.Validate(); err != nil {
			invalidParams.AddNested("CertificateBasedAuthProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateBasedAuthProperties sets the CertificateBasedAuthProperties field's value.
func (s *ModifyCertificateBasedAuthPropertiesInput) SetCertificateBasedAuthProperties(v *CertificateBasedAuthProperties) *ModifyCertificateBasedAuthPropertiesInput {
	s.CertificateBasedAuthProperties = v
	return s
}

// SetPropertiesToDelete sets the PropertiesToDelete field's value.
func (s *ModifyCertificateBasedAuthPropertiesInput) SetPropertiesToDelete(v []*string) *ModifyCertificateBasedAuthPropertiesInput {
	s.PropertiesToDelete = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ModifyCertificateBasedAuthPropertiesInput) SetResourceId(v string) *ModifyCertificateBasedAuthPropertiesInput {
	s.ResourceId = &v
	return s
}

type ModifyCertificateBasedAuthPropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyCertificateBasedAuthPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyCertificateBasedAuthPropertiesOutput) GoString() string {
	return s.String()
}

type ModifyClientPropertiesInput struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon WorkSpaces client.
	//
	// ClientProperties is a required field
	ClientProperties *ClientProperties `type:"structure" required:"true"`

	// The resource identifiers, in the form of directory IDs.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyClientPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyClientPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClientPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClientPropertiesInput"}
	if s.ClientProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientProperties"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientProperties sets the ClientProperties field's value.
func (s *ModifyClientPropertiesInput) SetClientProperties(v *ClientProperties) *ModifyClientPropertiesInput {
	s.ClientProperties = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ModifyClientPropertiesInput) SetResourceId(v string) *ModifyClientPropertiesInput {
	s.ResourceId = &v
	return s
}

type ModifyClientPropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyClientPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyClientPropertiesOutput) GoString() string {
	return s.String()
}

type ModifySamlPropertiesInput struct {
	_ struct{} `type:"structure"`

	// The SAML properties to delete as part of your request.
	//
	// Specify one of the following options:
	//
	//    * SAML_PROPERTIES_USER_ACCESS_URL to delete the user access URL.
	//
	//    * SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME to delete the relay state
	//    parameter name.
	PropertiesToDelete []*string `type:"list" enum:"DeletableSamlProperty"`

	// The directory identifier for which you want to configure SAML properties.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The properties for configuring SAML 2.0 authentication.
	SamlProperties *SamlProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifySamlPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifySamlPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifySamlPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifySamlPropertiesInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.SamlProperties != nil {
		if err := s.SamlProperties.Validate(); err != nil {
			invalidParams.AddNested("SamlProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPropertiesToDelete sets the PropertiesToDelete field's value.
func (s *ModifySamlPropertiesInput) SetPropertiesToDelete(v []*string) *ModifySamlPropertiesInput {
	s.PropertiesToDelete = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ModifySamlPropertiesInput) SetResourceId(v string) *ModifySamlPropertiesInput {
	s.ResourceId = &v
	return s
}

// SetSamlProperties sets the SamlProperties field's value.
func (s *ModifySamlPropertiesInput) SetSamlProperties(v *SamlProperties) *ModifySamlPropertiesInput {
	s.SamlProperties = v
	return s
}

type ModifySamlPropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifySamlPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifySamlPropertiesOutput) GoString() string {
	return s.String()
}

type ModifySelfservicePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The permissions to enable or disable self-service capabilities.
	//
	// SelfservicePermissions is a required field
	SelfservicePermissions *SelfservicePermissions `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifySelfservicePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifySelfservicePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifySelfservicePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifySelfservicePermissionsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.SelfservicePermissions == nil {
		invalidParams.Add(request.NewErrParamRequired("SelfservicePermissions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *ModifySelfservicePermissionsInput) SetResourceId(v string) *ModifySelfservicePermissionsInput {
	s.ResourceId = &v
	return s
}

// SetSelfservicePermissions sets the SelfservicePermissions field's value.
func (s *ModifySelfservicePermissionsInput) SetSelfservicePermissions(v *SelfservicePermissions) *ModifySelfservicePermissionsInput {
	s.SelfservicePermissions = v
	return s
}

type ModifySelfservicePermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifySelfservicePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifySelfservicePermissionsOutput) GoString() string {
	return s.String()
}

type ModifyStreamingPropertiesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The streaming properties to configure.
	StreamingProperties *StreamingProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyStreamingPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyStreamingPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyStreamingPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyStreamingPropertiesInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.StreamingProperties != nil {
		if err := s.StreamingProperties.Validate(); err != nil {
			invalidParams.AddNested("StreamingProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *ModifyStreamingPropertiesInput) SetResourceId(v string) *ModifyStreamingPropertiesInput {
	s.ResourceId = &v
	return s
}

// SetStreamingProperties sets the StreamingProperties field's value.
func (s *ModifyStreamingPropertiesInput) SetStreamingProperties(v *StreamingProperties) *ModifyStreamingPropertiesInput {
	s.StreamingProperties = v
	return s
}

type ModifyStreamingPropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyStreamingPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyStreamingPropertiesOutput) GoString() string {
	return s.String()
}

type ModifyWorkspaceAccessPropertiesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The device types and operating systems to enable or disable for access.
	//
	// WorkspaceAccessProperties is a required field
	WorkspaceAccessProperties *WorkspaceAccessProperties `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceAccessPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceAccessPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspaceAccessPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspaceAccessPropertiesInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.WorkspaceAccessProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceAccessProperties"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *ModifyWorkspaceAccessPropertiesInput) SetResourceId(v string) *ModifyWorkspaceAccessPropertiesInput {
	s.ResourceId = &v
	return s
}

// SetWorkspaceAccessProperties sets the WorkspaceAccessProperties field's value.
func (s *ModifyWorkspaceAccessPropertiesInput) SetWorkspaceAccessProperties(v *WorkspaceAccessProperties) *ModifyWorkspaceAccessPropertiesInput {
	s.WorkspaceAccessProperties = v
	return s
}

type ModifyWorkspaceAccessPropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceAccessPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceAccessPropertiesOutput) GoString() string {
	return s.String()
}

type ModifyWorkspaceCreationPropertiesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The default properties for creating WorkSpaces.
	//
	// WorkspaceCreationProperties is a required field
	WorkspaceCreationProperties *WorkspaceCreationProperties `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceCreationPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceCreationPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspaceCreationPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspaceCreationPropertiesInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.WorkspaceCreationProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceCreationProperties"))
	}
	if s.WorkspaceCreationProperties != nil {
		if err := s.WorkspaceCreationProperties.Validate(); err != nil {
			invalidParams.AddNested("WorkspaceCreationProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *ModifyWorkspaceCreationPropertiesInput) SetResourceId(v string) *ModifyWorkspaceCreationPropertiesInput {
	s.ResourceId = &v
	return s
}

// SetWorkspaceCreationProperties sets the WorkspaceCreationProperties field's value.
func (s *ModifyWorkspaceCreationPropertiesInput) SetWorkspaceCreationProperties(v *WorkspaceCreationProperties) *ModifyWorkspaceCreationPropertiesInput {
	s.WorkspaceCreationProperties = v
	return s
}

type ModifyWorkspaceCreationPropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceCreationPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceCreationPropertiesOutput) GoString() string {
	return s.String()
}

type ModifyWorkspacePropertiesInput struct {
	_ struct{} `type:"structure"`

	// Indicates the data replication status.
	DataReplication *string `type:"string" enum:"DataReplication"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`

	// The properties of the WorkSpace.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspacePropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspacePropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspacePropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspacePropertiesInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataReplication sets the DataReplication field's value.
func (s *ModifyWorkspacePropertiesInput) SetDataReplication(v string) *ModifyWorkspacePropertiesInput {
	s.DataReplication = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ModifyWorkspacePropertiesInput) SetWorkspaceId(v string) *ModifyWorkspacePropertiesInput {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *ModifyWorkspacePropertiesInput) SetWorkspaceProperties(v *WorkspaceProperties) *ModifyWorkspacePropertiesInput {
	s.WorkspaceProperties = v
	return s
}

type ModifyWorkspacePropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspacePropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspacePropertiesOutput) GoString() string {
	return s.String()
}

type ModifyWorkspaceStateInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`

	// The WorkSpace state.
	//
	// WorkspaceState is a required field
	WorkspaceState *string `type:"string" required:"true" enum:"TargetWorkspaceState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspaceStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspaceStateInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceState == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceState"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ModifyWorkspaceStateInput) SetWorkspaceId(v string) *ModifyWorkspaceStateInput {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceState sets the WorkspaceState field's value.
func (s *ModifyWorkspaceStateInput) SetWorkspaceState(v string) *ModifyWorkspaceStateInput {
	s.WorkspaceState = &v
	return s
}

type ModifyWorkspaceStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceStateOutput) GoString() string {
	return s.String()
}

// Describes the network details of a WorkSpaces Pool.
type NetworkAccessConfiguration struct {
	_ struct{} `type:"structure"`

	// The resource identifier of the elastic network interface that is attached
	// to instances in your VPC. All network interfaces have the eni-xxxxxxxx resource
	// identifier.
	EniId *string `min:"1" type:"string"`

	// The private IP address of the elastic network interface that is attached
	// to instances in your VPC.
	EniPrivateIpAddress *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkAccessConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkAccessConfiguration) GoString() string {
	return s.String()
}

// SetEniId sets the EniId field's value.
func (s *NetworkAccessConfiguration) SetEniId(v string) *NetworkAccessConfiguration {
	s.EniId = &v
	return s
}

// SetEniPrivateIpAddress sets the EniPrivateIpAddress field's value.
func (s *NetworkAccessConfiguration) SetEniPrivateIpAddress(v string) *NetworkAccessConfiguration {
	s.EniPrivateIpAddress = &v
	return s
}

// The operating system that the image is running.
type OperatingSystem struct {
	_ struct{} `type:"structure"`

	// The operating system.
	Type *string `type:"string" enum:"OperatingSystemType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperatingSystem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperatingSystem) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *OperatingSystem) SetType(v string) *OperatingSystem {
	s.Type = &v
	return s
}

// The operating system of the WorkSpace is not compatible with the application.
type OperatingSystemNotCompatibleException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperatingSystemNotCompatibleException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperatingSystemNotCompatibleException) GoString() string {
	return s.String()
}

func newErrorOperatingSystemNotCompatibleException(v protocol.ResponseMetadata) error {
	return &OperatingSystemNotCompatibleException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperatingSystemNotCompatibleException) Code() string {
	return "OperatingSystemNotCompatibleException"
}

// Message returns the exception's message.
func (s *OperatingSystemNotCompatibleException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperatingSystemNotCompatibleException) OrigErr() error {
	return nil
}

func (s *OperatingSystemNotCompatibleException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperatingSystemNotCompatibleException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperatingSystemNotCompatibleException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The properties of this WorkSpace are currently being modified. Try again
// in a moment.
type OperationInProgressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationInProgressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationInProgressException) GoString() string {
	return s.String()
}

func newErrorOperationInProgressException(v protocol.ResponseMetadata) error {
	return &OperationInProgressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationInProgressException) Code() string {
	return "OperationInProgressException"
}

// Message returns the exception's message.
func (s *OperationInProgressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationInProgressException) OrigErr() error {
	return nil
}

func (s *OperationInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationInProgressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationInProgressException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This operation is not supported.
type OperationNotSupportedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception error message.
	Message_ *string `locationName:"message" type:"string"`

	// The exception error reason.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationNotSupportedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationNotSupportedException) GoString() string {
	return s.String()
}

func newErrorOperationNotSupportedException(v protocol.ResponseMetadata) error {
	return &OperationNotSupportedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationNotSupportedException) Code() string {
	return "OperationNotSupportedException"
}

// Message returns the exception's message.
func (s *OperationNotSupportedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationNotSupportedException) OrigErr() error {
	return nil
}

func (s *OperationNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationNotSupportedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationNotSupportedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the standby WorkSpace.
type PendingCreateStandbyWorkspacesRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for the standby WorkSpace.
	DirectoryId *string `min:"10" type:"string"`

	// The operational state of the standby WorkSpace.
	State *string `type:"string" enum:"WorkspaceState"`

	// Describes the standby WorkSpace that was created.
	//
	// Because this operation is asynchronous, the identifier returned is not immediately
	// available for use with other operations. For example, if you call DescribeWorkspaces
	// (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html)
	// before the WorkSpace is created, the information returned can be incomplete.
	UserName *string `min:"1" type:"string"`

	// The identifier of the standby WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingCreateStandbyWorkspacesRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingCreateStandbyWorkspacesRequest) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *PendingCreateStandbyWorkspacesRequest) SetDirectoryId(v string) *PendingCreateStandbyWorkspacesRequest {
	s.DirectoryId = &v
	return s
}

// SetState sets the State field's value.
func (s *PendingCreateStandbyWorkspacesRequest) SetState(v string) *PendingCreateStandbyWorkspacesRequest {
	s.State = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *PendingCreateStandbyWorkspacesRequest) SetUserName(v string) *PendingCreateStandbyWorkspacesRequest {
	s.UserName = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *PendingCreateStandbyWorkspacesRequest) SetWorkspaceId(v string) *PendingCreateStandbyWorkspacesRequest {
	s.WorkspaceId = &v
	return s
}

// Describes the information used to reboot a WorkSpace.
type RebootRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RebootRequest) SetWorkspaceId(v string) *RebootRequest {
	s.WorkspaceId = &v
	return s
}

type RebootWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.
	//
	// RebootWorkspaceRequests is a required field
	RebootWorkspaceRequests []*RebootRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootWorkspacesInput"}
	if s.RebootWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("RebootWorkspaceRequests"))
	}
	if s.RebootWorkspaceRequests != nil && len(s.RebootWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RebootWorkspaceRequests", 1))
	}
	if s.RebootWorkspaceRequests != nil {
		for i, v := range s.RebootWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RebootWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRebootWorkspaceRequests sets the RebootWorkspaceRequests field's value.
func (s *RebootWorkspacesInput) SetRebootWorkspaceRequests(v []*RebootRequest) *RebootWorkspacesInput {
	s.RebootWorkspaceRequests = v
	return s
}

type RebootWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be rebooted.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *RebootWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *RebootWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Describes the information used to rebuild a WorkSpace.
type RebuildRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebuildRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebuildRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebuildRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebuildRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RebuildRequest) SetWorkspaceId(v string) *RebuildRequest {
	s.WorkspaceId = &v
	return s
}

type RebuildWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpace to rebuild. You can specify a single WorkSpace.
	//
	// RebuildWorkspaceRequests is a required field
	RebuildWorkspaceRequests []*RebuildRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebuildWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebuildWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebuildWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebuildWorkspacesInput"}
	if s.RebuildWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("RebuildWorkspaceRequests"))
	}
	if s.RebuildWorkspaceRequests != nil && len(s.RebuildWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RebuildWorkspaceRequests", 1))
	}
	if s.RebuildWorkspaceRequests != nil {
		for i, v := range s.RebuildWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RebuildWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRebuildWorkspaceRequests sets the RebuildWorkspaceRequests field's value.
func (s *RebuildWorkspacesInput) SetRebuildWorkspaceRequests(v []*RebuildRequest) *RebuildWorkspacesInput {
	s.RebuildWorkspaceRequests = v
	return s
}

type RebuildWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpace that could not be rebuilt.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebuildWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebuildWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *RebuildWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *RebuildWorkspacesOutput {
	s.FailedRequests = v
	return s
}

type RegisterWorkspaceDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The active directory config of the directory.
	ActiveDirectoryConfig *ActiveDirectoryConfig `type:"structure"`

	// The identifier of the directory. You cannot register a directory if it does
	// not have a status of Active. If the directory does not have a status of Active,
	// you will receive an InvalidResourceStateException error. If you have already
	// registered the maximum number of directories that you can register with Amazon
	// WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister
	// directories that you are not using for WorkSpaces, and try again.
	DirectoryId *string `min:"10" type:"string"`

	// Indicates whether self-service capabilities are enabled or disabled.
	EnableSelfService *bool `type:"boolean"`

	// Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled
	// this parameter and WorkDocs is not available in the Region, you will receive
	// an OperationNotSupportedException error. Set EnableWorkDocs to disabled,
	// and try again.
	EnableWorkDocs *bool `type:"boolean"`

	// The identifiers of the subnets for your virtual private cloud (VPC). Make
	// sure that the subnets are in supported Availability Zones. The subnets must
	// also be in separate Availability Zones. If these conditions are not met,
	// you will receive an OperationNotSupportedException error.
	SubnetIds []*string `type:"list"`

	// The tags associated with the directory.
	Tags []*Tag `type:"list"`

	// Indicates whether your WorkSpace directory is dedicated or shared. To use
	// Bring Your Own License (BYOL) images, this value must be set to DEDICATED
	// and your Amazon Web Services account must be enabled for BYOL. If your account
	// has not been enabled for BYOL, you will receive an InvalidParameterValuesException
	// error. For more information about BYOL images, see Bring Your Own Windows
	// Desktop Images (https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
	Tenancy *string `type:"string" enum:"Tenancy"`

	// The type of identity management the user is using.
	UserIdentityType *string `type:"string" enum:"UserIdentityType"`

	// Description of the directory to register.
	WorkspaceDirectoryDescription *string `type:"string"`

	// The name of the directory to register.
	WorkspaceDirectoryName *string `type:"string"`

	// Indicates whether the directory's WorkSpace type is personal or pools.
	WorkspaceType *string `type:"string" enum:"WorkspaceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterWorkspaceDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterWorkspaceDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterWorkspaceDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterWorkspaceDirectoryInput"}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.ActiveDirectoryConfig != nil {
		if err := s.ActiveDirectoryConfig.Validate(); err != nil {
			invalidParams.AddNested("ActiveDirectoryConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActiveDirectoryConfig sets the ActiveDirectoryConfig field's value.
func (s *RegisterWorkspaceDirectoryInput) SetActiveDirectoryConfig(v *ActiveDirectoryConfig) *RegisterWorkspaceDirectoryInput {
	s.ActiveDirectoryConfig = v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *RegisterWorkspaceDirectoryInput) SetDirectoryId(v string) *RegisterWorkspaceDirectoryInput {
	s.DirectoryId = &v
	return s
}

// SetEnableSelfService sets the EnableSelfService field's value.
func (s *RegisterWorkspaceDirectoryInput) SetEnableSelfService(v bool) *RegisterWorkspaceDirectoryInput {
	s.EnableSelfService = &v
	return s
}

// SetEnableWorkDocs sets the EnableWorkDocs field's value.
func (s *RegisterWorkspaceDirectoryInput) SetEnableWorkDocs(v bool) *RegisterWorkspaceDirectoryInput {
	s.EnableWorkDocs = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *RegisterWorkspaceDirectoryInput) SetSubnetIds(v []*string) *RegisterWorkspaceDirectoryInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *RegisterWorkspaceDirectoryInput) SetTags(v []*Tag) *RegisterWorkspaceDirectoryInput {
	s.Tags = v
	return s
}

// SetTenancy sets the Tenancy field's value.
func (s *RegisterWorkspaceDirectoryInput) SetTenancy(v string) *RegisterWorkspaceDirectoryInput {
	s.Tenancy = &v
	return s
}

// SetUserIdentityType sets the UserIdentityType field's value.
func (s *RegisterWorkspaceDirectoryInput) SetUserIdentityType(v string) *RegisterWorkspaceDirectoryInput {
	s.UserIdentityType = &v
	return s
}

// SetWorkspaceDirectoryDescription sets the WorkspaceDirectoryDescription field's value.
func (s *RegisterWorkspaceDirectoryInput) SetWorkspaceDirectoryDescription(v string) *RegisterWorkspaceDirectoryInput {
	s.WorkspaceDirectoryDescription = &v
	return s
}

// SetWorkspaceDirectoryName sets the WorkspaceDirectoryName field's value.
func (s *RegisterWorkspaceDirectoryInput) SetWorkspaceDirectoryName(v string) *RegisterWorkspaceDirectoryInput {
	s.WorkspaceDirectoryName = &v
	return s
}

// SetWorkspaceType sets the WorkspaceType field's value.
func (s *RegisterWorkspaceDirectoryInput) SetWorkspaceType(v string) *RegisterWorkspaceDirectoryInput {
	s.WorkspaceType = &v
	return s
}

type RegisterWorkspaceDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	DirectoryId *string `min:"10" type:"string"`

	// The registration status of the WorkSpace directory.
	State *string `type:"string" enum:"WorkspaceDirectoryState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterWorkspaceDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterWorkspaceDirectoryOutput) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *RegisterWorkspaceDirectoryOutput) SetDirectoryId(v string) *RegisterWorkspaceDirectoryOutput {
	s.DirectoryId = &v
	return s
}

// SetState sets the State field's value.
func (s *RegisterWorkspaceDirectoryOutput) SetState(v string) *RegisterWorkspaceDirectoryOutput {
	s.State = &v
	return s
}

type RejectAccountLinkInvitationInput struct {
	_ struct{} `type:"structure"`

	// The client token of the account link invitation to reject.
	ClientToken *string `type:"string"`

	// The identifier of the account link
	//
	// LinkId is a required field
	LinkId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectAccountLinkInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectAccountLinkInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectAccountLinkInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectAccountLinkInvitationInput"}
	if s.LinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("LinkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *RejectAccountLinkInvitationInput) SetClientToken(v string) *RejectAccountLinkInvitationInput {
	s.ClientToken = &v
	return s
}

// SetLinkId sets the LinkId field's value.
func (s *RejectAccountLinkInvitationInput) SetLinkId(v string) *RejectAccountLinkInvitationInput {
	s.LinkId = &v
	return s
}

type RejectAccountLinkInvitationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the account link.
	AccountLink *AccountLink `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectAccountLinkInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectAccountLinkInvitationOutput) GoString() string {
	return s.String()
}

// SetAccountLink sets the AccountLink field's value.
func (s *RejectAccountLinkInvitationOutput) SetAccountLink(v *AccountLink) *RejectAccountLinkInvitationOutput {
	s.AccountLink = v
	return s
}

// Describes the related WorkSpace. The related WorkSpace could be a standby
// WorkSpace or primary WorkSpace related to the specified WorkSpace.
type RelatedWorkspaceProperties struct {
	_ struct{} `type:"structure"`

	// The Region of the related WorkSpace.
	Region *string `min:"1" type:"string"`

	// Indicates the state of the WorkSpace.
	State *string `type:"string" enum:"WorkspaceState"`

	// Indicates the type of WorkSpace.
	Type *string `type:"string" enum:"StandbyWorkspaceRelationshipType"`

	// The identifier of the related WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedWorkspaceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelatedWorkspaceProperties) GoString() string {
	return s.String()
}

// SetRegion sets the Region field's value.
func (s *RelatedWorkspaceProperties) SetRegion(v string) *RelatedWorkspaceProperties {
	s.Region = &v
	return s
}

// SetState sets the State field's value.
func (s *RelatedWorkspaceProperties) SetState(v string) *RelatedWorkspaceProperties {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *RelatedWorkspaceProperties) SetType(v string) *RelatedWorkspaceProperties {
	s.Type = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RelatedWorkspaceProperties) SetWorkspaceId(v string) *RelatedWorkspaceProperties {
	s.WorkspaceId = &v
	return s
}

// The specified resource already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource is associated with a directory.
type ResourceAssociatedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAssociatedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAssociatedException) GoString() string {
	return s.String()
}

func newErrorResourceAssociatedException(v protocol.ResponseMetadata) error {
	return &ResourceAssociatedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAssociatedException) Code() string {
	return "ResourceAssociatedException"
}

// Message returns the exception's message.
func (s *ResourceAssociatedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAssociatedException) OrigErr() error {
	return nil
}

func (s *ResourceAssociatedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAssociatedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAssociatedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource could not be created.
type ResourceCreationFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCreationFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCreationFailedException) GoString() string {
	return s.String()
}

func newErrorResourceCreationFailedException(v protocol.ResponseMetadata) error {
	return &ResourceCreationFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceCreationFailedException) Code() string {
	return "ResourceCreationFailedException"
}

// Message returns the exception's message.
func (s *ResourceCreationFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceCreationFailedException) OrigErr() error {
	return nil
}

func (s *ResourceCreationFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceCreationFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceCreationFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource is currently in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource that is in use.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your resource limits have been exceeded.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception error message.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The resource could not be found.
	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource that could not be found.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource is not available.
type ResourceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception error message.
	Message_ *string `locationName:"message" type:"string"`

	// The identifier of the resource that is not available.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) GoString() string {
	return s.String()
}

func newErrorResourceUnavailableException(v protocol.ResponseMetadata) error {
	return &ResourceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceUnavailableException) Code() string {
	return "ResourceUnavailableException"
}

// Message returns the exception's message.
func (s *ResourceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceUnavailableException) OrigErr() error {
	return nil
}

func (s *ResourceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RestoreWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreWorkspaceInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RestoreWorkspaceInput) SetWorkspaceId(v string) *RestoreWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

type RestoreWorkspaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreWorkspaceOutput) GoString() string {
	return s.String()
}

type RevokeIpRulesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// The rules to remove from the group.
	//
	// UserRules is a required field
	UserRules []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeIpRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeIpRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeIpRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeIpRulesInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.UserRules == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *RevokeIpRulesInput) SetGroupId(v string) *RevokeIpRulesInput {
	s.GroupId = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *RevokeIpRulesInput) SetUserRules(v []*string) *RevokeIpRulesInput {
	s.UserRules = v
	return s
}

type RevokeIpRulesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeIpRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeIpRulesOutput) GoString() string {
	return s.String()
}

// Describes the root volume for a WorkSpace bundle.
type RootStorage struct {
	_ struct{} `type:"structure"`

	// The size of the root volume.
	//
	// Capacity is a required field
	Capacity *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RootStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RootStorage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RootStorage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RootStorage"}
	if s.Capacity == nil {
		invalidParams.Add(request.NewErrParamRequired("Capacity"))
	}
	if s.Capacity != nil && len(*s.Capacity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Capacity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacity sets the Capacity field's value.
func (s *RootStorage) SetCapacity(v string) *RootStorage {
	s.Capacity = &v
	return s
}

// Describes the enablement status, user access URL, and relay state parameter
// name that are used for configuring federation with an SAML 2.0 identity provider.
type SamlProperties struct {
	_ struct{} `type:"structure"`

	// The relay state parameter name supported by the SAML 2.0 identity provider
	// (IdP). When the end user is redirected to the user access URL from the WorkSpaces
	// client application, this relay state parameter name is appended as a query
	// parameter to the URL along with the relay state endpoint to return the user
	// to the client application session.
	//
	// To use SAML 2.0 authentication with WorkSpaces, the IdP must support IdP-initiated
	// deep linking for the relay state URL. Consult your IdP documentation for
	// more information.
	RelayStateParameterName *string `min:"1" type:"string"`

	// Indicates the status of SAML 2.0 authentication. These statuses include the
	// following.
	//
	//    * If the setting is DISABLED, end users will be directed to login with
	//    their directory credentials.
	//
	//    * If the setting is ENABLED, end users will be directed to login via the
	//    user access URL. Users attempting to connect to WorkSpaces from a client
	//    application that does not support SAML 2.0 authentication will not be
	//    able to connect.
	//
	//    * If the setting is ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK, end users will
	//    be directed to login via the user access URL on supported client applications,
	//    but will not prevent clients that do not support SAML 2.0 authentication
	//    from connecting as if SAML 2.0 authentication was disabled.
	Status *string `type:"string" enum:"SamlStatusEnum"`

	// The SAML 2.0 identity provider (IdP) user access URL is the URL a user would
	// navigate to in their web browser in order to federate from the IdP and directly
	// access the application, without any SAML 2.0 service provider (SP) bindings.
	UserAccessUrl *string `min:"8" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SamlProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SamlProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SamlProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SamlProperties"}
	if s.RelayStateParameterName != nil && len(*s.RelayStateParameterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RelayStateParameterName", 1))
	}
	if s.UserAccessUrl != nil && len(*s.UserAccessUrl) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("UserAccessUrl", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelayStateParameterName sets the RelayStateParameterName field's value.
func (s *SamlProperties) SetRelayStateParameterName(v string) *SamlProperties {
	s.RelayStateParameterName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SamlProperties) SetStatus(v string) *SamlProperties {
	s.Status = &v
	return s
}

// SetUserAccessUrl sets the UserAccessUrl field's value.
func (s *SamlProperties) SetUserAccessUrl(v string) *SamlProperties {
	s.UserAccessUrl = &v
	return s
}

// Describes the self-service permissions for a directory. For more information,
// see Enable Self-Service WorkSpace Management Capabilities for Your Users
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html).
type SelfservicePermissions struct {
	_ struct{} `type:"structure"`

	// Specifies whether users can change the compute type (bundle) for their WorkSpace.
	ChangeComputeType *string `type:"string" enum:"ReconnectEnum"`

	// Specifies whether users can increase the volume size of the drives on their
	// WorkSpace.
	IncreaseVolumeSize *string `type:"string" enum:"ReconnectEnum"`

	// Specifies whether users can rebuild the operating system of a WorkSpace to
	// its original state.
	RebuildWorkspace *string `type:"string" enum:"ReconnectEnum"`

	// Specifies whether users can restart their WorkSpace.
	RestartWorkspace *string `type:"string" enum:"ReconnectEnum"`

	// Specifies whether users can switch the running mode of their WorkSpace.
	SwitchRunningMode *string `type:"string" enum:"ReconnectEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelfservicePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelfservicePermissions) GoString() string {
	return s.String()
}

// SetChangeComputeType sets the ChangeComputeType field's value.
func (s *SelfservicePermissions) SetChangeComputeType(v string) *SelfservicePermissions {
	s.ChangeComputeType = &v
	return s
}

// SetIncreaseVolumeSize sets the IncreaseVolumeSize field's value.
func (s *SelfservicePermissions) SetIncreaseVolumeSize(v string) *SelfservicePermissions {
	s.IncreaseVolumeSize = &v
	return s
}

// SetRebuildWorkspace sets the RebuildWorkspace field's value.
func (s *SelfservicePermissions) SetRebuildWorkspace(v string) *SelfservicePermissions {
	s.RebuildWorkspace = &v
	return s
}

// SetRestartWorkspace sets the RestartWorkspace field's value.
func (s *SelfservicePermissions) SetRestartWorkspace(v string) *SelfservicePermissions {
	s.RestartWorkspace = &v
	return s
}

// SetSwitchRunningMode sets the SwitchRunningMode field's value.
func (s *SelfservicePermissions) SetSwitchRunningMode(v string) *SelfservicePermissions {
	s.SwitchRunningMode = &v
	return s
}

// Describes a snapshot.
type Snapshot struct {
	_ struct{} `type:"structure"`

	// The time when the snapshot was created.
	SnapshotTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Snapshot) GoString() string {
	return s.String()
}

// SetSnapshotTime sets the SnapshotTime field's value.
func (s *Snapshot) SetSnapshotTime(v time.Time) *Snapshot {
	s.SnapshotTime = &v
	return s
}

// Describes a standby WorkSpace.
type StandbyWorkspace struct {
	_ struct{} `type:"structure"`

	// Indicates whether data replication is enabled, and if enabled, the type of
	// data replication.
	DataReplication *string `type:"string" enum:"DataReplication"`

	// The identifier of the directory for the standby WorkSpace.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`

	// The identifier of the standby WorkSpace.
	//
	// PrimaryWorkspaceId is a required field
	PrimaryWorkspaceId *string `type:"string" required:"true"`

	// The tags associated with the standby WorkSpace.
	Tags []*Tag `type:"list"`

	// The volume encryption key of the standby WorkSpace.
	VolumeEncryptionKey *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StandbyWorkspace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StandbyWorkspace) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StandbyWorkspace) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StandbyWorkspace"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.PrimaryWorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryWorkspaceId"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataReplication sets the DataReplication field's value.
func (s *StandbyWorkspace) SetDataReplication(v string) *StandbyWorkspace {
	s.DataReplication = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *StandbyWorkspace) SetDirectoryId(v string) *StandbyWorkspace {
	s.DirectoryId = &v
	return s
}

// SetPrimaryWorkspaceId sets the PrimaryWorkspaceId field's value.
func (s *StandbyWorkspace) SetPrimaryWorkspaceId(v string) *StandbyWorkspace {
	s.PrimaryWorkspaceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StandbyWorkspace) SetTags(v []*Tag) *StandbyWorkspace {
	s.Tags = v
	return s
}

// SetVolumeEncryptionKey sets the VolumeEncryptionKey field's value.
func (s *StandbyWorkspace) SetVolumeEncryptionKey(v string) *StandbyWorkspace {
	s.VolumeEncryptionKey = &v
	return s
}

// Describes the properties of the related standby WorkSpaces.
type StandbyWorkspacesProperties struct {
	_ struct{} `type:"structure"`

	// Indicates whether data replication is enabled, and if enabled, the type of
	// data replication.
	DataReplication *string `type:"string" enum:"DataReplication"`

	// The date and time at which the last successful snapshot was taken of the
	// primary WorkSpace used for replicating data.
	RecoverySnapshotTime *time.Time `type:"timestamp"`

	// The identifier of the standby WorkSpace
	StandbyWorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StandbyWorkspacesProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StandbyWorkspacesProperties) GoString() string {
	return s.String()
}

// SetDataReplication sets the DataReplication field's value.
func (s *StandbyWorkspacesProperties) SetDataReplication(v string) *StandbyWorkspacesProperties {
	s.DataReplication = &v
	return s
}

// SetRecoverySnapshotTime sets the RecoverySnapshotTime field's value.
func (s *StandbyWorkspacesProperties) SetRecoverySnapshotTime(v time.Time) *StandbyWorkspacesProperties {
	s.RecoverySnapshotTime = &v
	return s
}

// SetStandbyWorkspaceId sets the StandbyWorkspaceId field's value.
func (s *StandbyWorkspacesProperties) SetStandbyWorkspaceId(v string) *StandbyWorkspacesProperties {
	s.StandbyWorkspaceId = &v
	return s
}

// Information used to start a WorkSpace.
type StartRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRequest) GoString() string {
	return s.String()
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *StartRequest) SetWorkspaceId(v string) *StartRequest {
	s.WorkspaceId = &v
	return s
}

type StartWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to start. You can specify up to 25 WorkSpaces.
	//
	// StartWorkspaceRequests is a required field
	StartWorkspaceRequests []*StartRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartWorkspacesInput"}
	if s.StartWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StartWorkspaceRequests"))
	}
	if s.StartWorkspaceRequests != nil && len(s.StartWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartWorkspaceRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStartWorkspaceRequests sets the StartWorkspaceRequests field's value.
func (s *StartWorkspacesInput) SetStartWorkspaceRequests(v []*StartRequest) *StartWorkspacesInput {
	s.StartWorkspaceRequests = v
	return s
}

type StartWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be started.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *StartWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *StartWorkspacesOutput {
	s.FailedRequests = v
	return s
}

type StartWorkspacesPoolInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the pool.
	//
	// PoolId is a required field
	PoolId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkspacesPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkspacesPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartWorkspacesPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartWorkspacesPoolInput"}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPoolId sets the PoolId field's value.
func (s *StartWorkspacesPoolInput) SetPoolId(v string) *StartWorkspacesPoolInput {
	s.PoolId = &v
	return s
}

type StartWorkspacesPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkspacesPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkspacesPoolOutput) GoString() string {
	return s.String()
}

// Describes the information used to stop a WorkSpace.
type StopRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRequest) GoString() string {
	return s.String()
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *StopRequest) SetWorkspaceId(v string) *StopRequest {
	s.WorkspaceId = &v
	return s
}

type StopWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
	//
	// StopWorkspaceRequests is a required field
	StopWorkspaceRequests []*StopRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopWorkspacesInput"}
	if s.StopWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StopWorkspaceRequests"))
	}
	if s.StopWorkspaceRequests != nil && len(s.StopWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StopWorkspaceRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStopWorkspaceRequests sets the StopWorkspaceRequests field's value.
func (s *StopWorkspacesInput) SetStopWorkspaceRequests(v []*StopRequest) *StopWorkspacesInput {
	s.StopWorkspaceRequests = v
	return s
}

type StopWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be stopped.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *StopWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *StopWorkspacesOutput {
	s.FailedRequests = v
	return s
}

type StopWorkspacesPoolInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the pool.
	//
	// PoolId is a required field
	PoolId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkspacesPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkspacesPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopWorkspacesPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopWorkspacesPoolInput"}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPoolId sets the PoolId field's value.
func (s *StopWorkspacesPoolInput) SetPoolId(v string) *StopWorkspacesPoolInput {
	s.PoolId = &v
	return s
}

type StopWorkspacesPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkspacesPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkspacesPoolOutput) GoString() string {
	return s.String()
}

// Describes the storage connector.
type StorageConnector struct {
	_ struct{} `type:"structure"`

	// The type of connector used to save user files.
	//
	// ConnectorType is a required field
	ConnectorType *string `type:"string" required:"true" enum:"StorageConnectorTypeEnum"`

	// Indicates if the storage connetor is enabled or disabled.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"StorageConnectorStatusEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConnector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConnector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageConnector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageConnector"}
	if s.ConnectorType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorType"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorType sets the ConnectorType field's value.
func (s *StorageConnector) SetConnectorType(v string) *StorageConnector {
	s.ConnectorType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StorageConnector) SetStatus(v string) *StorageConnector {
	s.Status = &v
	return s
}

// Describes the streaming properties.
type StreamingProperties struct {
	_ struct{} `type:"structure"`

	// Indicates the storage connector used
	StorageConnectors []*StorageConnector `min:"1" type:"list"`

	// Indicates the type of preferred protocol for the streaming experience.
	StreamingExperiencePreferredProtocol *string `type:"string" enum:"StreamingExperiencePreferredProtocolEnum"`

	// Indicates the permission settings asscoiated with the user.
	UserSettings []*UserSetting `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamingProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamingProperties"}
	if s.StorageConnectors != nil && len(s.StorageConnectors) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StorageConnectors", 1))
	}
	if s.UserSettings != nil && len(s.UserSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserSettings", 1))
	}
	if s.StorageConnectors != nil {
		for i, v := range s.StorageConnectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StorageConnectors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UserSettings != nil {
		for i, v := range s.UserSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStorageConnectors sets the StorageConnectors field's value.
func (s *StreamingProperties) SetStorageConnectors(v []*StorageConnector) *StreamingProperties {
	s.StorageConnectors = v
	return s
}

// SetStreamingExperiencePreferredProtocol sets the StreamingExperiencePreferredProtocol field's value.
func (s *StreamingProperties) SetStreamingExperiencePreferredProtocol(v string) *StreamingProperties {
	s.StreamingExperiencePreferredProtocol = &v
	return s
}

// SetUserSettings sets the UserSettings field's value.
func (s *StreamingProperties) SetUserSettings(v []*UserSetting) *StreamingProperties {
	s.UserSettings = v
	return s
}

// Describes a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Describes the information used to terminate a WorkSpace.
type TerminateRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *TerminateRequest) SetWorkspaceId(v string) *TerminateRequest {
	s.WorkspaceId = &v
	return s
}

type TerminateWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
	//
	// TerminateWorkspaceRequests is a required field
	TerminateWorkspaceRequests []*TerminateRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateWorkspacesInput"}
	if s.TerminateWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminateWorkspaceRequests"))
	}
	if s.TerminateWorkspaceRequests != nil && len(s.TerminateWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TerminateWorkspaceRequests", 1))
	}
	if s.TerminateWorkspaceRequests != nil {
		for i, v := range s.TerminateWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TerminateWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTerminateWorkspaceRequests sets the TerminateWorkspaceRequests field's value.
func (s *TerminateWorkspacesInput) SetTerminateWorkspaceRequests(v []*TerminateRequest) *TerminateWorkspacesInput {
	s.TerminateWorkspaceRequests = v
	return s
}

type TerminateWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be terminated.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *TerminateWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *TerminateWorkspacesOutput {
	s.FailedRequests = v
	return s
}

type TerminateWorkspacesPoolInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the pool.
	//
	// PoolId is a required field
	PoolId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateWorkspacesPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateWorkspacesPoolInput"}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPoolId sets the PoolId field's value.
func (s *TerminateWorkspacesPoolInput) SetPoolId(v string) *TerminateWorkspacesPoolInput {
	s.PoolId = &v
	return s
}

type TerminateWorkspacesPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesPoolOutput) GoString() string {
	return s.String()
}

type TerminateWorkspacesPoolSessionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the pool session.
	//
	// SessionId is a required field
	SessionId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesPoolSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesPoolSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateWorkspacesPoolSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateWorkspacesPoolSessionInput"}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSessionId sets the SessionId field's value.
func (s *TerminateWorkspacesPoolSessionInput) SetSessionId(v string) *TerminateWorkspacesPoolSessionInput {
	s.SessionId = &v
	return s
}

type TerminateWorkspacesPoolSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesPoolSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesPoolSessionOutput) GoString() string {
	return s.String()
}

// Describes the timeout settings for a pool of WorkSpaces.
type TimeoutSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the amount of time, in seconds, that a streaming session remains
	// active after users disconnect. If users try to reconnect to the streaming
	// session after a disconnection or network interruption within the time set,
	// they are connected to their previous session. Otherwise, they are connected
	// to a new session with a new streaming instance.
	DisconnectTimeoutInSeconds *int64 `min:"60" type:"integer"`

	// The amount of time in seconds a connection will stay active while idle.
	IdleDisconnectTimeoutInSeconds *int64 `type:"integer"`

	// Specifies the maximum amount of time, in seconds, that a streaming session
	// can remain active. If users are still connected to a streaming instance five
	// minutes before this limit is reached, they are prompted to save any open
	// documents before being disconnected. After this time elapses, the instance
	// is terminated and replaced by a new instance.
	MaxUserDurationInSeconds *int64 `min:"600" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeoutSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeoutSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeoutSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeoutSettings"}
	if s.DisconnectTimeoutInSeconds != nil && *s.DisconnectTimeoutInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("DisconnectTimeoutInSeconds", 60))
	}
	if s.MaxUserDurationInSeconds != nil && *s.MaxUserDurationInSeconds < 600 {
		invalidParams.Add(request.NewErrParamMinValue("MaxUserDurationInSeconds", 600))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisconnectTimeoutInSeconds sets the DisconnectTimeoutInSeconds field's value.
func (s *TimeoutSettings) SetDisconnectTimeoutInSeconds(v int64) *TimeoutSettings {
	s.DisconnectTimeoutInSeconds = &v
	return s
}

// SetIdleDisconnectTimeoutInSeconds sets the IdleDisconnectTimeoutInSeconds field's value.
func (s *TimeoutSettings) SetIdleDisconnectTimeoutInSeconds(v int64) *TimeoutSettings {
	s.IdleDisconnectTimeoutInSeconds = &v
	return s
}

// SetMaxUserDurationInSeconds sets the MaxUserDurationInSeconds field's value.
func (s *TimeoutSettings) SetMaxUserDurationInSeconds(v int64) *TimeoutSettings {
	s.MaxUserDurationInSeconds = &v
	return s
}

// The configuration of this network is not supported for this operation, or
// your network configuration conflicts with the Amazon WorkSpaces management
// network IP range. For more information, see Configure a VPC for Amazon WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html).
type UnsupportedNetworkConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedNetworkConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedNetworkConfigurationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedNetworkConfigurationException(v protocol.ResponseMetadata) error {
	return &UnsupportedNetworkConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedNetworkConfigurationException) Code() string {
	return "UnsupportedNetworkConfigurationException"
}

// Message returns the exception's message.
func (s *UnsupportedNetworkConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedNetworkConfigurationException) OrigErr() error {
	return nil
}

func (s *UnsupportedNetworkConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedNetworkConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedNetworkConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration of this WorkSpace is not supported for this operation.
// For more information, see Required Configuration and Service Components for
// WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html).
type UnsupportedWorkspaceConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedWorkspaceConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedWorkspaceConfigurationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedWorkspaceConfigurationException(v protocol.ResponseMetadata) error {
	return &UnsupportedWorkspaceConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedWorkspaceConfigurationException) Code() string {
	return "UnsupportedWorkspaceConfigurationException"
}

// Message returns the exception's message.
func (s *UnsupportedWorkspaceConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedWorkspaceConfigurationException) OrigErr() error {
	return nil
}

func (s *UnsupportedWorkspaceConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedWorkspaceConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedWorkspaceConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateConnectClientAddInInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the client add-in to update.
	//
	// AddInId is a required field
	AddInId *string `min:"36" type:"string" required:"true"`

	// The name of the client add-in.
	Name *string `min:"1" type:"string"`

	// The directory identifier for which the client add-in is configured.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The endpoint URL of the Amazon Connect client add-in.
	URL *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectClientAddInInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectClientAddInInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectClientAddInInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectClientAddInInput"}
	if s.AddInId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddInId"))
	}
	if s.AddInId != nil && len(*s.AddInId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AddInId", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.URL != nil && len(*s.URL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("URL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddInId sets the AddInId field's value.
func (s *UpdateConnectClientAddInInput) SetAddInId(v string) *UpdateConnectClientAddInInput {
	s.AddInId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateConnectClientAddInInput) SetName(v string) *UpdateConnectClientAddInInput {
	s.Name = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateConnectClientAddInInput) SetResourceId(v string) *UpdateConnectClientAddInInput {
	s.ResourceId = &v
	return s
}

// SetURL sets the URL field's value.
func (s *UpdateConnectClientAddInInput) SetURL(v string) *UpdateConnectClientAddInInput {
	s.URL = &v
	return s
}

type UpdateConnectClientAddInOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectClientAddInOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectClientAddInOutput) GoString() string {
	return s.String()
}

type UpdateConnectionAliasPermissionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias that you want to update permissions
	// for.
	//
	// AliasId is a required field
	AliasId *string `min:"13" type:"string" required:"true"`

	// Indicates whether to share or unshare the connection alias with the specified
	// Amazon Web Services account.
	//
	// ConnectionAliasPermission is a required field
	ConnectionAliasPermission *ConnectionAliasPermission `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionAliasPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionAliasPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectionAliasPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectionAliasPermissionInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}
	if s.AliasId != nil && len(*s.AliasId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("AliasId", 13))
	}
	if s.ConnectionAliasPermission == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionAliasPermission"))
	}
	if s.ConnectionAliasPermission != nil {
		if err := s.ConnectionAliasPermission.Validate(); err != nil {
			invalidParams.AddNested("ConnectionAliasPermission", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *UpdateConnectionAliasPermissionInput) SetAliasId(v string) *UpdateConnectionAliasPermissionInput {
	s.AliasId = &v
	return s
}

// SetConnectionAliasPermission sets the ConnectionAliasPermission field's value.
func (s *UpdateConnectionAliasPermissionInput) SetConnectionAliasPermission(v *ConnectionAliasPermission) *UpdateConnectionAliasPermissionInput {
	s.ConnectionAliasPermission = v
	return s
}

type UpdateConnectionAliasPermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionAliasPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionAliasPermissionOutput) GoString() string {
	return s.String()
}

// Describes whether a WorkSpace image needs to be updated with the latest drivers
// and other components required by Amazon WorkSpaces.
//
// Only Windows 10 WorkSpace images can be programmatically updated at this
// time.
type UpdateResult struct {
	_ struct{} `type:"structure"`

	// A description of whether updates for the WorkSpace image are pending or available.
	Description *string `min:"1" type:"string"`

	// Indicates whether updated drivers or other components are available for the
	// specified WorkSpace image.
	UpdateAvailable *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResult) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UpdateResult) SetDescription(v string) *UpdateResult {
	s.Description = &v
	return s
}

// SetUpdateAvailable sets the UpdateAvailable field's value.
func (s *UpdateResult) SetUpdateAvailable(v bool) *UpdateResult {
	s.UpdateAvailable = &v
	return s
}

type UpdateRulesOfIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// One or more rules.
	//
	// UserRules is a required field
	UserRules []*IpRuleItem `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRulesOfIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRulesOfIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRulesOfIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRulesOfIpGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.UserRules == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *UpdateRulesOfIpGroupInput) SetGroupId(v string) *UpdateRulesOfIpGroupInput {
	s.GroupId = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *UpdateRulesOfIpGroupInput) SetUserRules(v []*IpRuleItem) *UpdateRulesOfIpGroupInput {
	s.UserRules = v
	return s
}

type UpdateRulesOfIpGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRulesOfIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRulesOfIpGroupOutput) GoString() string {
	return s.String()
}

type UpdateWorkspaceBundleInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle.
	BundleId *string `type:"string"`

	// The identifier of the image.
	ImageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceBundleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceBundleInput) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *UpdateWorkspaceBundleInput) SetBundleId(v string) *UpdateWorkspaceBundleInput {
	s.BundleId = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *UpdateWorkspaceBundleInput) SetImageId(v string) *UpdateWorkspaceBundleInput {
	s.ImageId = &v
	return s
}

type UpdateWorkspaceBundleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceBundleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceBundleOutput) GoString() string {
	return s.String()
}

type UpdateWorkspaceImagePermissionInput struct {
	_ struct{} `type:"structure"`

	// The permission to copy the image. This permission can be revoked only after
	// an image has been shared.
	//
	// AllowCopyImage is a required field
	AllowCopyImage *bool `type:"boolean" required:"true"`

	// The identifier of the image.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`

	// The identifier of the Amazon Web Services account to share or unshare the
	// image with.
	//
	// Before sharing the image, confirm that you are sharing to the correct Amazon
	// Web Services account ID.
	//
	// SharedAccountId is a required field
	SharedAccountId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceImagePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceImagePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkspaceImagePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkspaceImagePermissionInput"}
	if s.AllowCopyImage == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowCopyImage"))
	}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}
	if s.SharedAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowCopyImage sets the AllowCopyImage field's value.
func (s *UpdateWorkspaceImagePermissionInput) SetAllowCopyImage(v bool) *UpdateWorkspaceImagePermissionInput {
	s.AllowCopyImage = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *UpdateWorkspaceImagePermissionInput) SetImageId(v string) *UpdateWorkspaceImagePermissionInput {
	s.ImageId = &v
	return s
}

// SetSharedAccountId sets the SharedAccountId field's value.
func (s *UpdateWorkspaceImagePermissionInput) SetSharedAccountId(v string) *UpdateWorkspaceImagePermissionInput {
	s.SharedAccountId = &v
	return s
}

type UpdateWorkspaceImagePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceImagePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceImagePermissionOutput) GoString() string {
	return s.String()
}

type UpdateWorkspacesPoolInput struct {
	_ struct{} `type:"structure"`

	// The persistent application settings for users in the pool.
	ApplicationSettings *ApplicationSettingsRequest `type:"structure"`

	// The identifier of the bundle.
	BundleId *string `type:"string"`

	// The desired capacity for the pool.
	Capacity *Capacity `type:"structure"`

	// Describes the specified pool to update.
	Description *string `min:"1" type:"string"`

	// The identifier of the directory.
	DirectoryId *string `min:"10" type:"string"`

	// The identifier of the specified pool to update.
	//
	// PoolId is a required field
	PoolId *string `type:"string" required:"true"`

	// Indicates the timeout settings of the specified pool.
	TimeoutSettings *TimeoutSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspacesPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspacesPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkspacesPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkspacesPoolInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}
	if s.ApplicationSettings != nil {
		if err := s.ApplicationSettings.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Capacity != nil {
		if err := s.Capacity.Validate(); err != nil {
			invalidParams.AddNested("Capacity", err.(request.ErrInvalidParams))
		}
	}
	if s.TimeoutSettings != nil {
		if err := s.TimeoutSettings.Validate(); err != nil {
			invalidParams.AddNested("TimeoutSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationSettings sets the ApplicationSettings field's value.
func (s *UpdateWorkspacesPoolInput) SetApplicationSettings(v *ApplicationSettingsRequest) *UpdateWorkspacesPoolInput {
	s.ApplicationSettings = v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *UpdateWorkspacesPoolInput) SetBundleId(v string) *UpdateWorkspacesPoolInput {
	s.BundleId = &v
	return s
}

// SetCapacity sets the Capacity field's value.
func (s *UpdateWorkspacesPoolInput) SetCapacity(v *Capacity) *UpdateWorkspacesPoolInput {
	s.Capacity = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkspacesPoolInput) SetDescription(v string) *UpdateWorkspacesPoolInput {
	s.Description = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *UpdateWorkspacesPoolInput) SetDirectoryId(v string) *UpdateWorkspacesPoolInput {
	s.DirectoryId = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *UpdateWorkspacesPoolInput) SetPoolId(v string) *UpdateWorkspacesPoolInput {
	s.PoolId = &v
	return s
}

// SetTimeoutSettings sets the TimeoutSettings field's value.
func (s *UpdateWorkspacesPoolInput) SetTimeoutSettings(v *TimeoutSettings) *UpdateWorkspacesPoolInput {
	s.TimeoutSettings = v
	return s
}

type UpdateWorkspacesPoolOutput struct {
	_ struct{} `type:"structure"`

	// Describes the specified pool.
	WorkspacesPool *WorkspacesPool `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspacesPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspacesPoolOutput) GoString() string {
	return s.String()
}

// SetWorkspacesPool sets the WorkspacesPool field's value.
func (s *UpdateWorkspacesPoolOutput) SetWorkspacesPool(v *WorkspacesPool) *UpdateWorkspacesPoolOutput {
	s.WorkspacesPool = v
	return s
}

// Information about the user's permission settings.
type UserSetting struct {
	_ struct{} `type:"structure"`

	// Indicates the type of action.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"UserSettingActionEnum"`

	// Indicates the maximum character length for the specified user setting.
	MaximumLength *int64 `type:"integer"`

	// Indicates if the setting is enabled or disabled.
	//
	// Permission is a required field
	Permission *string `type:"string" required:"true" enum:"UserSettingPermissionEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserSetting"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Permission == nil {
		invalidParams.Add(request.NewErrParamRequired("Permission"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UserSetting) SetAction(v string) *UserSetting {
	s.Action = &v
	return s
}

// SetMaximumLength sets the MaximumLength field's value.
func (s *UserSetting) SetMaximumLength(v int64) *UserSetting {
	s.MaximumLength = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *UserSetting) SetPermission(v string) *UserSetting {
	s.Permission = &v
	return s
}

// Describes the user volume for a WorkSpace bundle.
type UserStorage struct {
	_ struct{} `type:"structure"`

	// The size of the user volume.
	//
	// Capacity is a required field
	Capacity *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserStorage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserStorage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserStorage"}
	if s.Capacity == nil {
		invalidParams.Add(request.NewErrParamRequired("Capacity"))
	}
	if s.Capacity != nil && len(*s.Capacity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Capacity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacity sets the Capacity field's value.
func (s *UserStorage) SetCapacity(v string) *UserStorage {
	s.Capacity = &v
	return s
}

// You either haven't provided a TargetAccountId or are using the same value
// for TargetAccountId and SourceAccountId.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the WorkSpace application.
type WorkSpaceApplication struct {
	_ struct{} `type:"structure"`

	// The identifier of the application.
	ApplicationId *string `type:"string"`

	// The time the application is created.
	Created *time.Time `type:"timestamp"`

	// The description of the WorkSpace application.
	Description *string `type:"string"`

	// The license availability for the applications.
	LicenseType *string `type:"string" enum:"WorkSpaceApplicationLicenseType"`

	// The name of the WorkSpace application.
	Name *string `min:"1" type:"string"`

	// The owner of the WorkSpace application.
	Owner *string `type:"string"`

	// The status of WorkSpace application.
	State *string `type:"string" enum:"WorkSpaceApplicationState"`

	// The supported compute types of the WorkSpace application.
	SupportedComputeTypeNames []*string `type:"list" enum:"Compute"`

	// The supported operating systems of the WorkSpace application.
	SupportedOperatingSystemNames []*string `type:"list" enum:"OperatingSystemName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkSpaceApplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkSpaceApplication) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *WorkSpaceApplication) SetApplicationId(v string) *WorkSpaceApplication {
	s.ApplicationId = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *WorkSpaceApplication) SetCreated(v time.Time) *WorkSpaceApplication {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkSpaceApplication) SetDescription(v string) *WorkSpaceApplication {
	s.Description = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *WorkSpaceApplication) SetLicenseType(v string) *WorkSpaceApplication {
	s.LicenseType = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkSpaceApplication) SetName(v string) *WorkSpaceApplication {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *WorkSpaceApplication) SetOwner(v string) *WorkSpaceApplication {
	s.Owner = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkSpaceApplication) SetState(v string) *WorkSpaceApplication {
	s.State = &v
	return s
}

// SetSupportedComputeTypeNames sets the SupportedComputeTypeNames field's value.
func (s *WorkSpaceApplication) SetSupportedComputeTypeNames(v []*string) *WorkSpaceApplication {
	s.SupportedComputeTypeNames = v
	return s
}

// SetSupportedOperatingSystemNames sets the SupportedOperatingSystemNames field's value.
func (s *WorkSpaceApplication) SetSupportedOperatingSystemNames(v []*string) *WorkSpaceApplication {
	s.SupportedOperatingSystemNames = v
	return s
}

// Describes the WorkSpace application deployment.
type WorkSpaceApplicationDeployment struct {
	_ struct{} `type:"structure"`

	// The associations between the applications and the associated resources.
	Associations []*WorkspaceResourceAssociation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkSpaceApplicationDeployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkSpaceApplicationDeployment) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *WorkSpaceApplicationDeployment) SetAssociations(v []*WorkspaceResourceAssociation) *WorkSpaceApplicationDeployment {
	s.Associations = v
	return s
}

// Describes a WorkSpace.
type Workspace struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle used to create the WorkSpace.
	BundleId *string `type:"string"`

	// The name of the WorkSpace, as seen by the operating system. The format of
	// this name varies. For more information, see Launch a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/launch-workspaces-tutorials.html).
	ComputerName *string `type:"string"`

	// Indicates the settings of the data replication.
	DataReplicationSettings *DataReplicationSettings `type:"structure"`

	// The identifier of the Directory Service directory for the WorkSpace.
	DirectoryId *string `min:"10" type:"string"`

	// The error code that is returned if the WorkSpace cannot be created.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the WorkSpace cannot be
	// created.
	ErrorMessage *string `type:"string"`

	// The IP address of the WorkSpace.
	IpAddress *string `type:"string"`

	// The modification states of the WorkSpace.
	ModificationStates []*ModificationState `type:"list"`

	// The standby WorkSpace or primary WorkSpace related to the specified WorkSpace.
	RelatedWorkspaces []*RelatedWorkspaceProperties `type:"list"`

	// Indicates whether the data stored on the root volume is encrypted.
	RootVolumeEncryptionEnabled *bool `type:"boolean"`

	// The properties of the standby WorkSpace
	StandbyWorkspacesProperties []*StandbyWorkspacesProperties `type:"list"`

	// The operational state of the WorkSpace.
	//
	//    * PENDING – The WorkSpace is in a waiting state (for example, the WorkSpace
	//    is being created).
	//
	//    * AVAILABLE – The WorkSpace is running and has passed the health checks.
	//
	//    * IMPAIRED – Refer to UNHEALTHY state.
	//
	//    * UNHEALTHY – The WorkSpace is not responding to health checks.
	//
	//    * REBOOTING – The WorkSpace is being rebooted (restarted).
	//
	//    * STARTING – The WorkSpace is starting up and health checks are being
	//    run.
	//
	//    * REBUILDING – The WorkSpace is being rebuilt.
	//
	//    * RESTORING – The WorkSpace is being restored.
	//
	//    * MAINTENANCE – The WorkSpace is undergoing scheduled maintenance by
	//    Amazon Web Services.
	//
	//    * ADMIN_MAINTENANCE – The WorkSpace is undergoing maintenance by the
	//    WorkSpaces administrator.
	//
	//    * TERMINATING – The WorkSpace is being deleted.
	//
	//    * TERMINATED – The WorkSpace has been deleted.
	//
	//    * SUSPENDED – The WorkSpace has been suspended for image creation.
	//
	//    * UPDATING – The WorkSpace is undergoing an update.
	//
	//    * STOPPING – The WorkSpace is being stopped.
	//
	//    * STOPPED – The WorkSpace has been stopped.
	//
	//    * ERROR – The WorkSpace is an error state (for example, an error occurred
	//    during startup).
	//
	// After a WorkSpace is terminated, the TERMINATED state is returned only briefly
	// before the WorkSpace directory metadata is cleaned up, so this state is rarely
	// returned. To confirm that a WorkSpace is terminated, check for the WorkSpace
	// ID by using DescribeWorkSpaces (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html).
	// If the WorkSpace ID isn't returned, then the WorkSpace has been successfully
	// terminated.
	State *string `type:"string" enum:"WorkspaceState"`

	// The identifier of the subnet for the WorkSpace.
	SubnetId *string `min:"15" type:"string"`

	// The user for the WorkSpace.
	UserName *string `min:"1" type:"string"`

	// Indicates whether the data stored on the user volume is encrypted.
	UserVolumeEncryptionEnabled *bool `type:"boolean"`

	// The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace.
	// Amazon WorkSpaces does not support asymmetric KMS keys.
	VolumeEncryptionKey *string `type:"string"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`

	// The name of the user-decoupled WorkSpace.
	WorkspaceName *string `type:"string"`

	// The properties of the WorkSpace.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Workspace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Workspace) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *Workspace) SetBundleId(v string) *Workspace {
	s.BundleId = &v
	return s
}

// SetComputerName sets the ComputerName field's value.
func (s *Workspace) SetComputerName(v string) *Workspace {
	s.ComputerName = &v
	return s
}

// SetDataReplicationSettings sets the DataReplicationSettings field's value.
func (s *Workspace) SetDataReplicationSettings(v *DataReplicationSettings) *Workspace {
	s.DataReplicationSettings = v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *Workspace) SetDirectoryId(v string) *Workspace {
	s.DirectoryId = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Workspace) SetErrorCode(v string) *Workspace {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *Workspace) SetErrorMessage(v string) *Workspace {
	s.ErrorMessage = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *Workspace) SetIpAddress(v string) *Workspace {
	s.IpAddress = &v
	return s
}

// SetModificationStates sets the ModificationStates field's value.
func (s *Workspace) SetModificationStates(v []*ModificationState) *Workspace {
	s.ModificationStates = v
	return s
}

// SetRelatedWorkspaces sets the RelatedWorkspaces field's value.
func (s *Workspace) SetRelatedWorkspaces(v []*RelatedWorkspaceProperties) *Workspace {
	s.RelatedWorkspaces = v
	return s
}

// SetRootVolumeEncryptionEnabled sets the RootVolumeEncryptionEnabled field's value.
func (s *Workspace) SetRootVolumeEncryptionEnabled(v bool) *Workspace {
	s.RootVolumeEncryptionEnabled = &v
	return s
}

// SetStandbyWorkspacesProperties sets the StandbyWorkspacesProperties field's value.
func (s *Workspace) SetStandbyWorkspacesProperties(v []*StandbyWorkspacesProperties) *Workspace {
	s.StandbyWorkspacesProperties = v
	return s
}

// SetState sets the State field's value.
func (s *Workspace) SetState(v string) *Workspace {
	s.State = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *Workspace) SetSubnetId(v string) *Workspace {
	s.SubnetId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *Workspace) SetUserName(v string) *Workspace {
	s.UserName = &v
	return s
}

// SetUserVolumeEncryptionEnabled sets the UserVolumeEncryptionEnabled field's value.
func (s *Workspace) SetUserVolumeEncryptionEnabled(v bool) *Workspace {
	s.UserVolumeEncryptionEnabled = &v
	return s
}

// SetVolumeEncryptionKey sets the VolumeEncryptionKey field's value.
func (s *Workspace) SetVolumeEncryptionKey(v string) *Workspace {
	s.VolumeEncryptionKey = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *Workspace) SetWorkspaceId(v string) *Workspace {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceName sets the WorkspaceName field's value.
func (s *Workspace) SetWorkspaceName(v string) *Workspace {
	s.WorkspaceName = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *Workspace) SetWorkspaceProperties(v *WorkspaceProperties) *Workspace {
	s.WorkspaceProperties = v
	return s
}

// The device types and operating systems that can be used to access a WorkSpace.
// For more information, see Amazon WorkSpaces Client Network Requirements (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-network-requirements.html).
type WorkspaceAccessProperties struct {
	_ struct{} `type:"structure"`

	// Indicates whether users can use Android and Android-compatible Chrome OS
	// devices to access their WorkSpaces.
	DeviceTypeAndroid *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can use Chromebooks to access their WorkSpaces.
	DeviceTypeChromeOs *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can use iOS devices to access their WorkSpaces.
	DeviceTypeIos *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can use Linux clients to access their WorkSpaces.
	DeviceTypeLinux *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can use macOS clients to access their WorkSpaces.
	DeviceTypeOsx *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can access their WorkSpaces through a web browser.
	DeviceTypeWeb *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can use Windows clients to access their WorkSpaces.
	DeviceTypeWindows *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can use zero client devices to access their WorkSpaces.
	DeviceTypeZeroClient *string `type:"string" enum:"AccessPropertyValue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceAccessProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceAccessProperties) GoString() string {
	return s.String()
}

// SetDeviceTypeAndroid sets the DeviceTypeAndroid field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeAndroid(v string) *WorkspaceAccessProperties {
	s.DeviceTypeAndroid = &v
	return s
}

// SetDeviceTypeChromeOs sets the DeviceTypeChromeOs field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeChromeOs(v string) *WorkspaceAccessProperties {
	s.DeviceTypeChromeOs = &v
	return s
}

// SetDeviceTypeIos sets the DeviceTypeIos field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeIos(v string) *WorkspaceAccessProperties {
	s.DeviceTypeIos = &v
	return s
}

// SetDeviceTypeLinux sets the DeviceTypeLinux field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeLinux(v string) *WorkspaceAccessProperties {
	s.DeviceTypeLinux = &v
	return s
}

// SetDeviceTypeOsx sets the DeviceTypeOsx field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeOsx(v string) *WorkspaceAccessProperties {
	s.DeviceTypeOsx = &v
	return s
}

// SetDeviceTypeWeb sets the DeviceTypeWeb field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeWeb(v string) *WorkspaceAccessProperties {
	s.DeviceTypeWeb = &v
	return s
}

// SetDeviceTypeWindows sets the DeviceTypeWindows field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeWindows(v string) *WorkspaceAccessProperties {
	s.DeviceTypeWindows = &v
	return s
}

// SetDeviceTypeZeroClient sets the DeviceTypeZeroClient field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeZeroClient(v string) *WorkspaceAccessProperties {
	s.DeviceTypeZeroClient = &v
	return s
}

// Describes a WorkSpace bundle.
type WorkspaceBundle struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle.
	BundleId *string `type:"string"`

	// The type of WorkSpace bundle.
	BundleType *string `type:"string" enum:"BundleType"`

	// The compute type of the bundle. For more information, see Amazon WorkSpaces
	// Bundles (http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
	ComputeType *ComputeType `type:"structure"`

	// The time when the bundle was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description of the bundle.
	Description *string `type:"string"`

	// The identifier of the image that was used to create the bundle.
	ImageId *string `type:"string"`

	// The last time that the bundle was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the bundle.
	Name *string `min:"1" type:"string"`

	// The owner of the bundle. This is the account identifier of the owner, or
	// AMAZON if the bundle is provided by Amazon Web Services.
	Owner *string `type:"string"`

	// The size of the root volume.
	RootStorage *RootStorage `type:"structure"`

	// The state of the WorkSpace bundle.
	State *string `type:"string" enum:"WorkspaceBundleState"`

	// The size of the user volume.
	UserStorage *UserStorage `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceBundle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceBundle) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *WorkspaceBundle) SetBundleId(v string) *WorkspaceBundle {
	s.BundleId = &v
	return s
}

// SetBundleType sets the BundleType field's value.
func (s *WorkspaceBundle) SetBundleType(v string) *WorkspaceBundle {
	s.BundleType = &v
	return s
}

// SetComputeType sets the ComputeType field's value.
func (s *WorkspaceBundle) SetComputeType(v *ComputeType) *WorkspaceBundle {
	s.ComputeType = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *WorkspaceBundle) SetCreationTime(v time.Time) *WorkspaceBundle {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkspaceBundle) SetDescription(v string) *WorkspaceBundle {
	s.Description = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *WorkspaceBundle) SetImageId(v string) *WorkspaceBundle {
	s.ImageId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *WorkspaceBundle) SetLastUpdatedTime(v time.Time) *WorkspaceBundle {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkspaceBundle) SetName(v string) *WorkspaceBundle {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *WorkspaceBundle) SetOwner(v string) *WorkspaceBundle {
	s.Owner = &v
	return s
}

// SetRootStorage sets the RootStorage field's value.
func (s *WorkspaceBundle) SetRootStorage(v *RootStorage) *WorkspaceBundle {
	s.RootStorage = v
	return s
}

// SetState sets the State field's value.
func (s *WorkspaceBundle) SetState(v string) *WorkspaceBundle {
	s.State = &v
	return s
}

// SetUserStorage sets the UserStorage field's value.
func (s *WorkspaceBundle) SetUserStorage(v *UserStorage) *WorkspaceBundle {
	s.UserStorage = v
	return s
}

// Describes the connection status of a WorkSpace.
type WorkspaceConnectionStatus struct {
	_ struct{} `type:"structure"`

	// The connection state of the WorkSpace. The connection state is unknown if
	// the WorkSpace is stopped.
	ConnectionState *string `type:"string" enum:"ConnectionState"`

	// The timestamp of the connection status check.
	ConnectionStateCheckTimestamp *time.Time `type:"timestamp"`

	// The timestamp of the last known user connection.
	LastKnownUserConnectionTimestamp *time.Time `type:"timestamp"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceConnectionStatus) GoString() string {
	return s.String()
}

// SetConnectionState sets the ConnectionState field's value.
func (s *WorkspaceConnectionStatus) SetConnectionState(v string) *WorkspaceConnectionStatus {
	s.ConnectionState = &v
	return s
}

// SetConnectionStateCheckTimestamp sets the ConnectionStateCheckTimestamp field's value.
func (s *WorkspaceConnectionStatus) SetConnectionStateCheckTimestamp(v time.Time) *WorkspaceConnectionStatus {
	s.ConnectionStateCheckTimestamp = &v
	return s
}

// SetLastKnownUserConnectionTimestamp sets the LastKnownUserConnectionTimestamp field's value.
func (s *WorkspaceConnectionStatus) SetLastKnownUserConnectionTimestamp(v time.Time) *WorkspaceConnectionStatus {
	s.LastKnownUserConnectionTimestamp = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *WorkspaceConnectionStatus) SetWorkspaceId(v string) *WorkspaceConnectionStatus {
	s.WorkspaceId = &v
	return s
}

// Describes the default properties that are used for creating WorkSpaces. For
// more information, see Update Directory Details for Your WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html).
type WorkspaceCreationProperties struct {
	_ struct{} `type:"structure"`

	// The identifier of your custom security group.
	CustomSecurityGroupId *string `min:"11" type:"string"`

	// The default organizational unit (OU) for your WorkSpaces directories. This
	// string must be the full Lightweight Directory Access Protocol (LDAP) distinguished
	// name for the target domain and OU. It must be in the form "OU=value,DC=value,DC=value",
	// where value is any string of characters, and the number of domain components
	// (DCs) is two or more. For example, OU=WorkSpaces_machines,DC=machines,DC=example,DC=com.
	//
	//    * To avoid errors, certain characters in the distinguished name must be
	//    escaped. For more information, see Distinguished Names (https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names)
	//    in the Microsoft documentation.
	//
	//    * The API doesn't validate whether the OU exists.
	DefaultOu *string `type:"string"`

	// Indicates whether internet access is enabled for your WorkSpaces.
	EnableInternetAccess *bool `type:"boolean"`

	// Indicates whether maintenance mode is enabled for your WorkSpaces. For more
	// information, see WorkSpace Maintenance (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html).
	EnableMaintenanceMode *bool `type:"boolean"`

	// Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.
	//
	// If WorkDocs is already enabled for a WorkSpaces directory and you disable
	// it, new WorkSpaces launched in the directory will not have WorkDocs enabled.
	// However, WorkDocs remains enabled for any existing WorkSpaces, unless you
	// either disable users' access to WorkDocs or you delete the WorkDocs site.
	// To disable users' access to WorkDocs, see Disabling Users (https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html)
	// in the Amazon WorkDocs Administration Guide. To delete a WorkDocs site, see
	// Deleting a Site (https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html)
	// in the Amazon WorkDocs Administration Guide.
	//
	// If you enable WorkDocs on a directory that already has existing WorkSpaces,
	// the existing WorkSpaces and any new WorkSpaces that are launched in the directory
	// will have WorkDocs enabled.
	EnableWorkDocs *bool `type:"boolean"`

	// Indicates the IAM role ARN of the instance.
	InstanceIamRoleArn *string `type:"string"`

	// Indicates whether users are local administrators of their WorkSpaces.
	UserEnabledAsLocalAdministrator *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceCreationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceCreationProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkspaceCreationProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkspaceCreationProperties"}
	if s.CustomSecurityGroupId != nil && len(*s.CustomSecurityGroupId) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("CustomSecurityGroupId", 11))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomSecurityGroupId sets the CustomSecurityGroupId field's value.
func (s *WorkspaceCreationProperties) SetCustomSecurityGroupId(v string) *WorkspaceCreationProperties {
	s.CustomSecurityGroupId = &v
	return s
}

// SetDefaultOu sets the DefaultOu field's value.
func (s *WorkspaceCreationProperties) SetDefaultOu(v string) *WorkspaceCreationProperties {
	s.DefaultOu = &v
	return s
}

// SetEnableInternetAccess sets the EnableInternetAccess field's value.
func (s *WorkspaceCreationProperties) SetEnableInternetAccess(v bool) *WorkspaceCreationProperties {
	s.EnableInternetAccess = &v
	return s
}

// SetEnableMaintenanceMode sets the EnableMaintenanceMode field's value.
func (s *WorkspaceCreationProperties) SetEnableMaintenanceMode(v bool) *WorkspaceCreationProperties {
	s.EnableMaintenanceMode = &v
	return s
}

// SetEnableWorkDocs sets the EnableWorkDocs field's value.
func (s *WorkspaceCreationProperties) SetEnableWorkDocs(v bool) *WorkspaceCreationProperties {
	s.EnableWorkDocs = &v
	return s
}

// SetInstanceIamRoleArn sets the InstanceIamRoleArn field's value.
func (s *WorkspaceCreationProperties) SetInstanceIamRoleArn(v string) *WorkspaceCreationProperties {
	s.InstanceIamRoleArn = &v
	return s
}

// SetUserEnabledAsLocalAdministrator sets the UserEnabledAsLocalAdministrator field's value.
func (s *WorkspaceCreationProperties) SetUserEnabledAsLocalAdministrator(v bool) *WorkspaceCreationProperties {
	s.UserEnabledAsLocalAdministrator = &v
	return s
}

// Describes a directory that is used with Amazon WorkSpaces.
type WorkspaceDirectory struct {
	_ struct{} `type:"structure"`

	// Information about the Active Directory config.
	ActiveDirectoryConfig *ActiveDirectoryConfig `type:"structure"`

	// The directory alias.
	Alias *string `type:"string"`

	// The certificate-based authentication properties used to authenticate SAML
	// 2.0 Identity Provider (IdP) user identities to Active Directory for WorkSpaces
	// login.
	CertificateBasedAuthProperties *CertificateBasedAuthProperties `type:"structure"`

	// The user name for the service account.
	CustomerUserName *string `min:"1" type:"string"`

	// The directory identifier.
	DirectoryId *string `min:"10" type:"string"`

	// The name of the directory.
	DirectoryName *string `type:"string"`

	// The directory type.
	DirectoryType *string `type:"string" enum:"WorkspaceDirectoryType"`

	// The IP addresses of the DNS servers for the directory.
	DnsIpAddresses []*string `type:"list"`

	// The error message returned.
	ErrorMessage *string `type:"string"`

	// The identifier of the IAM role. This is the role that allows Amazon WorkSpaces
	// to make calls to other services, such as Amazon EC2, on your behalf.
	IamRoleId *string `type:"string"`

	// The identifiers of the IP access control groups associated with the directory.
	IpGroupIds []*string `locationName:"ipGroupIds" type:"list"`

	// The registration code for the directory. This is the code that users enter
	// in their Amazon WorkSpaces client application to connect to the directory.
	RegistrationCode *string `min:"1" type:"string"`

	// Describes the enablement status, user access URL, and relay state parameter
	// name that are used for configuring federation with an SAML 2.0 identity provider.
	SamlProperties *SamlProperties `type:"structure"`

	// The default self-service permissions for WorkSpaces in the directory.
	SelfservicePermissions *SelfservicePermissions `type:"structure"`

	// The state of the directory's registration with Amazon WorkSpaces. After a
	// directory is deregistered, the DEREGISTERED state is returned very briefly
	// before the directory metadata is cleaned up, so this state is rarely returned.
	// To confirm that a directory is deregistered, check for the directory ID by
	// using DescribeWorkspaceDirectories (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html).
	// If the directory ID isn't returned, then the directory has been successfully
	// deregistered.
	State *string `type:"string" enum:"WorkspaceDirectoryState"`

	// The streaming properties to configure.
	StreamingProperties *StreamingProperties `type:"structure"`

	// The identifiers of the subnets used with the directory.
	SubnetIds []*string `type:"list"`

	// Specifies whether the directory is dedicated or shared. To use Bring Your
	// Own License (BYOL), this value must be set to DEDICATED. For more information,
	// see Bring Your Own Windows Desktop Images (https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
	Tenancy *string `type:"string" enum:"Tenancy"`

	// Indicates the identity type of the specifired user.
	UserIdentityType *string `type:"string" enum:"UserIdentityType"`

	// The devices and operating systems that users can use to access WorkSpaces.
	WorkspaceAccessProperties *WorkspaceAccessProperties `type:"structure"`

	// The default creation properties for all WorkSpaces in the directory.
	WorkspaceCreationProperties *DefaultWorkspaceCreationProperties `type:"structure"`

	// The description of the WorkSpace directory
	WorkspaceDirectoryDescription *string `type:"string"`

	// The name fo the WorkSpace directory.
	WorkspaceDirectoryName *string `type:"string"`

	// The identifier of the security group that is assigned to new WorkSpaces.
	WorkspaceSecurityGroupId *string `min:"11" type:"string"`

	// Indicates whether the directory's WorkSpace type is personal or pools.
	WorkspaceType *string `type:"string" enum:"WorkspaceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceDirectory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceDirectory) GoString() string {
	return s.String()
}

// SetActiveDirectoryConfig sets the ActiveDirectoryConfig field's value.
func (s *WorkspaceDirectory) SetActiveDirectoryConfig(v *ActiveDirectoryConfig) *WorkspaceDirectory {
	s.ActiveDirectoryConfig = v
	return s
}

// SetAlias sets the Alias field's value.
func (s *WorkspaceDirectory) SetAlias(v string) *WorkspaceDirectory {
	s.Alias = &v
	return s
}

// SetCertificateBasedAuthProperties sets the CertificateBasedAuthProperties field's value.
func (s *WorkspaceDirectory) SetCertificateBasedAuthProperties(v *CertificateBasedAuthProperties) *WorkspaceDirectory {
	s.CertificateBasedAuthProperties = v
	return s
}

// SetCustomerUserName sets the CustomerUserName field's value.
func (s *WorkspaceDirectory) SetCustomerUserName(v string) *WorkspaceDirectory {
	s.CustomerUserName = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *WorkspaceDirectory) SetDirectoryId(v string) *WorkspaceDirectory {
	s.DirectoryId = &v
	return s
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *WorkspaceDirectory) SetDirectoryName(v string) *WorkspaceDirectory {
	s.DirectoryName = &v
	return s
}

// SetDirectoryType sets the DirectoryType field's value.
func (s *WorkspaceDirectory) SetDirectoryType(v string) *WorkspaceDirectory {
	s.DirectoryType = &v
	return s
}

// SetDnsIpAddresses sets the DnsIpAddresses field's value.
func (s *WorkspaceDirectory) SetDnsIpAddresses(v []*string) *WorkspaceDirectory {
	s.DnsIpAddresses = v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *WorkspaceDirectory) SetErrorMessage(v string) *WorkspaceDirectory {
	s.ErrorMessage = &v
	return s
}

// SetIamRoleId sets the IamRoleId field's value.
func (s *WorkspaceDirectory) SetIamRoleId(v string) *WorkspaceDirectory {
	s.IamRoleId = &v
	return s
}

// SetIpGroupIds sets the IpGroupIds field's value.
func (s *WorkspaceDirectory) SetIpGroupIds(v []*string) *WorkspaceDirectory {
	s.IpGroupIds = v
	return s
}

// SetRegistrationCode sets the RegistrationCode field's value.
func (s *WorkspaceDirectory) SetRegistrationCode(v string) *WorkspaceDirectory {
	s.RegistrationCode = &v
	return s
}

// SetSamlProperties sets the SamlProperties field's value.
func (s *WorkspaceDirectory) SetSamlProperties(v *SamlProperties) *WorkspaceDirectory {
	s.SamlProperties = v
	return s
}

// SetSelfservicePermissions sets the SelfservicePermissions field's value.
func (s *WorkspaceDirectory) SetSelfservicePermissions(v *SelfservicePermissions) *WorkspaceDirectory {
	s.SelfservicePermissions = v
	return s
}

// SetState sets the State field's value.
func (s *WorkspaceDirectory) SetState(v string) *WorkspaceDirectory {
	s.State = &v
	return s
}

// SetStreamingProperties sets the StreamingProperties field's value.
func (s *WorkspaceDirectory) SetStreamingProperties(v *StreamingProperties) *WorkspaceDirectory {
	s.StreamingProperties = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *WorkspaceDirectory) SetSubnetIds(v []*string) *WorkspaceDirectory {
	s.SubnetIds = v
	return s
}

// SetTenancy sets the Tenancy field's value.
func (s *WorkspaceDirectory) SetTenancy(v string) *WorkspaceDirectory {
	s.Tenancy = &v
	return s
}

// SetUserIdentityType sets the UserIdentityType field's value.
func (s *WorkspaceDirectory) SetUserIdentityType(v string) *WorkspaceDirectory {
	s.UserIdentityType = &v
	return s
}

// SetWorkspaceAccessProperties sets the WorkspaceAccessProperties field's value.
func (s *WorkspaceDirectory) SetWorkspaceAccessProperties(v *WorkspaceAccessProperties) *WorkspaceDirectory {
	s.WorkspaceAccessProperties = v
	return s
}

// SetWorkspaceCreationProperties sets the WorkspaceCreationProperties field's value.
func (s *WorkspaceDirectory) SetWorkspaceCreationProperties(v *DefaultWorkspaceCreationProperties) *WorkspaceDirectory {
	s.WorkspaceCreationProperties = v
	return s
}

// SetWorkspaceDirectoryDescription sets the WorkspaceDirectoryDescription field's value.
func (s *WorkspaceDirectory) SetWorkspaceDirectoryDescription(v string) *WorkspaceDirectory {
	s.WorkspaceDirectoryDescription = &v
	return s
}

// SetWorkspaceDirectoryName sets the WorkspaceDirectoryName field's value.
func (s *WorkspaceDirectory) SetWorkspaceDirectoryName(v string) *WorkspaceDirectory {
	s.WorkspaceDirectoryName = &v
	return s
}

// SetWorkspaceSecurityGroupId sets the WorkspaceSecurityGroupId field's value.
func (s *WorkspaceDirectory) SetWorkspaceSecurityGroupId(v string) *WorkspaceDirectory {
	s.WorkspaceSecurityGroupId = &v
	return s
}

// SetWorkspaceType sets the WorkspaceType field's value.
func (s *WorkspaceDirectory) SetWorkspaceType(v string) *WorkspaceDirectory {
	s.WorkspaceType = &v
	return s
}

// Describes a WorkSpace image.
type WorkspaceImage struct {
	_ struct{} `type:"structure"`

	// The date when the image was created. If the image has been shared, the Amazon
	// Web Services account that the image has been shared with sees the original
	// creation date of the image.
	Created *time.Time `type:"timestamp"`

	// The description of the image.
	Description *string `min:"1" type:"string"`

	// The error code that is returned for the image.
	ErrorCode *string `type:"string"`

	// Additional details of the error returned for the image, including the possible
	// causes of the errors and troubleshooting information.
	ErrorDetails []*ErrorDetails `type:"list"`

	// The text of the error message that is returned for the image.
	ErrorMessage *string `type:"string"`

	// The identifier of the image.
	ImageId *string `type:"string"`

	// The name of the image.
	Name *string `min:"1" type:"string"`

	// The operating system that the image is running.
	OperatingSystem *OperatingSystem `type:"structure"`

	// The identifier of the Amazon Web Services account that owns the image.
	OwnerAccountId *string `type:"string"`

	// Specifies whether the image is running on dedicated hardware. When Bring
	// Your Own License (BYOL) is enabled, this value is set to DEDICATED. For more
	// information, see Bring Your Own Windows Desktop Images (https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
	RequiredTenancy *string `type:"string" enum:"WorkspaceImageRequiredTenancy"`

	// The status of the image.
	State *string `type:"string" enum:"WorkspaceImageState"`

	// The updates (if any) that are available for the specified image.
	Updates *UpdateResult `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceImage) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *WorkspaceImage) SetCreated(v time.Time) *WorkspaceImage {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkspaceImage) SetDescription(v string) *WorkspaceImage {
	s.Description = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *WorkspaceImage) SetErrorCode(v string) *WorkspaceImage {
	s.ErrorCode = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *WorkspaceImage) SetErrorDetails(v []*ErrorDetails) *WorkspaceImage {
	s.ErrorDetails = v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *WorkspaceImage) SetErrorMessage(v string) *WorkspaceImage {
	s.ErrorMessage = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *WorkspaceImage) SetImageId(v string) *WorkspaceImage {
	s.ImageId = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkspaceImage) SetName(v string) *WorkspaceImage {
	s.Name = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *WorkspaceImage) SetOperatingSystem(v *OperatingSystem) *WorkspaceImage {
	s.OperatingSystem = v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *WorkspaceImage) SetOwnerAccountId(v string) *WorkspaceImage {
	s.OwnerAccountId = &v
	return s
}

// SetRequiredTenancy sets the RequiredTenancy field's value.
func (s *WorkspaceImage) SetRequiredTenancy(v string) *WorkspaceImage {
	s.RequiredTenancy = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkspaceImage) SetState(v string) *WorkspaceImage {
	s.State = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *WorkspaceImage) SetUpdates(v *UpdateResult) *WorkspaceImage {
	s.Updates = v
	return s
}

// Describes a WorkSpace.
type WorkspaceProperties struct {
	_ struct{} `type:"structure"`

	// The compute type. For more information, see Amazon WorkSpaces Bundles (http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
	ComputeTypeName *string `type:"string" enum:"Compute"`

	// The name of the operating system.
	OperatingSystemName *string `type:"string" enum:"OperatingSystemName"`

	// The protocol. For more information, see Protocols for Amazon WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-protocols.html).
	//
	//    * Only available for WorkSpaces created with PCoIP bundles.
	//
	//    * The Protocols property is case sensitive. Ensure you use PCOIP or WSP.
	//
	//    * Unavailable for Windows 7 WorkSpaces and WorkSpaces using GPU-based
	//    bundles (Graphics, GraphicsPro, Graphics.g4dn, and GraphicsPro.g4dn).
	Protocols []*string `type:"list" enum:"Protocol"`

	// The size of the root volume. For important information about how to modify
	// the size of the root and user volumes, see Modify a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
	RootVolumeSizeGib *int64 `type:"integer"`

	// The running mode. For more information, see Manage the WorkSpace Running
	// Mode (https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html).
	//
	// The MANUAL value is only supported by Amazon WorkSpaces Core. Contact your
	// account team to be allow-listed to use this value. For more information,
	// see Amazon WorkSpaces Core (http://aws.amazon.com/workspaces/core/).
	//
	// Review your running mode to ensure you are using one that is optimal for
	// your needs and budget. For more information on switching running modes, see
	// Can I switch between hourly and monthly billing? (http://aws.amazon.com/workspaces-family/workspaces/faqs/#:~:text=Can%20I%20switch%20between%20hourly%20and%20monthly%20billing%20on%20WorkSpaces%20Personal%3F)
	RunningMode *string `type:"string" enum:"RunningMode"`

	// The time after a user logs off when WorkSpaces are automatically stopped.
	// Configured in 60-minute intervals.
	RunningModeAutoStopTimeoutInMinutes *int64 `type:"integer"`

	// The size of the user storage. For important information about how to modify
	// the size of the root and user volumes, see Modify a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
	UserVolumeSizeGib *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceProperties) GoString() string {
	return s.String()
}

// SetComputeTypeName sets the ComputeTypeName field's value.
func (s *WorkspaceProperties) SetComputeTypeName(v string) *WorkspaceProperties {
	s.ComputeTypeName = &v
	return s
}

// SetOperatingSystemName sets the OperatingSystemName field's value.
func (s *WorkspaceProperties) SetOperatingSystemName(v string) *WorkspaceProperties {
	s.OperatingSystemName = &v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *WorkspaceProperties) SetProtocols(v []*string) *WorkspaceProperties {
	s.Protocols = v
	return s
}

// SetRootVolumeSizeGib sets the RootVolumeSizeGib field's value.
func (s *WorkspaceProperties) SetRootVolumeSizeGib(v int64) *WorkspaceProperties {
	s.RootVolumeSizeGib = &v
	return s
}

// SetRunningMode sets the RunningMode field's value.
func (s *WorkspaceProperties) SetRunningMode(v string) *WorkspaceProperties {
	s.RunningMode = &v
	return s
}

// SetRunningModeAutoStopTimeoutInMinutes sets the RunningModeAutoStopTimeoutInMinutes field's value.
func (s *WorkspaceProperties) SetRunningModeAutoStopTimeoutInMinutes(v int64) *WorkspaceProperties {
	s.RunningModeAutoStopTimeoutInMinutes = &v
	return s
}

// SetUserVolumeSizeGib sets the UserVolumeSizeGib field's value.
func (s *WorkspaceProperties) SetUserVolumeSizeGib(v int64) *WorkspaceProperties {
	s.UserVolumeSizeGib = &v
	return s
}

// Describes the information used to create a WorkSpace.
type WorkspaceRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle for the WorkSpace. You can use DescribeWorkspaceBundles
	// to list the available bundles.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`

	// The identifier of the Directory Service directory for the WorkSpace. You
	// can use DescribeWorkspaceDirectories to list the available directories.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`

	// Indicates whether the data stored on the root volume is encrypted.
	RootVolumeEncryptionEnabled *bool `type:"boolean"`

	// The tags for the WorkSpace.
	Tags []*Tag `type:"list"`

	// The user name of the user for the WorkSpace. This user name must exist in
	// the Directory Service directory for the WorkSpace.
	//
	// The reserved keyword, [UNDEFINED], is used when creating user-decoupled WorkSpaces.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`

	// Indicates whether the data stored on the user volume is encrypted.
	UserVolumeEncryptionEnabled *bool `type:"boolean"`

	// The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace.
	// Amazon WorkSpaces does not support asymmetric KMS keys.
	VolumeEncryptionKey *string `type:"string"`

	// The name of the user-decoupled WorkSpace.
	WorkspaceName *string `type:"string"`

	// The WorkSpace properties.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkspaceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkspaceRequest"}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *WorkspaceRequest) SetBundleId(v string) *WorkspaceRequest {
	s.BundleId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *WorkspaceRequest) SetDirectoryId(v string) *WorkspaceRequest {
	s.DirectoryId = &v
	return s
}

// SetRootVolumeEncryptionEnabled sets the RootVolumeEncryptionEnabled field's value.
func (s *WorkspaceRequest) SetRootVolumeEncryptionEnabled(v bool) *WorkspaceRequest {
	s.RootVolumeEncryptionEnabled = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *WorkspaceRequest) SetTags(v []*Tag) *WorkspaceRequest {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *WorkspaceRequest) SetUserName(v string) *WorkspaceRequest {
	s.UserName = &v
	return s
}

// SetUserVolumeEncryptionEnabled sets the UserVolumeEncryptionEnabled field's value.
func (s *WorkspaceRequest) SetUserVolumeEncryptionEnabled(v bool) *WorkspaceRequest {
	s.UserVolumeEncryptionEnabled = &v
	return s
}

// SetVolumeEncryptionKey sets the VolumeEncryptionKey field's value.
func (s *WorkspaceRequest) SetVolumeEncryptionKey(v string) *WorkspaceRequest {
	s.VolumeEncryptionKey = &v
	return s
}

// SetWorkspaceName sets the WorkspaceName field's value.
func (s *WorkspaceRequest) SetWorkspaceName(v string) *WorkspaceRequest {
	s.WorkspaceName = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *WorkspaceRequest) SetWorkspaceProperties(v *WorkspaceProperties) *WorkspaceRequest {
	s.WorkspaceProperties = v
	return s
}

// Describes the association between an application and a WorkSpace resource.
type WorkspaceResourceAssociation struct {
	_ struct{} `type:"structure"`

	// The identifier of the associated resource.
	AssociatedResourceId *string `min:"1" type:"string"`

	// The resource types of the associated resource.
	AssociatedResourceType *string `type:"string" enum:"WorkSpaceAssociatedResourceType"`

	// The time the association is created.
	Created *time.Time `type:"timestamp"`

	// The time the association status was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The status of the WorkSpace resource association.
	State *string `type:"string" enum:"AssociationState"`

	// The reason the association deployment failed.
	StateReason *AssociationStateReason `type:"structure"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceResourceAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceResourceAssociation) GoString() string {
	return s.String()
}

// SetAssociatedResourceId sets the AssociatedResourceId field's value.
func (s *WorkspaceResourceAssociation) SetAssociatedResourceId(v string) *WorkspaceResourceAssociation {
	s.AssociatedResourceId = &v
	return s
}

// SetAssociatedResourceType sets the AssociatedResourceType field's value.
func (s *WorkspaceResourceAssociation) SetAssociatedResourceType(v string) *WorkspaceResourceAssociation {
	s.AssociatedResourceType = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *WorkspaceResourceAssociation) SetCreated(v time.Time) *WorkspaceResourceAssociation {
	s.Created = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *WorkspaceResourceAssociation) SetLastUpdatedTime(v time.Time) *WorkspaceResourceAssociation {
	s.LastUpdatedTime = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkspaceResourceAssociation) SetState(v string) *WorkspaceResourceAssociation {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *WorkspaceResourceAssociation) SetStateReason(v *AssociationStateReason) *WorkspaceResourceAssociation {
	s.StateReason = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *WorkspaceResourceAssociation) SetWorkspaceId(v string) *WorkspaceResourceAssociation {
	s.WorkspaceId = &v
	return s
}

// The workspaces_DefaultRole role could not be found. If this is the first
// time you are registering a directory, you will need to create the workspaces_DefaultRole
// role before you can register a directory. For more information, see Creating
// the workspaces_DefaultRole Role (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role).
type WorkspacesDefaultRoleNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspacesDefaultRoleNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspacesDefaultRoleNotFoundException) GoString() string {
	return s.String()
}

func newErrorWorkspacesDefaultRoleNotFoundException(v protocol.ResponseMetadata) error {
	return &WorkspacesDefaultRoleNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WorkspacesDefaultRoleNotFoundException) Code() string {
	return "WorkspacesDefaultRoleNotFoundException"
}

// Message returns the exception's message.
func (s *WorkspacesDefaultRoleNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WorkspacesDefaultRoleNotFoundException) OrigErr() error {
	return nil
}

func (s *WorkspacesDefaultRoleNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WorkspacesDefaultRoleNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WorkspacesDefaultRoleNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a pool of WorkSpaces.
type WorkspacesPool struct {
	_ struct{} `type:"structure"`

	// The persistent application settings for users of the pool.
	ApplicationSettings *ApplicationSettingsResponse `type:"structure"`

	// The identifier of the bundle used by the pool.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`

	// The capacity status for the pool
	//
	// CapacityStatus is a required field
	CapacityStatus *CapacityStatus `type:"structure" required:"true"`

	// The time the pool was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The description of the pool.
	Description *string `min:"1" type:"string"`

	// The identifier of the directory used by the pool.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`

	// The pool errors.
	Errors []*WorkspacesPoolError `type:"list"`

	// The Amazon Resource Name (ARN) for the pool.
	//
	// PoolArn is a required field
	PoolArn *string `type:"string" required:"true"`

	// The identifier of a pool.
	//
	// PoolId is a required field
	PoolId *string `type:"string" required:"true"`

	// The name of the pool,
	//
	// PoolName is a required field
	PoolName *string `type:"string" required:"true"`

	// The current state of the pool.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"WorkspacesPoolState"`

	// The amount of time that a pool session remains active after users disconnect.
	// If they try to reconnect to the pool session after a disconnection or network
	// interruption within this time interval, they are connected to their previous
	// session. Otherwise, they are connected to a new session with a new pool instance.
	TimeoutSettings *TimeoutSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspacesPool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspacesPool) GoString() string {
	return s.String()
}

// SetApplicationSettings sets the ApplicationSettings field's value.
func (s *WorkspacesPool) SetApplicationSettings(v *ApplicationSettingsResponse) *WorkspacesPool {
	s.ApplicationSettings = v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *WorkspacesPool) SetBundleId(v string) *WorkspacesPool {
	s.BundleId = &v
	return s
}

// SetCapacityStatus sets the CapacityStatus field's value.
func (s *WorkspacesPool) SetCapacityStatus(v *CapacityStatus) *WorkspacesPool {
	s.CapacityStatus = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *WorkspacesPool) SetCreatedAt(v time.Time) *WorkspacesPool {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkspacesPool) SetDescription(v string) *WorkspacesPool {
	s.Description = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *WorkspacesPool) SetDirectoryId(v string) *WorkspacesPool {
	s.DirectoryId = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *WorkspacesPool) SetErrors(v []*WorkspacesPoolError) *WorkspacesPool {
	s.Errors = v
	return s
}

// SetPoolArn sets the PoolArn field's value.
func (s *WorkspacesPool) SetPoolArn(v string) *WorkspacesPool {
	s.PoolArn = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *WorkspacesPool) SetPoolId(v string) *WorkspacesPool {
	s.PoolId = &v
	return s
}

// SetPoolName sets the PoolName field's value.
func (s *WorkspacesPool) SetPoolName(v string) *WorkspacesPool {
	s.PoolName = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkspacesPool) SetState(v string) *WorkspacesPool {
	s.State = &v
	return s
}

// SetTimeoutSettings sets the TimeoutSettings field's value.
func (s *WorkspacesPool) SetTimeoutSettings(v *TimeoutSettings) *WorkspacesPool {
	s.TimeoutSettings = v
	return s
}

// Describes a pool error.
type WorkspacesPoolError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"WorkspacesPoolErrorCode"`

	// The error message.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspacesPoolError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspacesPoolError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *WorkspacesPoolError) SetErrorCode(v string) *WorkspacesPoolError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *WorkspacesPoolError) SetErrorMessage(v string) *WorkspacesPoolError {
	s.ErrorMessage = &v
	return s
}

// Describes a pool session.
type WorkspacesPoolSession struct {
	_ struct{} `type:"structure"`

	// The authentication method. The user is authenticated using a WorkSpaces Pools
	// URL (API) or SAML 2.0 federation (SAML).
	AuthenticationType *string `type:"string" enum:"AuthenticationType"`

	// Specifies whether a user is connected to the pool session.
	ConnectionState *string `type:"string" enum:"SessionConnectionState"`

	// The time that the pool session ended.
	ExpirationTime *time.Time `type:"timestamp"`

	// The identifier for the instance hosting the session.
	InstanceId *string `type:"string"`

	// Describes the network details of the pool.
	NetworkAccessConfiguration *NetworkAccessConfiguration `type:"structure"`

	// The identifier of the pool.
	//
	// PoolId is a required field
	PoolId *string `type:"string" required:"true"`

	// The identifier of the session.
	//
	// SessionId is a required field
	SessionId *string `min:"36" type:"string" required:"true"`

	// The time that the pool sission started.
	StartTime *time.Time `type:"timestamp"`

	// The identifier of the user.
	//
	// UserId is a required field
	UserId *string `min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspacesPoolSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspacesPoolSession) GoString() string {
	return s.String()
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *WorkspacesPoolSession) SetAuthenticationType(v string) *WorkspacesPoolSession {
	s.AuthenticationType = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *WorkspacesPoolSession) SetConnectionState(v string) *WorkspacesPoolSession {
	s.ConnectionState = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *WorkspacesPoolSession) SetExpirationTime(v time.Time) *WorkspacesPoolSession {
	s.ExpirationTime = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *WorkspacesPoolSession) SetInstanceId(v string) *WorkspacesPoolSession {
	s.InstanceId = &v
	return s
}

// SetNetworkAccessConfiguration sets the NetworkAccessConfiguration field's value.
func (s *WorkspacesPoolSession) SetNetworkAccessConfiguration(v *NetworkAccessConfiguration) *WorkspacesPoolSession {
	s.NetworkAccessConfiguration = v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *WorkspacesPoolSession) SetPoolId(v string) *WorkspacesPoolSession {
	s.PoolId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *WorkspacesPoolSession) SetSessionId(v string) *WorkspacesPoolSession {
	s.SessionId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *WorkspacesPoolSession) SetStartTime(v time.Time) *WorkspacesPoolSession {
	s.StartTime = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *WorkspacesPoolSession) SetUserId(v string) *WorkspacesPoolSession {
	s.UserId = &v
	return s
}

const (
	// AccessPropertyValueAllow is a AccessPropertyValue enum value
	AccessPropertyValueAllow = "ALLOW"

	// AccessPropertyValueDeny is a AccessPropertyValue enum value
	AccessPropertyValueDeny = "DENY"
)

// AccessPropertyValue_Values returns all elements of the AccessPropertyValue enum
func AccessPropertyValue_Values() []string {
	return []string{
		AccessPropertyValueAllow,
		AccessPropertyValueDeny,
	}
}

const (
	// AccountLinkStatusEnumLinked is a AccountLinkStatusEnum enum value
	AccountLinkStatusEnumLinked = "LINKED"

	// AccountLinkStatusEnumLinkingFailed is a AccountLinkStatusEnum enum value
	AccountLinkStatusEnumLinkingFailed = "LINKING_FAILED"

	// AccountLinkStatusEnumLinkNotFound is a AccountLinkStatusEnum enum value
	AccountLinkStatusEnumLinkNotFound = "LINK_NOT_FOUND"

	// AccountLinkStatusEnumPendingAcceptanceByTargetAccount is a AccountLinkStatusEnum enum value
	AccountLinkStatusEnumPendingAcceptanceByTargetAccount = "PENDING_ACCEPTANCE_BY_TARGET_ACCOUNT"

	// AccountLinkStatusEnumRejected is a AccountLinkStatusEnum enum value
	AccountLinkStatusEnumRejected = "REJECTED"
)

// AccountLinkStatusEnum_Values returns all elements of the AccountLinkStatusEnum enum
func AccountLinkStatusEnum_Values() []string {
	return []string{
		AccountLinkStatusEnumLinked,
		AccountLinkStatusEnumLinkingFailed,
		AccountLinkStatusEnumLinkNotFound,
		AccountLinkStatusEnumPendingAcceptanceByTargetAccount,
		AccountLinkStatusEnumRejected,
	}
}

const (
	// ApplicationMicrosoftOffice2016 is a Application enum value
	ApplicationMicrosoftOffice2016 = "Microsoft_Office_2016"

	// ApplicationMicrosoftOffice2019 is a Application enum value
	ApplicationMicrosoftOffice2019 = "Microsoft_Office_2019"
)

// Application_Values returns all elements of the Application enum
func Application_Values() []string {
	return []string{
		ApplicationMicrosoftOffice2016,
		ApplicationMicrosoftOffice2019,
	}
}

const (
	// ApplicationAssociatedResourceTypeWorkspace is a ApplicationAssociatedResourceType enum value
	ApplicationAssociatedResourceTypeWorkspace = "WORKSPACE"

	// ApplicationAssociatedResourceTypeBundle is a ApplicationAssociatedResourceType enum value
	ApplicationAssociatedResourceTypeBundle = "BUNDLE"

	// ApplicationAssociatedResourceTypeImage is a ApplicationAssociatedResourceType enum value
	ApplicationAssociatedResourceTypeImage = "IMAGE"
)

// ApplicationAssociatedResourceType_Values returns all elements of the ApplicationAssociatedResourceType enum
func ApplicationAssociatedResourceType_Values() []string {
	return []string{
		ApplicationAssociatedResourceTypeWorkspace,
		ApplicationAssociatedResourceTypeBundle,
		ApplicationAssociatedResourceTypeImage,
	}
}

const (
	// ApplicationSettingsStatusEnumDisabled is a ApplicationSettingsStatusEnum enum value
	ApplicationSettingsStatusEnumDisabled = "DISABLED"

	// ApplicationSettingsStatusEnumEnabled is a ApplicationSettingsStatusEnum enum value
	ApplicationSettingsStatusEnumEnabled = "ENABLED"
)

// ApplicationSettingsStatusEnum_Values returns all elements of the ApplicationSettingsStatusEnum enum
func ApplicationSettingsStatusEnum_Values() []string {
	return []string{
		ApplicationSettingsStatusEnumDisabled,
		ApplicationSettingsStatusEnumEnabled,
	}
}

const (
	// AssociationErrorCodeValidationErrorInsufficientDiskSpace is a AssociationErrorCode enum value
	AssociationErrorCodeValidationErrorInsufficientDiskSpace = "ValidationError.InsufficientDiskSpace"

	// AssociationErrorCodeValidationErrorInsufficientMemory is a AssociationErrorCode enum value
	AssociationErrorCodeValidationErrorInsufficientMemory = "ValidationError.InsufficientMemory"

	// AssociationErrorCodeValidationErrorUnsupportedOperatingSystem is a AssociationErrorCode enum value
	AssociationErrorCodeValidationErrorUnsupportedOperatingSystem = "ValidationError.UnsupportedOperatingSystem"

	// AssociationErrorCodeDeploymentErrorInternalServerError is a AssociationErrorCode enum value
	AssociationErrorCodeDeploymentErrorInternalServerError = "DeploymentError.InternalServerError"

	// AssociationErrorCodeDeploymentErrorWorkspaceUnreachable is a AssociationErrorCode enum value
	AssociationErrorCodeDeploymentErrorWorkspaceUnreachable = "DeploymentError.WorkspaceUnreachable"
)

// AssociationErrorCode_Values returns all elements of the AssociationErrorCode enum
func AssociationErrorCode_Values() []string {
	return []string{
		AssociationErrorCodeValidationErrorInsufficientDiskSpace,
		AssociationErrorCodeValidationErrorInsufficientMemory,
		AssociationErrorCodeValidationErrorUnsupportedOperatingSystem,
		AssociationErrorCodeDeploymentErrorInternalServerError,
		AssociationErrorCodeDeploymentErrorWorkspaceUnreachable,
	}
}

const (
	// AssociationStatePendingInstall is a AssociationState enum value
	AssociationStatePendingInstall = "PENDING_INSTALL"

	// AssociationStatePendingInstallDeployment is a AssociationState enum value
	AssociationStatePendingInstallDeployment = "PENDING_INSTALL_DEPLOYMENT"

	// AssociationStatePendingUninstall is a AssociationState enum value
	AssociationStatePendingUninstall = "PENDING_UNINSTALL"

	// AssociationStatePendingUninstallDeployment is a AssociationState enum value
	AssociationStatePendingUninstallDeployment = "PENDING_UNINSTALL_DEPLOYMENT"

	// AssociationStateInstalling is a AssociationState enum value
	AssociationStateInstalling = "INSTALLING"

	// AssociationStateUninstalling is a AssociationState enum value
	AssociationStateUninstalling = "UNINSTALLING"

	// AssociationStateError is a AssociationState enum value
	AssociationStateError = "ERROR"

	// AssociationStateCompleted is a AssociationState enum value
	AssociationStateCompleted = "COMPLETED"

	// AssociationStateRemoved is a AssociationState enum value
	AssociationStateRemoved = "REMOVED"
)

// AssociationState_Values returns all elements of the AssociationState enum
func AssociationState_Values() []string {
	return []string{
		AssociationStatePendingInstall,
		AssociationStatePendingInstallDeployment,
		AssociationStatePendingUninstall,
		AssociationStatePendingUninstallDeployment,
		AssociationStateInstalling,
		AssociationStateUninstalling,
		AssociationStateError,
		AssociationStateCompleted,
		AssociationStateRemoved,
	}
}

const (
	// AssociationStatusNotAssociated is a AssociationStatus enum value
	AssociationStatusNotAssociated = "NOT_ASSOCIATED"

	// AssociationStatusAssociatedWithOwnerAccount is a AssociationStatus enum value
	AssociationStatusAssociatedWithOwnerAccount = "ASSOCIATED_WITH_OWNER_ACCOUNT"

	// AssociationStatusAssociatedWithSharedAccount is a AssociationStatus enum value
	AssociationStatusAssociatedWithSharedAccount = "ASSOCIATED_WITH_SHARED_ACCOUNT"

	// AssociationStatusPendingAssociation is a AssociationStatus enum value
	AssociationStatusPendingAssociation = "PENDING_ASSOCIATION"

	// AssociationStatusPendingDisassociation is a AssociationStatus enum value
	AssociationStatusPendingDisassociation = "PENDING_DISASSOCIATION"
)

// AssociationStatus_Values returns all elements of the AssociationStatus enum
func AssociationStatus_Values() []string {
	return []string{
		AssociationStatusNotAssociated,
		AssociationStatusAssociatedWithOwnerAccount,
		AssociationStatusAssociatedWithSharedAccount,
		AssociationStatusPendingAssociation,
		AssociationStatusPendingDisassociation,
	}
}

const (
	// AuthenticationTypeSaml is a AuthenticationType enum value
	AuthenticationTypeSaml = "SAML"
)

// AuthenticationType_Values returns all elements of the AuthenticationType enum
func AuthenticationType_Values() []string {
	return []string{
		AuthenticationTypeSaml,
	}
}

const (
	// BundleAssociatedResourceTypeApplication is a BundleAssociatedResourceType enum value
	BundleAssociatedResourceTypeApplication = "APPLICATION"
)

// BundleAssociatedResourceType_Values returns all elements of the BundleAssociatedResourceType enum
func BundleAssociatedResourceType_Values() []string {
	return []string{
		BundleAssociatedResourceTypeApplication,
	}
}

const (
	// BundleTypeRegular is a BundleType enum value
	BundleTypeRegular = "REGULAR"

	// BundleTypeStandby is a BundleType enum value
	BundleTypeStandby = "STANDBY"
)

// BundleType_Values returns all elements of the BundleType enum
func BundleType_Values() []string {
	return []string{
		BundleTypeRegular,
		BundleTypeStandby,
	}
}

const (
	// CertificateBasedAuthStatusEnumDisabled is a CertificateBasedAuthStatusEnum enum value
	CertificateBasedAuthStatusEnumDisabled = "DISABLED"

	// CertificateBasedAuthStatusEnumEnabled is a CertificateBasedAuthStatusEnum enum value
	CertificateBasedAuthStatusEnumEnabled = "ENABLED"
)

// CertificateBasedAuthStatusEnum_Values returns all elements of the CertificateBasedAuthStatusEnum enum
func CertificateBasedAuthStatusEnum_Values() []string {
	return []string{
		CertificateBasedAuthStatusEnumDisabled,
		CertificateBasedAuthStatusEnumEnabled,
	}
}

const (
	// ClientDeviceTypeDeviceTypeWindows is a ClientDeviceType enum value
	ClientDeviceTypeDeviceTypeWindows = "DeviceTypeWindows"

	// ClientDeviceTypeDeviceTypeOsx is a ClientDeviceType enum value
	ClientDeviceTypeDeviceTypeOsx = "DeviceTypeOsx"

	// ClientDeviceTypeDeviceTypeAndroid is a ClientDeviceType enum value
	ClientDeviceTypeDeviceTypeAndroid = "DeviceTypeAndroid"

	// ClientDeviceTypeDeviceTypeIos is a ClientDeviceType enum value
	ClientDeviceTypeDeviceTypeIos = "DeviceTypeIos"

	// ClientDeviceTypeDeviceTypeLinux is a ClientDeviceType enum value
	ClientDeviceTypeDeviceTypeLinux = "DeviceTypeLinux"

	// ClientDeviceTypeDeviceTypeWeb is a ClientDeviceType enum value
	ClientDeviceTypeDeviceTypeWeb = "DeviceTypeWeb"
)

// ClientDeviceType_Values returns all elements of the ClientDeviceType enum
func ClientDeviceType_Values() []string {
	return []string{
		ClientDeviceTypeDeviceTypeWindows,
		ClientDeviceTypeDeviceTypeOsx,
		ClientDeviceTypeDeviceTypeAndroid,
		ClientDeviceTypeDeviceTypeIos,
		ClientDeviceTypeDeviceTypeLinux,
		ClientDeviceTypeDeviceTypeWeb,
	}
}

const (
	// ComputeValue is a Compute enum value
	ComputeValue = "VALUE"

	// ComputeStandard is a Compute enum value
	ComputeStandard = "STANDARD"

	// ComputePerformance is a Compute enum value
	ComputePerformance = "PERFORMANCE"

	// ComputePower is a Compute enum value
	ComputePower = "POWER"

	// ComputeGraphics is a Compute enum value
	ComputeGraphics = "GRAPHICS"

	// ComputePowerpro is a Compute enum value
	ComputePowerpro = "POWERPRO"

	// ComputeGraphicspro is a Compute enum value
	ComputeGraphicspro = "GRAPHICSPRO"

	// ComputeGraphicsG4dn is a Compute enum value
	ComputeGraphicsG4dn = "GRAPHICS_G4DN"

	// ComputeGraphicsproG4dn is a Compute enum value
	ComputeGraphicsproG4dn = "GRAPHICSPRO_G4DN"
)

// Compute_Values returns all elements of the Compute enum
func Compute_Values() []string {
	return []string{
		ComputeValue,
		ComputeStandard,
		ComputePerformance,
		ComputePower,
		ComputeGraphics,
		ComputePowerpro,
		ComputeGraphicspro,
		ComputeGraphicsG4dn,
		ComputeGraphicsproG4dn,
	}
}

const (
	// ConnectionAliasStateCreating is a ConnectionAliasState enum value
	ConnectionAliasStateCreating = "CREATING"

	// ConnectionAliasStateCreated is a ConnectionAliasState enum value
	ConnectionAliasStateCreated = "CREATED"

	// ConnectionAliasStateDeleting is a ConnectionAliasState enum value
	ConnectionAliasStateDeleting = "DELETING"
)

// ConnectionAliasState_Values returns all elements of the ConnectionAliasState enum
func ConnectionAliasState_Values() []string {
	return []string{
		ConnectionAliasStateCreating,
		ConnectionAliasStateCreated,
		ConnectionAliasStateDeleting,
	}
}

const (
	// ConnectionStateConnected is a ConnectionState enum value
	ConnectionStateConnected = "CONNECTED"

	// ConnectionStateDisconnected is a ConnectionState enum value
	ConnectionStateDisconnected = "DISCONNECTED"

	// ConnectionStateUnknown is a ConnectionState enum value
	ConnectionStateUnknown = "UNKNOWN"
)

// ConnectionState_Values returns all elements of the ConnectionState enum
func ConnectionState_Values() []string {
	return []string{
		ConnectionStateConnected,
		ConnectionStateDisconnected,
		ConnectionStateUnknown,
	}
}

const (
	// DataReplicationNoReplication is a DataReplication enum value
	DataReplicationNoReplication = "NO_REPLICATION"

	// DataReplicationPrimaryAsSource is a DataReplication enum value
	DataReplicationPrimaryAsSource = "PRIMARY_AS_SOURCE"
)

// DataReplication_Values returns all elements of the DataReplication enum
func DataReplication_Values() []string {
	return []string{
		DataReplicationNoReplication,
		DataReplicationPrimaryAsSource,
	}
}

const (
	// DedicatedTenancyAccountTypeSourceAccount is a DedicatedTenancyAccountType enum value
	DedicatedTenancyAccountTypeSourceAccount = "SOURCE_ACCOUNT"

	// DedicatedTenancyAccountTypeTargetAccount is a DedicatedTenancyAccountType enum value
	DedicatedTenancyAccountTypeTargetAccount = "TARGET_ACCOUNT"
)

// DedicatedTenancyAccountType_Values returns all elements of the DedicatedTenancyAccountType enum
func DedicatedTenancyAccountType_Values() []string {
	return []string{
		DedicatedTenancyAccountTypeSourceAccount,
		DedicatedTenancyAccountTypeTargetAccount,
	}
}

const (
	// DedicatedTenancyModificationStateEnumPending is a DedicatedTenancyModificationStateEnum enum value
	DedicatedTenancyModificationStateEnumPending = "PENDING"

	// DedicatedTenancyModificationStateEnumCompleted is a DedicatedTenancyModificationStateEnum enum value
	DedicatedTenancyModificationStateEnumCompleted = "COMPLETED"

	// DedicatedTenancyModificationStateEnumFailed is a DedicatedTenancyModificationStateEnum enum value
	DedicatedTenancyModificationStateEnumFailed = "FAILED"
)

// DedicatedTenancyModificationStateEnum_Values returns all elements of the DedicatedTenancyModificationStateEnum enum
func DedicatedTenancyModificationStateEnum_Values() []string {
	return []string{
		DedicatedTenancyModificationStateEnumPending,
		DedicatedTenancyModificationStateEnumCompleted,
		DedicatedTenancyModificationStateEnumFailed,
	}
}

const (
	// DedicatedTenancySupportEnumEnabled is a DedicatedTenancySupportEnum enum value
	DedicatedTenancySupportEnumEnabled = "ENABLED"
)

// DedicatedTenancySupportEnum_Values returns all elements of the DedicatedTenancySupportEnum enum
func DedicatedTenancySupportEnum_Values() []string {
	return []string{
		DedicatedTenancySupportEnumEnabled,
	}
}

const (
	// DedicatedTenancySupportResultEnumEnabled is a DedicatedTenancySupportResultEnum enum value
	DedicatedTenancySupportResultEnumEnabled = "ENABLED"

	// DedicatedTenancySupportResultEnumDisabled is a DedicatedTenancySupportResultEnum enum value
	DedicatedTenancySupportResultEnumDisabled = "DISABLED"
)

// DedicatedTenancySupportResultEnum_Values returns all elements of the DedicatedTenancySupportResultEnum enum
func DedicatedTenancySupportResultEnum_Values() []string {
	return []string{
		DedicatedTenancySupportResultEnumEnabled,
		DedicatedTenancySupportResultEnumDisabled,
	}
}

const (
	// DeletableCertificateBasedAuthPropertyCertificateBasedAuthPropertiesCertificateAuthorityArn is a DeletableCertificateBasedAuthProperty enum value
	DeletableCertificateBasedAuthPropertyCertificateBasedAuthPropertiesCertificateAuthorityArn = "CERTIFICATE_BASED_AUTH_PROPERTIES_CERTIFICATE_AUTHORITY_ARN"
)

// DeletableCertificateBasedAuthProperty_Values returns all elements of the DeletableCertificateBasedAuthProperty enum
func DeletableCertificateBasedAuthProperty_Values() []string {
	return []string{
		DeletableCertificateBasedAuthPropertyCertificateBasedAuthPropertiesCertificateAuthorityArn,
	}
}

const (
	// DeletableSamlPropertySamlPropertiesUserAccessUrl is a DeletableSamlProperty enum value
	DeletableSamlPropertySamlPropertiesUserAccessUrl = "SAML_PROPERTIES_USER_ACCESS_URL"

	// DeletableSamlPropertySamlPropertiesRelayStateParameterName is a DeletableSamlProperty enum value
	DeletableSamlPropertySamlPropertiesRelayStateParameterName = "SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME"
)

// DeletableSamlProperty_Values returns all elements of the DeletableSamlProperty enum
func DeletableSamlProperty_Values() []string {
	return []string{
		DeletableSamlPropertySamlPropertiesUserAccessUrl,
		DeletableSamlPropertySamlPropertiesRelayStateParameterName,
	}
}

const (
	// DescribeWorkspacesPoolsFilterNamePoolName is a DescribeWorkspacesPoolsFilterName enum value
	DescribeWorkspacesPoolsFilterNamePoolName = "PoolName"
)

// DescribeWorkspacesPoolsFilterName_Values returns all elements of the DescribeWorkspacesPoolsFilterName enum
func DescribeWorkspacesPoolsFilterName_Values() []string {
	return []string{
		DescribeWorkspacesPoolsFilterNamePoolName,
	}
}

const (
	// DescribeWorkspacesPoolsFilterOperatorEquals is a DescribeWorkspacesPoolsFilterOperator enum value
	DescribeWorkspacesPoolsFilterOperatorEquals = "EQUALS"

	// DescribeWorkspacesPoolsFilterOperatorNotequals is a DescribeWorkspacesPoolsFilterOperator enum value
	DescribeWorkspacesPoolsFilterOperatorNotequals = "NOTEQUALS"

	// DescribeWorkspacesPoolsFilterOperatorContains is a DescribeWorkspacesPoolsFilterOperator enum value
	DescribeWorkspacesPoolsFilterOperatorContains = "CONTAINS"

	// DescribeWorkspacesPoolsFilterOperatorNotcontains is a DescribeWorkspacesPoolsFilterOperator enum value
	DescribeWorkspacesPoolsFilterOperatorNotcontains = "NOTCONTAINS"
)

// DescribeWorkspacesPoolsFilterOperator_Values returns all elements of the DescribeWorkspacesPoolsFilterOperator enum
func DescribeWorkspacesPoolsFilterOperator_Values() []string {
	return []string{
		DescribeWorkspacesPoolsFilterOperatorEquals,
		DescribeWorkspacesPoolsFilterOperatorNotequals,
		DescribeWorkspacesPoolsFilterOperatorContains,
		DescribeWorkspacesPoolsFilterOperatorNotcontains,
	}
}

const (
	// ImageAssociatedResourceTypeApplication is a ImageAssociatedResourceType enum value
	ImageAssociatedResourceTypeApplication = "APPLICATION"
)

// ImageAssociatedResourceType_Values returns all elements of the ImageAssociatedResourceType enum
func ImageAssociatedResourceType_Values() []string {
	return []string{
		ImageAssociatedResourceTypeApplication,
	}
}

const (
	// ImageTypeOwned is a ImageType enum value
	ImageTypeOwned = "OWNED"

	// ImageTypeShared is a ImageType enum value
	ImageTypeShared = "SHARED"
)

// ImageType_Values returns all elements of the ImageType enum
func ImageType_Values() []string {
	return []string{
		ImageTypeOwned,
		ImageTypeShared,
	}
}

const (
	// LogUploadEnumEnabled is a LogUploadEnum enum value
	LogUploadEnumEnabled = "ENABLED"

	// LogUploadEnumDisabled is a LogUploadEnum enum value
	LogUploadEnumDisabled = "DISABLED"
)

// LogUploadEnum_Values returns all elements of the LogUploadEnum enum
func LogUploadEnum_Values() []string {
	return []string{
		LogUploadEnumEnabled,
		LogUploadEnumDisabled,
	}
}

const (
	// ModificationResourceEnumRootVolume is a ModificationResourceEnum enum value
	ModificationResourceEnumRootVolume = "ROOT_VOLUME"

	// ModificationResourceEnumUserVolume is a ModificationResourceEnum enum value
	ModificationResourceEnumUserVolume = "USER_VOLUME"

	// ModificationResourceEnumComputeType is a ModificationResourceEnum enum value
	ModificationResourceEnumComputeType = "COMPUTE_TYPE"
)

// ModificationResourceEnum_Values returns all elements of the ModificationResourceEnum enum
func ModificationResourceEnum_Values() []string {
	return []string{
		ModificationResourceEnumRootVolume,
		ModificationResourceEnumUserVolume,
		ModificationResourceEnumComputeType,
	}
}

const (
	// ModificationStateEnumUpdateInitiated is a ModificationStateEnum enum value
	ModificationStateEnumUpdateInitiated = "UPDATE_INITIATED"

	// ModificationStateEnumUpdateInProgress is a ModificationStateEnum enum value
	ModificationStateEnumUpdateInProgress = "UPDATE_IN_PROGRESS"
)

// ModificationStateEnum_Values returns all elements of the ModificationStateEnum enum
func ModificationStateEnum_Values() []string {
	return []string{
		ModificationStateEnumUpdateInitiated,
		ModificationStateEnumUpdateInProgress,
	}
}

const (
	// OperatingSystemNameAmazonLinux2 is a OperatingSystemName enum value
	OperatingSystemNameAmazonLinux2 = "AMAZON_LINUX_2"

	// OperatingSystemNameUbuntu1804 is a OperatingSystemName enum value
	OperatingSystemNameUbuntu1804 = "UBUNTU_18_04"

	// OperatingSystemNameUbuntu2004 is a OperatingSystemName enum value
	OperatingSystemNameUbuntu2004 = "UBUNTU_20_04"

	// OperatingSystemNameUbuntu2204 is a OperatingSystemName enum value
	OperatingSystemNameUbuntu2204 = "UBUNTU_22_04"

	// OperatingSystemNameUnknown is a OperatingSystemName enum value
	OperatingSystemNameUnknown = "UNKNOWN"

	// OperatingSystemNameWindows10 is a OperatingSystemName enum value
	OperatingSystemNameWindows10 = "WINDOWS_10"

	// OperatingSystemNameWindows11 is a OperatingSystemName enum value
	OperatingSystemNameWindows11 = "WINDOWS_11"

	// OperatingSystemNameWindows7 is a OperatingSystemName enum value
	OperatingSystemNameWindows7 = "WINDOWS_7"

	// OperatingSystemNameWindowsServer2016 is a OperatingSystemName enum value
	OperatingSystemNameWindowsServer2016 = "WINDOWS_SERVER_2016"

	// OperatingSystemNameWindowsServer2019 is a OperatingSystemName enum value
	OperatingSystemNameWindowsServer2019 = "WINDOWS_SERVER_2019"

	// OperatingSystemNameWindowsServer2022 is a OperatingSystemName enum value
	OperatingSystemNameWindowsServer2022 = "WINDOWS_SERVER_2022"

	// OperatingSystemNameRhel8 is a OperatingSystemName enum value
	OperatingSystemNameRhel8 = "RHEL_8"
)

// OperatingSystemName_Values returns all elements of the OperatingSystemName enum
func OperatingSystemName_Values() []string {
	return []string{
		OperatingSystemNameAmazonLinux2,
		OperatingSystemNameUbuntu1804,
		OperatingSystemNameUbuntu2004,
		OperatingSystemNameUbuntu2204,
		OperatingSystemNameUnknown,
		OperatingSystemNameWindows10,
		OperatingSystemNameWindows11,
		OperatingSystemNameWindows7,
		OperatingSystemNameWindowsServer2016,
		OperatingSystemNameWindowsServer2019,
		OperatingSystemNameWindowsServer2022,
		OperatingSystemNameRhel8,
	}
}

const (
	// OperatingSystemTypeWindows is a OperatingSystemType enum value
	OperatingSystemTypeWindows = "WINDOWS"

	// OperatingSystemTypeLinux is a OperatingSystemType enum value
	OperatingSystemTypeLinux = "LINUX"
)

// OperatingSystemType_Values returns all elements of the OperatingSystemType enum
func OperatingSystemType_Values() []string {
	return []string{
		OperatingSystemTypeWindows,
		OperatingSystemTypeLinux,
	}
}

const (
	// ProtocolPcoip is a Protocol enum value
	ProtocolPcoip = "PCOIP"

	// ProtocolWsp is a Protocol enum value
	ProtocolWsp = "WSP"
)

// Protocol_Values returns all elements of the Protocol enum
func Protocol_Values() []string {
	return []string{
		ProtocolPcoip,
		ProtocolWsp,
	}
}

const (
	// ReconnectEnumEnabled is a ReconnectEnum enum value
	ReconnectEnumEnabled = "ENABLED"

	// ReconnectEnumDisabled is a ReconnectEnum enum value
	ReconnectEnumDisabled = "DISABLED"
)

// ReconnectEnum_Values returns all elements of the ReconnectEnum enum
func ReconnectEnum_Values() []string {
	return []string{
		ReconnectEnumEnabled,
		ReconnectEnumDisabled,
	}
}

const (
	// RunningModeAutoStop is a RunningMode enum value
	RunningModeAutoStop = "AUTO_STOP"

	// RunningModeAlwaysOn is a RunningMode enum value
	RunningModeAlwaysOn = "ALWAYS_ON"

	// RunningModeManual is a RunningMode enum value
	RunningModeManual = "MANUAL"
)

// RunningMode_Values returns all elements of the RunningMode enum
func RunningMode_Values() []string {
	return []string{
		RunningModeAutoStop,
		RunningModeAlwaysOn,
		RunningModeManual,
	}
}

const (
	// SamlStatusEnumDisabled is a SamlStatusEnum enum value
	SamlStatusEnumDisabled = "DISABLED"

	// SamlStatusEnumEnabled is a SamlStatusEnum enum value
	SamlStatusEnumEnabled = "ENABLED"

	// SamlStatusEnumEnabledWithDirectoryLoginFallback is a SamlStatusEnum enum value
	SamlStatusEnumEnabledWithDirectoryLoginFallback = "ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK"
)

// SamlStatusEnum_Values returns all elements of the SamlStatusEnum enum
func SamlStatusEnum_Values() []string {
	return []string{
		SamlStatusEnumDisabled,
		SamlStatusEnumEnabled,
		SamlStatusEnumEnabledWithDirectoryLoginFallback,
	}
}

const (
	// SessionConnectionStateConnected is a SessionConnectionState enum value
	SessionConnectionStateConnected = "CONNECTED"

	// SessionConnectionStateNotConnected is a SessionConnectionState enum value
	SessionConnectionStateNotConnected = "NOT_CONNECTED"
)

// SessionConnectionState_Values returns all elements of the SessionConnectionState enum
func SessionConnectionState_Values() []string {
	return []string{
		SessionConnectionStateConnected,
		SessionConnectionStateNotConnected,
	}
}

const (
	// StandbyWorkspaceRelationshipTypePrimary is a StandbyWorkspaceRelationshipType enum value
	StandbyWorkspaceRelationshipTypePrimary = "PRIMARY"

	// StandbyWorkspaceRelationshipTypeStandby is a StandbyWorkspaceRelationshipType enum value
	StandbyWorkspaceRelationshipTypeStandby = "STANDBY"
)

// StandbyWorkspaceRelationshipType_Values returns all elements of the StandbyWorkspaceRelationshipType enum
func StandbyWorkspaceRelationshipType_Values() []string {
	return []string{
		StandbyWorkspaceRelationshipTypePrimary,
		StandbyWorkspaceRelationshipTypeStandby,
	}
}

const (
	// StorageConnectorStatusEnumEnabled is a StorageConnectorStatusEnum enum value
	StorageConnectorStatusEnumEnabled = "ENABLED"

	// StorageConnectorStatusEnumDisabled is a StorageConnectorStatusEnum enum value
	StorageConnectorStatusEnumDisabled = "DISABLED"
)

// StorageConnectorStatusEnum_Values returns all elements of the StorageConnectorStatusEnum enum
func StorageConnectorStatusEnum_Values() []string {
	return []string{
		StorageConnectorStatusEnumEnabled,
		StorageConnectorStatusEnumDisabled,
	}
}

const (
	// StorageConnectorTypeEnumHomeFolder is a StorageConnectorTypeEnum enum value
	StorageConnectorTypeEnumHomeFolder = "HOME_FOLDER"
)

// StorageConnectorTypeEnum_Values returns all elements of the StorageConnectorTypeEnum enum
func StorageConnectorTypeEnum_Values() []string {
	return []string{
		StorageConnectorTypeEnumHomeFolder,
	}
}

const (
	// StreamingExperiencePreferredProtocolEnumTcp is a StreamingExperiencePreferredProtocolEnum enum value
	StreamingExperiencePreferredProtocolEnumTcp = "TCP"

	// StreamingExperiencePreferredProtocolEnumUdp is a StreamingExperiencePreferredProtocolEnum enum value
	StreamingExperiencePreferredProtocolEnumUdp = "UDP"
)

// StreamingExperiencePreferredProtocolEnum_Values returns all elements of the StreamingExperiencePreferredProtocolEnum enum
func StreamingExperiencePreferredProtocolEnum_Values() []string {
	return []string{
		StreamingExperiencePreferredProtocolEnumTcp,
		StreamingExperiencePreferredProtocolEnumUdp,
	}
}

const (
	// TargetWorkspaceStateAvailable is a TargetWorkspaceState enum value
	TargetWorkspaceStateAvailable = "AVAILABLE"

	// TargetWorkspaceStateAdminMaintenance is a TargetWorkspaceState enum value
	TargetWorkspaceStateAdminMaintenance = "ADMIN_MAINTENANCE"
)

// TargetWorkspaceState_Values returns all elements of the TargetWorkspaceState enum
func TargetWorkspaceState_Values() []string {
	return []string{
		TargetWorkspaceStateAvailable,
		TargetWorkspaceStateAdminMaintenance,
	}
}

const (
	// TenancyDedicated is a Tenancy enum value
	TenancyDedicated = "DEDICATED"

	// TenancyShared is a Tenancy enum value
	TenancyShared = "SHARED"
)

// Tenancy_Values returns all elements of the Tenancy enum
func Tenancy_Values() []string {
	return []string{
		TenancyDedicated,
		TenancyShared,
	}
}

const (
	// UserIdentityTypeCustomerManaged is a UserIdentityType enum value
	UserIdentityTypeCustomerManaged = "CUSTOMER_MANAGED"

	// UserIdentityTypeAwsDirectoryService is a UserIdentityType enum value
	UserIdentityTypeAwsDirectoryService = "AWS_DIRECTORY_SERVICE"
)

// UserIdentityType_Values returns all elements of the UserIdentityType enum
func UserIdentityType_Values() []string {
	return []string{
		UserIdentityTypeCustomerManaged,
		UserIdentityTypeAwsDirectoryService,
	}
}

const (
	// UserSettingActionEnumClipboardCopyFromLocalDevice is a UserSettingActionEnum enum value
	UserSettingActionEnumClipboardCopyFromLocalDevice = "CLIPBOARD_COPY_FROM_LOCAL_DEVICE"

	// UserSettingActionEnumClipboardCopyToLocalDevice is a UserSettingActionEnum enum value
	UserSettingActionEnumClipboardCopyToLocalDevice = "CLIPBOARD_COPY_TO_LOCAL_DEVICE"

	// UserSettingActionEnumPrintingToLocalDevice is a UserSettingActionEnum enum value
	UserSettingActionEnumPrintingToLocalDevice = "PRINTING_TO_LOCAL_DEVICE"

	// UserSettingActionEnumSmartCard is a UserSettingActionEnum enum value
	UserSettingActionEnumSmartCard = "SMART_CARD"
)

// UserSettingActionEnum_Values returns all elements of the UserSettingActionEnum enum
func UserSettingActionEnum_Values() []string {
	return []string{
		UserSettingActionEnumClipboardCopyFromLocalDevice,
		UserSettingActionEnumClipboardCopyToLocalDevice,
		UserSettingActionEnumPrintingToLocalDevice,
		UserSettingActionEnumSmartCard,
	}
}

const (
	// UserSettingPermissionEnumEnabled is a UserSettingPermissionEnum enum value
	UserSettingPermissionEnumEnabled = "ENABLED"

	// UserSettingPermissionEnumDisabled is a UserSettingPermissionEnum enum value
	UserSettingPermissionEnumDisabled = "DISABLED"
)

// UserSettingPermissionEnum_Values returns all elements of the UserSettingPermissionEnum enum
func UserSettingPermissionEnum_Values() []string {
	return []string{
		UserSettingPermissionEnumEnabled,
		UserSettingPermissionEnumDisabled,
	}
}

const (
	// WorkSpaceApplicationLicenseTypeLicensed is a WorkSpaceApplicationLicenseType enum value
	WorkSpaceApplicationLicenseTypeLicensed = "LICENSED"

	// WorkSpaceApplicationLicenseTypeUnlicensed is a WorkSpaceApplicationLicenseType enum value
	WorkSpaceApplicationLicenseTypeUnlicensed = "UNLICENSED"
)

// WorkSpaceApplicationLicenseType_Values returns all elements of the WorkSpaceApplicationLicenseType enum
func WorkSpaceApplicationLicenseType_Values() []string {
	return []string{
		WorkSpaceApplicationLicenseTypeLicensed,
		WorkSpaceApplicationLicenseTypeUnlicensed,
	}
}

const (
	// WorkSpaceApplicationStatePending is a WorkSpaceApplicationState enum value
	WorkSpaceApplicationStatePending = "PENDING"

	// WorkSpaceApplicationStateError is a WorkSpaceApplicationState enum value
	WorkSpaceApplicationStateError = "ERROR"

	// WorkSpaceApplicationStateAvailable is a WorkSpaceApplicationState enum value
	WorkSpaceApplicationStateAvailable = "AVAILABLE"

	// WorkSpaceApplicationStateUninstallOnly is a WorkSpaceApplicationState enum value
	WorkSpaceApplicationStateUninstallOnly = "UNINSTALL_ONLY"
)

// WorkSpaceApplicationState_Values returns all elements of the WorkSpaceApplicationState enum
func WorkSpaceApplicationState_Values() []string {
	return []string{
		WorkSpaceApplicationStatePending,
		WorkSpaceApplicationStateError,
		WorkSpaceApplicationStateAvailable,
		WorkSpaceApplicationStateUninstallOnly,
	}
}

const (
	// WorkSpaceAssociatedResourceTypeApplication is a WorkSpaceAssociatedResourceType enum value
	WorkSpaceAssociatedResourceTypeApplication = "APPLICATION"
)

// WorkSpaceAssociatedResourceType_Values returns all elements of the WorkSpaceAssociatedResourceType enum
func WorkSpaceAssociatedResourceType_Values() []string {
	return []string{
		WorkSpaceAssociatedResourceTypeApplication,
	}
}

const (
	// WorkspaceBundleStateAvailable is a WorkspaceBundleState enum value
	WorkspaceBundleStateAvailable = "AVAILABLE"

	// WorkspaceBundleStatePending is a WorkspaceBundleState enum value
	WorkspaceBundleStatePending = "PENDING"

	// WorkspaceBundleStateError is a WorkspaceBundleState enum value
	WorkspaceBundleStateError = "ERROR"
)

// WorkspaceBundleState_Values returns all elements of the WorkspaceBundleState enum
func WorkspaceBundleState_Values() []string {
	return []string{
		WorkspaceBundleStateAvailable,
		WorkspaceBundleStatePending,
		WorkspaceBundleStateError,
	}
}

const (
	// WorkspaceDirectoryStateRegistering is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateRegistering = "REGISTERING"

	// WorkspaceDirectoryStateRegistered is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateRegistered = "REGISTERED"

	// WorkspaceDirectoryStateDeregistering is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateDeregistering = "DEREGISTERING"

	// WorkspaceDirectoryStateDeregistered is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateDeregistered = "DEREGISTERED"

	// WorkspaceDirectoryStateError is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateError = "ERROR"
)

// WorkspaceDirectoryState_Values returns all elements of the WorkspaceDirectoryState enum
func WorkspaceDirectoryState_Values() []string {
	return []string{
		WorkspaceDirectoryStateRegistering,
		WorkspaceDirectoryStateRegistered,
		WorkspaceDirectoryStateDeregistering,
		WorkspaceDirectoryStateDeregistered,
		WorkspaceDirectoryStateError,
	}
}

const (
	// WorkspaceDirectoryTypeSimpleAd is a WorkspaceDirectoryType enum value
	WorkspaceDirectoryTypeSimpleAd = "SIMPLE_AD"

	// WorkspaceDirectoryTypeAdConnector is a WorkspaceDirectoryType enum value
	WorkspaceDirectoryTypeAdConnector = "AD_CONNECTOR"

	// WorkspaceDirectoryTypeCustomerManaged is a WorkspaceDirectoryType enum value
	WorkspaceDirectoryTypeCustomerManaged = "CUSTOMER_MANAGED"
)

// WorkspaceDirectoryType_Values returns all elements of the WorkspaceDirectoryType enum
func WorkspaceDirectoryType_Values() []string {
	return []string{
		WorkspaceDirectoryTypeSimpleAd,
		WorkspaceDirectoryTypeAdConnector,
		WorkspaceDirectoryTypeCustomerManaged,
	}
}

const (
	// WorkspaceImageErrorDetailCodeOutdatedPowershellVersion is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeOutdatedPowershellVersion = "OutdatedPowershellVersion"

	// WorkspaceImageErrorDetailCodeOfficeInstalled is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeOfficeInstalled = "OfficeInstalled"

	// WorkspaceImageErrorDetailCodePcoIpagentInstalled is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodePcoIpagentInstalled = "PCoIPAgentInstalled"

	// WorkspaceImageErrorDetailCodeWindowsUpdatesEnabled is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeWindowsUpdatesEnabled = "WindowsUpdatesEnabled"

	// WorkspaceImageErrorDetailCodeAutoMountDisabled is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeAutoMountDisabled = "AutoMountDisabled"

	// WorkspaceImageErrorDetailCodeWorkspacesByolaccountNotFound is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeWorkspacesByolaccountNotFound = "WorkspacesBYOLAccountNotFound"

	// WorkspaceImageErrorDetailCodeWorkspacesByolaccountDisabled is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeWorkspacesByolaccountDisabled = "WorkspacesBYOLAccountDisabled"

	// WorkspaceImageErrorDetailCodeDhcpdisabled is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeDhcpdisabled = "DHCPDisabled"

	// WorkspaceImageErrorDetailCodeDiskFreeSpace is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeDiskFreeSpace = "DiskFreeSpace"

	// WorkspaceImageErrorDetailCodeAdditionalDrivesAttached is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeAdditionalDrivesAttached = "AdditionalDrivesAttached"

	// WorkspaceImageErrorDetailCodeOsnotSupported is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeOsnotSupported = "OSNotSupported"

	// WorkspaceImageErrorDetailCodeDomainJoined is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeDomainJoined = "DomainJoined"

	// WorkspaceImageErrorDetailCodeAzureDomainJoined is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeAzureDomainJoined = "AzureDomainJoined"

	// WorkspaceImageErrorDetailCodeFirewallEnabled is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeFirewallEnabled = "FirewallEnabled"

	// WorkspaceImageErrorDetailCodeVmwareToolsInstalled is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeVmwareToolsInstalled = "VMWareToolsInstalled"

	// WorkspaceImageErrorDetailCodeDiskSizeExceeded is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeDiskSizeExceeded = "DiskSizeExceeded"

	// WorkspaceImageErrorDetailCodeIncompatiblePartitioning is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeIncompatiblePartitioning = "IncompatiblePartitioning"

	// WorkspaceImageErrorDetailCodePendingReboot is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodePendingReboot = "PendingReboot"

	// WorkspaceImageErrorDetailCodeAutoLogonEnabled is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeAutoLogonEnabled = "AutoLogonEnabled"

	// WorkspaceImageErrorDetailCodeRealTimeUniversalDisabled is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeRealTimeUniversalDisabled = "RealTimeUniversalDisabled"

	// WorkspaceImageErrorDetailCodeMultipleBootPartition is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeMultipleBootPartition = "MultipleBootPartition"

	// WorkspaceImageErrorDetailCodeRequires64bitOs is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeRequires64bitOs = "Requires64BitOS"

	// WorkspaceImageErrorDetailCodeZeroRearmCount is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeZeroRearmCount = "ZeroRearmCount"

	// WorkspaceImageErrorDetailCodeInPlaceUpgrade is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeInPlaceUpgrade = "InPlaceUpgrade"

	// WorkspaceImageErrorDetailCodeAntiVirusInstalled is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeAntiVirusInstalled = "AntiVirusInstalled"

	// WorkspaceImageErrorDetailCodeUefinotSupported is a WorkspaceImageErrorDetailCode enum value
	WorkspaceImageErrorDetailCodeUefinotSupported = "UEFINotSupported"
)

// WorkspaceImageErrorDetailCode_Values returns all elements of the WorkspaceImageErrorDetailCode enum
func WorkspaceImageErrorDetailCode_Values() []string {
	return []string{
		WorkspaceImageErrorDetailCodeOutdatedPowershellVersion,
		WorkspaceImageErrorDetailCodeOfficeInstalled,
		WorkspaceImageErrorDetailCodePcoIpagentInstalled,
		WorkspaceImageErrorDetailCodeWindowsUpdatesEnabled,
		WorkspaceImageErrorDetailCodeAutoMountDisabled,
		WorkspaceImageErrorDetailCodeWorkspacesByolaccountNotFound,
		WorkspaceImageErrorDetailCodeWorkspacesByolaccountDisabled,
		WorkspaceImageErrorDetailCodeDhcpdisabled,
		WorkspaceImageErrorDetailCodeDiskFreeSpace,
		WorkspaceImageErrorDetailCodeAdditionalDrivesAttached,
		WorkspaceImageErrorDetailCodeOsnotSupported,
		WorkspaceImageErrorDetailCodeDomainJoined,
		WorkspaceImageErrorDetailCodeAzureDomainJoined,
		WorkspaceImageErrorDetailCodeFirewallEnabled,
		WorkspaceImageErrorDetailCodeVmwareToolsInstalled,
		WorkspaceImageErrorDetailCodeDiskSizeExceeded,
		WorkspaceImageErrorDetailCodeIncompatiblePartitioning,
		WorkspaceImageErrorDetailCodePendingReboot,
		WorkspaceImageErrorDetailCodeAutoLogonEnabled,
		WorkspaceImageErrorDetailCodeRealTimeUniversalDisabled,
		WorkspaceImageErrorDetailCodeMultipleBootPartition,
		WorkspaceImageErrorDetailCodeRequires64bitOs,
		WorkspaceImageErrorDetailCodeZeroRearmCount,
		WorkspaceImageErrorDetailCodeInPlaceUpgrade,
		WorkspaceImageErrorDetailCodeAntiVirusInstalled,
		WorkspaceImageErrorDetailCodeUefinotSupported,
	}
}

const (
	// WorkspaceImageIngestionProcessByolRegular is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolRegular = "BYOL_REGULAR"

	// WorkspaceImageIngestionProcessByolGraphics is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolGraphics = "BYOL_GRAPHICS"

	// WorkspaceImageIngestionProcessByolGraphicspro is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolGraphicspro = "BYOL_GRAPHICSPRO"

	// WorkspaceImageIngestionProcessByolGraphicsG4dn is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolGraphicsG4dn = "BYOL_GRAPHICS_G4DN"

	// WorkspaceImageIngestionProcessByolRegularWsp is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolRegularWsp = "BYOL_REGULAR_WSP"

	// WorkspaceImageIngestionProcessByolRegularByop is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolRegularByop = "BYOL_REGULAR_BYOP"

	// WorkspaceImageIngestionProcessByolGraphicsG4dnByop is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolGraphicsG4dnByop = "BYOL_GRAPHICS_G4DN_BYOP"
)

// WorkspaceImageIngestionProcess_Values returns all elements of the WorkspaceImageIngestionProcess enum
func WorkspaceImageIngestionProcess_Values() []string {
	return []string{
		WorkspaceImageIngestionProcessByolRegular,
		WorkspaceImageIngestionProcessByolGraphics,
		WorkspaceImageIngestionProcessByolGraphicspro,
		WorkspaceImageIngestionProcessByolGraphicsG4dn,
		WorkspaceImageIngestionProcessByolRegularWsp,
		WorkspaceImageIngestionProcessByolRegularByop,
		WorkspaceImageIngestionProcessByolGraphicsG4dnByop,
	}
}

const (
	// WorkspaceImageRequiredTenancyDefault is a WorkspaceImageRequiredTenancy enum value
	WorkspaceImageRequiredTenancyDefault = "DEFAULT"

	// WorkspaceImageRequiredTenancyDedicated is a WorkspaceImageRequiredTenancy enum value
	WorkspaceImageRequiredTenancyDedicated = "DEDICATED"
)

// WorkspaceImageRequiredTenancy_Values returns all elements of the WorkspaceImageRequiredTenancy enum
func WorkspaceImageRequiredTenancy_Values() []string {
	return []string{
		WorkspaceImageRequiredTenancyDefault,
		WorkspaceImageRequiredTenancyDedicated,
	}
}

const (
	// WorkspaceImageStateAvailable is a WorkspaceImageState enum value
	WorkspaceImageStateAvailable = "AVAILABLE"

	// WorkspaceImageStatePending is a WorkspaceImageState enum value
	WorkspaceImageStatePending = "PENDING"

	// WorkspaceImageStateError is a WorkspaceImageState enum value
	WorkspaceImageStateError = "ERROR"
)

// WorkspaceImageState_Values returns all elements of the WorkspaceImageState enum
func WorkspaceImageState_Values() []string {
	return []string{
		WorkspaceImageStateAvailable,
		WorkspaceImageStatePending,
		WorkspaceImageStateError,
	}
}

const (
	// WorkspaceStatePending is a WorkspaceState enum value
	WorkspaceStatePending = "PENDING"

	// WorkspaceStateAvailable is a WorkspaceState enum value
	WorkspaceStateAvailable = "AVAILABLE"

	// WorkspaceStateImpaired is a WorkspaceState enum value
	WorkspaceStateImpaired = "IMPAIRED"

	// WorkspaceStateUnhealthy is a WorkspaceState enum value
	WorkspaceStateUnhealthy = "UNHEALTHY"

	// WorkspaceStateRebooting is a WorkspaceState enum value
	WorkspaceStateRebooting = "REBOOTING"

	// WorkspaceStateStarting is a WorkspaceState enum value
	WorkspaceStateStarting = "STARTING"

	// WorkspaceStateRebuilding is a WorkspaceState enum value
	WorkspaceStateRebuilding = "REBUILDING"

	// WorkspaceStateRestoring is a WorkspaceState enum value
	WorkspaceStateRestoring = "RESTORING"

	// WorkspaceStateMaintenance is a WorkspaceState enum value
	WorkspaceStateMaintenance = "MAINTENANCE"

	// WorkspaceStateAdminMaintenance is a WorkspaceState enum value
	WorkspaceStateAdminMaintenance = "ADMIN_MAINTENANCE"

	// WorkspaceStateTerminating is a WorkspaceState enum value
	WorkspaceStateTerminating = "TERMINATING"

	// WorkspaceStateTerminated is a WorkspaceState enum value
	WorkspaceStateTerminated = "TERMINATED"

	// WorkspaceStateSuspended is a WorkspaceState enum value
	WorkspaceStateSuspended = "SUSPENDED"

	// WorkspaceStateUpdating is a WorkspaceState enum value
	WorkspaceStateUpdating = "UPDATING"

	// WorkspaceStateStopping is a WorkspaceState enum value
	WorkspaceStateStopping = "STOPPING"

	// WorkspaceStateStopped is a WorkspaceState enum value
	WorkspaceStateStopped = "STOPPED"

	// WorkspaceStateError is a WorkspaceState enum value
	WorkspaceStateError = "ERROR"
)

// WorkspaceState_Values returns all elements of the WorkspaceState enum
func WorkspaceState_Values() []string {
	return []string{
		WorkspaceStatePending,
		WorkspaceStateAvailable,
		WorkspaceStateImpaired,
		WorkspaceStateUnhealthy,
		WorkspaceStateRebooting,
		WorkspaceStateStarting,
		WorkspaceStateRebuilding,
		WorkspaceStateRestoring,
		WorkspaceStateMaintenance,
		WorkspaceStateAdminMaintenance,
		WorkspaceStateTerminating,
		WorkspaceStateTerminated,
		WorkspaceStateSuspended,
		WorkspaceStateUpdating,
		WorkspaceStateStopping,
		WorkspaceStateStopped,
		WorkspaceStateError,
	}
}

const (
	// WorkspaceTypePersonal is a WorkspaceType enum value
	WorkspaceTypePersonal = "PERSONAL"

	// WorkspaceTypePools is a WorkspaceType enum value
	WorkspaceTypePools = "POOLS"
)

// WorkspaceType_Values returns all elements of the WorkspaceType enum
func WorkspaceType_Values() []string {
	return []string{
		WorkspaceTypePersonal,
		WorkspaceTypePools,
	}
}

const (
	// WorkspacesPoolErrorCodeIamServiceRoleIsMissing is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeIamServiceRoleIsMissing = "IAM_SERVICE_ROLE_IS_MISSING"

	// WorkspacesPoolErrorCodeIamServiceRoleMissingEniDescribeAction is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeIamServiceRoleMissingEniDescribeAction = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"

	// WorkspacesPoolErrorCodeIamServiceRoleMissingEniCreateAction is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeIamServiceRoleMissingEniCreateAction = "IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"

	// WorkspacesPoolErrorCodeIamServiceRoleMissingEniDeleteAction is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeIamServiceRoleMissingEniDeleteAction = "IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"

	// WorkspacesPoolErrorCodeNetworkInterfaceLimitExceeded is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeNetworkInterfaceLimitExceeded = "NETWORK_INTERFACE_LIMIT_EXCEEDED"

	// WorkspacesPoolErrorCodeInternalServiceError is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeInternalServiceError = "INTERNAL_SERVICE_ERROR"

	// WorkspacesPoolErrorCodeMachineRoleIsMissing is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeMachineRoleIsMissing = "MACHINE_ROLE_IS_MISSING"

	// WorkspacesPoolErrorCodeStsDisabledInRegion is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeStsDisabledInRegion = "STS_DISABLED_IN_REGION"

	// WorkspacesPoolErrorCodeSubnetHasInsufficientIpAddresses is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeSubnetHasInsufficientIpAddresses = "SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"

	// WorkspacesPoolErrorCodeIamServiceRoleMissingDescribeSubnetAction is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeIamServiceRoleMissingDescribeSubnetAction = "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"

	// WorkspacesPoolErrorCodeSubnetNotFound is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeSubnetNotFound = "SUBNET_NOT_FOUND"

	// WorkspacesPoolErrorCodeImageNotFound is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeImageNotFound = "IMAGE_NOT_FOUND"

	// WorkspacesPoolErrorCodeInvalidSubnetConfiguration is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeInvalidSubnetConfiguration = "INVALID_SUBNET_CONFIGURATION"

	// WorkspacesPoolErrorCodeSecurityGroupsNotFound is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeSecurityGroupsNotFound = "SECURITY_GROUPS_NOT_FOUND"

	// WorkspacesPoolErrorCodeIgwNotAttached is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeIgwNotAttached = "IGW_NOT_ATTACHED"

	// WorkspacesPoolErrorCodeIamServiceRoleMissingDescribeSecurityGroupsAction is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeIamServiceRoleMissingDescribeSecurityGroupsAction = "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"

	// WorkspacesPoolErrorCodeWorkspacesPoolStopped is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeWorkspacesPoolStopped = "WORKSPACES_POOL_STOPPED"

	// WorkspacesPoolErrorCodeWorkspacesPoolInstanceProvisioningFailure is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeWorkspacesPoolInstanceProvisioningFailure = "WORKSPACES_POOL_INSTANCE_PROVISIONING_FAILURE"

	// WorkspacesPoolErrorCodeDomainJoinErrorFileNotFound is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorFileNotFound = "DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"

	// WorkspacesPoolErrorCodeDomainJoinErrorAccessDenied is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorAccessDenied = "DOMAIN_JOIN_ERROR_ACCESS_DENIED"

	// WorkspacesPoolErrorCodeDomainJoinErrorLogonFailure is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorLogonFailure = "DOMAIN_JOIN_ERROR_LOGON_FAILURE"

	// WorkspacesPoolErrorCodeDomainJoinErrorInvalidParameter is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorInvalidParameter = "DOMAIN_JOIN_ERROR_INVALID_PARAMETER"

	// WorkspacesPoolErrorCodeDomainJoinErrorMoreData is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorMoreData = "DOMAIN_JOIN_ERROR_MORE_DATA"

	// WorkspacesPoolErrorCodeDomainJoinErrorNoSuchDomain is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorNoSuchDomain = "DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"

	// WorkspacesPoolErrorCodeDomainJoinErrorNotSupported is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorNotSupported = "DOMAIN_JOIN_ERROR_NOT_SUPPORTED"

	// WorkspacesPoolErrorCodeDomainJoinNerrInvalidWorkgroupName is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinNerrInvalidWorkgroupName = "DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"

	// WorkspacesPoolErrorCodeDomainJoinNerrWorkstationNotStarted is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinNerrWorkstationNotStarted = "DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"

	// WorkspacesPoolErrorCodeDomainJoinErrorDsMachineAccountQuotaExceeded is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorDsMachineAccountQuotaExceeded = "DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"

	// WorkspacesPoolErrorCodeDomainJoinNerrPasswordExpired is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinNerrPasswordExpired = "DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"

	// WorkspacesPoolErrorCodeDomainJoinInternalServiceError is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinInternalServiceError = "DOMAIN_JOIN_INTERNAL_SERVICE_ERROR"

	// WorkspacesPoolErrorCodeDomainJoinErrorSecretActionPermissionIsMissing is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorSecretActionPermissionIsMissing = "DOMAIN_JOIN_ERROR_SECRET_ACTION_PERMISSION_IS_MISSING"

	// WorkspacesPoolErrorCodeDomainJoinErrorSecretDecryptionFailure is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorSecretDecryptionFailure = "DOMAIN_JOIN_ERROR_SECRET_DECRYPTION_FAILURE"

	// WorkspacesPoolErrorCodeDomainJoinErrorSecretStateInvalid is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorSecretStateInvalid = "DOMAIN_JOIN_ERROR_SECRET_STATE_INVALID"

	// WorkspacesPoolErrorCodeDomainJoinErrorSecretNotFound is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorSecretNotFound = "DOMAIN_JOIN_ERROR_SECRET_NOT_FOUND"

	// WorkspacesPoolErrorCodeDomainJoinErrorSecretValueKeyNotFound is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorSecretValueKeyNotFound = "DOMAIN_JOIN_ERROR_SECRET_VALUE_KEY_NOT_FOUND"

	// WorkspacesPoolErrorCodeDomainJoinErrorSecretInvalid is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDomainJoinErrorSecretInvalid = "DOMAIN_JOIN_ERROR_SECRET_INVALID"

	// WorkspacesPoolErrorCodeBundleNotFound is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeBundleNotFound = "BUNDLE_NOT_FOUND"

	// WorkspacesPoolErrorCodeDirectoryNotFound is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDirectoryNotFound = "DIRECTORY_NOT_FOUND"

	// WorkspacesPoolErrorCodeInsufficientPermissionsError is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeInsufficientPermissionsError = "INSUFFICIENT_PERMISSIONS_ERROR"

	// WorkspacesPoolErrorCodeDefaultOuIsMissing is a WorkspacesPoolErrorCode enum value
	WorkspacesPoolErrorCodeDefaultOuIsMissing = "DEFAULT_OU_IS_MISSING"
)

// WorkspacesPoolErrorCode_Values returns all elements of the WorkspacesPoolErrorCode enum
func WorkspacesPoolErrorCode_Values() []string {
	return []string{
		WorkspacesPoolErrorCodeIamServiceRoleIsMissing,
		WorkspacesPoolErrorCodeIamServiceRoleMissingEniDescribeAction,
		WorkspacesPoolErrorCodeIamServiceRoleMissingEniCreateAction,
		WorkspacesPoolErrorCodeIamServiceRoleMissingEniDeleteAction,
		WorkspacesPoolErrorCodeNetworkInterfaceLimitExceeded,
		WorkspacesPoolErrorCodeInternalServiceError,
		WorkspacesPoolErrorCodeMachineRoleIsMissing,
		WorkspacesPoolErrorCodeStsDisabledInRegion,
		WorkspacesPoolErrorCodeSubnetHasInsufficientIpAddresses,
		WorkspacesPoolErrorCodeIamServiceRoleMissingDescribeSubnetAction,
		WorkspacesPoolErrorCodeSubnetNotFound,
		WorkspacesPoolErrorCodeImageNotFound,
		WorkspacesPoolErrorCodeInvalidSubnetConfiguration,
		WorkspacesPoolErrorCodeSecurityGroupsNotFound,
		WorkspacesPoolErrorCodeIgwNotAttached,
		WorkspacesPoolErrorCodeIamServiceRoleMissingDescribeSecurityGroupsAction,
		WorkspacesPoolErrorCodeWorkspacesPoolStopped,
		WorkspacesPoolErrorCodeWorkspacesPoolInstanceProvisioningFailure,
		WorkspacesPoolErrorCodeDomainJoinErrorFileNotFound,
		WorkspacesPoolErrorCodeDomainJoinErrorAccessDenied,
		WorkspacesPoolErrorCodeDomainJoinErrorLogonFailure,
		WorkspacesPoolErrorCodeDomainJoinErrorInvalidParameter,
		WorkspacesPoolErrorCodeDomainJoinErrorMoreData,
		WorkspacesPoolErrorCodeDomainJoinErrorNoSuchDomain,
		WorkspacesPoolErrorCodeDomainJoinErrorNotSupported,
		WorkspacesPoolErrorCodeDomainJoinNerrInvalidWorkgroupName,
		WorkspacesPoolErrorCodeDomainJoinNerrWorkstationNotStarted,
		WorkspacesPoolErrorCodeDomainJoinErrorDsMachineAccountQuotaExceeded,
		WorkspacesPoolErrorCodeDomainJoinNerrPasswordExpired,
		WorkspacesPoolErrorCodeDomainJoinInternalServiceError,
		WorkspacesPoolErrorCodeDomainJoinErrorSecretActionPermissionIsMissing,
		WorkspacesPoolErrorCodeDomainJoinErrorSecretDecryptionFailure,
		WorkspacesPoolErrorCodeDomainJoinErrorSecretStateInvalid,
		WorkspacesPoolErrorCodeDomainJoinErrorSecretNotFound,
		WorkspacesPoolErrorCodeDomainJoinErrorSecretValueKeyNotFound,
		WorkspacesPoolErrorCodeDomainJoinErrorSecretInvalid,
		WorkspacesPoolErrorCodeBundleNotFound,
		WorkspacesPoolErrorCodeDirectoryNotFound,
		WorkspacesPoolErrorCodeInsufficientPermissionsError,
		WorkspacesPoolErrorCodeDefaultOuIsMissing,
	}
}

const (
	// WorkspacesPoolStateCreating is a WorkspacesPoolState enum value
	WorkspacesPoolStateCreating = "CREATING"

	// WorkspacesPoolStateDeleting is a WorkspacesPoolState enum value
	WorkspacesPoolStateDeleting = "DELETING"

	// WorkspacesPoolStateRunning is a WorkspacesPoolState enum value
	WorkspacesPoolStateRunning = "RUNNING"

	// WorkspacesPoolStateStarting is a WorkspacesPoolState enum value
	WorkspacesPoolStateStarting = "STARTING"

	// WorkspacesPoolStateStopped is a WorkspacesPoolState enum value
	WorkspacesPoolStateStopped = "STOPPED"

	// WorkspacesPoolStateStopping is a WorkspacesPoolState enum value
	WorkspacesPoolStateStopping = "STOPPING"

	// WorkspacesPoolStateUpdating is a WorkspacesPoolState enum value
	WorkspacesPoolStateUpdating = "UPDATING"
)

// WorkspacesPoolState_Values returns all elements of the WorkspacesPoolState enum
func WorkspacesPoolState_Values() []string {
	return []string{
		WorkspacesPoolStateCreating,
		WorkspacesPoolStateDeleting,
		WorkspacesPoolStateRunning,
		WorkspacesPoolStateStarting,
		WorkspacesPoolStateStopped,
		WorkspacesPoolStateStopping,
		WorkspacesPoolStateUpdating,
	}
}
