searchData={"items":[{"type":"module","title":"dialyzer","doc":"Dialyzer is a **DI**screpancy **A**na**LYZ**er for **ER**lang programs.\n\nDialyzer is a static analysis tool that identifies software\ndiscrepancies, such as definite type errors, code that is unreachable\nbecause of programming errors, and unnecessary tests in single Erlang\nmodules or an entire codebase.\n\nDialyzer starts its analysis from either debug-compiled BEAM code or\nfrom Erlang source code. The file and line number of a discrepancy is\nreported along with an indication of the nature of the discrepancy.\nDialyzer bases its analysis on the concept of success typings,\nensuring sound warnings without false positives.\n\n[](){: #command_line }","ref":"dialyzer.html"},{"type":"module","title":"Using Dialyzer from the Command Line - dialyzer","doc":"This section provides a brief description of the options available\nwhen running Dialyzer from the command line. The same information can\nbe obtained by writing the following in a shell:\n\n```text\ndialyzer --help\n```\n\n_Exit status of the command-line version:_\n\n- **`0`** - No problems were found during the analysis and no warnings were\n  emitted.\n\n- **`1`** - Problems were found during the analysis.\n\n- **`2`** - No problems were found during the analysis, but warnings were\n  emitted.\n\n_Usage:_\n\n```text\ndialyzer [--add_to_plt] [--apps applications] [--build_plt]\n         [--check_plt] [-Ddefine]* [-Dname]* [--dump_callgraph file]\n         [--error_location flag] [files_or_dirs] [--fullpath]\n         [--get_warnings] [--help] [-I include_dir]*\n         [--incremental] [--metrics_file] [--no_check_plt] [--no_indentation]\n         [--no_spec] [-o outfile] [--output_plt file] [-pa dir]* [--plt plt]\n         [--plt_info] [--plts plt*] [--quiet] [-r dirs] [--raw]\n         [--remove_from_plt] [--shell] [--src] [--statistics] [--verbose]\n         [--version] [--warning_apps applications] [-Wwarn]*\n```\n\n> #### Note {: .info }\n>\n> \\* denotes that multiple occurrences of the option are possible.\n\n_Options of the command-line version:_\n\n- **`--add_to_plt`** - The PLT is extended to also include the files specified\n  with `-c` and `-r`. Use `--plt` to specify which PLT to start from, and\n  `--output_plt` to specify where to put the PLT. Note that files already\n  included in the PLT will be reanalyzed if they depend on the new files.\n  This option only works for BEAM files, not source files.\n\n- **`--apps applications`** - By default, warnings will be reported to all\n  applications given by `--apps`. However, if `--warning_apps` is used, only\n  those applications given to `--warning_apps` will have warnings reported. All\n  applications given by `--apps`, but not `--warning_apps`, will be analysed to\n  provide context to the analysis, but warnings will not be reported for them.\n  For example, you may want to include libraries you depend on in the analysis\n  with `--apps` so discrepancies in their usage can be found, but only include\n  your own code with `--warning_apps` so that discrepancies are only reported in\n  code that you own.\n\n- **`--warning_apps applications`** - This option is typically used when\n  building or modifying a PLT as in:\n\n  ```text\n  dialyzer --build_plt --apps erts kernel stdlib mnesia ...\n  ```\n\n  to refer conveniently to library applications corresponding to the\n  Erlang/OTP installation. This option can also be used during\n  analysis to refer to Erlang/OTP applications. File or directory\n  names can also be included, as in:\n\n  ```text\n  dialyzer --apps inets ssl ./ebin ../other_lib/ebin/my_module.beam\n  ```\n\n- **`--build_plt`** - The analysis starts from an empty PLT and creates a new\n  one from the files specified with `-c` and `-r`. This option only works for\n  BEAM files. To override the default PLT location, use `--plt` or\n  `--output_plt`.\n\n- **`--check_plt`** - Check the PLT for consistency and rebuild it if it is not\n  up-to-date.\n\n- **`-Dname` (or `-Dname=value`)** - When analyzing from source, pass the define\n  to Dialyzer. (\\*\\*)\n\n- **`--dump_callgraph file`** - Dump the call graph into the specified file\n  whose format is determined by the filename extension. Supported extensions\n  are: `raw`, `dot`, and `ps`. If something else is used as filename extension,\n  the default `.raw` format is used.\n\n- **`--error_location column | line`{: #error_location }** - Use a pair\n  `{Line, Column}` or an integer `Line` to pinpoint the location of warnings.\n  The default is to use a pair `{Line, Column}`. When formatted, the line and\n  the column are separated by a colon.\n\n- **`files_or_dirs` (for backward compatibility also as `-c files_or_dirs`)** -\n  Use Dialyzer from the command line to detect defects in the specified files or\n  directories containing `.erl` or `.beam` files, depending on the type of the\n  analysis.\n\n- **`--fullpath`** - Display the full path names of files for which warnings are\n  emitted.\n\n- **`--get_warnings`** - Make Dialyzer emit warnings even when manipulating the\n  PLT. Warnings are only emitted for files that are analyzed.\n\n- **`--help` (or `-h`)** - Print a help message and exit.\n\n- **`-I include_dir`** - When analyzing from source, pass the `include_dir` to\n  Dialyzer. (\\*\\*)\n\n- **`--input_list_file file`** - Analyze the file names that are listed in the\n  specified file (one file name per line).\n\n- **`--no_check_plt`** - Skip the PLT check when running Dialyzer. This is\n  useful when working with installed PLTs that never change.\n\n- **`--incremental`** - The analysis starts from an existing incremental PLT, or\n  builds one from scratch if one does not exist, and runs the minimal amount of\n  additional analysis to report all issues in the given set of apps. Notably,\n  incremental PLT files are not compatible with \"classic\" PLT files, and vice\n  versa. The initial incremental PLT will be updated unless an alternative\n  output incremental PLT is given.\n\n- **`--no_indentation`** - Do not insert line breaks in types, contracts, and\n  Erlang Code when formatting warnings.\n\n- **`--no_spec`** - Ignore functions specs. This is useful for debugging when\n  one suspects that some specs are incorrect.\n\n- **`-o outfile` (or `--output outfile`)** - When using Dialyzer from the\n  command line, send the analysis results to the specified outfile rather than\n  to `stdout`.\n\n- **`--metrics_file file`** - Write metrics about Dialyzer's incrementality (for\n  example, total number of modules considered, how many modules were changed\n  since the PLT was last updated, how many modules needed to be analyzed) to a\n  file. This can be useful for tracking and debugging Dialyzer's incrementality.\n\n- **`--output_plt file`** - Store the PLT at the specified file after building\n  it.\n\n- **`-pa dir`** - Include `dir` in the path for Erlang. This is useful when\n  analyzing files that have `-include_lib()` directives.\n\n- **`--plt plt`** - Use the specified PLT as the initial PLT. If the PLT was\n  built during setup, the files are checked for consistency.\n\n- **`--plt_info`** - Make Dialyzer print information about the PLT and then\n  quit. The PLT can be specified with `--plt(s)`.\n\n- **`--plts plt*`** - Merge the specified PLTs to create the initial PLT. This\n  requires that the PLTs are disjoint (that is, do not have any module appearing\n  in more than one PLT). The PLTs are created in the usual way:\n\n  ```text\n  dialyzer --build_plt --output_plt plt_1 files_to_include\n  ...\n  dialyzer --build_plt --output_plt plt_n files_to_include\n  ```\n\n  They can then be used in either of the following ways:\n\n  ```text\n  dialyzer files_to_analyze --plts plt_1 ... plt_n\n  ```\n\n  or\n\n  ```text\n  dialyzer --plts plt_1 ... plt_n -- files_to_analyze\n  ```\n\n  Notice the `--` delimiter in the second case.\n\n- **`--quiet` (or `-q`)** - Make Dialyzer a bit more quiet.\n\n- **`-r dirs`** - Same as `files_or_dirs`, but the specified directories are\n  searched recursively for subdirectories containing `.erl` or `.beam` files in\n  them, depending on the type of analysis.\n\n- **`--raw`** - When using Dialyzer from the command line, output the raw\n  analysis results (Erlang terms) instead of the formatted result. The raw\n  format is easier to post-process (for example, to filter warnings or to output\n  HTML pages).\n\n- **`--remove_from_plt`** - The information from the files specified with `-c`\n  and `-r` is removed from the PLT. Notice that this can cause a reanalysis of\n  the remaining dependent files.\n\n- **`--src`** - Override the default, which is to analyze BEAM files, and\n  analyze starting from Erlang source code instead.\n\n- **`--statistics`** - Print information about the progress of execution\n  (analysis phases, time spent in each, and size of the relative input).\n\n- **`--verbose`** - Make Dialyzer a bit more verbose.\n\n- **`--version` (or `-v`)** - Print the Dialyzer version and some more\n  information and exit.\n\n- **`-Wwarn`** - A family of options that selectively turn on/off warnings. (For\n  help on the names of warnings, use `dialyzer -Whelp`.) Notice that the options\n  can also be specified in the file with a `-dialyzer()` attribute. For details,\n  see section\n  [Requesting or Suppressing Warnings in Source Files](`m:dialyzer#suppression`).\n\n> #### Note {: .info }\n>\n> \\*\\* the syntax of defines and includes is the same as that used by\n> [erlc](`e:erts:erlc_cmd.md`).\n\n[](){: #warning_options }\n\n_Warning options:_\n\n- **`-Werror_handling` (\\*\\*\\*)** - Include warnings for functions that only\n  return by an exception.\n\n- **`-Wextra_return` (\\*\\*\\*)** - Warn about functions whose specification\n  includes types that the function cannot return.\n\n- **`-Wmissing_return` (\\*\\*\\*)** - Warn about functions that return values that\n  are not part of the specification.\n\n- **`-Wno_behaviours`** - Suppress warnings about behavior callbacks that drift\n  from the published recommended interfaces.\n\n- **`-Wno_contracts`** - Suppress warnings about invalid contracts.\n\n- **`-Wno_fail_call`** - Suppress warnings for failing calls.\n\n- **`-Wno_fun_app`** - Suppress warnings for fun applications that will fail.\n\n- **`-Wno_improper_lists`** - Suppress warnings for construction of improper\n  lists.\n\n- **`-Wno_match`** - Suppress warnings for patterns that are unused or cannot\n  match.\n\n- **`-Wno_missing_calls`** - Suppress warnings about calls to missing functions.\n\n- **`-Wno_opaque`** - Suppress warnings for violations of opacity of data types.\n\n- **`-Wno_return`** - Suppress warnings for functions that will never return a\n  value.\n\n- **`-Wno_undefined_callbacks`** - Suppress warnings about behaviors that have\n  no `-callback` attributes for their callbacks.\n\n- **`-Wno_unused`** - Suppress warnings for unused functions.\n\n- **`-Wno_unknown`** - Suppress warnings about unknown functions and types. The\n  default is to warn about unknown functions and types when setting the exit\n  status. When using Dialyzer from Erlang, warnings about unknown functions and\n  types are returned.\n\n- **`-Wunderspecs` (\\*\\*\\*)** - Warn about underspecified functions (the\n  specification is strictly more allowing than the success typing).\n\n- **`-Wunmatched_returns` (\\*\\*\\*)** - Include warnings for function calls that\n  ignore a structured return value or do not match against one of many possible\n  return values. However, no warnings are included if the possible return values\n  are a union of atoms or a union of numbers.\n\nThe following options are also available, but their use is not recommended (they\nare mostly for Dialyzer developers and internal debugging):\n\n- **`-Woverspecs` (\\*\\*\\*)** - Warn about overspecified functions (the\n  specification is strictly less allowing than the success typing).\n\n- **`-Wspecdiffs` (\\*\\*\\*)** - Warn when the specification is different than the\n  success typing.\n\n> #### Note {: .info }\n>\n> \\*\\*\\* denotes options that turn on warnings rather than turning them off.\n\nThe following options are not strictly needed as they specify the\ndefault. They are primarily intended to be used with the `-dialyzer`\nattribute. For an example see section [Requesting or Suppressing\nWarnings in Source Files](`m:dialyzer#suppression`).\n\n- **`-Wno_underspecs`** - Suppress warnings about underspecified functions (the\n  specification is strictly more allowing than the success typing).\n\n- **`-Wno_extra_return`** - Suppress warnings about functions whose\n  specification includes types that the function cannot return.\n\n- **`-Wno_missing_return`** - Suppress warnings about functions that return\n  values that are not part of the specification.","ref":"dialyzer.html#module-using-dialyzer-from-the-command-line"},{"type":"module","title":"Using Dialyzer from Erlang - dialyzer","doc":"Dialyzer can be used directly from Erlang. The options are similar to the ones\ngiven from the command line. See section\n[Using Dialyzer from the Command Line](`m:dialyzer#command_line`).","ref":"dialyzer.html#module-using-dialyzer-from-erlang"},{"type":"module","title":"Default Dialyzer Options - dialyzer","doc":"The (host operating system) environment variable `ERL_COMPILER_OPTIONS` can be\nused to give default Dialyzer options. Its value must be a valid Erlang term. If\nthe value is a list, it is used as is. If it is not a list, it is put into a\nlist.\n\nThe list is appended to any options given to `run/1` or on the command line.\n\nThe list can be retrieved with `compile:env_compiler_options/0`.\n\nCurrently the only option used is the\n[`error_location`](`m:dialyzer#error_location`) option.\n\n_Dialyzer configuration file:_\n\nDialyzer's configuration file may also be used to augment the default options\nand those given directly to the Dialyzer command. It is commonly used to avoid\nrepeating options which would otherwise need to be given explicitly to Dialyzer\non every invocation.\n\nThe location of the configuration file can be set via the `DIALYZER_CONFIG`\nenvironment variable, and defaults to within the `user_config` from\n`filename:basedir/3`.\n\nAn example configuration file's contents might be:\n\n```erlang\n      {incremental,\n        {default_apps,[stdlib,kernel,erts]},\n        {default_warning_apps,[stdlib]}\n      }.\n      {warnings, [no_improper_lists]}.\n      {add_pathsa,[\"/users/samwise/potatoes/ebin\"]}.\n      {add_pathsz,[\"/users/smeagol/fish/ebin\"]}.\n```\n\n[](){: #suppression }","ref":"dialyzer.html#module-default-dialyzer-options"},{"type":"module","title":"Requesting or Suppressing Warnings in Source Files - dialyzer","doc":"Attribute `-dialyzer()` can be used for turning off warnings in a module by\nspecifying functions or warning options. For example, to turn off all warnings\nfor the function `f/0`, include the following line:\n\n```erlang\n-dialyzer({nowarn_function, f/0}).\n```\n\nTo turn off warnings for improper lists, add the following line to the source\nfile:\n\n```text\n-dialyzer(no_improper_lists).\n```\n\nAttribute `-dialyzer()` is allowed after function declarations. Lists of warning\noptions or functions are allowed:\n\n```erlang\n-dialyzer([{nowarn_function, [f/0]}, no_improper_lists]).\n```\n\nWarning options can be restricted to functions:\n\n```erlang\n-dialyzer({no_improper_lists, g/0}).\n```\n\n```erlang\n-dialyzer({[no_return, no_match], [g/0, h/0]}).\n```\n\nThe warning option for underspecified functions, `-Wunderspecs`, can result in\nuseful warnings, but often functions with specifications that are strictly more\nallowing than the success typing cannot easily be modified to be less allowing.\nTo turn off the warning for underspecified function `f/0`, include the following\nline:\n\n```erlang\n-dialyzer({no_underspecs, f/0}).\n```\n\nFor help on the warning options, use `dialyzer -Whelp`. The options are also\nenumerated, see type `t:warn_option/0`.\n\nAttribute `-dialyzer()` can also be used for turning on warnings. For example,\nif a module has been fixed regarding unmatched returns, adding the following\nline can help in assuring that no new unmatched return warnings are introduced:\n\n```text\n-dialyzer(unmatched_returns).\n```","ref":"dialyzer.html#module-requesting-or-suppressing-warnings-in-source-files"},{"type":"type","title":"dialyzer.dial_option/0","doc":"Option `from` defaults to `byte_code`. Options `init_plt` and `plts` change the\ndefault.","ref":"dialyzer.html#t:dial_option/0"},{"type":"type","title":"dialyzer.dial_warn_tag/0","doc":"","ref":"dialyzer.html#t:dial_warn_tag/0"},{"type":"type","title":"dialyzer.dial_warning/0","doc":"","ref":"dialyzer.html#t:dial_warning/0"},{"type":"type","title":"dialyzer.error_location/0","doc":"If the value of this option is `line`, an integer `Line` is used as `Location`\nin messages. If the value is `column`, a pair `{Line, Column}` is used as\n`Location`. The default is `column`.","ref":"dialyzer.html#t:error_location/0"},{"type":"type","title":"dialyzer.file_location/0","doc":"","ref":"dialyzer.html#t:file_location/0"},{"type":"type","title":"dialyzer.filename_opt/0","doc":"","ref":"dialyzer.html#t:filename_opt/0"},{"type":"type","title":"dialyzer.format_option/0","doc":"","ref":"dialyzer.html#t:format_option/0"},{"type":"function","title":"dialyzer.format_warning/1","doc":"Get a string from warnings as returned by `run/1`.","ref":"dialyzer.html#format_warning/1"},{"type":"function","title":"dialyzer.format_warning/2","doc":"Get a string from warnings as returned by `run/1`.\n\nIf `indent_opt` is set to `true` (default), line breaks are inserted in types,\ncontracts, and Erlang code to improve readability.\n\nIf `error_location` is set to `column` (default), locations are formatted as\n`Line:Column` if the column number is available, otherwise locations are\nformatted as `Line` even if the column number is available.","ref":"dialyzer.html#format_warning/2"},{"type":"function","title":"dialyzer.plt_info/1","doc":"Returns information about the specified PLT.","ref":"dialyzer.html#plt_info/1"},{"type":"function","title":"dialyzer.run/1","doc":"Run Dialyzer and return warnings.","ref":"dialyzer.html#run/1"},{"type":"type","title":"dialyzer.warn_option/0","doc":"See section [Warning options](`m:dialyzer#warning_options`) for a description of\nthe warning options.","ref":"dialyzer.html#t:warn_option/0"},{"type":"extras","title":"Dialyzer Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Dialyzer Release Notes\n\nThis document describes the changes made to the Dialyzer application.","ref":"notes.html"},{"type":"extras","title":"Dialyzer 5.3.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fixed a crash caused by the use of opaque types.\n\n  Own Id: OTP-19439 Aux Id: ERIERL-1183, [PR-9314]\n\n[PR-9314]: https://github.com/erlang/otp/pull/9314","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 5.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fixed type inference for `erlang:system_info(logical_processors)`.\n\n  Own Id: OTP-19307 Aux Id: [PR-8954], [GH-8948]\n\n- Dialyzer would crash when attempting to analyze a module compiled with the `line_coverage` option.\n\n  Own Id: OTP-19344 Aux Id: [GH-9027], [PR-9034]\n\n[PR-8954]: https://github.com/erlang/otp/pull/8954\n[GH-8948]: https://github.com/erlang/otp/issues/8948\n[GH-9027]: https://github.com/erlang/otp/issues/9027\n[PR-9034]: https://github.com/erlang/otp/pull/9034","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Erlang/OTP type specifications has been updated to eliminate overlapping domains.\n\n  Own Id: OTP-19310 Aux Id: [GH-8810], [GH-8821], [PR-8986]\n\n[GH-8810]: https://github.com/erlang/otp/issues/8810\n[GH-8821]: https://github.com/erlang/otp/issues/8821\n[PR-8986]: https://github.com/erlang/otp/pull/8986","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 5.2.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Man pages are now available for `erl`, `erlc`, `dialyzer`, and all other programs that are included in Erlang/OTP.\n\n  Own Id: OTP-19201 Aux Id: [PR-8740]\n\n[PR-8740]: https://github.com/erlang/otp/pull/8740","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 5.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-2"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The `--gui` option for Dialyzer has been removed.\n\n  Own Id: OTP-18667 Aux Id: [PR-7443]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-7443]: https://github.com/erlang/otp/pull/7443\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 5.1.3.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-1-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"* Fixed a crash caused by the use of opaque types.\n\n  Own Id: OTP-19439 Aux Id: ERIERL-1183, PR-9314","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 5.1.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"* Fixed an issue with bitstring type inference on segments following UTF-8/16/32 segments.\n\n  Own Id: OTP-19068 Aux Id: GH-8383","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 5.1.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix `dialyzer --output` flag to work. This option was accidentally removed in\n  OTP 26.0.\n\n  Own Id: OTP-18767 Aux Id: PR-7657\n\n- Fixed a crash in contract checking relating to opaque types.\n\n  Own Id: OTP-18772 Aux Id: GH-7676","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 5.1.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fixed a bug that caused dialyzer to crash when analyzing bogus code that\n  contained the literal atom `undefined` in segment sizes.\n\n  Own Id: OTP-18629 Aux Id: GH-7325\n\n- Dialyzer could crash when attempting to analyze a module that defined a type\n  called `product/`.\n\n  Own Id: OTP-18738 Aux Id: GH-7584","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 5.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- When checking behaviors, Dialyzer could generate false warning that a callback\n  function did not have the correct type according to the spec in the behavior\n  definition.\n\n  Own Id: OTP-18237 Aux Id: GH-6221, PR-6243\n\n- In a spec, [`list(none())`](`t:list/1`) used to mean `t:none/0`. It has now\n  been corrected to mean the empty list.\n\n  Own Id: OTP-18276 Aux Id: GH-6333\n\n- The compiler would silently accept singleton (unbound) type variables in a\n  union type. Starting from Erlang/OTP 26, the compiler will generate a warning\n  for this example. The warning can be disabled using the\n  `nowarn_singleton_typevar` option. In Erlang/OTP 27, the warning will become\n  an error.\n\n  Own Id: OTP-18389 Aux Id: GH-6508, PR-6864, GH-7116\n\n- Fixed a bug that prevented the `--plts` option from being used together with\n  `--add-to-plt`.\n\n  Own Id: OTP-18485 Aux Id: GH-6850, PR-6854\n\n- Fixed a crash when analyzing code that contained illegal bitstring segment\n  sizes.\n\n  Own Id: OTP-18562\n\n- Fixed a crash when formatting certain warnings that contained multi-byte\n  unicode characters.\n\n  Own Id: OTP-18564 Aux Id: GH-7153","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Dialyzer has a new incremental mode that be invoked by giving the\n  `--incremental` option when running Dialyzer. This new incremental mode is\n  likely to become the default in a future release.\n\n  Incremental mode primarily differs from the previous, \"classic\", ways of\n  running Dialyzer, in that its model is optimised around the common use case of\n  regularly analysing a single codebase, tweaking the code, analysing it again,\n  and so on, without explicit reference to the building and checking of a PLT.\n\n  In this mode the PLT file acts much more like a true cache, where users\n  provide a codebase and a set of files they care about, and Dialyzer does the\n  legwork in terms of deciding how to most efficiently report all of the\n  relevant warnings given the cached results it may already have in the PLT (and\n  if a PLT doesn't exist, incremental mode will create one).\n\n  Own Id: OTP-18188 Aux Id: PR-5997\n\n- Dialyzer now produces clearer error messages for contract violations.\n\n  Own Id: OTP-18238 Aux Id: PR-6271\n\n- The name of a built-in type can now be reused as the name of type locally.\n  That is useful when an OTP release introduces a new built-in type; having the\n  possibility to redefine built-in types locally can make it easier to maintain\n  code that works in multiple OTP releases.\n\n  Own Id: OTP-18282 Aux Id: GH-6132, PR-6335\n\n- There is new option `-no_spec` to ignore all specs. It is useful for debugging\n  when one suspects that some specs could be incorrect.\n\n  Own Id: OTP-18310\n\n- Dialyzer's overloaded domain warning is now disabled by default, and can be\n  enabled with the flag `-Woverlapping_contract`.\n\n  Dialyzer used to issue a warning for overloaded domains stating\n  `\"such contracts are currently unsupported and are simply ignored\"`.\n\n  These contracts are not \"ignored\" but rather, Dialyzer takes the union of the\n  overloaded domains. This means that we lose the dependency from each\n  corresponding input to output type. Because of this, the warning is really\n  about not being able to establish a dependency between the input and output\n  types of each respective overloaded function specification.\n\n  Own Id: OTP-18342 Aux Id: GH-6117, PR-6654\n\n- Dialyzer has enabled (by default) warnings about unknown types and functions.\n\n  Prior to this change, Dialyzer had warnings about unknown types and functions\n  disabled (by default).\n\n  This default value has been overwritten; Dialyzer now warns about unknown\n  types and functions (as requested by the community in GH-5695). Thus, the\n  following two examples are equivalent, i.e., passing the `-Wunknown` function\n  is enabled by default:\n\n  `dialyzer moduler.erl -Wunknown -Wmissing_return`\n\n  `dialyzer moduler.erl -Wmissing_return`\n\n  Dialyzer has a new flag, `-Wno_unknown`. Its purpose is to suppress warnings\n  about unknown functions and types.\n\n  Users who wish to suppress these warnings can invoke Dialyzer using this flag.\n  Example: `dialyzer module.erl -Wno_unknown`\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18439 Aux Id: GH-5695,PR-6822, GH-6942\n\n- Deprecates `dbg:stop_clear/0` because it is simply a function alias to\n  `dbg:stop/0`\n\n  Own Id: OTP-18478 Aux Id: GH-6903\n\n- Added the new built-in type `t:dynamic/0` introduced in EEP-61, improving\n  support for gradual type checkers.\n\n  Own Id: OTP-18522\n\n- Added the `argparse` module for simplified argument handling in escripts and\n  similar.\n\n  Own Id: OTP-18558 Aux Id: PR-6852","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 5.0.5 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-0-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fixed a bug that would cause analysis to crash.\n\n  Own Id: OTP-18372 Aux Id: GH-6580","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Replace size/1 with either tuple_size/1 or byte_size/1\n\n  The [`size/1`](`size/1`) BIF is not optimized by the JIT, and its use can\n  result in worse types for Dialyzer.\n\n  When one knows that the value being tested must be a tuple,\n  [`tuple_size/1`](`tuple_size/1`) should always be preferred.\n\n  When one knows that the value being tested must be a binary,\n  [`byte_size/1`](`byte_size/1`) should be preferred. However,\n  [`byte_size/1`](`byte_size/1`) also accepts a bitstring (rounding up size to a\n  whole number of bytes), so one must make sure that the call to `byte_size/` is\n  preceded by a call to [`is_binary/1`](`is_binary/1`) to ensure that bitstrings\n  are rejected. Note that the compiler removes redundant calls to\n  [`is_binary/1`](`is_binary/1`), so if one is not sure whether previous code\n  had made sure that the argument is a binary, it does not harm to add an\n  [`is_binary/1`](`is_binary/1`) test immediately before the call to\n  [`byte_size/1`](`byte_size/1`).\n\n  Own Id: OTP-18432 Aux Id:\n  GH-6672,PR-6793,PR-6784,PR-6787,PR-6785,PR-6682,PR-6800,PR-6797,PR-6798,PR-6799,PR-6796,PR-6813,PR-6671,PR-6673,PR-6684,PR-6694,GH-6677,PR-6696,PR-6670,PR-6674","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 5.0.4 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Dialyzer would crash when attempting to analyze a bit syntax segment size\n  having an literal non-integer size such as `[]`.\n\n  Own Id: OTP-18307 Aux Id: GH-6419, GH-6473\n\n- Dialyzer could crash when trying to analyze a convoluted nested expression\n  involving funs,\n\n  Own Id: OTP-18347 Aux Id: GH-6518, PR-6525","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 5.0.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Dialyzer could crash when analyzing Elixir code that used intricate macros.\n\n  Own Id: OTP-18262 Aux Id: GH-6323","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The `--input_list_file` option has been added.\n\n  Own Id: OTP-18263 Aux Id: ERIERL-821","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 5.0.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Two bugs have been fixed in Dialyzer's checking of behaviors:\n\n  When a _mandatory_ callback function is present but not exported, Dialyzer\n  would not complain about a missing callback.\n\n  When an _optional_ callback function was not exported and had incompatible\n  arguments and/or the return values were incompatible, Dialyzer would complain.\n  This has been changed to suppress the warning, because the function might not\n  be intended to be a callback function, for instance if a release added a new\n  optional callback function (such as `format_status/1` for the gen_server\n  behaviour added in OTP 25).\n\n  Own Id: OTP-18127 Aux Id: ERIERL-817\n\n- The `no_extra_return` and `no_missing_return` warnings can now be suppressed\n  through `-dialyzer` directives in source code.\n\n  Own Id: OTP-18148 Aux Id: PR-6068","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 5.0.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fixed the documentation for the `missing_return` and `extra_return` options.\n\n  Own Id: OTP-18120","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 5.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-5-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fixed a bug that could cause the type analyzer to enter an infinite loop.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17644 Aux Id: PR-5223","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Optimize operations in the `erl_types` module. Parallelize the Dialyzer pass\n  `remote`.\n\n  Own Id: OTP-17524\n\n- Added the `missing_return` and `extra_return` options to raise warnings when\n  specifications differ from inferred types. These are similar to, but not quite\n  as verbose as `overspecs` and `underspecs`.\n\n  Own Id: OTP-17654 Aux Id: GH-5214\n\n- The `race_conditions` option has been removed.\n\n  Own Id: OTP-17819\n\n- The default location of the plt has been changed from `$HOME` to\n  `filename:basedir(user_cache,\"erlang\")`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17821 Aux Id: GH-5016 PR-5408 OTP-17554\n\n- `dialyzer` will now honor dependencies inside type declarations. That is, if\n  the declaration of an exported type changes, all modules using said type will\n  be revisited.\n\n  Own Id: OTP-17826 Aux Id: PR-5498\n\n- Dialyzer now better understands the types for [`min/2`](`min/2`),\n  [`max/2`](`max/2`), and `erlang:raise/3`. Because of that, Dialyzer can\n  potentially generate new warnings. In particular, functions that use\n  `erlang:raise/3` could now need a spec with a `t:no_return/0` return type to\n  avoid an unwanted warning.\n\n  Own Id: OTP-17897 Aux Id: PR-5651\n\n- The `typer_core` module has been added to provide an Erlang API for running\n  `typer`.\n\n  Own Id: OTP-17964 Aux Id: PR-5660\n\n- Added the `--annotate-in-place` option to `typer`, which can be used to\n  annotate the specs that the tool inferred directly into the source code files.\n\n  Own Id: OTP-18035 Aux Id: PR-5802","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 4.4.4.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-4-4-1"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The `--input_list_file` option has been added.\n\n  Own Id: OTP-18263 Aux Id: ERIERL-821","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 4.4.4 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- There could be spurious warnings for unknown types when a type was a subtype\n  of an existing type that was a subtype of an unknown type.\n\n  Own Id: OTP-17963 Aux Id: GH-5764","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 4.4.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fixed a crash when opaque types contained certain unicode characters.\n\n  Own Id: OTP-17643 Aux Id: GH-5210\n\n- When the compiler is invoked by Dialyzer, it will no longer apply an\n  optimization of binary patterns that would turn the pattern `<<\"bar\">>` into\n  `<<6447474:24>>`, which would be very confusing when printed out by Dialyzer.\n\n  Own Id: OTP-17768 Aux Id: GH-5429","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 4.4.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Do not crash if a PLT file no longer exists.\n\n  Own Id: OTP-17511 Aux Id: GH-4501\n\n- Fix bug in `erl_types` related to maps.\n\n  Own Id: OTP-17537\n\n- Fix bugs in `erl_types` regarding improper lists.\n\n  Own Id: OTP-17541\n\n- The `underspecs` and `overspecs` options will now generate correct warnings\n  for misused opaque types.\n\n  Own Id: OTP-17616 Aux Id: GH-5118","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 4.4.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Do not expose line number `0` in messages if there are other locations to use.\n\n  Own Id: OTP-17443 Aux Id: GH-4890\n\n- In rare circumstances, Dialyzer could crash analyzing code with a list\n  comprehension whose value was ignored. (Thanks to Ulf Wiger for reporting this\n  bug.)\n\n  Own Id: OTP-17482","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 4.4 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-4"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Some internal HiPE modules have been moved into the dialyzer application so\n  that dialyzer works when HiPE is disabled.\n\n  Own Id: OTP-16883\n\n- The experimental HiPE application has been removed, together with all related\n  functionality in other applications.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16963\n\n- Add warning option `no_underspecs`.\n\n  Own Id: OTP-16986 Aux Id: ERL-1379, ERL-1480, GH-4033\n\n- Report filename and location for warnings returned due to the `-Wunknown`\n  option. When used from the command-line, one location per file is printed.\n\n  Own Id: OTP-16995 Aux Id: ERL-1348\n\n- Add types and specifications for documentation.\n\n  Own Id: OTP-17084\n\n- Add option `error_location`. The option is recognized if included in the\n  environment variable ERL_COMPILER_OPTIONS.\n\n  Own Id: OTP-17177 Aux Id: OTP-16824\n\n- Clarify how to declare records used in match patterns.\n\n  Own Id: OTP-17183 Aux Id: ERL-892, GH-4493","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 4.3.1.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-3-1-2"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The `--input_list_file` option has been added.\n\n  Own Id: OTP-18263 Aux Id: ERIERL-821","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 4.3.1.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-3-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- In rare circumstances, Dialyzer could crash analyzing code with a list\n  comprehension whose value was ignored. (Thanks to Ulf Wiger for reporting this\n  bug.)\n\n  Own Id: OTP-17482","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 4.3.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Correct handling of PLTs in the GUI.\n\n  Own Id: OTP-17091","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 4.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-3"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Clarify warning option `-Wunmatched_returns` in `m:dialyzer`.\n\n  Own Id: OTP-17068 Aux Id: ERL-1223","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 4.2.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- In rare circumstance, dialyzer wold crash when analyzing a list comprehension.\n\n  Own Id: OTP-16813 Aux Id: ERL-1307","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 4.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-2"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Improve handling of `maps:remove/2`.\n\n  Own Id: OTP-16055 Aux Id: ERL-1002","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 4.1.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix a bug where warnings about overspecified functions were erroneously\n  emitted. Only overloaded functions were affected by the bug.\n\n  Own Id: OTP-16292","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Remove test data with GNU license.\n\n  Own Id: OTP-16146","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 4.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-1"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Allow native compilation when using Dialyzer from Erlang. The options `native`\n  (defaults to `false`) and `native_cache` have been added.\n\n  Own Id: OTP-15880 Aux Id: PR-2283","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 4.0.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- The HiPE compiler would badly miscompile certain try/catch expressions, so it\n  will now refuse to compile modules containing try or catch.\n\n  As a consequence of this, `dialyzer` will no longer compile key modules to\n  native code.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15949","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 4.0.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Make sure Dialyzer does not crash if the formatting of results fails. Instead\n  of crashing, an unformatted version of the results is returned.\n\n  Own Id: OTP-15922 Aux Id: PR-2240, ERL-949","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 4.0.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix a bug that caused a crash when indenting a Dialyzer warning mentioning\n  more than one record field.\n\n  Own Id: OTP-15861 Aux Id: ERL-953","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 4.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-4-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- All incorrect (that is, all) uses of \"can not\" has been corrected to \"cannot\"\n  in source code comments, documentation, examples, and so on.\n\n  Own Id: OTP-14282 Aux Id: PR-1891","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- By default Dialyzer inserts line breaks in types, contracts, and Erlang Code\n  when formatting results. Use the new `--no_indentation` option to get the old\n  behavior of not inserting line breaks.\n\n  Own Id: OTP-15135\n\n- Use bit syntax in warnings instead of Core Erlang syntax, for readability.\n\n  Own Id: OTP-15752\n\n- The format of the raw analysis result tagged with `fun_app_args` is changed to\n  `{fun_app_args, [ArgNs, Args, Type]}`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15779","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 3.3.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix a bug that caused Dialyzer to crash when analyzing a contract with a\n  module name differing from the analyzed module's name. The bug was introduced\n  in Erlang/OTP 18.\n\n  Own Id: OTP-15562 Aux Id: ERL-845\n\n- Fix a bug in the handling of the `Key` argument of\n  `lists:{keysearch, keyfind, keymember}`.\n\n  Own Id: OTP-15570\n\n- Optimize (again) Dialyzer's handling of left-associative use of `andalso` and\n  `orelse` in guards.\n\n  Own Id: OTP-15577 Aux Id: ERL-851, PR-2141, PR-1944","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 3.3.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-3-1"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Optimize Dialyzer's handling of left-associative use of `andalso` and `orelse`\n  in guards.\n\n  Own Id: OTP-15268 Aux Id: ERL-680","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 3.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-3"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Changed the default behaviour of `.erlang` loading: `.erlang` is no longer\n  loaded from the current directory. `c:erlangrc(PathList)` can be used to\n  search and load an `.erlang` file from user specified directories.\n\n  `escript`, `erlc`, `dialyzer` and `typer` no longer load an `.erlang` at all.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14439\n\n- Dialyzer can no longer read BEAM files created with OTP 19 or earlier.\n\n  Own Id: OTP-14493 Aux Id: PR-1434\n\n- Speed up the computation of MD5 sums.\n\n  Own Id: OTP-14937 Aux Id: PR-1719\n\n- Fix a situation where Dialyzer unnecessarily discarded contract information,\n  resulting in missed warnings.\n\n  Own Id: OTP-14970 Aux Id: PR-1722\n\n- The (not recommended) option `-Woverspecs` is somewhat refined, and generates\n  warnings in a few more cases.\n\n  Own Id: OTP-14982 Aux Id: OTP-14970, PR-1722\n\n- Do not emit warnings for fun expressions residing in code that cannot be run.\n  This is consistent with how Dialyzer treats other code that cannot be run.\n\n  Own Id: OTP-15079 Aux Id: ERL-593","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 3.2.4 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix bugs concerning `erlang:abs/1` and `erlang:bsl/2`.\n\n  Own Id: OTP-14858 Aux Id: ERL-551\n\n- Fix a bug that caused Dialyzer to crash instead of emitting a warning.\n\n  Own Id: OTP-14911\n\n- Fix a bug concerning parameterized opaque types.\n\n  Own Id: OTP-14925 Aux Id: ERL-565","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 3.2.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- The error message returned from Dialyzer when, for example, a modified record\n  field type is not a subtype of the declared type, no longer includes a call\n  stack. The bug was introduced in Erlang/OTP 19.3.\n\n  Own Id: OTP-14742\n\n- A bug relating to maps and never returning functions has been fixed.\n\n  Own Id: OTP-14743","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 3.2.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix a bug regarding map types that caused Dialyzer to go into an infinite\n  loop. A consequence of the fix is that compound map keys such as maps and\n  tuples sometimes are handled with less precision than before.\n\n  Own Id: OTP-14572 Aux Id: seq13319","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- General Unicode improvements.\n\n  Own Id: OTP-14462\n\n- The check for unknown remote types is improved.\n\n  Own Id: OTP-14606 Aux Id: OTP-14218","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 3.2.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix a bug where merging PLT:s could lose info. The bug was introduced in\n  Erlang/OTP 20.0.\n\n  Own Id: OTP-14558 Aux Id: ERIERL-53","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 3.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- The check of bad type variables in type declarations was mistakingly removed\n  in Erlang/OTP 18, and is now re-introduced.\n\n  Own Id: OTP-14423 Aux Id: OTP-14323","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Analyzing modules with binary construction with huge strings is now much\n  faster. The compiler also compiles such modules slightly faster.\n\n  Own Id: OTP-14125 Aux Id: ERL-308\n\n- The peak memory consumption is reduced.\n\n  Own Id: OTP-14127\n\n- Warnings about unknown types are now also generated for types not used by any\n  function specification.\n\n  Own Id: OTP-14218 Aux Id: OTP-14127\n\n- TypEr has been removed as separate application and is now a part of the\n  Dialyzer application. Documentation for TypEr has been added in the Dialyzer\n  application.\n\n  Own Id: OTP-14336\n\n- The format of debug information that is stored in BEAM files (when\n  `debug_info` is used) has been changed. The purpose of the change is to better\n  support other BEAM-based languages such as Elixir or LFE.\n\n  All tools included in OTP (dialyzer, debugger, cover, and so on) will handle\n  both the new format and the previous format. Tools that retrieve the debug\n  information using `beam_lib:chunk(Beam, [abstract_code])` will continue to\n  work with both the new and old format. Tools that call\n  `beam_lib:chunk(Beam, [\"Abst\"])` will not work with the new format.\n\n  For more information, see the description of `debug_info` in the documentation\n  for `beam_lib` and the description of the `{debug_info,{Backend,Data}}` option\n  in the documentation for `compile`.\n\n  Own Id: OTP-14369 Aux Id: PR-1367","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 3.1.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Report unknown types properly. A bug was introduced in Erlang/OTP 19.3, where\n  warnings about unknown types were simply discarded.\n\n  Own Id: OTP-14368","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 3.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix a bug concerning parameterized opaque types.\n\n  Own Id: OTP-14130\n\n- Improve a few warnings. One of them could cause a crash.\n\n  Own Id: OTP-14177\n\n- The dialyzer and observer applications will now use a portable way to find the\n  home directory. That means that there is no longer any need to manually set\n  the HOME environment variable on Windows.\n\n  Own Id: OTP-14249 Aux Id: ERL-161","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The peak memory consumption is reduced.\n\n  The evaluation of huge SCCs in `dialyzer_typesig` is optimized.\n\n  Analyzing modules with binary construction with huge strings is now much\n  faster.\n\n  Own Id: OTP-14126 Aux Id: ERL-308","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 3.0.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix bugs regarding opaque types.\n\n  Own Id: OTP-13693\n\n- Fix error handling of bad `-dialyzer()` attributes.\n\n  Own Id: OTP-13979 Aux Id: ERL-283","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- A few warning messages have been improved.\n\n  Own Id: OTP-11403","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 3.0.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-0-2"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The translation of forms to types is improved for opaque types in a few cases.\n\n  Own Id: OTP-13682\n\n- Add warning suppression to compiler-generated case statements. Warnings about\n  clauses that cannot match and are also compiler generated are suppressed\n  unless none of the clauses return.\n\n  Own Id: OTP-13723 Aux Id: ERL-159, PR-1121","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 3.0.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix a map related bug.\n\n  Own Id: OTP-13709 Aux Id: ERL-177, PR-1115","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 3.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-3-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix a bug in the translation of forms to types.\n\n  Own Id: OTP-13520\n\n- Correct misspelling in Dialyzer's acronym definition.\n\n  Own Id: OTP-13544 Aux Id: PR-1007\n\n- Dialyzer no longer crashes when there is an invalid function call such as\n  `42(7)` in a module being analyzed. The compiler will now warn for invalid\n  function calls such as `X = 42, x(7)`.\n\n  Own Id: OTP-13552 Aux Id: ERL-138\n\n- Fix a bug that caused Dialyzer to go into an infinite loop.\n\n  Own Id: OTP-13653 Aux Id: ERL-157\n\n- Fix a bug in Dialyzer related to call-site analysis.\n\n  Own Id: OTP-13655 Aux Id: PR-1092","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The evaluation of SCCs in `dialyzer_typesig` is optimized.\n\n  Maps are used instead of Dicts to further optimize the evaluation.\n\n  Own Id: OTP-10349\n\n- Since Erlang/OTP R14A, when support for parameterized modules was added,\n  `t:module/0` has included `t:tuple/0`, but that part is removed; the type\n  `t:module/0` is now the same as `t:atom/0`, as documented in the Reference\n  Manual.\n\n  Own Id: OTP-13244\n\n- The type specification syntax for Maps is improved:\n\n  - The association type `KeyType := ValueType` denotes an association that must\n    be present.\n  - The shorthand `...` stands for the association type `any() => any()`.\n\n  An incompatible change is that `#{}` stands for the empty map. The type\n  `t:map/0` (a map of any size) can be written as `#{...}`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13542 Aux Id: PR-1014\n\n- The translation of forms to types is improved.\n\n  Own Id: OTP-13547","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.9 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Dialyzer no longer asserts that files and directories to be removed from a PLT\n  exist.\n\n  Own Id: OTP-13103 Aux Id: ERL-40\n\n- Fix a bug concerning parameterized opaque types.\n\n  Own Id: OTP-13237\n\n- Fix pretty printing of Core Maps\n\n  Literal maps could cause Dialyzer to crash when pretty printing the results.\n\n  Own Id: OTP-13238\n\n- If a behavior module contains an non-exported function with the same name as\n  one of the behavior's callbacks, the callback info was inadvertently deleted\n  from the PLT as the `dialyzer_plt:delete_list/2` function was cleaning up the\n  callback table.\n\n  Own Id: OTP-13287\n\n- Correct the contract for `erlang:byte_size/1`\n\n  Correct the handling of comparison operators for map and bit string operands.\n\n  Own Id: OTP-13312","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Dialyzer recognizes calls to `M:F/A` where `M`, `F`, and `A` are all literals.\n\n  Own Id: OTP-13217","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.8.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-8-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Reintroduce the `erlang:make_fun/3` BIF in erl_bif_types.\n\n  Own Id: OTP-13068","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 2.8.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Improve the translation of forms to types.\n\n  Own Id: OTP-12865\n\n- Fix a bug concerning parameterized opaque types.\n\n  Own Id: OTP-12866\n\n- Fix a bug concerning parameterized opaque types.\n\n  Own Id: OTP-12940\n\n- Fix bugs concerning `erlang:abs/1`.\n\n  Own Id: OTP-12948\n\n- Fix a bug concerning `lists:keydelete/3` with union and opaque types.\n\n  Own Id: OTP-12949\n\n- Use new function `hipe:erts_checksum` to get correct runtime checksum for\n  cached beam files.\n\n  Own Id: OTP-12964 Aux Id: OTP-12963, OTP-12962","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 2.8 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- The translation of Erlang forms to the type representation used by Dialyzer\n  has been improved in several ways. The most important change is that deeply\n  nested records can be handled.\n\n  Own Id: OTP-12350\n\n- Fix a bug that could cause bogus warnings for opaque types.\n\n  In Erlang/OTP 18 two parameterized types declared in the same module always\n  result in a contradiction (`t:none/0`) when combined outside of the module\n  where they are declared, unless they have the same number of parameters.\n\n  The behaviour is different from Erlang/OTP 17 where, for instance,\n  [`dict:dict()`](`t:dict:dict/0`) and [`dict:dict(_, _)`](`t:dict:dict/2`),\n  which are both opaque, can be combined outside of the `dict` module.\n\n  In Erlang/OTP 18, [`dict:dict()`](`t:dict:dict/0`) and\n  [`dict:dict(_, _)`](`t:dict:dict/2`) can still be combined outside of the\n  `dict` module. That has been made possible by not declaring\n  [`dict:dict()`](`t:dict:dict/0`) as opaque.\n\n  Own Id: OTP-12493\n\n- Update the PLT properly when a module is changed. (Thanks to James Fish for\n  the bug report, and to Stavros Aronis for fixing the bug.)\n\n  Own Id: OTP-12637\n\n- An argument of '\\*'/2 is not constraind if the other operand can be zero.\n\n  Own Id: OTP-12725\n\n- Mention the option `check_plt` among the `dialyzer:gui()` options. (Thanks to\n  James Fish.)\n\n  Own Id: OTP-12750\n\n- Fix a bug which could cause an infinite loop in Dialyzer.\n\n  Own Id: OTP-12826","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The `-dialyzer()` attribute can be used for suppressing warnings in a module\n  by specifying functions or warning options. It can also be used for requesting\n  warnings in a module.\n\n  Own Id: OTP-10280\n\n- The pre-defined types `array()`, `dict()`, `digraph()`, `gb_set()`,\n  `gb_tree()`, `queue()`, `set()`, and `tid()` have been removed.\n\n  Own Id: OTP-11445 Aux Id: OTP-10342, OTP-9352\n\n- A few type names that have been used for representing certain predefined types\n  can now be used for user-defined types. This affects the types `product/_`,\n  `union/_`, and `range/2` as well as `tuple/N` (N > 0), `map/N` (N > 0),\n  `atom/1`, `integer/1`, `binary/2`, `record/_,` and `'fun'/_`. A consequence is\n  that, for example, it is no longer possible to refer to a record type with\n  `record(r)`; instead the usual record notation, `#r{}`, is to be used.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-11851\n\n- When implementing user-defined behaviours it is now possible to specify\n  optional callback functions. See OTP Design Principles User's Guide, Sys and\n  Proc_Lib, User-Defined Behaviours, for details.\n\n  Own Id: OTP-11861\n\n- Add two options to the Dialyzer: `no_missing_calls` suppresses warnings about\n  calls to missing or unexported functions; `unknown` lets warnings about\n  unknown functions or types affect the exit status. See also dialyzer(3).\n\n  Own Id: OTP-12682\n\n- By default, dialyzer will now cache native versions of dialyzer modules to\n  avoid having to re-compile them each time dialyzer is started. Caching can be\n  disabled using the option `--no_native_cache`.\n\n  Own Id: OTP-12779","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.7.4 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-7-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- A bug concerning `t:map/0` types has been fixed.\n\n  Own Id: OTP-12472","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 2.7.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-7-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- When compiling Erlang source, Dialyzer now ignores the environment variable\n  ERL_COMPILER_OPTIONS as well as skips the Erlang Compiler option\n  `warnings_as_errors`.\n\n  Own Id: OTP-12225\n\n- Dialyzer did not check the type of record elements when updating them. The\n  bug, introduced in Erlang/OTP 17.1, has been corrected. (Thanks to Nicolas\n  Dudebout for pointing it out.)\n\n  Own Id: OTP-12319\n\n- Coalesce map keys in dialyzer mode\n\n  This fixes a regression introduced in commit\n  805f9c89fc01220bc1bb0f27e1b68fd4eca688ba The problem occurred with compounded\n  map keys compiled with dialyzer option turned on, '+dialyzer'.\n\n  Reported by: Ivan Uemlianin\n\n  Own Id: OTP-12347","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 2.7.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- A bug concerning `is_record/2,3` has been fixed, as well as some cases where\n  Dialyzer could crash due to reaching system limits.\n\n  Own Id: OTP-12018\n\n- When given the `-Wunderspecs` flag Dialyzer sometimes output bogus warnings\n  for parametrized types. This bug has been fixed.\n\n  Own Id: OTP-12111\n\n- Dialyzer now fetch the compile options from beam files, and use them when\n  creating core from the abstract code. Previously the options were ignored.\n\n  Own Id: OTP-12150","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 2.7.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix a bug concerning opaque types. Thanks to Shayan Pooya for pointing out the\n  bug.\n\n  Own Id: OTP-11869\n\n- A bug where Dialyzer failed to handle typed records with fields containing\n  remote types has been fixed. Thanks to Erik Søe Sørensen for reporting the\n  bug.\n\n  Own Id: OTP-11918\n\n- Make sure that only literal records are checked against the types of record\n  definitions. Until now the elements of tuples have been checked against record\n  field types if the tag och size of the tuple matches the record definition,\n  often with surprising results.\n\n  Own Id: OTP-11935 Aux Id: seq12590\n\n- A Dialyzer crash involving analysis of Map types has now been fixed.\n\n  Own Id: OTP-11947","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 2.7 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Dialyzer will no longer emit warnings when inspecting or modifying opaque\n  types within the scope of a module.\n\n  Hitherto the shape of terms (tuple, list, etc.) has been used to determine the\n  opaque terms, but now the contracts are used for decorating types with\n  opacity.\n\n  Own Id: OTP-10397\n\n- With `--Wunmatched_returns`, dialyzer will no longer warn when the value of a\n  list comprehension is ignored, provided that the each value in the list would\n  be an atomic value (such as integer or atoms, as opposed to tuples and lists).\n  Example: ignoring '`[io:format(...) || ...]`' will not cause a warning, while\n  ignoring '`[file:close(Fd) || ...]`' will.\n\n  Own Id: OTP-11626\n\n- The man page for dialyzer now contains correct information regarding\n  -Wno_behaviours. (Thanks to Steve Vinosky.)\n\n  Own Id: OTP-11706\n\n- Fix handling of 'on_load' attribute. (Thanks to Kostis Sagonas.)\n\n  Own Id: OTP-11743\n\n- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744\n\n- The generalization of guard constraints has been modified.\n\n  Own Id: OTP-11798 Aux Id: seq12547\n\n- Dialyzer now plays nicely with funs that come as \"external\" arguments. (Thanks\n  to Stavros Aronis for fixing the bug.)\n\n  Own Id: OTP-11826","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The pre-defined types `array/0`, `dict/0`, `digraph/0`, `gb_set/0`,\n  `gb_tree/0`, `queue/0`, `set/0`, and `tid/0` have been deprecated. They will\n  be removed in Erlang/OTP 18.0.\n\n  Instead the types [`array:array/0`](`t:array:array/0`),\n  [`dict:dict/0`](`t:dict:dict/0`), [`digraph:graph/0`](`t:digraph:graph/0`),\n  `gb_set:set/0`, `gb_tree:tree/0`, [`queue:queue/0`](`t:queue:queue/0`),\n  [`sets:set/0`](`t:sets:set/0`), and [`ets:tid/0`](`t:ets:tid/0`) can be used.\n  (Note: it has always been necessary to use [`ets:tid/0`](`t:ets:tid/0`).)\n\n  It is allowed in Erlang/OTP 17.0 to locally re-define the types `array/0`,\n  `dict/0`, and so on.\n\n  New types [`array:array/1`](`t:array:array/1`),\n  [`dict:dict/2`](`t:dict:dict/2`), [`gb_sets:set/1`](`t:gb_sets:set/1`),\n  [`gb_trees:tree/2`](`t:gb_trees:tree/2`),\n  [`queue:queue/1`](`t:queue:queue/1`), and [`sets:set/1`](`t:sets:set/1`) have\n  been added.\n\n  A compiler option, `nowarn_deprecated_type`, has been introduced. By including\n  the attribute\n\n  `-compile(nowarn_deprecated_type).`\n\n  in an Erlang source file, warnings about deprecated types can be avoided in\n  Erlang/OTP 17.0.\n\n  The option can also be given as a compiler flag:\n\n  `erlc +nowarn_deprecated_type file.erl`\n\n  Own Id: OTP-10342\n\n- Removed gs based applications and gs based backends. The `observer`\n  application replaces the removed applications.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-10915\n\n- Forbid unsized fields in patterns of binary generators and simplified\n  v3_core's translation of bit string generators. (Thanks to Anthony Ramine.)\n\n  Own Id: OTP-11186\n\n- EEP43: New data type - Maps\n\n  With Maps you may for instance:\n\n  - \\_\\_\\_\\_ - `M0 = #{ a => 1, b => 2}, % create associations`\n\n  - \\_\\_\\_\\_ - `M1 = M0#{ a := 10 }, % update values`\n\n  - \\_\\_\\_\\_ - `M2 = M1#{ \"hi\" => \"hello\"}, % add new associations`\n\n  - \\_\\_\\_\\_ - `#{ \"hi\" := V1, a := V2, b := V3} = M2. % match keys with values`\n\n  For information on how to use Maps please see Map Expressions in the\n  [Reference Manual](`e:system:expressions.md#map-expressions`).\n\n  The current implementation is without the following features:\n\n  - \\_\\_\\_\\_ - No variable keys\n\n  - \\_\\_\\_\\_ - No single value access\n\n  - \\_\\_\\_\\_ - No map comprehensions\n\n  Note that Maps is _experimental_ during OTP 17.0.\n\n  Own Id: OTP-11616\n\n- Parameterized opaque types have been introduced.\n\n  Own Id: OTP-11625\n\n- Some function specs are corrected or moved and some edoc comments are\n  corrected in order to allow use of edoc. (Thanks to Pierre Fenoll)\n\n  Own Id: OTP-11702","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.6.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- A bug that made it impossible to do any analyses from the GUI has been fixed.\n\n  Own Id: OTP-11057 Aux Id: seq12313","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Include module, function and arity in Dialyzer's \"overlapping domain\"\n  warnings. Thanks to Magnus Henoch.\n\n  Own Id: OTP-10918\n\n- Improve Dialyzer output for scan errors. Thanks to Magnus Henoch.\n\n  Own Id: OTP-10996\n\n- Integrate elliptic curve contribution from Andreas Schultz\n\n  In order to be able to support elliptic curve cipher suites in SSL/TLS,\n  additions to handle elliptic curve infrastructure has been added to public_key\n  and crypto.\n\n  This also has resulted in a rewrite of the crypto API to gain consistency and\n  remove unnecessary overhead. All OTP applications using crypto has been\n  updated to use the new API.\n\n  Impact: Elliptic curve cryptography (ECC) offers equivalent security with\n  smaller key sizes than other public key algorithms. Smaller key sizes result\n  in savings for power, memory, bandwidth, and computational cost that make ECC\n  especially attractive for constrained environments.\n\n  Own Id: OTP-11009\n\n- Bitstring type inference and duplicate module error message fixes. Thanks to\n  Stavros Aronis.\n\n  Own Id: OTP-11027\n\n- Erlang source files with non-ASCII characters are now encoded in UTF-8\n  (instead of latin1).\n\n  Own Id: OTP-11041 Aux Id: OTP-10907","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.6 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-6"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Miscellaneous updates due to Unicode support.\n\n  Own Id: OTP-10820\n\n- User defined types with same name and different arity and documentation\n  inconsistencies. Thanks Stavros Aronis.\n\n  Own Id: OTP-10861\n\n- Native code compilation changes. Thanks to Kostis Sagonas.\n\n  Own Id: OTP-10865","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.5.4 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-5-4"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Support for Unicode has been implemented.\n\n  Own Id: OTP-10302\n\n- Dialyzer no longer outputs warnings for unused anonymous functions (\"funs\").\n  Warnings are still output for unused functions.\n\n  Own Id: OTP-10433\n\n- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630\n\n- Some examples overflowing the width of PDF pages have been corrected.\n\n  Own Id: OTP-10665\n\n- Fix precision of record creation violation warnings. Thanks to Stavros Aronis\n\n  Own Id: OTP-10681\n\n- Report spec discrepancy on mismatching lists. Thanks to Stavros Aronis.\n\n  Own Id: OTP-10740\n\n- Properly support functions with arbitrary arity in type specs. Thanks to\n  Stavros Aronis.\n\n  Own Id: OTP-10772","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.5.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix a crash in race condition detection\n\n  Remove old untested experimental extension\n\n  Respect \\{plt_check,false\\} option when using dialyzer:run/1\n\n  Fix handling of tuple set remote types appearing in tuple sets\n\n  Own Id: OTP-10464","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 2.5.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Correct handling of type names in contracts. Fix crash related to contract\n  checking. Do not rewrite unchanged PLT.\n\n  Own Id: OTP-10083\n\n- Stop a forgotten server process\n\n  Dialyzer forgot to stop a server process before finishing its analysis. This\n  is a concurrency error detected by Concuerror. Changes to fix warnings\n  identified by running dialyzer -Wunmatched_returns. Thanks to Kostis Sagonas.\n\n  Own Id: OTP-10231","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Bug fixes and improvements of `dialyzer_typesig`.\n\n  Own Id: OTP-10082\n\n- Add parallel dialyzer support\n\n  Own Id: OTP-10103\n\n- An alternative implementation of the solver in `dialyzer_typesig` has been\n  introduced. It is faster than the original implementation.\n\n  Own Id: OTP-10110\n\n- Bugs in `erl_types:t_inf()` (HiPE) and in `dialyzer_dataflow` (Dialyzer) have\n  been fixed.\n\n  Own Id: OTP-10191","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.5.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-5-1"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Handle `nowarn_unused_function` the same way as the compiler does.\n\n  Own Id: OTP-9833","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.5 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix false warning about closure application\n\n  Whenever a variable that could hold one of two or more possible closures was\n  used in a particular application, the application was assumed to fail if ONE\n  of the closures would fail in this application. This has been corrected to\n  infer failing application if ALL possible closures would fail in the\n  particular application.\n\n  Change category of 'might also return' warnings\n\n  Dialyzer emits warnings like the following \"The specification for \\_ states\n  that the function might also return _ but the inferred return is _\", which are\n  actually underspecifications and not wrong type specifications. This patch\n  makes sure that they are filed under the appropriate category.\n\n  Own Id: OTP-9707\n\n- Wrap up behaviours patch for Dialyzer\n\n  - Enable warnings by default, add two options for suppressing them\n  - Fix warning formatting and update testsuites.\n  - Detection of callback-spec discrepancies\n  - Allow none() as return value in callbacks\n  - Behaviour callback discrepancy detection for Dialyzer\n  - Add lookup function for callbacks\n  - Store callbacks in codeserver and PLT\n  - Collect callback definitions during compilation\n  - Update inets results\n\n  Own Id: OTP-9731\n\n- - No warnings for underspecs with remote types\n  - Fix crash in Typer\n  - Fix Dialyzer's warning for its own code\n  - Fix Dialyzer's warnings in HiPE\n  - Add file/line info in a particular Dialyzer crash\n  - Update inets test results\n\n  Own Id: OTP-9758\n\n- - Correct callback spec in application module\n  - Refine warning about callback specs with extra ranges\n  - Cleanup autoimport compiler directives\n  - Fix Dialyzer's warnings in typer\n  - Fix Dialyzer's warning for its own code\n  - Fix bug in Dialyzer's behaviours analysis\n  - Fix crash in Dialyzer\n  - Variable substitution was not generalizing any unknown variables.\n\n  Own Id: OTP-9776","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Optimize the joining of maps in `dialyzer_dataflow`.\n\n  Own Id: OTP-9761","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.4.4 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Update results of race_SUITE/extract_translations Update results of\n  small_SUITE/flatten Add codec_can and list_to_bitstring tests Fix bug when\n  reporting unused functions Update Dialyzer r9c_suite results Fix dialyzer\n  warning on default clause for binary comprehension (Thanks to Ivan Dubrov)\n\n  Own Id: OTP-9483\n\n- Fix server loop detection\n\n  Dialyzer does not normally emit warnings for functions that implement\n  non-terminating server loops. This detection failed when some of the elements\n  in an SCC terminated normally (being for example list comprehensions or other\n  generic anonymous functions that were included in the SCC). This patch fixes\n  that.\n\n  Own Id: OTP-9489\n\n- Add a proplist() type\n\n  Recently I was adding specs to an API and found that there is no canonical\n  proplist() type defined. (Thanks to Ryan Zezeski)\n\n  Own Id: OTP-9499\n\n- Suppress some warnings about generation of non-returning funs\n\n  No warnings are emitted for funs that are non-returning when the function that\n  generates them has a contract that specifies that it will return such a\n  non-returning fun.\n\n  Enhance Dialyzer's inference on comparisons\n\n  This patch makes Dialyzer aware of Erlang's total ordering of terms, enabling\n  discrepancy detection in cases where e.g. integer() < tuple() is treated as a\n  comparison that might also return false (when it is certain to always return\n  true).\n\n  Minor fix in dead code\n\n  Fix infinite loop in dataflow\n\n  Update r9c/\\{inets,mnesia\\} results in dialyzer's test suite\n\n  Add origin information to #fun_var closures\n\n  (Thanks to Tuncer Ayaz and Maria Christakis)\n\n  Own Id: OTP-9529\n\n- Quote atoms if necessary in types\n\n  Atoms in some occurrences were not correctly quoted when formatted to strings,\n  for instance by the typer program (Thanks to Tomas Abrahamsson)\n\n  Update Dialyzer's reference results\n\n  Own Id: OTP-9560\n\n- Fix typer's crash for nonexisting files Remove unused macro Fix bug in\n  dataflow Decrease tuple arity limit This fixes a memory related crash.\n\n  Own Id: OTP-9597","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Types for several BIFs have been extended/corrected. Also the types for types\n  for `lists:keyfind/3`, `lists:keysearch/3`, and `lists:keyemember/3` have been\n  corrected. The incorrect/incomplete types could cause false dialyzer warnings.\n\n  Own Id: OTP-9496","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.4.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fix the name of an error function(Thanks to Maria christakis)\n\n  Own Id: OTP-9175\n\n- Fix crash related with the contract blame assignment patch\n\n  Own Id: OTP-9219\n\n- dialyzer/doc: synchronize manual.txt and dialyzer.xml (Thanks to Tuncer Ayaz)\n\n  Own Id: OTP-9226\n\n- Simplify Dialyzer's test suite structure\n\n  \\*\\_SUITE.erl files are now automatically generated by the respective data\n  directories by the Makefile.\n\n  Own Id: OTP-9278","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Dialyzer 2.4.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Add a --fullpath option to Dialyzer\n\n  This change adds a --fullpath option to Dialyzer, which makes the warning\n  messages contain the full path of the corresponding file.\n\n  Original patch submitted by Magnus Henoch (legoscia) on 15/9/2010 and cooked\n  to death in the 'pu' branch all this time.\n\n  The patch was essentially correct and most of it has been used as is, but\n  there have been some changes to make the code slightly prettier, avoid some\n  code duplication, and add documentation to dialyzer's doc files and to its\n  help message.\n\n  Own Id: OTP-9098\n\n- Fix warnings about guards containing not\n\n  The wording of warnings about unsatisfiable guards that used 'not' was\n  incorrect (the 'not' was not mentioned and it appeared as \"Guard test\n  is_atom(atom()) can never succeed\") (thanks to Stavros Aronis).\n\n  Own Id: OTP-9099\n\n- Version 2.4.2 (in Erlang/OTP R14B02) ------------------------------------ -\n  Added --fullpath option to display files with warnings with their full file\n  names (thanks to Magnus Henoch for the original patch). - Better handling of\n  'and'/'or'/'not' guards that generate warnings (thanks to Stavros Aronis). -\n  Better blame assignment for cases when a function's spec is erroneous (thanks\n  to Stavros Aronis). - More descriptive warnings when a tuple/record pattern\n  contains subterms that violate the declared types of record fields (thanks to\n  Matthias Lang for the test case and for Stavros Aronis for the actual fix).\n\n  Own Id: OTP-9126\n\n- Add spec to dialyzer_cl_parse:get_lib_dir/1\n\n  Own Id: OTP-9129","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Test suites for Dialyzer\n\n  This is a transcription of most of the cvs.srv.it.uu.se:/hipe repository\n  dialyzer_tests into test suites that use the test server framework.\n\n  See README for information on how to use the included scripts for\n  modifications and updates.\n\n  When testing Dialyzer it's important that several OTP modules are included in\n  the plt. The suites takes care of that too.\n\n  Own Id: OTP-9116","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.4.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-4-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- \\- Fixed pretty rare infinite loop when refining the types of an SCC whose\n  functions all returned none() (thanks to Stavros Aronis).\n\n  \\- Fixed pretty rare crash when taking the infimum of two tuple_sets.\n\n  Own Id: OTP-8979","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- \\- Added ability to supply multiple PLTs for the analysis (option --plts).\n  Currently these PLTs must be independent (i.e., no module appears in more than\n  one PLT) and there must not include files with module name clashes.\n\n  \\- Strengthened and streamlined hard-coded type information for some BIFs and\n  key library functions.\n\n  Own Id: OTP-8962","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.3.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-3-1"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Eliminated warnings for auto-imported BIF clashes.\n\n  Own Id: OTP-8840","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.3.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-3-0"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Various changes to dialyzer-related files for R14.\n\n  \\- Dialyzer properly supports the new attribute -export_type and checks that\n  remote types only refer to exported types. A warning is produced if some\n  files/applications refer to types defined in modules which are neither in the\n  PLT nor in the analyzed applications.\n\n  \\- Support for detecting data races involving whereis/1 and unregister/1.\n\n  \\- More precise identification of the reason(s) why a record construction\n  violates the types declared for its fields.\n\n  \\- Fixed bug in the handling of the 'or' guard.\n\n  \\- Better handling of the erlang:element/2 BIF.\n\n  \\- Complete handling of Erlang BIFs.\n\n  Own Id: OTP-8699","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.2.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-2-0"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Much better support for opaque types (thanks to Manouk Manoukian).\n\n  Added support for recursive types (experimental).\n\n  Added support for parameterized modules.\n\n  Dialyzer now warns when -specs state that a function returns some type when in\n  fact it does not.\n\n  Added `--no_native` (`-nn`) option so that the user can bypass the native code\n  compilation that dialyzer heuristically performs when dialyzing many files.\n\n  Fixed minor bug in the dialyzer script allowing the --wx option to bring up\n  the wx-based GUI regardless of its placement in the options list.\n\n  Options --apps and -Wrace_conditions, which were added in the previous\n  version, are now properly documented in the manual.\n\n  Own Id: OTP-8464","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.1.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-1-0"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8201\n\n- Dialyzer can statically detect some kinds of data races in Erlang programs.\n  Use the new option -Wrace_conditions to enable the race analysis. The\n  technique is described in a paper which is available at:\n  http://www.it.uu.se/research/group/hipe/dialyzer/publications/races.pdf\n\n  Added support for packages (thanks to Maria Christakis).\n\n  There has been a major change in the default mode of Dialyzer. Previously, the\n  default mode was the GUI, while now it is the command line. As a result of\n  this change, it is now possible to analyze a set of files/dirs with the\n  command:\n\n  - dialyzer file1 ... fileN\n\n  In other words, the -c (--command-line) option is no longer necessary, though\n  it will be retained for some time for backwards compatibility. To start\n  dialyzer's GUI use either of the following commands:\n\n  - dialyzer --gui %% for the old gs-based GUI\n  - dialyzer --wx %% for the new wx-based GUI (where available)\n\n  There is a new option --apps which allows the user to easily refer to\n  Erlang/OTP applications and include them in the analysis or in the building of\n  the PLT. For example, we recommend building the PLT with:\n\n  - dialyzer --build_plt --apps erts kernel stdlib mnesia ...\n\n  The new option can also take absolute file names as well as applications. Note\n  that the application versions that will be included in the PLT are those that\n  correspond to the Erlang/OTP system which is used.\n\n  Dialyzer has a new wxWidgets based GUI (thanks to Elli Frangaki) for platforms\n  where the wx application is available.\n\n  Own Id: OTP-8300","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 2.0.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-2-0-0"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- There is a major addition to the capabilities of dialyzer, worthy of bumping\n  the version number. Starting with this version, dialyzer not only accepts but\n  also properly processes remote types (i.e., types of the form\n  ModuleName:TypeName()). Previous dialyzer versions only accepted this notation\n  in -type and -spec declarations, but effectively ignored its information by\n  mapping remote types to the type any(). In contrast, starting with this\n  version, remote types are used in the analysis and are also stored in the\n  PLTs. (This addition changes the format of PLTs and requires rebuilding any\n  PLTs created by an older dialyzer version.) Note that dialyzer will complain\n  and abort the analysis of a set of modules if it needs to process a remote\n  type without a definition (either because the module does not include a\n  definition of the type or the module is not included in the analysis). We may\n  relax this restriction in a future version.\n\n  Fixed minor issue with dialyzer:run/1 crashing (upon its return) when used for\n  adding type information to an existing PLT.\n\n  Fixed minor but quite annoying issues in dialyzer's GUI.\n\n  Own Id: OTP-8187","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.9.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-9-2"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Fixed problem with type inference going into an infinite loop when analyzing a\n  strongly connected component of functions that do not return but also contain\n  an erroneous call which makes them fail and be assigned the type none()\n  instead of the type unit().\n\n  More accurate type information for some BIFs and library files.\n\n  Introduced boolean() as the \\`official' name for the type was so far known as\n  bool(). The latter is still accepted as well as boolean().\n\n  Own Id: OTP-8037","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.9.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-9-1"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Has better handling of opaque types.\n\n  The handling of UTF segments of bitstreams has been significantly strengthened\n  and revised. In all probability, now it is correct.\n\n  Own Id: OTP-7958","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.9.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-9-0"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The analysis accepts opaque type declarations and detects violations of\n  opacity of terms of such types. Starting with R13, many Erlang/OTP standard\n  libraries (array, dict, digraph, ets, gb_sets, gb_trees, queue, and sets)\n  contain opaque type declarations of their main data types. Dialyzer will spit\n  out warnings in code that explicitly depends on the structure of these terms.\n\n  Added support for handling UTF segments in bitstreams and for detecting\n  obvious type errors in these segments. Warning: This code is not terribly\n  tested though since there are very few Erlang programs which use Unicode-based\n  binaries - not surprising since this is a new language feature of R13.\n\n  Strengthened the discrepancy identification when testing for equality and\n  matching between terms of different types. This detects more bugs in code.\n\n  Added warning for M:F(...) calls where M is not a module term and F is not an\n  atom. Previously, such calls where found to fail but the reason for the\n  failure was not reported.\n\n  Added a convenient shorthand for the --no_check_plt option (-n).\n\n  Added the --dump_callgraph option for dumping the callgraph of all files that\n  are analyzed into a specified file. The callgraph either be dumped in raw\n  format, in .dot format, or converted to a .ps (postscript) file. Note that in\n  large callgraphs the generated postscript file might not be interpretable by\n  Ghostview. (Thanks to Ilya Khlopotov for the initial version of this\n  functionality.)\n\n  Own Id: OTP-7864","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.8.3 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-8-3"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Added the `--no_check_plt` option that makes the startup time faster when\n  working with stable PLTs that do not change.\n\n  Changed the phrasing of some warnings so that they do not cause confusion to\n  some users and correspond better to reality.\n\n  Own Id: OTP-7632","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.8.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-8-2"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Minor updates.\n\n  Own Id: OTP-7522","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.8.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-8-1"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- There is new `--raw` option for Dialyzer to output the result of the analysis\n  in Erlang term, to facilitate later filtering and/or formatting.\n\n  Own Id: OTP-7386\n\n- The return type of the Erlang interface dialyzer:run/1 has changed to only\n  return a list of warnings. If something goes wrong dialyzer dies with an\n  exception.\n\n  The handling of the PLT is now more flexible. There is no longer any default\n  PLT included with OTP. Please consult the manual for the changes.\n\n  Own Id: OTP-7389","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.8.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-8-0"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Dialyzer's analysis is from now on exclusively based on success typings. In\n  particular, support for options `--old_style` and `--dataflow` has been\n  discontinued.\n\n  Better and more aggressive handling of type information in records.\n\n  Dialyzer has a new warning option `-Wunmatched_returns` which warns for\n  function calls that ignore the return value. This catches many common\n  programming errors (e.g. calling `file:close/1` and not checking for the\n  absence of errors), interface discrepancies (e.g. a function returning\n  multiple values when in reality the function is void and only called for its\n  side-effects), calling the wrong function (e.g. `io_lib:format/1` instead of\n  `io:format/1`), and even possible performance defects (e.g. unnecessarily\n  constructing a list using a list comprehension instead of using\n  `lists:foreach/2`). Whenever a function returns a single atomic value (e.g.\n  'ok' or pid()), the warning is suppressed. This allows for \"void\" functions\n  (returning a single atom like 'ok') or for calls to certain builtins like\n  `spawn`. Because not all calls which ignore the return value are\n  discrepancies, the option is off by default and has to be explicitly requested\n  by the user. But we recommend it nevertheless.\n\n  Some warning options (`-Wno_comp`, `-Wno_guards`, `-Wno_unsafe_beam`, etc.)\n  which could be used when analyzing bytecode produced by an old BEAM compiler\n  have been removed.\n\n  Own Id: OTP-7241","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.7.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-7-2"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The warnings returned by the Erlang interface now contains a tag describing\n  the type of warning.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-7134","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.7.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-7-1"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Use of success typings is now default, is robust and detects significantly\n  more errors than in previous versions.\n\n  Dialyzer now accepts and takes into account type information in record\n  declarations and in contracts -- see related paper in Erlang'07 workshop.\n  Various OTP applications (e.g. stdlib and kernel) are partially annotated with\n  appropriate contracts specifying types information for their functions.\n\n  The type previously known as unit() has been renamed to no_return(). Its use\n  in a contract as the return type of a function now silences off the \"function\n  has no local return\" dialyzer warning without use of the corresponding option.\n\n  Own Id: OTP-6997","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.7.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-7-0"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Minor Makefile changes.\n\n  Own Id: OTP-6689\n\n- Dialyzer can now use success typings to find discrepancies. As a consequence\n  significantly more discrepancies are detected. The downside is that the\n  analysis takes about 2 to 2.5 times longer than in previous versions, and may\n  also result in some warnings that might be harder to interpret even though\n  they are correct. This has been a major change, worth of increasing the\n  version number.\n\n  New command-line options:\n\n  \\--succ_typings Use the success typings analysis.\n\n  \\--dataflow (default) Use the previous analysis.\n\n  The new type unit() has been introduced to handle the return type of\n  non-terminating functions such as servers.\n\n  Dialyzer's code server uses a compressed representation and the analysis\n  requires significantly less memory than in previous versions.\n\n  Own Id: OTP-6736","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.6.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-6-0"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Dialyzer (in the modes where either source or BEAM code which contains\n  debug_info is analyzed) spits out line information for all discrepancies. This\n  has been a major change, worth of increasing the version number.\n\n  We warn users that _considerably_ more discrepancies are identified by this\n  version of Dialyzer compared with previous ones and applications. If, for some\n  reason, warnings generated by previous versions of Dialyzer are preferable,\n  the command line option --old_style can be employed.\n\n  Own Id: OTP-6546\n\n- Dialyzer handles term comparison operators more precisely and is able to\n  identify more discrepancies in 'if' or 'case' statements with comparisons.\n\n  Dialyzer has more precise type information for many standard OTP functions.\n\n  Own Id: OTP-6547","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.5.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-5-1"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Updated the chapter \"More on the Persistent Lookup Table (PLT)\" in Dialyzer\n  User's Guide and added information on how to use Dialyzer from Erlang to\n  `m:dialyzer`. Also, the Dialyzer text files used by its GUI are now included\n  in the Erlang/OTP release.\n\n  Own Id: OTP-6361\n\n- New options `--check_init_plt` and `--verbose`.\n\n  Improvements in the analysis (meaning that this version can find more\n  discrepancies than the previous version).\n\n  Own Id: OTP-6421","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.5.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-5-0"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Dialyzer's building of PLT is based on a different type inference algorithm.\n  More specifically, Dialyzer uses inference of refined success typings to infer\n  function prototypes. As a result, Dialyzer bases its analysis on a\n  significantly more powerful basis and thus is able to detect more\n  discrepancies. The downside is that building the PLT is a considerably slower\n  process. We will work on improving that.\n\n  Dialyzer takes into account the BEAM compiler directive\n  `-compile({nowarn_unused_function, {F,A}}).` and then suppresses the warning\n  that function F/A will never be called.\n\n  Dialyzer's default initial PLT now also includes \"mnesia\".\n\n  Own Id: OTP-6304","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.4.2 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-4-2"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Improvements in PLT management.\n\n  Own Id: OTP-6128","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.4.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Some minor changes.","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Some minor changes.","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.4.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-4-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Changes for Dialyzer to work with Erlang/OTP R10B-10.","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Dialyzer's analysis is significantly faster as it uses a global function\n  call-graph for obtaining type signatures for all analyzed functions.","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.3.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Small changes for Dialyzer to work with Erlang/OTP R10B-5.\n- Fixed a small buglet in the analysis; this affected one of HiPE's files.","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Modified setup script for execution under Cygwin (patch by Vlad Dumitrescu).\n- Added command line option --no_warn_on_inline.\n- Dialyzer now explicitly warns when modules with the same name but from\n  different dirs are being analyzed (contribution by Ulf Wiger).","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.3.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-3-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fixed a number of false positives that Dialyzer 1.2.0 was spitting out.","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Requires the presence of an Erlang/OTP R10B-4 system.\n- Dialyzer is significantly (approx 40%) faster since it now uses 'ets' rather\n  than 'dets' for its PLT.\n- Slightly improved the precision of the analysis.\n- In the GUI version, Dialyzer now reports the list of modules that should be\n  included in the modules to analyze in order to possibly improve the accuracy\n  of the reported results.\n- Some more information is displayed when calling a function or closure with\n  arguments of the wrong type.\n- The record guard now allows discrepancies involving tuples that are known to\n  be records to be displayed as #rec\\{\\} rather than \\{'rec',_,...,_\\}\n- Added -q option which makes the command-line version of Dialyzer a bit more\n  silent.","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.2.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-2-0"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Dialyzer works with the open source and commercial versions of Erlang/OTP\n  R10B-2 on all platforms (i.e., HiPE support is not a prerequisite anymore).\n- Whenever a .beam file contains abstract code (i.e., has been compiled with the\n  +debug_info option), the analysis starts from this code rather than from BEAM\n  bytecode -- this makes the results identical to those obtained by analysis\n  starting from source code. (This is a contribution from Bjorn Gustavsson -\n  Thanks\\!)\n- Added -pa command line option for easier handling of -include_lib() directives\n  in source code.\n- Includes all changes added in v1.1.1; see below. The \"Add Recursively\"\n  functionality is also available in the command-line mode (-r option).","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.1.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fixed problems using the shell script on Solaris machines.\n- Fixed small inconsistencies in Dialyzer's documentation and help.","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- The command-line mode of Dialyzer spits discrepancies in stdout by default and\n  returns a numeric value indicating its exit status.\n- Added \"Add Recursively\" button contributed by Martin Bjorklund (thanks\\!).","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.1.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-1-0"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Dialyzer works with the open source version of Erlang/OTP R10B-1 (on platforms\n  where HiPE support is available) and it does not require installation of a\n  customized Erlang/OTP system anymore.\n- Dialyzer comes with an extensive command-line interface, in addition to an\n  enhanced GUI.\n- Analysis can start from source code (through Core Erlang) as well as from BEAM\n  bytecode.\n- Dialyzer finds considerably more discrepancies in Erlang code than previous\n  versions.\n- Added ability to selectively turn on/off different warning categories.","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.0.1 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Dialyzer Release Notes","doc":"- Fixed major bug of v1.0.0 which caused the analysis to stop prematurely (i.e.,\n  without properly reaching fixpoint) when analyzing more than one module. This\n  did not affect correctness of the results, but lost many opportunities to\n  detect discrepancies.","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Performance improvements in the analysis.","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer 1.0.0 - Dialyzer Release Notes","doc":"","ref":"notes.html#dialyzer-1-0-0"},{"type":"extras","title":"Improvements and New Features - Dialyzer Release Notes","doc":"- Initial Dialyzer version: Analysis starts from BEAM bytecode only and only a\n  GUI version is available. Dialyzer reports discrepancies in the use of the\n  \"sequential\" part of Erlang. To be used, Dialyzer requires the presence of a\n  specific snapshot of Erlang/OTP which can be obtained from Dialyzer's\n  homepage.","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Dialyzer","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Dialyzer","ref":"dialyzer_chapter.html"},{"type":"extras","title":"Introduction - Dialyzer","doc":"","ref":"dialyzer_chapter.html#introduction"},{"type":"extras","title":"Scope - Dialyzer","doc":"Dialyzer is a static analysis tool that identifies software discrepancies, such\nas definite type errors, code that is unreachable because of\nprogramming error, and unnecessary tests in single Erlang modules or an entire\ncodebase.\n\nDialyzer can be called from the command line and from Erlang.\n\n[](){: #plt }","ref":"dialyzer_chapter.html#scope"},{"type":"extras","title":"The Persistent Lookup Table - Dialyzer","doc":"Dialyzer stores the result of an analysis in a Persistent Lookup Table (PLT).\nThe PLT can then be used as a starting point for later analyses. It is\nrecommended to build a PLT with the Erlang/OTP applications that you are using,\nbut also to include your own applications that you are using frequently.\n\nThe PLT is built using option `--build_plt` to Dialyzer. The following command\nbuilds the recommended minimal PLT for Erlang/OTP:\n\n```text\ndialyzer --build_plt --apps erts kernel stdlib mnesia\n```\n\nDialyzer looks if there is an environment variable called `DIALYZER_PLT` and\nplaces the PLT at this location. If no such variable is set, Dialyzer places the\nPLT in a file called .dialyzer_plt in the\n[`filename:basedir(user_cache, \"erlang\")`](`m:filename#user_cache`) folder. The\nplacement can also be specified using the options `--plt` or `--output_plt`.\n\nInformation can be added to an existing PLT using option `--add_to_plt`. If you\nalso want to include the Erlang compiler in the PLT and place it in a new PLT,\nthen use the following command:\n\n```text\ndialyzer --add_to_plt --apps compiler --output_plt my.plt\n```\n\nThen you can add your favorite application `my_app` to the new PLT:\n\n```text\ndialyzer --add_to_plt --plt my.plt -r my_app/ebin\n```\n\nBut you realize that it is unnecessary to have the Erlang compiler in this one:\n\n```text\ndialyzer --remove_from_plt --plt my.plt --apps compiler\n```\n\nLater, when you have fixed a bug in your application `my_app`, you want to update\nthe PLT so that it becomes fresh the next time you run Dialyzer. In this case,\nrun the following command:\n\n```text\ndialyzer --check_plt --plt my.plt\n```\n\nDialyzer then reanalyzes the changed files and the files that depend on these\nfiles. Note that this consistency check is performed automatically the next\ntime you run Dialyzer with this PLT. Use option `--check_plt` to perform the\nconsistency check without doing any other analysis.\n\nTo get information about a PLT, use the following option:\n\n```text\ndialyzer --plt_info\n```\n\nTo specify which PLT, use option `--plt`.\n\nTo get the output printed to a file, use option `--output_file`.\n\nNote that no warnings are emitted when manipulating the PLT. To turn on\nwarnings during (re)analysis of the PLT, use option `--get_warnings`.","ref":"dialyzer_chapter.html#the-persistent-lookup-table"},{"type":"extras","title":"Using Dialyzer from the Command Line - Dialyzer","doc":"Dialyzer has a command-line version for automated use. See `m:dialyzer`.","ref":"dialyzer_chapter.html#using-dialyzer-from-the-command-line"},{"type":"extras","title":"Using Dialyzer from Erlang - Dialyzer","doc":"Dialyzer can also be used directly from Erlang. See `m:dialyzer`.","ref":"dialyzer_chapter.html#using-dialyzer-from-erlang"},{"type":"extras","title":"Dialyzer's Model of Analysis - Dialyzer","doc":"Dialyzer operates somewhere between a classical type checker and a more general\nstatic-analysis tool: It checks and consumes function specs, yet does not require\nthem, and it can find bugs across modules which consider the dataflow of the\nprograms under analysis. This means Dialyzer can find genuine bugs in complex\ncode, and is pragmatic in the face of missing specs or limited information about\nthe codebase, only reporting issues which it can prove have the potential to\ncause a genuine issue at runtime. This means Dialyzer will sometimes not report\nevery bug, since it cannot always find this proof.","ref":"dialyzer_chapter.html#dialyzer-s-model-of-analysis"},{"type":"extras","title":"How Dialyzer Uses Function Specifications - Dialyzer","doc":"Dialyzer infers types for all top-level functions in a module. If the module\nalso has a spec given in the source-code, Dialyzer will compare the inferred\ntype to the spec. The comparison checks, for each argument and the return, that\nthe inferred and specified types overlap — which is to say, the types have at\nleast one possible runtime value in common. Notice that Dialyzer does not check\nthat one type contains a subset of values of the other, or that they are\nprecisely equal: This allows Dialyzer to make simplifying assumptions to\npreserve performance and avoid reporting program flows which could potentially\nsucceed at runtime.\n\nIf the inferred and specified types do not overlap, Dialyzer will warn that the\nspec is invalid with respect to the implementation. However, if they do overlap,\nDialyzer will proceed under the assumption that the correct type for the given\nfunction is the intersection of the inferred type and the specified type (the\nrationale being that the user may know something that Dialyzer itself cannot\ndeduce). One implication of this is that if the user gives a spec for a function\nwhich overlaps with Dialyzer's inferred type, but is more restrictive, Dialyzer\nwill trust those restrictions. This may then generate an error elsewhere that\nfollows from the erroneously restricted spec.\n\n_Examples:_\n\nNon-overlapping argument:\n\n```erlang\n-spec foo(boolean()) -> string().\n%% Dialyzer will infer: foo(integer()) -> string().\nfoo(N) ->\n    integer_to_list(N).\n```\n\nSince the type of the argument in the spec is different from the type that\nDialyzer inferred, Dialyzer will generate the following warning:\n\n```erlang\nsome_module.erl:7:2: Invalid type specification for function some_module:foo/1.\n The success typing is some_module:foo\n          (integer()) -> string()\n But the spec is some_module:foo\n          (boolean()) -> string()\n They do not overlap in the 1st argument\n```\n\nNon-overlapping return:\n\n```erlang\n-spec bar(a | b) -> atom().\n%% Dialyzer will infer: bar(a | b) -> binary().\nbar(a) -> <<\"a\">>;\nbar(b) -> <<\"b\">>.\n```\n\nSince the return value in the spec and the return value inferred by Dialyzer are\ndifferent, Dialyzer will generate the following warning:\n\n```erlang\nsome_module.erl:11:2: Invalid type specification for function some_module:bar/1.\n The success typing is some_module:bar\n          ('a' | 'b') -> <<_:8>>\n But the spec is some_module:bar\n          ('a' | 'b') -> atom()\n The return types do not overlap\n```\n\nOverlapping spec and inferred type:\n\n```erlang\n-spec baz(a | b) -> non_neg_integer().\n%% Dialyzer will infer: baz(b | c | d) -> -1 | 0 | 1.\nbaz(b) -> -1;\nbaz(c) -> 0;\nbaz(d) -> 1.\n```\n\nDialyzer will \"trust\" the spec and using the intersection of the spec and\ninferred type:\n\n```text\nbaz(b) -> 0 | 1.\n```\n\nNotice how the `c` and `d` from the argument to `baz/1` and the `-1` in the\nreturn from the inferred type were dropped once the spec and inferred type were\nintersected. This could result in warnings being emitted for later functions.\n\nFor example, if `baz/1` is called like this:\n\n```text\ncall_baz1(A) ->\n    case baz(A) of\n        -1 -> negative;\n        0 -> zero;\n        1 -> positive\n    end.\n```\n\nDialyzer will generate the following warning:\n\n```text\nsome_module.erl:25:9: The pattern\n          -1 can never match the type\n          0 | 1\n```\n\nIf `baz/1` is called like this:\n\n```text\ncall_baz2() ->\n    baz(a).\n```\n\nDialyzer will generate the following warnings:\n\n```text\nsome_module.erl:30:1: Function call_baz2/0 has no local return\nsome_module.erl:31:9: The call t:baz\n         ('a') will never return since it differs in the 1st argument\n               from the success typing arguments:\n         ('b' | 'c' | 'd')\n```","ref":"dialyzer_chapter.html#how-dialyzer-uses-function-specifications"},{"type":"extras","title":"Feedback and Bug Reports - Dialyzer","doc":"We very much welcome user feedback! If you notice anything weird,\nespecially if Dialyzer reports any discrepancy that is a false\npositive, please open an issue describing the symptoms and how to\nreproduce them.","ref":"dialyzer_chapter.html#feedback-and-bug-reports"},{"type":"extras","title":"typer","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# typer\n\nType annotator for Erlang programs.","ref":"typer_cmd.html"},{"type":"extras","title":"Description - typer","doc":"TypEr shows type information for Erlang modules. Additionally, it can\nannotate the code of files with such type information.\n\n[](){: #command_line }","ref":"typer_cmd.html#description"},{"type":"extras","title":"Using TypEr - typer","doc":"TypEr is used from the command-line. This section provides a brief description\nof the options. The same information can be obtained by writing the following in\na shell:\n\n```text\ntyper --help\n```\n\n_Usage:_\n\n```text\ntyper [--help] [--version] [--plt PLT] [--edoc]\n      [--show | --show-exported | --annotate | --annotate-inc-files | --annotate-in-place]\n      [-Ddefine]* [-I include_dir]* [-pa dir]* [-pz dir]*\n      [-T application]* file* [-r directory*]\n```\n\n> #### Note {: .info }\n>\n> \\* denotes that multiple occurrences of the option are possible.\n\n_Options:_\n\n- **`-r`** - Search directories recursively for .erl files below them. If a list\n  of files is given, this option must given be after them.\n\n- **`--show`** - Print type specifications for all functions on stdout. (This is\n  the default behaviour; this option is not really needed.)\n\n- **`--show-exported` (or `show_exported`)** - Same as `--show`, but print\n  specifications for exported functions only. Specs are displayed sorted\n  alphabetically according to the function's name.\n\n- **`--annotate`** - Annotate the specified files with type specifications.\n\n- **`--annotate-inc-files`** - Same as `--annotate`, but annotates all\n  `-include()` files as well as all .erl files. (Use this option with caution —\n  it is not well-tested.)\n\n- **`--annotate-in-place`** - Annotate directly in the source code files,\n  instead of dumping the annotated files in a different directory. (Use this\n  option with caution — it is not well-tested.)\n\n- **`--edoc`** - Print type information as Edoc `@spec` comments, not as type\n  specs.\n\n- **`--plt`** - Use the specified dialyzer PLT file rather than the default one.\n\n- **`-T file*`** - The specified file(s) already contain type specifications and\n  these are to be trusted in order to print specs for the rest of the files.\n  (Multiple files or directories, separated by spaces, can be specified.)\n\n- **`-Dname` (or `-Dname=value`)** - Pass the defined name(s) to TypEr. (\\*\\*)\n\n- **`-I`** - Pass the include_dir to TypEr. (\\*\\*)\n\n- **`-pa dir`** - Include `dir` in the path for Erlang. This is useful when\n  analyzing files that use `-include_lib()` directives or parse transforms.\n\n- **`-pz dir`** - Include `dir` in the path for Erlang. This is useful when\n  analyzing files that use `-include_lib()` directives or parse transforms.\n\n- **`--version` (or `-v`)** - Print the TypEr version and some more information\n  and exit.\n\n> #### Note {: .info }\n>\n> \\*\\* options `-D` and `-I` work the same way as in\n> [erlc](`e:erts:erlc_cmd.md`).","ref":"typer_cmd.html#using-typer"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.37.0-rc.2"}}