---
title: "Shade"
description: "Shade Backend Docs"
versionIntroduced: "v1.73"
---

# {{< icon "fa fa-moon" >}} Shade

This is a backend for the [Shade](https://shade.inc/) platform

## About Shade

[Shade](https://shade.inc/) is an AI-powered cloud NAS that makes your cloud files behave like a local drive, optimized for media and creative workflows. It provides fast, secure access with natural-language search, easy sharing, and scalable cloud storage.


## Accounts & Pricing

To use this backend, you need to [create a free account](https://app.shade.inc/) on Shade. You can start with a free account and get 20GB of storage for free.


## Usage

Paths are specified as `remote:path`

Paths may be as deep as required, e.g. `remote:directory/subdirectory`.


## Configuration

Here is an example of making a Shade configuration.

First, create a [create a free account](https://app.shade.inc/) account and choose a plan.

You will need to log in and get the `API Key` and `Drive ID` for your account from the settings section of your account and created drive respectively.

Now run

`rclone config`

Follow this interactive process:

```sh
$ rclone config
e) Edit existing remote
n) New remote
d) Delete remote
r) Rename remote
c) Copy remote
s) Set configuration password
q) Quit config
e/n/d/r/c/s/q> n

Enter name for new remote.
name> Shade

Option Storage.
Type of storage to configure.
Choose a number from below, or type in your own value.
[OTHER OPTIONS]
xx / Shade FS
   \ (shade)
[OTHER OPTIONS]
Storage> xx

Option drive_id.
The ID of your drive, see this in the drive settings. Individual rclone configs must be made per drive.
Enter a value.
drive_id> [YOUR_ID]

Option api_key.
An API key for your account.
Enter a value.
api_key> [YOUR_API_KEY]

Edit advanced config?
y) Yes
n) No (default)
y/n> n

Configuration complete.
Options:
- type: shade
- drive_id: [YOUR_ID]
- api_key: [YOUR_API_KEY]
Keep this "Shade" remote?
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d> y
```

### Modification times and hashes

Shade does not support hashes and writing mod times.


### Transfers

Shade uses multipart uploads by default. This means that files will be chunked and sent up to Shade concurrently. In order to configure how many simultaneous uploads you want to use, upload the 'concurrency' option in the advanced config section. Note that this uses more memory and initiates more http requests.

### Deleting files

Please note that when deleting files in Shade via rclone it will delete the file instantly, instead of sending it to the trash. This means that it will not be recoverable.


<!-- autogenerated options start - DO NOT EDIT - instead edit fs.RegInfo in backend/shade/shade.go and run make backenddocs to verify --> <!-- markdownlint-disable-line line-length -->
### Standard options

Here are the Standard options specific to shade (Shade FS).

#### --shade-drive-id

The ID of your drive, see this in the drive settings. Individual rclone configs must be made per drive.

Properties:

- Config:      drive_id
- Env Var:     RCLONE_SHADE_DRIVE_ID
- Type:        string
- Required:    true

#### --shade-api-key

An API key for your account.

Properties:

- Config:      api_key
- Env Var:     RCLONE_SHADE_API_KEY
- Type:        string
- Required:    true

### Advanced options

Here are the Advanced options specific to shade (Shade FS).

#### --shade-endpoint

Endpoint for the service.

Leave blank normally.

Properties:

- Config:      endpoint
- Env Var:     RCLONE_SHADE_ENDPOINT
- Type:        string
- Required:    false

#### --shade-chunk-size

Chunk size to use for uploading.

Any files larger than this will be uploaded in chunks of this size.

Note that this is stored in memory per transfer, so increasing it will
increase memory usage.

Minimum is 5MB, maximum is 5GB.

Properties:

- Config:      chunk_size
- Env Var:     RCLONE_SHADE_CHUNK_SIZE
- Type:        SizeSuffix
- Default:     64Mi

#### --shade-upload-concurrency

Concurrency for multipart uploads and copies. This is the number of chunks of the same file that are uploaded concurrently for multipart uploads and copies.

Properties:

- Config:      upload_concurrency
- Env Var:     RCLONE_SHADE_UPLOAD_CONCURRENCY
- Type:        int
- Default:     4

#### --shade-max-upload-parts

Maximum amount of parts in a multipart upload.

Properties:

- Config:      max_upload_parts
- Env Var:     RCLONE_SHADE_MAX_UPLOAD_PARTS
- Type:        int
- Default:     10000

#### --shade-token

JWT Token for performing Shade FS operations. Don't set this value - rclone will set it automatically

Properties:

- Config:      token
- Env Var:     RCLONE_SHADE_TOKEN
- Type:        string
- Required:    false

#### --shade-token-expiry

JWT Token Expiration time. Don't set this value - rclone will set it automatically

Properties:

- Config:      token_expiry
- Env Var:     RCLONE_SHADE_TOKEN_EXPIRY
- Type:        string
- Required:    false

#### --shade-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_SHADE_ENCODING
- Type:        Encoding
- Default:     Slash,BackSlash,Del,Ctl,InvalidUtf8,Dot

#### --shade-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_SHADE_DESCRIPTION
- Type:        string
- Required:    false

<!-- autogenerated options stop -->

## Limitations

Note that Shade is case insensitive so you can't have a file called
"Hello.doc" and one called "hello.doc".

Shade only supports filenames up to 255 characters in length.

`rclone about` is not supported by the Shade backend. Backends without
this capability cannot determine free space for an rclone mount or
use policy `mfs` (most free space) as a member of an rclone union
remote.

See [List of backends that do not support rclone about](https://rclone.org/overview/#optional-features) and [rclone about](https://rclone.org/commands/rclone_about/)

## Backend commands

Here are the commands specific to the shade backend.

Run them with

    rclone backend COMMAND remote:

The help below will explain what arguments each command takes.

See the [backend](/commands/rclone_backend/) command for more
info on how to pass options and arguments.

These can be run on a running backend using the rc command
[backend/command](/rc/#backend-command).


