/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;

public enum ArgumentType {
    key("key", false),
    keyreq("keyreq", false),
    keyrest("keyrest", false),
    block("block", false),
    opt("opt", false),
    rest("rest", false),
    req("req", false),
    anonreq("req", true),
    anonopt("opt", true),
    anonrest("rest", true),
    anonkeyrest("keyrest", true),
    nokey("nokey", true);

    public final String name;
    public final String typeId;
    public final boolean anonymous;

    private ArgumentType(String typeId, boolean anonymous) {
        this.typeId = typeId;
        this.anonymous = anonymous;
        this.name = this.toString();
    }

    public static ArgumentType valueOf(char prefix) {
        switch (prefix) {
            case 'k': {
                return key;
            }
            case 'K': {
                return keyreq;
            }
            case 'e': {
                return keyrest;
            }
            case 'b': {
                return block;
            }
            case 'o': {
                return opt;
            }
            case 'r': {
                return rest;
            }
            case 'q': {
                return req;
            }
            case 'l': {
                return nokey;
            }
            case 'n': {
                return anonreq;
            }
            case 'O': {
                return anonopt;
            }
            case 'R': {
                return anonrest;
            }
            case 'N': {
                return anonkeyrest;
            }
        }
        return null;
    }

    static char prefixFrom(ArgumentType type2) {
        switch (type2) {
            case key: {
                return 'k';
            }
            case keyreq: {
                return 'K';
            }
            case keyrest: {
                return 'e';
            }
            case block: {
                return 'b';
            }
            case opt: {
                return 'o';
            }
            case rest: {
                return 'r';
            }
            case req: {
                return 'q';
            }
            case nokey: {
                return 'l';
            }
            case anonreq: {
                return 'n';
            }
            case anonopt: {
                return 'O';
            }
            case anonrest: {
                return 'R';
            }
            case anonkeyrest: {
                return 'N';
            }
        }
        throw new IllegalArgumentException("Bogus type for ArgumentType: '" + (Object)((Object)type2) + "'");
    }

    public RubyArray toArrayForm(Ruby runtime2, RubySymbol name2) {
        RubySymbol typeName = runtime2.newSymbol(this.typeId);
        return this.anonymous ? runtime2.newArray((IRubyObject)typeName) : runtime2.newArray((IRubyObject)typeName, (IRubyObject)name2);
    }

    public ArgumentType anonymousForm() {
        switch (this) {
            case opt: {
                return anonopt;
            }
            case req: {
                return anonreq;
            }
            case rest: {
                return anonrest;
            }
            case keyrest: {
                return anonkeyrest;
            }
        }
        return this;
    }
}

