﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/comprehend/model/RelationshipType.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace Comprehend {
namespace Model {
namespace RelationshipTypeMapper {

static const int CHILD_HASH = HashingUtils::HashString("CHILD");

RelationshipType GetRelationshipTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == CHILD_HASH) {
    return RelationshipType::CHILD;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<RelationshipType>(hashCode);
  }

  return RelationshipType::NOT_SET;
}

Aws::String GetNameForRelationshipType(RelationshipType enumValue) {
  switch (enumValue) {
    case RelationshipType::NOT_SET:
      return {};
    case RelationshipType::CHILD:
      return "CHILD";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace RelationshipTypeMapper
}  // namespace Model
}  // namespace Comprehend
}  // namespace Aws
