﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bcm-pricing-calculator/model/BillScenarioSummary.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace BCMPricingCalculator {
namespace Model {

BillScenarioSummary::BillScenarioSummary(JsonView jsonValue) { *this = jsonValue; }

BillScenarioSummary& BillScenarioSummary::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("id")) {
    m_id = jsonValue.GetString("id");
    m_idHasBeenSet = true;
  }
  if (jsonValue.ValueExists("name")) {
    m_name = jsonValue.GetString("name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("billInterval")) {
    m_billInterval = jsonValue.GetObject("billInterval");
    m_billIntervalHasBeenSet = true;
  }
  if (jsonValue.ValueExists("status")) {
    m_status = BillScenarioStatusMapper::GetBillScenarioStatusForName(jsonValue.GetString("status"));
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("createdAt")) {
    m_createdAt = jsonValue.GetDouble("createdAt");
    m_createdAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("expiresAt")) {
    m_expiresAt = jsonValue.GetDouble("expiresAt");
    m_expiresAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("failureMessage")) {
    m_failureMessage = jsonValue.GetString("failureMessage");
    m_failureMessageHasBeenSet = true;
  }
  if (jsonValue.ValueExists("groupSharingPreference")) {
    m_groupSharingPreference =
        GroupSharingPreferenceEnumMapper::GetGroupSharingPreferenceEnumForName(jsonValue.GetString("groupSharingPreference"));
    m_groupSharingPreferenceHasBeenSet = true;
  }
  if (jsonValue.ValueExists("costCategoryGroupSharingPreferenceArn")) {
    m_costCategoryGroupSharingPreferenceArn = jsonValue.GetString("costCategoryGroupSharingPreferenceArn");
    m_costCategoryGroupSharingPreferenceArnHasBeenSet = true;
  }
  return *this;
}

JsonValue BillScenarioSummary::Jsonize() const {
  JsonValue payload;

  if (m_idHasBeenSet) {
    payload.WithString("id", m_id);
  }

  if (m_nameHasBeenSet) {
    payload.WithString("name", m_name);
  }

  if (m_billIntervalHasBeenSet) {
    payload.WithObject("billInterval", m_billInterval.Jsonize());
  }

  if (m_statusHasBeenSet) {
    payload.WithString("status", BillScenarioStatusMapper::GetNameForBillScenarioStatus(m_status));
  }

  if (m_createdAtHasBeenSet) {
    payload.WithDouble("createdAt", m_createdAt.SecondsWithMSPrecision());
  }

  if (m_expiresAtHasBeenSet) {
    payload.WithDouble("expiresAt", m_expiresAt.SecondsWithMSPrecision());
  }

  if (m_failureMessageHasBeenSet) {
    payload.WithString("failureMessage", m_failureMessage);
  }

  if (m_groupSharingPreferenceHasBeenSet) {
    payload.WithString("groupSharingPreference",
                       GroupSharingPreferenceEnumMapper::GetNameForGroupSharingPreferenceEnum(m_groupSharingPreference));
  }

  if (m_costCategoryGroupSharingPreferenceArnHasBeenSet) {
    payload.WithString("costCategoryGroupSharingPreferenceArn", m_costCategoryGroupSharingPreferenceArn);
  }

  return payload;
}

}  // namespace Model
}  // namespace BCMPricingCalculator
}  // namespace Aws
