// @generated by protoc-gen-es v2.6.0 with parameter "target=js+dts,import_extension=none,json_types=true"
// @generated from file runme/runner/v2/config.proto (package runme.runner.v2, syntax proto3)
/* eslint-disable */

import type { GenEnum, GenFile, GenMessage } from "@bufbuild/protobuf/codegenv2";
import type { Message } from "@bufbuild/protobuf";

/**
 * Describes the file runme/runner/v2/config.proto.
 */
export declare const file_runme_runner_v2_config: GenFile;

/**
 * ProgramConfig is a configuration for a program to execute.
 * From this configuration, any program can be built.
 *
 * @generated from message runme.runner.v2.ProgramConfig
 */
export declare type ProgramConfig = Message<"runme.runner.v2.ProgramConfig"> & {
  /**
   * program_name is a name of the program to execute.
   * If it's not a path (relative or absolute), the runner
   * will try to resolve the name.
   * For example: "sh", "/bin/bash".
   *
   * @generated from field: string program_name = 1;
   */
  programName: string;

  /**
   * arguments is a list of arguments passed to the program.
   *
   * @generated from field: repeated string arguments = 2;
   */
  arguments: string[];

  /**
   * directory to execute the program in.
   *
   * @generated from field: string directory = 3;
   */
  directory: string;

  /**
   * language_id associated with script to allow interpreter
   * detection if no specific interpreter program is provided.
   *
   * @generated from field: string language_id = 4;
   */
  languageId: string;

  /**
   * background indicates a background process
   * required to handle running background tasks via CLI in C/I
   *
   * @generated from field: bool background = 5;
   */
  background: boolean;

  /**
   * file_extension associated with script. Some interpreters are strict
   * about file extensions, such as tsc which requires "ts" extension.
   *
   * @generated from field: string file_extension = 6;
   */
  fileExtension: string;

  /**
   * env is a list of additional environment variables
   * that will be injected to the executed program.
   *
   * @generated from field: repeated string env = 7;
   */
  env: string[];

  /**
   * @generated from oneof runme.runner.v2.ProgramConfig.source
   */
  source: {
    /**
     * commands are commands to be executed by the program.
     * The commands are joined and executed as a script.
     *
     * @generated from field: runme.runner.v2.ProgramConfig.CommandList commands = 8;
     */
    value: ProgramConfig_CommandList;
    case: "commands";
  } | {
    /**
     * script is code to be executed by the program.
     * Individual lines are joined with the new line character.
     *
     * @generated from field: string script = 9;
     */
    value: string;
    case: "script";
  } | { case: undefined; value?: undefined };

  /**
   * interactive, if true, uses a pseudo-tty to execute the program.
   * Otherwise, the program is executed using in-memory buffers for I/O.
   *
   * @generated from field: bool interactive = 10;
   */
  interactive: boolean;

  /**
   * TODO(adamb): understand motivation for this. In theory, source
   * should tell whether to execute it inline or as a file.
   *
   * @generated from field: runme.runner.v2.CommandMode mode = 11;
   */
  mode: CommandMode;

  /**
   * optional well known id for cell/block
   *
   * @generated from field: string known_id = 12;
   */
  knownId: string;

  /**
   * optional well known name for cell/block
   *
   * @generated from field: string known_name = 13;
   */
  knownName: string;

  /**
   * optional run ID to track the execution of the program
   *
   * @generated from field: string run_id = 14;
   */
  runId: string;
};

/**
 * ProgramConfig is a configuration for a program to execute.
 * From this configuration, any program can be built.
 *
 * @generated from message runme.runner.v2.ProgramConfig
 */
export declare type ProgramConfigJson = {
  /**
   * program_name is a name of the program to execute.
   * If it's not a path (relative or absolute), the runner
   * will try to resolve the name.
   * For example: "sh", "/bin/bash".
   *
   * @generated from field: string program_name = 1;
   */
  programName?: string;

  /**
   * arguments is a list of arguments passed to the program.
   *
   * @generated from field: repeated string arguments = 2;
   */
  arguments?: string[];

  /**
   * directory to execute the program in.
   *
   * @generated from field: string directory = 3;
   */
  directory?: string;

  /**
   * language_id associated with script to allow interpreter
   * detection if no specific interpreter program is provided.
   *
   * @generated from field: string language_id = 4;
   */
  languageId?: string;

  /**
   * background indicates a background process
   * required to handle running background tasks via CLI in C/I
   *
   * @generated from field: bool background = 5;
   */
  background?: boolean;

  /**
   * file_extension associated with script. Some interpreters are strict
   * about file extensions, such as tsc which requires "ts" extension.
   *
   * @generated from field: string file_extension = 6;
   */
  fileExtension?: string;

  /**
   * env is a list of additional environment variables
   * that will be injected to the executed program.
   *
   * @generated from field: repeated string env = 7;
   */
  env?: string[];

  /**
   * commands are commands to be executed by the program.
   * The commands are joined and executed as a script.
   *
   * @generated from field: runme.runner.v2.ProgramConfig.CommandList commands = 8;
   */
  commands?: ProgramConfig_CommandListJson;

  /**
   * script is code to be executed by the program.
   * Individual lines are joined with the new line character.
   *
   * @generated from field: string script = 9;
   */
  script?: string;

  /**
   * interactive, if true, uses a pseudo-tty to execute the program.
   * Otherwise, the program is executed using in-memory buffers for I/O.
   *
   * @generated from field: bool interactive = 10;
   */
  interactive?: boolean;

  /**
   * TODO(adamb): understand motivation for this. In theory, source
   * should tell whether to execute it inline or as a file.
   *
   * @generated from field: runme.runner.v2.CommandMode mode = 11;
   */
  mode?: CommandModeJson;

  /**
   * optional well known id for cell/block
   *
   * @generated from field: string known_id = 12;
   */
  knownId?: string;

  /**
   * optional well known name for cell/block
   *
   * @generated from field: string known_name = 13;
   */
  knownName?: string;

  /**
   * optional run ID to track the execution of the program
   *
   * @generated from field: string run_id = 14;
   */
  runId?: string;
};

/**
 * Describes the message runme.runner.v2.ProgramConfig.
 * Use `create(ProgramConfigSchema)` to create a new message.
 */
export declare const ProgramConfigSchema: GenMessage<ProgramConfig, {jsonType: ProgramConfigJson}>;

/**
 * @generated from message runme.runner.v2.ProgramConfig.CommandList
 */
export declare type ProgramConfig_CommandList = Message<"runme.runner.v2.ProgramConfig.CommandList"> & {
  /**
   * commands are commands to be executed by the program.
   * The commands are joined and executed as a script.
   * For example: ["echo 'Hello, World'", "ls -l /etc"].
   *
   * @generated from field: repeated string items = 1;
   */
  items: string[];
};

/**
 * @generated from message runme.runner.v2.ProgramConfig.CommandList
 */
export declare type ProgramConfig_CommandListJson = {
  /**
   * commands are commands to be executed by the program.
   * The commands are joined and executed as a script.
   * For example: ["echo 'Hello, World'", "ls -l /etc"].
   *
   * @generated from field: repeated string items = 1;
   */
  items?: string[];
};

/**
 * Describes the message runme.runner.v2.ProgramConfig.CommandList.
 * Use `create(ProgramConfig_CommandListSchema)` to create a new message.
 */
export declare const ProgramConfig_CommandListSchema: GenMessage<ProgramConfig_CommandList, {jsonType: ProgramConfig_CommandListJson}>;

/**
 * @generated from enum runme.runner.v2.CommandMode
 */
export enum CommandMode {
  /**
   * @generated from enum value: COMMAND_MODE_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * COMMAND_MODE_INLINE indicates that the command should be executed inline.
   * For example: bash -c "echo 'Hello, World'"
   *
   * @generated from enum value: COMMAND_MODE_INLINE = 1;
   */
  INLINE = 1,

  /**
   * COMMAND_MODE_FILE indicates that the command should be executed as a file.
   * For example: bash /tmp/script.sh
   *
   * @generated from enum value: COMMAND_MODE_FILE = 2;
   */
  FILE = 2,

  /**
   * COMMAND_MODE_TERMINAL indicates that the command should be executed as a Runme Terminal.
   * This is used by the VS Code extension.
   *
   * @generated from enum value: COMMAND_MODE_TERMINAL = 3;
   */
  TERMINAL = 3,

  /**
   * COMMAND_MODE_CLI indicates that the command is executed via runme CLI.
   * It is executed as a native command.
   *
   * @generated from enum value: COMMAND_MODE_CLI = 4;
   */
  CLI = 4,
}

/**
 * @generated from enum runme.runner.v2.CommandMode
 */
export declare type CommandModeJson = "COMMAND_MODE_UNSPECIFIED" | "COMMAND_MODE_INLINE" | "COMMAND_MODE_FILE" | "COMMAND_MODE_TERMINAL" | "COMMAND_MODE_CLI";

/**
 * Describes the enum runme.runner.v2.CommandMode.
 */
export declare const CommandModeSchema: GenEnum<CommandMode, CommandModeJson>;
