/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.DefaultedArgumentExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.FoldingFunction;
import net.sf.saxon.functions.hof.FunctionLiteral;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.YearMonthDurationValue;

public class Sum
extends FoldingFunction {
    @Override
    public Expression makeFunctionCall(Expression ... arguments) {
        Expression[] newArgs = new Expression[2];
        newArgs[0] = arguments[0];
        if (arguments.length < 2 || arguments[1] instanceof DefaultedArgumentExpression) {
            newArgs[1] = FunctionLiteral.makeLiteral(Int64Value.ZERO);
            this.setArity(2);
        } else {
            newArgs[1] = arguments[1];
        }
        return super.makeFunctionCall(newArgs);
    }

    @Override
    public ItemType getResultItemType(Expression[] args) {
        TypeHierarchy th = this.getRetainedStaticContext().getConfiguration().getTypeHierarchy();
        ItemType base = Atomizer.getAtomizedItemType(args[0], false, th);
        if (base.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            base = BuiltInAtomicType.DOUBLE;
        }
        if (Cardinality.allowsZero(args[0].getCardinality())) {
            if (this.getArity() == 1) {
                return Type.getCommonSuperType(base, BuiltInAtomicType.INTEGER, th);
            }
            return Type.getCommonSuperType(base, args[1].getItemType(), th);
        }
        return base.getPrimitiveItemType();
    }

    @Override
    public int getCardinality(Expression[] arguments) {
        if (this.getArity() == 1 || arguments[1].getCardinality() == 1) {
            return 16384;
        }
        return 24576;
    }

    @Override
    public Fold getFold(XPathContext context, Sequence ... additionalArguments) throws XPathException {
        if (additionalArguments.length > 0) {
            AtomicValue z = (AtomicValue)additionalArguments[0].head();
            return new SumFold(context, z);
        }
        return new SumFold(context, Int64Value.ZERO);
    }

    public static AtomicValue total(SequenceIterator in, XPathContext context, Location locator) throws XPathException {
        try {
            SumFold fold = new SumFold(context, null);
            SequenceTool.supply(in, fold::processItem);
            return (AtomicValue)fold.result().head();
        }
        catch (XPathException e) {
            throw e.maybeWithLocation(locator).maybeWithContext(context);
        }
    }

    @Override
    public Elaborator getElaborator() {
        return new SumFnElaborator();
    }

    public static class SumFold
    implements Fold {
        private final XPathContext context;
        private final AtomicValue zeroValue;
        private AtomicValue data;
        private boolean atStart = true;
        private final ConversionRules rules;
        private final StringConverter toDouble;

        public SumFold(XPathContext context, AtomicValue zeroValue) {
            this.context = context;
            this.zeroValue = zeroValue;
            this.rules = context.getConfiguration().getConversionRules();
            this.toDouble = BuiltInAtomicType.DOUBLE.getStringConverter(this.rules);
        }

        @Override
        public void processItem(Item item) throws XPathException {
            AtomicValue next = (AtomicValue)item;
            if (this.atStart) {
                this.atStart = false;
                if (next.isUntypedAtomic()) {
                    this.data = this.toDouble.convert(next).asAtomic();
                    return;
                }
                if (next instanceof NumericValue || next instanceof DayTimeDurationValue || next instanceof YearMonthDurationValue) {
                    this.data = next;
                    return;
                }
                throw new XPathException("Input to sum() contains a value of type " + next.getPrimitiveType().getDisplayName() + " which is neither numeric, nor a duration").withXPathContext(this.context).withErrorCode("FORG0006");
            }
            if (this.data instanceof NumericValue) {
                if (next.isUntypedAtomic()) {
                    next = this.toDouble.convert(next).asAtomic();
                } else if (!(next instanceof NumericValue)) {
                    throw new XPathException("Input to sum() contains a mix of numeric and non-numeric values").withXPathContext(this.context).withErrorCode("FORG0006");
                }
                this.data = ArithmeticExpression.compute(this.data, 0, next, this.context);
            } else if (this.data instanceof DurationValue) {
                if (!(this.data instanceof DayTimeDurationValue) && !(this.data instanceof YearMonthDurationValue)) {
                    throw new XPathException("Input to sum() contains a duration that is neither a dayTimeDuration nor a yearMonthDuration").withXPathContext(this.context).withErrorCode("FORG0006");
                }
                if (!(next instanceof DurationValue)) {
                    throw new XPathException("Input to sum() contains a mix of duration and non-duration values").withXPathContext(this.context).withErrorCode("FORG0006");
                }
                this.data = ((DurationValue)this.data).add((DurationValue)next);
            } else {
                throw new XPathException("Input to sum() contains a value of type " + this.data.getPrimitiveType().getDisplayName() + " which is neither numeric, nor a duration").withXPathContext(this.context).withErrorCode("FORG0006");
            }
        }

        @Override
        public boolean isFinished() {
            return this.data instanceof DoubleValue && this.data.isNaN();
        }

        @Override
        public Sequence result() {
            if (this.atStart) {
                return SequenceTool.itemOrEmpty(this.zeroValue);
            }
            return this.data;
        }
    }

    public static class SumFnElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            PullEvaluator puller = fnc.getArg(0).makeElaborator().elaborateForPull();
            boolean defaultSecondArg = fnc.getArity() < 2 || fnc.getArg(1) instanceof DefaultedArgumentExpression;
            ItemEvaluator zero = defaultSecondArg ? context -> Int64Value.ZERO : fnc.getArg(1).makeElaborator().elaborateForItem();
            return context -> {
                Item it;
                SumFold fold = new SumFold(context, (AtomicValue)zero.eval(context));
                SequenceIterator iter = puller.iterate(context);
                while ((it = iter.next()) != null) {
                    fold.processItem(it);
                }
                return fold.result().head();
            };
        }
    }
}

