// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#![cfg(feature = "test-util")]
#[::tokio::test]
async fn operation_input_test_get_object_1() {
    /* documentation: Invalid access point ARN: Not S3 */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:not-s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error =
        _result.expect_err("expected error: Invalid ARN: The ARN was not for the S3 service, found: not-s3 [Invalid access point ARN: Not S3]");
    assert!(
        format!("{:?}", error).contains("Invalid ARN: The ARN was not for the S3 service, found: not-s3"),
        "expected error to contain `Invalid ARN: The ARN was not for the S3 service, found: not-s3` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_2() {
    /* documentation: Invalid access point ARN: invalid resource */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint:more-data".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: The ARN may only contain a single resource component after `accesspoint`. [Invalid access point ARN: invalid resource]");
    assert!(
        format!("{:?}", error).contains("Invalid ARN: The ARN may only contain a single resource component after `accesspoint`."),
        "expected error to contain `Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_3() {
    /* documentation: Invalid access point ARN: invalid no ap name */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("arn:aws:s3:us-west-2:123456789012:accesspoint:".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided [Invalid access point ARN: invalid no ap name]");
    assert!(
                                            format!("{:?}", error).contains("Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided"),
                                            "expected error to contain `Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_4() {
    /* documentation: Invalid access point ARN: AccountId is invalid */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456_789012:accesspoint:apname".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123456_789012` [Invalid access point ARN: AccountId is invalid]");
    assert!(
        format!("{:?}", error).contains("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123456_789012`"),
        "expected error to contain `Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123456_789012`` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_5() {
    /* documentation: Invalid access point ARN: access point name is invalid */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:ap_name".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `ap_name` [Invalid access point ARN: access point name is invalid]");
    assert!(
        format!("{:?}", error).contains("Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `ap_name`"),
        "expected error to contain `Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `ap_name`` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_6() {
    /* documentation: Access points (disable access points explicitly false) */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_7() {
    /* documentation: Access points: partition does not support FIPS */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Partition does not support FIPS [Access points: partition does not support FIPS]");
    assert!(
        format!("{:?}", error).contains("Partition does not support FIPS"),
        "expected error to contain `Partition does not support FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_8() {
    /* documentation: Bucket region is invalid */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west -2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid region in ARN: `us-west -2` (invalid DNS name) [Bucket region is invalid]");
    assert!(
        format!("{:?}", error).contains("Invalid region in ARN: `us-west -2` (invalid DNS name)"),
        "expected error to contain `Invalid region in ARN: `us-west -2` (invalid DNS name)` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_create_bucket_9() {
    /* documentation: Access points when Access points explicitly disabled (used for CreateBucket) */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .create_bucket()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Access points are not supported for this operation [Access points when Access points explicitly disabled (used for CreateBucket)]");
    assert!(
        format!("{:?}", error).contains("Access points are not supported for this operation"),
        "expected error to contain `Access points are not supported for this operation` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_10() {
    /* documentation: missing arn type */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("arn:aws:s3:us-west-2:123456789012:".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: `arn:aws:s3:us-west-2:123456789012:` was not a valid ARN [missing arn type]");
    assert!(
        format!("{:?}", error).contains("Invalid ARN: `arn:aws:s3:us-west-2:123456789012:` was not a valid ARN"),
        "expected error to contain `Invalid ARN: `arn:aws:s3:us-west-2:123456789012:` was not a valid ARN` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_11() {
    /* documentation: SDK::Host + access point + Dualstack is an error */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::UseDualStack": true,
        "SDK::Endpoint": "https://beta.example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.endpoint_url("https://beta.example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err(
        "expected error: Cannot set dual-stack in combination with a custom endpoint. [SDK::Host + access point + Dualstack is an error]",
    );
    assert!(
        format!("{:?}", error).contains("Cannot set dual-stack in combination with a custom endpoint."),
        "expected error to contain `Cannot set dual-stack in combination with a custom endpoint.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_12() {
    /* documentation: Access point ARN with FIPS & Dualstack */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_13() {
    /* documentation: Access point ARN with Dualstack */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.dualstack.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.dualstack.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_14() {
    /* documentation: vanilla MRAP */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mfzwi23gnjvgw.mrap.accesspoint.s3-global.amazonaws.com"),
        "expected URI to start with `https://mfzwi23gnjvgw.mrap.accesspoint.s3-global.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_15() {
    /* documentation: MRAP does not support FIPS */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3 MRAP does not support FIPS [MRAP does not support FIPS]");
    assert!(
        format!("{:?}", error).contains("S3 MRAP does not support FIPS"),
        "expected error to contain `S3 MRAP does not support FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_16() {
    /* documentation: MRAP does not support DualStack */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3 MRAP does not support dual-stack [MRAP does not support DualStack]");
    assert!(
        format!("{:?}", error).contains("S3 MRAP does not support dual-stack"),
        "expected error to contain `S3 MRAP does not support dual-stack` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_17() {
    /* documentation: MRAP does not support S3 Accelerate */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3 MRAP does not support S3 Accelerate [MRAP does not support S3 Accelerate]");
    assert!(
        format!("{:?}", error).contains("S3 MRAP does not support S3 Accelerate"),
        "expected error to contain `S3 MRAP does not support S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_18() {
    /* documentation: MRAP explicitly disabled */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::S3::DisableMultiRegionAccessPoints": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.disable_multi_region_access_points(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: Multi-Region Access Point ARNs are disabled. [MRAP explicitly disabled]");
    assert!(
        format!("{:?}", error).contains("Invalid configuration: Multi-Region Access Point ARNs are disabled."),
        "expected error to contain `Invalid configuration: Multi-Region Access Point ARNs are disabled.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_19() {
    /* documentation: Dual-stack endpoint with path-style forced */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucketname".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.us-west-2.amazonaws.com/bucketname"),
        "expected URI to start with `https://s3.dualstack.us-west-2.amazonaws.com/bucketname` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_20() {
    /* documentation: Dual-stack endpoint + SDK::Host is error */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "SDK::Endpoint": "https://abc.com",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.endpoint_url("https://abc.com");
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucketname".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error =
        _result.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [Dual-stack endpoint + SDK::Host is error]");
    assert!(
        format!("{:?}", error).contains("Cannot set dual-stack in combination with a custom endpoint."),
        "expected error to contain `Cannot set dual-stack in combination with a custom endpoint.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_21() {
    /* documentation: path style + ARN bucket */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Path-style addressing cannot be used with ARN buckets [path style + ARN bucket]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with ARN buckets"),
        "expected error to contain `Path-style addressing cannot be used with ARN buckets` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_22() {
    /* documentation: implicit path style bucket + dualstack */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99_ab".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.us-west-2.amazonaws.com/99_ab"),
        "expected URI to start with `https://s3.dualstack.us-west-2.amazonaws.com/99_ab` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_23() {
    /* documentation: implicit path style bucket + dualstack */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "SDK::Endpoint": "http://abc.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.endpoint_url("http://abc.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99_ab".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error =
        _result.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [implicit path style bucket + dualstack]");
    assert!(
        format!("{:?}", error).contains("Cannot set dual-stack in combination with a custom endpoint."),
        "expected error to contain `Cannot set dual-stack in combination with a custom endpoint.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_24() {
    /* documentation: don't allow URL injections in the bucket */
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("example.com#".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-west-2.amazonaws.com/example.com%23"),
        "expected URI to start with `https://s3.us-west-2.amazonaws.com/example.com%23` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_25() {
    /* documentation: URI encode bucket names in the path */
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-west-2.amazonaws.com/bucket%20name"),
        "expected URI to start with `https://s3.us-west-2.amazonaws.com/bucket%20name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_26() {
    /* documentation: path style + implicit private link */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99_ab".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/99_ab"),
        "expected URI to start with `https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/99_ab` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_27() {
    /* documentation: using an IPv4 address forces path style */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "SDK::Endpoint": "https://123.123.0.1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.endpoint_url("https://123.123.0.1");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucketname".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://123.123.0.1/bucketname"),
        "expected URI to start with `https://123.123.0.1/bucketname` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_28() {
    /* documentation: vanilla access point arn with region mismatch and UseArnRegion=false */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-east-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false` [vanilla access point arn with region mismatch and UseArnRegion=false]");
    assert!(
                                            format!("{:?}", error).contains("Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`"),
                                            "expected error to contain `Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_29() {
    /* documentation: vanilla access point arn with region mismatch and UseArnRegion unset */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_30() {
    /* documentation: vanilla access point arn with region mismatch and UseArnRegion=true */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_31() {
    /* documentation: subdomains are not allowed in virtual buckets */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket.name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-east-1.amazonaws.com/bucket.name"),
        "expected URI to start with `https://s3.us-east-1.amazonaws.com/bucket.name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_32() {
    /* documentation: bucket names with 3 characters are allowed in virtual buckets */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("aaa".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://aaa.s3.us-east-1.amazonaws.com"),
        "expected URI to start with `https://aaa.s3.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_33() {
    /* documentation: bucket names with fewer than 3 characters are not allowed in virtual host */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("aa".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-east-1.amazonaws.com/aa"),
        "expected URI to start with `https://s3.us-east-1.amazonaws.com/aa` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_34() {
    /* documentation: bucket names with uppercase characters are not allowed in virtual host */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("BucketName".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-east-1.amazonaws.com/BucketName"),
        "expected URI to start with `https://s3.us-east-1.amazonaws.com/BucketName` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_35() {
    /* documentation: subdomains are allowed in virtual buckets on http endpoints */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "SDK::Endpoint": "http://example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.endpoint_url("http://example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket.name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("http://bucket.name.example.com"),
        "expected URI to start with `http://bucket.name.example.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_buckets_36() {
    /* documentation: aws-global region uses the global endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.amazonaws.com"),
        "expected URI to start with `https://s3.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_buckets_37() {
    /* documentation: aws-global region with fips uses the regional endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3-fips.us-east-1.amazonaws.com"),
        "expected URI to start with `https://s3-fips.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_buckets_38() {
    /* documentation: aws-global region with dualstack uses the regional endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.us-east-1.amazonaws.com"),
        "expected URI to start with `https://s3.dualstack.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_buckets_39() {
    /* documentation: aws-global region with fips and dualstack uses the regional endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3-fips.dualstack.us-east-1.amazonaws.com"),
        "expected URI to start with `https://s3-fips.dualstack.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_buckets_40() {
    /* documentation: aws-global region with accelerate on non-bucket case, uses global endpoint and ignores accelerate */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.amazonaws.com"),
        "expected URI to start with `https://s3.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_buckets_41() {
    /* documentation: aws-global region with custom endpoint, uses custom */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "SDK::Endpoint": "https://example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.endpoint_url("https://example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://example.com"),
        "expected URI to start with `https://example.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_42() {
    /* documentation: virtual addressing, aws-global region uses the global endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_objects_43() {
    /* documentation: virtual addressing, aws-global region with Prefix, and Key uses the global endpoint. Prefix and Key parameters should not be used in endpoint evaluation. */
    /* builtIns: {
        "AWS::Region": "aws-global"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .list_objects()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_prefix(::std::option::Option::Some("prefix".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_44() {
    /* documentation: virtual addressing, aws-global region with fips uses the regional fips endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-fips.us-east-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-fips.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_45() {
    /* documentation: virtual addressing, aws-global region with dualstack uses the regional dualstack endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.dualstack.us-east-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.dualstack.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_46() {
    /* documentation: virtual addressing, aws-global region with fips/dualstack uses the regional fips/dualstack endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-fips.dualstack.us-east-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-fips.dualstack.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_47() {
    /* documentation: virtual addressing, aws-global region with accelerate uses the global accelerate endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-accelerate.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-accelerate.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_48() {
    /* documentation: virtual addressing, aws-global region with custom endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "SDK::Endpoint": "https://example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.endpoint_url("https://example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.example.com"),
        "expected URI to start with `https://bucket-name.example.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_49() {
    /* documentation: ForcePathStyle, aws-global region uses the global endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_50() {
    /* documentation: ForcePathStyle, aws-global region with dualstack uses regional dualstack endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::UseDualStack": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.us-east-1.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3.dualstack.us-east-1.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_51() {
    /* documentation: ForcePathStyle, aws-global region custom endpoint uses the custom endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "SDK::Endpoint": "https://example.com",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.endpoint_url("https://example.com");
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://example.com/bucket-name"),
        "expected URI to start with `https://example.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_52() {
    /* documentation: ARN with aws-global region and  UseArnRegion uses the regional endpoint */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://reports-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com"),
        "expected URI to start with `https://reports-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_53() {
    /* documentation: cross partition MRAP ARN is an error */
    /* builtIns: {
        "AWS::Region": "us-west-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws-cn:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err(
        "expected error: Client was configured for partition `aws` but bucket referred to partition `aws-cn` [cross partition MRAP ARN is an error]",
    );
    assert!(
        format!("{:?}", error).contains("Client was configured for partition `aws` but bucket referred to partition `aws-cn`"),
        "expected error to contain `Client was configured for partition `aws` but bucket referred to partition `aws-cn`` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_54() {
    /* documentation: Endpoint override, accesspoint with HTTP, port */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "http://beta.example.com:1234"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("http://beta.example.com:1234");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("http://myendpoint-123456789012.beta.example.com:1234"),
        "expected URI to start with `http://myendpoint-123456789012.beta.example.com:1234` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_55() {
    /* documentation: vanilla virtual addressing@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.us-west-2.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_56() {
    /* documentation: virtual addressing + dualstack@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.dualstack.us-west-2.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.dualstack.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_57() {
    /* documentation: accelerate + dualstack@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-accelerate.dualstack.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-accelerate.dualstack.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_58() {
    /* documentation: accelerate (dualstack=false)@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-accelerate.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-accelerate.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_59() {
    /* documentation: virtual addressing + fips@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-fips.us-west-2.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-fips.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_60() {
    /* documentation: virtual addressing + dualstack + fips@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-fips.dualstack.us-west-2.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-fips.dualstack.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_61() {
    /* documentation: accelerate + fips = error@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Accelerate cannot be used with FIPS [accelerate + fips = error@us-west-2]");
    assert!(
        format!("{:?}", error).contains("Accelerate cannot be used with FIPS"),
        "expected error to contain `Accelerate cannot be used with FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_62() {
    /* documentation: vanilla virtual addressing@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.cn-north-1.amazonaws.com.cn"),
        "expected URI to start with `https://bucket-name.s3.cn-north-1.amazonaws.com.cn` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_63() {
    /* documentation: virtual addressing + dualstack@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.dualstack.cn-north-1.amazonaws.com.cn"),
        "expected URI to start with `https://bucket-name.s3.dualstack.cn-north-1.amazonaws.com.cn` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_64() {
    /* documentation: vanilla virtual addressing@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.af-south-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_65() {
    /* documentation: virtual addressing + dualstack@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3.dualstack.af-south-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3.dualstack.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_66() {
    /* documentation: accelerate + dualstack@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseDualStack": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-accelerate.dualstack.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-accelerate.dualstack.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_67() {
    /* documentation: accelerate (dualstack=false)@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-accelerate.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-accelerate.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_68() {
    /* documentation: virtual addressing + fips@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-fips.af-south-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-fips.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_69() {
    /* documentation: virtual addressing + dualstack + fips@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.s3-fips.dualstack.af-south-1.amazonaws.com"),
        "expected URI to start with `https://bucket-name.s3-fips.dualstack.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_70() {
    /* documentation: accelerate + fips = error@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Accelerate cannot be used with FIPS [accelerate + fips = error@af-south-1]");
    assert!(
        format!("{:?}", error).contains("Accelerate cannot be used with FIPS"),
        "expected error to contain `Accelerate cannot be used with FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_71() {
    /* documentation: vanilla path style@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-west-2.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3.us-west-2.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_72() {
    /* documentation: fips@us-gov-west-2, bucket is not S3-dns-compatible (subdomains) */
    /* builtIns: {
        "AWS::Region": "us-gov-west-1",
        "AWS::UseFIPS": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-gov-west-1"));
        let builder = builder.use_fips(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket.with.dots".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3-fips.us-gov-west-1.amazonaws.com/bucket.with.dots"),
        "expected URI to start with `https://s3-fips.us-gov-west-1.amazonaws.com/bucket.with.dots` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_73() {
    /* documentation: path style + accelerate = error@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::ForcePathStyle": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.force_path_style(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error =
        _result.expect_err("expected error: Path-style addressing cannot be used with S3 Accelerate [path style + accelerate = error@us-west-2]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with S3 Accelerate"),
        "expected error to contain `Path-style addressing cannot be used with S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_74() {
    /* documentation: path style + dualstack@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.us-west-2.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3.dualstack.us-west-2.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_75() {
    /* documentation: path style + arn is error@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Path-style addressing cannot be used with ARN buckets [path style + arn is error@us-west-2]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with ARN buckets"),
        "expected error to contain `Path-style addressing cannot be used with ARN buckets` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_76() {
    /* documentation: path style + invalid DNS name@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99a_b".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-west-2.amazonaws.com/99a_b"),
        "expected URI to start with `https://s3.us-west-2.amazonaws.com/99a_b` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_77() {
    /* documentation: no path style + invalid DNS name@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99a_b".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.us-west-2.amazonaws.com/99a_b"),
        "expected URI to start with `https://s3.us-west-2.amazonaws.com/99a_b` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_78() {
    /* documentation: vanilla path style@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.cn-north-1.amazonaws.com.cn/bucket-name"),
        "expected URI to start with `https://s3.cn-north-1.amazonaws.com.cn/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_79() {
    /* documentation: path style + fips@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::UseFIPS": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.use_fips(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Partition does not support FIPS [path style + fips@cn-north-1]");
    assert!(
        format!("{:?}", error).contains("Partition does not support FIPS"),
        "expected error to contain `Partition does not support FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_80() {
    /* documentation: path style + accelerate = error@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::S3::ForcePathStyle": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.force_path_style(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error =
        _result.expect_err("expected error: Path-style addressing cannot be used with S3 Accelerate [path style + accelerate = error@cn-north-1]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with S3 Accelerate"),
        "expected error to contain `Path-style addressing cannot be used with S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_81() {
    /* documentation: path style + dualstack@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::UseDualStack": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.cn-north-1.amazonaws.com.cn/bucket-name"),
        "expected URI to start with `https://s3.dualstack.cn-north-1.amazonaws.com.cn/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_82() {
    /* documentation: path style + arn is error@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Path-style addressing cannot be used with ARN buckets [path style + arn is error@cn-north-1]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with ARN buckets"),
        "expected error to contain `Path-style addressing cannot be used with ARN buckets` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_83() {
    /* documentation: path style + invalid DNS name@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99a_b".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.cn-north-1.amazonaws.com.cn/99a_b"),
        "expected URI to start with `https://s3.cn-north-1.amazonaws.com.cn/99a_b` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_84() {
    /* documentation: no path style + invalid DNS name@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99a_b".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.cn-north-1.amazonaws.com.cn/99a_b"),
        "expected URI to start with `https://s3.cn-north-1.amazonaws.com.cn/99a_b` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_85() {
    /* documentation: vanilla path style@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.af-south-1.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3.af-south-1.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_86() {
    /* documentation: path style + fips@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3-fips.af-south-1.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3-fips.af-south-1.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_87() {
    /* documentation: path style + accelerate = error@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::S3::ForcePathStyle": true,
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.force_path_style(true);
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error =
        _result.expect_err("expected error: Path-style addressing cannot be used with S3 Accelerate [path style + accelerate = error@af-south-1]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with S3 Accelerate"),
        "expected error to contain `Path-style addressing cannot be used with S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_88() {
    /* documentation: path style + dualstack@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseDualStack": true,
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.dualstack.af-south-1.amazonaws.com/bucket-name"),
        "expected URI to start with `https://s3.dualstack.af-south-1.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_89() {
    /* documentation: path style + arn is error@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Path-style addressing cannot be used with ARN buckets [path style + arn is error@af-south-1]");
    assert!(
        format!("{:?}", error).contains("Path-style addressing cannot be used with ARN buckets"),
        "expected error to contain `Path-style addressing cannot be used with ARN buckets` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_90() {
    /* documentation: path style + invalid DNS name@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99a_b".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.af-south-1.amazonaws.com/99a_b"),
        "expected URI to start with `https://s3.af-south-1.amazonaws.com/99a_b` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_91() {
    /* documentation: no path style + invalid DNS name@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("99a_b".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3.af-south-1.amazonaws.com/99a_b"),
        "expected URI to start with `https://s3.af-south-1.amazonaws.com/99a_b` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_92() {
    /* documentation: virtual addressing + private link@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("http://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
        "expected URI to start with `http://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_93() {
    /* documentation: path style + private link@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name"),
        "expected URI to start with `https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_94() {
    /* documentation: SDK::Host + FIPS@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true,
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: A custom endpoint cannot be combined with FIPS [SDK::Host + FIPS@us-west-2]");
    assert!(
        format!("{:?}", error).contains("A custom endpoint cannot be combined with FIPS"),
        "expected error to contain `A custom endpoint cannot be combined with FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_95() {
    /* documentation: SDK::Host + DualStack@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [SDK::Host + DualStack@us-west-2]");
    assert!(
        format!("{:?}", error).contains("Cannot set dual-stack in combination with a custom endpoint."),
        "expected error to contain `Cannot set dual-stack in combination with a custom endpoint.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_96() {
    /* documentation: SDK::HOST + accelerate@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: A custom endpoint cannot be combined with S3 Accelerate [SDK::HOST + accelerate@us-west-2]");
    assert!(
        format!("{:?}", error).contains("A custom endpoint cannot be combined with S3 Accelerate"),
        "expected error to contain `A custom endpoint cannot be combined with S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_97() {
    /* documentation: SDK::Host + access point ARN@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://beta.example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://beta.example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.beta.example.com"),
        "expected URI to start with `https://myendpoint-123456789012.beta.example.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_98() {
    /* documentation: virtual addressing + private link@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
        "expected URI to start with `https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_99() {
    /* documentation: path style + private link@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name"),
        "expected URI to start with `https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_100() {
    /* documentation: SDK::Host + DualStack@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::UseDualStack": true,
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [SDK::Host + DualStack@cn-north-1]");
    assert!(
        format!("{:?}", error).contains("Cannot set dual-stack in combination with a custom endpoint."),
        "expected error to contain `Cannot set dual-stack in combination with a custom endpoint.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_101() {
    /* documentation: SDK::Host + access point ARN@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "SDK::Endpoint": "https://beta.example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.endpoint_url("https://beta.example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.beta.example.com"),
        "expected URI to start with `https://myendpoint-123456789012.beta.example.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_102() {
    /* documentation: virtual addressing + private link@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
        "expected URI to start with `https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_103() {
    /* documentation: path style + private link@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com",
        "AWS::S3::ForcePathStyle": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        let builder = builder.force_path_style(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name"),
        "expected URI to start with `https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_104() {
    /* documentation: SDK::Host + FIPS@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true,
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: A custom endpoint cannot be combined with FIPS [SDK::Host + FIPS@af-south-1]");
    assert!(
        format!("{:?}", error).contains("A custom endpoint cannot be combined with FIPS"),
        "expected error to contain `A custom endpoint cannot be combined with FIPS` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_105() {
    /* documentation: SDK::Host + DualStack@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseDualStack": true,
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Cannot set dual-stack in combination with a custom endpoint. [SDK::Host + DualStack@af-south-1]");
    assert!(
        format!("{:?}", error).contains("Cannot set dual-stack in combination with a custom endpoint."),
        "expected error to contain `Cannot set dual-stack in combination with a custom endpoint.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_106() {
    /* documentation: SDK::HOST + accelerate@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "SDK::Endpoint": "https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.endpoint_url("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com");
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("bucket-name".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: A custom endpoint cannot be combined with S3 Accelerate [SDK::HOST + accelerate@af-south-1]");
    assert!(
        format!("{:?}", error).contains("A custom endpoint cannot be combined with S3 Accelerate"),
        "expected error to contain `A custom endpoint cannot be combined with S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_107() {
    /* documentation: SDK::Host + access point ARN@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "SDK::Endpoint": "https://beta.example.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.endpoint_url("https://beta.example.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.beta.example.com"),
        "expected URI to start with `https://myendpoint-123456789012.beta.example.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_108() {
    /* documentation: vanilla access point arn@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_109() {
    /* documentation: access point arn + FIPS@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint-fips.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint-fips.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_110() {
    /* documentation: access point arn + accelerate = error@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Access Points do not support S3 Accelerate [access point arn + accelerate = error@us-west-2]");
    assert!(
        format!("{:?}", error).contains("Access Points do not support S3 Accelerate"),
        "expected error to contain `Access Points do not support S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_111() {
    /* documentation: access point arn + FIPS + DualStack@us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_112() {
    /* documentation: vanilla access point arn@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.cn-north-1.amazonaws.com.cn"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.cn-north-1.amazonaws.com.cn` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_113() {
    /* documentation: access point arn + accelerate = error@cn-north-1 */
    /* builtIns: {
        "AWS::Region": "cn-north-1",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("cn-north-1"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Access Points do not support S3 Accelerate [access point arn + accelerate = error@cn-north-1]");
    assert!(
        format!("{:?}", error).contains("Access Points do not support S3 Accelerate"),
        "expected error to contain `Access Points do not support S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_114() {
    /* documentation: vanilla access point arn@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint.af-south-1.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_115() {
    /* documentation: access point arn + FIPS@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint-fips.af-south-1.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint-fips.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_116() {
    /* documentation: access point arn + accelerate = error@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Access Points do not support S3 Accelerate [access point arn + accelerate = error@af-south-1]");
    assert!(
        format!("{:?}", error).contains("Access Points do not support S3 Accelerate"),
        "expected error to contain `Access Points do not support S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_117() {
    /* documentation: access point arn + FIPS + DualStack@af-south-1 */
    /* builtIns: {
        "AWS::Region": "af-south-1",
        "AWS::UseFIPS": true,
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("af-south-1"));
        let builder = builder.use_fips(true);
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.af-south-1.amazonaws.com"),
        "expected URI to start with `https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.af-south-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_118() {
    /* documentation: S3 outposts vanilla test */
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://reports-123456789012.op-01234567890123456.s3-outposts.us-west-2.amazonaws.com"),
        "expected URI to start with `https://reports-123456789012.op-01234567890123456.s3-outposts.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_119() {
    /* documentation: S3 outposts custom endpoint */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://example.amazonaws.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://example.amazonaws.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://reports-123456789012.op-01234567890123456.example.amazonaws.com"),
        "expected URI to start with `https://reports-123456789012.op-01234567890123456.example.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_120() {
    /* documentation: outposts arn with region mismatch and UseArnRegion=false */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false` [outposts arn with region mismatch and UseArnRegion=false]");
    assert!(
                                            format!("{:?}", error).contains("Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`"),
                                            "expected error to contain `Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_121() {
    /* documentation: outposts arn with region mismatch, custom region and UseArnRegion=false */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://example.com",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://example.com");
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false` [outposts arn with region mismatch, custom region and UseArnRegion=false]");
    assert!(
                                            format!("{:?}", error).contains("Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`"),
                                            "expected error to contain `Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_122() {
    /* documentation: outposts arn with region mismatch and UseArnRegion=true */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com"),
        "expected URI to start with `https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_123() {
    /* documentation: outposts arn with region mismatch and UseArnRegion unset */
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com"),
        "expected URI to start with `https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_124() {
    /* documentation: outposts arn with partition mismatch and UseArnRegion=true */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Client was configured for partition `aws` but ARN (`arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint`) has `aws-cn` [outposts arn with partition mismatch and UseArnRegion=true]");
    assert!(
                                            format!("{:?}", error).contains("Client was configured for partition `aws` but ARN (`arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint`) has `aws-cn`"),
                                            "expected error to contain `Client was configured for partition `aws` but ARN (`arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint`) has `aws-cn`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_125() {
    /* documentation: object lambda @us-east-1 */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com"),
        "expected URI to start with `https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_126() {
    /* documentation: object lambda @us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com"),
        "expected URI to start with `https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_127() {
    /* documentation: object lambda, colon resource deliminator @us-west-2 */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com"),
        "expected URI to start with `https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_128() {
    /* documentation: object lambda @us-east-1, client region us-west-2, useArnRegion=true */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com"),
        "expected URI to start with `https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_129() {
    /* documentation: object lambda @us-east-1, client region s3-external-1, useArnRegion=true */
    /* builtIns: {
        "AWS::Region": "s3-external-1",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("s3-external-1"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com"),
        "expected URI to start with `https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_130() {
    /* documentation: object lambda @us-east-1, client region s3-external-1, useArnRegion=false */
    /* builtIns: {
        "AWS::Region": "s3-external-1",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("s3-external-1"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `s3-external-1` and UseArnRegion is `false` [object lambda @us-east-1, client region s3-external-1, useArnRegion=false]");
    assert!(
                                            format!("{:?}", error).contains("Invalid configuration: region from ARN `us-east-1` does not match client region `s3-external-1` and UseArnRegion is `false`"),
                                            "expected error to contain `Invalid configuration: region from ARN `us-east-1` does not match client region `s3-external-1` and UseArnRegion is `false`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_131() {
    /* documentation: object lambda @us-east-1, client region aws-global, useArnRegion=true */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com"),
        "expected URI to start with `https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_132() {
    /* documentation: object lambda @us-east-1, client region aws-global, useArnRegion=false */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `aws-global` and UseArnRegion is `false` [object lambda @us-east-1, client region aws-global, useArnRegion=false]");
    assert!(
                                            format!("{:?}", error).contains("Invalid configuration: region from ARN `us-east-1` does not match client region `aws-global` and UseArnRegion is `false`"),
                                            "expected error to contain `Invalid configuration: region from ARN `us-east-1` does not match client region `aws-global` and UseArnRegion is `false`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_133() {
    /* documentation: object lambda @cn-north-1, client region us-west-2 (cross partition), useArnRegion=true */
    /* builtIns: {
        "AWS::Region": "aws-global",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("aws-global"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Client was configured for partition `aws` but ARN (`arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner`) has `aws-cn` [object lambda @cn-north-1, client region us-west-2 (cross partition), useArnRegion=true]");
    assert!(
                                            format!("{:?}", error).contains("Client was configured for partition `aws` but ARN (`arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner`) has `aws-cn`"),
                                            "expected error to contain `Client was configured for partition `aws` but ARN (`arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner`) has `aws-cn`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_134() {
    /* documentation: object lambda with dualstack */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseDualStack": true,
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_dual_stack(true);
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3 Object Lambda does not support Dual-stack [object lambda with dualstack]");
    assert!(
        format!("{:?}", error).contains("S3 Object Lambda does not support Dual-stack"),
        "expected error to contain `S3 Object Lambda does not support Dual-stack` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_135() {
    /* documentation: object lambda with accelerate */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::Accelerate": true,
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.accelerate(true);
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3 Object Lambda does not support S3 Accelerate [object lambda with accelerate]");
    assert!(
        format!("{:?}", error).contains("S3 Object Lambda does not support S3 Accelerate"),
        "expected error to contain `S3 Object Lambda does not support S3 Accelerate` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_136() {
    /* documentation: object lambda with invalid arn - bad service and someresource */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("arn:aws:sqs:us-west-2:123456789012:someresource".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: Unrecognized format: arn:aws:sqs:us-west-2:123456789012:someresource (type: someresource) [object lambda with invalid arn - bad service and someresource]");
    assert!(
                                            format!("{:?}", error).contains("Invalid ARN: Unrecognized format: arn:aws:sqs:us-west-2:123456789012:someresource (type: someresource)"),
                                            "expected error to contain `Invalid ARN: Unrecognized format: arn:aws:sqs:us-west-2:123456789012:someresource (type: someresource)` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_137() {
    /* documentation: object lambda with invalid arn - account id contains invalid characters */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-west-2:123.45678.9012:accesspoint:mybucket".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123.45678.9012` [object lambda with invalid arn - account id contains invalid characters]");
    assert!(
        format!("{:?}", error).contains("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123.45678.9012`"),
        "expected error to contain `Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123.45678.9012`` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_138() {
    /* documentation: object lambda with custom endpoint */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://my-endpoint.com",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://my-endpoint.com");
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybanner-123456789012.my-endpoint.com"),
        "expected URI to start with `https://mybanner-123456789012.my-endpoint.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_139() {
    /* documentation: object lambda arn with region mismatch and UseArnRegion=false */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::S3::UseArnRegion": false
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_arn_region(false);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some(
                "arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner".to_owned()
            ))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false` [object lambda arn with region mismatch and UseArnRegion=false]");
    assert!(
                                            format!("{:?}", error).contains("Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`"),
                                            "expected error to contain `Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`` but it was {:?}", error
                                        );
}

#[::tokio::test]
async fn operation_input_test_get_object_140() {
    /* documentation: Data Plane with short zone name */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--abcd-ab1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--abcd-ab1--x-s3.s3express-abcd-ab1.us-east-1.amazonaws.com"),
        "expected URI to start with `https://mybucket--abcd-ab1--x-s3.s3express-abcd-ab1.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_141() {
    /* documentation: Data Plane with short zone names (13 chars) */
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--test-zone-ab1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--test-zone-ab1--x-s3.s3express-test-zone-ab1.us-west-2.amazonaws.com"),
        "expected URI to start with `https://mybucket--test-zone-ab1--x-s3.s3express-test-zone-ab1.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_142() {
    /* documentation: Data Plane with medium zone names (14 chars) */
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--test1-zone-ab1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--test1-zone-ab1--x-s3.s3express-test1-zone-ab1.us-west-2.amazonaws.com"),
        "expected URI to start with `https://mybucket--test1-zone-ab1--x-s3.s3express-test1-zone-ab1.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_143() {
    /* documentation: Data Plane with long zone names (20 chars) */
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--test1-long1-zone-ab1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(uri.starts_with("https://mybucket--test1-long1-zone-ab1--x-s3.s3express-test1-long1-zone-ab1.us-west-2.amazonaws.com"), "expected URI to start with `https://mybucket--test1-long1-zone-ab1--x-s3.s3express-test1-long1-zone-ab1.us-west-2.amazonaws.com` but it was `{}`", uri);
}

#[::tokio::test]
async fn operation_input_test_get_object_144() {
    /* documentation: Data Plane with short zone fips */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--test-ab1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--test-ab1--x-s3.s3express-fips-test-ab1.us-east-1.amazonaws.com"),
        "expected URI to start with `https://mybucket--test-ab1--x-s3.s3express-fips-test-ab1.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_145() {
    /* documentation: Data Plane with short zone (13 chars) fips */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--test-zone-ab1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--test-zone-ab1--x-s3.s3express-fips-test-zone-ab1.us-west-2.amazonaws.com"),
        "expected URI to start with `https://mybucket--test-zone-ab1--x-s3.s3express-fips-test-zone-ab1.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_146() {
    /* documentation: Data Plane with medium zone (14 chars) fips */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--test1-zone-ab1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--test1-zone-ab1--x-s3.s3express-fips-test1-zone-ab1.us-west-2.amazonaws.com"),
        "expected URI to start with `https://mybucket--test1-zone-ab1--x-s3.s3express-fips-test1-zone-ab1.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_147() {
    /* documentation: Data Plane with long zone (20 chars) fips */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--test1-long1-zone-ab1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(uri.starts_with("https://mybucket--test1-long1-zone-ab1--x-s3.s3express-fips-test1-long1-zone-ab1.us-west-2.amazonaws.com"), "expected URI to start with `https://mybucket--test1-long1-zone-ab1--x-s3.s3express-fips-test1-long1-zone-ab1.us-west-2.amazonaws.com` but it was `{}`", uri);
}

#[::tokio::test]
async fn operation_input_test_get_object_148() {
    /* documentation: Data Plane with long AZ */
    /* builtIns: {
        "AWS::Region": "us-west-2"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--test1-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--test1-az1--x-s3.s3express-test1-az1.us-west-2.amazonaws.com"),
        "expected URI to start with `https://mybucket--test1-az1--x-s3.s3express-test1-az1.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_149() {
    /* documentation: Data Plane with long AZ fips */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--test1-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--test1-az1--x-s3.s3express-fips-test1-az1.us-west-2.amazonaws.com"),
        "expected URI to start with `https://mybucket--test1-az1--x-s3.s3express-fips-test1-az1.us-west-2.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_create_bucket_150() {
    /* documentation: Control plane with short AZ bucket */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .create_bucket()
            .set_bucket(::std::option::Option::Some("mybucket--test-ab1--x-s3".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3express-control.us-east-1.amazonaws.com/mybucket--test-ab1--x-s3"),
        "expected URI to start with `https://s3express-control.us-east-1.amazonaws.com/mybucket--test-ab1--x-s3` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_create_bucket_151() {
    /* documentation: Control plane with short AZ bucket and fips */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .create_bucket()
            .set_bucket(::std::option::Option::Some("mybucket--test-ab1--x-s3".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3express-control-fips.us-east-1.amazonaws.com/mybucket--test-ab1--x-s3"),
        "expected URI to start with `https://s3express-control-fips.us-east-1.amazonaws.com/mybucket--test-ab1--x-s3` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_directory_buckets_152() {
    /* documentation: Control plane without bucket */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_directory_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3express-control.us-east-1.amazonaws.com"),
        "expected URI to start with `https://s3express-control.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_list_directory_buckets_153() {
    /* documentation: Control plane without bucket and fips */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseFIPS": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_fips(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(client.list_directory_buckets().send().await);
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://s3express-control-fips.us-east-1.amazonaws.com"),
        "expected URI to start with `https://s3express-control-fips.us-east-1.amazonaws.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_154() {
    /* documentation: Data plane host override non virtual session auth */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://10.0.0.1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://10.0.0.1");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--usw2-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://10.0.0.1/mybucket--usw2-az1--x-s3"),
        "expected URI to start with `https://10.0.0.1/mybucket--usw2-az1--x-s3` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_155() {
    /* documentation: Data plane host override */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://custom.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://custom.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--usw2-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    let req = rcvr.expect_request();
    let uri = req.uri().to_string();
    assert!(
        uri.starts_with("https://mybucket--usw2-az1--x-s3.custom.com"),
        "expected URI to start with `https://mybucket--usw2-az1--x-s3.custom.com` but it was `{}`",
        uri
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_156() {
    /* documentation: bad format error */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--usaz1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Unrecognized S3Express bucket name format. [bad format error]");
    assert!(
        format!("{:?}", error).contains("Unrecognized S3Express bucket name format."),
        "expected error to contain `Unrecognized S3Express bucket name format.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_157() {
    /* documentation: bad format error no session auth */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--usaz1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: Unrecognized S3Express bucket name format. [bad format error no session auth]");
    assert!(
        format!("{:?}", error).contains("Unrecognized S3Express bucket name format."),
        "expected error to contain `Unrecognized S3Express bucket name format.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_158() {
    /* documentation: dual-stack error */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::UseDualStack": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.use_dual_stack(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--test-ab1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3Express does not support Dual-stack. [dual-stack error]");
    assert!(
        format!("{:?}", error).contains("S3Express does not support Dual-stack."),
        "expected error to contain `S3Express does not support Dual-stack.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_159() {
    /* documentation: accelerate error */
    /* builtIns: {
        "AWS::Region": "us-east-1",
        "AWS::S3::Accelerate": true
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        let builder = builder.accelerate(true);
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("mybucket--test-ab1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3Express does not support S3 Accelerate. [accelerate error]");
    assert!(
        format!("{:?}", error).contains("S3Express does not support S3 Accelerate."),
        "expected error to contain `S3Express does not support S3 Accelerate.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_160() {
    /* documentation: Data plane bucket format error */
    /* builtIns: {
        "AWS::Region": "us-east-1"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-east-1"));
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("my.bucket--test-ab1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err("expected error: S3Express bucket name is not a valid virtual hostable name. [Data plane bucket format error]");
    assert!(
        format!("{:?}", error).contains("S3Express bucket name is not a valid virtual hostable name."),
        "expected error to contain `S3Express bucket name is not a valid virtual hostable name.` but it was {:?}",
        error
    );
}

#[::tokio::test]
async fn operation_input_test_get_object_161() {
    /* documentation: host override data plane bucket error session auth */
    /* builtIns: {
        "AWS::Region": "us-west-2",
        "SDK::Endpoint": "https://custom.com"
    } */
    /* clientParams: {} */
    let (http_client, rcvr) = ::aws_smithy_http_client::test_util::capture_request(None);
    let conf = {
        #[allow(unused_mut)]
        let mut builder = aws_sdk_s3::Config::builder().with_test_defaults().http_client(http_client);
        let builder = builder.region(::aws_types::region::Region::new("us-west-2"));
        let builder = builder.endpoint_url("https://custom.com");
        builder.build()
    };
    let client = aws_sdk_s3::Client::from_conf(conf);
    let _result = dbg!(
        client
            .get_object()
            .set_bucket(::std::option::Option::Some("my.bucket--usw2-az1--x-s3".to_owned()))
            .set_key(::std::option::Option::Some("key".to_owned()))
            .send()
            .await
    );
    rcvr.expect_no_request();
    let error = _result.expect_err(
        "expected error: S3Express bucket name is not a valid virtual hostable name. [host override data plane bucket error session auth]",
    );
    assert!(
        format!("{:?}", error).contains("S3Express bucket name is not a valid virtual hostable name."),
        "expected error to contain `S3Express bucket name is not a valid virtual hostable name.` but it was {:?}",
        error
    );
}
