// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package discovery

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetRuntimeEndpointsOKCode is the HTTP code returned for type GetRuntimeEndpointsOK
const GetRuntimeEndpointsOKCode int = 200

/*
GetRuntimeEndpointsOK Success

swagger:response getRuntimeEndpointsOK
*/
type GetRuntimeEndpointsOK struct {

	/*
	  In: Body
	*/
	Payload models.Endpoints `json:"body,omitempty"`
}

// NewGetRuntimeEndpointsOK creates GetRuntimeEndpointsOK with default headers values
func NewGetRuntimeEndpointsOK() *GetRuntimeEndpointsOK {

	return &GetRuntimeEndpointsOK{}
}

// WithPayload adds the payload to the get runtime endpoints o k response
func (o *GetRuntimeEndpointsOK) WithPayload(payload models.Endpoints) *GetRuntimeEndpointsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get runtime endpoints o k response
func (o *GetRuntimeEndpointsOK) SetPayload(payload models.Endpoints) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRuntimeEndpointsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Endpoints{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetRuntimeEndpointsDefault General Error

swagger:response getRuntimeEndpointsDefault
*/
type GetRuntimeEndpointsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetRuntimeEndpointsDefault creates GetRuntimeEndpointsDefault with default headers values
func NewGetRuntimeEndpointsDefault(code int) *GetRuntimeEndpointsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetRuntimeEndpointsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get runtime endpoints default response
func (o *GetRuntimeEndpointsDefault) WithStatusCode(code int) *GetRuntimeEndpointsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get runtime endpoints default response
func (o *GetRuntimeEndpointsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get runtime endpoints default response
func (o *GetRuntimeEndpointsDefault) WithConfigurationVersion(configurationVersion string) *GetRuntimeEndpointsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get runtime endpoints default response
func (o *GetRuntimeEndpointsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get runtime endpoints default response
func (o *GetRuntimeEndpointsDefault) WithPayload(payload *models.Error) *GetRuntimeEndpointsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get runtime endpoints default response
func (o *GetRuntimeEndpointsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRuntimeEndpointsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
