// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package configuration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetConfigurationVersionOKCode is the HTTP code returned for type GetConfigurationVersionOK
const GetConfigurationVersionOKCode int = 200

/*
GetConfigurationVersionOK Configuration version

swagger:response getConfigurationVersionOK
*/
type GetConfigurationVersionOK struct {

	/*
	  In: Body
	*/
	Payload int64 `json:"body,omitempty"`
}

// NewGetConfigurationVersionOK creates GetConfigurationVersionOK with default headers values
func NewGetConfigurationVersionOK() *GetConfigurationVersionOK {

	return &GetConfigurationVersionOK{}
}

// WithPayload adds the payload to the get configuration version o k response
func (o *GetConfigurationVersionOK) WithPayload(payload int64) *GetConfigurationVersionOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get configuration version o k response
func (o *GetConfigurationVersionOK) SetPayload(payload int64) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetConfigurationVersionOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetConfigurationVersionNotFoundCode is the HTTP code returned for type GetConfigurationVersionNotFound
const GetConfigurationVersionNotFoundCode int = 404

/*
GetConfigurationVersionNotFound The specified resource was not found

swagger:response getConfigurationVersionNotFound
*/
type GetConfigurationVersionNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetConfigurationVersionNotFound creates GetConfigurationVersionNotFound with default headers values
func NewGetConfigurationVersionNotFound() *GetConfigurationVersionNotFound {

	return &GetConfigurationVersionNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get configuration version not found response
func (o *GetConfigurationVersionNotFound) WithConfigurationVersion(configurationVersion string) *GetConfigurationVersionNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get configuration version not found response
func (o *GetConfigurationVersionNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get configuration version not found response
func (o *GetConfigurationVersionNotFound) WithPayload(payload *models.Error) *GetConfigurationVersionNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get configuration version not found response
func (o *GetConfigurationVersionNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetConfigurationVersionNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetConfigurationVersionDefault General Error

swagger:response getConfigurationVersionDefault
*/
type GetConfigurationVersionDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetConfigurationVersionDefault creates GetConfigurationVersionDefault with default headers values
func NewGetConfigurationVersionDefault(code int) *GetConfigurationVersionDefault {
	if code <= 0 {
		code = 500
	}

	return &GetConfigurationVersionDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get configuration version default response
func (o *GetConfigurationVersionDefault) WithStatusCode(code int) *GetConfigurationVersionDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get configuration version default response
func (o *GetConfigurationVersionDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get configuration version default response
func (o *GetConfigurationVersionDefault) WithConfigurationVersion(configurationVersion string) *GetConfigurationVersionDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get configuration version default response
func (o *GetConfigurationVersionDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get configuration version default response
func (o *GetConfigurationVersionDefault) WithPayload(payload *models.Error) *GetConfigurationVersionDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get configuration version default response
func (o *GetConfigurationVersionDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetConfigurationVersionDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
