//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscelltype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCellType(pub NSUInteger);
impl NSCellType {
    #[doc(alias = "NSNullCellType")]
    pub const NullCellType: Self = Self(0);
    #[doc(alias = "NSTextCellType")]
    pub const TextCellType: Self = Self(1);
    #[doc(alias = "NSImageCellType")]
    pub const ImageCellType: Self = Self(2);
}

unsafe impl Encode for NSCellType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCellType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscellattribute?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCellAttribute(pub NSUInteger);
impl NSCellAttribute {
    #[doc(alias = "NSCellDisabled")]
    pub const CellDisabled: Self = Self(0);
    #[doc(alias = "NSCellState")]
    pub const CellState: Self = Self(1);
    #[doc(alias = "NSPushInCell")]
    pub const PushInCell: Self = Self(2);
    #[doc(alias = "NSCellEditable")]
    pub const CellEditable: Self = Self(3);
    #[doc(alias = "NSChangeGrayCell")]
    pub const ChangeGrayCell: Self = Self(4);
    #[doc(alias = "NSCellHighlighted")]
    pub const CellHighlighted: Self = Self(5);
    #[doc(alias = "NSCellLightsByContents")]
    pub const CellLightsByContents: Self = Self(6);
    #[doc(alias = "NSCellLightsByGray")]
    pub const CellLightsByGray: Self = Self(7);
    #[doc(alias = "NSChangeBackgroundCell")]
    pub const ChangeBackgroundCell: Self = Self(8);
    #[doc(alias = "NSCellLightsByBackground")]
    pub const CellLightsByBackground: Self = Self(9);
    #[doc(alias = "NSCellIsBordered")]
    pub const CellIsBordered: Self = Self(10);
    #[doc(alias = "NSCellHasOverlappingImage")]
    pub const CellHasOverlappingImage: Self = Self(11);
    #[doc(alias = "NSCellHasImageHorizontal")]
    pub const CellHasImageHorizontal: Self = Self(12);
    #[doc(alias = "NSCellHasImageOnLeftOrBottom")]
    pub const CellHasImageOnLeftOrBottom: Self = Self(13);
    #[doc(alias = "NSCellChangesContents")]
    pub const CellChangesContents: Self = Self(14);
    #[doc(alias = "NSCellIsInsetButton")]
    pub const CellIsInsetButton: Self = Self(15);
    #[doc(alias = "NSCellAllowsMixedState")]
    pub const CellAllowsMixedState: Self = Self(16);
}

unsafe impl Encode for NSCellAttribute {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCellAttribute {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscellimageposition?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCellImagePosition(pub NSUInteger);
impl NSCellImagePosition {
    #[doc(alias = "NSNoImage")]
    pub const NoImage: Self = Self(0);
    #[doc(alias = "NSImageOnly")]
    pub const ImageOnly: Self = Self(1);
    #[doc(alias = "NSImageLeft")]
    pub const ImageLeft: Self = Self(2);
    #[doc(alias = "NSImageRight")]
    pub const ImageRight: Self = Self(3);
    #[doc(alias = "NSImageBelow")]
    pub const ImageBelow: Self = Self(4);
    #[doc(alias = "NSImageAbove")]
    pub const ImageAbove: Self = Self(5);
    #[doc(alias = "NSImageOverlaps")]
    pub const ImageOverlaps: Self = Self(6);
    #[doc(alias = "NSImageLeading")]
    pub const ImageLeading: Self = Self(7);
    #[doc(alias = "NSImageTrailing")]
    pub const ImageTrailing: Self = Self(8);
}

unsafe impl Encode for NSCellImagePosition {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCellImagePosition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagescaling?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSImageScaling(pub NSUInteger);
impl NSImageScaling {
    #[doc(alias = "NSImageScaleProportionallyDown")]
    pub const ScaleProportionallyDown: Self = Self(0);
    #[doc(alias = "NSImageScaleAxesIndependently")]
    pub const ScaleAxesIndependently: Self = Self(1);
    #[doc(alias = "NSImageScaleNone")]
    pub const ScaleNone: Self = Self(2);
    #[doc(alias = "NSImageScaleProportionallyUpOrDown")]
    pub const ScaleProportionallyUpOrDown: Self = Self(3);
    #[deprecated = "Use NSImageScaleProportionallyDown instead"]
    pub const NSScaleProportionally: Self = Self(0);
    #[deprecated = "Use NSImageScaleAxesIndependently instead"]
    pub const NSScaleToFit: Self = Self(1);
    #[deprecated = "Use NSImageScaleNone instead"]
    pub const NSScaleNone: Self = Self(2);
}

unsafe impl Encode for NSImageScaling {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSImageScaling {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolstatevalue?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type NSControlStateValue = NSInteger;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolstatevaluemixed?language=objc)
pub static NSControlStateValueMixed: NSControlStateValue = -1;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolstatevalueoff?language=objc)
pub static NSControlStateValueOff: NSControlStateValue = 0;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolstatevalueon?language=objc)
pub static NSControlStateValueOn: NSControlStateValue = 1;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscellstylemask?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCellStyleMask(pub NSUInteger);
bitflags::bitflags! {
    impl NSCellStyleMask: NSUInteger {
        #[doc(alias = "NSNoCellMask")]
        const NoCellMask = 0;
        #[doc(alias = "NSContentsCellMask")]
        const ContentsCellMask = 1;
        #[doc(alias = "NSPushInCellMask")]
        const PushInCellMask = 2;
        #[doc(alias = "NSChangeGrayCellMask")]
        const ChangeGrayCellMask = 4;
        #[doc(alias = "NSChangeBackgroundCellMask")]
        const ChangeBackgroundCellMask = 8;
    }
}

unsafe impl Encode for NSCellStyleMask {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCellStyleMask {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontroltint?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSControlTint(pub NSUInteger);
impl NSControlTint {
    #[doc(alias = "NSDefaultControlTint")]
    pub const DefaultControlTint: Self = Self(0);
    #[doc(alias = "NSBlueControlTint")]
    pub const BlueControlTint: Self = Self(1);
    #[doc(alias = "NSGraphiteControlTint")]
    pub const GraphiteControlTint: Self = Self(6);
    #[doc(alias = "NSClearControlTint")]
    pub const ClearControlTint: Self = Self(7);
}

unsafe impl Encode for NSControlTint {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSControlTint {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolsize?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSControlSize(pub NSUInteger);
impl NSControlSize {
    #[doc(alias = "NSControlSizeRegular")]
    pub const Regular: Self = Self(0);
    #[doc(alias = "NSControlSizeSmall")]
    pub const Small: Self = Self(1);
    #[doc(alias = "NSControlSizeMini")]
    pub const Mini: Self = Self(2);
    #[doc(alias = "NSControlSizeLarge")]
    pub const Large: Self = Self(3);
    #[doc(alias = "NSControlSizeExtraLarge")]
    pub const ExtraLarge: Self = Self(4);
}

unsafe impl Encode for NSControlSize {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSControlSize {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscell?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCell;
);

#[cfg(feature = "NSAccessibilityProtocols")]
extern_conformance!(
    unsafe impl NSAccessibility for NSCell {}
);

#[cfg(feature = "NSAccessibilityProtocols")]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSCell {}
);

extern_conformance!(
    unsafe impl NSCoding for NSCell {}
);

extern_conformance!(
    unsafe impl NSCopying for NSCell {}
);

unsafe impl CopyingHelper for NSCell {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCell {}
);

#[cfg(feature = "NSUserInterfaceItemIdentification")]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSCell {}
);

impl NSCell {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(initTextCell:))]
        #[unsafe(method_family = init)]
        pub fn initTextCell(this: Allocated<Self>, string: &NSString) -> Retained<Self>;

        #[cfg(feature = "NSImage")]
        #[unsafe(method(initImageCell:))]
        #[unsafe(method_family = init)]
        pub fn initImageCell(this: Allocated<Self>, image: Option<&NSImage>) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        #[unsafe(method(prefersTrackingUntilMouseUp))]
        #[unsafe(method_family = none)]
        pub fn prefersTrackingUntilMouseUp(mtm: MainThreadMarker) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(controlView))]
        #[unsafe(method_family = none)]
        pub unsafe fn controlView(&self) -> Option<Retained<NSView>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// Setter for [`controlView`][Self::controlView].
        ///
        /// # Safety
        ///
        /// This is unretained, you must ensure the object is kept alive while in use.
        #[unsafe(method(setControlView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setControlView(&self, control_view: Option<&NSView>);

        #[unsafe(method(type))]
        #[unsafe(method_family = none)]
        pub fn r#type(&self) -> NSCellType;

        /// Setter for [`type`][Self::type].
        #[unsafe(method(setType:))]
        #[unsafe(method_family = none)]
        pub fn setType(&self, r#type: NSCellType);

        #[unsafe(method(state))]
        #[unsafe(method_family = none)]
        pub fn state(&self) -> NSControlStateValue;

        /// Setter for [`state`][Self::state].
        #[unsafe(method(setState:))]
        #[unsafe(method_family = none)]
        pub fn setState(&self, state: NSControlStateValue);

        #[unsafe(method(target))]
        #[unsafe(method_family = none)]
        pub fn target(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`target`][Self::target].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// `target` should be of the correct type.
        #[unsafe(method(setTarget:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTarget(&self, target: Option<&AnyObject>);

        #[unsafe(method(action))]
        #[unsafe(method_family = none)]
        pub fn action(&self) -> Option<Sel>;

        /// Setter for [`action`][Self::action].
        ///
        /// # Safety
        ///
        /// `action` must be a valid selector.
        #[unsafe(method(setAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAction(&self, action: Option<Sel>);

        #[unsafe(method(tag))]
        #[unsafe(method_family = none)]
        pub fn tag(&self) -> NSInteger;

        /// Setter for [`tag`][Self::tag].
        #[unsafe(method(setTag:))]
        #[unsafe(method_family = none)]
        pub fn setTag(&self, tag: NSInteger);

        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub fn title(&self) -> Retained<NSString>;

        /// Setter for [`title`][Self::title].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub fn setTitle(&self, title: &NSString);

        #[unsafe(method(isOpaque))]
        #[unsafe(method_family = none)]
        pub fn isOpaque(&self) -> bool;

        #[unsafe(method(isEnabled))]
        #[unsafe(method_family = none)]
        pub fn isEnabled(&self) -> bool;

        /// Setter for [`isEnabled`][Self::isEnabled].
        #[unsafe(method(setEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setEnabled(&self, enabled: bool);

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(sendActionOn:))]
        #[unsafe(method_family = none)]
        pub fn sendActionOn(&self, mask: NSEventMask) -> NSInteger;

        #[unsafe(method(isContinuous))]
        #[unsafe(method_family = none)]
        pub fn isContinuous(&self) -> bool;

        /// Setter for [`isContinuous`][Self::isContinuous].
        #[unsafe(method(setContinuous:))]
        #[unsafe(method_family = none)]
        pub fn setContinuous(&self, continuous: bool);

        #[unsafe(method(isEditable))]
        #[unsafe(method_family = none)]
        pub fn isEditable(&self) -> bool;

        /// Setter for [`isEditable`][Self::isEditable].
        #[unsafe(method(setEditable:))]
        #[unsafe(method_family = none)]
        pub fn setEditable(&self, editable: bool);

        #[unsafe(method(isSelectable))]
        #[unsafe(method_family = none)]
        pub fn isSelectable(&self) -> bool;

        /// Setter for [`isSelectable`][Self::isSelectable].
        #[unsafe(method(setSelectable:))]
        #[unsafe(method_family = none)]
        pub fn setSelectable(&self, selectable: bool);

        #[unsafe(method(isBordered))]
        #[unsafe(method_family = none)]
        pub fn isBordered(&self) -> bool;

        /// Setter for [`isBordered`][Self::isBordered].
        #[unsafe(method(setBordered:))]
        #[unsafe(method_family = none)]
        pub fn setBordered(&self, bordered: bool);

        #[unsafe(method(isBezeled))]
        #[unsafe(method_family = none)]
        pub fn isBezeled(&self) -> bool;

        /// Setter for [`isBezeled`][Self::isBezeled].
        #[unsafe(method(setBezeled:))]
        #[unsafe(method_family = none)]
        pub fn setBezeled(&self, bezeled: bool);

        #[unsafe(method(isScrollable))]
        #[unsafe(method_family = none)]
        pub fn isScrollable(&self) -> bool;

        /// Setter for [`isScrollable`][Self::isScrollable].
        #[unsafe(method(setScrollable:))]
        #[unsafe(method_family = none)]
        pub fn setScrollable(&self, scrollable: bool);

        #[unsafe(method(isHighlighted))]
        #[unsafe(method_family = none)]
        pub fn isHighlighted(&self) -> bool;

        /// Setter for [`isHighlighted`][Self::isHighlighted].
        #[unsafe(method(setHighlighted:))]
        #[unsafe(method_family = none)]
        pub fn setHighlighted(&self, highlighted: bool);

        #[cfg(feature = "NSText")]
        #[unsafe(method(alignment))]
        #[unsafe(method_family = none)]
        pub fn alignment(&self) -> NSTextAlignment;

        #[cfg(feature = "NSText")]
        /// Setter for [`alignment`][Self::alignment].
        #[unsafe(method(setAlignment:))]
        #[unsafe(method_family = none)]
        pub fn setAlignment(&self, alignment: NSTextAlignment);

        #[unsafe(method(wraps))]
        #[unsafe(method_family = none)]
        pub fn wraps(&self) -> bool;

        /// Setter for [`wraps`][Self::wraps].
        #[unsafe(method(setWraps:))]
        #[unsafe(method_family = none)]
        pub fn setWraps(&self, wraps: bool);

        #[cfg(feature = "NSFont")]
        #[unsafe(method(font))]
        #[unsafe(method_family = none)]
        pub fn font(&self) -> Option<Retained<NSFont>>;

        #[cfg(feature = "NSFont")]
        /// Setter for [`font`][Self::font].
        #[unsafe(method(setFont:))]
        #[unsafe(method_family = none)]
        pub fn setFont(&self, font: Option<&NSFont>);

        #[unsafe(method(keyEquivalent))]
        #[unsafe(method_family = none)]
        pub fn keyEquivalent(&self) -> Retained<NSString>;

        #[unsafe(method(formatter))]
        #[unsafe(method_family = none)]
        pub fn formatter(&self) -> Option<Retained<NSFormatter>>;

        /// Setter for [`formatter`][Self::formatter].
        #[unsafe(method(setFormatter:))]
        #[unsafe(method_family = none)]
        pub fn setFormatter(&self, formatter: Option<&NSFormatter>);

        #[unsafe(method(objectValue))]
        #[unsafe(method_family = none)]
        pub fn objectValue(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`objectValue`][Self::objectValue].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `object_value` should be of the correct type.
        #[unsafe(method(setObjectValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setObjectValue(&self, object_value: Option<&AnyObject>);

        #[unsafe(method(hasValidObjectValue))]
        #[unsafe(method_family = none)]
        pub fn hasValidObjectValue(&self) -> bool;

        #[unsafe(method(stringValue))]
        #[unsafe(method_family = none)]
        pub fn stringValue(&self) -> Retained<NSString>;

        /// Setter for [`stringValue`][Self::stringValue].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setStringValue:))]
        #[unsafe(method_family = none)]
        pub fn setStringValue(&self, string_value: &NSString);

        /// # Safety
        ///
        /// `other_cell` should be of the correct type.
        #[unsafe(method(compare:))]
        #[unsafe(method_family = none)]
        pub unsafe fn compare(&self, other_cell: &AnyObject) -> NSComparisonResult;

        #[unsafe(method(intValue))]
        #[unsafe(method_family = none)]
        pub fn intValue(&self) -> c_int;

        /// Setter for [`intValue`][Self::intValue].
        #[unsafe(method(setIntValue:))]
        #[unsafe(method_family = none)]
        pub fn setIntValue(&self, int_value: c_int);

        #[unsafe(method(floatValue))]
        #[unsafe(method_family = none)]
        pub fn floatValue(&self) -> c_float;

        /// Setter for [`floatValue`][Self::floatValue].
        #[unsafe(method(setFloatValue:))]
        #[unsafe(method_family = none)]
        pub fn setFloatValue(&self, float_value: c_float);

        #[unsafe(method(doubleValue))]
        #[unsafe(method_family = none)]
        pub fn doubleValue(&self) -> c_double;

        /// Setter for [`doubleValue`][Self::doubleValue].
        #[unsafe(method(setDoubleValue:))]
        #[unsafe(method_family = none)]
        pub fn setDoubleValue(&self, double_value: c_double);

        #[unsafe(method(integerValue))]
        #[unsafe(method_family = none)]
        pub fn integerValue(&self) -> NSInteger;

        /// Setter for [`integerValue`][Self::integerValue].
        #[unsafe(method(setIntegerValue:))]
        #[unsafe(method_family = none)]
        pub fn setIntegerValue(&self, integer_value: NSInteger);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeIntValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeIntValueFrom(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeFloatValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeFloatValueFrom(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeDoubleValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeDoubleValueFrom(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeStringValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeStringValueFrom(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeObjectValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeObjectValueFrom(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeIntegerValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeIntegerValueFrom(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSImage")]
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub fn image(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`image`][Self::image].
        #[unsafe(method(setImage:))]
        #[unsafe(method_family = none)]
        pub fn setImage(&self, image: Option<&NSImage>);

        #[unsafe(method(controlSize))]
        #[unsafe(method_family = none)]
        pub fn controlSize(&self) -> NSControlSize;

        /// Setter for [`controlSize`][Self::controlSize].
        #[unsafe(method(setControlSize:))]
        #[unsafe(method_family = none)]
        pub fn setControlSize(&self, control_size: NSControlSize);

        #[unsafe(method(representedObject))]
        #[unsafe(method_family = none)]
        pub fn representedObject(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`representedObject`][Self::representedObject].
        ///
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[unsafe(method(setRepresentedObject:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRepresentedObject(&self, represented_object: Option<&AnyObject>);

        #[unsafe(method(cellAttribute:))]
        #[unsafe(method_family = none)]
        pub fn cellAttribute(&self, parameter: NSCellAttribute) -> NSInteger;

        #[unsafe(method(setCellAttribute:to:))]
        #[unsafe(method_family = none)]
        pub fn setCellAttribute_to(&self, parameter: NSCellAttribute, value: NSInteger);

        #[unsafe(method(imageRectForBounds:))]
        #[unsafe(method_family = none)]
        pub fn imageRectForBounds(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(titleRectForBounds:))]
        #[unsafe(method_family = none)]
        pub fn titleRectForBounds(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(drawingRectForBounds:))]
        #[unsafe(method_family = none)]
        pub fn drawingRectForBounds(&self, rect: NSRect) -> NSRect;

        #[unsafe(method(_bulletStringForString:bulletCharacter:))]
        #[unsafe(method_family = none)]
        pub fn _bulletStringForString_bulletCharacter(
            string: &NSString,
            bullet_char: unichar,
            mtm: MainThreadMarker,
        ) -> Retained<NSString>;

        #[unsafe(method(cellSize))]
        #[unsafe(method_family = none)]
        pub fn cellSize(&self) -> NSSize;

        #[unsafe(method(cellSizeForBounds:))]
        #[unsafe(method_family = none)]
        pub fn cellSizeForBounds(&self, rect: NSRect) -> NSSize;

        #[cfg(all(feature = "NSColor", feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(highlightColorWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub fn highlightColorWithFrame_inView(
            &self,
            cell_frame: NSRect,
            control_view: &NSView,
        ) -> Option<Retained<NSColor>>;

        #[unsafe(method(calcDrawInfo:))]
        #[unsafe(method_family = none)]
        pub fn calcDrawInfo(&self, rect: NSRect);

        #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
        #[unsafe(method(setUpFieldEditorAttributes:))]
        #[unsafe(method_family = none)]
        pub fn setUpFieldEditorAttributes(&self, text_obj: &NSText) -> Retained<NSText>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(drawInteriorWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub fn drawInteriorWithFrame_inView(&self, cell_frame: NSRect, control_view: &NSView);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(drawWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub fn drawWithFrame_inView(&self, cell_frame: NSRect, control_view: &NSView);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(highlight:withFrame:inView:))]
        #[unsafe(method_family = none)]
        pub fn highlight_withFrame_inView(
            &self,
            flag: bool,
            cell_frame: NSRect,
            control_view: &NSView,
        );

        #[unsafe(method(mouseDownFlags))]
        #[unsafe(method_family = none)]
        pub fn mouseDownFlags(&self) -> NSInteger;

        /// # Safety
        ///
        /// - `delay` must be a valid pointer.
        /// - `interval` must be a valid pointer.
        #[unsafe(method(getPeriodicDelay:interval:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getPeriodicDelay_interval(
            &self,
            delay: NonNull<c_float>,
            interval: NonNull<c_float>,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(startTrackingAt:inView:))]
        #[unsafe(method_family = none)]
        pub fn startTrackingAt_inView(&self, start_point: NSPoint, control_view: &NSView) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(continueTracking:at:inView:))]
        #[unsafe(method_family = none)]
        pub fn continueTracking_at_inView(
            &self,
            last_point: NSPoint,
            current_point: NSPoint,
            control_view: &NSView,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(stopTracking:at:inView:mouseIsUp:))]
        #[unsafe(method_family = none)]
        pub fn stopTracking_at_inView_mouseIsUp(
            &self,
            last_point: NSPoint,
            stop_point: NSPoint,
            control_view: &NSView,
            flag: bool,
        );

        #[cfg(all(feature = "NSEvent", feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(trackMouse:inRect:ofView:untilMouseUp:))]
        #[unsafe(method_family = none)]
        pub fn trackMouse_inRect_ofView_untilMouseUp(
            &self,
            event: &NSEvent,
            cell_frame: NSRect,
            control_view: &NSView,
            flag: bool,
        ) -> bool;

        #[cfg(all(
            feature = "NSEvent",
            feature = "NSResponder",
            feature = "NSText",
            feature = "NSView"
        ))]
        /// # Safety
        ///
        /// `delegate` should be of the correct type.
        #[unsafe(method(editWithFrame:inView:editor:delegate:event:))]
        #[unsafe(method_family = none)]
        pub unsafe fn editWithFrame_inView_editor_delegate_event(
            &self,
            rect: NSRect,
            control_view: &NSView,
            text_obj: &NSText,
            delegate: Option<&AnyObject>,
            event: Option<&NSEvent>,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
        /// # Safety
        ///
        /// `delegate` should be of the correct type.
        #[unsafe(method(selectWithFrame:inView:editor:delegate:start:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectWithFrame_inView_editor_delegate_start_length(
            &self,
            rect: NSRect,
            control_view: &NSView,
            text_obj: &NSText,
            delegate: Option<&AnyObject>,
            sel_start: NSInteger,
            sel_length: NSInteger,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
        #[unsafe(method(endEditing:))]
        #[unsafe(method_family = none)]
        pub fn endEditing(&self, text_obj: &NSText);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(resetCursorRect:inView:))]
        #[unsafe(method_family = none)]
        pub fn resetCursorRect_inView(&self, cell_frame: NSRect, control_view: &NSView);

        #[cfg(feature = "NSMenu")]
        #[unsafe(method(menu))]
        #[unsafe(method_family = none)]
        pub fn menu(&self) -> Option<Retained<NSMenu>>;

        #[cfg(feature = "NSMenu")]
        /// Setter for [`menu`][Self::menu].
        #[unsafe(method(setMenu:))]
        #[unsafe(method_family = none)]
        pub fn setMenu(&self, menu: Option<&NSMenu>);

        #[cfg(all(
            feature = "NSEvent",
            feature = "NSMenu",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[unsafe(method(menuForEvent:inRect:ofView:))]
        #[unsafe(method_family = none)]
        pub fn menuForEvent_inRect_ofView(
            &self,
            event: &NSEvent,
            cell_frame: NSRect,
            view: &NSView,
        ) -> Option<Retained<NSMenu>>;

        #[cfg(feature = "NSMenu")]
        #[unsafe(method(defaultMenu))]
        #[unsafe(method_family = none)]
        pub fn defaultMenu(mtm: MainThreadMarker) -> Option<Retained<NSMenu>>;

        #[unsafe(method(sendsActionOnEndEditing))]
        #[unsafe(method_family = none)]
        pub fn sendsActionOnEndEditing(&self) -> bool;

        /// Setter for [`sendsActionOnEndEditing`][Self::sendsActionOnEndEditing].
        #[unsafe(method(setSendsActionOnEndEditing:))]
        #[unsafe(method_family = none)]
        pub fn setSendsActionOnEndEditing(&self, sends_action_on_end_editing: bool);

        #[cfg(feature = "NSText")]
        #[unsafe(method(baseWritingDirection))]
        #[unsafe(method_family = none)]
        pub fn baseWritingDirection(&self) -> NSWritingDirection;

        #[cfg(feature = "NSText")]
        /// Setter for [`baseWritingDirection`][Self::baseWritingDirection].
        #[unsafe(method(setBaseWritingDirection:))]
        #[unsafe(method_family = none)]
        pub fn setBaseWritingDirection(&self, base_writing_direction: NSWritingDirection);

        #[cfg(feature = "NSParagraphStyle")]
        #[unsafe(method(lineBreakMode))]
        #[unsafe(method_family = none)]
        pub fn lineBreakMode(&self) -> NSLineBreakMode;

        #[cfg(feature = "NSParagraphStyle")]
        /// Setter for [`lineBreakMode`][Self::lineBreakMode].
        #[unsafe(method(setLineBreakMode:))]
        #[unsafe(method_family = none)]
        pub fn setLineBreakMode(&self, line_break_mode: NSLineBreakMode);

        #[unsafe(method(allowsUndo))]
        #[unsafe(method_family = none)]
        pub fn allowsUndo(&self) -> bool;

        /// Setter for [`allowsUndo`][Self::allowsUndo].
        #[unsafe(method(setAllowsUndo:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsUndo(&self, allows_undo: bool);

        #[unsafe(method(truncatesLastVisibleLine))]
        #[unsafe(method_family = none)]
        pub fn truncatesLastVisibleLine(&self) -> bool;

        /// Setter for [`truncatesLastVisibleLine`][Self::truncatesLastVisibleLine].
        #[unsafe(method(setTruncatesLastVisibleLine:))]
        #[unsafe(method_family = none)]
        pub fn setTruncatesLastVisibleLine(&self, truncates_last_visible_line: bool);

        #[cfg(feature = "NSUserInterfaceLayout")]
        #[unsafe(method(userInterfaceLayoutDirection))]
        #[unsafe(method_family = none)]
        pub fn userInterfaceLayoutDirection(&self) -> NSUserInterfaceLayoutDirection;

        #[cfg(feature = "NSUserInterfaceLayout")]
        /// Setter for [`userInterfaceLayoutDirection`][Self::userInterfaceLayoutDirection].
        #[unsafe(method(setUserInterfaceLayoutDirection:))]
        #[unsafe(method_family = none)]
        pub fn setUserInterfaceLayoutDirection(
            &self,
            user_interface_layout_direction: NSUserInterfaceLayoutDirection,
        );

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSText",
            feature = "NSTextView",
            feature = "NSView"
        ))]
        #[unsafe(method(fieldEditorForView:))]
        #[unsafe(method_family = none)]
        pub fn fieldEditorForView(&self, control_view: &NSView) -> Option<Retained<NSTextView>>;

        #[unsafe(method(usesSingleLineMode))]
        #[unsafe(method_family = none)]
        pub fn usesSingleLineMode(&self) -> bool;

        /// Setter for [`usesSingleLineMode`][Self::usesSingleLineMode].
        #[unsafe(method(setUsesSingleLineMode:))]
        #[unsafe(method_family = none)]
        pub fn setUsesSingleLineMode(&self, uses_single_line_mode: bool);

        #[cfg(all(
            feature = "NSDraggingItem",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[unsafe(method(draggingImageComponentsWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub fn draggingImageComponentsWithFrame_inView(
            &self,
            frame: NSRect,
            view: &NSView,
        ) -> Retained<NSArray<NSDraggingImageComponent>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSCell {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// NSKeyboardUI.
impl NSCell {
    extern_methods!(
        #[unsafe(method(refusesFirstResponder))]
        #[unsafe(method_family = none)]
        pub fn refusesFirstResponder(&self) -> bool;

        /// Setter for [`refusesFirstResponder`][Self::refusesFirstResponder].
        #[unsafe(method(setRefusesFirstResponder:))]
        #[unsafe(method_family = none)]
        pub fn setRefusesFirstResponder(&self, refuses_first_responder: bool);

        #[unsafe(method(acceptsFirstResponder))]
        #[unsafe(method_family = none)]
        pub fn acceptsFirstResponder(&self) -> bool;

        #[unsafe(method(showsFirstResponder))]
        #[unsafe(method_family = none)]
        pub fn showsFirstResponder(&self) -> bool;

        /// Setter for [`showsFirstResponder`][Self::showsFirstResponder].
        #[unsafe(method(setShowsFirstResponder:))]
        #[unsafe(method_family = none)]
        pub fn setShowsFirstResponder(&self, shows_first_responder: bool);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(performClick:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performClick(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(focusRingType))]
        #[unsafe(method_family = none)]
        pub fn focusRingType(&self) -> NSFocusRingType;

        #[cfg(feature = "NSGraphics")]
        /// Setter for [`focusRingType`][Self::focusRingType].
        #[unsafe(method(setFocusRingType:))]
        #[unsafe(method_family = none)]
        pub fn setFocusRingType(&self, focus_ring_type: NSFocusRingType);

        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(defaultFocusRingType))]
        #[unsafe(method_family = none)]
        pub fn defaultFocusRingType(mtm: MainThreadMarker) -> NSFocusRingType;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(drawFocusRingMaskWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub fn drawFocusRingMaskWithFrame_inView(&self, cell_frame: NSRect, control_view: &NSView);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(focusRingMaskBoundsForFrame:inView:))]
        #[unsafe(method_family = none)]
        pub fn focusRingMaskBoundsForFrame_inView(
            &self,
            cell_frame: NSRect,
            control_view: &NSView,
        ) -> NSRect;

        #[unsafe(method(wantsNotificationForMarkedText))]
        #[unsafe(method_family = none)]
        pub fn wantsNotificationForMarkedText(&self) -> bool;
    );
}

/// NSCellAttributedStringMethods.
impl NSCell {
    extern_methods!(
        #[unsafe(method(attributedStringValue))]
        #[unsafe(method_family = none)]
        pub fn attributedStringValue(&self) -> Retained<NSAttributedString>;

        /// Setter for [`attributedStringValue`][Self::attributedStringValue].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAttributedStringValue:))]
        #[unsafe(method_family = none)]
        pub fn setAttributedStringValue(&self, attributed_string_value: &NSAttributedString);

        #[unsafe(method(allowsEditingTextAttributes))]
        #[unsafe(method_family = none)]
        pub fn allowsEditingTextAttributes(&self) -> bool;

        /// Setter for [`allowsEditingTextAttributes`][Self::allowsEditingTextAttributes].
        #[unsafe(method(setAllowsEditingTextAttributes:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsEditingTextAttributes(&self, allows_editing_text_attributes: bool);

        #[unsafe(method(importsGraphics))]
        #[unsafe(method_family = none)]
        pub fn importsGraphics(&self) -> bool;

        /// Setter for [`importsGraphics`][Self::importsGraphics].
        #[unsafe(method(setImportsGraphics:))]
        #[unsafe(method_family = none)]
        pub fn setImportsGraphics(&self, imports_graphics: bool);
    );
}

/// NSCellMixedState.
impl NSCell {
    extern_methods!(
        #[unsafe(method(allowsMixedState))]
        #[unsafe(method_family = none)]
        pub fn allowsMixedState(&self) -> bool;

        /// Setter for [`allowsMixedState`][Self::allowsMixedState].
        #[unsafe(method(setAllowsMixedState:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsMixedState(&self, allows_mixed_state: bool);

        #[unsafe(method(nextState))]
        #[unsafe(method_family = none)]
        pub fn nextState(&self) -> NSInteger;

        #[unsafe(method(setNextState))]
        #[unsafe(method_family = none)]
        pub fn setNextState(&self);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscellhitresult?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCellHitResult(pub NSUInteger);
bitflags::bitflags! {
    impl NSCellHitResult: NSUInteger {
        #[doc(alias = "NSCellHitNone")]
        const None = 0;
        #[doc(alias = "NSCellHitContentArea")]
        const ContentArea = 1<<0;
        #[doc(alias = "NSCellHitEditableTextArea")]
        const EditableTextArea = 1<<1;
        #[doc(alias = "NSCellHitTrackableArea")]
        const TrackableArea = 1<<2;
    }
}

unsafe impl Encode for NSCellHitResult {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCellHitResult {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// NSCellHitTest.
impl NSCell {
    extern_methods!(
        #[cfg(all(feature = "NSEvent", feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(hitTestForEvent:inRect:ofView:))]
        #[unsafe(method_family = none)]
        pub fn hitTestForEvent_inRect_ofView(
            &self,
            event: &NSEvent,
            cell_frame: NSRect,
            control_view: &NSView,
        ) -> NSCellHitResult;
    );
}

/// NSCellExpansion.
impl NSCell {
    extern_methods!(
        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(expansionFrameWithFrame:inView:))]
        #[unsafe(method_family = none)]
        pub fn expansionFrameWithFrame_inView(&self, cell_frame: NSRect, view: &NSView) -> NSRect;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(drawWithExpansionFrame:inView:))]
        #[unsafe(method_family = none)]
        pub fn drawWithExpansionFrame_inView(&self, cell_frame: NSRect, view: &NSView);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbackgroundstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSBackgroundStyle(pub NSInteger);
impl NSBackgroundStyle {
    #[doc(alias = "NSBackgroundStyleNormal")]
    pub const Normal: Self = Self(0);
    #[doc(alias = "NSBackgroundStyleEmphasized")]
    pub const Emphasized: Self = Self(1);
    #[doc(alias = "NSBackgroundStyleRaised")]
    pub const Raised: Self = Self(2);
    #[doc(alias = "NSBackgroundStyleLowered")]
    pub const Lowered: Self = Self(3);
}

unsafe impl Encode for NSBackgroundStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSBackgroundStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// NSCellBackgroundStyle.
impl NSCell {
    extern_methods!(
        #[unsafe(method(backgroundStyle))]
        #[unsafe(method_family = none)]
        pub fn backgroundStyle(&self) -> NSBackgroundStyle;

        /// Setter for [`backgroundStyle`][Self::backgroundStyle].
        #[unsafe(method(setBackgroundStyle:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundStyle(&self, background_style: NSBackgroundStyle);

        #[unsafe(method(interiorBackgroundStyle))]
        #[unsafe(method_family = none)]
        pub fn interiorBackgroundStyle(&self) -> NSBackgroundStyle;
    );
}

#[cfg(all(
    feature = "NSGraphics",
    feature = "NSImage",
    feature = "objc2-core-foundation"
))]
#[inline]
pub extern "C-unwind" fn NSDrawThreePartImage(
    frame: NSRect,
    start_cap: Option<&NSImage>,
    center_fill: Option<&NSImage>,
    end_cap: Option<&NSImage>,
    vertical: bool,
    op: NSCompositingOperation,
    alpha_fraction: CGFloat,
    flipped: bool,
) {
    extern "C-unwind" {
        fn NSDrawThreePartImage(
            frame: NSRect,
            start_cap: Option<&NSImage>,
            center_fill: Option<&NSImage>,
            end_cap: Option<&NSImage>,
            vertical: Bool,
            op: NSCompositingOperation,
            alpha_fraction: CGFloat,
            flipped: Bool,
        );
    }
    unsafe {
        NSDrawThreePartImage(
            frame,
            start_cap,
            center_fill,
            end_cap,
            Bool::new(vertical),
            op,
            alpha_fraction,
            Bool::new(flipped),
        )
    }
}

#[cfg(all(
    feature = "NSGraphics",
    feature = "NSImage",
    feature = "objc2-core-foundation"
))]
#[inline]
pub extern "C-unwind" fn NSDrawNinePartImage(
    frame: NSRect,
    top_left_corner: Option<&NSImage>,
    top_edge_fill: Option<&NSImage>,
    top_right_corner: Option<&NSImage>,
    left_edge_fill: Option<&NSImage>,
    center_fill: Option<&NSImage>,
    right_edge_fill: Option<&NSImage>,
    bottom_left_corner: Option<&NSImage>,
    bottom_edge_fill: Option<&NSImage>,
    bottom_right_corner: Option<&NSImage>,
    op: NSCompositingOperation,
    alpha_fraction: CGFloat,
    flipped: bool,
) {
    extern "C-unwind" {
        fn NSDrawNinePartImage(
            frame: NSRect,
            top_left_corner: Option<&NSImage>,
            top_edge_fill: Option<&NSImage>,
            top_right_corner: Option<&NSImage>,
            left_edge_fill: Option<&NSImage>,
            center_fill: Option<&NSImage>,
            right_edge_fill: Option<&NSImage>,
            bottom_left_corner: Option<&NSImage>,
            bottom_edge_fill: Option<&NSImage>,
            bottom_right_corner: Option<&NSImage>,
            op: NSCompositingOperation,
            alpha_fraction: CGFloat,
            flipped: Bool,
        );
    }
    unsafe {
        NSDrawNinePartImage(
            frame,
            top_left_corner,
            top_edge_fill,
            top_right_corner,
            left_edge_fill,
            center_fill,
            right_edge_fill,
            bottom_left_corner,
            bottom_edge_fill,
            bottom_right_corner,
            op,
            alpha_fraction,
            Bool::new(flipped),
        )
    }
}

/// NSDeprecated.
impl NSCell {
    extern_methods!(
        #[deprecated = "The controlTint property is not respected on 10.14 and later. For custom cells, use +[NSColor controlAccentColor] to respect the user's preferred accent color when drawing."]
        #[unsafe(method(controlTint))]
        #[unsafe(method_family = none)]
        pub fn controlTint(&self) -> NSControlTint;

        /// Setter for [`controlTint`][Self::controlTint].
        #[deprecated = "The controlTint property is not respected on 10.14 and later. For custom cells, use +[NSColor controlAccentColor] to respect the user's preferred accent color when drawing."]
        #[unsafe(method(setControlTint:))]
        #[unsafe(method_family = none)]
        pub fn setControlTint(&self, control_tint: NSControlTint);

        #[deprecated]
        #[unsafe(method(entryType))]
        #[unsafe(method_family = none)]
        pub fn entryType(&self) -> NSInteger;

        #[deprecated]
        #[unsafe(method(setEntryType:))]
        #[unsafe(method_family = none)]
        pub fn setEntryType(&self, r#type: NSInteger);

        #[deprecated]
        #[unsafe(method(isEntryAcceptable:))]
        #[unsafe(method_family = none)]
        pub fn isEntryAcceptable(&self, string: &NSString) -> bool;

        #[deprecated]
        #[unsafe(method(setFloatingPointFormat:left:right:))]
        #[unsafe(method_family = none)]
        pub fn setFloatingPointFormat_left_right(
            &self,
            auto_range: bool,
            left_digits: NSUInteger,
            right_digits: NSUInteger,
        );

        #[deprecated]
        #[unsafe(method(setMnemonicLocation:))]
        #[unsafe(method_family = none)]
        pub fn setMnemonicLocation(&self, location: NSUInteger);

        #[deprecated]
        #[unsafe(method(mnemonicLocation))]
        #[unsafe(method_family = none)]
        pub fn mnemonicLocation(&self) -> NSUInteger;

        #[deprecated]
        #[unsafe(method(mnemonic))]
        #[unsafe(method_family = none)]
        pub fn mnemonic(&self) -> Retained<NSString>;

        #[deprecated]
        #[unsafe(method(setTitleWithMnemonic:))]
        #[unsafe(method_family = none)]
        pub fn setTitleWithMnemonic(&self, string_with_ampersand: &NSString);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbackgroundstylelight?language=objc)
#[deprecated]
pub static NSBackgroundStyleLight: NSBackgroundStyle =
    NSBackgroundStyle(NSBackgroundStyle::Normal.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbackgroundstyledark?language=objc)
#[deprecated]
pub static NSBackgroundStyleDark: NSBackgroundStyle =
    NSBackgroundStyle(NSBackgroundStyle::Emphasized.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscellstatevalue?language=objc)
#[deprecated]
pub type NSCellStateValue = NSControlStateValue;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmixedstate?language=objc)
#[deprecated]
pub static NSMixedState: NSControlStateValue = NSControlStateValueMixed;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsoffstate?language=objc)
#[deprecated]
pub static NSOffState: NSControlStateValue = NSControlStateValueOff;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsonstate?language=objc)
#[deprecated]
pub static NSOnState: NSControlStateValue = NSControlStateValueOn;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsregularcontrolsize?language=objc)
#[deprecated]
pub static NSRegularControlSize: NSControlSize = NSControlSize(NSControlSize::Regular.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssmallcontrolsize?language=objc)
#[deprecated]
pub static NSSmallControlSize: NSControlSize = NSControlSize(NSControlSize::Small.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsminicontrolsize?language=objc)
#[deprecated]
pub static NSMiniControlSize: NSControlSize = NSControlSize(NSControlSize::Mini.0);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontroltintdidchangenotification?language=objc)
    #[deprecated = "Changes to the accent color can be manually observed by implementing -viewDidChangeEffectiveAppearance in a NSView subclass, or by Key-Value Observing the -effectiveAppearance property on NSApplication. Views are automatically redisplayed when the accent color changes."]
    pub static NSControlTintDidChangeNotification: &'static NSNotificationName;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanytype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSAnyType: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsinttype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSIntType: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspositiveinttype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSPositiveIntType: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfloattype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSFloatType: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspositivefloattype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSPositiveFloatType: c_uint = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdoubletype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSDoubleType: c_uint = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspositivedoubletype?language=objc)
#[deprecated = "Use formatters instead"]
pub const NSPositiveDoubleType: c_uint = 7;
