// Code generated by 'go generate'; DO NOT EDIT.

package desktop

import (
	"syscall"
	"unsafe"

	"golang.org/x/sys/windows"
)

var _ unsafe.Pointer

// Do the interface allocations only once for common
// Errno values.
const (
	errnoERROR_IO_PENDING = 997
)

var (
	errERROR_IO_PENDING error = syscall.Errno(errnoERROR_IO_PENDING)
	errERROR_EINVAL     error = syscall.EINVAL
)

// errnoErr returns common boxed Errno values, to prevent
// allocations at runtime.
func errnoErr(e syscall.Errno) error {
	switch e {
	case 0:
		return errERROR_EINVAL
	case errnoERROR_IO_PENDING:
		return errERROR_IO_PENDING
	}
	// TODO: add more here, after collecting data on the common
	// error values see on Windows. (perhaps when running
	// all.bat?)
	return e
}

var (
	modkernel32 = windows.NewLazySystemDLL("kernel32.dll")
	moduser32   = windows.NewLazySystemDLL("user32.dll")
	modwtsapi32 = windows.NewLazySystemDLL("wtsapi32.dll")

	procSetLastError                       = modkernel32.NewProc("SetLastError")
	procCreateWindowExW                    = moduser32.NewProc("CreateWindowExW")
	procDefWindowProcW                     = moduser32.NewProc("DefWindowProcW")
	procDestroyWindow                      = moduser32.NewProc("DestroyWindow")
	procDispatchMessageW                   = moduser32.NewProc("DispatchMessageW")
	procGetMessageW                        = moduser32.NewProc("GetMessageW")
	procPostQuitMessage                    = moduser32.NewProc("PostQuitMessage")
	procRegisterClassExW                   = moduser32.NewProc("RegisterClassExW")
	procSendMessageW                       = moduser32.NewProc("SendMessageW")
	procTranslateMessage                   = moduser32.NewProc("TranslateMessage")
	procWTSRegisterSessionNotificationEx   = modwtsapi32.NewProc("WTSRegisterSessionNotificationEx")
	procWTSUnRegisterSessionNotificationEx = modwtsapi32.NewProc("WTSUnRegisterSessionNotificationEx")
)

func setLastError(dwErrorCode uint32) {
	syscall.SyscallN(procSetLastError.Addr(), uintptr(dwErrorCode))
	return
}

func createWindowEx(dwExStyle uint32, lpClassName *uint16, lpWindowName *uint16, dwStyle uint32, x int32, y int32, nWidth int32, nHeight int32, hWndParent windows.HWND, hMenu windows.Handle, hInstance windows.Handle, lpParam unsafe.Pointer) (hWnd windows.HWND, err error) {
	r0, _, e1 := syscall.SyscallN(procCreateWindowExW.Addr(), uintptr(dwExStyle), uintptr(unsafe.Pointer(lpClassName)), uintptr(unsafe.Pointer(lpWindowName)), uintptr(dwStyle), uintptr(x), uintptr(y), uintptr(nWidth), uintptr(nHeight), uintptr(hWndParent), uintptr(hMenu), uintptr(hInstance), uintptr(lpParam))
	hWnd = windows.HWND(r0)
	if hWnd == 0 {
		err = errnoErr(e1)
	}
	return
}

func defWindowProc(hwnd windows.HWND, msg uint32, wparam uintptr, lparam uintptr) (res uintptr) {
	r0, _, _ := syscall.SyscallN(procDefWindowProcW.Addr(), uintptr(hwnd), uintptr(msg), uintptr(wparam), uintptr(lparam))
	res = uintptr(r0)
	return
}

func destroyWindow(hwnd windows.HWND) (err error) {
	r1, _, e1 := syscall.SyscallN(procDestroyWindow.Addr(), uintptr(hwnd))
	if int32(r1) == 0 {
		err = errnoErr(e1)
	}
	return
}

func dispatchMessage(lpMsg *_MSG) (res uintptr) {
	r0, _, _ := syscall.SyscallN(procDispatchMessageW.Addr(), uintptr(unsafe.Pointer(lpMsg)))
	res = uintptr(r0)
	return
}

func getMessage(lpMsg *_MSG, hwnd windows.HWND, msgMin uint32, msgMax uint32) (ret int32) {
	r0, _, _ := syscall.SyscallN(procGetMessageW.Addr(), uintptr(unsafe.Pointer(lpMsg)), uintptr(hwnd), uintptr(msgMin), uintptr(msgMax))
	ret = int32(r0)
	return
}

func postQuitMessage(exitCode int32) {
	syscall.SyscallN(procPostQuitMessage.Addr(), uintptr(exitCode))
	return
}

func registerClassEx(windowClass *_WNDCLASSEX) (atom uint16, err error) {
	r0, _, e1 := syscall.SyscallN(procRegisterClassExW.Addr(), uintptr(unsafe.Pointer(windowClass)))
	atom = uint16(r0)
	if atom == 0 {
		err = errnoErr(e1)
	}
	return
}

func sendMessage(hwnd windows.HWND, msg uint32, wparam uintptr, lparam uintptr) (res uintptr) {
	r0, _, _ := syscall.SyscallN(procSendMessageW.Addr(), uintptr(hwnd), uintptr(msg), uintptr(wparam), uintptr(lparam))
	res = uintptr(r0)
	return
}

func translateMessage(lpMsg *_MSG) (res bool) {
	r0, _, _ := syscall.SyscallN(procTranslateMessage.Addr(), uintptr(unsafe.Pointer(lpMsg)))
	res = r0 != 0
	return
}

func registerSessionNotification(hServer windows.Handle, hwnd windows.HWND, flags uint32) (err error) {
	r1, _, e1 := syscall.SyscallN(procWTSRegisterSessionNotificationEx.Addr(), uintptr(hServer), uintptr(hwnd), uintptr(flags))
	if int32(r1) == 0 {
		err = errnoErr(e1)
	}
	return
}

func unregisterSessionNotification(hServer windows.Handle, hwnd windows.HWND) (err error) {
	r1, _, e1 := syscall.SyscallN(procWTSUnRegisterSessionNotificationEx.Addr(), uintptr(hServer), uintptr(hwnd))
	if int32(r1) == 0 {
		err = errnoErr(e1)
	}
	return
}
