/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.stmt;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class TryCatchStatement
extends Statement {
    private Statement tryStatement;
    private Statement finallyStatement;
    private final List<CatchStatement> catchStatements = new ArrayList<CatchStatement>();
    private final List<ExpressionStatement> resourceStatements = new ArrayList<ExpressionStatement>();

    public TryCatchStatement(Statement tryStatement, Statement finallyStatement) {
        this.tryStatement = tryStatement;
        this.finallyStatement = finallyStatement;
    }

    @Override
    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitTryCatchFinally(this);
    }

    public Statement getTryStatement() {
        return this.tryStatement;
    }

    public Statement getFinallyStatement() {
        return this.finallyStatement;
    }

    public CatchStatement getCatchStatement(int idx) {
        if (idx >= 0 && idx < this.catchStatements.size()) {
            return this.catchStatements.get(idx);
        }
        return null;
    }

    public List<CatchStatement> getCatchStatements() {
        return this.catchStatements;
    }

    public ExpressionStatement getResourceStatement(int idx) {
        if (idx >= 0 && idx < this.resourceStatements.size()) {
            return this.resourceStatements.get(idx);
        }
        return null;
    }

    public List<ExpressionStatement> getResourceStatements() {
        return this.resourceStatements;
    }

    public static boolean isResource(Expression expression) {
        return Boolean.TRUE.equals(expression.getNodeMetaData("_IS_RESOURCE"));
    }

    public void setTryStatement(Statement tryStatement) {
        this.tryStatement = tryStatement;
    }

    public void setFinallyStatement(Statement finallyStatement) {
        this.finallyStatement = finallyStatement;
    }

    public void setCatchStatement(int idx, CatchStatement catchStatement) {
        this.catchStatements.set(idx, catchStatement);
    }

    public TryCatchStatement addCatch(CatchStatement catchStatement) {
        this.catchStatements.add(catchStatement);
        return this;
    }

    public TryCatchStatement addResource(ExpressionStatement resourceStatement) {
        Expression resourceExpression = resourceStatement.getExpression();
        if (!(resourceExpression instanceof DeclarationExpression) && !(resourceExpression instanceof VariableExpression)) {
            throw new GroovyBugError("resourceStatement should be a variable declaration statement or a variable");
        }
        resourceExpression.putNodeMetaData("_IS_RESOURCE", Boolean.TRUE);
        this.resourceStatements.add(resourceStatement);
        return this;
    }
}

