/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjaropenbeans;

import groovyjarjarharmonybeans.BeansUtils;
import groovyjarjarharmonybeans.internal.nls.Messages;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class Statement {
    private Object target;
    private String methodName;
    private Object[] arguments;
    private static WeakHashMap<Class<?>, Method[]> classMethodsCache = new WeakHashMap();
    private static final String[][] pdConstructorSignatures = new String[][]{{"java.lang.Class", "new", "java.lang.Boolean", "", "", ""}, {"java.lang.Class", "new", "java.lang.Byte", "", "", ""}, {"java.lang.Class", "new", "java.lang.Character", "", "", ""}, {"java.lang.Class", "new", "java.lang.Double", "", "", ""}, {"java.lang.Class", "new", "java.lang.Float", "", "", ""}, {"java.lang.Class", "new", "java.lang.Integer", "", "", ""}, {"java.lang.Class", "new", "java.lang.Long", "", "", ""}, {"java.lang.Class", "new", "java.lang.Short", "", "", ""}, {"java.lang.Class", "new", "java.lang.String", "", "", ""}, {"java.lang.Class", "forName", "java.lang.String", "", "", ""}, {"java.lang.Class", "newInstance", "java.lang.Class", "java.lang.Integer", "", ""}, {"java.lang.reflect.Field", "get", "null", "", "", ""}, {"java.lang.Class", "forName", "java.lang.String", "", "", ""}};

    public Statement(Object target, String methodName, Object[] arguments) {
        this.target = target;
        this.methodName = methodName;
        this.arguments = arguments == null ? BeansUtils.EMPTY_OBJECT_ARRAY : arguments;
    }

    public String toString() {
        Class<?> clazz;
        StringBuilder sb = new StringBuilder();
        if (this.target == null) {
            sb.append("null");
        } else {
            clazz = this.target.getClass();
            sb.append(clazz == String.class ? "\"\"" : BeansUtils.idOfClass(clazz));
        }
        sb.append('.' + this.methodName + '(');
        if (this.arguments != null) {
            for (int index = 0; index < this.arguments.length; ++index) {
                if (index > 0) {
                    sb.append(", ");
                }
                if (this.arguments[index] == null) {
                    sb.append("null");
                    continue;
                }
                clazz = this.arguments[index].getClass();
                sb.append(clazz == String.class ? '\"' + (String)this.arguments[index] + '\"' : BeansUtils.idOfClass(clazz));
            }
        }
        sb.append(')');
        sb.append(';');
        return sb.toString();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Object getTarget() {
        return this.target;
    }

    public void execute() throws Exception {
        this.invokeMethod();
    }

    Object invokeMethod() throws Exception {
        Class<?> result;
        block24: {
            result = null;
            try {
                Object target = this.getTarget();
                String methodName = this.getMethodName();
                Object[] arguments = this.getArguments();
                Class<?> targetClass = target.getClass();
                if (targetClass.isArray()) {
                    Method method = this.findArrayMethod(methodName, arguments);
                    Object[] copy = new Object[arguments.length + 1];
                    copy[0] = target;
                    System.arraycopy(arguments, 0, copy, 1, arguments.length);
                    result = method.invoke(null, copy);
                    break block24;
                }
                if ("newInstance".equals(methodName) && target == Array.class) {
                    result = Array.newInstance((Class)arguments[0], (int)((Integer)arguments[1]));
                    break block24;
                }
                if ("new".equals(methodName) || "newInstance".equals(methodName)) {
                    if (target instanceof Class) {
                        Constructor<?> constructor = this.findConstructor((Class)target, arguments);
                        result = constructor.newInstance(arguments);
                    } else {
                        if ("new".equals(methodName)) {
                            throw new NoSuchMethodException(this.toString());
                        }
                        Method method = Statement.findMethod(targetClass, methodName, arguments, false);
                        result = method.invoke(target, arguments);
                    }
                    break block24;
                }
                if (methodName.equals("newArray")) {
                    Class clazz = (Class)target;
                    for (int index = 0; index < arguments.length; ++index) {
                        Class<?> argClass;
                        Class<?> clazz2 = argClass = arguments[index] == null ? null : arguments[index].getClass();
                        if (argClass == null || clazz.isAssignableFrom(argClass) || BeansUtils.isPrimitiveWrapper(argClass, clazz)) continue;
                        throw new IllegalArgumentException(Messages.getString("beans.63"));
                    }
                    result = Array.newInstance(clazz, arguments.length);
                    if (clazz.isPrimitive()) {
                        this.arrayCopy(clazz, arguments, result, arguments.length);
                    } else {
                        System.arraycopy(arguments, 0, result, 0, arguments.length);
                    }
                    return result;
                }
                if (target instanceof Class) {
                    Method method = null;
                    try {
                        if (target != Class.class) {
                            method = Statement.findMethod((Class)target, methodName, arguments, true);
                            result = method.invoke(null, arguments);
                        }
                    }
                    catch (NoSuchMethodException argClass) {
                        // empty catch block
                    }
                    if (method == null) {
                        if ("forName".equals(methodName) && arguments.length == 1 && arguments[0] instanceof String) {
                            try {
                                result = Class.forName((String)arguments[0]);
                            }
                            catch (ClassNotFoundException e2) {
                                result = Class.forName((String)arguments[0], true, Thread.currentThread().getContextClassLoader());
                            }
                        } else {
                            method = Statement.findMethod(targetClass, methodName, arguments, false);
                            result = method.invoke(target, arguments);
                        }
                    }
                    break block24;
                }
                if (target instanceof Iterator) {
                    final Iterator iterator = (Iterator)target;
                    final Method method = Statement.findMethod(targetClass, methodName, arguments, false);
                    if (iterator.hasNext()) {
                        result = new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                try {
                                    method.setAccessible(true);
                                    return method.invoke((Object)iterator, new Object[0]);
                                }
                                catch (Exception exception) {
                                    return null;
                                }
                            }
                        }.run();
                    }
                } else {
                    Method method = Statement.findMethod(targetClass, methodName, arguments, false);
                    method.setAccessible(true);
                    result = method.invoke(target, arguments);
                }
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                throw t != null && t instanceof Exception ? (Exception)t : ite;
            }
        }
        return result;
    }

    private void arrayCopy(Class<?> type, Object[] src, Object dest, int length) {
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        if (type != Boolean.TYPE) break block8;
                                        boolean[] destination = (boolean[])dest;
                                        for (int index = 0; index < length; ++index) {
                                            destination[index] = (Boolean)src[index];
                                        }
                                        break block9;
                                    }
                                    if (type != Short.TYPE) break block10;
                                    short[] destination = (short[])dest;
                                    for (int index = 0; index < length; ++index) {
                                        destination[index] = (Short)src[index];
                                    }
                                    break block9;
                                }
                                if (type != Byte.TYPE) break block11;
                                byte[] destination = (byte[])dest;
                                for (int index = 0; index < length; ++index) {
                                    destination[index] = (Byte)src[index];
                                }
                                break block9;
                            }
                            if (type != Character.TYPE) break block12;
                            char[] destination = (char[])dest;
                            for (int index = 0; index < length; ++index) {
                                destination[index] = ((Character)src[index]).charValue();
                            }
                            break block9;
                        }
                        if (type != Integer.TYPE) break block13;
                        int[] destination = (int[])dest;
                        for (int index = 0; index < length; ++index) {
                            destination[index] = (Integer)src[index];
                        }
                        break block9;
                    }
                    if (type != Long.TYPE) break block14;
                    long[] destination = (long[])dest;
                    for (int index = 0; index < length; ++index) {
                        destination[index] = (Long)src[index];
                    }
                    break block9;
                }
                if (type != Float.TYPE) break block15;
                float[] destination = (float[])dest;
                for (int index = 0; index < length; ++index) {
                    destination[index] = ((Float)src[index]).floatValue();
                }
                break block9;
            }
            if (type != Double.TYPE) break block9;
            double[] destination = (double[])dest;
            for (int index = 0; index < length; ++index) {
                destination[index] = (Double)src[index];
            }
        }
    }

    private Method findArrayMethod(String methodName, Object[] args) throws NoSuchMethodException {
        Class[] classArray;
        boolean isGet = "get".equals(methodName);
        boolean isSet = "set".equals(methodName);
        if (!isGet && !isSet) {
            throw new NoSuchMethodException(Messages.getString("beans.3C"));
        }
        if (args.length > 0 && args[0].getClass() != Integer.class) {
            throw new ClassCastException(Messages.getString("beans.3D"));
        }
        if (isGet && args.length != 1) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("beans.3E"));
        }
        if (isSet && args.length != 2) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("beans.3F"));
        }
        if (isGet) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = Object.class;
            classArray = classArray2;
            classArray2[1] = Integer.TYPE;
        } else {
            Class[] classArray3 = new Class[3];
            classArray3[0] = Object.class;
            classArray3[1] = Integer.TYPE;
            classArray = classArray3;
            classArray3[2] = Object.class;
        }
        Class[] paraTypes = classArray;
        return Array.class.getMethod(methodName, paraTypes);
    }

    private Constructor<?> findConstructor(Class<?> clazz, Object[] args) throws NoSuchMethodException {
        Class<?>[] argTypes = Statement.getTypes(args);
        Constructor<?> result = null;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] paraTypes = constructor.getParameterTypes();
            if (!Statement.match(argTypes, paraTypes)) continue;
            if (result == null) {
                result = constructor;
                continue;
            }
            Class<?>[] resultParaTypes = result.getParameterTypes();
            boolean isAssignable = true;
            for (int index = 0; index < paraTypes.length && (argTypes[index] == null || (isAssignable &= resultParaTypes[index].isAssignableFrom(paraTypes[index]))) && (argTypes[index] != null || (isAssignable &= paraTypes[index].isAssignableFrom(resultParaTypes[index]))); ++index) {
            }
            if (!isAssignable) continue;
            result = constructor;
        }
        if (result == null) {
            throw new NoSuchMethodException(Messages.getString("beans.40", clazz.getName()));
        }
        return result;
    }

    static Method findMethod(Class<?> clazz, String methodName, Object[] args, boolean isStatic) throws NoSuchMethodException {
        Class<?>[] argTypes = Statement.getTypes(args);
        Method[] methods = null;
        if (classMethodsCache.containsKey(clazz)) {
            methods = classMethodsCache.get(clazz);
        } else {
            methods = clazz.getMethods();
            classMethodsCache.put(clazz, methods);
        }
        ArrayList<Method> fitMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (!methodName.equals(method.getName()) || isStatic && !Modifier.isStatic(method.getModifiers()) || !Statement.match(argTypes, method.getParameterTypes())) continue;
            fitMethods.add(method);
        }
        int fitSize = fitMethods.size();
        if (fitSize == 0) {
            throw new NoSuchMethodException(Messages.getString("beans.41", methodName));
        }
        if (fitSize == 1) {
            return (Method)fitMethods.get(0);
        }
        MethodComparator comparator = new MethodComparator(methodName, argTypes);
        Method[] fitMethodArray = fitMethods.toArray(new Method[fitSize]);
        Method onlyMethod = fitMethodArray[0];
        for (int i = 1; i < fitMethodArray.length; ++i) {
            int difference = comparator.compare(onlyMethod, fitMethodArray[i]);
            if (difference == 0) {
                Class<?> fitReturnType;
                Class<?> onlyReturnType = onlyMethod.getReturnType();
                if (onlyReturnType == (fitReturnType = fitMethodArray[i].getReturnType())) {
                    throw new NoSuchMethodException(Messages.getString("beans.62", methodName));
                }
                if (onlyReturnType.isAssignableFrom(fitReturnType)) {
                    onlyMethod = fitMethodArray[i];
                }
            }
            if (difference <= 0) continue;
            onlyMethod = fitMethodArray[i];
        }
        return onlyMethod;
    }

    private static boolean match(Class<?>[] argTypes, Class<?>[] paraTypes) {
        if (paraTypes.length != argTypes.length) {
            return false;
        }
        for (int index = 0; index < paraTypes.length; ++index) {
            if (argTypes[index] == null || paraTypes[index].isAssignableFrom(argTypes[index]) || BeansUtils.isPrimitiveWrapper(argTypes[index], paraTypes[index])) continue;
            return false;
        }
        return true;
    }

    static boolean isStaticMethodCall(Statement stmt) {
        Object target = stmt.getTarget();
        String methodName = stmt.getMethodName();
        if (!(target instanceof Class)) {
            return false;
        }
        try {
            Statement.findMethod((Class)target, methodName, stmt.getArguments(), true);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    static boolean isPDConstructor(Statement stmt) {
        Object target = stmt.getTarget();
        String methodName = stmt.getMethodName();
        Object[] args = stmt.getArguments();
        Object[] sig = new String[pdConstructorSignatures[0].length];
        if (target == null || methodName == null || args == null || args.length == 0) {
            return false;
        }
        sig[0] = target.getClass().getName();
        sig[1] = methodName;
        for (int i = 2; i < sig.length; ++i) {
            sig[i] = args.length > i - 2 ? (args[i - 2] != null ? args[i - 2].getClass().getName() : "null") : "";
        }
        for (Object[] objectArray : pdConstructorSignatures) {
            if (!Arrays.equals(sig, objectArray)) continue;
            return true;
        }
        return false;
    }

    private static Class<?> getPrimitiveWrapper(Class<?> base) {
        Class res = null;
        if (base == Boolean.TYPE) {
            res = Boolean.class;
        } else if (base == Byte.TYPE) {
            res = Byte.class;
        } else if (base == Character.TYPE) {
            res = Character.class;
        } else if (base == Short.TYPE) {
            res = Short.class;
        } else if (base == Integer.TYPE) {
            res = Integer.class;
        } else if (base == Long.TYPE) {
            res = Long.class;
        } else if (base == Float.TYPE) {
            res = Float.class;
        } else if (base == Double.TYPE) {
            res = Double.class;
        }
        return res;
    }

    private static Class<?>[] getTypes(Object[] arguments) {
        Class[] types = new Class[arguments.length];
        for (int index = 0; index < arguments.length; ++index) {
            types[index] = arguments[index] == null ? null : arguments[index].getClass();
        }
        return types;
    }

    static class MethodComparator
    implements Comparator<Method> {
        static int INFINITY = Integer.MAX_VALUE;
        private String referenceMethodName;
        private Class<?>[] referenceMethodArgumentTypes;
        private final Map<Method, Integer> cache;

        public MethodComparator(String refMethodName, Class<?>[] refArgumentTypes) {
            this.referenceMethodName = refMethodName;
            this.referenceMethodArgumentTypes = refArgumentTypes;
            this.cache = new HashMap<Method, Integer>();
        }

        @Override
        public int compare(Method m1, Method m2) {
            Integer norm1 = this.cache.get(m1);
            Integer norm2 = this.cache.get(m2);
            if (norm1 == null) {
                norm1 = this.getNorm(m1);
                this.cache.put(m1, norm1);
            }
            if (norm2 == null) {
                norm2 = this.getNorm(m2);
                this.cache.put(m2, norm2);
            }
            return norm1 - norm2;
        }

        private int getNorm(Method m) {
            String methodName = m.getName();
            Class<?>[] argumentTypes = m.getParameterTypes();
            int totalNorm = 0;
            if (!this.referenceMethodName.equals(methodName) || this.referenceMethodArgumentTypes.length != argumentTypes.length) {
                return INFINITY;
            }
            for (int i = 0; i < this.referenceMethodArgumentTypes.length; ++i) {
                if (this.referenceMethodArgumentTypes[i] == null) continue;
                if (this.referenceMethodArgumentTypes[i].isPrimitive()) {
                    this.referenceMethodArgumentTypes[i] = Statement.getPrimitiveWrapper(this.referenceMethodArgumentTypes[i]);
                }
                if (argumentTypes[i].isPrimitive()) {
                    argumentTypes[i] = Statement.getPrimitiveWrapper(argumentTypes[i]);
                }
                totalNorm += MethodComparator.getDistance(this.referenceMethodArgumentTypes[i], argumentTypes[i]);
            }
            return totalNorm;
        }

        private static int getDistance(Class<?> clz1, Class<?> clz2) {
            int superDist = INFINITY;
            if (!clz2.isAssignableFrom(clz1)) {
                return INFINITY;
            }
            if (clz1.getName().equals(clz2.getName())) {
                return 0;
            }
            Class<?> superClz = clz1.getSuperclass();
            if (superClz != null) {
                superDist = MethodComparator.getDistance(superClz, clz2);
            }
            if (clz2.isInterface()) {
                Class<?>[] interfaces = clz1.getInterfaces();
                int bestDist = INFINITY;
                for (Class<?> element : interfaces) {
                    int curDist = MethodComparator.getDistance(element, clz2);
                    if (curDist >= bestDist) continue;
                    bestDist = curDist;
                }
                if (superDist < bestDist) {
                    bestDist = superDist;
                }
                return bestDist != INFINITY ? bestDist + 1 : INFINITY;
            }
            return superDist != INFINITY ? superDist + 2 : INFINITY;
        }
    }
}

