// DO NOT EDIT
// Generated by JFlex 1.9.0 http://jflex.de/
// source: src/main/jflex/LexScan.flex

/*
 * Copyright (C) 1998-2018  Gerwin Klein <lsf@jflex.de>
 * SPDX-License-Identifier: BSD-3-Clause
 */

package jflex.core;

import java_cup.runtime.Symbol;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import jflex.core.unicode.IntCharSet;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;
import jflex.option.Options;
import jflex.performance.Timer;
import jflex.scanner.ScannerException;
import jflex.skeleton.Skeleton;


@SuppressWarnings("fallthrough")
public final class LexScan extends AbstractLexScan implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int COMMENT = 2;
  public static final int STATELIST = 4;
  public static final int MACROS = 6;
  public static final int REGEXPSTART = 8;
  public static final int REGEXP = 10;
  public static final int JAVA_CODE = 12;
  public static final int STATES = 14;
  public static final int STRING_CONTENT = 16;
  public static final int CHARCLASS = 18;
  public static final int COPY = 20;
  public static final int REPEATEXP = 22;
  public static final int EATWSPNL = 24;
  public static final int CTOR_ARG = 26;
  public static final int REGEXP_CODEPOINT_SEQUENCE = 28;
  public static final int STRING_CODEPOINT_SEQUENCE = 30;
  public static final int CHARCLASS_CODEPOINT = 32;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  4,  5,  6,  7,  7,  8,  8,  9,  9, 
    10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 
    18, 18
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\10\u2f00\31\u1f00\1\u0100\1\u3000\1\u3100\1\u0100\1\u3200"+
    "\1\u3300\1\u3400\1\u3500\1\u3600\1\u3700\1\u3800\1\u3900\1\u3a00"+
    "\1\u0100\1\u3b00\1\u3c00\1\u3d00\1\u3e00\1\u3f00\1\u4000\3\u1f00"+
    "\1\u4100\1\u4200\1\u4300\1\u4400\1\u4500\1\u4600\1\u4700\1\u4800"+
    "\1\u4900\1\u1f00\1\u4a00\1\u1f00\1\u4b00\1\u4c00\2\u1f00\3\u0100"+
    "\1\u4d00\1\u4e00\1\u4f00\12\u1f00\4\u0100\1\u5000\17\u1f00\2\u0100"+
    "\1\u5100\41\u1f00\2\u0100\1\u5200\1\u5300\3\u1f00\1\u5400\27\u0100"+
    "\1\u5500\2\u0100\1\u5600\45\u1f00\1\u0100\1\u5700\1\u5800\11\u1f00"+
    "\1\u5900\24\u1f00\1\u5a00\1\u5b00\1\u1f00\1\u5c00\1\u5d00\1\u5e00"+
    "\1\u5f00\2\u1f00\1\u6000\5\u1f00\1\u6100\7\u1f00\1\u6200\1\u6300"+
    "\4\u1f00\1\u6400\21\u1f00\246\u0100\1\u6500\20\u0100\1\u6600\1\u6700"+
    "\25\u0100\1\u6800\34\u0100\1\u6900\14\u1f00\2\u0100\1\u6a00\u0b05\u1f00"+
    "\1\u6b00\1\u6c00\u02fe\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\10\0\1\1\1\2\1\3\2\4\1\5\16\0\4\6"+
    "\1\2\1\7\1\10\1\6\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\1\26\1\27\1\30\2\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\6\1\37\1\40\1\41\1\42\1\6"+
    "\3\43\1\44\1\45\1\46\10\47\1\50\1\51\1\47"+
    "\1\52\1\53\1\47\1\54\1\47\1\55\3\47\1\56"+
    "\1\57\1\60\1\61\1\62\1\6\1\63\1\64\1\65"+
    "\1\66\1\67\1\70\1\71\1\72\1\73\1\74\1\75"+
    "\1\76\1\77\1\100\1\101\1\102\1\47\1\103\1\104"+
    "\1\105\1\106\1\107\1\110\1\111\1\112\1\113\1\114"+
    "\1\115\1\116\1\117\6\0\1\120\32\0\2\6\4\121"+
    "\4\6\1\121\2\6\1\0\7\6\1\121\4\6\1\121"+
    "\5\6\27\121\1\6\37\121\1\6\u01ca\121\4\6\14\121"+
    "\16\6\5\121\7\6\1\121\1\6\1\121\21\6\160\0"+
    "\5\121\1\6\2\121\2\6\4\121\1\6\1\121\6\6"+
    "\1\121\1\6\3\121\1\6\1\121\1\6\24\121\1\6"+
    "\123\121\1\6\213\121\1\6\5\0\2\6\246\121\1\6"+
    "\46\121\2\6\1\121\7\6\47\121\7\6\1\121\1\6"+
    "\55\0\1\6\1\0\1\6\2\0\1\6\2\0\1\6"+
    "\1\0\10\6\33\121\5\6\3\121\15\6\6\0\5\6"+
    "\1\121\4\6\13\0\1\6\1\0\3\6\53\121\37\0"+
    "\4\6\2\121\1\0\143\121\1\6\1\121\10\0\1\6"+
    "\6\0\2\121\2\0\1\6\4\0\2\121\12\0\3\121"+
    "\2\6\1\121\17\6\1\0\1\121\1\0\36\121\33\0"+
    "\2\6\131\121\13\0\1\121\16\6\12\0\41\121\11\0"+
    "\2\121\4\6\1\121\5\6\26\121\4\0\1\121\11\0"+
    "\1\121\3\0\1\121\5\0\22\6\31\121\3\0\4\6"+
    "\13\121\65\6\25\121\1\6\10\121\26\6\60\0\66\121"+
    "\3\0\1\121\22\0\1\121\7\0\12\121\2\0\2\6"+
    "\12\0\1\6\20\121\3\0\1\6\10\121\2\6\2\121"+
    "\2\6\26\121\1\6\7\121\1\6\1\121\3\6\4\121"+
    "\2\6\1\0\1\121\7\0\2\6\2\0\2\6\3\0"+
    "\1\121\10\6\1\0\4\6\2\121\1\6\3\121\2\0"+
    "\2\6\12\0\4\121\7\6\2\121\4\6\3\0\1\6"+
    "\6\121\4\6\2\121\2\6\26\121\1\6\7\121\1\6"+
    "\2\121\1\6\2\121\1\6\2\121\2\6\1\0\1\6"+
    "\5\0\4\6\2\0\2\6\3\0\3\6\1\0\7\6"+
    "\4\121\1\6\1\121\7\6\14\0\3\121\1\0\13\6"+
    "\3\0\1\6\11\121\1\6\3\121\1\6\26\121\1\6"+
    "\7\121\1\6\2\121\1\6\5\121\2\6\1\0\1\121"+
    "\10\0\1\6\3\0\1\6\3\0\2\6\1\121\17\6"+
    "\2\121\2\0\2\6\12\0\1\6\1\121\7\6\1\121"+
    "\6\0\1\6\3\0\1\6\10\121\2\6\2\121\2\6"+
    "\26\121\1\6\7\121\1\6\2\121\1\6\5\121\2\6"+
    "\1\0\1\121\7\0\2\6\2\0\2\6\3\0\10\6"+
    "\2\0\4\6\2\121\1\6\3\121\2\0\2\6\12\0"+
    "\1\6\1\121\20\6\1\0\1\121\1\6\6\121\3\6"+
    "\3\121\1\6\4\121\3\6\2\121\1\6\1\121\1\6"+
    "\2\121\3\6\2\121\3\6\3\121\3\6\14\121\4\6"+
    "\5\0\3\6\3\0\1\6\4\0\2\6\1\121\6\6"+
    "\1\0\16\6\12\0\11\6\1\121\6\6\4\0\1\6"+
    "\10\121\1\6\3\121\1\6\27\121\1\6\20\121\3\6"+
    "\1\121\7\0\1\6\3\0\1\6\4\0\7\6\2\0"+
    "\1\6\3\121\5\6\2\121\2\0\2\6\12\0\20\6"+
    "\1\121\3\0\1\6\10\121\1\6\3\121\1\6\27\121"+
    "\1\6\12\121\1\6\5\121\2\6\1\0\1\121\7\0"+
    "\1\6\3\0\1\6\4\0\7\6\2\0\7\6\1\121"+
    "\1\6\2\121\2\0\2\6\12\0\1\6\2\121\15\6"+
    "\4\0\1\6\10\121\1\6\3\121\1\6\51\121\2\0"+
    "\1\121\7\0\1\6\3\0\1\6\4\0\1\121\5\6"+
    "\3\121\1\0\7\6\3\121\2\0\2\6\12\0\12\6"+
    "\6\121\2\6\2\0\1\6\22\121\3\6\30\121\1\6"+
    "\11\121\1\6\1\121\2\6\7\121\3\6\1\0\4\6"+
    "\6\0\1\6\1\0\1\6\10\0\6\6\12\0\2\6"+
    "\2\0\15\6\60\121\1\0\2\121\7\0\4\6\10\121"+
    "\10\0\1\6\12\0\47\6\2\121\1\6\1\121\2\6"+
    "\2\121\1\6\1\121\2\6\1\121\6\6\4\121\1\6"+
    "\7\121\1\6\3\121\1\6\1\121\1\6\1\121\2\6"+
    "\2\121\1\6\4\121\1\0\2\121\6\0\1\6\2\0"+
    "\1\121\2\6\5\121\1\6\1\121\1\6\6\0\2\6"+
    "\12\0\2\6\4\121\40\6\1\121\27\6\2\0\6\6"+
    "\12\0\13\6\1\0\1\6\1\0\1\6\1\0\4\6"+
    "\2\0\10\121\1\6\44\121\4\6\24\0\1\6\2\0"+
    "\5\121\13\0\1\6\44\0\11\6\1\0\71\6\53\121"+
    "\24\0\1\121\12\0\6\6\6\121\4\0\4\121\3\0"+
    "\1\121\3\0\2\121\7\0\3\121\4\0\15\121\14\0"+
    "\1\121\17\0\2\6\46\121\1\6\1\121\5\6\1\121"+
    "\2\6\53\121\1\6\115\121\1\6\4\121\2\6\7\121"+
    "\1\6\1\121\1\6\4\121\2\6\51\121\1\6\4\121"+
    "\2\6\41\121\1\6\4\121\2\6\7\121\1\6\1\121"+
    "\1\6\4\121\2\6\17\121\1\6\71\121\1\6\4\121"+
    "\2\6\103\121\2\6\3\0\40\6\20\121\20\6\126\121"+
    "\2\6\6\121\3\6\u016c\121\2\6\21\121\1\6\32\121"+
    "\5\6\113\121\3\6\13\121\7\6\15\121\1\6\4\121"+
    "\3\0\13\6\22\121\3\0\13\6\22\121\2\0\14\6"+
    "\15\121\1\6\3\121\1\6\2\0\14\6\64\121\40\0"+
    "\3\6\1\121\3\6\2\121\1\0\2\6\12\0\41\6"+
    "\4\0\1\6\12\0\6\6\130\121\10\6\5\121\2\0"+
    "\42\121\1\0\1\121\5\6\106\121\12\6\37\121\1\6"+
    "\14\0\4\6\14\0\12\6\12\0\36\121\2\6\5\121"+
    "\13\6\54\121\4\6\32\121\6\6\12\0\46\6\27\121"+
    "\5\0\4\6\65\121\12\0\1\6\35\0\2\6\13\0"+
    "\6\6\12\0\15\6\1\121\10\6\16\0\102\6\5\0"+
    "\57\121\21\0\7\121\4\6\12\0\21\6\11\0\14\6"+
    "\3\0\36\121\15\0\2\121\12\0\54\121\16\0\14\6"+
    "\44\121\24\0\10\6\12\0\3\6\3\121\12\0\44\121"+
    "\2\6\11\121\107\6\3\0\1\6\25\0\4\121\1\0"+
    "\4\121\3\0\2\121\3\0\6\6\300\121\72\0\1\6"+
    "\5\0\26\121\2\6\6\121\2\6\46\121\2\6\6\121"+
    "\2\6\10\121\1\6\1\121\1\6\1\121\1\6\1\121"+
    "\1\6\37\121\2\6\65\121\1\6\7\121\1\6\1\121"+
    "\3\6\3\121\1\6\7\121\3\6\4\121\2\6\6\121"+
    "\4\6\15\121\5\6\3\121\1\6\7\121\16\6\5\0"+
    "\30\6\2\4\5\0\20\6\2\121\23\6\1\121\13\6"+
    "\5\0\1\6\12\0\1\6\1\121\15\6\1\121\20\6"+
    "\15\121\3\6\40\121\20\6\15\0\4\6\1\0\3\6"+
    "\14\0\21\6\1\121\4\6\1\121\2\6\12\121\1\6"+
    "\1\121\3\6\5\121\6\6\1\121\1\6\1\121\1\6"+
    "\1\121\1\6\4\121\1\6\13\121\2\6\4\121\5\6"+
    "\5\121\4\6\1\121\21\6\51\121\u0177\6\57\121\1\6"+
    "\57\121\1\6\205\121\6\6\4\121\3\0\2\121\14\6"+
    "\46\121\1\6\1\121\5\6\1\121\2\6\70\121\7\6"+
    "\1\121\17\6\1\0\27\121\11\6\7\121\1\6\7\121"+
    "\1\6\7\121\1\6\7\121\1\6\7\121\1\6\7\121"+
    "\1\6\7\121\1\6\7\121\1\6\40\0\57\6\1\121"+
    "\325\6\3\121\31\6\11\121\6\0\1\6\5\121\2\6"+
    "\5\121\4\6\126\121\2\6\2\0\2\6\3\121\1\6"+
    "\132\121\1\6\4\121\5\6\52\121\2\6\136\121\21\6"+
    "\33\121\65\6\306\121\112\6\353\121\25\6\215\121\103\6"+
    "\56\121\2\6\15\121\3\6\20\121\12\0\2\121\24\6"+
    "\57\121\1\0\4\6\12\0\1\6\37\121\2\0\120\121"+
    "\2\0\45\6\11\121\2\6\147\121\2\6\44\121\1\6"+
    "\10\121\77\6\13\121\1\0\3\121\1\0\4\121\1\0"+
    "\27\121\5\0\20\6\1\121\7\6\64\121\14\6\2\0"+
    "\62\121\22\0\12\6\12\0\6\6\22\0\6\121\3\6"+
    "\1\121\1\6\1\121\2\6\12\0\34\121\10\0\2\6"+
    "\27\121\15\0\14\6\35\121\3\6\4\0\57\121\16\0"+
    "\16\6\1\121\12\0\6\6\5\121\1\0\12\121\12\0"+
    "\5\121\1\6\51\121\16\0\11\6\3\121\1\0\10\121"+
    "\2\0\2\6\12\0\6\6\27\121\3\6\1\121\3\0"+
    "\62\121\1\0\1\121\3\0\2\121\2\0\5\121\2\0"+
    "\1\121\1\0\1\121\30\6\3\121\2\6\13\121\5\0"+
    "\2\6\3\121\2\0\12\6\6\121\2\6\6\121\2\6"+
    "\6\121\11\6\7\121\1\6\7\121\1\6\53\121\1\6"+
    "\12\121\12\6\163\121\10\0\1\6\2\0\2\6\12\0"+
    "\6\6\244\121\14\6\27\121\4\6\61\121\4\6\u0100\122"+
    "\156\121\2\6\152\121\46\6\7\121\14\6\5\121\5\6"+
    "\1\121\1\0\12\121\1\6\15\121\1\6\5\121\1\6"+
    "\1\121\1\6\2\121\1\6\2\121\1\6\154\121\41\6"+
    "\153\121\22\6\100\121\2\6\66\121\50\6\15\121\3\6"+
    "\20\0\20\6\20\0\3\6\2\121\30\6\3\121\31\6"+
    "\1\121\6\6\5\121\1\6\207\121\2\6\1\0\4\6"+
    "\1\121\13\6\12\0\7\6\32\121\4\6\1\121\1\6"+
    "\32\121\13\6\131\121\3\6\6\121\2\6\6\121\2\6"+
    "\6\121\2\6\3\121\3\6\2\121\3\6\2\121\22\6"+
    "\3\0\4\6\14\121\1\6\32\121\1\6\23\121\1\6"+
    "\2\121\1\6\17\121\2\6\16\121\42\6\173\121\105\6"+
    "\65\121\210\6\1\0\202\6\35\121\3\6\61\121\17\6"+
    "\1\0\37\6\40\121\15\6\36\121\5\6\46\121\5\0"+
    "\5\6\36\121\2\6\44\121\4\6\10\121\1\6\5\121"+
    "\52\6\236\121\2\6\12\0\6\6\44\121\4\6\44\121"+
    "\4\6\50\121\10\6\64\121\234\6\67\121\11\6\26\121"+
    "\12\6\10\121\230\6\6\121\2\6\1\121\1\6\54\121"+
    "\1\6\2\121\3\6\1\121\2\6\27\121\12\6\27\121"+
    "\11\6\37\121\101\6\23\121\1\6\2\121\12\6\26\121"+
    "\12\6\32\121\106\6\70\121\6\6\2\121\100\6\1\121"+
    "\3\0\1\6\2\0\5\6\4\0\4\121\1\6\3\121"+
    "\1\6\33\121\4\6\3\0\4\6\1\0\40\6\35\121"+
    "\3\6\35\121\43\6\10\121\1\6\34\121\2\0\31\6"+
    "\66\121\12\6\26\121\12\6\23\121\15\6\22\121\156\6"+
    "\111\121\67\6\63\121\15\6\63\121\15\6\3\0\65\121"+
    "\17\0\37\6\12\0\17\6\4\0\55\121\13\0\2\6"+
    "\1\0\22\6\31\121\7\6\12\0\6\6\3\0\44\121"+
    "\16\0\1\6\12\0\20\6\43\121\1\0\2\6\1\121"+
    "\11\6\3\0\60\121\16\0\4\121\5\6\3\0\3\6"+
    "\12\0\1\121\1\6\1\121\43\6\22\121\1\6\31\121"+
    "\14\0\6\6\1\0\101\6\7\121\1\6\1\121\1\6"+
    "\4\121\1\6\17\121\1\6\12\121\7\6\57\121\14\0"+
    "\5\6\12\0\6\6\4\0\1\6\10\121\2\6\2\121"+
    "\2\6\26\121\1\6\7\121\1\6\2\121\1\6\5\121"+
    "\2\6\1\0\1\121\7\0\2\6\2\0\2\6\3\0"+
    "\2\6\1\121\6\6\1\0\5\6\5\121\2\0\2\6"+
    "\7\0\3\6\5\0\213\6\65\121\22\0\4\121\5\6"+
    "\12\0\46\6\60\121\24\0\2\121\1\6\1\121\10\6"+
    "\12\0\246\6\57\121\7\0\2\6\11\0\27\6\4\121"+
    "\2\0\42\6\60\121\21\0\3\6\1\121\13\6\12\0"+
    "\46\6\53\121\15\0\10\6\12\0\66\6\32\121\3\6"+
    "\17\0\4\6\12\0\u0166\6\100\121\12\0\25\6\2\121"+
    "\12\0\50\121\7\0\1\121\4\0\10\6\1\0\10\6"+
    "\1\121\13\0\50\121\2\6\4\121\20\0\46\6\71\121"+
    "\7\6\11\121\1\6\45\121\10\0\1\6\10\0\1\121"+
    "\17\6\12\0\30\6\36\121\2\6\26\0\1\6\16\0"+
    "\111\6\7\121\1\6\2\121\1\6\46\121\6\0\3\6"+
    "\1\0\1\6\2\0\1\6\7\0\1\121\1\0\10\6"+
    "\12\0\246\6\232\121\146\6\157\121\21\6\304\121\274\6"+
    "\57\121\321\6\107\121\271\6\71\121\7\6\37\121\1\6"+
    "\12\0\146\6\36\121\2\6\5\0\13\6\60\121\7\0"+
    "\11\6\4\121\14\6\12\0\11\6\25\121\5\6\23\121"+
    "\160\6\105\121\13\6\1\121\56\0\20\6\4\0\15\121"+
    "\100\6\2\121\36\6\355\121\23\6\363\121\15\6\37\121"+
    "\121\6\u018c\121\4\6\153\121\5\6\15\121\3\6\11\121"+
    "\7\6\12\121\3\6\2\0\1\6\4\0\301\6\5\0"+
    "\3\6\26\0\2\6\7\0\36\6\4\0\224\6\3\0"+
    "\273\6\125\121\1\6\107\121\1\6\2\121\2\6\1\121"+
    "\2\6\2\121\2\6\4\121\1\6\14\121\1\6\1\121"+
    "\1\6\7\121\1\6\101\121\1\6\4\121\2\6\10\121"+
    "\1\6\7\121\1\6\34\121\1\6\4\121\1\6\5\121"+
    "\1\6\1\121\3\6\7\121\1\6\u0154\121\2\6\31\121"+
    "\1\6\31\121\1\6\37\121\1\6\31\121\1\6\37\121"+
    "\1\6\31\121\1\6\37\121\1\6\31\121\1\6\37\121"+
    "\1\6\31\121\1\6\10\121\2\6\151\0\4\6\62\0"+
    "\10\6\1\0\16\6\1\0\26\6\5\0\1\6\17\0"+
    "\120\6\7\0\1\6\21\0\2\6\7\0\1\6\2\0"+
    "\1\6\5\0\325\6\305\121\13\6\7\0\51\6\104\121"+
    "\7\0\5\6\12\0\246\6\4\121\1\6\33\121\1\6"+
    "\2\121\1\6\1\121\2\6\1\121\1\6\12\121\1\6"+
    "\4\121\1\6\1\121\1\6\1\121\6\6\1\121\4\6"+
    "\1\121\1\6\1\121\1\6\1\121\1\6\3\121\1\6"+
    "\2\121\1\6\1\121\2\6\1\121\1\6\1\121\1\6"+
    "\1\121\1\6\1\121\1\6\1\121\1\6\2\121\1\6"+
    "\1\121\2\6\4\121\1\6\7\121\1\6\4\121\1\6"+
    "\4\121\1\6\1\121\1\6\12\121\1\6\21\121\5\6"+
    "\3\121\1\6\5\121\1\6\21\121\104\6\327\121\51\6"+
    "\65\121\13\6\336\121\2\6\u0182\121\16\6\u0131\121\37\6"+
    "\36\121\343\6\1\0\36\6\140\0\200\6\360\0\20\6";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[27904];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\23\0\4\1\1\2\3\3\1\4\2\5\1\6\3\4"+
    "\1\7\1\10\1\3\1\11\1\4\1\10\3\4\1\3"+
    "\1\12\1\13\1\14\1\4\2\14\1\15\1\4\2\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\15\1\30\1\31\1\15\1\32\1\33\1\34"+
    "\1\35\1\36\3\3\1\37\1\40\1\4\1\41\1\42"+
    "\1\43\2\44\1\45\1\3\1\15\1\46\2\47\1\50"+
    "\1\15\1\51\1\52\1\15\1\53\1\54\3\15\1\3"+
    "\2\43\1\3\2\47\1\3\1\55\1\56\2\57\1\60"+
    "\1\61\1\62\1\63\1\64\1\3\1\65\3\0\1\66"+
    "\1\67\1\0\1\10\3\0\17\10\1\0\1\70\1\0"+
    "\1\71\1\72\2\10\2\0\1\73\1\4\5\0\1\74"+
    "\1\75\2\0\1\76\2\77\1\100\1\76\1\101\1\102"+
    "\1\76\1\103\1\104\1\105\1\106\1\107\1\76\1\110"+
    "\1\111\1\112\1\76\1\113\1\76\2\0\1\114\1\0"+
    "\2\115\10\0\1\116\1\117\2\120\1\116\1\121\1\122"+
    "\1\123\1\124\1\125\2\116\3\0\1\126\1\127\1\130"+
    "\1\76\1\0\1\131\1\132\6\0\1\133\1\60\1\61"+
    "\1\63\1\0\1\134\2\65\3\0\37\10\2\135\2\136"+
    "\1\10\2\137\1\10\12\0\1\77\4\0\1\140\2\0"+
    "\1\141\1\142\5\0\1\120\2\0\1\143\1\0\1\144"+
    "\1\145\3\0\2\146\1\61\1\63\4\0\11\10\1\147"+
    "\12\10\1\150\1\10\1\0\20\10\10\0\1\151\1\0"+
    "\1\152\1\0\1\153\5\0\1\154\3\0\1\61\1\63"+
    "\2\0\1\155\1\156\5\10\1\157\3\10\1\160\10\10"+
    "\1\156\7\10\1\161\1\0\2\10\1\162\15\10\22\0"+
    "\1\61\1\63\1\0\1\163\12\10\1\164\4\10\1\165"+
    "\7\10\1\0\11\10\1\0\1\10\2\166\1\167\3\10"+
    "\11\0\1\170\2\0\1\171\2\0\2\172\3\0\1\61"+
    "\1\63\1\0\3\10\1\173\2\10\1\0\1\174\16\10"+
    "\1\0\2\10\1\175\5\10\1\176\1\0\1\10\2\166"+
    "\4\177\3\10\2\0\1\200\12\0\2\201\1\0\2\10"+
    "\2\202\1\10\1\203\2\10\2\204\10\10\1\150\1\205"+
    "\1\0\1\10\1\206\3\10\2\207\1\10\1\176\4\0"+
    "\1\210\4\177\2\10\1\211\1\212\7\0\1\213\1\214"+
    "\4\0\1\215\1\10\2\202\2\216\1\217\1\203\1\0"+
    "\1\10\1\0\1\220\2\204\1\221\1\222\2\10\1\0"+
    "\3\10\2\223\1\10\1\166\4\10\2\207\1\224\1\10"+
    "\1\0\1\176\1\0\1\10\1\0\2\225\1\10\1\226"+
    "\1\227\5\0\2\230\2\0\1\10\2\216\1\0\1\10"+
    "\2\0\2\221\1\10\1\0\2\231\1\232\1\10\1\0"+
    "\3\10\2\233\3\10\2\166\2\224\1\10\2\176\2\210"+
    "\2\225\1\10\2\0\1\234\5\0\1\235\1\203\2\236"+
    "\4\0\1\236\1\221\1\0\2\10\2\0\2\231\1\237"+
    "\1\232\1\0\1\240\1\10\2\241\2\233\1\10\2\242"+
    "\1\243\4\244\1\224\1\0\1\10\1\176\2\0\1\10"+
    "\1\245\3\0\2\246\5\0\2\10\2\0\2\237\1\0"+
    "\1\240\2\247\2\241\1\250\1\251\1\10\2\242\1\252"+
    "\4\244\1\10\2\0\1\210\2\253\3\0\2\254\2\0"+
    "\1\236\1\0\2\10\2\0\1\237\1\0\1\232\2\250"+
    "\1\251\1\10\2\252\2\251\1\10\2\176\1\0\2\253"+
    "\1\255\1\0\1\256\1\257\2\260\3\236\1\0\1\10"+
    "\1\222\1\0\1\222\1\250\1\0\1\10\1\252\1\0"+
    "\1\251\1\10\1\176\1\210\1\255\1\253\1\255\3\0"+
    "\2\261\2\10\2\253\1\255\5\0\2\10\1\0\1\253"+
    "\2\255\1\0\1\262\3\236\1\10\1\263\1\0\1\255"+
    "\1\10\4\263\1\10\1\264\1\263\1\264\1\263\1\264"+
    "\1\10\1\264\1\263\2\264\1\263\3\264\1\263\1\265"+
    "\1\264\1\0\2\264\1\265";

  private static int [] zzUnpackAction() {
    int [] result = new int[919];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\123\0\246\0\371\0\u014c\0\u019f\0\u01f2\0\u0245"+
    "\0\u0298\0\u02eb\0\u033e\0\u0391\0\u03e4\0\u0437\0\u048a\0\u04dd"+
    "\0\u0530\0\u0583\0\u05d6\0\u0629\0\u067c\0\u06cf\0\u0722\0\u0775"+
    "\0\u07c8\0\u081b\0\u067c\0\u086e\0\u067c\0\u08c1\0\u0914\0\u0967"+
    "\0\u09ba\0\u0a0d\0\u0a60\0\u0ab3\0\u0b06\0\u0b59\0\u0bac\0\u0bff"+
    "\0\u0c52\0\u067c\0\u0ca5\0\u0cf8\0\u0d4b\0\u067c\0\u067c\0\u0d9e"+
    "\0\u0df1\0\u0cf8\0\u067c\0\u0e44\0\u0e97\0\u0eea\0\u067c\0\u067c"+
    "\0\u067c\0\u067c\0\u067c\0\u067c\0\u067c\0\u067c\0\u0f3d\0\u0f90"+
    "\0\u067c\0\u0fe3\0\u1036\0\u067c\0\u1089\0\u10dc\0\u067c\0\u112f"+
    "\0\u1182\0\u11d5\0\u1228\0\u067c\0\u067c\0\u127b\0\u067c\0\u12ce"+
    "\0\u1321\0\u067c\0\u1374\0\u067c\0\u13c7\0\u141a\0\u141a\0\u141a"+
    "\0\u146d\0\u067c\0\u14c0\0\u1513\0\u0fe3\0\u1566\0\u067c\0\u067c"+
    "\0\u15b9\0\u160c\0\u165f\0\u16b2\0\u067c\0\u1705\0\u1758\0\u067c"+
    "\0\u17ab\0\u17fe\0\u067c\0\u1851\0\u067c\0\u17ab\0\u18a4\0\u18f7"+
    "\0\u067c\0\u194a\0\u067c\0\u199d\0\u19f0\0\u1a43\0\u1a96\0\u07c8"+
    "\0\u067c\0\u067c\0\u081b\0\u1ae9\0\u1b3c\0\u1b8f\0\u1be2\0\u1c35"+
    "\0\u1c88\0\u1cdb\0\u1d2e\0\u1d81\0\u1dd4\0\u1e27\0\u1e7a\0\u1ecd"+
    "\0\u1f20\0\u1f73\0\u1fc6\0\u2019\0\u206c\0\u20bf\0\u2112\0\u067c"+
    "\0\u2165\0\u067c\0\u21b8\0\u220b\0\u225e\0\u0c52\0\u0cf8\0\u067c"+
    "\0\u22b1\0\u2304\0\u0d9e\0\u2357\0\u0e97\0\u23aa\0\u1089\0\u067c"+
    "\0\u23fd\0\u2450\0\u067c\0\u24a3\0\u24f6\0\u067c\0\u2549\0\u067c"+
    "\0\u067c\0\u259c\0\u067c\0\u067c\0\u067c\0\u067c\0\u067c\0\u25ef"+
    "\0\u067c\0\u067c\0\u067c\0\u2642\0\u067c\0\u2695\0\u1089\0\u26e8"+
    "\0\u273b\0\u10dc\0\u067c\0\u278e\0\u1182\0\u11d5\0\u1228\0\u27e1"+
    "\0\u2834\0\u2887\0\u28da\0\u292d\0\u067c\0\u067c\0\u2980\0\u29d3"+
    "\0\u2a26\0\u067c\0\u067c\0\u067c\0\u067c\0\u067c\0\u2a79\0\u2acc"+
    "\0\u141a\0\u0fe3\0\u2b1f\0\u067c\0\u067c\0\u067c\0\u2b72\0\u2bc5"+
    "\0\u067c\0\u067c\0\u16b2\0\u2c18\0\u2c6b\0\u2cbe\0\u2d11\0\u17fe"+
    "\0\u2d64\0\u2db7\0\u2e0a\0\u2e5d\0\u2eb0\0\u067c\0\u067c\0\u2f03"+
    "\0\u2f56\0\u2fa9\0\u2ffc\0\u304f\0\u30a2\0\u30f5\0\u3148\0\u319b"+
    "\0\u31ee\0\u3241\0\u3294\0\u32e7\0\u333a\0\u338d\0\u33e0\0\u3433"+
    "\0\u3486\0\u34d9\0\u352c\0\u357f\0\u35d2\0\u3625\0\u3678\0\u36cb"+
    "\0\u371e\0\u3771\0\u37c4\0\u3817\0\u386a\0\u38bd\0\u3910\0\u3963"+
    "\0\u39b6\0\u3a09\0\u067c\0\u3a5c\0\u3aaf\0\u3b02\0\u3b55\0\u3ba8"+
    "\0\u3bfb\0\u3c4e\0\u3ca1\0\u3cf4\0\u2549\0\u25ef\0\u3d47\0\u3d9a"+
    "\0\u3ded\0\u3e40\0\u3e93\0\u3ee6\0\u067c\0\u3f39\0\u3f8c\0\u3fdf"+
    "\0\u4032\0\u067c\0\u4085\0\u40d8\0\u067c\0\u067c\0\u412b\0\u417e"+
    "\0\u41d1\0\u4224\0\u4277\0\u067c\0\u42ca\0\u431d\0\u067c\0\u4370"+
    "\0\u067c\0\u067c\0\u43c3\0\u4416\0\u4469\0\u067c\0\u44bc\0\u450f"+
    "\0\u4562\0\u45b5\0\u4608\0\u465b\0\u46ae\0\u4701\0\u4754\0\u47a7"+
    "\0\u47fa\0\u484d\0\u48a0\0\u48f3\0\u4946\0\u4999\0\u49ec\0\u4a3f"+
    "\0\u4a92\0\u4ae5\0\u4b38\0\u4b8b\0\u4bde\0\u4c31\0\u4c84\0\u4cd7"+
    "\0\u4d2a\0\u4d7d\0\u4dd0\0\u4e23\0\u4e76\0\u4ec9\0\u4f1c\0\u4f6f"+
    "\0\u4fc2\0\u5015\0\u5068\0\u50bb\0\u510e\0\u5161\0\u51b4\0\u5207"+
    "\0\u525a\0\u52ad\0\u5300\0\u5353\0\u53a6\0\u53f9\0\u544c\0\u549f"+
    "\0\u54f2\0\u5545\0\u5598\0\u55eb\0\u067c\0\u563e\0\u067c\0\u5691"+
    "\0\u067c\0\u56e4\0\u5737\0\u578a\0\u57dd\0\u5830\0\u067c\0\u5883"+
    "\0\u58d6\0\u5929\0\u597c\0\u59cf\0\u5a22\0\u5a75\0\u067c\0\u067c"+
    "\0\u5ac8\0\u5b1b\0\u5b6e\0\u5bc1\0\u5c14\0\u1ae9\0\u5c67\0\u5cba"+
    "\0\u5d0d\0\u1ae9\0\u5d60\0\u5db3\0\u5e06\0\u5e59\0\u5eac\0\u5eff"+
    "\0\u5f52\0\u5fa5\0\u1ae9\0\u5ff8\0\u604b\0\u609e\0\u60f1\0\u6144"+
    "\0\u6197\0\u61ea\0\u1ae9\0\u623d\0\u6290\0\u62e3\0\u1ae9\0\u6336"+
    "\0\u6389\0\u63dc\0\u642f\0\u6482\0\u64d5\0\u6528\0\u657b\0\u65ce"+
    "\0\u6621\0\u6674\0\u66c7\0\u671a\0\u676d\0\u67c0\0\u6813\0\u6866"+
    "\0\u68b9\0\u690c\0\u695f\0\u69b2\0\u6a05\0\u6a58\0\u6aab\0\u6afe"+
    "\0\u6b51\0\u6ba4\0\u6bf7\0\u6c4a\0\u6c9d\0\u6cf0\0\u6d43\0\u6d96"+
    "\0\u6de9\0\u067c\0\u6e3c\0\u6e8f\0\u6ee2\0\u6f35\0\u6f88\0\u6fdb"+
    "\0\u702e\0\u7081\0\u70d4\0\u7127\0\u1ae9\0\u717a\0\u71cd\0\u7220"+
    "\0\u7273\0\u1ae9\0\u72c6\0\u7319\0\u736c\0\u73bf\0\u7412\0\u7465"+
    "\0\u74b8\0\u750b\0\u755e\0\u75b1\0\u7604\0\u7657\0\u76aa\0\u76fd"+
    "\0\u7750\0\u77a3\0\u77f6\0\u7849\0\u789c\0\u78ef\0\u7942\0\u1ae9"+
    "\0\u7995\0\u79e8\0\u7a3b\0\u7a8e\0\u7ae1\0\u7b34\0\u7b87\0\u7bda"+
    "\0\u7c2d\0\u7c80\0\u7cd3\0\u7d26\0\u6a58\0\u7d79\0\u7dcc\0\u6b51"+
    "\0\u7e1f\0\u7e72\0\u067c\0\u7ec5\0\u7f18\0\u7f6b\0\u7fbe\0\u067c"+
    "\0\u067c\0\u8011\0\u8064\0\u80b7\0\u810a\0\u1ae9\0\u815d\0\u81b0"+
    "\0\u8203\0\u1ae9\0\u8256\0\u82a9\0\u82fc\0\u834f\0\u83a2\0\u83f5"+
    "\0\u8448\0\u849b\0\u84ee\0\u8541\0\u8594\0\u85e7\0\u863a\0\u868d"+
    "\0\u86e0\0\u8733\0\u8786\0\u1ae9\0\u87d9\0\u882c\0\u887f\0\u88d2"+
    "\0\u8925\0\u8978\0\u89cb\0\u8a1e\0\u8a71\0\u8ac4\0\u8b17\0\u8b6a"+
    "\0\u8bbd\0\u8c10\0\u8c63\0\u3aaf\0\u8cb6\0\u8d09\0\u8d5c\0\u8daf"+
    "\0\u8e02\0\u8e55\0\u8ea8\0\u8efb\0\u8f4e\0\u8fa1\0\u8ff4\0\u9047"+
    "\0\u909a\0\u90ed\0\u067c\0\u9140\0\u9193\0\u91e6\0\u9239\0\u928c"+
    "\0\u92df\0\u9332\0\u9385\0\u93d8\0\u942b\0\u947e\0\u94d1\0\u9524"+
    "\0\u9577\0\u95ca\0\u961d\0\u9670\0\u96c3\0\u9716\0\u9769\0\u1ae9"+
    "\0\u1ae9\0\u97bc\0\u980f\0\u1ae9\0\u9862\0\u98b5\0\u9908\0\u995b"+
    "\0\u99ae\0\u9a01\0\u9a54\0\u9aa7\0\u9afa\0\u9b4d\0\u9ba0\0\u9bf3"+
    "\0\u9c46\0\u9c99\0\u9cec\0\u9d3f\0\u9d92\0\u3ba8\0\u067c\0\u067c"+
    "\0\u9de5\0\u9e38\0\u9e8b\0\u9ede\0\u9f31\0\u9f84\0\u9fd7\0\u8fa1"+
    "\0\u8ff4\0\ua02a\0\ua07d\0\ua0d0\0\ua123\0\u1ae9\0\ua176\0\ua1c9"+
    "\0\ua21c\0\ua26f\0\ua2c2\0\u1ae9\0\ua315\0\ua368\0\ua3bb\0\ua40e"+
    "\0\u1ae9\0\ua461\0\ua4b4\0\ua507\0\ua55a\0\ua5ad\0\ua600\0\ua653"+
    "\0\ua6a6\0\ua6f9\0\ua74c\0\ua79f\0\ua7f2\0\ua845\0\ua898\0\ua8eb"+
    "\0\ua93e\0\ua991\0\ua9e4\0\uaa37\0\uaa8a\0\uaadd\0\uab30\0\uab83"+
    "\0\uabd6\0\uac29\0\uac7c\0\uaccf\0\uad22\0\uad75\0\uadc8\0\uae1b"+
    "\0\u067c\0\uae6e\0\uaec1\0\uaf14\0\uaf67\0\uafba\0\u067c\0\ub00d"+
    "\0\ub060\0\ub0b3\0\ub106\0\ub159\0\ub1ac\0\ub1ff\0\ub252\0\ub2a5"+
    "\0\ub2f8\0\ub34b\0\ub39e\0\ub3f1\0\ub444\0\ub497\0\ub4ea\0\ub53d"+
    "\0\ub590\0\ub5e3\0\ub636\0\ub689\0\ub6dc\0\ub72f\0\ub782\0\ub7d5"+
    "\0\ub828\0\ub87b\0\ub8ce\0\ub921\0\ub974\0\ub9c7\0\uba1a\0\uba6d"+
    "\0\ubac0\0\ubb13\0\ubb66\0\ubbb9\0\ubc0c\0\ubc5f\0\ubcb2\0\ubd05"+
    "\0\u067c\0\ubd58\0\ubdab\0\ubdfe\0\ube51\0\ubea4\0\u1ae9\0\ubef7"+
    "\0\ub252\0\ubf4a\0\ubf9d\0\ubff0\0\uc043\0\uc096\0\ub2f8\0\uc0e9"+
    "\0\uc13c\0\uc18f\0\uc1e2\0\uc235\0\uc288\0\uc2db\0\uc32e\0\uc381"+
    "\0\uc3d4\0\uc427\0\uc47a\0\uc4cd\0\uc520\0\uc573\0\uc5c6\0\uc619"+
    "\0\uc66c\0\uc6bf\0\uc712\0\u1ae9\0\uc765\0\uc7b8\0\uc80b\0\uc85e"+
    "\0\uc8b1\0\uc904\0\uc957\0\uc9aa\0\uc9fd\0\uca50\0\ucaa3\0\u067c"+
    "\0\ucaf6\0\ucb49\0\ucb9c\0\u067c\0\ucbef\0\ucc42\0\ucc95\0\ucce8"+
    "\0\ucd3b\0\ucd8e\0\ucde1\0\uce34\0\uce87\0\uceda\0\ucf2d\0\ucf80"+
    "\0\ucfd3\0\ud026\0\ud079\0\ud0cc\0\ud11f\0\ud172\0\ud1c5\0\ud218"+
    "\0\ud26b\0\ud2be\0\ud311\0\ud364\0\ud3b7\0\ud40a\0\ud45d\0\ud4b0"+
    "\0\ud503\0\ud556\0\ud5a9\0\ud5fc\0\ud64f\0\ud6a2\0\ud6f5\0\ud748"+
    "\0\ud79b\0\u067c\0\ud7ee\0\ud841\0\ud894\0\ucd3b\0\ud8e7\0\ud93a"+
    "\0\ud98d\0\ud9e0\0\uda33\0\uda86\0\udad9\0\udb2c\0\udb7f\0\udbd2"+
    "\0\udc25\0\udc78\0\udccb\0\udd1e\0\udd71\0\uddc4\0\ude17\0\ude6a"+
    "\0\udebd\0\udf10\0\udf63\0\udfb6\0\ue009\0\ue05c\0\u067c\0\u067c"+
    "\0\u067c\0\ue0af\0\ud894\0\ud8e7\0\ue102\0\ue155\0\ue1a8\0\u1ae9"+
    "\0\ue1fb\0\u067c\0\ue24e\0\ue2a1\0\ue2f4\0\ue347\0\ue39a\0\ue3ed"+
    "\0\ue440\0\ue493\0\udf10\0\ue4e6\0\ue539\0\ue58c\0\ue5df\0\ue632"+
    "\0\ue685\0\u1ae9\0\u067c\0\ue6d8\0\ue72b\0\ue77e\0\ue7d1\0\ue824"+
    "\0\ue877\0\ue8ca\0\ue91d\0\ue970\0\ue9c3\0\uea16\0\uea69\0\ueabc"+
    "\0\ueb0f\0\u067c\0\ueb62\0\uebb5\0\u067c\0\ue970\0\ue9c3\0\uec08"+
    "\0\uec5b\0\uecae\0\ued01\0\udfb6\0\ued54\0\ueda7\0\uedfa\0\uee4d"+
    "\0\ueea0\0\ueef3\0\uef46\0\uef99\0\uefec\0\uf03f\0\uf092\0\uf0e5"+
    "\0\uf138\0\uf18b\0\uf1de\0\uf231\0\uf284\0\uf2d7\0\uf32a\0\uf37d"+
    "\0\uf3d0\0\uf423\0\uf476\0\uf4c9\0\uf51c\0\uf56f\0\uf5c2";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[919];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\3\24\2\25\1\26\4\24\1\27\105\24\1\25\1\24"+
    "\1\0\17\30\1\31\4\30\1\32\76\30\2\33\1\34"+
    "\2\35\1\36\3\33\1\37\7\33\1\40\21\33\13\37"+
    "\4\33\32\37\4\33\1\35\1\37\1\0\1\33\2\41"+
    "\3\42\3\33\1\43\1\44\11\33\1\45\13\33\1\46"+
    "\2\33\13\43\4\33\32\43\4\33\1\42\1\43\1\0"+
    "\1\33\2\47\3\42\3\33\1\43\1\50\11\33\1\45"+
    "\13\33\1\46\2\33\13\43\4\33\32\43\4\33\1\42"+
    "\1\43\1\0\1\33\2\51\2\52\1\53\16\33\1\54"+
    "\12\33\1\55\56\33\1\56\1\33\1\52\1\33\1\0"+
    "\1\57\2\60\2\52\1\53\4\57\1\61\11\57\1\62"+
    "\12\57\1\55\56\57\1\56\1\57\1\52\2\57\1\63"+
    "\2\64\2\65\1\66\1\63\1\67\1\70\1\71\3\63"+
    "\1\72\1\73\1\74\1\75\2\63\1\76\1\77\12\63"+
    "\1\100\2\63\1\101\13\63\1\102\1\103\1\63\1\104"+
    "\32\63\1\105\1\106\1\63\1\107\1\65\1\63\1\0"+
    "\10\110\1\111\3\110\1\112\7\110\1\113\67\110\1\114"+
    "\1\110\1\115\4\110\1\33\5\116\3\33\1\43\7\33"+
    "\1\117\17\33\1\120\1\33\13\43\4\33\32\43\4\33"+
    "\1\116\1\43\1\0\3\121\2\122\1\123\2\121\1\124"+
    "\46\121\1\125\40\121\1\122\2\121\1\63\2\126\1\127"+
    "\1\130\1\131\2\63\1\132\2\63\1\133\6\63\1\134"+
    "\33\63\1\135\1\136\1\137\1\140\32\63\1\141\1\142"+
    "\1\63\1\143\1\130\1\63\1\0\3\144\2\145\1\146"+
    "\4\144\1\147\105\144\1\145\1\144\1\0\1\33\2\41"+
    "\2\150\1\151\13\33\1\152\74\33\1\153\1\33\1\150"+
    "\1\33\1\0\1\33\5\154\112\33\1\154\1\33\1\0"+
    "\5\155\1\156\3\155\1\157\31\155\13\157\4\155\32\157"+
    "\5\155\1\157\1\155\1\33\5\116\17\33\11\160\5\33"+
    "\4\160\14\33\6\160\25\33\1\161\1\33\1\116\1\33"+
    "\1\0\1\33\2\41\2\122\1\123\17\33\11\162\5\33"+
    "\4\162\14\33\6\162\25\33\1\163\1\33\1\122\1\33"+
    "\1\0\3\33\2\150\1\151\17\33\11\164\5\33\4\164"+
    "\14\33\6\164\27\33\1\150\1\33\1\0\3\24\2\25"+
    "\1\26\112\24\1\25\1\24\127\0\1\25\117\0\3\24"+
    "\2\25\1\26\4\24\1\165\105\24\1\25\1\24\1\0"+
    "\17\30\1\166\4\30\1\167\115\30\1\170\4\30\1\171"+
    "\115\30\1\172\4\30\1\173\76\30\2\0\1\34\16\0"+
    "\1\40\104\0\1\35\117\0\2\37\7\0\1\37\13\0"+
    "\11\37\5\0\13\37\4\0\32\37\4\0\2\37\3\0"+
    "\1\40\121\0\2\41\123\0\3\42\112\0\1\42\2\0"+
    "\2\43\7\0\1\43\13\0\11\43\5\0\13\43\4\0"+
    "\32\43\4\0\2\43\12\0\1\174\14\0\1\175\4\0"+
    "\1\176\1\177\6\0\13\174\4\0\1\174\1\200\1\201"+
    "\1\202\1\203\1\204\1\205\2\174\1\206\2\174\1\207"+
    "\1\174\1\210\1\174\1\211\1\174\1\212\1\213\1\214"+
    "\1\174\1\215\1\174\1\216\1\174\1\217\4\0\1\174"+
    "\20\0\1\220\4\0\1\221\77\0\2\46\121\0\2\47"+
    "\7\0\1\222\121\0\1\174\1\223\13\0\1\175\4\0"+
    "\1\176\1\177\6\0\13\174\4\0\1\174\1\200\1\201"+
    "\1\202\1\203\1\204\1\205\2\174\1\206\2\174\1\207"+
    "\1\174\1\210\1\174\1\211\1\174\1\224\1\213\1\214"+
    "\1\174\1\215\1\225\1\216\1\174\1\217\4\0\1\174"+
    "\2\0\2\226\21\0\1\227\12\0\1\55\56\0\1\56"+
    "\7\0\1\52\136\0\1\230\4\0\1\231\135\0\1\232"+
    "\63\0\1\57\2\233\3\0\4\57\1\61\11\57\1\62"+
    "\12\57\1\55\56\57\1\56\1\57\1\0\2\57\73\0"+
    "\1\234\30\0\2\64\3\235\1\0\1\67\1\70\1\71"+
    "\3\0\1\72\1\73\1\74\1\75\2\0\1\76\1\77"+
    "\15\0\1\101\13\0\1\102\1\236\1\0\1\104\32\0"+
    "\1\237\1\106\1\0\1\107\1\235\3\0\5\235\1\0"+
    "\1\67\1\70\1\71\3\0\1\72\1\73\1\74\1\75"+
    "\2\0\1\76\1\77\15\0\1\101\13\0\1\102\1\236"+
    "\1\0\1\104\32\0\1\237\1\106\1\0\1\107\1\235"+
    "\3\0\2\235\1\65\2\235\1\0\1\67\1\70\1\71"+
    "\3\0\1\72\1\73\1\74\1\75\2\0\1\76\1\77"+
    "\15\0\1\101\13\0\1\102\1\236\1\0\1\104\32\0"+
    "\1\237\1\106\1\0\1\107\1\235\21\0\1\240\4\0"+
    "\1\231\135\0\1\241\121\0\1\242\64\0\3\243\3\0"+
    "\17\243\4\244\3\245\10\243\1\246\4\243\1\247\1\250"+
    "\1\251\1\252\1\253\6\243\1\254\1\243\1\255\1\243"+
    "\1\256\7\243\1\257\1\243\1\260\1\261\1\262\1\263"+
    "\1\264\1\243\1\265\1\266\6\243\1\0\1\243\2\0"+
    "\2\267\6\0\1\270\13\0\11\271\5\0\13\270\4\0"+
    "\32\270\5\0\1\270\2\0\2\272\2\273\1\274\112\0"+
    "\1\273\2\0\10\110\1\275\3\110\1\276\7\110\1\277"+
    "\67\110\1\0\1\110\1\0\4\110\3\275\3\0\2\275"+
    "\1\110\46\275\1\300\40\275\1\0\2\275\3\301\3\0"+
    "\6\301\1\0\42\301\1\302\40\301\1\0\2\301\17\110"+
    "\1\303\4\110\1\304\76\110\1\0\5\116\112\0\1\116"+
    "\3\0\5\120\112\0\1\120\2\0\3\121\3\0\2\121"+
    "\1\0\46\121\1\0\40\121\1\0\2\121\3\0\1\122"+
    "\117\0\3\305\3\0\2\305\1\306\14\305\4\307\3\310"+
    "\20\305\1\311\7\305\1\312\3\305\1\313\7\305\1\314"+
    "\2\305\1\315\1\305\1\316\1\317\2\305\1\320\6\305"+
    "\1\0\1\305\2\0\5\321\50\0\1\322\1\323\40\0"+
    "\1\321\3\0\2\321\1\130\2\321\50\0\1\322\1\323"+
    "\40\0\1\321\15\0\1\324\131\0\1\325\35\0\1\326"+
    "\42\0\3\243\3\0\17\243\4\244\3\245\10\243\1\246"+
    "\4\243\1\247\1\243\1\251\1\252\1\253\6\243\1\254"+
    "\1\243\1\255\1\243\1\256\7\243\1\257\1\243\1\260"+
    "\1\261\1\262\1\263\1\327\1\243\1\265\1\266\6\243"+
    "\1\0\1\243\12\0\1\330\31\0\13\330\4\0\32\330"+
    "\5\0\1\330\116\0\1\331\124\0\1\332\3\0\3\333"+
    "\2\145\1\146\112\333\1\145\1\333\4\0\1\145\117\0"+
    "\3\333\2\145\1\146\61\333\1\334\3\333\1\335\16\333"+
    "\1\336\3\333\1\337\1\333\1\145\1\333\4\0\1\150"+
    "\120\0\2\340\22\0\11\341\66\0\5\154\112\0\1\154"+
    "\2\0\2\157\1\342\6\0\1\157\13\0\11\157\5\0"+
    "\13\157\4\0\32\157\4\0\2\157\26\0\11\343\5\0"+
    "\4\343\14\0\6\343\57\0\11\344\5\0\4\344\14\0"+
    "\6\344\57\0\11\345\5\0\4\345\14\0\6\345\25\0"+
    "\1\346\4\0\3\165\2\347\1\350\112\165\1\347\1\165"+
    "\1\0\17\30\1\166\4\30\1\0\115\30\1\0\4\30"+
    "\1\167\76\30\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\32\174\4\0\2\174\33\0\1\351\154\0"+
    "\1\352\122\0\1\353\36\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\2\174\1\354\15\174\1\355"+
    "\11\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\24\174\1\356\3\174\1\357"+
    "\1\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\1\174\1\360\6\174\1\361"+
    "\3\174\1\362\2\174\1\363\3\174\1\364\1\365\5\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\5\174\1\366\24\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\17\174\1\367\7\174\1\370\2\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\11\174\1\371\12\174\1\372\5\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\7\174\1\373\5\174\1\374\1\375\13\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\11\174\1\376\20\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\17\174\1\377\12\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\1\174\1\u0100"+
    "\22\174\1\u0101\5\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\3\174\1\u0102"+
    "\17\174\1\u0103\1\u0104\5\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\10\174"+
    "\1\u0105\6\174\1\u0106\10\174\1\u0107\1\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\16\174\1\u0108\13\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\1\174"+
    "\1\u0109\30\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\30\174\1\u010a\1\174"+
    "\4\0\2\174\1\0\3\217\2\u010b\1\u010c\112\217\1\u010b"+
    "\1\217\1\0\3\221\2\52\1\53\112\221\1\52\1\221"+
    "\1\0\3\223\3\0\112\223\1\0\2\223\1\174\1\u010d"+
    "\1\u010e\6\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\3\174\1\u0102\17\174\1\u010f\1\u0104\5\174\4\0\2\174"+
    "\1\0\1\174\1\u0110\1\u0111\6\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\22\174\1\u0112\7\174\4\0\2\174"+
    "\1\0\3\231\3\0\112\231\1\0\2\231\45\0\1\u0113"+
    "\155\0\1\u0114\66\0\1\246\4\0\1\u0115\1\250\1\251"+
    "\1\0\1\253\10\0\1\255\13\0\1\u0116\1\0\1\262"+
    "\1\0\1\u0117\1\0\1\265\57\0\1\u0118\143\0\1\u0119"+
    "\5\0\1\u011a\1\0\1\u011b\7\0\1\u011c\41\0\7\245"+
    "\114\0\7\u011d\203\0\1\u011e\33\0\11\u011f\5\0\4\u011f"+
    "\14\0\6\u011f\146\0\1\u0120\33\0\11\u0121\5\0\4\u0121"+
    "\14\0\6\u0121\23\0\1\u0122\33\0\11\u0123\5\0\4\u0123"+
    "\14\0\6\u0123\32\0\2\270\1\u0124\6\0\1\270\13\0"+
    "\11\270\5\0\13\270\4\0\32\270\2\0\1\u0125\1\0"+
    "\2\270\26\0\11\271\70\0\1\u0126\117\0\3\275\3\0"+
    "\112\275\1\0\2\275\14\0\1\110\106\0\3\301\3\0"+
    "\17\301\4\u0127\3\u0128\23\301\1\u0129\26\301\1\u012a\11\301"+
    "\1\0\2\301\17\303\1\u012b\103\303\3\304\3\110\112\304"+
    "\1\110\1\304\26\0\7\310\114\0\7\u012c\114\0\11\u012d"+
    "\5\0\4\u012d\14\0\6\u012d\57\0\11\u012e\5\0\4\u012e"+
    "\14\0\6\u012e\23\0\1\u012f\33\0\11\u0130\5\0\4\u0130"+
    "\14\0\6\u0130\76\0\1\246\4\0\1\u0115\1\0\1\251"+
    "\1\0\1\253\10\0\1\255\13\0\1\u0116\1\0\1\262"+
    "\3\0\1\265\37\0\11\u0121\5\0\4\u0121\14\0\6\u0121"+
    "\23\0\1\u0131\6\0\2\330\7\0\1\330\13\0\11\330"+
    "\5\0\13\330\4\0\32\330\2\0\1\u0132\1\0\2\330"+
    "\1\0\3\333\2\145\1\146\73\333\1\u0133\16\333\1\145"+
    "\1\333\1\0\3\333\2\145\1\146\72\333\1\u0134\17\333"+
    "\1\145\1\333\1\0\3\333\2\145\1\146\104\333\1\u0135"+
    "\5\333\1\145\1\333\1\0\3\337\2\u0136\1\u0137\112\337"+
    "\1\u0136\1\337\26\0\11\341\66\0\2\342\145\0\11\u0138"+
    "\5\0\4\u0138\14\0\6\u0138\57\0\11\u0139\5\0\4\u0139"+
    "\14\0\6\u0139\57\0\11\u013a\5\0\4\u013a\14\0\6\u013a"+
    "\25\0\1\346\7\0\1\347\203\0\1\u013b\131\0\1\u013c"+
    "\122\0\1\u013d\27\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\22\174\1\u013e\7\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\11\174\1\u013f\20\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\6\174"+
    "\1\u0140\23\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\1\174\1\u0141\30\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\22\174\1\u0142\7\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\1\174\1\u0143\30\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\1\174"+
    "\1\u0144\30\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\14\174\1\u0145\15\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\17\174\1\u0146\12\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\20\174\1\u0147\11\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\2\174"+
    "\1\u0148\27\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\6\174\1\u0149\23\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\23\174\1\u014a\6\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\16\174\1\u014b\13\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\14\174"+
    "\1\u014c\1\174\1\u014d\13\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\16\174"+
    "\1\u014e\13\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\20\174\1\u014f\11\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\3\174\1\u0150\5\174\1\u0151\11\174"+
    "\1\u0152\6\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\16\174\1\u0153\13\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\10\0\1\u0154"+
    "\2\0\11\174\5\0\13\174\4\0\1\u0155\22\174\1\u0156"+
    "\6\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\3\174\1\u0157\26\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\2\174\1\u0158\27\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\1\174\1\u0159\30\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\1\174\1\u015a"+
    "\30\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\20\174\1\u015b\11\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\21\174\1\u015c\10\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\13\174\1\u015d\16\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\20\174\1\u015e"+
    "\11\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\11\174\1\u015f\20\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\21\174\1\u0160\10\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\5\174\1\u0161\6\174\1\u0162\15\174\4\0\2\174\4\0"+
    "\1\u010b\117\0\1\174\1\u010d\1\u010e\6\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\32\174\4\0\2\174\2\0"+
    "\2\u010e\120\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\1\174\1\u0163\30\174\4\0\2\174\1\0"+
    "\1\174\1\u0110\1\u0111\6\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\32\174\4\0\2\174\2\0\2\u0111\120\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\23\174\1\u0164\6\174\4\0\2\174\51\0\1\u0165\137\0"+
    "\1\u0166\151\0\1\u0122\56\0\1\u0167\145\0\1\u0168\125\0"+
    "\1\u0169\113\0\1\u016a\11\0\1\u016b\123\0\1\u016c\20\0"+
    "\116\u011e\1\u016d\4\u011e\25\0\11\u016e\5\0\4\u016e\14\0"+
    "\6\u016e\32\0\116\u0120\1\u016f\4\u0120\25\0\11\u0170\5\0"+
    "\4\u0170\14\0\6\u0170\57\0\11\u0171\5\0\4\u0171\14\0"+
    "\6\u0171\33\0\2\u0124\113\0\1\u0125\20\0\1\110\10\0"+
    "\7\u0128\103\0\1\110\10\0\7\301\103\0\1\110\42\0"+
    "\1\u0172\26\0\1\u0173\30\0\1\110\10\0\11\u0174\5\0"+
    "\4\u0174\14\0\6\u0174\32\0\17\303\1\u012b\4\303\1\110"+
    "\76\303\25\0\11\u0175\5\0\4\u0175\14\0\6\u0175\57\0"+
    "\11\u0176\5\0\4\u0176\14\0\6\u0176\57\0\11\u0177\5\0"+
    "\4\u0177\14\0\6\u0177\32\0\3\333\2\145\1\146\62\333"+
    "\1\u0178\27\333\1\145\1\333\1\0\3\333\2\145\1\146"+
    "\65\333\1\u0179\24\333\1\145\1\333\1\0\3\333\2\145"+
    "\1\146\70\333\1\u017a\21\333\1\145\1\333\4\0\1\u0136"+
    "\144\0\11\u017b\5\0\4\u017b\14\0\6\u017b\57\0\11\u017c"+
    "\5\0\4\u017c\14\0\6\u017c\57\0\11\u017d\5\0\4\u017d"+
    "\14\0\6\u017d\25\0\1\346\77\0\1\u017e\134\0\1\u017f"+
    "\122\0\1\u0180\15\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\23\174\1\u0181\6\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\20\174\1\u0182\11\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\6\174"+
    "\1\u0183\23\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\3\174\1\u0184\26\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\5\174\1\u0185\24\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\21\174\1\u0186\10\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\22\174"+
    "\1\u0187\7\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\24\174\1\u0188\5\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\21\174\1\u0189\10\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\2\174\1\u018a\6\174"+
    "\5\0\13\174\4\0\4\174\1\u018b\15\174\1\u018c\7\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\24\174\1\u018d\5\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\3\174\1\u018e\17\174\1\u018f\1\174\1\u0190\4\174"+
    "\1\217\3\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\5\174\1\u0191\24\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\1\174\1\u0192\30\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\14\174\1\u0193\15\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\3\174\1\u0194"+
    "\26\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\17\174\1\u0195\12\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\14\174\1\u0196\15\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\14\174\1\u0197\15\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\23\174\1\u0198"+
    "\6\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\5\174\1\u0199\20\174\1\u019a"+
    "\3\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\5\174\1\u019b\24\174\4\0"+
    "\2\174\111\0\1\u019c\12\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\22\174\1\u019d\7\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\24\174\1\u019e\5\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\13\174\1\u019f\16\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\14\174\1\u01a0"+
    "\15\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\16\174\1\u01a1\13\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\16\174\1\u01a2\13\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\20\174\1\u01a3\11\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\17\174\1\u01a4"+
    "\12\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\5\174\1\u01a5\24\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\5\174\1\u01a6\24\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\3\174\1\u01a7\26\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\16\174\1\u01a8"+
    "\13\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\17\174\1\u01a9\12\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\5\174\1\u01aa\24\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\16\174\1\u01a2\4\174\1\u01ab\6\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\1\174\1\u01ac\30\174\4\0\2\174\47\0\1\u01ad\152\0"+
    "\1\u01ae\72\0\1\u01af\145\0\1\u01b0\120\0\1\u01b1\140\0"+
    "\1\u01b2\125\0\1\u01b3\114\0\1\u01b4\45\0\11\u01b5\5\0"+
    "\4\u01b5\14\0\6\u01b5\57\0\11\u01b6\5\0\4\u01b6\14\0"+
    "\6\u01b6\111\0\1\u0172\26\0\1\u0173\41\0\11\u0174\5\0"+
    "\4\u0174\14\0\6\u0174\57\0\11\u01b7\5\0\4\u01b7\14\0"+
    "\6\u01b7\57\0\11\u01b8\5\0\4\u01b8\14\0\6\u01b8\57\0"+
    "\11\u01b9\5\0\4\u01b9\14\0\6\u01b9\32\0\3\333\2\145"+
    "\1\146\77\333\1\u01ba\1\333\1\u01bb\6\333\1\u01bc\1\333"+
    "\1\145\1\333\1\0\3\333\2\145\1\146\77\333\1\u01bd"+
    "\12\333\1\145\1\333\1\0\3\333\2\145\1\146\61\333"+
    "\1\u01be\30\333\1\145\1\333\26\0\11\u01bf\5\0\4\u01bf"+
    "\14\0\6\u01bf\57\0\11\u01c0\5\0\4\u01c0\14\0\6\u01c0"+
    "\57\0\11\u01c1\5\0\4\u01c1\14\0\6\u01c1\25\0\1\346"+
    "\111\0\1\u01c2\15\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\21\174\1\u01c3\10\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\21\174\1\u01c4\10\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\5\174"+
    "\1\u01c5\24\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\3\174\1\u01c6\26\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\14\174\1\u01c7\15\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\22\174\1\u01c8\7\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\15\174"+
    "\1\u01c9\14\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\1\174\1\u01ca\30\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\5\174\1\u01cb\24\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\30\174\1\u01cc\1\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\7\174"+
    "\1\u01cd\22\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\14\174\1\u01ce\15\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\10\174\1\u01cf\21\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\1\174\1\u01d0\30\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\16\174"+
    "\1\u01d1\13\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\14\174\1\u01d2\15\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\23\174\1\u01d3\6\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\21\174\1\u01d4\10\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\5\174"+
    "\1\u01d5\24\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\24\174\1\u01d6\5\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\23\174\1\u01d7\6\174\1\217\3\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\7\174\1\u01d8\22\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\21\174\1\u01d9\10\174\4\0\2\174\64\0\1\u01da\37\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\24\174\1\u01db\5\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\16\174\1\u01dc"+
    "\13\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\11\174\1\u01dd\20\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\5\174\1\u01de\24\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\4\174\1\u01df\25\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\21\174\1\u01e0"+
    "\10\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\26\174\1\u01e1\3\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\16\174\1\u01e2\13\174\4\0\2\174\1\0"+
    "\1\174\1\u01e3\1\u01e4\6\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\32\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\17\174\1\u01e5"+
    "\12\174\4\0\2\174\1\0\1\174\1\u01e6\1\u01e7\6\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\32\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\6\174\1\u01e8\23\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\27\174\1\u01e9\2\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\5\174\1\u01ea"+
    "\24\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\23\174\1\u01eb\6\174\4\0"+
    "\2\174\42\0\1\u01ec\167\0\1\u01ed\55\0\1\u01ee\154\0"+
    "\1\u01ef\134\0\1\u01f0\122\0\1\u01f1\104\0\1\u01f2\122\0"+
    "\1\u01f3\60\0\11\u01f4\5\0\4\u01f4\14\0\6\u01f4\57\0"+
    "\11\u01f5\5\0\4\u01f5\14\0\6\u01f5\57\0\11\u01f6\5\0"+
    "\4\u01f6\14\0\6\u01f6\57\0\11\u01f7\5\0\4\u01f7\14\0"+
    "\6\u01f7\57\0\11\u01f8\5\0\4\u01f8\14\0\6\u01f8\32\0"+
    "\3\333\2\145\1\146\64\333\1\u01f9\25\333\1\145\1\333"+
    "\1\0\3\333\2\145\1\146\55\333\1\u01fa\34\333\1\145"+
    "\1\333\1\0\3\u01bc\2\u01fb\1\u01fc\112\u01bc\1\u01fb\1\u01bc"+
    "\1\0\3\333\2\145\1\146\77\333\1\u01fd\10\333\1\u01fe"+
    "\1\333\1\145\1\333\1\0\3\333\2\145\1\146\103\333"+
    "\1\u01ff\6\333\1\145\1\333\26\0\11\u0200\5\0\4\u0200"+
    "\14\0\6\u0200\57\0\11\u0201\5\0\4\u0201\14\0\6\u0201"+
    "\57\0\11\u0202\5\0\4\u0202\14\0\6\u0202\25\0\1\346"+
    "\4\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\1\174\1\u0203\30\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\11\174"+
    "\1\u0204\20\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\21\174\1\u0205\10\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\12\174\1\u0206\17\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\5\174\1\u0207\24\174\4\0\2\174\1\0\1\174"+
    "\1\u0208\1\u0209\6\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\32\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\16\174\1\u020a\13\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\21\174\1\u020b\10\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\2\174\1\u020c\27\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\15\174"+
    "\1\u020d\14\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\17\174\1\u020e\12\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\21\174\1\u020f\10\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\14\174\1\u0210\15\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\4\174"+
    "\1\u0211\25\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\11\174\1\u0212\20\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\5\174\1\u0213\24\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\15\174\1\u0214\14\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\4\174"+
    "\1\u0215\25\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\10\174\1\u0216\21\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\5\174\1\u0217\24\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\1\174\1\u0218\30\174\4\0\2\174\104\0\1\u0219"+
    "\17\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\20\174\1\u021a\11\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\11\174"+
    "\1\u021b\20\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\3\174\1\u021c\26\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\21\174\1\u021d\10\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\1\174\1\u021e\30\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\5\174"+
    "\1\u021f\24\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\22\174\1\u0220\7\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\1\u0221\31\174\4\0\2\174\1\0"+
    "\1\174\1\u01e3\1\u01e4\6\0\1\u0222\13\0\11\174\1\0"+
    "\1\u0223\3\0\13\u0222\4\0\32\u0222\4\0\1\174\1\u0222"+
    "\2\0\2\u01e4\6\0\1\u0222\25\0\1\u0223\3\0\13\u0222"+
    "\4\0\32\u0222\5\0\1\u0222\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\4\174\1\u0224\25\174"+
    "\4\0\2\174\1\0\1\u0225\1\u01e6\1\u01e7\3\0\3\u0226"+
    "\1\u0225\10\u0226\1\u0227\2\u0226\11\u0225\5\u0226\13\u0228\4\u0226"+
    "\1\u0228\1\u0229\30\u0228\4\u0226\1\174\1\u0225\2\u0226\2\u01e7"+
    "\3\0\14\u0226\1\u0227\20\u0226\13\u0227\4\u0226\1\u0227\1\u022a"+
    "\30\u0227\4\u0226\1\0\2\u0226\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\23\174\1\u022b\6\174\4\0"+
    "\2\174\1\0\1\174\1\u010d\1\u010e\6\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\22\174\1\u022c\7\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\5\174\1\u022d\24\174\4\0\2\174\42\0"+
    "\1\u022e\147\0\1\u022f\75\0\1\u0230\166\0\1\u0231\122\0"+
    "\1\u0232\104\0\1\u0233\136\0\1\u0234\122\0\1\u0235\44\0"+
    "\11\u0236\5\0\4\u0236\14\0\6\u0236\57\0\11\301\5\0"+
    "\4\301\14\0\6\301\57\0\11\u0237\5\0\4\u0237\14\0"+
    "\6\u0237\32\0\3\333\2\145\1\146\75\333\1\u0238\14\333"+
    "\1\145\1\333\1\0\3\333\2\145\1\146\70\333\1\u0239"+
    "\21\333\1\145\1\333\4\0\1\u01fb\117\0\3\333\2\145"+
    "\1\146\64\333\1\u023a\25\333\1\145\1\333\1\0\3\u01fe"+
    "\2\u023b\1\u023c\112\u01fe\1\u023b\1\u01fe\1\0\3\333\2\145"+
    "\1\146\77\333\1\u023d\12\333\1\145\1\333\117\0\1\346"+
    "\4\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\3\174\1\u023e\26\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\25\174"+
    "\1\u023f\4\174\4\0\2\174\1\0\1\174\1\u0240\1\u0241"+
    "\6\0\1\174\13\0\11\174\5\0\13\174\4\0\32\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\22\174\1\u0242\7\174\4\0\2\174"+
    "\1\0\1\174\1\u0208\1\u0209\6\0\1\u0243\13\0\11\174"+
    "\5\0\13\u0243\4\0\32\u0243\4\0\1\174\1\u0243\2\0"+
    "\2\u0209\6\0\1\u0243\31\0\13\u0243\4\0\32\u0243\5\0"+
    "\1\u0243\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\7\174\1\u0244\22\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\24\174\1\u0245\5\174\4\0\2\174\1\0\1\174\1\u0246"+
    "\1\u0247\6\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\32\174\4\0\2\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\22\174\1\u0248\7\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\17\174\1\u0249\12\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\32\174\1\217\3\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\22\174\1\u024a\7\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\17\174\1\u024b\12\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\3\174\1\u024c\26\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\5\174"+
    "\1\u024d\24\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\5\174\1\u024e\24\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\21\174\1\u024f\10\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\21\174\1\u0250\10\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\20\174"+
    "\1\u0251\11\174\4\0\2\174\101\0\1\u0252\22\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\20\174"+
    "\1\u0253\11\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\27\174\1\u0254\2\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\21\174\1\u0255\10\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\14\174\1\u0256\15\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\22\174"+
    "\1\u0257\7\174\4\0\2\174\1\0\1\174\1\u0258\1\u0259"+
    "\6\0\1\174\13\0\11\174\5\0\13\174\4\0\32\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\22\174\1\u025a\7\174\4\0\2\174"+
    "\1\0\2\u0222\1\u025b\6\0\1\u0222\11\0\1\u025c\1\0"+
    "\11\u0222\1\0\1\u025d\3\0\13\u0222\1\u025e\3\0\32\u0222"+
    "\4\0\2\u0222\1\0\3\u025f\6\0\1\u025f\1\0\1\u025f"+
    "\5\0\1\u025f\1\0\1\u025f\1\0\11\u025f\1\0\1\u025f"+
    "\1\0\15\u025f\4\0\32\u025f\4\0\2\u025f\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\5\174"+
    "\1\u0260\24\174\4\0\2\174\1\0\2\u0225\1\u0226\3\0"+
    "\3\u0226\1\u0225\13\u0226\11\u0225\5\u0226\13\u0225\4\u0226\32\u0225"+
    "\4\u0226\1\174\1\u0225\4\u0226\3\0\112\u0226\1\0\3\u0226"+
    "\2\u0261\3\0\14\u0226\1\u0227\20\u0226\13\u0227\4\u0226\32\u0227"+
    "\4\u0226\1\0\2\u0226\1\u0225\1\u0262\1\u0261\3\0\3\u0226"+
    "\1\u0225\10\u0226\1\u0227\2\u0226\11\u0225\5\u0226\13\u0228\4\u0226"+
    "\32\u0228\4\u0226\1\174\1\u0225\1\u0226\1\u0225\1\u0262\1\u0261"+
    "\3\0\3\u0226\1\u0225\10\u0226\1\u0227\2\u0226\11\u0225\5\u0226"+
    "\13\u0228\4\u0226\14\u0228\1\u0263\15\u0228\4\u0226\1\174\1\u0225"+
    "\2\u0226\2\u0261\3\0\14\u0226\1\u0227\20\u0226\13\u0227\4\u0226"+
    "\14\u0227\1\u0264\15\u0227\4\u0226\1\0\2\u0226\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\10\174\1\u0265"+
    "\21\174\4\0\2\174\1\0\1\174\1\u0110\1\u0111\6\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\22\174\1\u0266"+
    "\7\174\4\0\2\174\2\0\5\u022e\106\0\1\u0267\1\u0268"+
    "\2\0\1\u022e\71\0\1\u0269\34\0\5\u026a\112\0\1\u026a"+
    "\40\0\1\u026b\153\0\1\u026c\136\0\1\u026d\104\0\1\u026e"+
    "\122\0\1\u026f\62\0\11\u0270\5\0\4\u0270\14\0\6\u0270"+
    "\57\0\11\u0271\5\0\4\u0271\14\0\6\u0271\32\0\3\333"+
    "\2\145\1\146\73\333\1\u0272\16\333\1\145\1\333\1\0"+
    "\3\333\2\145\1\146\110\333\1\u0273\1\333\1\145\1\333"+
    "\1\0\3\333\2\145\1\146\75\333\1\u0274\14\333\1\145"+
    "\1\333\4\0\1\u023b\117\0\3\333\2\145\1\146\64\333"+
    "\1\u0275\25\333\1\145\1\333\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\23\174\1\u0276\6\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\1\174\1\u0277\30\174\4\0\2\174"+
    "\1\0\1\u0278\1\u0240\1\u0241\3\0\3\u0279\1\u0278\13\u0279"+
    "\11\u027a\5\u0279\13\u0278\4\u0279\32\u0278\4\u0279\1\174\1\u0278"+
    "\2\u0279\2\u0241\3\0\17\u0279\11\u027b\62\u0279\1\0\2\u0279"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\22\174\1\u027c\7\174\4\0\2\174\1\0\2\u0243\1\u027d"+
    "\6\0\1\u0243\13\0\11\u0243\1\0\1\u027e\3\0\13\u0243"+
    "\4\0\32\u0243\4\0\2\u0243\1\0\1\174\1\u027f\1\u0280"+
    "\6\0\1\174\13\0\11\174\5\0\13\174\4\0\32\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\7\174\1\u0281\22\174\4\0\2\174"+
    "\1\0\1\u0282\1\u0246\1\u0247\3\0\3\u0283\1\u0284\13\u0283"+
    "\11\u0282\5\u0283\13\u0284\4\u0283\32\u0284\4\u0283\1\174\1\u0284"+
    "\2\u0283\2\u0247\3\0\3\u0283\1\u0284\31\u0283\13\u0284\4\u0283"+
    "\32\u0284\4\u0283\1\0\1\u0284\1\u0283\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\5\174\1\u0285\24\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\26\174\1\u0286\3\174\4\0\2\174"+
    "\1\0\1\174\1\u0287\1\u0288\6\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\32\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\16\174"+
    "\1\u0289\13\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\1\174\1\u028a\30\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\16\174\1\u028b\13\174\4\0\2\174"+
    "\1\0\1\174\1\u028c\1\u028d\6\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\32\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\17\174"+
    "\1\u028e\12\174\4\0\2\174\2\0\2\u028f\120\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\21\174"+
    "\1\u0290\10\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\17\174\1\u0291\12\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\17\174\1\u0292\12\174\4\0\2\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\22\174\1\u0293\7\174\4\0\2\174\1\0\1\u0294"+
    "\1\u0258\1\u0259\3\0\3\u0295\1\u0296\13\u0295\11\u0294\5\u0295"+
    "\13\u0296\4\u0295\32\u0296\4\u0295\1\174\1\u0296\2\u0295\2\u0259"+
    "\3\0\3\u0295\1\u0296\31\u0295\13\u0296\4\u0295\32\u0296\4\u0295"+
    "\1\0\1\u0296\1\u0295\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\11\174\1\u0297\20\174\4\0\2\174"+
    "\2\0\2\u025b\20\0\1\u025c\13\0\1\u025d\16\0\1\u025e"+
    "\45\0\2\u025c\6\0\1\u0222\31\0\13\u0222\4\0\32\u0222"+
    "\5\0\1\u0222\1\0\3\u0298\6\0\1\u0298\1\0\1\u0298"+
    "\5\0\1\u0298\1\0\1\u0298\1\0\11\u0298\1\0\1\u0298"+
    "\1\0\15\u0298\4\0\32\u0298\4\0\2\u0298\2\0\2\u025e"+
    "\55\0\1\u0299\42\0\3\u025f\6\0\1\u025f\1\0\1\u025f"+
    "\5\0\1\u025f\1\0\1\u025f\1\0\11\u025f\1\0\1\u025f"+
    "\1\0\1\u029a\14\u025f\4\0\32\u025f\4\0\2\u025f\1\0"+
    "\1\174\1\u029b\1\u029c\6\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\32\174\4\0\2\174\1\0\1\u0226\2\u0261"+
    "\3\0\112\u0226\1\0\2\u0226\1\u0225\1\u0262\1\u0261\3\0"+
    "\3\u0226\1\u0225\13\u0226\11\u0225\5\u0226\13\u0225\4\u0226\32\u0225"+
    "\4\u0226\1\174\1\u0225\1\u0226\1\u0225\1\u0262\1\u0261\3\0"+
    "\3\u0226\1\u0225\10\u0226\1\u0227\2\u0226\11\u0225\5\u0226\13\u0228"+
    "\4\u0226\14\u0228\1\u029d\15\u0228\4\u0226\1\174\1\u0225\2\u0226"+
    "\2\u0261\3\0\14\u0226\1\u0227\20\u0226\13\u0227\4\u0226\14\u0227"+
    "\1\u029e\15\u0227\4\u0226\1\0\2\u0226\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\21\174\1\u029f\10\174"+
    "\4\0\2\174\2\0\2\u02a0\121\0\5\u026a\106\0\1\u02a1"+
    "\3\0\1\u026a\62\0\1\255\145\0\1\u02a2\55\0\1\u02a3"+
    "\147\0\1\u02a4\122\0\1\u02a5\37\0\3\333\2\145\1\146"+
    "\102\333\1\u02a6\7\333\1\145\1\333\1\0\3\u0273\2\u02a7"+
    "\1\u02a8\112\u0273\1\u02a7\1\u0273\1\0\3\333\2\145\1\146"+
    "\73\333\1\u02a9\16\333\1\145\1\333\1\0\3\333\2\145"+
    "\1\146\75\333\1\u02aa\14\333\1\145\1\333\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\23\174"+
    "\1\u02ab\6\174\4\0\2\174\1\0\2\u0278\1\u0279\3\0"+
    "\3\u0279\1\u0278\13\u0279\11\u0278\5\u0279\13\u0278\4\u0279\32\u0278"+
    "\4\u0279\1\174\1\u0278\4\u0279\3\0\112\u0279\1\0\2\u0279"+
    "\1\u0278\1\u02ac\1\u02ad\3\0\3\u0279\1\u0278\13\u0279\11\u027a"+
    "\5\u0279\13\u0278\4\u0279\32\u0278\4\u0279\1\174\1\u0278\2\u0279"+
    "\2\u02ad\3\0\17\u0279\11\u027b\62\u0279\1\0\2\u0279\1\0"+
    "\2\u027d\34\0\1\u027e\63\0\3\u02ae\6\0\1\u02ae\1\0"+
    "\1\u02ae\5\0\1\u02ae\1\0\1\u02ae\1\0\11\u02ae\1\0"+
    "\1\u02ae\1\0\15\u02ae\4\0\32\u02ae\4\0\2\u02ae\1\0"+
    "\1\174\1\u027f\1\u0280\6\0\1\u02af\13\0\11\174\1\0"+
    "\1\u02b0\3\0\13\u02af\4\0\32\u02af\4\0\1\174\1\u02af"+
    "\2\0\2\u0280\6\0\1\u02b1\25\0\1\u02b0\3\0\13\u02b1"+
    "\4\0\32\u02b1\5\0\1\u02b1\1\0\2\u0282\1\u0283\3\0"+
    "\3\u0283\1\u0282\13\u0283\11\u0282\5\u0283\13\u0282\4\u0283\32\u0282"+
    "\4\u0283\1\174\1\u0282\4\u0283\3\0\112\u0283\1\0\2\u0283"+
    "\2\u0284\1\u02b2\3\0\3\u0283\1\u0284\11\u0283\1\u0247\1\u0283"+
    "\11\u0284\5\u0283\13\u0284\4\u0283\32\u0284\4\u0283\1\u02b3\1\u0284"+
    "\1\u0283\1\174\1\u02b4\1\u02b5\6\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\32\174\4\0\2\174\1\0\1\174"+
    "\1\u02b6\1\u02b7\6\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\32\174\1\217\3\0\2\174\1\0\1\174\1\u0287"+
    "\1\u0288\6\0\1\u02b8\13\0\11\174\5\0\13\u02b8\4\0"+
    "\32\u02b8\4\0\1\174\1\u02b8\2\0\2\u0288\6\0\1\u02b8"+
    "\31\0\13\u02b8\4\0\32\u02b8\5\0\1\u02b8\1\0\1\174"+
    "\1\u02b9\1\u02ba\6\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\32\174\4\0\2\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\22\174\1\u02bb\7\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\23\174\1\u02bc\6\174\4\0\2\174"+
    "\1\0\2\u028c\1\u028d\3\0\3\u028d\1\u028c\13\u028d\11\u028c"+
    "\5\u028d\13\u028c\4\u028d\32\u028c\4\u028d\1\174\1\u028c\1\0"+
    "\3\u028d\3\0\112\u028d\1\0\1\u028d\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\26\174\1\u02bd"+
    "\3\174\4\0\2\174\1\0\1\u0226\2\u028f\3\0\14\u0226"+
    "\1\u02be\20\u0226\13\u02be\4\u0226\1\u02be\1\u02bf\30\u02be\4\u0226"+
    "\1\0\2\u0226\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\5\174\1\u02c0\24\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\21\174\1\u02c1\10\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\16\174\1\u02c2"+
    "\13\174\4\0\2\174\1\0\1\174\1\u02c3\1\u02c4\6\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\32\174\4\0"+
    "\2\174\1\0\2\u0294\1\u0295\3\0\3\u0295\1\u0294\13\u0295"+
    "\11\u0294\5\u0295\13\u0294\4\u0295\32\u0294\4\u0295\1\174\1\u0294"+
    "\4\u0295\3\0\112\u0295\1\0\2\u0295\2\u0296\1\u02c5\3\0"+
    "\3\u0295\1\u0296\7\u0295\1\u0259\1\u0295\1\u0259\1\u0295\11\u0296"+
    "\5\u0295\13\u0296\4\u0295\32\u0296\4\u0295\1\u02c6\1\u0296\1\u0295"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\31\174\1\u02c7\4\0\2\174\1\0\3\u0298\6\0\1\u0298"+
    "\1\0\1\u0298\5\0\1\u0298\1\0\1\u0298\1\0\11\u0298"+
    "\1\0\1\u0298\1\0\1\u02c8\14\u0298\4\0\32\u0298\4\0"+
    "\2\u0298\2\0\2\u0299\53\0\1\u025e\44\0\1\u025f\2\u029a"+
    "\6\0\1\u02c9\1\0\1\u025f\5\0\1\u025f\1\0\1\u025f"+
    "\1\0\11\u025f\1\0\1\u025f\1\0\1\u029a\1\u025f\13\u02c9"+
    "\4\0\32\u02c9\4\0\1\u025f\1\u02c9\1\0\1\174\1\u029b"+
    "\1\u029c\6\0\1\174\13\0\1\174\10\u02ca\5\0\13\174"+
    "\4\0\32\174\4\0\2\174\2\0\2\u029c\23\0\10\u02cb"+
    "\65\0\1\u0225\1\u02cc\1\u02cd\3\0\3\u0226\1\u0225\10\u0226"+
    "\1\u0227\2\u0226\11\u0225\5\u0226\13\u0228\4\u0226\32\u0228\4\u0226"+
    "\1\174\1\u0225\2\u0226\2\u02cd\3\0\14\u0226\1\u0227\20\u0226"+
    "\13\u0227\4\u0226\32\u0227\4\u0226\1\0\2\u0226\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\17\174\1\u02ce"+
    "\12\174\4\0\2\174\1\0\3\u02a0\3\0\112\u02a0\1\0"+
    "\1\u02a0\37\0\1\u02cf\27\0\1\u02d0\114\0\1\u02d1\146\0"+
    "\1\u02d2\122\0\1\u02d3\16\0\3\333\2\145\1\146\110\333"+
    "\1\u02d4\1\333\1\145\1\333\4\0\1\u02a7\117\0\3\333"+
    "\2\145\1\146\102\333\1\u02d5\7\333\1\145\1\333\1\0"+
    "\3\333\2\145\1\146\73\333\1\u02d6\16\333\1\145\1\333"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\5\174\1\u02d7\24\174\4\0\2\174\1\0\1\u0278"+
    "\1\u02ac\1\u02ad\3\0\3\u0279\1\u0278\13\u0279\11\u0278\5\u0279"+
    "\13\u0278\4\u0279\32\u0278\4\u0279\1\174\1\u0278\2\u0279\2\u02ad"+
    "\3\0\112\u0279\1\0\2\u0279\3\u02ae\6\0\1\u02ae\1\0"+
    "\1\u02ae\5\0\1\u02ae\1\0\1\u02ae\1\0\11\u02ae\1\0"+
    "\1\u02ae\1\0\1\u02d8\14\u02ae\4\0\32\u02ae\4\0\2\u02ae"+
    "\1\0\1\u02af\1\u02d9\1\u02da\6\0\1\u02af\11\0\1\u02db"+
    "\1\0\11\u02af\1\0\1\u02dc\3\0\13\u02af\1\u02dd\3\0"+
    "\32\u02af\4\0\2\u02af\1\0\3\u02de\6\0\1\u02de\1\0"+
    "\1\u02de\5\0\1\u02de\1\0\1\u02de\1\0\11\u02de\1\0"+
    "\1\u02de\1\0\15\u02de\4\0\32\u02de\4\0\2\u02de\1\0"+
    "\1\u02b1\1\u02df\1\u02da\6\0\1\u02b1\11\0\1\u02db\1\0"+
    "\11\u02b1\1\0\1\u02dc\3\0\13\u02b1\1\u02dd\3\0\32\u02b1"+
    "\4\0\2\u02b1\1\0\1\u0283\2\u02b2\3\0\15\u0283\1\u0247"+
    "\74\u0283\1\0\2\u0283\2\u02b3\1\u02e0\6\0\1\u02b3\11\0"+
    "\1\u02e1\1\0\11\u02b3\5\0\13\u02b3\4\0\32\u02b3\4\0"+
    "\2\u02b3\1\0\1\174\1\u02b4\1\u02b5\6\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\6\174\1\u02e2\14\174\1\u02e3"+
    "\6\174\4\0\2\174\2\0\2\u02b5\65\0\1\u02e4\14\0"+
    "\1\u02e5\15\0\1\u02e6\1\u02b6\1\u02b7\3\0\3\u02e7\1\u02e8"+
    "\13\u02e7\11\u02e6\5\u02e7\13\u02e8\4\u02e7\32\u02e8\4\u02e7\1\174"+
    "\1\u02e8\2\u02e7\2\u02b7\3\0\3\u02e7\1\u02e8\31\u02e7\13\u02e8"+
    "\4\u02e7\32\u02e8\4\u02e7\1\0\1\u02e8\1\u02e7\2\u02b8\1\u02e9"+
    "\6\0\1\u02b8\11\0\1\u0288\1\0\11\u02b8\1\0\1\u02ea"+
    "\3\0\13\u02b8\4\0\32\u02b8\4\0\2\u02b8\1\0\1\174"+
    "\1\u02b9\1\u02ba\6\0\1\u02eb\13\0\11\174\5\0\13\u02eb"+
    "\4\0\32\u02eb\4\0\1\174\1\u02eb\2\0\2\u02ba\6\0"+
    "\1\u02eb\31\0\13\u02eb\4\0\32\u02eb\5\0\1\u02eb\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\5\174\1\u027c\24\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\22\174\1\u02ec"+
    "\7\174\4\0\2\174\1\0\1\174\1\u02ed\1\u02ee\6\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\32\174\1\217"+
    "\3\0\2\174\1\0\1\u0226\2\u02ef\3\0\14\u0226\1\u02be"+
    "\20\u0226\13\u02be\4\u0226\32\u02be\4\u0226\1\0\3\u0226\2\u02ef"+
    "\3\0\14\u0226\1\u02be\20\u0226\13\u02be\4\u0226\14\u02be\1\u02f0"+
    "\15\u02be\4\u0226\1\0\2\u0226\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\22\174\1\u02f1\7\174\4\0"+
    "\2\174\1\0\1\174\1\u02f2\1\u02f3\6\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\32\174\4\0\2\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\5\174\1\u02f4\24\174\4\0\2\174\1\0\1\u0225\1\u02c3"+
    "\1\u02c4\3\0\3\u0226\1\u0225\10\u0226\1\u02f5\2\u0226\11\u0225"+
    "\5\u0226\13\u02f6\4\u0226\1\u02f6\1\u02f7\30\u02f6\4\u0226\1\174"+
    "\1\u0225\2\u0226\2\u02c4\3\0\14\u0226\1\u02f5\20\u0226\13\u02f5"+
    "\4\u0226\1\u02f5\1\u02f8\30\u02f5\4\u0226\1\0\2\u0226\1\u0295"+
    "\2\u02c5\3\0\13\u0295\1\u0259\1\u0295\1\u0259\74\u0295\1\0"+
    "\2\u0295\2\u02c6\1\u02f9\6\0\1\u02c6\7\0\1\u02fa\1\0"+
    "\1\u02fa\1\0\11\u02c6\5\0\13\u02c6\4\0\32\u02c6\4\0"+
    "\2\u02c6\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\5\174\1\u02fb\24\174\4\0\2\174\1\0"+
    "\1\u0298\2\u02c8\6\0\1\u0298\1\0\1\u0298\5\0\1\u0298"+
    "\1\0\1\u0298\1\0\11\u0298\1\0\1\u0298\1\0\1\u02c8"+
    "\14\u0298\1\u025e\3\0\32\u0298\4\0\2\u0298\1\0\2\u02c9"+
    "\1\u02fc\6\0\1\u02c9\1\0\1\u025f\5\0\1\u025f\1\0"+
    "\1\u029a\1\0\11\u02c9\1\0\1\u02fd\1\0\1\u029a\1\u025f"+
    "\13\u02c9\1\u025e\3\0\32\u02c9\4\0\2\u02c9\1\0\2\174"+
    "\7\0\1\174\11\0\1\u02fe\1\0\11\u02ca\5\0\13\174"+
    "\4\0\32\174\4\0\2\174\24\0\1\u02fe\1\0\11\u02cb"+
    "\65\0\1\u0225\1\u02cc\1\u02cd\3\0\3\u0226\1\u0225\13\u0226"+
    "\11\u0225\5\u0226\13\u0225\4\u0226\32\u0225\4\u0226\1\174\1\u0225"+
    "\2\u0226\2\u02cd\3\0\112\u0226\1\0\2\u0226\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\26\174\1\u02ff"+
    "\3\174\4\0\2\174\61\0\1\u0300\135\0\1\u0301\116\0"+
    "\1\u0302\122\0\1\u0303\33\0\3\u02d4\2\u0304\1\u0305\112\u02d4"+
    "\1\u0304\1\u02d4\1\0\3\333\2\145\1\146\110\333\1\u0306"+
    "\1\333\1\145\1\333\1\0\3\333\2\145\1\146\102\333"+
    "\1\u0307\7\333\1\145\1\333\1\0\1\u02ae\2\u02d8\6\0"+
    "\1\u02ae\1\0\1\u02ae\5\0\1\u02ae\1\0\1\u02ae\1\0"+
    "\11\u02ae\1\0\1\u02ae\1\0\1\u02d8\14\u02ae\4\0\32\u02ae"+
    "\4\0\2\u02ae\2\0\2\u02da\20\0\1\u02db\13\0\1\u02dc"+
    "\16\0\1\u02dd\45\0\2\u02db\6\0\1\u02b1\31\0\13\u02b1"+
    "\4\0\32\u02b1\5\0\1\u02b1\1\0\3\u0308\6\0\1\u0308"+
    "\1\0\1\u0308\5\0\1\u0308\1\0\1\u0308\1\0\11\u0308"+
    "\1\0\1\u0308\1\0\15\u0308\4\0\32\u0308\4\0\2\u0308"+
    "\2\0\2\u02dd\55\0\1\u0309\42\0\3\u02de\6\0\1\u02de"+
    "\1\0\1\u02de\5\0\1\u02de\1\0\1\u02de\1\0\11\u02de"+
    "\1\0\1\u02de\1\0\1\u030a\14\u02de\4\0\32\u02de\4\0"+
    "\2\u02de\2\0\2\u02e0\20\0\1\u02e1\100\0\2\u02e1\6\0"+
    "\1\u02b3\31\0\13\u02b3\4\0\32\u02b3\5\0\1\u02b3\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\1\174\1\u030b\30\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\21\174\1\u030c"+
    "\10\174\4\0\2\174\64\0\1\u030d\142\0\1\u030e\17\0"+
    "\2\u02e6\1\u02e7\3\0\3\u02e7\1\u02e6\13\u02e7\11\u02e6\5\u02e7"+
    "\13\u02e6\4\u02e7\32\u02e6\4\u02e7\1\174\1\u02e6\4\u02e7\3\0"+
    "\112\u02e7\1\0\2\u02e7\2\u02e8\1\u030f\3\0\3\u02e7\1\u02e8"+
    "\7\u02e7\1\u02b7\1\u02e7\1\u02b7\1\u02e7\11\u02e8\5\u02e7\13\u02e8"+
    "\4\u02e7\32\u02e8\4\u02e7\1\u0310\1\u02e8\1\u02e7\1\0\2\u02e9"+
    "\20\0\1\u0288\13\0\1\u02ea\63\0\3\u0311\6\0\1\u0311"+
    "\1\0\1\u0311\5\0\1\u0311\1\0\1\u0311\1\0\11\u0311"+
    "\1\0\1\u0311\1\0\15\u0311\4\0\32\u0311\4\0\2\u0311"+
    "\1\0\2\u02eb\1\u0312\6\0\1\u02eb\13\0\11\u02eb\5\0"+
    "\13\u02eb\4\0\32\u02eb\4\0\2\u02eb\1\0\1\174\1\u0313"+
    "\1\u0314\6\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\32\174\4\0\2\174\1\0\1\u0315\1\u02ed\1\u02ee\3\0"+
    "\3\u0316\1\u0317\13\u0316\11\u0315\5\u0316\13\u0317\4\u0316\32\u0317"+
    "\4\u0316\1\174\1\u0317\2\u0316\2\u02ee\3\0\3\u0316\1\u0317"+
    "\31\u0316\13\u0317\4\u0316\32\u0317\4\u0316\1\0\1\u0317\1\u0316"+
    "\1\u0226\2\u02ef\3\0\112\u0226\1\0\3\u0226\2\u02ef\3\0"+
    "\14\u0226\1\u02be\20\u0226\13\u02be\4\u0226\14\u02be\1\u0318\15\u02be"+
    "\4\u0226\1\0\2\u0226\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\22\174\1\u0319\7\174\4\0\2\174"+
    "\1\0\1\u031a\1\u02f2\1\u02f3\3\0\3\u031b\1\u031c\13\u031b"+
    "\11\u031a\5\u031b\13\u031c\4\u031b\32\u031c\4\u031b\1\174\1\u031c"+
    "\2\u031b\2\u02f3\3\0\3\u031b\1\u031c\31\u031b\13\u031c\4\u031b"+
    "\32\u031c\4\u031b\1\0\1\u031c\1\u031b\1\u0226\2\u031d\3\0"+
    "\14\u0226\1\u02f5\20\u0226\13\u02f5\4\u0226\32\u02f5\4\u0226\1\0"+
    "\2\u0226\1\u0225\1\u031e\1\u031d\3\0\3\u0226\1\u0225\10\u0226"+
    "\1\u02f5\2\u0226\11\u0225\5\u0226\13\u02f6\4\u0226\32\u02f6\4\u0226"+
    "\1\174\1\u0225\1\u0226\1\u0225\1\u031e\1\u031d\3\0\3\u0226"+
    "\1\u0225\10\u0226\1\u02f5\2\u0226\11\u0225\5\u0226\13\u02f6\4\u0226"+
    "\14\u02f6\1\u031f\15\u02f6\4\u0226\1\174\1\u0225\2\u0226\2\u031d"+
    "\3\0\14\u0226\1\u02f5\20\u0226\13\u02f5\4\u0226\14\u02f5\1\u0320"+
    "\15\u02f5\4\u0226\1\0\2\u0226\1\0\2\u02f9\16\0\1\u02fa"+
    "\1\0\1\u02fa\100\0\2\u02fa\6\0\1\u02c6\31\0\13\u02c6"+
    "\4\0\32\u02c6\5\0\1\u02c6\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\1\u0321\31\174\4\0"+
    "\2\174\1\0\1\u025f\2\u02fc\6\0\1\u025f\1\0\1\u025f"+
    "\5\0\1\u025f\1\0\1\u029a\1\0\11\u025f\1\0\1\u02fd"+
    "\1\0\1\u029a\14\u025f\1\u025e\3\0\32\u025f\4\0\2\u025f"+
    "\1\0\3\u0322\6\0\1\u0322\1\0\1\u0322\5\0\1\u0322"+
    "\1\0\1\u0322\1\0\11\u0322\1\0\1\u0322\1\0\1\u0323"+
    "\14\u0322\4\0\32\u0322\4\0\2\u0322\26\0\11\u0324\65\0"+
    "\1\174\1\u0325\1\u0326\6\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\32\174\1\217\3\0\2\174\72\0\1\u0327"+
    "\67\0\1\u0328\122\0\1\u0329\67\0\1\u0304\117\0\3\u0306"+
    "\2\u032a\1\u032b\112\u0306\1\u032a\1\u0306\1\0\3\333\2\145"+
    "\1\146\110\333\1\u032c\1\333\1\145\1\333\1\0\3\u0308"+
    "\6\0\1\u0308\1\0\1\u0308\5\0\1\u0308\1\0\1\u0308"+
    "\1\0\11\u0308\1\0\1\u0308\1\0\1\u032d\14\u0308\4\0"+
    "\32\u0308\4\0\2\u0308\2\0\2\u032e\53\0\1\u02dd\44\0"+
    "\1\u02de\2\u030a\6\0\1\u032f\1\0\1\u02de\5\0\1\u02de"+
    "\1\0\1\u02de\1\0\11\u02de\1\0\1\u02de\1\0\1\u030a"+
    "\1\u02de\13\u032f\4\0\32\u032f\4\0\1\u02de\1\u032f\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\14\174\1\u0330\15\174\4\0\2\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\24\174\1\u0331"+
    "\5\174\4\0\2\174\77\0\1\u0332\132\0\1\u0333\14\0"+
    "\1\u02e7\2\u030f\3\0\13\u02e7\1\u02b7\1\u02e7\1\u02b7\74\u02e7"+
    "\1\0\2\u02e7\2\u0310\1\u0334\6\0\1\u0310\7\0\1\u0335"+
    "\1\0\1\u0335\1\0\11\u0310\5\0\13\u0310\4\0\32\u0310"+
    "\4\0\2\u0310\1\0\3\u0311\6\0\1\u0311\1\0\1\u0311"+
    "\5\0\1\u0311\1\0\1\u0311\1\0\11\u0311\1\0\1\u0311"+
    "\1\0\1\u0336\14\u0311\4\0\32\u0311\4\0\2\u0311\2\0"+
    "\2\u0312\120\0\2\u0313\1\u0314\3\0\3\u0314\1\u0313\13\u0314"+
    "\11\u0313\5\u0314\13\u0313\4\u0314\32\u0313\4\u0314\1\174\1\u0313"+
    "\1\0\3\u0314\3\0\112\u0314\1\0\1\u0314\1\0\2\u0315"+
    "\1\u0316\3\0\3\u0316\1\u0315\13\u0316\11\u0315\5\u0316\13\u0315"+
    "\4\u0316\32\u0315\4\u0316\1\174\1\u0315\4\u0316\3\0\112\u0316"+
    "\1\0\2\u0316\2\u0317\1\u0337\3\0\3\u0316\1\u0317\7\u0316"+
    "\1\u02ee\1\u0316\1\u02ee\1\u0316\11\u0317\5\u0316\13\u0317\4\u0316"+
    "\32\u0317\4\u0316\1\u0338\1\u0317\1\u0316\1\u0226\2\u0339\3\0"+
    "\14\u0226\1\u02be\20\u0226\13\u02be\4\u0226\32\u02be\4\u0226\1\0"+
    "\2\u0226\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\1\u033a\31\174\4\0\2\174\1\0\2\u031a\1\u031b"+
    "\3\0\3\u031b\1\u031a\13\u031b\11\u031a\5\u031b\13\u031a\4\u031b"+
    "\32\u031a\4\u031b\1\174\1\u031a\4\u031b\3\0\112\u031b\1\0"+
    "\2\u031b\2\u031c\1\u033b\3\0\3\u031b\1\u031c\11\u031b\1\u02f3"+
    "\1\u031b\11\u031c\5\u031b\13\u031c\4\u031b\32\u031c\4\u031b\1\u033c"+
    "\1\u031c\1\u031b\1\u0226\2\u031d\3\0\112\u0226\1\0\2\u0226"+
    "\1\u0225\1\u031e\1\u031d\3\0\3\u0226\1\u0225\13\u0226\11\u0225"+
    "\5\u0226\13\u0225\4\u0226\32\u0225\4\u0226\1\174\1\u0225\1\u0226"+
    "\1\u0225\1\u031e\1\u031d\3\0\3\u0226\1\u0225\10\u0226\1\u02f5"+
    "\2\u0226\11\u0225\5\u0226\13\u02f6\4\u0226\14\u02f6\1\u033d\15\u02f6"+
    "\4\u0226\1\174\1\u0225\2\u0226\2\u031d\3\0\14\u0226\1\u02f5"+
    "\20\u0226\13\u02f5\4\u0226\14\u02f5\1\u033e\15\u02f5\4\u0226\1\0"+
    "\2\u0226\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\14\174\1\u033f\15\174\4\0\2\174\1\0\3\u0322"+
    "\6\0\1\u0322\1\0\1\u0322\5\0\1\u0322\1\0\1\u0322"+
    "\1\0\11\u0322\1\0\1\u0322\1\0\1\u0340\14\u0322\4\0"+
    "\32\u0322\4\0\2\u0322\1\0\1\u0322\2\u0323\6\0\1\u0341"+
    "\1\0\1\u0322\5\0\1\u0322\1\0\1\u0322\1\0\11\u0322"+
    "\1\0\1\u0322\1\0\1\u0340\1\u0322\13\u0341\4\0\32\u0341"+
    "\4\0\1\u0322\1\u0341\24\0\1\u0342\1\0\11\u0324\65\0"+
    "\1\u0343\1\u0325\1\u0326\3\0\3\u0344\1\u0345\13\u0344\11\u0343"+
    "\5\u0344\13\u0345\4\u0344\32\u0345\4\u0344\1\174\1\u0345\2\u0344"+
    "\2\u0326\3\0\3\u0344\1\u0345\31\u0344\13\u0345\4\u0344\32\u0345"+
    "\4\u0344\1\0\1\u0345\1\u0344\73\0\1\u0346\107\0\1\u0347"+
    "\122\0\1\u0348\45\0\1\u032a\117\0\3\u032c\2\u0349\1\u034a"+
    "\112\u032c\1\u0349\1\u032c\1\0\1\u0308\2\u034b\6\0\1\u0308"+
    "\1\0\1\u0308\5\0\1\u0308\1\0\1\u0308\1\0\11\u0308"+
    "\1\0\1\u0308\1\0\1\u032d\14\u0308\1\u02dd\3\0\32\u0308"+
    "\4\0\2\u0308\1\0\1\u032f\1\u034c\1\u034d\6\0\1\u032f"+
    "\1\0\1\u02de\5\0\1\u02de\1\0\1\u030a\1\0\11\u032f"+
    "\1\0\1\u034e\1\0\1\u030a\1\u02de\13\u032f\1\u02dd\3\0"+
    "\32\u032f\4\0\2\u032f\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\22\174\1\u034f\7\174\4\0"+
    "\2\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\5\174\1\u0350\24\174\4\0\2\174\105\0"+
    "\1\u0351\105\0\1\u0352\34\0\2\u0334\16\0\1\u0335\1\0"+
    "\1\u0335\100\0\2\u0335\6\0\1\u0310\31\0\13\u0310\4\0"+
    "\32\u0310\5\0\1\u0310\1\0\1\u0311\2\u0336\6\0\1\u0311"+
    "\1\0\1\u0311\5\0\1\u0311\1\0\1\u0311\1\0\11\u0311"+
    "\1\0\1\u0311\1\0\1\u0336\14\u0311\4\0\32\u0311\4\0"+
    "\2\u0311\1\0\1\u0316\2\u0337\3\0\13\u0316\1\u02ee\1\u0316"+
    "\1\u02ee\74\u0316\1\0\2\u0316\2\u0338\1\u0353\6\0\1\u0338"+
    "\7\0\1\u0354\1\0\1\u0354\1\0\11\u0338\5\0\13\u0338"+
    "\4\0\32\u0338\4\0\2\u0338\1\0\1\u0226\2\u0339\3\0"+
    "\112\u0226\1\0\2\u0226\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\26\174\1\u0355\3\174\4\0\2\174"+
    "\1\0\1\u031b\2\u033b\3\0\15\u031b\1\u02f3\74\u031b\1\0"+
    "\2\u031b\2\u033c\1\u0356\6\0\1\u033c\11\0\1\u0357\1\0"+
    "\11\u033c\5\0\13\u033c\4\0\32\u033c\4\0\2\u033c\1\0"+
    "\1\u0225\1\u0358\1\u0339\3\0\3\u0226\1\u0225\10\u0226\1\u02f5"+
    "\2\u0226\11\u0225\5\u0226\13\u02f6\4\u0226\32\u02f6\4\u0226\1\174"+
    "\1\u0225\2\u0226\2\u0339\3\0\14\u0226\1\u02f5\20\u0226\13\u02f5"+
    "\4\u0226\32\u02f5\4\u0226\1\0\2\u0226\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\11\174\1\u0359\20\174"+
    "\4\0\2\174\1\0\1\u0322\2\u0340\6\0\1\u0341\1\0"+
    "\1\u0322\5\0\1\u0322\1\0\1\u0322\1\0\11\u0322\1\0"+
    "\1\u0322\1\0\1\u0340\1\u0322\13\u0341\1\u025e\3\0\32\u0341"+
    "\4\0\1\u0322\1\u0341\1\0\2\u0341\1\u035a\6\0\1\u0341"+
    "\1\0\1\u0322\5\0\1\u0322\1\0\1\u0323\1\0\11\u0341"+
    "\1\0\1\u0322\1\0\1\u0340\1\u0322\13\u0341\1\u025e\3\0"+
    "\32\u0341\4\0\2\u0341\26\0\11\u035b\65\0\2\u0343\1\u0344"+
    "\3\0\3\u0344\1\u0343\13\u0344\11\u0343\5\u0344\13\u0343\4\u0344"+
    "\32\u0343\4\u0344\1\174\1\u0343\4\u0344\3\0\112\u0344\1\0"+
    "\2\u0344\2\u0345\1\u035c\3\0\3\u0344\1\u0345\7\u0344\1\u0326"+
    "\1\u0344\1\u0326\1\u035d\11\u0345\5\u0344\13\u0345\4\u0344\32\u0345"+
    "\4\u0344\1\u035e\1\u0345\1\u0344\105\0\1\u035f\20\0\1\u0349"+
    "\117\0\1\u02de\2\u034d\6\0\1\u02de\1\0\1\u02de\5\0"+
    "\1\u02de\1\0\1\u030a\1\0\11\u02de\1\0\1\u034e\1\0"+
    "\1\u030a\14\u02de\1\u02dd\3\0\32\u02de\4\0\2\u02de\1\0"+
    "\3\u0360\6\0\1\u0360\1\0\1\u0360\5\0\1\u0360\1\0"+
    "\1\u0360\1\0\11\u0360\1\0\1\u0360\1\0\1\u0361\14\u0360"+
    "\4\0\32\u0360\4\0\2\u0360\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\5\174\1\u0362\24\174"+
    "\4\0\2\174\70\0\1\u0363\34\0\2\u0353\16\0\1\u0354"+
    "\1\0\1\u0354\100\0\2\u0354\6\0\1\u0338\31\0\13\u0338"+
    "\4\0\32\u0338\5\0\1\u0338\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\1\174\1\u0364\30\174"+
    "\4\0\2\174\2\0\2\u0356\20\0\1\u0357\100\0\2\u0357"+
    "\6\0\1\u033c\31\0\13\u033c\4\0\32\u033c\5\0\1\u033c"+
    "\1\0\1\u0225\1\u0358\1\u0339\3\0\3\u0226\1\u0225\13\u0226"+
    "\11\u0225\5\u0226\13\u0225\4\u0226\32\u0225\4\u0226\1\174\1\u0225"+
    "\1\u0226\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\15\174\1\u0365\14\174\4\0\2\174\1\0\1\u0322"+
    "\2\u035a\6\0\1\u0322\1\0\1\u0322\5\0\1\u0322\1\0"+
    "\1\u0323\1\0\11\u0322\1\0\1\u0322\1\0\1\u0340\14\u0322"+
    "\1\u025e\3\0\32\u0322\4\0\2\u0322\1\0\1\u0344\2\u035c"+
    "\3\0\13\u0344\1\u0326\1\u0344\1\u0326\1\u035d\73\u0344\1\0"+
    "\5\u0344\3\0\11\u0344\1\u0366\4\u0344\1\u0367\73\u0344\1\0"+
    "\2\u0344\2\u035e\1\u0368\6\0\1\u035e\7\0\1\u0369\1\0"+
    "\1\u0369\1\u036a\11\u035e\5\0\13\u035e\4\0\32\u035e\4\0"+
    "\2\u035e\37\0\1\u036b\64\0\3\u0360\6\0\1\u0360\1\0"+
    "\1\u0360\5\0\1\u0360\1\0\1\u0360\1\0\11\u0360\1\0"+
    "\1\u0360\1\0\1\u036c\14\u0360\4\0\32\u0360\4\0\2\u0360"+
    "\1\0\1\u0360\2\u0361\6\0\1\u036d\1\0\1\u0360\5\0"+
    "\1\u0360\1\0\1\u0360\1\0\11\u0360\1\0\1\u0360\1\0"+
    "\1\u036c\1\u0360\13\u036d\4\0\32\u036d\4\0\1\u0360\1\u036d"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\21\174\1\u036e\10\174\4\0\2\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\11\174"+
    "\1\u036f\20\174\4\0\2\174\1\0\3\u0366\3\u0370\11\u0366"+
    "\1\u0371\100\u0366\1\u0370\2\u0366\3\u0367\2\u0372\1\u0373\112\u0367"+
    "\1\u0372\1\u0367\1\u0344\1\0\2\u0368\16\0\1\u0369\1\0"+
    "\1\u0369\1\u036a\77\0\2\u0369\6\0\1\u035e\31\0\13\u035e"+
    "\4\0\32\u035e\5\0\1\u035e\20\0\1\u0370\4\0\1\u0374"+
    "\156\0\1\u0375\42\0\1\u0360\2\u0376\6\0\1\u036d\1\0"+
    "\1\u0360\5\0\1\u0360\1\0\1\u0360\1\0\11\u0360\1\0"+
    "\1\u0360\1\0\1\u036c\1\u0360\13\u036d\1\u02dd\3\0\32\u036d"+
    "\4\0\1\u0360\1\u036d\1\0\1\u036d\1\u0377\1\u0378\6\0"+
    "\1\u036d\1\0\1\u0360\5\0\1\u0360\1\0\1\u0361\1\0"+
    "\11\u036d\1\0\1\u0360\1\0\1\u036c\1\u0360\13\u036d\1\u02dd"+
    "\3\0\32\u036d\4\0\2\u036d\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\16\174\1\u0379\13\174"+
    "\4\0\2\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\23\174\1\u037a\6\174\4\0\2\174"+
    "\1\0\17\u0370\1\u037b\103\u0370\3\u0366\3\u0370\11\u0366\1\u0371"+
    "\4\u0366\1\u037c\73\u0366\1\u0370\2\u0366\3\0\1\u0372\117\0"+
    "\3\u0374\2\u0372\1\u0373\112\u0374\1\u0372\1\u0374\1\0\1\u0360"+
    "\2\u0378\6\0\1\u0360\1\0\1\u0360\5\0\1\u0360\1\0"+
    "\1\u0361\1\0\11\u0360\1\0\1\u0360\1\0\1\u036c\14\u0360"+
    "\1\u02dd\3\0\32\u0360\4\0\2\u0360\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\11\174\1\u037d"+
    "\20\174\4\0\2\174\1\0\1\u037e\1\u037f\1\u0380\3\0"+
    "\3\u0381\1\u037e\13\u0381\11\u037e\5\u0381\13\u037e\4\u0381\32\u037e"+
    "\4\u0381\1\174\1\u037e\1\u0381\17\u0370\1\u037b\4\u0370\1\u0372"+
    "\76\u0370\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\16\174\1\u0382\13\174\4\0\2\174\1\0\2\u037e"+
    "\1\u0381\3\0\3\u0381\1\u037e\13\u0381\11\u037e\5\u0381\13\u037e"+
    "\4\u0381\32\u037e\4\u0381\1\174\1\u037e\1\u0381\1\u037e\1\u037f"+
    "\1\u0380\3\0\3\u0381\1\u0383\13\u0381\1\u0384\10\u0385\5\u0381"+
    "\13\u0383\4\u0381\32\u0383\4\u0381\1\174\1\u0383\2\u0381\2\u0380"+
    "\3\0\3\u0381\1\u0383\13\u0381\1\u0386\10\u0387\5\u0381\13\u0383"+
    "\4\u0381\32\u0383\4\u0381\1\0\1\u0383\4\u0381\3\0\112\u0381"+
    "\1\0\2\u0381\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\7\174\1\u0388\22\174\4\0\2\174\1\0"+
    "\2\u0383\1\u0389\3\0\3\u0381\1\u0383\11\u0381\1\u038a\1\u0381"+
    "\11\u0383\5\u0381\13\u0383\4\u0381\32\u0383\4\u0381\1\u038b\1\u0383"+
    "\1\u0381\2\u037e\1\u0381\3\0\3\u0381\1\u037e\13\u0381\7\u038c"+
    "\2\u037e\5\u0381\13\u037e\4\u0381\27\u037e\1\u038d\2\u037e\4\u0381"+
    "\1\174\1\u037e\1\u0381\1\u037e\1\u038e\1\u038f\3\0\3\u0381"+
    "\1\u037e\13\u0381\11\u0385\5\u0381\13\u037e\4\u0381\32\u037e\4\u0381"+
    "\1\174\1\u037e\4\u0381\3\0\17\u0381\7\u0390\55\u0381\1\u0391"+
    "\6\u0381\1\0\3\u0381\2\u038f\3\0\17\u0381\11\u0387\62\u0381"+
    "\1\0\2\u0381\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\22\174\1\u0392\7\174\4\0\2\174\1\0"+
    "\1\u0381\2\u0389\3\0\15\u0381\1\u038a\74\u0381\1\0\3\u0381"+
    "\2\u038a\3\0\3\u0381\1\u0383\31\u0381\13\u0383\4\u0381\32\u0383"+
    "\4\u0381\1\0\1\u0383\1\u0381\2\u038b\1\u0393\6\0\1\u038b"+
    "\11\0\1\u0394\1\0\11\u038b\5\0\13\u038b\4\0\32\u038b"+
    "\4\0\2\u038b\1\0\1\u037e\1\u038e\1\u038f\3\0\3\u0381"+
    "\1\u037e\13\u0381\7\u038c\2\u037e\5\u0381\13\u037e\4\u0381\32\u037e"+
    "\4\u0381\1\174\1\u037e\1\u0381\2\u037e\1\u0381\3\0\3\u0381"+
    "\1\u037e\13\u0381\11\u0395\5\u0381\4\u0395\7\u037e\4\u0381\1\u037e"+
    "\6\u0395\23\u037e\4\u0381\1\174\1\u037e\1\u0381\1\u037e\1\u038e"+
    "\1\u038f\3\0\3\u0381\1\u037e\13\u0381\11\u037e\5\u0381\13\u037e"+
    "\4\u0381\32\u037e\4\u0381\1\174\1\u037e\2\u0381\2\u038f\3\0"+
    "\112\u0381\1\0\3\u0381\2\u038f\3\0\17\u0381\7\u0390\64\u0381"+
    "\1\0\5\u0381\3\0\17\u0381\11\u0396\5\u0381\4\u0396\14\u0381"+
    "\6\u0396\27\u0381\1\0\2\u0381\1\174\1\u0392\1\u0397\6\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\32\174\4\0"+
    "\2\174\2\0\2\u0393\20\0\1\u0394\100\0\2\u0394\6\0"+
    "\1\u038b\31\0\13\u038b\4\0\32\u038b\5\0\1\u038b\1\0"+
    "\1\u037e\1\u038e\1\u038f\3\0\3\u0381\1\u037e\13\u0381\11\u0395"+
    "\5\u0381\4\u0395\7\u037e\4\u0381\1\u037e\6\u0395\23\u037e\4\u0381"+
    "\1\174\1\u037e\2\u0381\2\u038f\3\0\17\u0381\11\u0396\5\u0381"+
    "\4\u0396\14\u0381\6\u0396\27\u0381\1\0\2\u0381\1\0\2\u0397"+
    "\120\0";

  private static int [] zzUnpacktrans() {
    int [] result = new int[62997];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\23\0\1\1\1\11\5\1\1\11\1\1\1\11\14\1"+
    "\1\11\3\1\2\11\3\1\1\11\3\1\10\11\2\1"+
    "\1\11\2\1\1\11\2\1\1\11\4\1\2\11\1\1"+
    "\1\11\2\1\1\11\1\1\1\11\5\1\1\11\4\1"+
    "\2\11\4\1\1\11\2\1\1\11\2\1\1\11\1\1"+
    "\1\11\3\1\1\11\1\1\1\11\2\1\3\0\2\11"+
    "\1\0\1\1\3\0\17\1\1\0\1\11\1\0\1\11"+
    "\3\1\2\0\1\11\1\1\5\0\1\1\1\11\2\0"+
    "\1\11\2\1\1\11\1\1\2\11\1\1\5\11\1\1"+
    "\3\11\1\1\1\11\1\1\2\0\1\1\1\0\1\11"+
    "\1\1\10\0\2\11\3\1\5\11\2\1\3\0\3\11"+
    "\1\1\1\0\2\11\6\0\4\1\1\0\2\11\1\1"+
    "\3\0\37\1\1\11\7\1\12\0\1\11\4\0\1\11"+
    "\2\0\2\11\5\0\1\11\2\0\1\11\1\0\2\11"+
    "\3\0\1\11\3\1\4\0\26\1\1\0\20\1\10\0"+
    "\1\11\1\0\1\11\1\0\1\11\5\0\1\11\3\0"+
    "\2\1\2\0\2\11\33\1\1\0\20\1\22\0\2\1"+
    "\1\0\1\11\27\1\1\0\11\1\1\0\7\1\11\0"+
    "\1\1\2\0\1\1\2\0\1\11\1\1\3\0\2\11"+
    "\1\0\6\1\1\0\17\1\1\0\11\1\1\0\12\1"+
    "\2\0\1\1\12\0\1\11\1\1\1\0\24\1\1\0"+
    "\11\1\4\0\7\1\2\11\7\0\2\1\4\0\10\1"+
    "\1\0\1\1\1\0\7\1\1\0\17\1\1\0\1\1"+
    "\1\0\1\1\1\0\4\1\1\11\5\0\1\11\1\1"+
    "\2\0\3\1\1\0\1\1\2\0\3\1\1\0\4\1"+
    "\1\0\24\1\2\0\1\11\5\0\4\1\4\0\2\1"+
    "\1\0\2\1\2\0\4\1\1\0\17\1\1\0\2\1"+
    "\2\0\1\1\1\11\3\0\1\11\1\1\5\0\2\1"+
    "\2\0\2\1\1\0\20\1\2\0\3\1\3\0\1\11"+
    "\1\1\2\0\1\1\1\0\2\1\2\0\1\1\1\0"+
    "\14\1\1\0\3\1\1\0\3\11\4\1\1\0\2\1"+
    "\1\0\1\11\1\1\1\0\2\1\1\0\7\1\3\0"+
    "\1\1\1\11\5\1\5\0\2\1\1\0\1\1\1\11"+
    "\1\1\1\0\1\11\5\1\1\0\30\1\1\0\3\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[919];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[Math.min(ZZ_BUFFERSIZE, zzMaxBufferLen())];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** the stack of open (nested) input streams to read from */
  private java.util.Deque<ZzFlexStreamInfo> zzStreams
    = new java.util.ArrayDeque<ZzFlexStreamInfo>();

  /**
   * inner class used to store info for nested
   * input streams
   */
  private static final class ZzFlexStreamInfo {
    java.io.Reader zzReader;
    int zzEndRead;
    int zzStartRead;
    int zzCurrentPos;
    int zzMarkedPos;
    int yyline;
    long yychar;
    int yycolumn;
    char [] zzBuffer;
    boolean zzAtBOL;
    boolean zzAtEOF;
    boolean zzEOFDone;
    int zzFinalHighSurrogate;

    /** sets all values stored in this class */
    ZzFlexStreamInfo(java.io.Reader zzReader, int zzEndRead, int zzStartRead,
                  int zzCurrentPos, int zzMarkedPos, char [] zzBuffer,
                  boolean zzAtBOL, boolean zzAtEOF, boolean zzEOFDone,
                  int zzFinalHighSurrogate, int yyline, long yychar,
                  int yycolumn) {
      this.zzReader      = zzReader;
      this.zzEndRead     = zzEndRead;
      this.zzStartRead   = zzStartRead;
      this.zzCurrentPos  = zzCurrentPos;
      this.zzMarkedPos   = zzMarkedPos;
      this.zzBuffer      = zzBuffer;
      this.zzAtBOL       = zzAtBOL;
      this.zzAtEOF       = zzAtEOF;
      this.zzEOFDone     = zzEOFDone;
      this.zzFinalHighSurrogate = zzFinalHighSurrogate;
      this.yyline        = yyline;
      this.yychar        = yychar;
      this.yycolumn      = yycolumn;
    }
  }

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  private boolean zzEOFDone;

  /* user code: */

  int balance = 0;
  int commentbalance = 0;
  int action_line = 0;
  StringBuilder actionText = new StringBuilder();

  boolean isYYEOF;
  boolean notUnix;
  boolean caseless;
  boolean inclusive_states;

  int nextState;

  boolean macroDefinition;

  Timer t = new Timer();

  @Override
  protected int lexLine() {
    return yyline;
  }

  @Override
  protected int lexColumn() {
    return yycolumn;
  }

  @Override
  protected String lexText() {
    return yytext();
  }

  @Override
  protected int lexLength() {
    return yylength();
  }

  @Override
  protected void lexPushback(int n) {
    yypushback(n);
  }

  @Override
  protected void lexPushStream(File f) throws IOException {
    // yypushStream in skeleton.nested
    yypushStream(Files.newBufferedReader(f.toPath(), Options.encoding));
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public LexScan(java.io.Reader in) {
    states.insert("YYINITIAL", true);
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate && zzCanGrow()) {
      /* if not, and it can grow: blow it up */
      char newBuffer[] = new char[Math.min(zzBuffer.length * 2, zzMaxBufferLen())];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      if (requested == 0) {
        throw new java.io.EOFException("Scan buffer limit reached ["+zzBuffer.length+"]");
      }
      else {
        throw new java.io.IOException(
            "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
      }
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;           // indicate end of file
    zzEndRead = zzStartRead;  // invalidate buffer

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Stores the current input stream on a stack, and
   * reads from a new stream. Lexical state, line,
   * char, and column counting remain untouched.
   *
   * The current input stream can be restored with
   * yypopStream (usually in an {@code <<EOF>>} action).
   *
   * @param reader the new input stream to read from
   *
   * @see #yypopStream()
   */
  public final void yypushStream(java.io.Reader reader) {
    zzStreams.push(
      new ZzFlexStreamInfo(zzReader, zzEndRead, zzStartRead, zzCurrentPos,
                        zzMarkedPos, zzBuffer, zzAtBOL, zzAtEOF, zzEOFDone,
                        zzFinalHighSurrogate, yyline, yychar, yycolumn)
    );
    zzBuffer = new char[Math.min(ZZ_BUFFERSIZE, zzMaxBufferLen())];
    zzReader = reader;
    yyResetPosition();
  }


  /**
   * Closes the current input stream and continues to
   * read from the one on top of the stream stack.
   *
   * @throws java.util.NoSuchElementException
   *         if there is no further stream to read from.
   *
   * @throws java.io.IOException
   *         if there was an error in closing the stream.
   *
   * @see #yypushStream(java.io.Reader)
   */
  public final void yypopStream() throws java.io.IOException {
    zzReader.close();
    ZzFlexStreamInfo s = (ZzFlexStreamInfo) zzStreams.pop();
    zzBuffer      = s.zzBuffer;
    zzReader      = s.zzReader;
    zzEndRead     = s.zzEndRead;
    zzStartRead   = s.zzStartRead;
    zzCurrentPos  = s.zzCurrentPos;
    zzMarkedPos   = s.zzMarkedPos;
    zzAtBOL       = s.zzAtBOL;
    zzAtEOF       = s.zzAtEOF;
    zzEOFDone     = s.zzEOFDone;
    zzFinalHighSurrogate = s.zzFinalHighSurrogate;
    yyline        = s.yyline;
    yychar        = s.yychar;
    yycolumn      = s.yycolumn;
  }


  /**
   * Returns true iff there are still streams left
   * to read from on the stream stack.
   */
  public final boolean yymoreStreams() {
    return !zzStreams.isEmpty();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to {@code ZZ_INITIAL}.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream
   *
   * @see #yypushStream(java.io.Reader)
   * @see #yypopStream()
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    int initBufferSize = Math.min(ZZ_BUFFERSIZE, zzMaxBufferLen());
    if (zzBuffer.length > initBufferSize) {
      zzBuffer = new char[initBufferSize];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }

  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
    
  yyclose();    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Symbol next_token() throws java.io.IOException
  {
    int zzInput;
    int zzAction;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      // cached fields:
      int zzCurrentPosL;
      int zzMarkedPosL = zzMarkedPos;
      int zzEndReadL = zzEndRead;
      char [] zzBufferL = zzBuffer;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':  // fall through
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            zzDoEOF();
            switch (zzLexicalState) {
            case YYINITIAL: {
              return symbol(sym.EOF);
            }  // fall though
            case 920: break;
            case COMMENT: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_COMMENT);
            }  // fall though
            case 921: break;
            case STATELIST: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_MACROS);
            }  // fall though
            case 922: break;
            case MACROS: {
              if ( yymoreStreams() ) {
                                  file = popFile();
                                  yypopStream();
                                }
                                else
                                  throw new ScannerException(file,ErrorMessages.EOF_IN_MACROS);
            }  // fall though
            case 923: break;
            case JAVA_CODE: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_ACTION, action_line-1);
            }  // fall though
            case 924: break;
            case STATES: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_STATES);
            }  // fall though
            case 925: break;
            case STRING_CONTENT: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_STRING);
            }  // fall though
            case 926: break;
            case CHARCLASS: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_REGEXP);
            }  // fall though
            case 927: break;
            case COPY: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_MACROS);
            }  // fall though
            case 928: break;
            case REPEATEXP: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_REGEXP);
            }  // fall though
            case 929: break;
            case REGEXP_CODEPOINT_SEQUENCE: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_REGEXP);
            }  // fall though
            case 930: break;
            case STRING_CODEPOINT_SEQUENCE: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_STRING);
            }  // fall though
            case 931: break;
            case CHARCLASS_CODEPOINT: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_REGEXP);
            }  // fall though
            case 932: break;
            default:
              {
                if ( yymoreStreams() ) {
             file = popFile();
             yypopStream();
           }
           else {
             return symbol(sym.EOF);
           }
              }
        }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { userCode.append(yytext());
            }
          // fall through
          case 182: break;
          case 2:
            { /* ignore */
            }
          // fall through
          case 183: break;
          case 3:
            { throw new ScannerException(file,ErrorMessages.UNEXPECTED_CHAR, yyline, yycolumn);
            }
          // fall through
          case 184: break;
          case 4:
            { 
            }
          // fall through
          case 185: break;
          case 5:
            { yybegin(MACROS);
            }
          // fall through
          case 186: break;
          case 6:
            { states.insert(yytext(),inclusive_states);
            }
          // fall through
          case 187: break;
          case 7:
            { return symbol(sym.IDENT, yytext());
            }
          // fall through
          case 188: break;
          case 8:
            { throw new ScannerException(file,ErrorMessages.UNKNOWN_OPTION, yyline, yycolumn);
            }
          // fall through
          case 189: break;
          case 9:
            { yybegin(REGEXP);
                                return symbol(sym.EQUALS);
            }
          // fall through
          case 190: break;
          case 10:
            { yybegin(STATES); return symbol_countUpdate(sym.LESSTHAN, null);
            }
          // fall through
          case 191: break;
          case 11:
            { return symbol_countUpdate(sym.RBRACE, null);
            }
          // fall through
          case 192: break;
          case 12:
            { yypushback(yylength()); yybegin(REGEXP);
            }
          // fall through
          case 193: break;
          case 13:
            { return symbol(sym.CHAR, yytext().codePointAt(0));
            }
          // fall through
          case 194: break;
          case 14:
            { if (macroDefinition) { yybegin(MACROS); } return symbol(sym.REGEXPEND);
            }
          // fall through
          case 195: break;
          case 15:
            { return symbol(sym.BANG);
            }
          // fall through
          case 196: break;
          case 16:
            { string.setLength(0); nextState = REGEXP; yybegin(STRING_CONTENT);
            }
          // fall through
          case 197: break;
          case 17:
            { return symbol(sym.DOLLAR);
            }
          // fall through
          case 198: break;
          case 18:
            { return symbol(sym.OPENBRACKET);
            }
          // fall through
          case 199: break;
          case 19:
            { return symbol(sym.CLOSEBRACKET);
            }
          // fall through
          case 200: break;
          case 20:
            { return symbol(sym.STAR);
            }
          // fall through
          case 201: break;
          case 21:
            { return symbol(sym.PLUS);
            }
          // fall through
          case 202: break;
          case 22:
            { return symbol(sym.POINT);
            }
          // fall through
          case 203: break;
          case 23:
            { return symbol(sym.LOOKAHEAD);
            }
          // fall through
          case 204: break;
          case 24:
            { return symbol(sym.QUESTION);
            }
          // fall through
          case 205: break;
          case 25:
            { yybegin(CHARCLASS); return symbol(sym.OPENCLASS);
            }
          // fall through
          case 206: break;
          case 26:
            { bolUsed = true; return symbol(sym.HAT);
            }
          // fall through
          case 207: break;
          case 27:
            { yybegin(REGEXPSTART); return symbol(sym.LBRACE);
            }
          // fall through
          case 208: break;
          case 28:
            { return symbol(sym.BAR);
            }
          // fall through
          case 209: break;
          case 29:
            { return symbol(sym.TILDE);
            }
          // fall through
          case 210: break;
          case 30:
            { actionText.append(yytext());
            }
          // fall through
          case 211: break;
          case 31:
            { balance++; actionText.append('{');
            }
          // fall through
          case 212: break;
          case 32:
            { if (balance > 0) {
                 balance--;
                 actionText.append('}');
               }
               else {
                 yybegin(REGEXPSTART);
                 Action a = new Action(actionText.toString(), action_line);
                 actions.add(a);
                 return symbol(sym.ACTION, a);
               }
            }
          // fall through
          case 213: break;
          case 33:
            { return symbol(sym.COMMA);
            }
          // fall through
          case 214: break;
          case 34:
            { yybegin(REGEXP); return symbol(sym.MORETHAN);
            }
          // fall through
          case 215: break;
          case 35:
            { string.append(yytext());
            }
          // fall through
          case 216: break;
          case 36:
            { throw new ScannerException(file,ErrorMessages.UNTERMINATED_STR, yyline, yycolumn);
            }
          // fall through
          case 217: break;
          case 37:
            { yybegin(nextState); return symbol(sym.STRING, string.toString());
            }
          // fall through
          case 218: break;
          case 38:
            { throw new ScannerException(file,ErrorMessages.EOL_IN_CHARCLASS,yyline,yycolumn);
            }
          // fall through
          case 219: break;
          case 39:
            { throw new ScannerException(file,ErrorMessages.UNEXPECTED_NL, yyline, yycolumn);
            }
          // fall through
          case 220: break;
          case 40:
            { string.setLength(0); nextState = CHARCLASS; yybegin(STRING_CONTENT);
            }
          // fall through
          case 221: break;
          case 41:
            { return symbol(sym.DASH);
            }
          // fall through
          case 222: break;
          case 42:
            { balance++; return symbol(sym.OPENCLASS);
            }
          // fall through
          case 223: break;
          case 43:
            { if (balance > 0) balance--; else yybegin(REGEXP); return symbol(sym.CLOSECLASS);
            }
          // fall through
          case 224: break;
          case 44:
            { return symbol(sym.HAT);
            }
          // fall through
          case 225: break;
          case 45:
            { yybegin(REGEXP); return symbol(sym.RBRACE);
            }
          // fall through
          case 226: break;
          case 46:
            { yybegin(REGEXP);
            }
          // fall through
          case 227: break;
          case 47:
            { throw new ScannerException(file,ErrorMessages.CTOR_ARG,yyline,yycolumn);
            }
          // fall through
          case 228: break;
          case 48:
            { yybegin(MACROS); ctorArgs.add(yytext().trim());
            }
          // fall through
          case 229: break;
          case 49:
            { int codePoint = Integer.parseInt(yytext(), 16);
                    if (codePoint <= getMaximumCodePoint()) {
                      string.append(Character.toChars(codePoint));
                    } else {
                      throw new ScannerException(file,ErrorMessages.CODEPOINT_OUT_OF_RANGE, yyline, yycolumn);
                    }
            }
          // fall through
          case 230: break;
          case 50:
            { yybegin(REGEXP); return symbol(sym.STRING, string.toString());
            }
          // fall through
          case 231: break;
          case 51:
            { int codePoint = Integer.parseInt(yytext(), 16);
                    if (codePoint <= getMaximumCodePoint()) {
                      string.append(Character.toChars(codePoint));
                    } else {
                      throw new ScannerException(file, ErrorMessages.CODEPOINT_OUT_OF_RANGE, yyline, yycolumn);
                    }
            }
          // fall through
          case 232: break;
          case 52:
            { yybegin(STRING_CONTENT);
            }
          // fall through
          case 233: break;
          case 53:
            { t.start();
                             yybegin(MACROS);
                             macroDefinition = true;
                             return symbol(sym.USERCODE,userCode);
            }
          // fall through
          case 234: break;
          case 54:
            { if (commentbalance > 0)
                commentbalance--;
              else
                yybegin(nextState);
            }
          // fall through
          case 235: break;
          case 55:
            { commentbalance++;
            }
          // fall through
          case 236: break;
          case 56:
            { nextState = MACROS; yybegin(COMMENT);
            }
          // fall through
          case 237: break;
          case 57:
            { Out.warning(ErrorMessages.NOT_AT_BOL, yyline); yypushback(1);
            }
          // fall through
          case 238: break;
          case 58:
            { macroDefinition = false;
                                yybegin(REGEXPSTART);
                                return symbol(sym.DELIMITER);
            }
          // fall through
          case 239: break;
          case 59:
            { nextState = REGEXPSTART; yybegin(COMMENT);
            }
          // fall through
          case 240: break;
          case 60:
            { actionText.setLength(0); yybegin(JAVA_CODE); action_line = yyline+1; return symbol(sym.REGEXPEND);
            }
          // fall through
          case 241: break;
          case 61:
            { nextState = REGEXP; yybegin(COMMENT);
            }
          // fall through
          case 242: break;
          case 62:
            { return symbol(sym.CHAR, yytext().codePointAt(1));
            }
          // fall through
          case 243: break;
          case 63:
            { return symbol(sym.CHAR, Integer.parseInt(yytext().substring(1,yylength()), 8));
            }
          // fall through
          case 244: break;
          case 64:
            { return symbol(sym.DIGITCLASSNOT);
            }
          // fall through
          case 245: break;
          case 65:
            { return symbol(sym.NEWLINE);
            }
          // fall through
          case 246: break;
          case 66:
            { return symbol(sym.WHITESPACECLASSNOT);
            }
          // fall through
          case 247: break;
          case 67:
            { return symbol(sym.WORDCLASSNOT);
            }
          // fall through
          case 248: break;
          case 68:
            { return symbol(sym.CHAR, (int)'\b');
            }
          // fall through
          case 249: break;
          case 69:
            { return symbol(sym.DIGITCLASS);
            }
          // fall through
          case 250: break;
          case 70:
            { return symbol(sym.CHAR, (int)'\f');
            }
          // fall through
          case 251: break;
          case 71:
            { return symbol(sym.CHAR, (int)'\n');
            }
          // fall through
          case 252: break;
          case 72:
            { return symbol(sym.CHAR, (int)'\r');
            }
          // fall through
          case 253: break;
          case 73:
            { return symbol(sym.WHITESPACECLASS);
            }
          // fall through
          case 254: break;
          case 74:
            { return symbol(sym.CHAR, (int)'\t');
            }
          // fall through
          case 255: break;
          case 75:
            { return symbol(sym.WORDCLASS);
            }
          // fall through
          case 256: break;
          case 76:
            { yybegin(REPEATEXP);
                                   return symbol(sym.REPEAT,
                                                 Integer.valueOf(yytext().trim().substring(1).trim()));
            }
          // fall through
          case 257: break;
          case 77:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -1);
            { if (macroDefinition) {
                              yybegin(EATWSPNL);
                              return symbol(sym.BAR);
                            }
                            else {
                              yybegin(REGEXPSTART);
                              return symbol(sym.NOACTION);
                            }
            }
          // fall through
          case 258: break;
          case 78:
            { string.append(yytext().substring(1, yytext().offsetByCodePoints(1, 1)));
            }
          // fall through
          case 259: break;
          case 79:
            { string.append('\"');
            }
          // fall through
          case 260: break;
          case 80:
            { string.append( (char) Integer.parseInt(yytext().substring(1,yylength()), 8));
            }
          // fall through
          case 261: break;
          case 81:
            { string.append('\b');
            }
          // fall through
          case 262: break;
          case 82:
            { string.append('\f');
            }
          // fall through
          case 263: break;
          case 83:
            { string.append('\n');
            }
          // fall through
          case 264: break;
          case 84:
            { string.append('\r');
            }
          // fall through
          case 265: break;
          case 85:
            { string.append('\t');
            }
          // fall through
          case 266: break;
          case 86:
            { return symbol(sym.INTERSECTION);
            }
          // fall through
          case 267: break;
          case 87:
            { return symbol(sym.DIFFERENCE);
            }
          // fall through
          case 268: break;
          case 88:
            { yypushback(1); yycolumn--; return symbol(sym.CHAR, (int)'-');
            }
          // fall through
          case 269: break;
          case 89:
            { /* union is the default operation - '||' can be ignored */
            }
          // fall through
          case 270: break;
          case 90:
            { return symbol(sym.SYMMETRICDIFFERENCE);
            }
          // fall through
          case 271: break;
          case 91:
            { return symbol(sym.REPEAT, Integer.valueOf(yytext().substring(1).trim()));
            }
          // fall through
          case 272: break;
          case 92:
            { int codePoint = Integer.parseInt(yytext().substring(0, yylength() - 1), 16);
                        if (codePoint <= getMaximumCodePoint()) {
                          yybegin(CHARCLASS);
                          return symbol(sym.CHAR, codePoint);
                        } else {
                          throw new ScannerException(file, ErrorMessages.CODEPOINT_OUT_OF_RANGE, yyline, yycolumn);
                        }
            }
          // fall through
          case 273: break;
          case 93:
            { string.setLength(0); yybegin(COPY);
            }
          // fall through
          case 274: break;
          case 94:
            { inclusive_states = true; yybegin(STATELIST);
            }
          // fall through
          case 275: break;
          case 95:
            { inclusive_states = false; yybegin(STATELIST);
            }
          // fall through
          case 276: break;
          case 96:
            { string.setLength(0); yybegin(REGEXP_CODEPOINT_SEQUENCE);
            }
          // fall through
          case 277: break;
          case 97:
            { return symbol_countUpdate(sym.MACROUSE, makeMacroIdent());
            }
          // fall through
          case 278: break;
          case 98:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -2);
            { if (macroDefinition) {
                              yybegin(EATWSPNL);
                              return symbol(sym.BAR);
                            }
                            else {
                              yybegin(REGEXPSTART);
                              return symbol(sym.NOACTION);
                            }
            }
          // fall through
          case 279: break;
          case 99:
            { yybegin(STRING_CODEPOINT_SEQUENCE);
            }
          // fall through
          case 280: break;
          case 100:
            { yybegin(CHARCLASS_CODEPOINT);
            }
          // fall through
          case 281: break;
          case 101:
            { return symbol(sym.MACROUSE, yytext().substring(1,yylength()-1));
            }
          // fall through
          case 282: break;
          case 102:
            { classCode = conc(classCode,string);  yybegin(MACROS);
            }
          // fall through
          case 283: break;
          case 103:
            { cupCompatible = true;
                                isImplementing = concExc(isImplementing, "java_cup.runtime.Scanner");
                                if (functionName == null)
                                  functionName = "next_token";
                                if (tokenType == null)
                                  tokenType = "java_cup.runtime.Symbol";
                                if (eofVal == null)
                                  eofVal = "return new java_cup.runtime.Symbol("+cupSymbol+".EOF);";
                                if (!Options.jlex) eofclose = true;
            }
          // fall through
          case 284: break;
          case 104:
            { isInteger = true;
            }
          // fall through
          case 285: break;
          case 105:
            { String trimmedText = yytext().trim();
                                 String propertyValue = trimmedText.substring(3,trimmedText.length()-1);
                                 IntCharSet set = getIntCharSet(propertyValue);
                                 if (null == set) {
                                   throw new ScannerException(file,ErrorMessages.INVALID_UNICODE_PROPERTY, yyline, yycolumn + 3);
                                 }
                                 return symbol(sym.UNIPROPCCLASSNOT, propertyValue);
            }
          // fall through
          case 286: break;
          case 106:
            { String trimmedText = yytext().trim();
                                 String propertyValue = trimmedText.substring(3,trimmedText.length()-1);
                                 IntCharSet set = getIntCharSet(propertyValue);
                                 if (null == set) {
                                   throw new ScannerException(file,ErrorMessages.INVALID_UNICODE_PROPERTY, yyline, yycolumn + 3);
                                 }
                                 return symbol(sym.UNIPROPCCLASS, propertyValue);
            }
          // fall through
          case 287: break;
          case 107:
            { return symbol(sym.CHAR, Integer.parseInt(yytext().substring(2,yylength()), 16));
            }
          // fall through
          case 288: break;
          case 108:
            { string.append( (char) Integer.parseInt(yytext().substring(2,yylength()), 16));
            }
          // fall through
          case 289: break;
          case 109:
            { initCharClasses(CharSetSize.SEVEN_BIT);
            }
          // fall through
          case 290: break;
          case 110:
            { initCharClasses(CharSetSize.EIGHT_BIT);
            }
          // fall through
          case 291: break;
          case 111:
            { charCount = true;
            }
          // fall through
          case 292: break;
          case 112:
            { cup2Compatible = true;
                                isImplementing = concExc(isImplementing, "Scanner");
                                lineCount = true;
                                columnCount = true;
                                if (functionName == null)
                                  functionName = "readNextTerminal";
                                if (tokenType == null)
                                  tokenType = "ScannerToken<? extends Object>";
                                if (eofVal == null)
                                  eofVal = "return token(SpecialTerminals.EndOfInputStream);";
                                if (!Options.jlex) eofclose = true;
                                // %unicode:
                                initCharClasses(CharSetSize.UNICODE);
            }
          // fall through
          case 293: break;
          case 113:
            { lineCount = true;
            }
          // fall through
          case 294: break;
          case 114:
            { /* no-op - this is the only generation method */
            }
          // fall through
          case 295: break;
          case 115:
            { initCharClasses(CharSetSize.UNICODE);
            }
          // fall through
          case 296: break;
          case 116:
            { debugOption = true;
            }
          // fall through
          case 297: break;
          case 117:
            { isFinal = true;
            }
          // fall through
          case 298: break;
          case 118:
            { throw new ScannerException(file, ErrorMessages.NOT_A_WARNING_ID, yyline);
            }
          // fall through
          case 299: break;
          case 119:
            { isYYEOF = true;
            }
          // fall through
          case 300: break;
          case 120:
            { maybeWarnUnicodeMatch(4);
                return symbol(sym.CHAR, Integer.parseInt(yytext().substring(2,6), 16));
            }
          // fall through
          case 301: break;
          case 121:
            { maybeWarnUnicodeMatch(4);
                string.append( (char) Integer.parseInt(yytext().substring(2,6), 16));
            }
          // fall through
          case 302: break;
          case 122:
            { eofCode = conc(eofCode,string); yybegin(MACROS);
            }
          // fall through
          case 303: break;
          case 123:
            { isInteger = true;
                                if (eofVal == null)
                                  eofVal = "return 0;";
                                eofclose = true;
            }
          // fall through
          case 304: break;
          case 124:
            { columnCount = true;
            }
          // fall through
          case 305: break;
          case 125:
            { isPublic = true;
            }
          // fall through
          case 306: break;
          case 126:
            { tokenType = yytext().substring(6).trim();
            }
          // fall through
          case 307: break;
          case 127:
            { OptionUtils.enableWarning(yytext().substring(6).trim());
            }
          // fall through
          case 308: break;
          case 128:
            { throw new ScannerException(file,ErrorMessages.EOF_WO_ACTION);
            }
          // fall through
          case 309: break;
          case 129:
            { initCode = conc(initCode,string);    yybegin(MACROS);
            }
          // fall through
          case 310: break;
          case 130:
            { throw new ScannerException(file,ErrorMessages.NO_BUFFER_SIZE, yyline);
            }
          // fall through
          case 311: break;
          case 131:
            { className = yytext().substring(7).trim();
            }
          // fall through
          case 312: break;
          case 132:
            { throw new ScannerException(file,ErrorMessages.QUIL_CUPSYM, yyline);
            }
          // fall through
          case 313: break;
          case 133:
            { isIntWrap = true;
            }
          // fall through
          case 314: break;
          case 134:
            { notUnix = true;
            }
          // fall through
          case 315: break;
          case 135:
            { throw new ScannerException(file,ErrorMessages.QUIL_THROW, yyline);
            }
          // fall through
          case 316: break;
          case 136:
            { String v = yytext().substring(8).trim();
                                       initCharClasses(CharSetSize.UNICODE, v);
            }
          // fall through
          case 317: break;
          case 137:
            { actionText.setLength(0); yybegin(JAVA_CODE);
                                   Symbol s = symbol_countUpdate(sym.EOFRULE, null);
                                   action_line = s.left+1;
                                   return s;
            }
          // fall through
          case 318: break;
          case 138:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -1);
            { yybegin(REGEXP); return symbol(sym.EOFRULE);
            }
          // fall through
          case 319: break;
          case 139:
            { maybeWarnUnicodeMatch(6);
                int codePoint = Integer.parseInt(yytext().substring(2,8), 16);
                if (codePoint <= getMaximumCodePoint()) {
                  return symbol(sym.CHAR, codePoint);
                } else {
                  throw new ScannerException(file,ErrorMessages.CODEPOINT_OUT_OF_RANGE, yyline, yycolumn+2);
                }
            }
          // fall through
          case 320: break;
          case 140:
            { maybeWarnUnicodeMatch(6);
                int codePoint = Integer.parseInt(yytext().substring(2,8), 16);
                if (codePoint <= getMaximumCodePoint()) {
                  string.append(Character.toChars(codePoint));
                } else {
                  throw new ScannerException(file,ErrorMessages.CODEPOINT_OUT_OF_RANGE, yyline, yycolumn+2);
                }
            }
          // fall through
          case 321: break;
          case 141:
            { isAbstract = true;
            }
          // fall through
          case 322: break;
          case 142:
            { bufferSize = Integer.parseInt(yytext().substring(8).trim());
            }
          // fall through
          case 323: break;
          case 143:
            { caseless = true;
            }
          // fall through
          case 324: break;
          case 144:
            { cupDebug = true;
            }
          // fall through
          case 325: break;
          case 145:
            { cupSymbol = yytext().substring(8).trim();
                                if (cupCompatible) Out.warning(ErrorMessages.CUPSYM_AFTER_CUP, yyline);
            }
          // fall through
          case 326: break;
          case 146:
            { eofclose = true;
            }
          // fall through
          case 327: break;
          case 147:
            { includeFile(yytext().substring(9).trim());
            }
          // fall through
          case 328: break;
          case 148:
            { lexThrow.add(yytext().substring(8).trim());
            }
          // fall through
          case 329: break;
          case 149:
            { OptionUtils.enableAllWarnings();
            }
          // fall through
          case 330: break;
          case 150:
            { includeFile(yytext().trim().substring(9).trim());
            }
          // fall through
          case 331: break;
          case 151:
            { actionText.setLength(0);
                            yybegin(JAVA_CODE);
                            action_line = yyline+1;
                            return symbol(sym.EOFRULE);
            }
          // fall through
          case 332: break;
          case 152:
            { eofVal = string.toString(); yybegin(MACROS);
            }
          // fall through
          case 333: break;
          case 153:
            { throw new ScannerException(file,ErrorMessages.QUIL_EOFTHROW, yyline);
            }
          // fall through
          case 334: break;
          case 154:
            { isExtending = yytext().substring(9).trim();
            }
          // fall through
          case 335: break;
          case 155:
            { OptionUtils.suppressWarning(yytext().substring(9).trim());
            }
          // fall through
          case 336: break;
          case 156:
            { return symbol(sym.LETTERCLASS);
            }
          // fall through
          case 337: break;
          case 157:
            { visibility = "private"; Skeleton.makePrivate();
            }
          // fall through
          case 338: break;
          case 158:
            { yybegin(CTOR_ARG); ctorTypes.add(yytext().substring(8).trim());
            }
          // fall through
          case 339: break;
          case 159:
            { eofThrow = concExc(eofThrow,yytext().substring(10).trim());
            }
          // fall through
          case 340: break;
          case 160:
            { functionName = yytext().substring(10).trim();
            }
          // fall through
          case 341: break;
          case 161:
            { throw new ScannerException(file,ErrorMessages.QUIL_INITTHROW, yyline);
            }
          // fall through
          case 342: break;
          case 162:
            { throw new ScannerException(file,ErrorMessages.QUIL_SCANERROR, yyline);
            }
          // fall through
          case 343: break;
          case 163:
            { standalone = true; isInteger = true;
            }
          // fall through
          case 344: break;
          case 164:
            { OptionUtils.suppressWarning(yytext().substring(10).trim());
            }
          // fall through
          case 345: break;
          case 165:
            { return symbol(sym.JLETTERCLASS);
            }
          // fall through
          case 346: break;
          case 166:
            { eofThrow = concExc(eofThrow,string); yybegin(MACROS);
            }
          // fall through
          case 347: break;
          case 167:
            { isImplementing = concExc(isImplementing, yytext().substring(12).trim());
            }
          // fall through
          case 348: break;
          case 168:
            { initThrow = concExc(initThrow,yytext().substring(11).trim());
            }
          // fall through
          case 349: break;
          case 169:
            { OptionUtils.suppressAllWarnings();
            }
          // fall through
          case 350: break;
          case 170:
            { scanErrorException = yytext().substring(11).trim();
            }
          // fall through
          case 351: break;
          case 171:
            { throw new ScannerException(file,ErrorMessages.QUIL_YYLEXTHROW, yyline);
            }
          // fall through
          case 352: break;
          case 172:
            { initThrow = concExc(initThrow,string);  yybegin(MACROS);
            }
          // fall through
          case 353: break;
          case 173:
            { lexThrow.add(yytext().substring(12).trim());
            }
          // fall through
          case 354: break;
          case 174:
            { return symbol(sym.LOWERCLASS);
            }
          // fall through
          case 355: break;
          case 175:
            { return symbol(sym.UPPERCLASS);
            }
          // fall through
          case 356: break;
          case 176:
            { lexThrow.add(string.toString()); yybegin(MACROS);
            }
          // fall through
          case 357: break;
          case 177:
            { eofclose = false;
            }
          // fall through
          case 358: break;
          case 178:
            { return symbol(sym.JLETTERDIGITCLASS);
            }
          // fall through
          case 359: break;
          case 179:
            { throw new ScannerException(file, ErrorMessages.TOKEN_SIZE_LIMIT, yyline);
            }
          // fall through
          case 360: break;
          case 180:
            { tokenSizeLimit = yytext().substring(18).trim();
            }
          // fall through
          case 361: break;
          case 181:
            { noSuppressWarnings = true;
            }
          // fall through
          case 362: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }

  /**
   * Converts an int token code into the name of the
   * token by reflection on the cup symbol class/interface sym
   */
  private static String getTokenName(int token) {
    try {
      java.lang.reflect.Field [] classFields = sym.class.getFields();
      for (int i = 0; i < classFields.length; i++) {
        if (classFields[i].getInt(null) == token) {
          return classFields[i].getName();
        }
      }
    } catch (Exception e) {
      e.printStackTrace(System.err);
    }

    return "UNKNOWN TOKEN";
  }

  /**
   * Same as next_token but also prints the token to standard out
   * for debugging.
   */
  public Symbol debug_next_token() throws java.io.IOException {
    Symbol s = next_token();
    System.out.println( "line:" + (yyline+1) + " col:" + (yycolumn+1) + " --"+ yytext() + "--" + getTokenName(s.sym) + "--");
    return s;
  }

  /**
   * Runs the scanner on input files.
   *
   * This main method is the debugging routine for the scanner.
   * It prints debugging information about each returned token to
   * System.out until the end of file is reached, or an error occured.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String[] argv) {
    if (argv.length == 0) {
      System.out.println("Usage : java LexScan [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          // Side-effect: is encodingName valid?
          java.nio.charset.Charset.forName(encodingName);
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        LexScan scanner = null;
        java.io.FileInputStream stream = null;
        java.io.Reader reader = null;
        try {
          stream = new java.io.FileInputStream(argv[i]);
          reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new LexScan(reader);
          while ( !scanner.zzAtEOF ) scanner.debug_next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
        finally {
          if (reader != null) {
            try {
              reader.close();
            }
            catch (java.io.IOException e) {
              System.out.println("IO error closing file \""+argv[i]+"\"");
              System.out.println(e);
            }
          }
          if (stream != null) {
            try {
              stream.close();
            }
            catch (java.io.IOException e) {
              System.out.println("IO error closing file \""+argv[i]+"\"");
              System.out.println(e);
            }
          }
        }
      }
    }
  }


}
