/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * spherical radial offset.
 * This formula contains analytic aux.DE and aux.r-dz

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_spherical_offset.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSphericalOffsetIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	// if (-length(z) > -1e-21f) -length(z) = -1e-21f;   //  z is neg.)
	z *= 1.0f + fractal->transformCommon.offset / -length(z);
	z *= fractal->transformCommon.scale;
	aux->DE = aux->DE * fractal->transformCommon.scale + fractal->analyticDE.offset1;
	return z;
}