/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2022 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Buddhi Mandelbox SphericalFoldSmooth

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_spherical_fold_smooth.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSphericalFoldSmoothIteration(
	REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 oldZ = z;
	REAL m = 1.0f;
	REAL t = 1.0f;
	REAL rr = dot(z, z);

	z += fractal->transformCommon.offset000;

	if (fractal->transformCommon.functionEnabledCxFalse
			&& aux->i >= fractal->transformCommon.startIterationsS
			&& aux->i < fractal->transformCommon.stopIterationsS)
	{
		if (rr < fractal->transformCommon.minR2p25)
			m = fractal->transformCommon.maxMinR2factor;
		else if (rr < fractal->transformCommon.maxR2d1)
			m = fractal->transformCommon.maxR2d1 / rr;
		z *= m;
		aux->DE *= m;
	}

	if (fractal->transformCommon.functionEnabledCy
			&& aux->i >= fractal->transformCommon.startIterationsX
			&& aux->i < fractal->transformCommon.stopIterationsX)
	{
		rr = dot(z, z);
		z += fractal->transformCommon.offsetA000;
		REAL rk1 = SmoothConditionALessB(
			rr, fractal->transformCommon.minR2p25, fractal->transformCommon.scaleA3);
		REAL sm1 = fractal->transformCommon.maxMinR2factor * rk1 + 1.0f - rk1;
		t = 1.0f;
		if (aux->i >= fractal->transformCommon.startIterationsY
				&& aux->i < fractal->transformCommon.stopIterationsY)
		{
			REAL rk2 = SmoothConditionALessB(
				rr, fractal->transformCommon.maxR2d1, fractal->transformCommon.scaleB3);
			REAL rk21 = (1.0f - rk1) * rk2;
			t = 1.0f - rk21 + fractal->transformCommon.maxR2d1 / rr * rk21;
		}
		t *= sm1;
		z *= t;
		aux->DE *= t;
		z -= fractal->transformCommon.offsetA000;
	}

	z -= fractal->transformCommon.offset000;

	if (fractal->foldColor.auxColorEnabledFalse && aux->i >= fractal->foldColor.startIterationsA
			&& aux->i < fractal->foldColor.stopIterationsA)
	{
		REAL colorAdd = 0.0f;
		oldZ = fabs(oldZ - z);
		colorAdd += oldZ.x * fractal->foldColor.difs0000.x;
		colorAdd += oldZ.y * fractal->foldColor.difs0000.y;
		colorAdd += oldZ.z * fractal->foldColor.difs0000.z;
		colorAdd += t * m * fractal->foldColor.difs0000.w;
		if (!fractal->foldColor.auxColorEnabled)
			aux->color = colorAdd;
		else
			aux->color += colorAdd;
	}

	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	return z;
}