/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2024 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * scale vary V2.12.- based on DarkBeam's maths
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_scale_vary_v212.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfScaleVaryV212Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (aux->i >= fractal->transformCommon.startIterations
			&& aux->i < fractal->transformCommon.stopIterations)
	{
		if (fractal->transformCommon.functionEnabledBxFalse)
		{
			aux->actualScaleA = fabs(aux->actualScaleA);
		}
		aux->actualScaleA =
			fractal->transformCommon.scaleMain2 + fractal->transformCommon.scaleVary0 * aux->actualScaleA;
		REAL temp = aux->actualScaleA;
		if (fractal->transformCommon.functionEnabledByFalse) // limits
		{
			if (aux->actualScaleA < fractal->transformCommon.offset0)
				temp = fractal->transformCommon.offset0;
			if (aux->actualScaleA > fractal->transformCommon.offset4)
				temp = fractal->transformCommon.offset4;
		}

		z *= temp;
		aux->DE = aux->DE * fabs(temp) + fractal->analyticDE.offset1;
	}

	else if (aux->i < fractal->transformCommon.startIterations)
	{
		z *= fractal->transformCommon.scaleMain2;
		aux->DE = aux->DE * fabs(fractal->transformCommon.scaleMain2) + fractal->analyticDE.offset1;
	}
	else
	{
		if (fractal->transformCommon.functionEnabledBzFalse)
		{
			aux->actualScaleA = fractal->transformCommon.scaleMain2;
		}
		z *= aux->actualScaleA;
		aux->DE = aux->DE * fabs(aux->actualScaleA) + fractal->analyticDE.offset1;
	}
	return z;
}