<!-- If you want to modify sections/contents permanently, you should modify both
ReleaseNotes.md and ReleaseNotesTemplate.txt. -->

# Flang {{version}} {{in_progress}}Release Notes

````{only} PreRelease
```{warning}
 These are in-progress notes for the upcoming LLVM {{version}} release.
 Release notes for previous releases can be found on [the Download
 Page](https://releases.llvm.org/download.html).
```
````

## Introduction

This document contains the release notes for the Flang Fortran frontend,
part of the LLVM Compiler Infrastructure, release {{version}}. Here we
describe the status of Flang in some detail, including major
improvements from the previous release and new feature work. For the
general LLVM release notes, see [the LLVM
documentation](https://llvm.org/docs/ReleaseNotes.html). All LLVM
releases may be downloaded from the [LLVM releases web
site](https://llvm.org/releases/).

Note that if you are reading this file from a Git checkout, this
document applies to the *next* release, not the current one. To see the
release notes for a specific release, please see the [releases
page](https://llvm.org/releases/).

## Major New Features

* Support for LOWER= argument for C_F_POINTER.
* Experimental support for multi-image program launch, collective subroutines,
  synchronization, teams, and image enumeration.

## Bug Fixes

## Non-comprehensive list of changes in this release

## New Compiler Flags

* -fexperimental-loop-fusion is now recognized by flang.
* -fcoarray activates experimental multi-image support in flang.

## Windows Support

## Fortran Language Changes in Flang

## Build System Changes

## New Issues Found

## Additional Information

Flang's documentation is located in the `flang/docs/` directory in the
LLVM monorepo.

If you have any questions or comments about Flang, please feel free to
contact us on the [Discourse
forums](https://discourse.llvm.org/c/subprojects/flang/33).
