import { ForwardedRef, PropsWithChildren, ReactElement, RefObject } from "react";
import { TNode } from "./utils";
import { TCascadeMenuForwardRef, TMeta, TStylingProps } from "./index";
import { TCascadeOption, TCascadeOptionProps } from "./CascadeOption";
type TCascadeMenuProps<Meta extends TMeta> = Omit<TCascadeOptionProps<Meta>, "option"> & TStylingProps & {
    options: TCascadeOption<Meta>[];
    isInitiallyOpen?: boolean;
    openerOptionNode?: TNode;
    openerOptionElementRef?: RefObject<HTMLDivElement>;
    openerMenuRef?: RefObject<HTMLDivElement>;
};
export declare function CascadeMenuBaseRaw<Meta extends TMeta = object>({ isInitiallyOpen, openerMenuRef, ...props }: TCascadeMenuProps<Meta>, ref: ForwardedRef<TCascadeMenuForwardRef>): import("react/jsx-runtime").JSX.Element;
export declare const CascadeMenuBase: <Meta extends TMeta = object>({ isInitiallyOpen, ...props }: TCascadeMenuProps<Meta> & {
    ref?: ForwardedRef<TCascadeMenuForwardRef>;
}) => ReactElement;
export declare function CascadeMenuOpenerRaw<Meta extends TMeta = object>(props: PropsWithChildren<TCascadeMenuProps<Meta>>, ref: React.ForwardedRef<TCascadeMenuForwardRef>): import("react/jsx-runtime").JSX.Element;
export declare const CascadeMenuOpener: <Meta extends TMeta = object>(props: PropsWithChildren<TCascadeMenuProps<Meta>> & {
    ref?: ForwardedRef<TCascadeMenuForwardRef>;
}) => ReactElement;
export {};
//# sourceMappingURL=CascadeMenu.d.ts.map