/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.auth;

import java.time.Instant;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class AuthCredentialPresentation
extends ByteArray {
    public AuthCredentialPresentation(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.AuthCredentialPresentation_CheckValidContents(contents));
    }

    public UuidCiphertext getUuidCiphertext() {
        byte[] newContents = Native.AuthCredentialPresentation_GetUuidCiphertext(this.contents);
        try {
            return new UuidCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public UuidCiphertext getPniCiphertext() {
        byte[] newContents = Native.AuthCredentialPresentation_GetPniCiphertext(this.contents);
        try {
            return new UuidCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Instant getRedemptionTime() {
        return Instant.ofEpochSecond(Native.AuthCredentialPresentation_GetRedemptionTime(this.contents));
    }

    public Version getVersion() {
        byte version = this.contents[0];
        Version[] values = Version.values();
        if (version < values.length) {
            return values[version];
        }
        return Version.UNKNOWN;
    }

    public static enum Version {
        V1,
        V2,
        V3,
        V4,
        UNKNOWN;

    }
}

