/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.output;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.util.Util;

public class JsonWriterImpl
implements JsonWriter {
    private final Writer writer;
    private final ObjectMapper objectMapper;

    public JsonWriterImpl(Writer writer) {
        this.writer = writer;
        this.objectMapper = Util.createJsonObjectMapper();
    }

    @Override
    public synchronized void write(Object object) {
        try {
            try {
                this.objectMapper.writeValue(this.writer, object);
            }
            catch (JsonProcessingException e) {
                throw new AssertionError((Object)e);
            }
            this.writer.write(System.lineSeparator());
            this.writer.flush();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

