/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.asamk.signal.commands.JsonRpcMultiCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.manager.ProvisioningManager;
import org.asamk.signal.manager.api.UserAlreadyExistsException;
import org.asamk.signal.output.JsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinishLinkCommand
implements JsonRpcMultiCommand<FinishLinkParams> {
    private static final Logger logger = LoggerFactory.getLogger(FinishLinkCommand.class);

    @Override
    public String getName() {
        return "finishLink";
    }

    @Override
    public TypeReference<FinishLinkParams> getRequestType() {
        return new TypeReference<FinishLinkParams>(this){};
    }

    @Override
    public void handleCommand(FinishLinkParams request, MultiAccountManager m, JsonWriter jsonWriter) throws CommandException {
        String number;
        URI deviceLinkUri;
        if (request.deviceLinkUri() == null) {
            throw new UserErrorException("Missing deviceLinkUri.");
        }
        try {
            deviceLinkUri = new URI(request.deviceLinkUri());
        }
        catch (URISyntaxException e) {
            throw new UserErrorException("Invalid device link uri.");
        }
        ProvisioningManager provisioningManager = m.getProvisioningManagerFor(deviceLinkUri);
        if (provisioningManager == null) {
            throw new UserErrorException("Unknown device link uri.");
        }
        String deviceName = request.deviceName();
        if (deviceName == null) {
            deviceName = "cli";
        }
        try {
            number = provisioningManager.finishDeviceLink(deviceName);
        }
        catch (TimeoutException e) {
            throw new UserErrorException("Link request timed out, please try again.");
        }
        catch (IOException e) {
            throw new IOErrorException("Link request error: " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")", e);
        }
        catch (UserAlreadyExistsException e) {
            throw new UserErrorException("The user " + e.getNumber() + " already exists\nDelete \"" + String.valueOf(e.getFileName()) + "\" before trying again.");
        }
        jsonWriter.write(new JsonFinishLink(number));
    }

    public record FinishLinkParams(String deviceLinkUri, String deviceName) {
    }

    private record JsonFinishLink(String number) {
    }
}

