/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.calling;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.protocol.util.Pair;
import org.signal.libsignal.zkgroup.calllinks.CreateCallLinkCredentialRequest;
import org.signal.libsignal.zkgroup.calllinks.CreateCallLinkCredentialResponse;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.messages.calls.CallingResponse;
import org.whispersystems.signalservice.api.messages.calls.TurnServerInfo;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.CreateCallLinkAuthRequest;
import org.whispersystems.signalservice.internal.push.CreateCallLinkAuthResponse;
import org.whispersystems.signalservice.internal.push.GetCallingRelaysResponse;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u000e\u001a\u00020\u000fJJ\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u001a\u0010\u0017\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0018\u0018\u00010\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/whispersystems/signalservice/api/calling/CallingApi;", "", "auth", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;)V", "getTurnServerInfo", "Lorg/whispersystems/signalservice/api/NetworkResult;", "", "Lorg/whispersystems/signalservice/api/messages/calls/TurnServerInfo;", "createCallLinkCredential", "Lorg/signal/libsignal/zkgroup/calllinks/CreateCallLinkCredentialResponse;", "request", "Lorg/signal/libsignal/zkgroup/calllinks/CreateCallLinkCredentialRequest;", "makeCallingRequest", "Lorg/whispersystems/signalservice/api/messages/calls/CallingResponse;", "requestId", "", "url", "", "httpMethod", "headers", "Lorg/signal/libsignal/protocol/util/Pair;", "body", "", "signal-service-java"})
public final class CallingApi {
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket auth;
    @NotNull
    private final PushServiceSocket pushServiceSocket;

    public CallingApi(@NotNull SignalWebSocket.AuthenticatedWebSocket auth, @NotNull PushServiceSocket pushServiceSocket) {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
        this.auth = auth;
        this.pushServiceSocket = pushServiceSocket;
    }

    @NotNull
    public final NetworkResult<List<TurnServerInfo>> getTurnServerInfo() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v2/calling/relays", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.auth, request2, Reflection.getOrCreateKotlinClass(GetCallingRelaysResponse.class), 0L, 8, null).map(CallingApi::getTurnServerInfo$lambda$0);
    }

    @NotNull
    public final NetworkResult<CreateCallLinkCredentialResponse> createCallLinkCredential(@NotNull CreateCallLinkCredentialRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        WebSocketRequestMessage request3 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/call-link/create-auth", CreateCallLinkAuthRequest.Companion.create(request2), null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.auth, request3, Reflection.getOrCreateKotlinClass(CreateCallLinkAuthResponse.class), 0L, 8, null).map(CallingApi::createCallLinkCredential$lambda$1);
    }

    @NotNull
    public final NetworkResult<CallingResponse> makeCallingRequest(long requestId, @NotNull String url, @NotNull String httpMethod, @Nullable List<? extends Pair<String, String>> headers, @Nullable byte[] body) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"httpMethod");
        NetworkResult result2 = NetworkResult.Companion.fromFetch(() -> CallingApi.makeCallingRequest$lambda$2(this, requestId, url, httpMethod, headers, body));
        return result2 instanceof NetworkResult.Success ? result2 : (NetworkResult)new NetworkResult.Success<CallingResponse.Error>(new CallingResponse.Error(requestId, result2.getCause()));
    }

    private static final List getTurnServerInfo$lambda$0(GetCallingRelaysResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = it.getRelays();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final CreateCallLinkCredentialResponse createCallLinkCredential$lambda$1(CreateCallLinkAuthResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCreateCallLinkCredentialResponse();
    }

    private static final CallingResponse makeCallingRequest$lambda$2(CallingApi this$0, long $requestId, String $url, String $httpMethod, List $headers, byte[] $body) {
        return this$0.pushServiceSocket.makeCallingRequest($requestId, $url, $httpMethod, $headers, $body);
    }
}

