/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jruby.RubyModule;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class ClassUtils {
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    public static boolean assignable(Class<?> target2, Class<?> from) {
        if (target2.isPrimitive()) {
            target2 = CodegenUtils.getBoxType(target2);
        } else if (from == Void.TYPE || target2.isAssignableFrom(from)) {
            return true;
        }
        if (from.isPrimitive()) {
            from = CodegenUtils.getBoxType(from);
        }
        if (target2.isAssignableFrom(from)) {
            return true;
        }
        if (Number.class.isAssignableFrom(target2)) {
            if (Number.class.isAssignableFrom(from)) {
                return true;
            }
            if (from == Character.class) {
                return true;
            }
        } else if (target2 == Character.class && Number.class.isAssignableFrom(from)) {
            return true;
        }
        return false;
    }

    public static Class<?>[] getArgumentTypes(ThreadContext context, IRubyObject[] args2, int offset2) {
        int length2 = args2.length;
        if (length2 == offset2) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] argumentTypes = new Class[length2 - offset2];
        for (int i2 = offset2; i2 < length2; ++i2) {
            argumentTypes[i2 - offset2] = Java.resolveClassType(context, args2[i2]);
        }
        return argumentTypes;
    }

    public static AccessibleObject getMatchingCallable(Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        if (methodName.length() == 6 && "<init>".equals(methodName)) {
            return ClassUtils.getMatchingConstructor(javaClass, argumentTypes);
        }
        return ClassUtils.getMatchingDeclaredMethod(javaClass, methodName, argumentTypes);
    }

    public static Constructor getMatchingConstructor(Class<?> javaClass, Class<?>[] argumentTypes) {
        try {
            return javaClass.getConstructor(argumentTypes);
        }
        catch (NoSuchMethodException e) {
            int argLength = argumentTypes.length;
            block2: for (Constructor<?> ctor : javaClass.getConstructors()) {
                Class<?>[] ctorTypes = ctor.getParameterTypes();
                int ctorLength = ctorTypes.length;
                if (ctorLength != argLength) continue;
                if (ctorLength == 0 && argLength == 0) {
                    return ctor;
                }
                boolean found = true;
                for (int i2 = 0; i2 < argLength; ++i2) {
                    if (!ctorTypes[i2].isAssignableFrom(argumentTypes[i2])) continue block2;
                    found = true;
                }
                if (!found) continue;
                return ctor;
            }
            return null;
        }
    }

    public static Method getMatchingDeclaredMethod(Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            return javaClass.getDeclaredMethod(methodName, argumentTypes);
        }
        catch (NoSuchMethodException e) {
            block2: for (Method method2 : javaClass.getDeclaredMethods()) {
                if (!method2.getName().equals(methodName)) continue;
                Class<?>[] targetTypes = method2.getParameterTypes();
                if (targetTypes.length == 0 && argumentTypes.length == 0) {
                    return method2;
                }
                for (int i2 = 0; i2 < argumentTypes.length; ++i2) {
                    if (i2 >= targetTypes.length || !targetTypes[i2].isAssignableFrom(argumentTypes[i2])) continue block2;
                }
                return method2;
            }
            return null;
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        try {
            return clazz.getDeclaredFields();
        }
        catch (SecurityException e) {
            return ClassUtils.getFields(clazz);
        }
    }

    public static Field[] getFields(Class<?> clazz) {
        try {
            return clazz.getFields();
        }
        catch (SecurityException e) {
            return new Field[0];
        }
    }

    public static Class<?>[] getDeclaredClasses(Class<?> clazz) {
        try {
            return clazz.getDeclaredClasses();
        }
        catch (SecurityException e) {
            return new Class[0];
        }
        catch (NoClassDefFoundError cnfe) {
            return new Class[0];
        }
    }

    public static String getSimpleName(Class<?> clazz) {
        if (clazz.isArray()) {
            return ClassUtils.getSimpleName(clazz.getComponentType()) + "[]";
        }
        String className = clazz.getName();
        int len = className.length();
        int i2 = className.lastIndexOf(36);
        if (i2 != -1) {
            while (++i2 < len && Character.isDigit(className.charAt(i2))) {
            }
            return className.substring(i2);
        }
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public static Constructor[] getConstructors(Class<?> clazz) {
        try {
            return clazz.getConstructors();
        }
        catch (SecurityException e) {
            return new Constructor[0];
        }
    }

    public static boolean isJavaClassProxyType(RubyModule clazz) {
        return JavaUtil.getJavaClass(clazz, null) != null;
    }
}

