// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// REQUIRES: amdgpu-registered-target

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-is-target-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --check-prefix=IR-GPU

// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp -emit-llvm %s -o - | FileCheck %s --check-prefix=IR

// Check same results after serialization round-trip
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp -emit-pch -o %t %s
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp -include-pch %t -emit-llvm %s -o - | FileCheck %s --check-prefix=IR-PCH


// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-assume-no-nested-parallelism -DNESTED -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-is-target-device -fopenmp-assume-no-nested-parallelism -DNESTED -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --check-prefix=IR-GPU-NESTED

// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp -fopenmp-assume-no-nested-parallelism -DNESTED -emit-llvm %s -o - | FileCheck %s --check-prefix=IR-NESTED

// Check same results after serialization round-trip
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp -fopenmp-assume-no-nested-parallelism -DNESTED -emit-pch -o %t %s
// RUN: %clang_cc1 -verify -triple x86_64-pc-linux-gnu -fopenmp -include-pch %t -fopenmp-assume-no-nested-parallelism -DNESTED -emit-llvm %s -o - | FileCheck %s --check-prefix=IR-PCH-NESTED

// expected-no-diagnostics

#ifndef NESTED
extern int omp_get_num_teams(void);
#endif

#ifndef HEADER
#define HEADER
extern int foo(int i);

int N = 100000;
int main()
{
  int a[N];
  int b[N];

#ifndef NESTED
  // Should be transformed into 'target teams distribute parallel for'
  #pragma omp target teams loop
  for (int j = 0; j != N; j++)
    a[j]=b[j];

  // Should be transformed into 'target teams distribute parallel for'
  #pragma omp target teams loop collapse(2)
  for (int i = 0; i < N; i++) {
    for (int j = 0; j < N; j++) {
      a[i] = b[i] * N + j;
    }
  }

  int nt = 0;
  // Should be transformed into 'target teams distribute parallel for'
  #pragma omp target teams loop num_teams(32)
  for (int i=0; i < N; i++) {
    if (!nt) nt = omp_get_num_teams();
    for (int j=0; j < N; j++)
      a[j] = b[j] * N + nt;
  }
#else
  // Should be transformed into 'target teams distribute parallel for'
  // even with function call because of assume-no-nested-parallelism.
  #pragma omp target teams loop collapse(2)
  for (int i = 0; i < N; i++) {
    for (int j = 0; j < N; j++) {
      a[i] = b[i] * N + foo(j);
    }
  }
#endif
  return 0;
}
#endif
// IR-GPU-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41
// IR-GPU-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR0:[0-9]+]] {
// IR-GPU-NEXT:  entry:
// IR-GPU-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[J:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// IR-GPU-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// IR-GPU-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR2]] to ptr
// IR-GPU-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// IR-GPU-NEXT:    [[J_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[J]] to ptr
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_]] to ptr
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_3]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// IR-GPU-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i32 0, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-GPU-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-GPU-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-GPU-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 0, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP6]], ptr [[DOTOMP_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// IR-GPU-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// IR-GPU-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// IR-GPU-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// IR-GPU-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// IR-GPU-NEXT:    [[TMP11:%.*]] = mul i32 [[TMP10]], 1
// IR-GPU-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP13:%.*]] = add i32 [[TMP11]], [[TMP12]]
// IR-GPU-NEXT:    store i32 [[TMP13]], ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[FOR_COND:%.*]]
// IR-GPU:       for.cond:
// IR-GPU-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// IR-GPU-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// IR-GPU:       for.body:
// IR-GPU-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// IR-GPU-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// IR-GPU-NEXT:    store i32 [[ADD]], ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP17:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// IR-GPU-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-GPU-NEXT:    [[TMP18:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-GPU-NEXT:    [[TMP19:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP19]] to i64
// IR-GPU-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM5]]
// IR-GPU-NEXT:    store i32 [[TMP18]], ptr [[ARRAYIDX6]], align 4
// IR-GPU-NEXT:    br label [[FOR_INC:%.*]]
// IR-GPU:       for.inc:
// IR-GPU-NEXT:    [[NVPTX_NUM_THREADS7:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// IR-GPU-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// IR-GPU-NEXT:    [[TMP21:%.*]] = mul i32 [[NVPTX_NUM_THREADS7]], [[TMP20]]
// IR-GPU-NEXT:    [[TMP22:%.*]] = mul i32 [[TMP21]], 1
// IR-GPU-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP24:%.*]] = add i32 [[TMP22]], [[TMP23]]
// IR-GPU-NEXT:    store i32 [[TMP24]], ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// IR-GPU:       for.end:
// IR-GPU-NEXT:    ret void
//
//
// IR-GPU-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46
// IR-GPU-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR0]] {
// IR-GPU-NEXT:  entry:
// IR-GPU-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[J:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// IR-GPU-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// IR-GPU-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR2]] to ptr
// IR-GPU-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// IR-GPU-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// IR-GPU-NEXT:    [[J_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[J]] to ptr
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_]] to ptr
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_3]] to ptr
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_4]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// IR-GPU-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 0, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// IR-GPU-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-GPU-NEXT:    [[CONV:%.*]] = sext i32 [[DIV]] to i64
// IR-GPU-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[TMP7]], 0
// IR-GPU-NEXT:    [[DIV6:%.*]] = sdiv i32 [[SUB5]], 1
// IR-GPU-NEXT:    [[CONV7:%.*]] = sext i32 [[DIV6]] to i64
// IR-GPU-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV]], [[CONV7]]
// IR-GPU-NEXT:    [[SUB8:%.*]] = sub nsw i64 [[MUL]], 1
// IR-GPU-NEXT:    store i64 [[SUB8]], ptr [[DOTCAPTURE_EXPR_4_ASCAST]], align 8
// IR-GPU-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 0, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    store i64 0, ptr [[DOTOMP_LB_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_4_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[TMP8]], ptr [[DOTOMP_UB_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTOMP_LB_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// IR-GPU-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// IR-GPU-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// IR-GPU-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// IR-GPU-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// IR-GPU-NEXT:    [[TMP13:%.*]] = zext i32 [[TMP12]] to i64
// IR-GPU-NEXT:    [[TMP14:%.*]] = mul i64 [[TMP13]], 1
// IR-GPU-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP16:%.*]] = add i64 [[TMP14]], [[TMP15]]
// IR-GPU-NEXT:    store i64 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NEXT:    br label [[FOR_COND:%.*]]
// IR-GPU:       for.cond:
// IR-GPU-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_UB_ASCAST]], align 8
// IR-GPU-NEXT:    [[CMP:%.*]] = icmp sle i64 [[TMP17]], [[TMP18]]
// IR-GPU-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// IR-GPU:       for.body:
// IR-GPU-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    [[SUB9:%.*]] = sub nsw i32 [[TMP20]], 0
// IR-GPU-NEXT:    [[DIV10:%.*]] = sdiv i32 [[SUB9]], 1
// IR-GPU-NEXT:    [[MUL11:%.*]] = mul nsw i32 1, [[DIV10]]
// IR-GPU-NEXT:    [[CONV12:%.*]] = sext i32 [[MUL11]] to i64
// IR-GPU-NEXT:    [[DIV13:%.*]] = sdiv i64 [[TMP19]], [[CONV12]]
// IR-GPU-NEXT:    [[MUL14:%.*]] = mul nsw i64 [[DIV13]], 1
// IR-GPU-NEXT:    [[ADD:%.*]] = add nsw i64 0, [[MUL14]]
// IR-GPU-NEXT:    [[CONV15:%.*]] = trunc i64 [[ADD]] to i32
// IR-GPU-NEXT:    store i32 [[CONV15]], ptr [[I_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP22:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    [[SUB16:%.*]] = sub nsw i32 [[TMP23]], 0
// IR-GPU-NEXT:    [[DIV17:%.*]] = sdiv i32 [[SUB16]], 1
// IR-GPU-NEXT:    [[MUL18:%.*]] = mul nsw i32 1, [[DIV17]]
// IR-GPU-NEXT:    [[CONV19:%.*]] = sext i32 [[MUL18]] to i64
// IR-GPU-NEXT:    [[DIV20:%.*]] = sdiv i64 [[TMP22]], [[CONV19]]
// IR-GPU-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    [[SUB21:%.*]] = sub nsw i32 [[TMP24]], 0
// IR-GPU-NEXT:    [[DIV22:%.*]] = sdiv i32 [[SUB21]], 1
// IR-GPU-NEXT:    [[MUL23:%.*]] = mul nsw i32 1, [[DIV22]]
// IR-GPU-NEXT:    [[CONV24:%.*]] = sext i32 [[MUL23]] to i64
// IR-GPU-NEXT:    [[MUL25:%.*]] = mul nsw i64 [[DIV20]], [[CONV24]]
// IR-GPU-NEXT:    [[SUB26:%.*]] = sub nsw i64 [[TMP21]], [[MUL25]]
// IR-GPU-NEXT:    [[MUL27:%.*]] = mul nsw i64 [[SUB26]], 1
// IR-GPU-NEXT:    [[ADD28:%.*]] = add nsw i64 0, [[MUL27]]
// IR-GPU-NEXT:    [[CONV29:%.*]] = trunc i64 [[ADD28]] to i32
// IR-GPU-NEXT:    store i32 [[CONV29]], ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP25:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// IR-GPU-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP25]] to i64
// IR-GPU-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-GPU-NEXT:    [[TMP26:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-GPU-NEXT:    [[TMP27:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    [[MUL30:%.*]] = mul nsw i32 [[TMP26]], [[TMP27]]
// IR-GPU-NEXT:    [[TMP28:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[ADD31:%.*]] = add nsw i32 [[MUL30]], [[TMP28]]
// IR-GPU-NEXT:    [[TMP29:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// IR-GPU-NEXT:    [[IDXPROM32:%.*]] = sext i32 [[TMP29]] to i64
// IR-GPU-NEXT:    [[ARRAYIDX33:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM32]]
// IR-GPU-NEXT:    store i32 [[ADD31]], ptr [[ARRAYIDX33]], align 4
// IR-GPU-NEXT:    br label [[FOR_INC:%.*]]
// IR-GPU:       for.inc:
// IR-GPU-NEXT:    [[NVPTX_NUM_THREADS34:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// IR-GPU-NEXT:    [[TMP30:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// IR-GPU-NEXT:    [[TMP31:%.*]] = mul i32 [[NVPTX_NUM_THREADS34]], [[TMP30]]
// IR-GPU-NEXT:    [[TMP32:%.*]] = zext i32 [[TMP31]] to i64
// IR-GPU-NEXT:    [[TMP33:%.*]] = mul i64 [[TMP32]], 1
// IR-GPU-NEXT:    [[TMP34:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP35:%.*]] = add i64 [[TMP33]], [[TMP34]]
// IR-GPU-NEXT:    store i64 [[TMP35]], ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// IR-GPU:       for.end:
// IR-GPU-NEXT:    ret void
//
//
// IR-GPU-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55
// IR-GPU-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i64 noundef [[N:%.*]], i64 noundef [[NT:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR3:[0-9]+]] {
// IR-GPU-NEXT:  entry:
// IR-GPU-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[NT_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[NT_CASTED:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// IR-GPU-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// IR-GPU-NEXT:    [[NT_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[NT_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// IR-GPU-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR2]] to ptr
// IR-GPU-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// IR-GPU-NEXT:    [[N_CASTED_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_CASTED]] to ptr
// IR-GPU-NEXT:    [[NT_CASTED_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[NT_CASTED]] to ptr
// IR-GPU-NEXT:    [[DOTZERO_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
// IR-GPU-NEXT:    [[DOTTHREADID_TEMP__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTTHREADID_TEMP_]] to ptr
// IR-GPU-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[NT]], ptr [[NT_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_target_init(ptr addrspacecast (ptr addrspace(1) @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55_kernel_environment to ptr), ptr [[DYN_PTR]])
// IR-GPU-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP4]], -1
// IR-GPU-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// IR-GPU:       user_code.entry:
// IR-GPU-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_global_thread_num(ptr addrspacecast (ptr addrspace(1) @[[GLOB1:[0-9]+]] to ptr))
// IR-GPU-NEXT:    [[TMP6:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP6]], ptr [[N_CASTED_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP7:%.*]] = load i64, ptr [[N_CASTED_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP8:%.*]] = load i32, ptr [[NT_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP8]], ptr [[NT_CASTED_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP9:%.*]] = load i64, ptr [[NT_CASTED_ASCAST]], align 8
// IR-GPU-NEXT:    store i32 0, ptr [[DOTZERO_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP5]], ptr [[DOTTHREADID_TEMP__ASCAST]], align 4
// IR-GPU-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55_omp_outlined(ptr [[DOTTHREADID_TEMP__ASCAST]], ptr [[DOTZERO_ADDR_ASCAST]], i64 [[TMP7]], i64 [[TMP9]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]]) #[[ATTR1:[0-9]+]]
// IR-GPU-NEXT:    call void @__kmpc_target_deinit()
// IR-GPU-NEXT:    ret void
// IR-GPU:       worker.exit:
// IR-GPU-NEXT:    ret void
//
//
// IR-GPU-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55_omp_outlined
// IR-GPU-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[NT:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR4:[0-9]+]] {
// IR-GPU-NEXT:  entry:
// IR-GPU-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[NT_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[TMP:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[I5:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[NT_CASTED:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [8 x ptr], align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTGLOBAL_TID__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTGLOBAL_TID__ADDR]] to ptr
// IR-GPU-NEXT:    [[DOTBOUND_TID__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTBOUND_TID__ADDR]] to ptr
// IR-GPU-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// IR-GPU-NEXT:    [[NT_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[NT_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// IR-GPU-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR2]] to ptr
// IR-GPU-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// IR-GPU-NEXT:    [[TMP_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[TMP]] to ptr
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_]] to ptr
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_3]] to ptr
// IR-GPU-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_COMB_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_COMB_LB]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_COMB_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_COMB_UB]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_STRIDE_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_STRIDE]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_IS_LAST_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IS_LAST]] to ptr
// IR-GPU-NEXT:    [[I5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I5]] to ptr
// IR-GPU-NEXT:    [[N_CASTED_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_CASTED]] to ptr
// IR-GPU-NEXT:    [[NT_CASTED_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[NT_CASTED]] to ptr
// IR-GPU-NEXT:    [[CAPTURED_VARS_ADDRS_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[CAPTURED_VARS_ADDRS]] to ptr
// IR-GPU-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[NT]], ptr [[NT_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-GPU-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-GPU-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-GPU-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-GPU-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-GPU:       omp.precond.then:
// IR-GPU-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST_ASCAST]], align 4
// IR-GPU-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// IR-GPU-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// IR-GPU-NEXT:    call void @__kmpc_distribute_static_init_4(ptr addrspacecast (ptr addrspace(1) @[[GLOB2:[0-9]+]] to ptr), i32 [[TMP9]], i32 91, ptr [[DOTOMP_IS_LAST_ASCAST]], ptr [[DOTOMP_COMB_LB_ASCAST]], ptr [[DOTOMP_COMB_UB_ASCAST]], ptr [[DOTOMP_STRIDE_ASCAST]], i32 1, i32 [[NVPTX_NUM_THREADS]])
// IR-GPU-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// IR-GPU-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-GPU:       cond.true:
// IR-GPU-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[COND_END:%.*]]
// IR-GPU:       cond.false:
// IR-GPU-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[COND_END]]
// IR-GPU:       cond.end:
// IR-GPU-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// IR-GPU-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_LB_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-GPU:       omp.inner.for.cond:
// IR-GPU-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP16]], 1
// IR-GPU-NEXT:    [[CMP7:%.*]] = icmp slt i32 [[TMP15]], [[ADD]]
// IR-GPU-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-GPU:       omp.inner.for.body:
// IR-GPU-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COMB_LB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// IR-GPU-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// IR-GPU-NEXT:    [[TMP21:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP21]], ptr [[N_CASTED_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP22:%.*]] = load i64, ptr [[N_CASTED_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP23:%.*]] = load i32, ptr [[NT_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP23]], ptr [[NT_CASTED_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP24:%.*]] = load i64, ptr [[NT_CASTED_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [8 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 0
// IR-GPU-NEXT:    [[TMP26:%.*]] = inttoptr i64 [[TMP18]] to ptr
// IR-GPU-NEXT:    store ptr [[TMP26]], ptr [[TMP25]], align 8
// IR-GPU-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [8 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 1
// IR-GPU-NEXT:    [[TMP28:%.*]] = inttoptr i64 [[TMP20]] to ptr
// IR-GPU-NEXT:    store ptr [[TMP28]], ptr [[TMP27]], align 8
// IR-GPU-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [8 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 2
// IR-GPU-NEXT:    [[TMP30:%.*]] = inttoptr i64 [[TMP22]] to ptr
// IR-GPU-NEXT:    store ptr [[TMP30]], ptr [[TMP29]], align 8
// IR-GPU-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [8 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 3
// IR-GPU-NEXT:    [[TMP32:%.*]] = inttoptr i64 [[TMP24]] to ptr
// IR-GPU-NEXT:    store ptr [[TMP32]], ptr [[TMP31]], align 8
// IR-GPU-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [8 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 4
// IR-GPU-NEXT:    [[TMP34:%.*]] = inttoptr i64 [[TMP0]] to ptr
// IR-GPU-NEXT:    store ptr [[TMP34]], ptr [[TMP33]], align 8
// IR-GPU-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [8 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 5
// IR-GPU-NEXT:    store ptr [[TMP1]], ptr [[TMP35]], align 8
// IR-GPU-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [8 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 6
// IR-GPU-NEXT:    [[TMP37:%.*]] = inttoptr i64 [[TMP2]] to ptr
// IR-GPU-NEXT:    store ptr [[TMP37]], ptr [[TMP36]], align 8
// IR-GPU-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [8 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 7
// IR-GPU-NEXT:    store ptr [[TMP3]], ptr [[TMP38]], align 8
// IR-GPU-NEXT:    [[TMP39:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP40:%.*]] = load i32, ptr [[TMP39]], align 4
// IR-GPU-NEXT:    call void @__kmpc_parallel_51(ptr addrspacecast (ptr addrspace(1) @[[GLOB1]] to ptr), i32 [[TMP40]], i32 1, i32 -1, i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55_omp_outlined_omp_outlined, ptr null, ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 8)
// IR-GPU-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-GPU:       omp.inner.for.inc:
// IR-GPU-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_STRIDE_ASCAST]], align 4
// IR-GPU-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP41]], [[TMP42]]
// IR-GPU-NEXT:    store i32 [[ADD8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_COMB_LB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTOMP_STRIDE_ASCAST]], align 4
// IR-GPU-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP43]], [[TMP44]]
// IR-GPU-NEXT:    store i32 [[ADD9]], ptr [[DOTOMP_COMB_LB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP45:%.*]] = load i32, ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTOMP_STRIDE_ASCAST]], align 4
// IR-GPU-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP45]], [[TMP46]]
// IR-GPU-NEXT:    store i32 [[ADD10]], ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    [[CMP11:%.*]] = icmp sgt i32 [[TMP47]], [[TMP48]]
// IR-GPU-NEXT:    br i1 [[CMP11]], label [[COND_TRUE12:%.*]], label [[COND_FALSE13:%.*]]
// IR-GPU:       cond.true12:
// IR-GPU-NEXT:    [[TMP49:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[COND_END14:%.*]]
// IR-GPU:       cond.false13:
// IR-GPU-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[COND_END14]]
// IR-GPU:       cond.end14:
// IR-GPU-NEXT:    [[COND15:%.*]] = phi i32 [ [[TMP49]], [[COND_TRUE12]] ], [ [[TMP50]], [[COND_FALSE13]] ]
// IR-GPU-NEXT:    store i32 [[COND15]], ptr [[DOTOMP_COMB_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP51:%.*]] = load i32, ptr [[DOTOMP_COMB_LB_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-GPU:       omp.inner.for.end:
// IR-GPU-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-GPU:       omp.loop.exit:
// IR-GPU-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP53:%.*]] = load i32, ptr [[TMP52]], align 4
// IR-GPU-NEXT:    call void @__kmpc_distribute_static_fini(ptr addrspacecast (ptr addrspace(1) @[[GLOB2]] to ptr), i32 [[TMP53]])
// IR-GPU-NEXT:    br label [[OMP_PRECOND_END]]
// IR-GPU:       omp.precond.end:
// IR-GPU-NEXT:    ret void
//
//
// IR-GPU-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55_omp_outlined_omp_outlined
// IR-GPU-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[NT:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR4]] {
// IR-GPU-NEXT:  entry:
// IR-GPU-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[NT_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[TMP:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[I6:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[J:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NEXT:    [[DOTGLOBAL_TID__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTGLOBAL_TID__ADDR]] to ptr
// IR-GPU-NEXT:    [[DOTBOUND_TID__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTBOUND_TID__ADDR]] to ptr
// IR-GPU-NEXT:    [[DOTPREVIOUS_LB__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTPREVIOUS_LB__ADDR]] to ptr
// IR-GPU-NEXT:    [[DOTPREVIOUS_UB__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTPREVIOUS_UB__ADDR]] to ptr
// IR-GPU-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// IR-GPU-NEXT:    [[NT_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[NT_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// IR-GPU-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// IR-GPU-NEXT:    [[VLA_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR2]] to ptr
// IR-GPU-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// IR-GPU-NEXT:    [[TMP_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[TMP]] to ptr
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_]] to ptr
// IR-GPU-NEXT:    [[DOTCAPTURE_EXPR_3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_3]] to ptr
// IR-GPU-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_STRIDE_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_STRIDE]] to ptr
// IR-GPU-NEXT:    [[DOTOMP_IS_LAST_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IS_LAST]] to ptr
// IR-GPU-NEXT:    [[I6_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I6]] to ptr
// IR-GPU-NEXT:    [[J_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[J]] to ptr
// IR-GPU-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[NT]], ptr [[NT_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-GPU-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-GPU-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-GPU-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-GPU-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-GPU:       omp.precond.then:
// IR-GPU-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_UB_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// IR-GPU-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP9]] to i32
// IR-GPU-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_LB_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[CONV5]], ptr [[DOTOMP_UB_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// IR-GPU-NEXT:    call void @__kmpc_for_static_init_4(ptr addrspacecast (ptr addrspace(1) @[[GLOB3:[0-9]+]] to ptr), i32 [[TMP11]], i32 33, ptr [[DOTOMP_IS_LAST_ASCAST]], ptr [[DOTOMP_LB_ASCAST]], ptr [[DOTOMP_UB_ASCAST]], ptr [[DOTOMP_STRIDE_ASCAST]], i32 1, i32 1)
// IR-GPU-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// IR-GPU-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-GPU:       omp.inner.for.cond:
// IR-GPU-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[CONV7:%.*]] = sext i32 [[TMP13]] to i64
// IR-GPU-NEXT:    [[TMP14:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[CMP8:%.*]] = icmp ule i64 [[CONV7]], [[TMP14]]
// IR-GPU-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-GPU:       omp.inner.for.body:
// IR-GPU-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// IR-GPU-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// IR-GPU-NEXT:    store i32 [[ADD]], ptr [[I6_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP16:%.*]] = load i32, ptr [[NT_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP16]], 0
// IR-GPU-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
// IR-GPU:       if.then:
// IR-GPU-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z17omp_get_num_teamsv() #[[ATTR7:[0-9]+]]
// IR-GPU-NEXT:    store i32 [[CALL]], ptr [[NT_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[IF_END]]
// IR-GPU:       if.end:
// IR-GPU-NEXT:    store i32 0, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[FOR_COND:%.*]]
// IR-GPU:       for.cond:
// IR-GPU-NEXT:    [[TMP17:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP18:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    [[CMP9:%.*]] = icmp slt i32 [[TMP17]], [[TMP18]]
// IR-GPU-NEXT:    br i1 [[CMP9]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// IR-GPU:       for.body:
// IR-GPU-NEXT:    [[TMP19:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP19]] to i64
// IR-GPU-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-GPU-NEXT:    [[TMP20:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-GPU-NEXT:    [[TMP21:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[TMP20]], [[TMP21]]
// IR-GPU-NEXT:    [[TMP22:%.*]] = load i32, ptr [[NT_ADDR_ASCAST]], align 4
// IR-GPU-NEXT:    [[ADD11:%.*]] = add nsw i32 [[MUL10]], [[TMP22]]
// IR-GPU-NEXT:    [[TMP23:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[IDXPROM12:%.*]] = sext i32 [[TMP23]] to i64
// IR-GPU-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM12]]
// IR-GPU-NEXT:    store i32 [[ADD11]], ptr [[ARRAYIDX13]], align 4
// IR-GPU-NEXT:    br label [[FOR_INC:%.*]]
// IR-GPU:       for.inc:
// IR-GPU-NEXT:    [[TMP24:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP24]], 1
// IR-GPU-NEXT:    store i32 [[INC]], ptr [[J_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP14:![0-9]+]]
// IR-GPU:       for.end:
// IR-GPU-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR-GPU:       omp.body.continue:
// IR-GPU-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-GPU:       omp.inner.for.inc:
// IR-GPU-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_STRIDE_ASCAST]], align 4
// IR-GPU-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// IR-GPU-NEXT:    store i32 [[ADD14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// IR-GPU-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-GPU:       omp.inner.for.end:
// IR-GPU-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-GPU:       omp.loop.exit:
// IR-GPU-NEXT:    [[TMP27:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NEXT:    [[TMP28:%.*]] = load i32, ptr [[TMP27]], align 4
// IR-GPU-NEXT:    call void @__kmpc_for_static_fini(ptr addrspacecast (ptr addrspace(1) @[[GLOB3]] to ptr), i32 [[TMP28]])
// IR-GPU-NEXT:    br label [[OMP_PRECOND_END]]
// IR-GPU:       omp.precond.end:
// IR-GPU-NEXT:    ret void
//
//
// IR-LABEL: define {{[^@]+}}@main
// IR-SAME: () #[[ATTR0:[0-9]+]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// IR-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// IR-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i64, align 8
// IR-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-NEXT:    [[N_CASTED2:%.*]] = alloca i64, align 8
// IR-NEXT:    [[NT:%.*]] = alloca i32, align 4
// IR-NEXT:    [[N_CASTED3:%.*]] = alloca i64, align 8
// IR-NEXT:    [[NT_CASTED:%.*]] = alloca i64, align 8
// IR-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// IR-NEXT:    [[TMP0:%.*]] = load i32, ptr @N, align 4
// IR-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// IR-NEXT:    [[TMP2:%.*]] = call ptr @llvm.stacksave.p0()
// IR-NEXT:    store ptr [[TMP2]], ptr [[SAVED_STACK]], align 8
// IR-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 16
// IR-NEXT:    store i64 [[TMP1]], ptr [[__VLA_EXPR0]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load i32, ptr @N, align 4
// IR-NEXT:    [[TMP4:%.*]] = zext i32 [[TMP3]] to i64
// IR-NEXT:    [[VLA1:%.*]] = alloca i32, i64 [[TMP4]], align 16
// IR-NEXT:    store i64 [[TMP4]], ptr [[__VLA_EXPR1]], align 8
// IR-NEXT:    [[TMP5:%.*]] = load i32, ptr @N, align 4
// IR-NEXT:    store i32 [[TMP5]], ptr [[N_CASTED]], align 4
// IR-NEXT:    [[TMP6:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41(i64 [[TMP6]], i64 [[TMP1]], ptr [[VLA]], i64 [[TMP4]], ptr [[VLA1]]) #[[ATTR3:[0-9]+]]
// IR-NEXT:    [[TMP7:%.*]] = load i32, ptr @N, align 4
// IR-NEXT:    store i32 [[TMP7]], ptr [[N_CASTED2]], align 4
// IR-NEXT:    [[TMP8:%.*]] = load i64, ptr [[N_CASTED2]], align 8
// IR-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46(i64 [[TMP8]], i64 [[TMP1]], ptr [[VLA]], i64 [[TMP4]], ptr [[VLA1]]) #[[ATTR3]]
// IR-NEXT:    store i32 0, ptr [[NT]], align 4
// IR-NEXT:    [[TMP9:%.*]] = load i32, ptr @N, align 4
// IR-NEXT:    store i32 [[TMP9]], ptr [[N_CASTED3]], align 4
// IR-NEXT:    [[TMP10:%.*]] = load i64, ptr [[N_CASTED3]], align 8
// IR-NEXT:    [[TMP11:%.*]] = load i32, ptr [[NT]], align 4
// IR-NEXT:    store i32 [[TMP11]], ptr [[NT_CASTED]], align 4
// IR-NEXT:    [[TMP12:%.*]] = load i64, ptr [[NT_CASTED]], align 8
// IR-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55(i64 [[TMP10]], i64 [[TMP12]], i64 [[TMP1]], ptr [[VLA]], i64 [[TMP4]], ptr [[VLA1]]) #[[ATTR3]]
// IR-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// IR-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// IR-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP13]])
// IR-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RETVAL]], align 4
// IR-NEXT:    ret i32 [[TMP14]]
//
//
// IR-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41
// IR-SAME: (i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2:[0-9]+]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP4]], ptr [[N_CASTED]], align 4
// IR-NEXT:    [[TMP5:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3:[0-9]+]], i32 5, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41.omp_outlined, i64 [[TMP5]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-NEXT:    ret void
//
//
// IR-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41.omp_outlined
// IR-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// IR-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// IR-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-NEXT:    [[J5:%.*]] = alloca i32, align 4
// IR-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    store i32 0, ptr [[J]], align 4
// IR-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR:       omp.precond.then:
// IR-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// IR-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// IR-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// IR-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// IR-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// IR-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR:       cond.true:
// IR-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    br label [[COND_END:%.*]]
// IR:       cond.false:
// IR-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    br label [[COND_END]]
// IR:       cond.end:
// IR-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// IR-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// IR-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR:       omp.inner.for.cond:
// IR-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// IR-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR:       omp.inner.for.body:
// IR-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// IR-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// IR-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// IR-NEXT:    [[TMP21:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP21]], ptr [[N_CASTED]], align 4
// IR-NEXT:    [[TMP22:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 7, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41.omp_outlined.omp_outlined, i64 [[TMP18]], i64 [[TMP20]], i64 [[TMP22]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR:       omp.inner.for.inc:
// IR-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4
// IR-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// IR-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR:       omp.inner.for.end:
// IR-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR:       omp.loop.exit:
// IR-NEXT:    [[TMP25:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP25]], align 4
// IR-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP26]])
// IR-NEXT:    br label [[OMP_PRECOND_END]]
// IR:       omp.precond.end:
// IR-NEXT:    ret void
//
//
// IR-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41.omp_outlined.omp_outlined
// IR-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// IR-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// IR-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-NEXT:    [[J6:%.*]] = alloca i32, align 4
// IR-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    store i32 0, ptr [[J]], align 4
// IR-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR:       omp.precond.then:
// IR-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// IR-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// IR-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP9]] to i32
// IR-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_LB]], align 4
// IR-NEXT:    store i32 [[CONV5]], ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// IR-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// IR-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2:[0-9]+]], i32 [[TMP11]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// IR-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// IR-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR:       cond.true:
// IR-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    br label [[COND_END:%.*]]
// IR:       cond.false:
// IR-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    br label [[COND_END]]
// IR:       cond.end:
// IR-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// IR-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// IR-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR:       omp.inner.for.cond:
// IR-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// IR-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR:       omp.inner.for.body:
// IR-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// IR-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// IR-NEXT:    store i32 [[ADD]], ptr [[J6]], align 4
// IR-NEXT:    [[TMP20:%.*]] = load i32, ptr [[J6]], align 4
// IR-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// IR-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-NEXT:    [[TMP21:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-NEXT:    [[TMP22:%.*]] = load i32, ptr [[J6]], align 4
// IR-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP22]] to i64
// IR-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM9]]
// IR-NEXT:    store i32 [[TMP21]], ptr [[ARRAYIDX10]], align 4
// IR-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR:       omp.body.continue:
// IR-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR:       omp.inner.for.inc:
// IR-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP23]], 1
// IR-NEXT:    store i32 [[ADD11]], ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR:       omp.inner.for.end:
// IR-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR:       omp.loop.exit:
// IR-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP24]], align 4
// IR-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP25]])
// IR-NEXT:    br label [[OMP_PRECOND_END]]
// IR:       omp.precond.end:
// IR-NEXT:    ret void
//
//
// IR-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46
// IR-SAME: (i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP4]], ptr [[N_CASTED]], align 4
// IR-NEXT:    [[TMP5:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3]], i32 5, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46.omp_outlined, i64 [[TMP5]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-NEXT:    ret void
//
//
// IR-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46.omp_outlined
// IR-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// IR-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i64, align 8
// IR-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i64, align 8
// IR-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i64, align 8
// IR-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// IR-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-NEXT:    [[I11:%.*]] = alloca i32, align 4
// IR-NEXT:    [[J12:%.*]] = alloca i32, align 4
// IR-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// IR-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-NEXT:    [[CONV:%.*]] = sext i32 [[DIV]] to i64
// IR-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP7]], 0
// IR-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// IR-NEXT:    [[CONV8:%.*]] = sext i32 [[DIV7]] to i64
// IR-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV]], [[CONV8]]
// IR-NEXT:    [[SUB9:%.*]] = sub nsw i64 [[MUL]], 1
// IR-NEXT:    store i64 [[SUB9]], ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NEXT:    store i32 0, ptr [[I]], align 4
// IR-NEXT:    store i32 0, ptr [[J]], align 4
// IR-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// IR-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR:       land.lhs.true:
// IR-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NEXT:    [[CMP10:%.*]] = icmp slt i32 0, [[TMP9]]
// IR-NEXT:    br i1 [[CMP10]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END]]
// IR:       omp.precond.then:
// IR-NEXT:    store i64 0, ptr [[DOTOMP_COMB_LB]], align 8
// IR-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NEXT:    store i64 [[TMP10]], ptr [[DOTOMP_COMB_UB]], align 8
// IR-NEXT:    store i64 1, ptr [[DOTOMP_STRIDE]], align 8
// IR-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP12:%.*]] = load i32, ptr [[TMP11]], align 4
// IR-NEXT:    call void @__kmpc_for_static_init_8(ptr @[[GLOB1]], i32 [[TMP12]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i64 1, i64 1)
// IR-NEXT:    [[TMP13:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-NEXT:    [[TMP14:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NEXT:    [[CMP13:%.*]] = icmp sgt i64 [[TMP13]], [[TMP14]]
// IR-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR:       cond.true:
// IR-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NEXT:    br label [[COND_END:%.*]]
// IR:       cond.false:
// IR-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-NEXT:    br label [[COND_END]]
// IR:       cond.end:
// IR-NEXT:    [[COND:%.*]] = phi i64 [ [[TMP15]], [[COND_TRUE]] ], [ [[TMP16]], [[COND_FALSE]] ]
// IR-NEXT:    store i64 [[COND]], ptr [[DOTOMP_COMB_UB]], align 8
// IR-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTOMP_COMB_LB]], align 8
// IR-NEXT:    store i64 [[TMP17]], ptr [[DOTOMP_IV]], align 8
// IR-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR:       omp.inner.for.cond:
// IR-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-NEXT:    [[CMP14:%.*]] = icmp sle i64 [[TMP18]], [[TMP19]]
// IR-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR:       omp.inner.for.body:
// IR-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_COMB_LB]], align 8
// IR-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-NEXT:    [[TMP22:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP22]], ptr [[N_CASTED]], align 4
// IR-NEXT:    [[TMP23:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 7, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46.omp_outlined.omp_outlined, i64 [[TMP20]], i64 [[TMP21]], i64 [[TMP23]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR:       omp.inner.for.inc:
// IR-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_STRIDE]], align 8
// IR-NEXT:    [[ADD:%.*]] = add nsw i64 [[TMP24]], [[TMP25]]
// IR-NEXT:    store i64 [[ADD]], ptr [[DOTOMP_IV]], align 8
// IR-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR:       omp.inner.for.end:
// IR-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR:       omp.loop.exit:
// IR-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP27:%.*]] = load i32, ptr [[TMP26]], align 4
// IR-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP27]])
// IR-NEXT:    br label [[OMP_PRECOND_END]]
// IR:       omp.precond.end:
// IR-NEXT:    ret void
//
//
// IR-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46.omp_outlined.omp_outlined
// IR-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// IR-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i64, align 8
// IR-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// IR-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// IR-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// IR-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-NEXT:    [[I11:%.*]] = alloca i32, align 4
// IR-NEXT:    [[J12:%.*]] = alloca i32, align 4
// IR-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// IR-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-NEXT:    [[CONV:%.*]] = sext i32 [[DIV]] to i64
// IR-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP7]], 0
// IR-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// IR-NEXT:    [[CONV8:%.*]] = sext i32 [[DIV7]] to i64
// IR-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV]], [[CONV8]]
// IR-NEXT:    [[SUB9:%.*]] = sub nsw i64 [[MUL]], 1
// IR-NEXT:    store i64 [[SUB9]], ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NEXT:    store i32 0, ptr [[I]], align 4
// IR-NEXT:    store i32 0, ptr [[J]], align 4
// IR-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// IR-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR:       land.lhs.true:
// IR-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NEXT:    [[CMP10:%.*]] = icmp slt i32 0, [[TMP9]]
// IR-NEXT:    br i1 [[CMP10]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END]]
// IR:       omp.precond.then:
// IR-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// IR-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NEXT:    store i64 [[TMP10]], ptr [[DOTOMP_UB]], align 8
// IR-NEXT:    [[TMP11:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-NEXT:    [[TMP12:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-NEXT:    store i64 [[TMP11]], ptr [[DOTOMP_LB]], align 8
// IR-NEXT:    store i64 [[TMP12]], ptr [[DOTOMP_UB]], align 8
// IR-NEXT:    store i64 1, ptr [[DOTOMP_STRIDE]], align 8
// IR-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP13]], align 4
// IR-NEXT:    call void @__kmpc_for_static_init_8(ptr @[[GLOB2]], i32 [[TMP14]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i64 1, i64 1)
// IR-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// IR-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NEXT:    [[CMP13:%.*]] = icmp sgt i64 [[TMP15]], [[TMP16]]
// IR-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR:       cond.true:
// IR-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NEXT:    br label [[COND_END:%.*]]
// IR:       cond.false:
// IR-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// IR-NEXT:    br label [[COND_END]]
// IR:       cond.end:
// IR-NEXT:    [[COND:%.*]] = phi i64 [ [[TMP17]], [[COND_TRUE]] ], [ [[TMP18]], [[COND_FALSE]] ]
// IR-NEXT:    store i64 [[COND]], ptr [[DOTOMP_UB]], align 8
// IR-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// IR-NEXT:    store i64 [[TMP19]], ptr [[DOTOMP_IV]], align 8
// IR-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR:       omp.inner.for.cond:
// IR-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// IR-NEXT:    [[CMP14:%.*]] = icmp sle i64 [[TMP20]], [[TMP21]]
// IR-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR:       omp.inner.for.body:
// IR-NEXT:    [[TMP22:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP23]], 0
// IR-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// IR-NEXT:    [[MUL17:%.*]] = mul nsw i32 1, [[DIV16]]
// IR-NEXT:    [[CONV18:%.*]] = sext i32 [[MUL17]] to i64
// IR-NEXT:    [[DIV19:%.*]] = sdiv i64 [[TMP22]], [[CONV18]]
// IR-NEXT:    [[MUL20:%.*]] = mul nsw i64 [[DIV19]], 1
// IR-NEXT:    [[ADD:%.*]] = add nsw i64 0, [[MUL20]]
// IR-NEXT:    [[CONV21:%.*]] = trunc i64 [[ADD]] to i32
// IR-NEXT:    store i32 [[CONV21]], ptr [[I11]], align 4
// IR-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NEXT:    [[SUB22:%.*]] = sub nsw i32 [[TMP26]], 0
// IR-NEXT:    [[DIV23:%.*]] = sdiv i32 [[SUB22]], 1
// IR-NEXT:    [[MUL24:%.*]] = mul nsw i32 1, [[DIV23]]
// IR-NEXT:    [[CONV25:%.*]] = sext i32 [[MUL24]] to i64
// IR-NEXT:    [[DIV26:%.*]] = sdiv i64 [[TMP25]], [[CONV25]]
// IR-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NEXT:    [[SUB27:%.*]] = sub nsw i32 [[TMP27]], 0
// IR-NEXT:    [[DIV28:%.*]] = sdiv i32 [[SUB27]], 1
// IR-NEXT:    [[MUL29:%.*]] = mul nsw i32 1, [[DIV28]]
// IR-NEXT:    [[CONV30:%.*]] = sext i32 [[MUL29]] to i64
// IR-NEXT:    [[MUL31:%.*]] = mul nsw i64 [[DIV26]], [[CONV30]]
// IR-NEXT:    [[SUB32:%.*]] = sub nsw i64 [[TMP24]], [[MUL31]]
// IR-NEXT:    [[MUL33:%.*]] = mul nsw i64 [[SUB32]], 1
// IR-NEXT:    [[ADD34:%.*]] = add nsw i64 0, [[MUL33]]
// IR-NEXT:    [[CONV35:%.*]] = trunc i64 [[ADD34]] to i32
// IR-NEXT:    store i32 [[CONV35]], ptr [[J12]], align 4
// IR-NEXT:    [[TMP28:%.*]] = load i32, ptr [[I11]], align 4
// IR-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP28]] to i64
// IR-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-NEXT:    [[TMP29:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-NEXT:    [[TMP30:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    [[MUL36:%.*]] = mul nsw i32 [[TMP29]], [[TMP30]]
// IR-NEXT:    [[TMP31:%.*]] = load i32, ptr [[J12]], align 4
// IR-NEXT:    [[ADD37:%.*]] = add nsw i32 [[MUL36]], [[TMP31]]
// IR-NEXT:    [[TMP32:%.*]] = load i32, ptr [[I11]], align 4
// IR-NEXT:    [[IDXPROM38:%.*]] = sext i32 [[TMP32]] to i64
// IR-NEXT:    [[ARRAYIDX39:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM38]]
// IR-NEXT:    store i32 [[ADD37]], ptr [[ARRAYIDX39]], align 4
// IR-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR:       omp.body.continue:
// IR-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR:       omp.inner.for.inc:
// IR-NEXT:    [[TMP33:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NEXT:    [[ADD40:%.*]] = add nsw i64 [[TMP33]], 1
// IR-NEXT:    store i64 [[ADD40]], ptr [[DOTOMP_IV]], align 8
// IR-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR:       omp.inner.for.end:
// IR-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR:       omp.loop.exit:
// IR-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP35:%.*]] = load i32, ptr [[TMP34]], align 4
// IR-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP35]])
// IR-NEXT:    br label [[OMP_PRECOND_END]]
// IR:       omp.precond.end:
// IR-NEXT:    ret void
//
//
// IR-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55
// IR-SAME: (i64 noundef [[N:%.*]], i64 noundef [[NT:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[NT_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-NEXT:    [[NT_CASTED:%.*]] = alloca i64, align 8
// IR-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB3]])
// IR-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NEXT:    store i64 [[NT]], ptr [[NT_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP1:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB3]], i32 [[TMP0]], i32 32, i32 0)
// IR-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP5]], ptr [[N_CASTED]], align 4
// IR-NEXT:    [[TMP6:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-NEXT:    [[TMP7:%.*]] = load i32, ptr [[NT_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP7]], ptr [[NT_CASTED]], align 4
// IR-NEXT:    [[TMP8:%.*]] = load i64, ptr [[NT_CASTED]], align 8
// IR-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3]], i32 6, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55.omp_outlined, i64 [[TMP6]], i64 [[TMP8]], i64 [[TMP1]], ptr [[TMP2]], i64 [[TMP3]], ptr [[TMP4]])
// IR-NEXT:    ret void
//
//
// IR-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55.omp_outlined
// IR-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[NT:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[NT_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// IR-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// IR-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-NEXT:    [[I5:%.*]] = alloca i32, align 4
// IR-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-NEXT:    [[NT_CASTED:%.*]] = alloca i64, align 8
// IR-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NEXT:    store i64 [[NT]], ptr [[NT_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    store i32 0, ptr [[I]], align 4
// IR-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR:       omp.precond.then:
// IR-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// IR-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// IR-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// IR-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1]], i32 [[TMP9]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// IR-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// IR-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR:       cond.true:
// IR-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    br label [[COND_END:%.*]]
// IR:       cond.false:
// IR-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    br label [[COND_END]]
// IR:       cond.end:
// IR-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// IR-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// IR-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR:       omp.inner.for.cond:
// IR-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// IR-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR:       omp.inner.for.body:
// IR-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// IR-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// IR-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// IR-NEXT:    [[TMP21:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP21]], ptr [[N_CASTED]], align 4
// IR-NEXT:    [[TMP22:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-NEXT:    [[TMP23:%.*]] = load i32, ptr [[NT_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP23]], ptr [[NT_CASTED]], align 4
// IR-NEXT:    [[TMP24:%.*]] = load i64, ptr [[NT_CASTED]], align 8
// IR-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 8, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55.omp_outlined.omp_outlined, i64 [[TMP18]], i64 [[TMP20]], i64 [[TMP22]], i64 [[TMP24]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR:       omp.inner.for.inc:
// IR-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4
// IR-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// IR-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR:       omp.inner.for.end:
// IR-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR:       omp.loop.exit:
// IR-NEXT:    [[TMP27:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP28:%.*]] = load i32, ptr [[TMP27]], align 4
// IR-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP28]])
// IR-NEXT:    br label [[OMP_PRECOND_END]]
// IR:       omp.precond.end:
// IR-NEXT:    ret void
//
//
// IR-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55.omp_outlined.omp_outlined
// IR-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[NT:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-NEXT:  entry:
// IR-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[NT_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// IR-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// IR-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// IR-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-NEXT:    [[I6:%.*]] = alloca i32, align 4
// IR-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NEXT:    store i64 [[NT]], ptr [[NT_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    store i32 0, ptr [[I]], align 4
// IR-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR:       omp.precond.then:
// IR-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// IR-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// IR-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP9]] to i32
// IR-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_LB]], align 4
// IR-NEXT:    store i32 [[CONV5]], ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// IR-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// IR-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2]], i32 [[TMP11]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// IR-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// IR-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR:       cond.true:
// IR-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-NEXT:    br label [[COND_END:%.*]]
// IR:       cond.false:
// IR-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    br label [[COND_END]]
// IR:       cond.end:
// IR-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// IR-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// IR-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR:       omp.inner.for.cond:
// IR-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// IR-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR:       omp.inner.for.body:
// IR-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// IR-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// IR-NEXT:    store i32 [[ADD]], ptr [[I6]], align 4
// IR-NEXT:    [[TMP20:%.*]] = load i32, ptr [[NT_ADDR]], align 4
// IR-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP20]], 0
// IR-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
// IR:       if.then:
// IR-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z17omp_get_num_teamsv()
// IR-NEXT:    store i32 [[CALL]], ptr [[NT_ADDR]], align 4
// IR-NEXT:    br label [[IF_END]]
// IR:       if.end:
// IR-NEXT:    store i32 0, ptr [[J]], align 4
// IR-NEXT:    br label [[FOR_COND:%.*]]
// IR:       for.cond:
// IR-NEXT:    [[TMP21:%.*]] = load i32, ptr [[J]], align 4
// IR-NEXT:    [[TMP22:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    [[CMP9:%.*]] = icmp slt i32 [[TMP21]], [[TMP22]]
// IR-NEXT:    br i1 [[CMP9]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// IR:       for.body:
// IR-NEXT:    [[TMP23:%.*]] = load i32, ptr [[J]], align 4
// IR-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP23]] to i64
// IR-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-NEXT:    [[TMP24:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-NEXT:    [[TMP25:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[TMP24]], [[TMP25]]
// IR-NEXT:    [[TMP26:%.*]] = load i32, ptr [[NT_ADDR]], align 4
// IR-NEXT:    [[ADD11:%.*]] = add nsw i32 [[MUL10]], [[TMP26]]
// IR-NEXT:    [[TMP27:%.*]] = load i32, ptr [[J]], align 4
// IR-NEXT:    [[IDXPROM12:%.*]] = sext i32 [[TMP27]] to i64
// IR-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM12]]
// IR-NEXT:    store i32 [[ADD11]], ptr [[ARRAYIDX13]], align 4
// IR-NEXT:    br label [[FOR_INC:%.*]]
// IR:       for.inc:
// IR-NEXT:    [[TMP28:%.*]] = load i32, ptr [[J]], align 4
// IR-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP28]], 1
// IR-NEXT:    store i32 [[INC]], ptr [[J]], align 4
// IR-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// IR:       for.end:
// IR-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR:       omp.body.continue:
// IR-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR:       omp.inner.for.inc:
// IR-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP29]], 1
// IR-NEXT:    store i32 [[ADD14]], ptr [[DOTOMP_IV]], align 4
// IR-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR:       omp.inner.for.end:
// IR-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR:       omp.loop.exit:
// IR-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NEXT:    [[TMP31:%.*]] = load i32, ptr [[TMP30]], align 4
// IR-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP31]])
// IR-NEXT:    br label [[OMP_PRECOND_END]]
// IR:       omp.precond.end:
// IR-NEXT:    ret void
//
//
// IR-PCH-LABEL: define {{[^@]+}}@main
// IR-PCH-SAME: () #[[ATTR0:[0-9]+]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[N_CASTED2:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[NT:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[N_CASTED3:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[NT_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// IR-PCH-NEXT:    [[TMP0:%.*]] = load i32, ptr @N, align 4
// IR-PCH-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// IR-PCH-NEXT:    [[TMP2:%.*]] = call ptr @llvm.stacksave.p0()
// IR-PCH-NEXT:    store ptr [[TMP2]], ptr [[SAVED_STACK]], align 8
// IR-PCH-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 16
// IR-PCH-NEXT:    store i64 [[TMP1]], ptr [[__VLA_EXPR0]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load i32, ptr @N, align 4
// IR-PCH-NEXT:    [[TMP4:%.*]] = zext i32 [[TMP3]] to i64
// IR-PCH-NEXT:    [[VLA1:%.*]] = alloca i32, i64 [[TMP4]], align 16
// IR-PCH-NEXT:    store i64 [[TMP4]], ptr [[__VLA_EXPR1]], align 8
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i32, ptr @N, align 4
// IR-PCH-NEXT:    store i32 [[TMP5]], ptr [[N_CASTED]], align 4
// IR-PCH-NEXT:    [[TMP6:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-PCH-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41(i64 [[TMP6]], i64 [[TMP1]], ptr [[VLA]], i64 [[TMP4]], ptr [[VLA1]]) #[[ATTR3:[0-9]+]]
// IR-PCH-NEXT:    [[TMP7:%.*]] = load i32, ptr @N, align 4
// IR-PCH-NEXT:    store i32 [[TMP7]], ptr [[N_CASTED2]], align 4
// IR-PCH-NEXT:    [[TMP8:%.*]] = load i64, ptr [[N_CASTED2]], align 8
// IR-PCH-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46(i64 [[TMP8]], i64 [[TMP1]], ptr [[VLA]], i64 [[TMP4]], ptr [[VLA1]]) #[[ATTR3]]
// IR-PCH-NEXT:    store i32 0, ptr [[NT]], align 4
// IR-PCH-NEXT:    [[TMP9:%.*]] = load i32, ptr @N, align 4
// IR-PCH-NEXT:    store i32 [[TMP9]], ptr [[N_CASTED3]], align 4
// IR-PCH-NEXT:    [[TMP10:%.*]] = load i64, ptr [[N_CASTED3]], align 8
// IR-PCH-NEXT:    [[TMP11:%.*]] = load i32, ptr [[NT]], align 4
// IR-PCH-NEXT:    store i32 [[TMP11]], ptr [[NT_CASTED]], align 4
// IR-PCH-NEXT:    [[TMP12:%.*]] = load i64, ptr [[NT_CASTED]], align 8
// IR-PCH-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55(i64 [[TMP10]], i64 [[TMP12]], i64 [[TMP1]], ptr [[VLA]], i64 [[TMP4]], ptr [[VLA1]]) #[[ATTR3]]
// IR-PCH-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// IR-PCH-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// IR-PCH-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP13]])
// IR-PCH-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RETVAL]], align 4
// IR-PCH-NEXT:    ret i32 [[TMP14]]
//
//
// IR-PCH-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41
// IR-PCH-SAME: (i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2:[0-9]+]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP4]], ptr [[N_CASTED]], align 4
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-PCH-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3:[0-9]+]], i32 5, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41.omp_outlined, i64 [[TMP5]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-PCH-NEXT:    ret void
//
//
// IR-PCH-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41.omp_outlined
// IR-PCH-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[J5:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-PCH-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-PCH-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-PCH-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[J]], align 4
// IR-PCH-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-PCH-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-PCH:       omp.precond.then:
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// IR-PCH-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-PCH-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// IR-PCH-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// IR-PCH-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-PCH:       cond.true:
// IR-PCH-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    br label [[COND_END:%.*]]
// IR-PCH:       cond.false:
// IR-PCH-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    br label [[COND_END]]
// IR-PCH:       cond.end:
// IR-PCH-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// IR-PCH-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// IR-PCH-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-PCH:       omp.inner.for.cond:
// IR-PCH-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// IR-PCH-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-PCH:       omp.inner.for.body:
// IR-PCH-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// IR-PCH-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// IR-PCH-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// IR-PCH-NEXT:    [[TMP21:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP21]], ptr [[N_CASTED]], align 4
// IR-PCH-NEXT:    [[TMP22:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-PCH-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 7, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41.omp_outlined.omp_outlined, i64 [[TMP18]], i64 [[TMP20]], i64 [[TMP22]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-PCH:       omp.inner.for.inc:
// IR-PCH-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4
// IR-PCH-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// IR-PCH-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-PCH:       omp.inner.for.end:
// IR-PCH-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-PCH:       omp.loop.exit:
// IR-PCH-NEXT:    [[TMP25:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP25]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP26]])
// IR-PCH-NEXT:    br label [[OMP_PRECOND_END]]
// IR-PCH:       omp.precond.end:
// IR-PCH-NEXT:    ret void
//
//
// IR-PCH-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l41.omp_outlined.omp_outlined
// IR-PCH-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[J6:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-PCH-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-PCH-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-PCH-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[J]], align 4
// IR-PCH-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-PCH-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-PCH:       omp.precond.then:
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// IR-PCH-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-PCH-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// IR-PCH-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-PCH-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP9]] to i32
// IR-PCH-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_LB]], align 4
// IR-PCH-NEXT:    store i32 [[CONV5]], ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-PCH-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2:[0-9]+]], i32 [[TMP11]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// IR-PCH-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// IR-PCH-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-PCH:       cond.true:
// IR-PCH-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    br label [[COND_END:%.*]]
// IR-PCH:       cond.false:
// IR-PCH-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    br label [[COND_END]]
// IR-PCH:       cond.end:
// IR-PCH-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// IR-PCH-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// IR-PCH-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-PCH:       omp.inner.for.cond:
// IR-PCH-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// IR-PCH-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-PCH:       omp.inner.for.body:
// IR-PCH-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// IR-PCH-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// IR-PCH-NEXT:    store i32 [[ADD]], ptr [[J6]], align 4
// IR-PCH-NEXT:    [[TMP20:%.*]] = load i32, ptr [[J6]], align 4
// IR-PCH-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// IR-PCH-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-PCH-NEXT:    [[TMP21:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-PCH-NEXT:    [[TMP22:%.*]] = load i32, ptr [[J6]], align 4
// IR-PCH-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP22]] to i64
// IR-PCH-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM9]]
// IR-PCH-NEXT:    store i32 [[TMP21]], ptr [[ARRAYIDX10]], align 4
// IR-PCH-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR-PCH:       omp.body.continue:
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-PCH:       omp.inner.for.inc:
// IR-PCH-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP23]], 1
// IR-PCH-NEXT:    store i32 [[ADD11]], ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-PCH:       omp.inner.for.end:
// IR-PCH-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-PCH:       omp.loop.exit:
// IR-PCH-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP24]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP25]])
// IR-PCH-NEXT:    br label [[OMP_PRECOND_END]]
// IR-PCH:       omp.precond.end:
// IR-PCH-NEXT:    ret void
//
//
// IR-PCH-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46
// IR-PCH-SAME: (i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP4]], ptr [[N_CASTED]], align 4
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-PCH-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3]], i32 5, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46.omp_outlined, i64 [[TMP5]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-PCH-NEXT:    ret void
//
//
// IR-PCH-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46.omp_outlined
// IR-PCH-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[I11:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[J12:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// IR-PCH-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-PCH-NEXT:    [[CONV:%.*]] = sext i32 [[DIV]] to i64
// IR-PCH-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP7]], 0
// IR-PCH-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// IR-PCH-NEXT:    [[CONV8:%.*]] = sext i32 [[DIV7]] to i64
// IR-PCH-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV]], [[CONV8]]
// IR-PCH-NEXT:    [[SUB9:%.*]] = sub nsw i64 [[MUL]], 1
// IR-PCH-NEXT:    store i64 [[SUB9]], ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NEXT:    store i32 0, ptr [[I]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[J]], align 4
// IR-PCH-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// IR-PCH-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-PCH:       land.lhs.true:
// IR-PCH-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NEXT:    [[CMP10:%.*]] = icmp slt i32 0, [[TMP9]]
// IR-PCH-NEXT:    br i1 [[CMP10]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END]]
// IR-PCH:       omp.precond.then:
// IR-PCH-NEXT:    store i64 0, ptr [[DOTOMP_COMB_LB]], align 8
// IR-PCH-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NEXT:    store i64 [[TMP10]], ptr [[DOTOMP_COMB_UB]], align 8
// IR-PCH-NEXT:    store i64 1, ptr [[DOTOMP_STRIDE]], align 8
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-PCH-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP12:%.*]] = load i32, ptr [[TMP11]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_init_8(ptr @[[GLOB1]], i32 [[TMP12]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i64 1, i64 1)
// IR-PCH-NEXT:    [[TMP13:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-PCH-NEXT:    [[TMP14:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NEXT:    [[CMP13:%.*]] = icmp sgt i64 [[TMP13]], [[TMP14]]
// IR-PCH-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-PCH:       cond.true:
// IR-PCH-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NEXT:    br label [[COND_END:%.*]]
// IR-PCH:       cond.false:
// IR-PCH-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-PCH-NEXT:    br label [[COND_END]]
// IR-PCH:       cond.end:
// IR-PCH-NEXT:    [[COND:%.*]] = phi i64 [ [[TMP15]], [[COND_TRUE]] ], [ [[TMP16]], [[COND_FALSE]] ]
// IR-PCH-NEXT:    store i64 [[COND]], ptr [[DOTOMP_COMB_UB]], align 8
// IR-PCH-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTOMP_COMB_LB]], align 8
// IR-PCH-NEXT:    store i64 [[TMP17]], ptr [[DOTOMP_IV]], align 8
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-PCH:       omp.inner.for.cond:
// IR-PCH-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-PCH-NEXT:    [[CMP14:%.*]] = icmp sle i64 [[TMP18]], [[TMP19]]
// IR-PCH-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-PCH:       omp.inner.for.body:
// IR-PCH-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_COMB_LB]], align 8
// IR-PCH-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-PCH-NEXT:    [[TMP22:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP22]], ptr [[N_CASTED]], align 4
// IR-PCH-NEXT:    [[TMP23:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-PCH-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 7, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46.omp_outlined.omp_outlined, i64 [[TMP20]], i64 [[TMP21]], i64 [[TMP23]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-PCH:       omp.inner.for.inc:
// IR-PCH-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_STRIDE]], align 8
// IR-PCH-NEXT:    [[ADD:%.*]] = add nsw i64 [[TMP24]], [[TMP25]]
// IR-PCH-NEXT:    store i64 [[ADD]], ptr [[DOTOMP_IV]], align 8
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-PCH:       omp.inner.for.end:
// IR-PCH-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-PCH:       omp.loop.exit:
// IR-PCH-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP27:%.*]] = load i32, ptr [[TMP26]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP27]])
// IR-PCH-NEXT:    br label [[OMP_PRECOND_END]]
// IR-PCH:       omp.precond.end:
// IR-PCH-NEXT:    ret void
//
//
// IR-PCH-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l46.omp_outlined.omp_outlined
// IR-PCH-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[I11:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[J12:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// IR-PCH-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-PCH-NEXT:    [[CONV:%.*]] = sext i32 [[DIV]] to i64
// IR-PCH-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP7]], 0
// IR-PCH-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// IR-PCH-NEXT:    [[CONV8:%.*]] = sext i32 [[DIV7]] to i64
// IR-PCH-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV]], [[CONV8]]
// IR-PCH-NEXT:    [[SUB9:%.*]] = sub nsw i64 [[MUL]], 1
// IR-PCH-NEXT:    store i64 [[SUB9]], ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NEXT:    store i32 0, ptr [[I]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[J]], align 4
// IR-PCH-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// IR-PCH-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-PCH:       land.lhs.true:
// IR-PCH-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NEXT:    [[CMP10:%.*]] = icmp slt i32 0, [[TMP9]]
// IR-PCH-NEXT:    br i1 [[CMP10]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END]]
// IR-PCH:       omp.precond.then:
// IR-PCH-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// IR-PCH-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NEXT:    store i64 [[TMP10]], ptr [[DOTOMP_UB]], align 8
// IR-PCH-NEXT:    [[TMP11:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP12:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[TMP11]], ptr [[DOTOMP_LB]], align 8
// IR-PCH-NEXT:    store i64 [[TMP12]], ptr [[DOTOMP_UB]], align 8
// IR-PCH-NEXT:    store i64 1, ptr [[DOTOMP_STRIDE]], align 8
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-PCH-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP13]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_init_8(ptr @[[GLOB2]], i32 [[TMP14]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i64 1, i64 1)
// IR-PCH-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// IR-PCH-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NEXT:    [[CMP13:%.*]] = icmp sgt i64 [[TMP15]], [[TMP16]]
// IR-PCH-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-PCH:       cond.true:
// IR-PCH-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NEXT:    br label [[COND_END:%.*]]
// IR-PCH:       cond.false:
// IR-PCH-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// IR-PCH-NEXT:    br label [[COND_END]]
// IR-PCH:       cond.end:
// IR-PCH-NEXT:    [[COND:%.*]] = phi i64 [ [[TMP17]], [[COND_TRUE]] ], [ [[TMP18]], [[COND_FALSE]] ]
// IR-PCH-NEXT:    store i64 [[COND]], ptr [[DOTOMP_UB]], align 8
// IR-PCH-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// IR-PCH-NEXT:    store i64 [[TMP19]], ptr [[DOTOMP_IV]], align 8
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-PCH:       omp.inner.for.cond:
// IR-PCH-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// IR-PCH-NEXT:    [[CMP14:%.*]] = icmp sle i64 [[TMP20]], [[TMP21]]
// IR-PCH-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-PCH:       omp.inner.for.body:
// IR-PCH-NEXT:    [[TMP22:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP23]], 0
// IR-PCH-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// IR-PCH-NEXT:    [[MUL17:%.*]] = mul nsw i32 1, [[DIV16]]
// IR-PCH-NEXT:    [[CONV18:%.*]] = sext i32 [[MUL17]] to i64
// IR-PCH-NEXT:    [[DIV19:%.*]] = sdiv i64 [[TMP22]], [[CONV18]]
// IR-PCH-NEXT:    [[MUL20:%.*]] = mul nsw i64 [[DIV19]], 1
// IR-PCH-NEXT:    [[ADD:%.*]] = add nsw i64 0, [[MUL20]]
// IR-PCH-NEXT:    [[CONV21:%.*]] = trunc i64 [[ADD]] to i32
// IR-PCH-NEXT:    store i32 [[CONV21]], ptr [[I11]], align 4
// IR-PCH-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NEXT:    [[SUB22:%.*]] = sub nsw i32 [[TMP26]], 0
// IR-PCH-NEXT:    [[DIV23:%.*]] = sdiv i32 [[SUB22]], 1
// IR-PCH-NEXT:    [[MUL24:%.*]] = mul nsw i32 1, [[DIV23]]
// IR-PCH-NEXT:    [[CONV25:%.*]] = sext i32 [[MUL24]] to i64
// IR-PCH-NEXT:    [[DIV26:%.*]] = sdiv i64 [[TMP25]], [[CONV25]]
// IR-PCH-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NEXT:    [[SUB27:%.*]] = sub nsw i32 [[TMP27]], 0
// IR-PCH-NEXT:    [[DIV28:%.*]] = sdiv i32 [[SUB27]], 1
// IR-PCH-NEXT:    [[MUL29:%.*]] = mul nsw i32 1, [[DIV28]]
// IR-PCH-NEXT:    [[CONV30:%.*]] = sext i32 [[MUL29]] to i64
// IR-PCH-NEXT:    [[MUL31:%.*]] = mul nsw i64 [[DIV26]], [[CONV30]]
// IR-PCH-NEXT:    [[SUB32:%.*]] = sub nsw i64 [[TMP24]], [[MUL31]]
// IR-PCH-NEXT:    [[MUL33:%.*]] = mul nsw i64 [[SUB32]], 1
// IR-PCH-NEXT:    [[ADD34:%.*]] = add nsw i64 0, [[MUL33]]
// IR-PCH-NEXT:    [[CONV35:%.*]] = trunc i64 [[ADD34]] to i32
// IR-PCH-NEXT:    store i32 [[CONV35]], ptr [[J12]], align 4
// IR-PCH-NEXT:    [[TMP28:%.*]] = load i32, ptr [[I11]], align 4
// IR-PCH-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP28]] to i64
// IR-PCH-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-PCH-NEXT:    [[TMP29:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-PCH-NEXT:    [[TMP30:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    [[MUL36:%.*]] = mul nsw i32 [[TMP29]], [[TMP30]]
// IR-PCH-NEXT:    [[TMP31:%.*]] = load i32, ptr [[J12]], align 4
// IR-PCH-NEXT:    [[ADD37:%.*]] = add nsw i32 [[MUL36]], [[TMP31]]
// IR-PCH-NEXT:    [[TMP32:%.*]] = load i32, ptr [[I11]], align 4
// IR-PCH-NEXT:    [[IDXPROM38:%.*]] = sext i32 [[TMP32]] to i64
// IR-PCH-NEXT:    [[ARRAYIDX39:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM38]]
// IR-PCH-NEXT:    store i32 [[ADD37]], ptr [[ARRAYIDX39]], align 4
// IR-PCH-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR-PCH:       omp.body.continue:
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-PCH:       omp.inner.for.inc:
// IR-PCH-NEXT:    [[TMP33:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NEXT:    [[ADD40:%.*]] = add nsw i64 [[TMP33]], 1
// IR-PCH-NEXT:    store i64 [[ADD40]], ptr [[DOTOMP_IV]], align 8
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-PCH:       omp.inner.for.end:
// IR-PCH-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-PCH:       omp.loop.exit:
// IR-PCH-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP35:%.*]] = load i32, ptr [[TMP34]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP35]])
// IR-PCH-NEXT:    br label [[OMP_PRECOND_END]]
// IR-PCH:       omp.precond.end:
// IR-PCH-NEXT:    ret void
//
//
// IR-PCH-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55
// IR-PCH-SAME: (i64 noundef [[N:%.*]], i64 noundef [[NT:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[NT_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[NT_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB3]])
// IR-PCH-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[NT]], ptr [[NT_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP1:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB3]], i32 [[TMP0]], i32 32, i32 0)
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP5]], ptr [[N_CASTED]], align 4
// IR-PCH-NEXT:    [[TMP6:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-PCH-NEXT:    [[TMP7:%.*]] = load i32, ptr [[NT_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP7]], ptr [[NT_CASTED]], align 4
// IR-PCH-NEXT:    [[TMP8:%.*]] = load i64, ptr [[NT_CASTED]], align 8
// IR-PCH-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3]], i32 6, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55.omp_outlined, i64 [[TMP6]], i64 [[TMP8]], i64 [[TMP1]], ptr [[TMP2]], i64 [[TMP3]], ptr [[TMP4]])
// IR-PCH-NEXT:    ret void
//
//
// IR-PCH-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55.omp_outlined
// IR-PCH-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[NT:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[NT_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[I5:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[NT_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[NT]], ptr [[NT_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-PCH-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-PCH-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-PCH-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[I]], align 4
// IR-PCH-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-PCH-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-PCH:       omp.precond.then:
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// IR-PCH-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-PCH-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1]], i32 [[TMP9]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// IR-PCH-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    [[CMP6:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// IR-PCH-NEXT:    br i1 [[CMP6]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-PCH:       cond.true:
// IR-PCH-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    br label [[COND_END:%.*]]
// IR-PCH:       cond.false:
// IR-PCH-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    br label [[COND_END]]
// IR-PCH:       cond.end:
// IR-PCH-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// IR-PCH-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// IR-PCH-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-PCH:       omp.inner.for.cond:
// IR-PCH-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// IR-PCH-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-PCH:       omp.inner.for.body:
// IR-PCH-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// IR-PCH-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// IR-PCH-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// IR-PCH-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// IR-PCH-NEXT:    [[TMP21:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP21]], ptr [[N_CASTED]], align 4
// IR-PCH-NEXT:    [[TMP22:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-PCH-NEXT:    [[TMP23:%.*]] = load i32, ptr [[NT_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP23]], ptr [[NT_CASTED]], align 4
// IR-PCH-NEXT:    [[TMP24:%.*]] = load i64, ptr [[NT_CASTED]], align 8
// IR-PCH-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 8, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55.omp_outlined.omp_outlined, i64 [[TMP18]], i64 [[TMP20]], i64 [[TMP22]], i64 [[TMP24]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-PCH:       omp.inner.for.inc:
// IR-PCH-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4
// IR-PCH-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// IR-PCH-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-PCH:       omp.inner.for.end:
// IR-PCH-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-PCH:       omp.loop.exit:
// IR-PCH-NEXT:    [[TMP27:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP28:%.*]] = load i32, ptr [[TMP27]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP28]])
// IR-PCH-NEXT:    br label [[OMP_PRECOND_END]]
// IR-PCH:       omp.precond.end:
// IR-PCH-NEXT:    ret void
//
//
// IR-PCH-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l55.omp_outlined.omp_outlined
// IR-PCH-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[NT:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-PCH-NEXT:  entry:
// IR-PCH-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[NT_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[I6:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-PCH-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[NT]], ptr [[NT_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// IR-PCH-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-PCH-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// IR-PCH-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[I]], align 4
// IR-PCH-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// IR-PCH-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-PCH:       omp.precond.then:
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// IR-PCH-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-PCH-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// IR-PCH-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-PCH-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP9]] to i32
// IR-PCH-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_LB]], align 4
// IR-PCH-NEXT:    store i32 [[CONV5]], ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// IR-PCH-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-PCH-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2]], i32 [[TMP11]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// IR-PCH-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// IR-PCH-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-PCH:       cond.true:
// IR-PCH-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// IR-PCH-NEXT:    br label [[COND_END:%.*]]
// IR-PCH:       cond.false:
// IR-PCH-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    br label [[COND_END]]
// IR-PCH:       cond.end:
// IR-PCH-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// IR-PCH-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// IR-PCH-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-PCH:       omp.inner.for.cond:
// IR-PCH-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// IR-PCH-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// IR-PCH-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-PCH:       omp.inner.for.body:
// IR-PCH-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// IR-PCH-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// IR-PCH-NEXT:    store i32 [[ADD]], ptr [[I6]], align 4
// IR-PCH-NEXT:    [[TMP20:%.*]] = load i32, ptr [[NT_ADDR]], align 4
// IR-PCH-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP20]], 0
// IR-PCH-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
// IR-PCH:       if.then:
// IR-PCH-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z17omp_get_num_teamsv()
// IR-PCH-NEXT:    store i32 [[CALL]], ptr [[NT_ADDR]], align 4
// IR-PCH-NEXT:    br label [[IF_END]]
// IR-PCH:       if.end:
// IR-PCH-NEXT:    store i32 0, ptr [[J]], align 4
// IR-PCH-NEXT:    br label [[FOR_COND:%.*]]
// IR-PCH:       for.cond:
// IR-PCH-NEXT:    [[TMP21:%.*]] = load i32, ptr [[J]], align 4
// IR-PCH-NEXT:    [[TMP22:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    [[CMP9:%.*]] = icmp slt i32 [[TMP21]], [[TMP22]]
// IR-PCH-NEXT:    br i1 [[CMP9]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// IR-PCH:       for.body:
// IR-PCH-NEXT:    [[TMP23:%.*]] = load i32, ptr [[J]], align 4
// IR-PCH-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP23]] to i64
// IR-PCH-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-PCH-NEXT:    [[TMP24:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-PCH-NEXT:    [[TMP25:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[TMP24]], [[TMP25]]
// IR-PCH-NEXT:    [[TMP26:%.*]] = load i32, ptr [[NT_ADDR]], align 4
// IR-PCH-NEXT:    [[ADD11:%.*]] = add nsw i32 [[MUL10]], [[TMP26]]
// IR-PCH-NEXT:    [[TMP27:%.*]] = load i32, ptr [[J]], align 4
// IR-PCH-NEXT:    [[IDXPROM12:%.*]] = sext i32 [[TMP27]] to i64
// IR-PCH-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM12]]
// IR-PCH-NEXT:    store i32 [[ADD11]], ptr [[ARRAYIDX13]], align 4
// IR-PCH-NEXT:    br label [[FOR_INC:%.*]]
// IR-PCH:       for.inc:
// IR-PCH-NEXT:    [[TMP28:%.*]] = load i32, ptr [[J]], align 4
// IR-PCH-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP28]], 1
// IR-PCH-NEXT:    store i32 [[INC]], ptr [[J]], align 4
// IR-PCH-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// IR-PCH:       for.end:
// IR-PCH-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR-PCH:       omp.body.continue:
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-PCH:       omp.inner.for.inc:
// IR-PCH-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP29]], 1
// IR-PCH-NEXT:    store i32 [[ADD14]], ptr [[DOTOMP_IV]], align 4
// IR-PCH-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-PCH:       omp.inner.for.end:
// IR-PCH-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-PCH:       omp.loop.exit:
// IR-PCH-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NEXT:    [[TMP31:%.*]] = load i32, ptr [[TMP30]], align 4
// IR-PCH-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP31]])
// IR-PCH-NEXT:    br label [[OMP_PRECOND_END]]
// IR-PCH:       omp.precond.end:
// IR-PCH-NEXT:    ret void
//
//
// IR-GPU-NESTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64
// IR-GPU-NESTED-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR0:[0-9]+]] {
// IR-GPU-NESTED-NEXT:  entry:
// IR-GPU-NESTED-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTZERO_ADDR:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[VLA_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR2]] to ptr
// IR-GPU-NESTED-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[N_CASTED_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_CASTED]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTZERO_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTZERO_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTTHREADID_TEMP__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTTHREADID_TEMP_]] to ptr
// IR-GPU-NESTED-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_target_init(ptr addrspacecast (ptr addrspace(1) @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64_kernel_environment to ptr), ptr [[DYN_PTR]])
// IR-GPU-NESTED-NEXT:    [[EXEC_USER_CODE:%.*]] = icmp eq i32 [[TMP4]], -1
// IR-GPU-NESTED-NEXT:    br i1 [[EXEC_USER_CODE]], label [[USER_CODE_ENTRY:%.*]], label [[WORKER_EXIT:%.*]]
// IR-GPU-NESTED:       user_code.entry:
// IR-GPU-NESTED-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_global_thread_num(ptr addrspacecast (ptr addrspace(1) @[[GLOB1:[0-9]+]] to ptr))
// IR-GPU-NESTED-NEXT:    [[TMP6:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    store i32 [[TMP6]], ptr [[N_CASTED_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[TMP7:%.*]] = load i64, ptr [[N_CASTED_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i32 0, ptr [[DOTZERO_ADDR_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    store i32 [[TMP5]], ptr [[DOTTHREADID_TEMP__ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64_omp_outlined(ptr [[DOTTHREADID_TEMP__ASCAST]], ptr [[DOTZERO_ADDR_ASCAST]], i64 [[TMP7]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]]) #[[ATTR2:[0-9]+]]
// IR-GPU-NESTED-NEXT:    call void @__kmpc_target_deinit()
// IR-GPU-NESTED-NEXT:    ret void
// IR-GPU-NESTED:       worker.exit:
// IR-GPU-NESTED-NEXT:    ret void
//
//
// IR-GPU-NESTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64_omp_outlined
// IR-GPU-NESTED-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR1:[0-9]+]] {
// IR-GPU-NESTED-NEXT:  entry:
// IR-GPU-NESTED-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[J:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[I11:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[J12:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[CAPTURED_VARS_ADDRS:%.*]] = alloca [7 x ptr], align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTGLOBAL_TID__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTGLOBAL_TID__ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTBOUND_TID__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTBOUND_TID__ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[VLA_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR2]] to ptr
// IR-GPU-NESTED-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// IR-GPU-NESTED-NEXT:    [[TMP_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[TMP]] to ptr
// IR-GPU-NESTED-NEXT:    [[TMP3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[_TMP3]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTCAPTURE_EXPR__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTCAPTURE_EXPR_4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_4]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTCAPTURE_EXPR_5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_5]] to ptr
// IR-GPU-NESTED-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// IR-GPU-NESTED-NEXT:    [[J_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[J]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTOMP_COMB_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_COMB_LB]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTOMP_COMB_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_COMB_UB]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTOMP_STRIDE_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_STRIDE]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTOMP_IS_LAST_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IS_LAST]] to ptr
// IR-GPU-NESTED-NEXT:    [[I11_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I11]] to ptr
// IR-GPU-NESTED-NEXT:    [[J12_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[J12]] to ptr
// IR-GPU-NESTED-NEXT:    [[N_CASTED_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_CASTED]] to ptr
// IR-GPU-NESTED-NEXT:    [[CAPTURED_VARS_ADDRS_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[CAPTURED_VARS_ADDRS]] to ptr
// IR-GPU-NESTED-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_4_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// IR-GPU-NESTED-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-GPU-NESTED-NEXT:    [[CONV:%.*]] = sext i32 [[DIV]] to i64
// IR-GPU-NESTED-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP7]], 0
// IR-GPU-NESTED-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// IR-GPU-NESTED-NEXT:    [[CONV8:%.*]] = sext i32 [[DIV7]] to i64
// IR-GPU-NESTED-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV]], [[CONV8]]
// IR-GPU-NESTED-NEXT:    [[SUB9:%.*]] = sub nsw i64 [[MUL]], 1
// IR-GPU-NESTED-NEXT:    store i64 [[SUB9]], ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    store i32 0, ptr [[J_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// IR-GPU-NESTED-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-GPU-NESTED:       land.lhs.true:
// IR-GPU-NESTED-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[CMP10:%.*]] = icmp slt i32 0, [[TMP9]]
// IR-GPU-NESTED-NEXT:    br i1 [[CMP10]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END]]
// IR-GPU-NESTED:       omp.precond.then:
// IR-GPU-NESTED-NEXT:    store i64 0, ptr [[DOTOMP_COMB_LB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[TMP10]], ptr [[DOTOMP_COMB_UB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 1, ptr [[DOTOMP_STRIDE_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// IR-GPU-NESTED-NEXT:    [[CONV13:%.*]] = zext i32 [[NVPTX_NUM_THREADS]] to i64
// IR-GPU-NESTED-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP12:%.*]] = load i32, ptr [[TMP11]], align 4
// IR-GPU-NESTED-NEXT:    call void @__kmpc_distribute_static_init_8(ptr addrspacecast (ptr addrspace(1) @[[GLOB2:[0-9]+]] to ptr), i32 [[TMP12]], i32 91, ptr [[DOTOMP_IS_LAST_ASCAST]], ptr [[DOTOMP_COMB_LB_ASCAST]], ptr [[DOTOMP_COMB_UB_ASCAST]], ptr [[DOTOMP_STRIDE_ASCAST]], i64 1, i64 [[CONV13]])
// IR-GPU-NESTED-NEXT:    [[TMP13:%.*]] = load i64, ptr [[DOTOMP_COMB_UB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP14:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[CMP14:%.*]] = icmp sgt i64 [[TMP13]], [[TMP14]]
// IR-GPU-NESTED-NEXT:    br i1 [[CMP14]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-GPU-NESTED:       cond.true:
// IR-GPU-NESTED-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    br label [[COND_END:%.*]]
// IR-GPU-NESTED:       cond.false:
// IR-GPU-NESTED-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTOMP_COMB_UB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    br label [[COND_END]]
// IR-GPU-NESTED:       cond.end:
// IR-GPU-NESTED-NEXT:    [[COND:%.*]] = phi i64 [ [[TMP15]], [[COND_TRUE]] ], [ [[TMP16]], [[COND_FALSE]] ]
// IR-GPU-NESTED-NEXT:    store i64 [[COND]], ptr [[DOTOMP_COMB_UB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTOMP_COMB_LB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[TMP17]], ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-GPU-NESTED:       omp.inner.for.cond:
// IR-GPU-NESTED-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[ADD:%.*]] = add nsw i64 [[TMP19]], 1
// IR-GPU-NESTED-NEXT:    [[CMP15:%.*]] = icmp slt i64 [[TMP18]], [[ADD]]
// IR-GPU-NESTED-NEXT:    br i1 [[CMP15]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-GPU-NESTED:       omp.inner.for.body:
// IR-GPU-NESTED-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_COMB_LB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_COMB_UB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP22:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    store i32 [[TMP22]], ptr [[N_CASTED_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[TMP23:%.*]] = load i64, ptr [[N_CASTED_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [7 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 0
// IR-GPU-NESTED-NEXT:    [[TMP25:%.*]] = inttoptr i64 [[TMP20]] to ptr
// IR-GPU-NESTED-NEXT:    store ptr [[TMP25]], ptr [[TMP24]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [7 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 1
// IR-GPU-NESTED-NEXT:    [[TMP27:%.*]] = inttoptr i64 [[TMP21]] to ptr
// IR-GPU-NESTED-NEXT:    store ptr [[TMP27]], ptr [[TMP26]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [7 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 2
// IR-GPU-NESTED-NEXT:    [[TMP29:%.*]] = inttoptr i64 [[TMP23]] to ptr
// IR-GPU-NESTED-NEXT:    store ptr [[TMP29]], ptr [[TMP28]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [7 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 3
// IR-GPU-NESTED-NEXT:    [[TMP31:%.*]] = inttoptr i64 [[TMP0]] to ptr
// IR-GPU-NESTED-NEXT:    store ptr [[TMP31]], ptr [[TMP30]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [7 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 4
// IR-GPU-NESTED-NEXT:    store ptr [[TMP1]], ptr [[TMP32]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [7 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 5
// IR-GPU-NESTED-NEXT:    [[TMP34:%.*]] = inttoptr i64 [[TMP2]] to ptr
// IR-GPU-NESTED-NEXT:    store ptr [[TMP34]], ptr [[TMP33]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [7 x ptr], ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 0, i64 6
// IR-GPU-NESTED-NEXT:    store ptr [[TMP3]], ptr [[TMP35]], align 8
// IR-GPU-NESTED-NEXT:    call void @__kmpc_parallel_spmd(ptr addrspacecast (ptr addrspace(1) @[[GLOB1]] to ptr), i32 -1, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64_omp_outlined_omp_outlined, ptr [[CAPTURED_VARS_ADDRS_ASCAST]], i64 7)
// IR-GPU-NESTED-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-GPU-NESTED:       omp.inner.for.inc:
// IR-GPU-NESTED-NEXT:    [[TMP36:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP37:%.*]] = load i64, ptr [[DOTOMP_STRIDE_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[ADD16:%.*]] = add nsw i64 [[TMP36]], [[TMP37]]
// IR-GPU-NESTED-NEXT:    store i64 [[ADD16]], ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP38:%.*]] = load i64, ptr [[DOTOMP_COMB_LB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP39:%.*]] = load i64, ptr [[DOTOMP_STRIDE_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[ADD17:%.*]] = add nsw i64 [[TMP38]], [[TMP39]]
// IR-GPU-NESTED-NEXT:    store i64 [[ADD17]], ptr [[DOTOMP_COMB_LB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP40:%.*]] = load i64, ptr [[DOTOMP_COMB_UB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP41:%.*]] = load i64, ptr [[DOTOMP_STRIDE_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[ADD18:%.*]] = add nsw i64 [[TMP40]], [[TMP41]]
// IR-GPU-NESTED-NEXT:    store i64 [[ADD18]], ptr [[DOTOMP_COMB_UB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP42:%.*]] = load i64, ptr [[DOTOMP_COMB_UB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP43:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[CMP19:%.*]] = icmp sgt i64 [[TMP42]], [[TMP43]]
// IR-GPU-NESTED-NEXT:    br i1 [[CMP19]], label [[COND_TRUE20:%.*]], label [[COND_FALSE21:%.*]]
// IR-GPU-NESTED:       cond.true20:
// IR-GPU-NESTED-NEXT:    [[TMP44:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    br label [[COND_END22:%.*]]
// IR-GPU-NESTED:       cond.false21:
// IR-GPU-NESTED-NEXT:    [[TMP45:%.*]] = load i64, ptr [[DOTOMP_COMB_UB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    br label [[COND_END22]]
// IR-GPU-NESTED:       cond.end22:
// IR-GPU-NESTED-NEXT:    [[COND23:%.*]] = phi i64 [ [[TMP44]], [[COND_TRUE20]] ], [ [[TMP45]], [[COND_FALSE21]] ]
// IR-GPU-NESTED-NEXT:    store i64 [[COND23]], ptr [[DOTOMP_COMB_UB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP46:%.*]] = load i64, ptr [[DOTOMP_COMB_LB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[TMP46]], ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-GPU-NESTED:       omp.inner.for.end:
// IR-GPU-NESTED-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-GPU-NESTED:       omp.loop.exit:
// IR-GPU-NESTED-NEXT:    [[TMP47:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP48:%.*]] = load i32, ptr [[TMP47]], align 4
// IR-GPU-NESTED-NEXT:    call void @__kmpc_distribute_static_fini(ptr addrspacecast (ptr addrspace(1) @[[GLOB2]] to ptr), i32 [[TMP48]])
// IR-GPU-NESTED-NEXT:    br label [[OMP_PRECOND_END]]
// IR-GPU-NESTED:       omp.precond.end:
// IR-GPU-NESTED-NEXT:    ret void
//
//
// IR-GPU-NESTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64_omp_outlined_omp_outlined
// IR-GPU-NESTED-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR1]] {
// IR-GPU-NESTED-NEXT:  entry:
// IR-GPU-NESTED-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[J:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[I11:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[J12:%.*]] = alloca i32, align 4, addrspace(5)
// IR-GPU-NESTED-NEXT:    [[DOTGLOBAL_TID__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTGLOBAL_TID__ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTBOUND_TID__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTBOUND_TID__ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTPREVIOUS_LB__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTPREVIOUS_LB__ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTPREVIOUS_UB__ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTPREVIOUS_UB__ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[VLA_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR2]] to ptr
// IR-GPU-NESTED-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// IR-GPU-NESTED-NEXT:    [[TMP_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[TMP]] to ptr
// IR-GPU-NESTED-NEXT:    [[TMP3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[_TMP3]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTCAPTURE_EXPR__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTCAPTURE_EXPR_4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_4]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTCAPTURE_EXPR_5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_5]] to ptr
// IR-GPU-NESTED-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// IR-GPU-NESTED-NEXT:    [[J_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[J]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTOMP_STRIDE_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_STRIDE]] to ptr
// IR-GPU-NESTED-NEXT:    [[DOTOMP_IS_LAST_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IS_LAST]] to ptr
// IR-GPU-NESTED-NEXT:    [[I11_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I11]] to ptr
// IR-GPU-NESTED-NEXT:    [[J12_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[J12]] to ptr
// IR-GPU-NESTED-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_4_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// IR-GPU-NESTED-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-GPU-NESTED-NEXT:    [[CONV:%.*]] = sext i32 [[DIV]] to i64
// IR-GPU-NESTED-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP7]], 0
// IR-GPU-NESTED-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// IR-GPU-NESTED-NEXT:    [[CONV8:%.*]] = sext i32 [[DIV7]] to i64
// IR-GPU-NESTED-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV]], [[CONV8]]
// IR-GPU-NESTED-NEXT:    [[SUB9:%.*]] = sub nsw i64 [[MUL]], 1
// IR-GPU-NESTED-NEXT:    store i64 [[SUB9]], ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    store i32 0, ptr [[J_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// IR-GPU-NESTED-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-GPU-NESTED:       land.lhs.true:
// IR-GPU-NESTED-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[CMP10:%.*]] = icmp slt i32 0, [[TMP9]]
// IR-GPU-NESTED-NEXT:    br i1 [[CMP10]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END]]
// IR-GPU-NESTED:       omp.precond.then:
// IR-GPU-NESTED-NEXT:    store i64 0, ptr [[DOTOMP_LB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[TMP10]], ptr [[DOTOMP_UB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP11:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP12:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[TMP11]], ptr [[DOTOMP_LB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[TMP12]], ptr [[DOTOMP_UB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 1, ptr [[DOTOMP_STRIDE_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP13]], align 4
// IR-GPU-NESTED-NEXT:    call void @__kmpc_for_static_init_8(ptr addrspacecast (ptr addrspace(1) @[[GLOB3:[0-9]+]] to ptr), i32 [[TMP14]], i32 33, ptr [[DOTOMP_IS_LAST_ASCAST]], ptr [[DOTOMP_LB_ASCAST]], ptr [[DOTOMP_UB_ASCAST]], ptr [[DOTOMP_STRIDE_ASCAST]], i64 1, i64 1)
// IR-GPU-NESTED-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTOMP_LB_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    store i64 [[TMP15]], ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-GPU-NESTED:       omp.inner.for.cond:
// IR-GPU-NESTED-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[CMP13:%.*]] = icmp ule i64 [[TMP16]], [[TMP17]]
// IR-GPU-NESTED-NEXT:    br i1 [[CMP13]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-GPU-NESTED:       omp.inner.for.body:
// IR-GPU-NESTED-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[SUB14:%.*]] = sub nsw i32 [[TMP19]], 0
// IR-GPU-NESTED-NEXT:    [[DIV15:%.*]] = sdiv i32 [[SUB14]], 1
// IR-GPU-NESTED-NEXT:    [[MUL16:%.*]] = mul nsw i32 1, [[DIV15]]
// IR-GPU-NESTED-NEXT:    [[CONV17:%.*]] = sext i32 [[MUL16]] to i64
// IR-GPU-NESTED-NEXT:    [[DIV18:%.*]] = sdiv i64 [[TMP18]], [[CONV17]]
// IR-GPU-NESTED-NEXT:    [[MUL19:%.*]] = mul nsw i64 [[DIV18]], 1
// IR-GPU-NESTED-NEXT:    [[ADD:%.*]] = add nsw i64 0, [[MUL19]]
// IR-GPU-NESTED-NEXT:    [[CONV20:%.*]] = trunc i64 [[ADD]] to i32
// IR-GPU-NESTED-NEXT:    store i32 [[CONV20]], ptr [[I11_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[SUB21:%.*]] = sub nsw i32 [[TMP22]], 0
// IR-GPU-NESTED-NEXT:    [[DIV22:%.*]] = sdiv i32 [[SUB21]], 1
// IR-GPU-NESTED-NEXT:    [[MUL23:%.*]] = mul nsw i32 1, [[DIV22]]
// IR-GPU-NESTED-NEXT:    [[CONV24:%.*]] = sext i32 [[MUL23]] to i64
// IR-GPU-NESTED-NEXT:    [[DIV25:%.*]] = sdiv i64 [[TMP21]], [[CONV24]]
// IR-GPU-NESTED-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[SUB26:%.*]] = sub nsw i32 [[TMP23]], 0
// IR-GPU-NESTED-NEXT:    [[DIV27:%.*]] = sdiv i32 [[SUB26]], 1
// IR-GPU-NESTED-NEXT:    [[MUL28:%.*]] = mul nsw i32 1, [[DIV27]]
// IR-GPU-NESTED-NEXT:    [[CONV29:%.*]] = sext i32 [[MUL28]] to i64
// IR-GPU-NESTED-NEXT:    [[MUL30:%.*]] = mul nsw i64 [[DIV25]], [[CONV29]]
// IR-GPU-NESTED-NEXT:    [[SUB31:%.*]] = sub nsw i64 [[TMP20]], [[MUL30]]
// IR-GPU-NESTED-NEXT:    [[MUL32:%.*]] = mul nsw i64 [[SUB31]], 1
// IR-GPU-NESTED-NEXT:    [[ADD33:%.*]] = add nsw i64 0, [[MUL32]]
// IR-GPU-NESTED-NEXT:    [[CONV34:%.*]] = trunc i64 [[ADD33]] to i32
// IR-GPU-NESTED-NEXT:    store i32 [[CONV34]], ptr [[J12_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I11_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP24]] to i64
// IR-GPU-NESTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-GPU-NESTED-NEXT:    [[TMP25:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-GPU-NESTED-NEXT:    [[TMP26:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[MUL35:%.*]] = mul nsw i32 [[TMP25]], [[TMP26]]
// IR-GPU-NESTED-NEXT:    [[TMP27:%.*]] = load i32, ptr [[J12_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z3fooi(i32 noundef [[TMP27]]) #[[ATTR5:[0-9]+]]
// IR-GPU-NESTED-NEXT:    [[ADD36:%.*]] = add nsw i32 [[MUL35]], [[CALL]]
// IR-GPU-NESTED-NEXT:    [[TMP28:%.*]] = load i32, ptr [[I11_ASCAST]], align 4
// IR-GPU-NESTED-NEXT:    [[IDXPROM37:%.*]] = sext i32 [[TMP28]] to i64
// IR-GPU-NESTED-NEXT:    [[ARRAYIDX38:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM37]]
// IR-GPU-NESTED-NEXT:    store i32 [[ADD36]], ptr [[ARRAYIDX38]], align 4
// IR-GPU-NESTED-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR-GPU-NESTED:       omp.body.continue:
// IR-GPU-NESTED-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-GPU-NESTED:       omp.inner.for.inc:
// IR-GPU-NESTED-NEXT:    [[TMP29:%.*]] = load i64, ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP30:%.*]] = load i64, ptr [[DOTOMP_STRIDE_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[ADD39:%.*]] = add nsw i64 [[TMP29]], [[TMP30]]
// IR-GPU-NESTED-NEXT:    store i64 [[ADD39]], ptr [[DOTOMP_IV_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-GPU-NESTED:       omp.inner.for.end:
// IR-GPU-NESTED-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-GPU-NESTED:       omp.loop.exit:
// IR-GPU-NESTED-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR_ASCAST]], align 8
// IR-GPU-NESTED-NEXT:    [[TMP32:%.*]] = load i32, ptr [[TMP31]], align 4
// IR-GPU-NESTED-NEXT:    call void @__kmpc_for_static_fini(ptr addrspacecast (ptr addrspace(1) @[[GLOB3]] to ptr), i32 [[TMP32]])
// IR-GPU-NESTED-NEXT:    br label [[OMP_PRECOND_END]]
// IR-GPU-NESTED:       omp.precond.end:
// IR-GPU-NESTED-NEXT:    ret void
//
//
// IR-NESTED-LABEL: define {{[^@]+}}@main
// IR-NESTED-SAME: () #[[ATTR0:[0-9]+]] {
// IR-NESTED-NEXT:  entry:
// IR-NESTED-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// IR-NESTED-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// IR-NESTED-NEXT:    [[TMP0:%.*]] = load i32, ptr @N, align 4
// IR-NESTED-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// IR-NESTED-NEXT:    [[TMP2:%.*]] = call ptr @llvm.stacksave.p0()
// IR-NESTED-NEXT:    store ptr [[TMP2]], ptr [[SAVED_STACK]], align 8
// IR-NESTED-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 16
// IR-NESTED-NEXT:    store i64 [[TMP1]], ptr [[__VLA_EXPR0]], align 8
// IR-NESTED-NEXT:    [[TMP3:%.*]] = load i32, ptr @N, align 4
// IR-NESTED-NEXT:    [[TMP4:%.*]] = zext i32 [[TMP3]] to i64
// IR-NESTED-NEXT:    [[VLA1:%.*]] = alloca i32, i64 [[TMP4]], align 16
// IR-NESTED-NEXT:    store i64 [[TMP4]], ptr [[__VLA_EXPR1]], align 8
// IR-NESTED-NEXT:    [[TMP5:%.*]] = load i32, ptr @N, align 4
// IR-NESTED-NEXT:    store i32 [[TMP5]], ptr [[N_CASTED]], align 4
// IR-NESTED-NEXT:    [[TMP6:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-NESTED-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64(i64 [[TMP6]], i64 [[TMP1]], ptr [[VLA]], i64 [[TMP4]], ptr [[VLA1]]) #[[ATTR3:[0-9]+]]
// IR-NESTED-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// IR-NESTED-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// IR-NESTED-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP7]])
// IR-NESTED-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RETVAL]], align 4
// IR-NESTED-NEXT:    ret i32 [[TMP8]]
//
//
// IR-NESTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64
// IR-NESTED-SAME: (i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2:[0-9]+]] {
// IR-NESTED-NEXT:  entry:
// IR-NESTED-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NESTED-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NESTED-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NESTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NESTED-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NESTED-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NESTED-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NESTED-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NESTED-NEXT:    store i32 [[TMP4]], ptr [[N_CASTED]], align 4
// IR-NESTED-NEXT:    [[TMP5:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-NESTED-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3:[0-9]+]], i32 5, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64.omp_outlined, i64 [[TMP5]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-NESTED-NEXT:    ret void
//
//
// IR-NESTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64.omp_outlined
// IR-NESTED-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-NESTED-NEXT:  entry:
// IR-NESTED-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NESTED-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NESTED-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NESTED-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NESTED-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[I11:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[J12:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NESTED-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-NESTED-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NESTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NESTED-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NESTED-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NESTED-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NESTED-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NESTED-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NESTED-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NESTED-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NESTED-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NESTED-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// IR-NESTED-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-NESTED-NEXT:    [[CONV:%.*]] = sext i32 [[DIV]] to i64
// IR-NESTED-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NESTED-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP7]], 0
// IR-NESTED-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// IR-NESTED-NEXT:    [[CONV8:%.*]] = sext i32 [[DIV7]] to i64
// IR-NESTED-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV]], [[CONV8]]
// IR-NESTED-NEXT:    [[SUB9:%.*]] = sub nsw i64 [[MUL]], 1
// IR-NESTED-NEXT:    store i64 [[SUB9]], ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NESTED-NEXT:    store i32 0, ptr [[I]], align 4
// IR-NESTED-NEXT:    store i32 0, ptr [[J]], align 4
// IR-NESTED-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NESTED-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// IR-NESTED-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-NESTED:       land.lhs.true:
// IR-NESTED-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NESTED-NEXT:    [[CMP10:%.*]] = icmp slt i32 0, [[TMP9]]
// IR-NESTED-NEXT:    br i1 [[CMP10]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END]]
// IR-NESTED:       omp.precond.then:
// IR-NESTED-NEXT:    store i64 0, ptr [[DOTOMP_COMB_LB]], align 8
// IR-NESTED-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NESTED-NEXT:    store i64 [[TMP10]], ptr [[DOTOMP_COMB_UB]], align 8
// IR-NESTED-NEXT:    store i64 1, ptr [[DOTOMP_STRIDE]], align 8
// IR-NESTED-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-NESTED-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP12:%.*]] = load i32, ptr [[TMP11]], align 4
// IR-NESTED-NEXT:    call void @__kmpc_for_static_init_8(ptr @[[GLOB1:[0-9]+]], i32 [[TMP12]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i64 1, i64 1)
// IR-NESTED-NEXT:    [[TMP13:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-NESTED-NEXT:    [[TMP14:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NESTED-NEXT:    [[CMP13:%.*]] = icmp sgt i64 [[TMP13]], [[TMP14]]
// IR-NESTED-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-NESTED:       cond.true:
// IR-NESTED-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NESTED-NEXT:    br label [[COND_END:%.*]]
// IR-NESTED:       cond.false:
// IR-NESTED-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-NESTED-NEXT:    br label [[COND_END]]
// IR-NESTED:       cond.end:
// IR-NESTED-NEXT:    [[COND:%.*]] = phi i64 [ [[TMP15]], [[COND_TRUE]] ], [ [[TMP16]], [[COND_FALSE]] ]
// IR-NESTED-NEXT:    store i64 [[COND]], ptr [[DOTOMP_COMB_UB]], align 8
// IR-NESTED-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTOMP_COMB_LB]], align 8
// IR-NESTED-NEXT:    store i64 [[TMP17]], ptr [[DOTOMP_IV]], align 8
// IR-NESTED-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-NESTED:       omp.inner.for.cond:
// IR-NESTED-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NESTED-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-NESTED-NEXT:    [[CMP14:%.*]] = icmp sle i64 [[TMP18]], [[TMP19]]
// IR-NESTED-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-NESTED:       omp.inner.for.body:
// IR-NESTED-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_COMB_LB]], align 8
// IR-NESTED-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-NESTED-NEXT:    [[TMP22:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NESTED-NEXT:    store i32 [[TMP22]], ptr [[N_CASTED]], align 4
// IR-NESTED-NEXT:    [[TMP23:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-NESTED-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 7, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64.omp_outlined.omp_outlined, i64 [[TMP20]], i64 [[TMP21]], i64 [[TMP23]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-NESTED-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-NESTED:       omp.inner.for.inc:
// IR-NESTED-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NESTED-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_STRIDE]], align 8
// IR-NESTED-NEXT:    [[ADD:%.*]] = add nsw i64 [[TMP24]], [[TMP25]]
// IR-NESTED-NEXT:    store i64 [[ADD]], ptr [[DOTOMP_IV]], align 8
// IR-NESTED-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-NESTED:       omp.inner.for.end:
// IR-NESTED-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-NESTED:       omp.loop.exit:
// IR-NESTED-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP27:%.*]] = load i32, ptr [[TMP26]], align 4
// IR-NESTED-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP27]])
// IR-NESTED-NEXT:    br label [[OMP_PRECOND_END]]
// IR-NESTED:       omp.precond.end:
// IR-NESTED-NEXT:    ret void
//
//
// IR-NESTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64.omp_outlined.omp_outlined
// IR-NESTED-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-NESTED-NEXT:  entry:
// IR-NESTED-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NESTED-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-NESTED-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-NESTED-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-NESTED-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// IR-NESTED-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[I11:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    [[J12:%.*]] = alloca i32, align 4
// IR-NESTED-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NESTED-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-NESTED-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-NESTED-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-NESTED-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-NESTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-NESTED-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-NESTED-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-NESTED-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-NESTED-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NESTED-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NESTED-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NESTED-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NESTED-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NESTED-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// IR-NESTED-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-NESTED-NEXT:    [[CONV:%.*]] = sext i32 [[DIV]] to i64
// IR-NESTED-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NESTED-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP7]], 0
// IR-NESTED-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// IR-NESTED-NEXT:    [[CONV8:%.*]] = sext i32 [[DIV7]] to i64
// IR-NESTED-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV]], [[CONV8]]
// IR-NESTED-NEXT:    [[SUB9:%.*]] = sub nsw i64 [[MUL]], 1
// IR-NESTED-NEXT:    store i64 [[SUB9]], ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NESTED-NEXT:    store i32 0, ptr [[I]], align 4
// IR-NESTED-NEXT:    store i32 0, ptr [[J]], align 4
// IR-NESTED-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-NESTED-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// IR-NESTED-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-NESTED:       land.lhs.true:
// IR-NESTED-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NESTED-NEXT:    [[CMP10:%.*]] = icmp slt i32 0, [[TMP9]]
// IR-NESTED-NEXT:    br i1 [[CMP10]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END]]
// IR-NESTED:       omp.precond.then:
// IR-NESTED-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// IR-NESTED-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NESTED-NEXT:    store i64 [[TMP10]], ptr [[DOTOMP_UB]], align 8
// IR-NESTED-NEXT:    [[TMP11:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP12:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-NESTED-NEXT:    store i64 [[TMP11]], ptr [[DOTOMP_LB]], align 8
// IR-NESTED-NEXT:    store i64 [[TMP12]], ptr [[DOTOMP_UB]], align 8
// IR-NESTED-NEXT:    store i64 1, ptr [[DOTOMP_STRIDE]], align 8
// IR-NESTED-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-NESTED-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP13]], align 4
// IR-NESTED-NEXT:    call void @__kmpc_for_static_init_8(ptr @[[GLOB2:[0-9]+]], i32 [[TMP14]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i64 1, i64 1)
// IR-NESTED-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// IR-NESTED-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NESTED-NEXT:    [[CMP13:%.*]] = icmp sgt i64 [[TMP15]], [[TMP16]]
// IR-NESTED-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-NESTED:       cond.true:
// IR-NESTED-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-NESTED-NEXT:    br label [[COND_END:%.*]]
// IR-NESTED:       cond.false:
// IR-NESTED-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// IR-NESTED-NEXT:    br label [[COND_END]]
// IR-NESTED:       cond.end:
// IR-NESTED-NEXT:    [[COND:%.*]] = phi i64 [ [[TMP17]], [[COND_TRUE]] ], [ [[TMP18]], [[COND_FALSE]] ]
// IR-NESTED-NEXT:    store i64 [[COND]], ptr [[DOTOMP_UB]], align 8
// IR-NESTED-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// IR-NESTED-NEXT:    store i64 [[TMP19]], ptr [[DOTOMP_IV]], align 8
// IR-NESTED-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-NESTED:       omp.inner.for.cond:
// IR-NESTED-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NESTED-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// IR-NESTED-NEXT:    [[CMP14:%.*]] = icmp sle i64 [[TMP20]], [[TMP21]]
// IR-NESTED-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-NESTED:       omp.inner.for.body:
// IR-NESTED-NEXT:    [[TMP22:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NESTED-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NESTED-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP23]], 0
// IR-NESTED-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// IR-NESTED-NEXT:    [[MUL17:%.*]] = mul nsw i32 1, [[DIV16]]
// IR-NESTED-NEXT:    [[CONV18:%.*]] = sext i32 [[MUL17]] to i64
// IR-NESTED-NEXT:    [[DIV19:%.*]] = sdiv i64 [[TMP22]], [[CONV18]]
// IR-NESTED-NEXT:    [[MUL20:%.*]] = mul nsw i64 [[DIV19]], 1
// IR-NESTED-NEXT:    [[ADD:%.*]] = add nsw i64 0, [[MUL20]]
// IR-NESTED-NEXT:    [[CONV21:%.*]] = trunc i64 [[ADD]] to i32
// IR-NESTED-NEXT:    store i32 [[CONV21]], ptr [[I11]], align 4
// IR-NESTED-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NESTED-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NESTED-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NESTED-NEXT:    [[SUB22:%.*]] = sub nsw i32 [[TMP26]], 0
// IR-NESTED-NEXT:    [[DIV23:%.*]] = sdiv i32 [[SUB22]], 1
// IR-NESTED-NEXT:    [[MUL24:%.*]] = mul nsw i32 1, [[DIV23]]
// IR-NESTED-NEXT:    [[CONV25:%.*]] = sext i32 [[MUL24]] to i64
// IR-NESTED-NEXT:    [[DIV26:%.*]] = sdiv i64 [[TMP25]], [[CONV25]]
// IR-NESTED-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-NESTED-NEXT:    [[SUB27:%.*]] = sub nsw i32 [[TMP27]], 0
// IR-NESTED-NEXT:    [[DIV28:%.*]] = sdiv i32 [[SUB27]], 1
// IR-NESTED-NEXT:    [[MUL29:%.*]] = mul nsw i32 1, [[DIV28]]
// IR-NESTED-NEXT:    [[CONV30:%.*]] = sext i32 [[MUL29]] to i64
// IR-NESTED-NEXT:    [[MUL31:%.*]] = mul nsw i64 [[DIV26]], [[CONV30]]
// IR-NESTED-NEXT:    [[SUB32:%.*]] = sub nsw i64 [[TMP24]], [[MUL31]]
// IR-NESTED-NEXT:    [[MUL33:%.*]] = mul nsw i64 [[SUB32]], 1
// IR-NESTED-NEXT:    [[ADD34:%.*]] = add nsw i64 0, [[MUL33]]
// IR-NESTED-NEXT:    [[CONV35:%.*]] = trunc i64 [[ADD34]] to i32
// IR-NESTED-NEXT:    store i32 [[CONV35]], ptr [[J12]], align 4
// IR-NESTED-NEXT:    [[TMP28:%.*]] = load i32, ptr [[I11]], align 4
// IR-NESTED-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP28]] to i64
// IR-NESTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-NESTED-NEXT:    [[TMP29:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-NESTED-NEXT:    [[TMP30:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-NESTED-NEXT:    [[MUL36:%.*]] = mul nsw i32 [[TMP29]], [[TMP30]]
// IR-NESTED-NEXT:    [[TMP31:%.*]] = load i32, ptr [[J12]], align 4
// IR-NESTED-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z3fooi(i32 noundef [[TMP31]])
// IR-NESTED-NEXT:    [[ADD37:%.*]] = add nsw i32 [[MUL36]], [[CALL]]
// IR-NESTED-NEXT:    [[TMP32:%.*]] = load i32, ptr [[I11]], align 4
// IR-NESTED-NEXT:    [[IDXPROM38:%.*]] = sext i32 [[TMP32]] to i64
// IR-NESTED-NEXT:    [[ARRAYIDX39:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM38]]
// IR-NESTED-NEXT:    store i32 [[ADD37]], ptr [[ARRAYIDX39]], align 4
// IR-NESTED-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR-NESTED:       omp.body.continue:
// IR-NESTED-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-NESTED:       omp.inner.for.inc:
// IR-NESTED-NEXT:    [[TMP33:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-NESTED-NEXT:    [[ADD40:%.*]] = add nsw i64 [[TMP33]], 1
// IR-NESTED-NEXT:    store i64 [[ADD40]], ptr [[DOTOMP_IV]], align 8
// IR-NESTED-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-NESTED:       omp.inner.for.end:
// IR-NESTED-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-NESTED:       omp.loop.exit:
// IR-NESTED-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-NESTED-NEXT:    [[TMP35:%.*]] = load i32, ptr [[TMP34]], align 4
// IR-NESTED-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP35]])
// IR-NESTED-NEXT:    br label [[OMP_PRECOND_END]]
// IR-NESTED:       omp.precond.end:
// IR-NESTED-NEXT:    ret void
//
//
// IR-PCH-NESTED-LABEL: define {{[^@]+}}@main
// IR-PCH-NESTED-SAME: () #[[ATTR0:[0-9]+]] {
// IR-PCH-NESTED-NEXT:  entry:
// IR-PCH-NESTED-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// IR-PCH-NESTED-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP0:%.*]] = load i32, ptr @N, align 4
// IR-PCH-NESTED-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// IR-PCH-NESTED-NEXT:    [[TMP2:%.*]] = call ptr @llvm.stacksave.p0()
// IR-PCH-NESTED-NEXT:    store ptr [[TMP2]], ptr [[SAVED_STACK]], align 8
// IR-PCH-NESTED-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 16
// IR-PCH-NESTED-NEXT:    store i64 [[TMP1]], ptr [[__VLA_EXPR0]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP3:%.*]] = load i32, ptr @N, align 4
// IR-PCH-NESTED-NEXT:    [[TMP4:%.*]] = zext i32 [[TMP3]] to i64
// IR-PCH-NESTED-NEXT:    [[VLA1:%.*]] = alloca i32, i64 [[TMP4]], align 16
// IR-PCH-NESTED-NEXT:    store i64 [[TMP4]], ptr [[__VLA_EXPR1]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP5:%.*]] = load i32, ptr @N, align 4
// IR-PCH-NESTED-NEXT:    store i32 [[TMP5]], ptr [[N_CASTED]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP6:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-PCH-NESTED-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64(i64 [[TMP6]], i64 [[TMP1]], ptr [[VLA]], i64 [[TMP4]], ptr [[VLA1]]) #[[ATTR3:[0-9]+]]
// IR-PCH-NESTED-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// IR-PCH-NESTED-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP7]])
// IR-PCH-NESTED-NEXT:    [[TMP8:%.*]] = load i32, ptr [[RETVAL]], align 4
// IR-PCH-NESTED-NEXT:    ret i32 [[TMP8]]
//
//
// IR-PCH-NESTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64
// IR-PCH-NESTED-SAME: (i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2:[0-9]+]] {
// IR-PCH-NESTED-NEXT:  entry:
// IR-PCH-NESTED-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NESTED-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NESTED-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NESTED-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NESTED-NEXT:    store i32 [[TMP4]], ptr [[N_CASTED]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP5:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-PCH-NESTED-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3:[0-9]+]], i32 5, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64.omp_outlined, i64 [[TMP5]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-PCH-NESTED-NEXT:    ret void
//
//
// IR-PCH-NESTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64.omp_outlined
// IR-PCH-NESTED-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-PCH-NESTED-NEXT:  entry:
// IR-PCH-NESTED-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NESTED-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NESTED-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NESTED-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NESTED-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[I11:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[J12:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NESTED-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NESTED-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NESTED-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NESTED-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// IR-PCH-NESTED-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-PCH-NESTED-NEXT:    [[CONV:%.*]] = sext i32 [[DIV]] to i64
// IR-PCH-NESTED-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NESTED-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP7]], 0
// IR-PCH-NESTED-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// IR-PCH-NESTED-NEXT:    [[CONV8:%.*]] = sext i32 [[DIV7]] to i64
// IR-PCH-NESTED-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV]], [[CONV8]]
// IR-PCH-NESTED-NEXT:    [[SUB9:%.*]] = sub nsw i64 [[MUL]], 1
// IR-PCH-NESTED-NEXT:    store i64 [[SUB9]], ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NESTED-NEXT:    store i32 0, ptr [[I]], align 4
// IR-PCH-NESTED-NEXT:    store i32 0, ptr [[J]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NESTED-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// IR-PCH-NESTED-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-PCH-NESTED:       land.lhs.true:
// IR-PCH-NESTED-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NESTED-NEXT:    [[CMP10:%.*]] = icmp slt i32 0, [[TMP9]]
// IR-PCH-NESTED-NEXT:    br i1 [[CMP10]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END]]
// IR-PCH-NESTED:       omp.precond.then:
// IR-PCH-NESTED-NEXT:    store i64 0, ptr [[DOTOMP_COMB_LB]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[TMP10]], ptr [[DOTOMP_COMB_UB]], align 8
// IR-PCH-NESTED-NEXT:    store i64 1, ptr [[DOTOMP_STRIDE]], align 8
// IR-PCH-NESTED-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP12:%.*]] = load i32, ptr [[TMP11]], align 4
// IR-PCH-NESTED-NEXT:    call void @__kmpc_for_static_init_8(ptr @[[GLOB1:[0-9]+]], i32 [[TMP12]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i64 1, i64 1)
// IR-PCH-NESTED-NEXT:    [[TMP13:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP14:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NESTED-NEXT:    [[CMP13:%.*]] = icmp sgt i64 [[TMP13]], [[TMP14]]
// IR-PCH-NESTED-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-PCH-NESTED:       cond.true:
// IR-PCH-NESTED-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NESTED-NEXT:    br label [[COND_END:%.*]]
// IR-PCH-NESTED:       cond.false:
// IR-PCH-NESTED-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-PCH-NESTED-NEXT:    br label [[COND_END]]
// IR-PCH-NESTED:       cond.end:
// IR-PCH-NESTED-NEXT:    [[COND:%.*]] = phi i64 [ [[TMP15]], [[COND_TRUE]] ], [ [[TMP16]], [[COND_FALSE]] ]
// IR-PCH-NESTED-NEXT:    store i64 [[COND]], ptr [[DOTOMP_COMB_UB]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTOMP_COMB_LB]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[TMP17]], ptr [[DOTOMP_IV]], align 8
// IR-PCH-NESTED-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-PCH-NESTED:       omp.inner.for.cond:
// IR-PCH-NESTED-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-PCH-NESTED-NEXT:    [[CMP14:%.*]] = icmp sle i64 [[TMP18]], [[TMP19]]
// IR-PCH-NESTED-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-PCH-NESTED:       omp.inner.for.body:
// IR-PCH-NESTED-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_COMB_LB]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_COMB_UB]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP22:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NESTED-NEXT:    store i32 [[TMP22]], ptr [[N_CASTED]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP23:%.*]] = load i64, ptr [[N_CASTED]], align 8
// IR-PCH-NESTED-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 7, ptr @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64.omp_outlined.omp_outlined, i64 [[TMP20]], i64 [[TMP21]], i64 [[TMP23]], i64 [[TMP0]], ptr [[TMP1]], i64 [[TMP2]], ptr [[TMP3]])
// IR-PCH-NESTED-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-PCH-NESTED:       omp.inner.for.inc:
// IR-PCH-NESTED-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_STRIDE]], align 8
// IR-PCH-NESTED-NEXT:    [[ADD:%.*]] = add nsw i64 [[TMP24]], [[TMP25]]
// IR-PCH-NESTED-NEXT:    store i64 [[ADD]], ptr [[DOTOMP_IV]], align 8
// IR-PCH-NESTED-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-PCH-NESTED:       omp.inner.for.end:
// IR-PCH-NESTED-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-PCH-NESTED:       omp.loop.exit:
// IR-PCH-NESTED-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP27:%.*]] = load i32, ptr [[TMP26]], align 4
// IR-PCH-NESTED-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP27]])
// IR-PCH-NESTED-NEXT:    br label [[OMP_PRECOND_END]]
// IR-PCH-NESTED:       omp.precond.end:
// IR-PCH-NESTED-NEXT:    ret void
//
//
// IR-PCH-NESTED-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l64.omp_outlined.omp_outlined
// IR-PCH-NESTED-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR2]] {
// IR-PCH-NESTED-NEXT:  entry:
// IR-PCH-NESTED-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NESTED-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NESTED-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NESTED-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// IR-PCH-NESTED-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[I:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[J:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// IR-PCH-NESTED-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[I11:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    [[J12:%.*]] = alloca i32, align 4
// IR-PCH-NESTED-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[N]], ptr [[N_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2]], align 8
// IR-PCH-NESTED-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NESTED-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP5:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NESTED-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NESTED-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// IR-PCH-NESTED-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// IR-PCH-NESTED-NEXT:    [[CONV:%.*]] = sext i32 [[DIV]] to i64
// IR-PCH-NESTED-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NESTED-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP7]], 0
// IR-PCH-NESTED-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// IR-PCH-NESTED-NEXT:    [[CONV8:%.*]] = sext i32 [[DIV7]] to i64
// IR-PCH-NESTED-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV]], [[CONV8]]
// IR-PCH-NESTED-NEXT:    [[SUB9:%.*]] = sub nsw i64 [[MUL]], 1
// IR-PCH-NESTED-NEXT:    store i64 [[SUB9]], ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NESTED-NEXT:    store i32 0, ptr [[I]], align 4
// IR-PCH-NESTED-NEXT:    store i32 0, ptr [[J]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// IR-PCH-NESTED-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// IR-PCH-NESTED-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_PRECOND_END:%.*]]
// IR-PCH-NESTED:       land.lhs.true:
// IR-PCH-NESTED-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NESTED-NEXT:    [[CMP10:%.*]] = icmp slt i32 0, [[TMP9]]
// IR-PCH-NESTED-NEXT:    br i1 [[CMP10]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END]]
// IR-PCH-NESTED:       omp.precond.then:
// IR-PCH-NESTED-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[TMP10]], ptr [[DOTOMP_UB]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP11:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP12:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[TMP11]], ptr [[DOTOMP_LB]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[TMP12]], ptr [[DOTOMP_UB]], align 8
// IR-PCH-NESTED-NEXT:    store i64 1, ptr [[DOTOMP_STRIDE]], align 8
// IR-PCH-NESTED-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP13]], align 4
// IR-PCH-NESTED-NEXT:    call void @__kmpc_for_static_init_8(ptr @[[GLOB2:[0-9]+]], i32 [[TMP14]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i64 1, i64 1)
// IR-PCH-NESTED-NEXT:    [[TMP15:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP16:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NESTED-NEXT:    [[CMP13:%.*]] = icmp sgt i64 [[TMP15]], [[TMP16]]
// IR-PCH-NESTED-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// IR-PCH-NESTED:       cond.true:
// IR-PCH-NESTED-NEXT:    [[TMP17:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_5]], align 8
// IR-PCH-NESTED-NEXT:    br label [[COND_END:%.*]]
// IR-PCH-NESTED:       cond.false:
// IR-PCH-NESTED-NEXT:    [[TMP18:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// IR-PCH-NESTED-NEXT:    br label [[COND_END]]
// IR-PCH-NESTED:       cond.end:
// IR-PCH-NESTED-NEXT:    [[COND:%.*]] = phi i64 [ [[TMP17]], [[COND_TRUE]] ], [ [[TMP18]], [[COND_FALSE]] ]
// IR-PCH-NESTED-NEXT:    store i64 [[COND]], ptr [[DOTOMP_UB]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// IR-PCH-NESTED-NEXT:    store i64 [[TMP19]], ptr [[DOTOMP_IV]], align 8
// IR-PCH-NESTED-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// IR-PCH-NESTED:       omp.inner.for.cond:
// IR-PCH-NESTED-NEXT:    [[TMP20:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// IR-PCH-NESTED-NEXT:    [[CMP14:%.*]] = icmp sle i64 [[TMP20]], [[TMP21]]
// IR-PCH-NESTED-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// IR-PCH-NESTED:       omp.inner.for.body:
// IR-PCH-NESTED-NEXT:    [[TMP22:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NESTED-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP23]], 0
// IR-PCH-NESTED-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// IR-PCH-NESTED-NEXT:    [[MUL17:%.*]] = mul nsw i32 1, [[DIV16]]
// IR-PCH-NESTED-NEXT:    [[CONV18:%.*]] = sext i32 [[MUL17]] to i64
// IR-PCH-NESTED-NEXT:    [[DIV19:%.*]] = sdiv i64 [[TMP22]], [[CONV18]]
// IR-PCH-NESTED-NEXT:    [[MUL20:%.*]] = mul nsw i64 [[DIV19]], 1
// IR-PCH-NESTED-NEXT:    [[ADD:%.*]] = add nsw i64 0, [[MUL20]]
// IR-PCH-NESTED-NEXT:    [[CONV21:%.*]] = trunc i64 [[ADD]] to i32
// IR-PCH-NESTED-NEXT:    store i32 [[CONV21]], ptr [[I11]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP25:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NESTED-NEXT:    [[SUB22:%.*]] = sub nsw i32 [[TMP26]], 0
// IR-PCH-NESTED-NEXT:    [[DIV23:%.*]] = sdiv i32 [[SUB22]], 1
// IR-PCH-NESTED-NEXT:    [[MUL24:%.*]] = mul nsw i32 1, [[DIV23]]
// IR-PCH-NESTED-NEXT:    [[CONV25:%.*]] = sext i32 [[MUL24]] to i64
// IR-PCH-NESTED-NEXT:    [[DIV26:%.*]] = sdiv i64 [[TMP25]], [[CONV25]]
// IR-PCH-NESTED-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// IR-PCH-NESTED-NEXT:    [[SUB27:%.*]] = sub nsw i32 [[TMP27]], 0
// IR-PCH-NESTED-NEXT:    [[DIV28:%.*]] = sdiv i32 [[SUB27]], 1
// IR-PCH-NESTED-NEXT:    [[MUL29:%.*]] = mul nsw i32 1, [[DIV28]]
// IR-PCH-NESTED-NEXT:    [[CONV30:%.*]] = sext i32 [[MUL29]] to i64
// IR-PCH-NESTED-NEXT:    [[MUL31:%.*]] = mul nsw i64 [[DIV26]], [[CONV30]]
// IR-PCH-NESTED-NEXT:    [[SUB32:%.*]] = sub nsw i64 [[TMP24]], [[MUL31]]
// IR-PCH-NESTED-NEXT:    [[MUL33:%.*]] = mul nsw i64 [[SUB32]], 1
// IR-PCH-NESTED-NEXT:    [[ADD34:%.*]] = add nsw i64 0, [[MUL33]]
// IR-PCH-NESTED-NEXT:    [[CONV35:%.*]] = trunc i64 [[ADD34]] to i32
// IR-PCH-NESTED-NEXT:    store i32 [[CONV35]], ptr [[J12]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP28:%.*]] = load i32, ptr [[I11]], align 4
// IR-PCH-NESTED-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP28]] to i64
// IR-PCH-NESTED-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// IR-PCH-NESTED-NEXT:    [[TMP29:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// IR-PCH-NESTED-NEXT:    [[TMP30:%.*]] = load i32, ptr [[N_ADDR]], align 4
// IR-PCH-NESTED-NEXT:    [[MUL36:%.*]] = mul nsw i32 [[TMP29]], [[TMP30]]
// IR-PCH-NESTED-NEXT:    [[TMP31:%.*]] = load i32, ptr [[J12]], align 4
// IR-PCH-NESTED-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z3fooi(i32 noundef [[TMP31]])
// IR-PCH-NESTED-NEXT:    [[ADD37:%.*]] = add nsw i32 [[MUL36]], [[CALL]]
// IR-PCH-NESTED-NEXT:    [[TMP32:%.*]] = load i32, ptr [[I11]], align 4
// IR-PCH-NESTED-NEXT:    [[IDXPROM38:%.*]] = sext i32 [[TMP32]] to i64
// IR-PCH-NESTED-NEXT:    [[ARRAYIDX39:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM38]]
// IR-PCH-NESTED-NEXT:    store i32 [[ADD37]], ptr [[ARRAYIDX39]], align 4
// IR-PCH-NESTED-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// IR-PCH-NESTED:       omp.body.continue:
// IR-PCH-NESTED-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// IR-PCH-NESTED:       omp.inner.for.inc:
// IR-PCH-NESTED-NEXT:    [[TMP33:%.*]] = load i64, ptr [[DOTOMP_IV]], align 8
// IR-PCH-NESTED-NEXT:    [[ADD40:%.*]] = add nsw i64 [[TMP33]], 1
// IR-PCH-NESTED-NEXT:    store i64 [[ADD40]], ptr [[DOTOMP_IV]], align 8
// IR-PCH-NESTED-NEXT:    br label [[OMP_INNER_FOR_COND]]
// IR-PCH-NESTED:       omp.inner.for.end:
// IR-PCH-NESTED-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// IR-PCH-NESTED:       omp.loop.exit:
// IR-PCH-NESTED-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// IR-PCH-NESTED-NEXT:    [[TMP35:%.*]] = load i32, ptr [[TMP34]], align 4
// IR-PCH-NESTED-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB2]], i32 [[TMP35]])
// IR-PCH-NESTED-NEXT:    br label [[OMP_PRECOND_END]]
// IR-PCH-NESTED:       omp.precond.end:
// IR-PCH-NESTED-NEXT:    ret void
//
