# ANTLR HOUSE RULES

*Last updated: Sept 10, 2022*

This brief document describes best practices for us to all get along and for the benefit of the project.  Collaborating on this project poses a number of difficulties:

* different native languages
* different time zones
* lack of common company or other organization as social glue
* we are just github userids without personal connection to most other contributors
* those developers able to contribute to such a complex project typically have a lot of experience and, consequently, strong opinions

Effective communication is difficult under the circumstances and civil discourse is a requirement to keep the project on track.  Over 35 years, in-fighting between contributors has made parrt's job as supreme dictator for life much more difficult.

Rules

1. Assume good intentions of the other party.
2. Try to be welcoming and respectful of differing viewpoints experiences.
2. No personal attacks, meaning ideas can be bad in your comments but not people.  Replace "You are ..." with "Your idea is ...".
3. Control your anger please. No hate speech, racism, sexism, or ethnocentrism. No trolling or insulting. See rule #1.
2. Be tolerant and understanding of non-native English speakers' word choice and phrasing.  This is a huge source of misunderstandings; see rule #1. For example, to a native English speaker "I cannot *approve* this" makes it sound like the writer has control over the readers contribution. Instead, the writer likely meant "I cannot *support* this." See rule #1.
3. Soften word choice to use conditional tenses and helper words. For example, use phrases such as "I'm not sure this is a good idea because ..." or "I wonder if you'd consider this other possibility: ..." etc...

Supreme dictator for life parrt has final say. His decisions will not always be correct nor to your liking, but he has a difficult cost-benefit equation to solve for every bug fix, feature, and PR.

Any text contrary to these house rules will likely be edited and replaced with an admonishment by parrt.

Send concerns to parrt@antlr.org.