## Security

[AMD](https://www.amd.com/) takes the security of our software products and services seriously, which includes all source code repositories managed through our GitHub organizations, which include [ROCm](https://github.com/ROCm/), [AMD SMI](https://github.com/ROCm/amdsmi), and [many others](https://www.amd.com/en/corporate/research/open-source.html).

If you believe you have found a security vulnerability in this (or any AMD-owned) repository, please report it.


## Reporting Security Issues

We appreciate all 3rd-party testing and security research, and would be grateful if you could responsibly disclose your findings. We will make every effort to acknowledge your contributions.

To report a security issue, please use the GitHub Security Advisory
[Report a Vulnerability](https://github.com/ROCm/rocm_bandwidth_test/security/advisories/new) tab.


If you prefer to submit without logging in, contact any of the maintainers or send email to [rbt@amd.com](mailto:rbt@amd.com).

You should receive a response within 24 hours. If for some reason you do not, please follow up via email to ensure we received your original message.
Additional information can be found at [maintainers](./AUTHORS.md).

Please include the requested information listed below (as much as you can provide) to help us better understand the nature and scope of the possible issue:

  * Type of issue (e.g. buffer overflow, null pointer dereference, uninitialized memory access, race conditions, etc.)
  * Full paths of source file(s) related to the issue
  * The location of the affected source code (tag/branch/commit or direct URL)
  * Any special configuration required to reproduce the issue
  * Step-by-step instructions to reproduce the issue
  * Proof-of-concept or exploit code (if/when possible)
  * Impact of the issue, including how an attacker might exploit the issue

This information will help us triage your report more quickly.


## Preferred Languages

We prefer all communications to be in English.

