/*
 * This file defines various constants that can be
 * used in the filter configuration file.
 *
 * Copyright (C) 2003, SuSE Linux AG
 * Written by okir@suse.de
 */

#define _GNU_SOURCE
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <sys/msg.h>
#include <linux/sockios.h>
#include <linux/laus_audit.h>
#include <fcntl.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>

#define SYSLOG_NAMES
#include <syslog.h>

#include "auditd.h"
#include "filter.h"

/* Kernel headers suck */
#define __u16	u_int16_t
#define __u32	u_int32_t
#define __s32	int32_t
#define __u8	u_int8_t
#include <linux/netlink.h>
#include <linux/rtnetlink.h>

struct map {
	const char *	name;
	unsigned long	value;
};

#define str(C)		#C
#define _(C)		{ #C, (C) }

static struct map	constants[] = {
	_(O_ACCMODE),
	_(O_RDONLY),
	_(O_WRONLY),
	_(O_RDWR),
	_(O_CREAT),
	_(O_EXCL),
	_(O_NOCTTY),
	_(O_TRUNC),
	_(O_APPEND),
	_(O_NONBLOCK),
#ifdef O_DIRECT
	_(O_DIRECT),
#endif
	_(O_DIRECTORY),
	_(O_NOFOLLOW),

	_(S_IFMT),
	_(S_IFREG),
	_(S_IFDIR),
	_(S_IFCHR),
	_(S_IFBLK),
	_(S_IFSOCK),
	_(S_IFLNK),

	_(AF_UNSPEC),
	_(AF_UNIX),
	_(AF_LOCAL),
	_(AF_INET),
	_(AF_INET6),
	_(AF_NETLINK),
	_(AF_PACKET),

	_(SOCK_DGRAM),
	_(SOCK_STREAM),
	_(SOCK_SEQPACKET),
	_(SOCK_RAW),

	_(SIOCADDDLCI),
	_(SIOCADDMULTI),
	_(SIOCADDRT),
	_(SIOCBONDCHANGEACTIVE),
	_(SIOCBONDENSLAVE),
	_(SIOCBONDRELEASE),
	_(SIOCBONDSETHWADDR),
	_(SIOCDARP),
	_(SIOCDELDLCI),
	_(SIOCDELMULTI),
	_(SIOCDELRT),
	_(SIOCDIFADDR),
	_(SIOCDRARP),
	_(SIOCETHTOOL),
	_(SIOCGIFBR),
	_(SIOCSARP),
	_(SIOCSIFADDR),
	_(SIOCSIFBR),
	_(SIOCSIFBRDADDR),
	_(SIOCSIFDSTADDR),
	_(SIOCSIFENCAP),
	_(SIOCSIFFLAGS),
	_(SIOCSIFHWADDR),
	_(SIOCSIFHWBROADCAST),
	_(SIOCSIFLINK),
	_(SIOCSIFMAP),
	_(SIOCSIFMEM),
	_(SIOCSIFMETRIC),
	_(SIOCSIFMTU),
	_(SIOCSIFNAME),
	_(SIOCSIFNETMASK),
	_(SIOCSIFPFLAGS),
	_(SIOCSIFSLAVE),
	_(SIOCSIFTXQLEN),
	_(SIOCSMIIREG),

	{ "__WSIGMASK",		0x7F },
	{ "__WSIGILL",		SIGILL },
	{ "__WSIGABRT", 	SIGABRT },
	{ "__WSIGSEGV", 	SIGSEGV },
	{ "__WSIGSTKFLT", 	SIGSTKFLT },

	_(IPC_CREAT),
	_(IPC_EXCL),
	_(IPC_NOWAIT),
	_(IPC_RMID),
	_(IPC_SET),
	_(IPC_STAT),
#ifdef __USE_GNU
	_(IPC_INFO),
#endif
	_(IPC_PRIVATE),

	_(AUIOCATTACH),
	_(AUIOCDETACH),
	_(AUIOCSUSPEND),
	_(AUIOCRESUME),
	_(AUIOCCLRPOLICY),
	_(AUIOCSETPOLICY),
	_(AUIOCIAMAUDITD),
	_(AUIOCSETAUDITID),
	_(AUIOCLOGIN),
	_(AUIOCUSERMESSAGE),
	_(AUIOCCLRFILTER),
	_(AUIOCSETFILTER),

	_(NETLINK_ROUTE),
	_(NETLINK_SKIP),
	_(NETLINK_USERSOCK),
	_(NETLINK_FIREWALL),
	_(NETLINK_TCPDIAG),
	_(NETLINK_NFLOG),
	_(NETLINK_ARPD),
	_(NETLINK_ROUTE6),
	_(NETLINK_IP6_FW),
	_(NETLINK_DNRTMSG),
	_(NETLINK_TAPBASE),

	_(NLM_F_REQUEST),
	_(NLM_F_MULTI),
	_(NLM_F_ACK),
	_(NLM_F_ECHO),
	_(NLM_F_ROOT),
	_(NLM_F_MATCH),
	_(NLM_F_ATOMIC),
	_(NLM_F_DUMP),
	_(NLM_F_REPLACE),
	_(NLM_F_EXCL),
	_(NLM_F_CREATE),
	_(NLM_F_APPEND),

	_(RTM_BASE),
	_(RTM_NEWLINK),
	_(RTM_DELLINK),
	_(RTM_GETLINK),
	_(RTM_NEWADDR),
	_(RTM_DELADDR),
	_(RTM_GETADDR),
	_(RTM_NEWROUTE),
	_(RTM_DELROUTE),
	_(RTM_GETROUTE),
	_(RTM_NEWNEIGH),
	_(RTM_DELNEIGH),
	_(RTM_GETNEIGH),
	_(RTM_NEWRULE),
	_(RTM_DELRULE),
	_(RTM_GETRULE),
	_(RTM_NEWQDISC),
	_(RTM_DELQDISC),
	_(RTM_GETQDISC),
	_(RTM_NEWTCLASS),
	_(RTM_DELTCLASS),
	_(RTM_GETTCLASS),
	_(RTM_NEWTFILTER),
	_(RTM_DELTFILTER),
	_(RTM_GETTFILTER),
	_(RTM_MAX),

	{ NULL, 0 }
};

static int
map_constant(const struct map *map, const char *name, unsigned long *value)
{
	if (!name)
		return -1;
	for (; map->name; map++) {
		if (!strcmp(map->name, name)) {
			*value = map->value;
			return 0;
		}
	}
	return -1;
}

int
cf_constant(const char *name, unsigned long *value)
{
	return map_constant(constants, name, value);
}

static int
map_syslog_foo(CODE *map, const char *name)
{
	if (!name)
		return -1;
	for (; map->c_name; map++) {
		if (!strcmp(map->c_name, name))
			break;
	}
	return map->c_val;
}

int
cf_syslog_facility(const char *name)
{
	return map_syslog_foo(facilitynames, name);
}

int
cf_syslog_priority(const char *name)
{
	return map_syslog_foo(prioritynames, name);
}
