/* objreuse-shm.c - shared memory allocated w/ shmget() must be zeroed by 
 * kernel
 *
 * $Id: objreuse-shm.c,v 1.1 2004/06/23 22:48:21 danjones Exp $
 *
 * Purpose: verify that the object reuse mechanism works as documented
 * 	in the case of shared memory returned by the kernel. All shared
 *	memory made available must contain zeroes and not any data that
 *	may exist from previous use.
 *
 * Method: allocate shared memory via the shmget() system call and verify
 *      that the contents are all zero bytes. Check different allocation
 *	 sizes.
 *
 * Expected result: exit code 0 indidates that all tests worked as
 *	expected.
 *
 */

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdarg.h>
#include <asm/page.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/stat.h>

#include "testmacros.h"


void verify_zeroes(char *buf, int size)
{
	int j;

	for (j=0; j<size; j++) {
		DIE_IF(buf[j] != 0);
	}

	return;
}

int main(int argc, char *argv[])
{

  int i;
  int shmid;
  void *shmaddr;
  struct shmid_ds shmdata;

  int increments[]={
	(1 * PAGE_SIZE) - 1, (1 * PAGE_SIZE), (1 * PAGE_SIZE) + 1,
	(2 * PAGE_SIZE) - 1, (2 * PAGE_SIZE), (2 * PAGE_SIZE) + 1,
	(1024 * PAGE_SIZE) - 1, (1024 * PAGE_SIZE), (1024 * PAGE_SIZE) + 1,
	(2048 * PAGE_SIZE) - 1, (2048 * PAGE_SIZE), (2048 * PAGE_SIZE) + 1,
	(4096 * PAGE_SIZE) - 1, (4096 * PAGE_SIZE), (4096 * PAGE_SIZE) + 1,
	(8192 * PAGE_SIZE) - 1, (8192 * PAGE_SIZE),
  };

  for (i=0; i < sizeof(increments)/sizeof(increments[0]); i++) {
    SYSCALL( shmid = shmget(IPC_PRIVATE, increments[i], S_IRUSR) );
    SYSCALL( shmaddr = shmat(shmid, NULL, 0) );
    SYSCALL( shmctl(shmid, IPC_STAT, &shmdata) );
    verify_zeroes((char *)shmaddr, shmdata.shm_segsz);
    SYSCALL(shmdt(shmaddr));
  }

  printf("%s: PASS\n", __FILE__);
  return 0;
}
