#!/bin/sh




function checkall {

echo -e "Checking for needed components"


if [ -e /etc/.product ] ; then 
 	product=`cat /etc/.product` 
 	ex=0
else
	ex=1
fi


echo -e "Checking for needed packages" 

for i in mysql mysql-devel expect; do 
	rpm -q $i > /dev/null 2>1
	if [ $? -eq 0 ] ; then
		ex_rpm[$i]=0
	else
		ex_rpm[$i]=1
	fi
	sum=$(($sum+ex_rpm[$i]))
done

rpm -q $i > /dev/null 2>1
if [ $? -eq 0 ] ; then
	tclsql=0
else
	tclsql=1
fi
sum=$(($sum+$tclsql))

}




function getinfo {

if [ ${ex} -eq 1 ]; then
	echo "Please enter Producttag"
	echo "for /etc/.product:"
	read product;
	echo $product > /etc/.product
else
	echo "Following Producttag has been defined: $product"
	echo "Is this correct ? [y/n]"
	read correct;
	if [ $correct = y ]; then
		echo $product > /etc/.product
	else
	        echo "Please enter Producttag"
        	echo "for /etc/.product:"
		echo "(e.g. suse8-RC4)"
        	read product;
        	echo $product > /etc/.product
	fi
fi




if [ $sum -eq 0 ]; then
	echo "No rpm is missing, skipping install"
else
	echo "$sum rpms are not yet installed, please give me the productpath:"
	echo "(e.g. /mounts/machcd3/CDs/suse80-prof-de-i386-RC4)"
	read productpath
	index="$productpath/INDEX.gz"
	if [ -e $index ]; then
		for i in mysql mysql-devel expect; do
			echo ex von $i ist ${ex_rpm[$i]}
			if [ ${ex_rpm[$i]} -eq 1 ]; then
				path[$i]=`zgrep -e /$i-[0-9].*i386.rpm $index`
				echo installing ${path[$i]}
				cd $productpath
			else
				echo $i is already installed, skipping
			fi
			rpm -ihv ${path[$i]}
		done
	else
		echo -e "$index does not exist\n"
	fi
	if [ $tclsql -eq 1 ]; then
		echo "additional packages are missing, please enter testsuite path:"
		echo "(e.g. /opt/testing/expect)"
		read suitepath
		if [ -e $suitepath ]; then
			echo installing tcl-sql
			rpm -ihv $suitepath/includes/required/tcl-sql-1.0-2suse.i386.rpm
		else
			echo -e "$suitepath does not exist\n"
		fi
	else
		echo bye	
	fi
fi


}

owd=`pwd`
sum=0
checkall
getinfo

if [ -n $suitepath ]; then
	cd $suitepath
else
	cd $owd
fi
