#!/bin/sh
# \
exec expect "$0" ${1+"$@"}
######################################################################
##   Copyright (C) International Business Machines  Corp., 2003
##
##   This program is free software;  you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation; either version 2 of the License, or
##   (at your option) any later version.
##
##   This program is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY;  without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
##   the GNU General Public License for more details.
##
##   You should have received a copy of the GNU General Public License
##   along with this program;  if not, write to the Free Software
##   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
##
##
##
##  FILE   : stunnel.sh
##
##  PURPOSE: To test the basic protocol functionality of OpenSSL via
##           a client/server connection over stunnel.
##
##  HISTORY:
##    10/03 Originated by Michael A. Halcrow <mike@halcrow.us>
##
######################################################################

if {[catch {set LTPROOT $env(LTPROOT)}]} {
    send_user "LTP root path not set.  Set in environment variable LTPROOT.  Defaulting to `.'.\n"
    set LTPROOT .
}

spawn killall -q stunnel
sleep 1
exec stunnel3_wrapper -c -d 42421 -r 42422 -p /etc/ssl/certs/stunnel_client_dsa.pem
exec stunnel3_wrapper -v 2 -d 42422 -r 42423 -p /etc/ssl/certs/stunnel_server_dsa.pem -A /etc/ssl/certs/stunnel_client_dsa.pem

set timeout 15

spawn ${LTPROOT}/bin/server
sleep 1
spawn ${LTPROOT}/bin/client

expect timeout {
    send_user "Host not responding\n"
    exec killall stunnel
    exit -1
} "Goodbye." {
    exec killall stunnel
    exit 0
}

send_user "Error testing OpenSSL via client/server over stunnel\n"

exec killall stunnel
exit -1
