#!/bin/sh
# \
exec expect "$0" ${1+"$@"}
######################################################################
##   Copyright (C) International Business Machines  Corp., 2003
##
##   This program is free software;  you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation; either version 2 of the License, or
##   (at your option) any later version.
##
##   This program is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY;  without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
##   the GNU General Public License for more details.
##
##   You should have received a copy of the GNU General Public License
##   along with this program;  if not, write to the Free Software
##   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
##
##
##
##  FILE   : setup_accounts.sh
##
##  PURPOSE: To set up test account(s) for the OpenSSL tests.
##          
##          
##
##  HISTORY:
##    10/03 Originated by Michael A. Halcrow <mike@halcrow.us>
##
######################################################################

set timeout 15

spawn userdel -r openssl_eal_test
expect
wait
spawn useradd -m -G trusted openssl_eal_test
expect
wait
spawn passwd openssl_eal_test 
expect timeout {
    send_user "Error waiting for password prompt\n"
    send_user "FAIL\n"
    exit -1
} "ew password: " {
    sleep 1
    send "1qaz2wsx3edc\r"
}

expect timeout {
    send_user "Timeout after first password\n"
    send_user "FAIL\n"
    exit -1
} "password:" {
    sleep 1
    send "1qaz2wsx3edc\r"
}
sleep 1
send_user "\nPASS\n"
exit 0
