/**********************************************************************
**   Copyright (C) International Business Machines Corp., 2003
**
**   This program is free software;  you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY;  without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
**   the GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public License
**   along with this program;  if not, write to the Free Software
**   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
**
**  FILE   : server.c
**
**  PURPOSE: To test the basic functionality of OpenSSL by using
**  stunnel as an intermediary in a brief client/server dialog.
**
**  HISTORY:
**    10/03 Originated by Michael A. Halcrow <mike@halcrow.us>
**
**********************************************************************/

#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>

int main() {
  char* tcp_addr = "127.0.0.1";
  int tcp_port = 42423;
  int tcp_socket;
  struct sockaddr_in tcp_sockaddr;
  struct sockaddr_in tcp_sourceaddr;
  int tcp_sourcelen;
  struct sockaddr_in tcp_remote_addr;
  socklen_t tcp_socklen = sizeof( struct sockaddr );
  int sd;
  char buf[ 100 ];
  char buffer[100];
  if( ( tcp_socket = socket(AF_INET, SOCK_STREAM, 0) ) < 0 ) {
    printf( "Error creating socket\n" );
    return 1;
  }
  memset( &tcp_sockaddr, 0, sizeof( tcp_sockaddr ) );
  tcp_sockaddr.sin_family = AF_INET;
  tcp_sockaddr.sin_port = htons( tcp_port );
  tcp_sockaddr.sin_addr.s_addr = (unsigned long)inet_addr( tcp_addr );
  if( bind( tcp_socket, ( struct sockaddr * )&tcp_sockaddr, sizeof( tcp_sockaddr ) ) < 0 ) {
    printf( "tcp-server error: %s\n", strerror( errno ) );
    return 1;
  }
  memset( buffer, 0, sizeof( buffer ) );
  if( listen( tcp_socket, 5 ) < 0 ) {
    printf( "tcp-server error: %s\n", strerror( errno ) );
    return 1;
  }
  if( ( sd = accept( tcp_socket, (struct sockaddr*)&tcp_remote_addr, &tcp_socklen ) ) < 0 ) {
    printf( "Error accepting connection\n" );
    return 1;
  }
  printf( "Accepted!\n" );
  if( recv( sd, &buf, 100, 0 ) == -1 ) {
    printf( "Error reading from accepted connection on socket: errno = [%i]:[%s]\n", errno, strerror( errno ) );
    return 1;
  }
  if( strncmp( buf, "Hello.", 6 ) == 0 ) {
    printf( "Server: Received Hello; sending Goodbye.\n" );
    strcpy(buffer, "Goodbye.");
  } else {
    strcpy( buffer, "Get lost." );
  }
  if( send( sd, &buffer, strlen( buffer ), 0 ) == -1 ) {
    printf( "Error writing data to socket connection\n" );
    return 1;
  }
  close( tcp_socket );
  return 0;
}

