#!/bin/sh
# \
exec expect "$0" ${1+"$@"}
######################################################################
##   Copyright (C) International Business Machines  Corp., 2003
##
##   This program is free software;  you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation; either version 2 of the License, or
##   (at your option) any later version.
##
##   This program is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY;  without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
##   the GNU General Public License for more details.
##
##   You should have received a copy of the GNU General Public License
##   along with this program;  if not, write to the Free Software
##   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
##
##
##
##  FILE   : send_new_dsa_key.sh
##
##  PURPOSE: To test the basic protocol functionality of OpenSSL with
##           DSA public/private keypair authentication.  This expect
##           script uploads the DSA public key to the reference
##           machine for future use in a key-authenticated login.
##
##  HISTORY:
##    06/03 Originated by Michael A. Halcrow <mhalcrow@cs.byu.edu>
##
######################################################################

set timeout 15

if {[catch {set reference_platform_url $env(REFERENCE_PLATFORM_HOST)}]} {
    send_user "Reference platform HOST not set.  Set in environment variable REFERENCE_PLATFORM_HOST.  Defaulting to localhost.\n"
    set reference_platform_url localhost
}

if {[catch {set username $env(REFERENCE_PLATFORM_USERNAME)}]} {
    send_user "Reference platform username not set.  Set in environment variable REFERENCE_PLATFORM_USERNAME.  Defaulting to openssl_eal_test.\n"
    set username openssl_eal_test
}

if {[catch {set password $env(REFERENCE_PLATFORM_PASSWORD)}]} {
    send_user "Reference platform password not set.  Set in environment variable REFERENCE_PLATFORM_PASSWORD.  Defaulting to ``1qaz2wsx3edc''.\n"
	set password 1qaz2wsx3edc
}

if {[catch {set reference_platform_success_string $env(REFERENCE_PLATFORM_SUCCESS_STRING)}]} {
    send_user "Reference platform login success string not set.  Set in environment variable REFERENCE_PLATFORM_SUCCESS_STRING.  Defaulting to ``>''.\n"
    set reference_platform_success_string ">"
}

send_user "Sending public key to server...\n"

spawn ssh -l $username $reference_platform_url
expect timeout {
    send_user "Error connecting to reference host\n"
    send_user "FAIL\n"
    exit -1
} "password:" {
    send "$password\r"
}

expect timeout {
    send_user "Timeout after sending password\n"
    send_user "FAIL\n"
    exit -1
} $reference_platform_success_string {
    send "mkdir .ssh\r"
    expect timeout {
	send_user "Timeout after mkdir\n"
	exit -1
    } $reference_platform_success_string {
	send "exit\r"
	expect timeout {
	    send_user "Timeout after exit\n"
	    exit -1
	}
	spawn scp id_dsa.pub $username@$reference_platform_url:.ssh/authorized_keys
	expect timeout {
	    send_user "Error connecting to reference host\n"
	    exit -1
	} "password" {
	    send "$password\r"
	}
	expect "100%" # Time left for transfer	    
	send_user "\nSuccess\n"
	exit 0
    }
    exit -1
} "Permission denied" {
    send_user "Bad password.  Set in REFERENCE_PLATFORM_PASSWORD environment variable and try again.\n"
    send_user "FAIL\n"
    exit -1
}

send_user "FAIL\n"
exit -1
