#!/bin/sh
######################################################################
##   Copyright (C) International Business Machines  Corp., 2003
##
##   This program is free software;  you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation; either version 2 of the License, or
##   (at your option) any later version.
##
##   This program is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY;  without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
##   the GNU General Public License for more details.
##
##   You should have received a copy of the GNU General Public License
##   along with this program;  if not, write to the Free Software
##   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
##
##
##
##  FILE   : rsa_auth.sh
##
##  PURPOSE: To test the basic protocol functionality of OpenSSL with
##           RSA public/private keypair authentication.
##
##  HISTORY:
##    06/03 Originated by Michael A. Halcrow <mhalcrow@cs.byu.edu>
##
######################################################################

# Create public/private RSA keypair

rm -f id_rsa id_rsa.pub

ssh-keygen -b 1024 -t rsa -f id_rsa -C "LTP Test Keypair"  -P ""

# Copy the public key to the reference platform

${LTPROOT}/bin/send_new_rsa_key.sh
RESULT=$?

if [ $RESULT = 0 ] ; then
    # Try to log in!
    ${LTPROOT}/bin/rsa_login.sh
    exit $?
else
    echo "Error sending key"
    echo ${RESULT}
    exit -1
fi

