#!/bin/sh
# \
exec expect "$0" ${1+"$@"}
######################################################################
##   Copyright (C) International Business Machines  Corp., 2003
##
##   This program is free software;  you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation; either version 2 of the License, or
##   (at your option) any later version.
##
##   This program is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY;  without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
##   the GNU General Public License for more details.
##
##   You should have received a copy of the GNU General Public License
##   along with this program;  if not, write to the Free Software
##   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
##
##
##
##  FILE   : password_auth.sh
##
##  PURPOSE: To test the basic protocol functionality of OpenSSL with
##           password authentication
##          
##
##  HISTORY:
##    06/03 Originated by Michael A. Halcrow <mhalcrow@cs.byu.edu>
##
######################################################################

set timeout 15

if {[catch {set reference_platform_url $env(REFERENCE_PLATFORM_HOST)}]} {
    send_user "Reference platform HOST not set.  Set in environment variable REFERENCE_PLATFORM_HOST.  Defaulting to localhost.\n"
    set reference_platform_url localhost
}

if {[catch {set username $env(REFERENCE_PLATFORM_USERNAME)}]} {
    send_user "Reference platform username not set.  Set in environment variable REFERENCE_PLATFORM_USERNAME.  Defaulting to openssl_eal_test.\n"
    set username openssl_eal_test
}

if {[catch {set password $env(REFERENCE_PLATFORM_PASSWORD)}]} {
    send_user "Reference platform password not set.  Set in environment variable REFERENCE_PLATFORM_PASSWORD.  Defaulting to ``1qaz2wsx3edc''.\n"
	set password 1qaz2wsx3edc
}

if {[catch {set reference_platform_success_string $env(REFERENCE_PLATFORM_SUCCESS_STRING)}]} {
    send_user "Reference platform login success string not set.  Set in environment variable REFERENCE_PLATFORM_SUCCESS_STRING.  Defaulting to ``>''.\n"
    set reference_platform_success_string ">"
}

send_user "Testing standard OpenSSH password-authenticated login\n"

spawn ssh -l $username $reference_platform_url
expect timeout {
    send_user "Error connecting to reference host\n"
    send_user "FAIL\n"
    exit -1
} "assword:" {
    send "$password\r"
} "continue connecting (yes/no)?" {
    send "yes\r"
    expect timeout {
	send_user "Error communicating with reference host\n"
	send_user "FAIL\n"
	exit -1
    } "password:" {
	send "$password\r"
    }    
}

expect timeout {
    send_user "Timeout after sending password\n"
    send_user "FAIL\n"
    exit -1
} $reference_platform_success_string {
    send_user "\nPASS\n"
    exit 0
} "Permission denied" {
    send_user "Bad password.  Set in REFERENCE_PLATFORM_PASSWORD environment variable and try again.\n"
    send_user "FAIL\n"
    exit -1
}

send_user "FAIL\n"
exit -1

