/**********************************************************************
**   Copyright (C) International Business Machines Corp., 2003
**
**   This program is free software;  you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY;  without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
**   the GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public License
**   along with this program;  if not, write to the Free Software
**   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
**
**  FILE   : client.c
**
**  PURPOSE: To test the basic functionality of OpenSSL by using
**  stunnel as an intermediary in a brief client/server dialog.
**
**  HISTORY:
**    10/03 Originated by Michael A. Halcrow <mike@halcrow.us>
**
**********************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netdb.h>
#include <errno.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <string.h>

#define DESTINATION_PORT 42421
#define DESTINATION_ADDR "127.0.0.1"

int main() {
  char buf[ 100 ];
  int sd;
  int sockfd;
  struct sockaddr_in dest_addr;
  if( ( sockfd = socket( AF_INET, SOCK_STREAM, 0 ) ) < 0 ) {
    printf( "Error creating socket\n" );
    return 1;
  }
  dest_addr.sin_family = AF_INET;
  dest_addr.sin_port = htons( DESTINATION_PORT );
  dest_addr.sin_addr.s_addr = inet_addr( DESTINATION_ADDR );
  memset( &dest_addr.sin_zero, 0, sizeof( dest_addr.sin_zero ) );
  if( ( sd = connect( sockfd, (struct sockaddr *)&dest_addr, sizeof( struct sockaddr ) ) ) == -1 ) {
    printf( "Error connecting\n" );
    return 1;
  }
  strcpy( buf, "Hello." );
  if( send( sockfd, buf, strlen( buf ), 0 ) == -1 ) {
    printf( "Error writing to server: errno = [%d]\n", errno );
    return 1;
  }
  memset( buf, 0, sizeof( buf ) );
  if( recv( sockfd, buf, 80, 0 ) < 0 ) {
    printf( "Error receiving from server: errno = [%d]\n", errno );
    return 1;
  }
  printf( "%s\n", buf );
  if( strncmp( buf, "Goodbye.", 8 ) == 0 ) {
    return 0;
  } else {
    printf( "Problem communicating with the server.\n" );
    return 1;
  }
}
