#!/bin/sh

# OpenSSL test installation script

# We must be root
if [ `whoami` = "root" ];
then
    echo "I am root.  This is good."
else
    echo "I am not root.  Make me root!!"
    exit 1
fi

# Step 1: Verify that packages are installed

echo

for exe in "ssh" "perl" "expect" "stunnel"
do
  if [ `which $exe` ]
      then
      echo "Found \`\`$exe''"
  else
      echo "\`\`$exe'' executable not in path; maybe it needs to be installed?"
      exit 1
  fi
done

# Step 2: Warn user that this could all seriously mess up his system :-).  If he doesn't trust me, then instruct him to follow the written instructions in README.

if [ "$1" != "-a" ]
then
	echo
	echo "This script intends to wreak havoc on your stunnel config files."
	echo "If this machine uses stunnel for anything other for EAL test"
	echo "purposes, you are advised to hit CTRL-C to break out of this"
	echo "script and read README for manual instructions."
	echo 
	echo -n Continue? [yN]

	read -e CONTINUEON
else
	CONTINUEON=y
fi

echo

if [ "$CONTINUEON" == "y" ]
then
    echo "Very well.  Performing modifications to your system..."
else
    echo "Aborting"
    exit 0
fi

# Step 3: Copy over configuration files, overwriting anything that existed there beforehand

echo

echo "Copying stunnel config file"
mkdir -p /etc/stunnel
cp -f install_files/stunnel.conf /etc/stunnel/stunnel.conf
echo "Copying stunnel self-signed certs"
cp -f install_files/stunnel_server_rsa.pem /etc/ssl/certs/stunnel_server_rsa.pem
cp -f install_files/stunnel_server_dsa.pem /etc/ssl/certs/stunnel_server_dsa.pem
cp -f install_files/stunnel_client_rsa.pem /etc/ssl/certs/stunnel_client_rsa.pem
cp -f install_files/stunnel_client_dsa.pem /etc/ssl/certs/stunnel_client_dsa.pem
echo "Adjusting permissions on the certs"
chmod 600 /etc/ssl/certs/stunnel_server_rsa.pem
chmod 600 /etc/ssl/certs/stunnel_server_dsa.pem
chmod 600 /etc/ssl/certs/stunnel_client_rsa.pem
chmod 600 /etc/ssl/certs/stunnel_client_dsa.pem
echo "Making link to hash value of cert"
ln -sf /etc/ssl/certs/stunnel_server_rsa.pem /etc/ssl/certs/`openssl x509 -noout -hash < /etc/ssl/certs/stunnel_server_rsa.pem`.0
ln -sf /etc/ssl/certs/stunnel_server_dsa.pem /etc/ssl/certs/`openssl x509 -noout -hash < /etc/ssl/certs/stunnel_server_dsa.pem`.0
ln -sf /etc/ssl/certs/stunnel_client_rsa.pem /etc/ssl/certs/`openssl x509 -noout -hash < /etc/ssl/certs/stunnel_client_rsa.pem`.0
ln -sf /etc/ssl/certs/stunnel_client_dsa.pem /etc/ssl/certs/`openssl x509 -noout -hash < /etc/ssl/certs/stunnel_client_dsa.pem`.0

echo "Have a lot of fun..."

exit 0
