##########################################################################
#   Copyright (C) International Business Machines  Corp., 2003
#
#   This program is free software;  you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY;  without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
#   the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program;  if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
#
#
#  FILE   : rules.mk
#
#  PURPOSE: This rules file facilitates the compiling, linking and running
#           of the Linux Auditing System test suite.
#
#           Rules are provided for dependency building, compiling, sub
#           directory traversal and running of the tests.
#
#
#  HISTORY:
#    08/03 originated by Tom Lendacky (toml@us.ibm.com)
#
##########################################################################

MACHINE		:= $(strip $(shell uname -m))
X		:= i486 i586 i686 ix86
P		:= ppc powerpc
IP		:= ppc64 powerpc64
Z		:= s390
Z64		:= s390x
X86_64		:= x86_64
FLAGS           := -g -O2 -Wall

WARN_DEPS       :=

DEPS		:=  binutils \
		    cpp \
                    expect \
                    flex \
                    gcc \
                    gcc-c++ \
                    glibc-devel \
                    kernel-source \
                    laus-devel \
                    libattr-devel \
                    libstdc++-devel \
                    make \
		    perl-Expect \
		    perl-IO-Tty \
		    perl-IO-Stty\
                    tcl
PPC64_DEPS	:=  gcc-64bit 
LTP_TEST_USERS :=     acltest1 \
                      bnd_usr1 \
                      c01_user \
                      c02_user \
                      ca_user1 \
                      ca_user2 \
                      cd_user1 \
                      cd_user2 \
                      crontab_test \
                      dev_usr1 \
                      dir_usr1 \
                      fil_usr1 \
                      fl_user \
                      ftp_user \
                      ftpuser1 \
                      ftpuser2 \
                      ll_user \
                      msq_usr1 \
                      msq_usr2 \
                      np_usr1 \
                      prc_usr1 \
                      sem_usr1 \
                      sem_usr2 \
                      shm_usr1 \
                      shm_usr2 \
                      ssh_usr1 \
                      ssh_usr2 \
                      ssh_usr3 \
                      su_usr1 \
                      su_usr2 \
                      test_user_1 \
                      test_user_2 \
                      uds_usr1 \
		      crontab_test
			

ifneq (,$(findstring $(MACHINE),$(X)))
	ARCH := -D__IX86
else
	ifneq (,$(findstring $(MACHINE),$(P)))
		ARCH := -D__PPC32 -D__PPC
	else
		ifneq (,$(findstring $(MACHINE),$(IP)))
			ARCH := -D__PPC64 -D__PPC
			DEPS := $(DEPS) $(PPC64_DEPS)
		else
			ifneq (,$(findstring $(MACHINE),$(Z)))
				ARCH := -D__S390
			else
				ifneq (,$(findstring $(MACHINE), $(Z64)))
					ARCH := -D__S390X
				else
					ifneq (,$(findstring $(MACHINE), $(X86_64)))
						ARCH := -D__X86_64
					endif
				endif
			endif
		endif
	endif
endif
ifeq ($(MODE), 32)
	ifneq (,$(findstring $(MACHINE), $(Z64)))
		ARCH += -m31 -D__MODE_32
		export LDFLAGS = -m31
	else 
		ifneq (,$(findstring $(MACHINE), $(X86_64)))
			ARCH += -m32 -D__MODE_32 -malign-double
			export LDFLAGS = -m32
		else
			ARCH += -m32 -D__MODE_32
			export LDFLAGS = -m32
		endif
	endif
else
	ifeq (,$(findstring $(MACHINE),$(X)))
		ARCH += -m64 -D__MODE_64
		export LIB_DIR = /lib64
		export LDFLAGS = -m64
	endif
endif


.PHONY: all clean deps depsdir subdirs $(SUB_DIRS) test run

#
# Dependency rules
#
DEP_FILES	= $(addprefix .deps/, $(ALL_OBJS:.o=.d))

deps::  headers depsdir $(DEP_FILES)

depsdir::
	@mkdir -p .deps


ifeq ($(findstring clean,$(MAKECMDGOALS)),)
# Include dependencies if goals do not include 'clean'
.deps/%.d: %.c
	@echo Creating dependencies for $<
	@$(SHELL) -ec '$(CC) $(FLAGS) $(CFLAGS) $(INCLUDES) -MM $< \
		| sed '\''s@\($*\)\.o[ :]*@\1.o $@: @g'\'' > $@; \
		[ -s $@ ] || $(RM) $@'

-include .deps/*.d
else
# Insure that clean is the only goal if specified
ifneq ($(words $(MAKECMDGOALS)), 1)
$(error The 'clean' goal must be the only goal specified)
endif
endif

#
# Sub-directory processing rules
#
subdirs: $(SUB_DIRS)

$(SUB_DIRS):
	$(MAKE) $(COMPILER) -C $@ $(MAKECMDGOALS)

#
# Command framework execution rules
#

cleanup::
	-if [ -n "`pwd | grep ltp_EAL`" -o -n "`ls | grep ltp_EAL`" ]; then rm -rf $(LTP_TEST_USERS); fi
	-if [ -n "`pwd | grep ltp_EAL`" -o -n "`ls | grep ltp_EAL`" ]; then echo $(LTP_TEST_USERS) | xargs -i userdel -r {}; fi

verifydeps::
	# MODE must be defined to either MODE=32 or MODE=64
	-rpm -q $(WARN_DEPS)
	rpm -q $(DEPS)
