#! /usr/bin/awk -f

BEGIN {

    print "// EAK (Easy Access, Internet, Multimedia, PDA) keyboards";
    print "// Created by Stanislav Brabec <sbrabec@suse.cz>";
    print "// Based on LinEAK project";
    print "// fix manually Media, Close, Stop etc. - can be Audio or non-audio";
    print "// fix manually Standby/Sleep, Power/PowerOff/WakeUp/Resume";
    print "// one key has undefined code (?101), few has redundant codes (<BRK>, <RCTL> etc.)";
    print "";


# $Xorg: xfree86,v 1.3 2000/08/17 19:54:37 cpqbld Exp $




# $XFree86: xc/programs/xkbcomp/keycodes/xfree86,v 3.17 2001/11/30 12:12:04 eich Exp $

# "standard" XFree86 codes
# It seems that the "default" must be the first entry in the file.

#default xkb_keycodes "xfree86" {
#    include "xfree86(basic)"
    codes[51] =  "<BKSL>";
    codes[94] =  "<LSGT>";
#};

#xkb_keycodes "basic" {

#    minimum= 8;
#    maximum= 255;

    codes[49] =  "<TLDE>";
    codes[10] =  "<AE01>";
    codes[11] =  "<AE02>";
    codes[12] =  "<AE03>";
    codes[13] =  "<AE04>";
    codes[14] =  "<AE05>";
    codes[15] =  "<AE06>";
    codes[16] =  "<AE07>";
    codes[17] =  "<AE08>";
    codes[18] =  "<AE09>";
    codes[19] =  "<AE10>";
    codes[20] =  "<AE11>";
    codes[21] =  "<AE12>";
    codes[22] =  "<BKSP>";

    codes[23]  =  "<TAB>";
    codes[24] =  "<AD01>";
    codes[25] =  "<AD02>";
    codes[26] =  "<AD03>";
    codes[27] =  "<AD04>";
    codes[28] =  "<AD05>";
    codes[29] =  "<AD06>";
    codes[30] =  "<AD07>";
    codes[31] =  "<AD08>";
    codes[32] =  "<AD09>";
    codes[33] =  "<AD10>";
    codes[34] =  "<AD11>";
    codes[35] =  "<AD12>";
    codes[36] =  "<RTRN>";

    codes[66] =  "<CAPS>";
    codes[38] =  "<AC01>";
    codes[39] =  "<AC02>";
    codes[40] =  "<AC03>";
    codes[41] =  "<AC04>";
    codes[42] =  "<AC05>";
    codes[43] =  "<AC06>";
    codes[44] =  "<AC07>";
    codes[45] =  "<AC08>";
    codes[46] =  "<AC09>";
    codes[47] =  "<AC10>";
    codes[48] =  "<AC11>";

    codes[50] =  "<LFSH>";
    codes[52] =  "<AB01>";
    codes[53] =  "<AB02>";
    codes[54] =  "<AB03>";
    codes[55] =  "<AB04>";
    codes[56] =  "<AB05>";
    codes[57] =  "<AB06>";
    codes[58] =  "<AB07>";
    codes[59] =  "<AB08>";
    codes[60] =  "<AB09>";
    codes[61] =  "<AB10>";
    codes[62] =  "<RTSH>";

    codes[64] =  "<LALT>";
    codes[37] =  "<LCTL>";
    codes[65] =  "<SPCE>";
    codes[109] = "<RCTL>";
    codes[113] = "<RALT>";
    # Microsoft keyboard extra keys
    codes[115] = "<LWIN>";
    codes[116] = "<RWIN>";
    codes[117] = "<MENU>";

    codes[9]  =   "<ESC>";
    codes[67] =  "<FK01>";
    codes[68] =  "<FK02>";
    codes[69] =  "<FK03>";
    codes[70] =  "<FK04>";
    codes[71] =  "<FK05>";
    codes[72] =  "<FK06>";
    codes[73] =  "<FK07>";
    codes[74] =  "<FK08>";
    codes[75] =  "<FK09>";
    codes[76] =  "<FK10>";
    codes[95] =  "<FK11>";
    codes[96] =  "<FK12>";

    codes[111] = "<PRSC>";
    codes[92] =  "<SYRQ>";
    codes[78] =  "<SCLK>";
    codes[110] = "<PAUS>";
    codes[114]  = "<BRK>";

    codes[106]  = "<INS>";
    codes[97] =  "<HOME>";
    codes[99] =  "<PGUP>";
    codes[107] = "<DELE>";
    codes[103]  = "<END>";
    codes[105] = "<PGDN>";

    codes[98]   =  "<UP>";
    codes[100] = "<LEFT>";
    codes[104] = "<DOWN>";
    codes[102] = "<RGHT>";

    codes[77] =  "<NMLK>";
    codes[112] = "<KPDV>";
    codes[63] =  "<KPMU>";
    codes[82] =  "<KPSU>";

    codes[79]  =  "<KP7>";
    codes[80]  =  "<KP8>";
    codes[81]  =  "<KP9>";
    codes[86] =  "<KPAD>";

    codes[83]  =  "<KP4>";
    codes[84]  =  "<KP5>";
    codes[85]  =  "<KP6>";

    codes[87]  =  "<KP1>";
    codes[88]  =  "<KP2>";
    codes[89]  =  "<KP3>";
    codes[108] = "<KPEN>";

    codes[90]  =  "<KP0>";
    codes[91] =  "<KPDL>";

    codes[118] =  "<FK13>";
    codes[119] =  "<FK14>";
    codes[120] =  "<FK15>";
    codes[121] =  "<FK16>";
    codes[122] =  "<FK17>";
    codes[123] =  "<KPDC>";

    # Keys that are generated on Japanese keyboards

#    alias <HZTG> = <TLDE>;	# Hankaku_Zenkaku toggle
#    alias <HKTG> = <FK15>;	# Hiragana_Katakana toggle
#    alias <AB11> = <KPDC>;	# backslash/underscore
    codes[129] =   "<XFER>";		# Henkan
    codes[131] =   "<NFER>";		# Muhenkan
    codes[133] =   "<AE13>";		# Yen

    # Keys that are generated on Japanese and Brazillian keyboards
#    alias <AC12> = <BKSL>;

    # Extended keys that may be generated on "Internet" keyboards.
    # These are not standardised, hence the meaningless names.
    # The entries commented out are never generated because the raw codes
    # in those positions are already used for well-defined keys.

#    alias <XFER> = <I01>;
    codes[130] =   "<I02>";
#    alias <NFER> = <I03>;
    codes[132] =   "<I04>";
#    alias <AE13> = <I05>;
    codes[134] =   "<I06>";
    codes[135] =   "<I07>";
    codes[136] =   "<I08>";
    codes[137] =   "<I09>";
    codes[138] =   "<I0A>";
    codes[139] =   "<I0B>";
    codes[140] =   "<I0C>";
    codes[141] =   "<I0D>";
    codes[142] =   "<I0E>";
    codes[143] =   "<I0F>";
    codes[144] =   "<I10>";
    codes[145] =   "<I11>";
    codes[146] =   "<I12>";
    codes[147] =   "<I13>";
    codes[148] =   "<I14>";
    codes[149] =   "<I15>";
    codes[150] =   "<I16>";
    codes[151] =   "<I17>";
    codes[152] =   "<I18>";
    codes[153] =   "<I19>";
    codes[154] =   "<I1A>";
    codes[155] =   "<I1B>";
    # codes[156] =   "<I1C>";
    # codes[157] =   "<I1D>";
    codes[158] =   "<I1E>";
    codes[159] =   "<I1F>";
    codes[160] =   "<I20>";
    codes[161] =   "<I21>";
    codes[162] =   "<I22>";
    codes[163] =   "<I23>";
    codes[164] =   "<I24>";
    codes[165] =   "<I25>";
    codes[166] =   "<I26>";
    codes[167] =   "<I27>";
    codes[168] =   "<I28>";
    codes[169] =   "<I29>";
    # codes[170] =   "<I2A>";
    codes[171] =   "<I2B>";
    codes[172] =   "<I2C>";
    codes[173] =   "<I2D>";
    codes[174] =   "<I2E>";
    codes[175] =   "<I2F>";
    codes[176] =   "<I30>";
    codes[177] =   "<I31>";
    codes[178] =   "<I32>";
    codes[179] =   "<I33>";
    codes[180] =   "<I34>";
    # codes[181] =   "<I35>";
    # codes[182] =   "<I36>";
    # codes[183] =   "<I37>";
    # codes[184] =   "<I38>";
    codes[185] =   "<I39>";
    codes[186] =   "<I3A>";
    codes[187] =   "<I3B>";
    codes[188] =   "<I3C>";
    # codes[189] =   "<I3D>";
    # codes[190] =   "<I3E>";
    # codes[191] =   "<I3F>";
    # codes[192] =   "<I40>";
    # codes[193] =   "<I41>";
    codes[194] =   "<I42>";
    codes[195] =   "<I43>";
    codes[196] =   "<I44>";
    codes[197] =   "<I45>";
    # codes[198] =   "<I46>";
    # codes[199] =   "<I47>";
    # codes[200] =   "<I48>";
    # codes[201] =   "<I49>";
    codes[202] =   "<I4A>";
    # codes[203] =   "<I4B>";
    # codes[204] =   "<I4C>";
    # codes[205] =   "<I4D>";
    # codes[206] =   "<I4E>";
    # codes[207] =   "<I4F>";
    # codes[208] =   "<I50>";
    # codes[209] =   "<I51>";
    # codes[210] =   "<I52>";
    # codes[211] =   "<I53>";
    codes[212] =   "<I54>";
    codes[213] =   "<I55>";
    codes[214] =   "<I56>";
    codes[215] =   "<I57>";
    codes[216] =   "<I58>";
    codes[217] =   "<I59>";
    codes[218] =   "<I5A>";
    # codes[219] =   "<I5B>";
    # codes[220] =   "<I5C>";
    # codes[221] =   "<I5D>";
    codes[222] =   "<I5E>";
    codes[223] =   "<I5F>";
    codes[224] =   "<I60>";
    codes[225] =   "<I61>";
    codes[226] =   "<I62>";
    codes[227] =   "<I63>";
    codes[228] =   "<I64>";
    codes[229] =   "<I65>";
    codes[230] =   "<I66>";
    codes[231] =   "<I67>";
    codes[232] =   "<I68>";
    codes[233] =   "<I69>";
    codes[234] =   "<I6A>";
    codes[235] =   "<I6B>";
    codes[236] =   "<I6C>";
    codes[237] =   "<I6D>";
    codes[238] =   "<I6E>";
    codes[239] =   "<I6F>";
    codes[240] =   "<I70>";
    codes[241] =   "<I71>";
    codes[242] =   "<I72>";
    codes[243] =   "<I73>";
    codes[244] =   "<I74>";
    codes[245] =   "<I75>";
    codes[246] =   "<I76>";
    codes[247] =   "<I77>";
    codes[248] =   "<I78>";
    codes[249] =   "<I79>";
    codes[250] =   "<I7A>";
    codes[251] =   "<I7B>";
    codes[252] =   "<I7C>";
    codes[253] =   "<I7D>";
    codes[254] =   "<I7E>";
    codes[255] =   "<I7F>";

    # Other codes never generated.  The XFree86 ddx never generates
    # these codes.

    # codes[93] =    "<U5D>";
    # codes[124] =   "<U7C>";
    # codes[125] =   "<U7D>";
    # codes[126] =   "<U7E>";
    # codes[127] =   "<U7F>";
    # codes[128] =   "<U80>";

#    indicator 1 = "Caps Lock";
#    indicator 2 = "Num Lock";
#    indicator 3 = "Scroll Lock";

#    alias <ALGR> = <RALT>;
#};

# What keyboard is this?

#xkb_keycodes "102" {
#    include "xfree86(xfree86)"

    # There will be warnings from xkbcomp because of multiple definitions.

    codes[122] = "<RALT>";
    codes[123] = "<RCTL>";

    codes[121] = "<PRSC>";
    codes[118] = "<PAUS>";

    codes[131]  = "<INS>";
    codes[135] = "<HOME>";
    codes[119] = "<PGUP>";
    codes[129] = "<DELE>";
    codes[130]  = "<END>";
    codes[134] = "<PGDN>";

    codes[128]   = "<UP>";
    codes[132] = "<LEFT>";
    codes[120] = "<DOWN>";
    codes[133] = "<RGHT>";

    codes[125] = "<KPDV>";

    codes[124] = "<KPEN>";
#};


# For japanese 106 keyboard. by tsuka(tsuka@kawalab.dnj.ynu.ac.jp)
#
# All of the keycodes here are now in the basic "xfree86" set.
#
#xkb_keycodes "jp106" {
#    include "xfree86(xfree86)"
#};


# For brazilian ABNT2 keyboard. by Ricardo Y. Igarashi(iga@that.com.br)
#xkb_keycodes "abnt2" {
#    include "xfree86(basic)"
    codes[94] = "<BKSL>";
    codes[51] = "<AC12>";
#};


}


function keycode(code) {
    ret=codes[code];
    if (! ret) { return "<?"code">"; } else { return ret; }
}

function xname(string) {
    gsub ("[Ww]eb(-|/|)",	"",			string);
    string="XF86"toupper(substr(string,1,1)) substr(string,2);
    string=gensub ("(Mute|Play|Stop|Prev|Next|Media)", "Audio\\1", "g", string);
    gsub ("Volumeup",		"AudioRaiseVolume",	string);
    gsub ("Volumedown",		"AudioLowerVolume",	string);
    gsub ("Volume\\+",		"AudioRaiseVolume",	string);
    gsub ("Volume[-_]down",	"AudioLowerVolume",	string);
    gsub ("Volume[-_]up",	"AudioRaiseVolume",	string);
    gsub ("Vol-down",		"AudioLowerVolume",	string);
    gsub ("Vol-up",		"AudioRaiseVolume",	string);
    gsub ("Volume-",		"AudioLowerVolume",	string);
    gsub ("AudioSong",		"Audio",		string);
    gsub ("Song",		"Audio",		string);
    gsub ("AudioPrevious",	"AudioPrev",		string);
    gsub ("Screensaver",	"ScreenSaver",		string);
    gsub ("Www",		"WWW",			string);
    gsub ("Home",		"HomePage",		string);
    gsub ("Vendorhome",		"VendorHome",		string);
    gsub ("Lightbulb",		"LightBulb",		string);
    gsub ("Mycomputer",		"MyComputer",		string);
    gsub ("Myhome",		"HomePage",		string);
    gsub ("E(-|)mail",		"Mail",			string);
    gsub ("Play(-|_|)pause",	"PlayPause",		string);
    gsub ("Fast(-|_|)forward",	"FastForward",		string);
    gsub ("Wake$",		"WakeUp",		string);
    gsub ("Wake-up",		"WakeUp",		string);
    gsub ("Wakeup",		"WakeUp",		string);
    gsub ("Poweroff",		"PowerOff",		string);
    gsub ("Scroll-down",	"ScrollDown",		string);
    gsub ("Scroll-up",		"ScrollUp",		string);
    gsub ("Scrolldown",		"ScrollDown",		string);
    gsub ("Scrollup",		"ScrollUp",		string);
    gsub ("Zoomin",		"ZoomIn",		string);
    gsub ("Zoomout",		"ZoomOut",		string);
    gsub ("XF86Help",		"Help",			string);
    gsub ("Userdefine",		"User",			string);
    gsub ("Free",		"User",			string);
    gsub ("Back/next",		"BackNext",		string);
    gsub ("Applicationleft",	"ApplicationLeft",	string);
    gsub ("Applicationright",	"ApplicationRight",	string);
    gsub ("Officehome",		"OfficeHome",		string);
    gsub ("Taskpane",		"TaskPane",		string);
    gsub ("Mysites",		"MySites",		string);
    gsub ("Wheelbutton",	"WheelButton",		string);
    gsub ("Itouch",		"ITouch",		string);
    gsub ("Scrollclick",	"ScrollClick",		string);
    gsub ("Gobackarrow",	"Back",			string);
    gsub ("Goforward",		"Forward",		string);
    gsub ("Mypages",		"MyPages",		string);
    gsub ("Multimediaprog",	"MultimediaProg",	string);
    gsub ("Stop-eject",		"StopEject",		string);
    gsub ("Splitscreen",	"SplitScreen",		string);
    gsub ("Dos",		"DOS",			string);
    gsub ("CdOpen",		"Eject",		string);
    gsub ("windows",		"Windows",		string);
    gsub ("_track",		"",			string);
    gsub ("shopping",		"Shopping",		string);
    gsub ("_track",		"",			string);
    gsub ("support",		"Support",		string);
    gsub ("button",		"Button",		string);
    gsub ("book",		"Book",			string);
    gsub ("_",			"",			string);
    return string;
}

function filled(string,len,inits) {
    lng=int((length(string)+inits)/8);
    len-=lng;
    if (len<0) { len=0; }
    str="";
    for (i=0;i<len;i++) { str=str"	"; }
    str=string str;
    return str;
}

/^[ 	]*$/ {
    print "";
    next;
}

/^[ 	]*\[.*KEYS\][ 	]*$/ {
    print "";
    next;
}

/^\[END .*\]$/ {
    print "};";
    next;
}

/^\[.*\]$/ {
    gsub ("[][]", "");
    print "partial alphanumeric_keys";
    print "xkb_symbols \""$0"\" {";
    next;
}

/ *brandname/ {
    gsub ("^[^\"]*\"", "");
    gsub ("\"[^\"]*$", "");
    if ($0=="other") {
	brand="";
    } else {
	brand=$0" ";
    }
    next;
}

/ *modelname/ {
    gsub ("^[^\"]*\"", "");
    gsub ("\"[^\"]*$", "");
    print "    name[Group1]= \""brand $0"\";";
    next;
}

/^[ 	]*[-+/_a-zA-Z0-9][-+/_a-zA-Z0-9]*[ 	]*=[ 	]*[0-9][0-9]*[ 	]*$/ {
    gsub ("^[ 	]*","");
    gsub ("[ 	]*$","");
    key=$0
    gsub ("[ 	]*=[ 	]*[0-9][0-9]*[ 	]*$", "",key);
    code=$0
    gsub ("^[-+/_a-zA-Z0-9][-+/_a-zA-Z0-9]*[ 	]*=[ 	]*", "",code);
    print "    key "keycode(code)"	{	[ "filled(xname(key),3,2)"]	};";
    next;
}

/.*/ {
    gsub ("(# | #)", "");
    print "// "$0;
}
