
#ifndef TRAYNOTIFICATION_H
#define TRAYNOTIFICATION_H

#include <qwidget.h>
#include <kactivelabel.h>

/**
 * A class derived from KActiveLabel so we can handle how
 * links are opened.
 */
class KammuActiveLabel : public KActiveLabel
{
    Q_OBJECT

    public:
        KammuActiveLabel( QWidget *parent = 0, const char* name = 0 );
        KammuActiveLabel( const QString& text, QWidget *parent = 0, const char* name = 0 );

    public slots:
        virtual void openLink( const QString &link );
};



/**
 * A little balloon for notifications
 *
 * @author Malte Starostik <malte@kde.org>
                            * @author Duncan Mac-Vicar Prett <duncan@kde.org>
 */
                                   class TrayNotification : public QWidget
{
    Q_OBJECT

    public:
        TrayNotification(const QString &text, const QString &pic);
//	KopeteBalloon();

        void setAnchor(const QPoint &anchor);

    signals:
        void signalButtonClicked();
        void signalIgnoreButtonClicked();
        void signalBalloonClicked();

    protected:
        virtual void updateMask();

    private:
        QPoint mAnchor;
};

#endif

// vim: set noet ts=4 sts=4 sw=4:

